/*!
 * jQuery JavaScript Library v3.7.1
 * https://jquery.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2023-08-28T13:37Z
 */
( function( global, factory ) {

	"use strict";

	if ( typeof module === "object" && typeof module.exports === "object" ) {

		// For CommonJS and CommonJS-like environments where a proper `window`
		// is present, execute the factory and get jQuery.
		// For environments that do not have a `window` with a `document`
		// (such as Node.js), expose a factory as module.exports.
		// This accentuates the need for the creation of a real `window`.
		// e.g. var jQuery = require("jquery")(window);
		// See ticket trac-14549 for more info.
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
} )( typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
// enough that all such attempts are guarded in a try block.
"use strict";

var arr = [];

var getProto = Object.getPrototypeOf;

var slice = arr.slice;

var flat = arr.flat ? function( array ) {
	return arr.flat.call( array );
} : function( array ) {
	return arr.concat.apply( [], array );
};


var push = arr.push;

var indexOf = arr.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var fnToString = hasOwn.toString;

var ObjectFunctionString = fnToString.call( Object );

var support = {};

var isFunction = function isFunction( obj ) {

		// Support: Chrome <=57, Firefox <=52
		// In some browsers, typeof returns "function" for HTML <object> elements
		// (i.e., `typeof document.createElement( "object" ) === "function"`).
		// We don't want to classify *any* DOM node as a function.
		// Support: QtWeb <=3.8.5, WebKit <=534.34, wkhtmltopdf tool <=0.12.5
		// Plus for old WebKit, typeof returns "function" for HTML collections
		// (e.g., `typeof document.getElementsByTagName("div") === "function"`). (gh-4756)
		return typeof obj === "function" && typeof obj.nodeType !== "number" &&
			typeof obj.item !== "function";
	};


var isWindow = function isWindow( obj ) {
		return obj != null && obj === obj.window;
	};


var document = window.document;



	var preservedScriptAttributes = {
		type: true,
		src: true,
		nonce: true,
		noModule: true
	};

	function DOMEval( code, node, doc ) {
		doc = doc || document;

		var i, val,
			script = doc.createElement( "script" );

		script.text = code;
		if ( node ) {
			for ( i in preservedScriptAttributes ) {

				// Support: Firefox 64+, Edge 18+
				// Some browsers don't support the "nonce" property on scripts.
				// On the other hand, just using `getAttribute` is not enough as
				// the `nonce` attribute is reset to an empty string whenever it
				// becomes browsing-context connected.
				// See https://github.com/whatwg/html/issues/2369
				// See https://html.spec.whatwg.org/#nonce-attributes
				// The `node.getAttribute` check was added for the sake of
				// `jQuery.globalEval` so that it can fake a nonce-containing node
				// via an object.
				val = node[ i ] || node.getAttribute && node.getAttribute( i );
				if ( val ) {
					script.setAttribute( i, val );
				}
			}
		}
		doc.head.appendChild( script ).parentNode.removeChild( script );
	}


function toType( obj ) {
	if ( obj == null ) {
		return obj + "";
	}

	// Support: Android <=2.3 only (functionish RegExp)
	return typeof obj === "object" || typeof obj === "function" ?
		class2type[ toString.call( obj ) ] || "object" :
		typeof obj;
}
/* global Symbol */
// Defining this global in .eslintrc.json would create a danger of using the global
// unguarded in another place, it seems safer to define global only for this module



var version = "3.7.1",

	rhtmlSuffix = /HTML$/i,

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {

		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	};

jQuery.fn = jQuery.prototype = {

	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {

		// Return all the elements in a clean array
		if ( num == null ) {
			return slice.call( this );
		}

		// Return just the one element from the set
		return num < 0 ? this[ num + this.length ] : this[ num ];
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	each: function( callback ) {
		return jQuery.each( this, callback );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map( this, function( elem, i ) {
			return callback.call( elem, i, elem );
		} ) );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	even: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return ( i + 1 ) % 2;
		} ) );
	},

	odd: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return i % 2;
		} ) );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor();
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: arr.sort,
	splice: arr.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[ 0 ] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// Skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !isFunction( target ) ) {
		target = {};
	}

	// Extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {

		// Only deal with non-null/undefined values
		if ( ( options = arguments[ i ] ) != null ) {

			// Extend the base object
			for ( name in options ) {
				copy = options[ name ];

				// Prevent Object.prototype pollution
				// Prevent never-ending loop
				if ( name === "__proto__" || target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
					( copyIsArray = Array.isArray( copy ) ) ) ) {
					src = target[ name ];

					// Ensure proper type for the source value
					if ( copyIsArray && !Array.isArray( src ) ) {
						clone = [];
					} else if ( !copyIsArray && !jQuery.isPlainObject( src ) ) {
						clone = {};
					} else {
						clone = src;
					}
					copyIsArray = false;

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend( {

	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	isPlainObject: function( obj ) {
		var proto, Ctor;

		// Detect obvious negatives
		// Use toString instead of jQuery.type to catch host objects
		if ( !obj || toString.call( obj ) !== "[object Object]" ) {
			return false;
		}

		proto = getProto( obj );

		// Objects with no prototype (e.g., `Object.create( null )`) are plain
		if ( !proto ) {
			return true;
		}

		// Objects with prototype are plain iff they were constructed by a global Object function
		Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;
		return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;
	},

	isEmptyObject: function( obj ) {
		var name;

		for ( name in obj ) {
			return false;
		}
		return true;
	},

	// Evaluates a script in a provided context; falls back to the global one
	// if not specified.
	globalEval: function( code, options, doc ) {
		DOMEval( code, { nonce: options && options.nonce }, doc );
	},

	each: function( obj, callback ) {
		var length, i = 0;

		if ( isArrayLike( obj ) ) {
			length = obj.length;
			for ( ; i < length; i++ ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		} else {
			for ( i in obj ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		}

		return obj;
	},


	// Retrieve the text value of an array of DOM nodes
	text: function( elem ) {
		var node,
			ret = "",
			i = 0,
			nodeType = elem.nodeType;

		if ( !nodeType ) {

			// If no nodeType, this is expected to be an array
			while ( ( node = elem[ i++ ] ) ) {

				// Do not traverse comment nodes
				ret += jQuery.text( node );
			}
		}
		if ( nodeType === 1 || nodeType === 11 ) {
			return elem.textContent;
		}
		if ( nodeType === 9 ) {
			return elem.documentElement.textContent;
		}
		if ( nodeType === 3 || nodeType === 4 ) {
			return elem.nodeValue;
		}

		// Do not include comment or processing instruction nodes

		return ret;
	},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArrayLike( Object( arr ) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
						[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		return arr == null ? -1 : indexOf.call( arr, elem, i );
	},

	isXMLDoc: function( elem ) {
		var namespace = elem && elem.namespaceURI,
			docElem = elem && ( elem.ownerDocument || elem ).documentElement;

		// Assume HTML when documentElement doesn't yet exist, such as inside
		// document fragments.
		return !rhtmlSuffix.test( namespace || docElem && docElem.nodeName || "HTML" );
	},

	// Support: Android <=4.0 only, PhantomJS 1 only
	// push.apply(_, arraylike) throws on ancient WebKit
	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var length, value,
			i = 0,
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArrayLike( elems ) ) {
			length = elems.length;
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return flat( ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
} );

if ( typeof Symbol === "function" ) {
	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
}

// Populate the class2type map
jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
	function( _i, name ) {
		class2type[ "[object " + name + "]" ] = name.toLowerCase();
	} );

function isArrayLike( obj ) {

	// Support: real iOS 8.2 only (not reproducible in simulator)
	// `in` check used to prevent JIT error (gh-2145)
	// hasOwn isn't used here due to false negatives
	// regarding Nodelist length in IE
	var length = !!obj && "length" in obj && obj.length,
		type = toType( obj );

	if ( isFunction( obj ) || isWindow( obj ) ) {
		return false;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}


function nodeName( elem, name ) {

	return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();

}
var pop = arr.pop;


var sort = arr.sort;


var splice = arr.splice;


var whitespace = "[\\x20\\t\\r\\n\\f]";


var rtrimCSS = new RegExp(
	"^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$",
	"g"
);




// Note: an element does not contain itself
jQuery.contains = function( a, b ) {
	var bup = b && b.parentNode;

	return a === bup || !!( bup && bup.nodeType === 1 && (

		// Support: IE 9 - 11+
		// IE doesn't have `contains` on SVG.
		a.contains ?
			a.contains( bup ) :
			a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
	) );
};




// CSS string/identifier serialization
// https://drafts.csswg.org/cssom/#common-serializing-idioms
var rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\x80-\uFFFF\w-]/g;

function fcssescape( ch, asCodePoint ) {
	if ( asCodePoint ) {

		// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
		if ( ch === "\0" ) {
			return "\uFFFD";
		}

		// Control characters and (dependent upon position) numbers get escaped as code points
		return ch.slice( 0, -1 ) + "\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
	}

	// Other potentially-special ASCII characters get backslash-escaped
	return "\\" + ch;
}

jQuery.escapeSelector = function( sel ) {
	return ( sel + "" ).replace( rcssescape, fcssescape );
};




var preferredDoc = document,
	pushNative = push;

( function() {

var i,
	Expr,
	outermostContext,
	sortInput,
	hasDuplicate,
	push = pushNative,

	// Local document vars
	document,
	documentElement,
	documentIsHTML,
	rbuggyQSA,
	matches,

	// Instance-specific data
	expando = jQuery.expando,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	nonnativeSelectorCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|" +
		"loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// https://www.w3.org/TR/css-syntax-3/#ident-token-diagram
	identifier = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace +
		"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",

	// Attribute selectors: https://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +

		// Operator (capture 2)
		"*([*^$|!~]?=)" + whitespace +

		// "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" +
		whitespace + "*\\]",

	pseudos = ":(" + identifier + ")(?:\\((" +

		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
		// 1. quoted (capture 3; capture 4 or capture 5)
		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +

		// 2. simple (capture 6)
		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +

		// 3. anything else (capture 2)
		".*" +
		")\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rwhitespace = new RegExp( whitespace + "+", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rleadingCombinator = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" +
		whitespace + "*" ),
	rdescend = new RegExp( whitespace + "|>" ),

	rpseudo = new RegExp( pseudos ),
	ridentifier = new RegExp( "^" + identifier + "$" ),

	matchExpr = {
		ID: new RegExp( "^#(" + identifier + ")" ),
		CLASS: new RegExp( "^\\.(" + identifier + ")" ),
		TAG: new RegExp( "^(" + identifier + "|[*])" ),
		ATTR: new RegExp( "^" + attributes ),
		PSEUDO: new RegExp( "^" + pseudos ),
		CHILD: new RegExp(
			"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +
				whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" +
				whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		bool: new RegExp( "^(?:" + booleans + ")$", "i" ),

		// For use in libraries implementing .is()
		// We use this for POS matching in `select`
		needsContext: new RegExp( "^" + whitespace +
			"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
			"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
	},

	rinputs = /^(?:input|select|textarea|button)$/i,
	rheader = /^h\d$/i,

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

	rsibling = /[+~]/,

	// CSS escapes
	// https://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	runescape = new RegExp( "\\\\[\\da-fA-F]{1,6}" + whitespace +
		"?|\\\\([^\\r\\n\\f])", "g" ),
	funescape = function( escape, nonHex ) {
		var high = "0x" + escape.slice( 1 ) - 0x10000;

		if ( nonHex ) {

			// Strip the backslash prefix from a non-hex escape sequence
			return nonHex;
		}

		// Replace a hexadecimal escape sequence with the encoded Unicode code point
		// Support: IE <=11+
		// For values outside the Basic Multilingual Plane (BMP), manually construct a
		// surrogate pair
		return high < 0 ?
			String.fromCharCode( high + 0x10000 ) :
			String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
	},

	// Used for iframes; see `setDocument`.
	// Support: IE 9 - 11+, Edge 12 - 18+
	// Removing the function wrapper causes a "Permission Denied"
	// error in IE/Edge.
	unloadHandler = function() {
		setDocument();
	},

	inDisabledFieldset = addCombinator(
		function( elem ) {
			return elem.disabled === true && nodeName( elem, "fieldset" );
		},
		{ dir: "parentNode", next: "legend" }
	);

// Support: IE <=9 only
// Accessing document.activeElement can throw unexpectedly
// https://bugs.jquery.com/ticket/13393
function safeActiveElement() {
	try {
		return document.activeElement;
	} catch ( err ) { }
}

// Optimize for push.apply( _, NodeList )
try {
	push.apply(
		( arr = slice.call( preferredDoc.childNodes ) ),
		preferredDoc.childNodes
	);

	// Support: Android <=4.0
	// Detect silently failing push.apply
	// eslint-disable-next-line no-unused-expressions
	arr[ preferredDoc.childNodes.length ].nodeType;
} catch ( e ) {
	push = {
		apply: function( target, els ) {
			pushNative.apply( target, slice.call( els ) );
		},
		call: function( target ) {
			pushNative.apply( target, slice.call( arguments, 1 ) );
		}
	};
}

function find( selector, context, results, seed ) {
	var m, i, elem, nid, match, groups, newSelector,
		newContext = context && context.ownerDocument,

		// nodeType defaults to 9, since context defaults to document
		nodeType = context ? context.nodeType : 9;

	results = results || [];

	// Return early from calls with invalid selector or context
	if ( typeof selector !== "string" || !selector ||
		nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

		return results;
	}

	// Try to shortcut find operations (as opposed to filters) in HTML documents
	if ( !seed ) {
		setDocument( context );
		context = context || document;

		if ( documentIsHTML ) {

			// If the selector is sufficiently simple, try using a "get*By*" DOM method
			// (excepting DocumentFragment context, where the methods don't exist)
			if ( nodeType !== 11 && ( match = rquickExpr.exec( selector ) ) ) {

				// ID selector
				if ( ( m = match[ 1 ] ) ) {

					// Document context
					if ( nodeType === 9 ) {
						if ( ( elem = context.getElementById( m ) ) ) {

							// Support: IE 9 only
							// getElementById can match elements by name instead of ID
							if ( elem.id === m ) {
								push.call( results, elem );
								return results;
							}
						} else {
							return results;
						}

					// Element context
					} else {

						// Support: IE 9 only
						// getElementById can match elements by name instead of ID
						if ( newContext && ( elem = newContext.getElementById( m ) ) &&
							find.contains( context, elem ) &&
							elem.id === m ) {

							push.call( results, elem );
							return results;
						}
					}

				// Type selector
				} else if ( match[ 2 ] ) {
					push.apply( results, context.getElementsByTagName( selector ) );
					return results;

				// Class selector
				} else if ( ( m = match[ 3 ] ) && context.getElementsByClassName ) {
					push.apply( results, context.getElementsByClassName( m ) );
					return results;
				}
			}

			// Take advantage of querySelectorAll
			if ( !nonnativeSelectorCache[ selector + " " ] &&
				( !rbuggyQSA || !rbuggyQSA.test( selector ) ) ) {

				newSelector = selector;
				newContext = context;

				// qSA considers elements outside a scoping root when evaluating child or
				// descendant combinators, which is not what we want.
				// In such cases, we work around the behavior by prefixing every selector in the
				// list with an ID selector referencing the scope context.
				// The technique has to be used as well when a leading combinator is used
				// as such selectors are not recognized by querySelectorAll.
				// Thanks to Andrew Dupont for this technique.
				if ( nodeType === 1 &&
					( rdescend.test( selector ) || rleadingCombinator.test( selector ) ) ) {

					// Expand context for sibling selectors
					newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
						context;

					// We can use :scope instead of the ID hack if the browser
					// supports it & if we're not changing the context.
					// Support: IE 11+, Edge 17 - 18+
					// IE/Edge sometimes throw a "Permission denied" error when
					// strict-comparing two documents; shallow comparisons work.
					// eslint-disable-next-line eqeqeq
					if ( newContext != context || !support.scope ) {

						// Capture the context ID, setting it first if necessary
						if ( ( nid = context.getAttribute( "id" ) ) ) {
							nid = jQuery.escapeSelector( nid );
						} else {
							context.setAttribute( "id", ( nid = expando ) );
						}
					}

					// Prefix every selector in the list
					groups = tokenize( selector );
					i = groups.length;
					while ( i-- ) {
						groups[ i ] = ( nid ? "#" + nid : ":scope" ) + " " +
							toSelector( groups[ i ] );
					}
					newSelector = groups.join( "," );
				}

				try {
					push.apply( results,
						newContext.querySelectorAll( newSelector )
					);
					return results;
				} catch ( qsaError ) {
					nonnativeSelectorCache( selector, true );
				} finally {
					if ( nid === expando ) {
						context.removeAttribute( "id" );
					}
				}
			}
		}
	}

	// All others
	return select( selector.replace( rtrimCSS, "$1" ), context, results, seed );
}

/**
 * Create key-value caches of limited size
 * @returns {function(string, object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */
function createCache() {
	var keys = [];

	function cache( key, value ) {

		// Use (key + " ") to avoid collision with native prototype properties
		// (see https://github.com/jquery/sizzle/issues/157)
		if ( keys.push( key + " " ) > Expr.cacheLength ) {

			// Only keep the most recent entries
			delete cache[ keys.shift() ];
		}
		return ( cache[ key + " " ] = value );
	}
	return cache;
}

/**
 * Mark a function for special use by jQuery selector module
 * @param {Function} fn The function to mark
 */
function markFunction( fn ) {
	fn[ expando ] = true;
	return fn;
}

/**
 * Support testing using an element
 * @param {Function} fn Passed the created element and returns a boolean result
 */
function assert( fn ) {
	var el = document.createElement( "fieldset" );

	try {
		return !!fn( el );
	} catch ( e ) {
		return false;
	} finally {

		// Remove from its parent by default
		if ( el.parentNode ) {
			el.parentNode.removeChild( el );
		}

		// release memory in IE
		el = null;
	}
}

/**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */
function createInputPseudo( type ) {
	return function( elem ) {
		return nodeName( elem, "input" ) && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */
function createButtonPseudo( type ) {
	return function( elem ) {
		return ( nodeName( elem, "input" ) || nodeName( elem, "button" ) ) &&
			elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for :enabled/:disabled
 * @param {Boolean} disabled true for :disabled; false for :enabled
 */
function createDisabledPseudo( disabled ) {

	// Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
	return function( elem ) {

		// Only certain elements can match :enabled or :disabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
		if ( "form" in elem ) {

			// Check for inherited disabledness on relevant non-disabled elements:
			// * listed form-associated elements in a disabled fieldset
			//   https://html.spec.whatwg.org/multipage/forms.html#category-listed
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
			// * option elements in a disabled optgroup
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
			// All such elements have a "form" property.
			if ( elem.parentNode && elem.disabled === false ) {

				// Option elements defer to a parent optgroup if present
				if ( "label" in elem ) {
					if ( "label" in elem.parentNode ) {
						return elem.parentNode.disabled === disabled;
					} else {
						return elem.disabled === disabled;
					}
				}

				// Support: IE 6 - 11+
				// Use the isDisabled shortcut property to check for disabled fieldset ancestors
				return elem.isDisabled === disabled ||

					// Where there is no isDisabled, check manually
					elem.isDisabled !== !disabled &&
						inDisabledFieldset( elem ) === disabled;
			}

			return elem.disabled === disabled;

		// Try to winnow out elements that can't be disabled before trusting the disabled property.
		// Some victims get caught in our net (label, legend, menu, track), but it shouldn't
		// even exist on them, let alone have a boolean value.
		} else if ( "label" in elem ) {
			return elem.disabled === disabled;
		}

		// Remaining elements are neither :enabled nor :disabled
		return false;
	};
}

/**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */
function createPositionalPseudo( fn ) {
	return markFunction( function( argument ) {
		argument = +argument;
		return markFunction( function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ ( j = matchIndexes[ i ] ) ] ) {
					seed[ j ] = !( matches[ j ] = seed[ j ] );
				}
			}
		} );
	} );
}

/**
 * Checks a node for validity as a jQuery selector context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */
function testContext( context ) {
	return context && typeof context.getElementsByTagName !== "undefined" && context;
}

/**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [node] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */
function setDocument( node ) {
	var subWindow,
		doc = node ? node.ownerDocument || node : preferredDoc;

	// Return early if doc is invalid or already selected
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( doc == document || doc.nodeType !== 9 || !doc.documentElement ) {
		return document;
	}

	// Update global variables
	document = doc;
	documentElement = document.documentElement;
	documentIsHTML = !jQuery.isXMLDoc( document );

	// Support: iOS 7 only, IE 9 - 11+
	// Older browsers didn't support unprefixed `matches`.
	matches = documentElement.matches ||
		documentElement.webkitMatchesSelector ||
		documentElement.msMatchesSelector;

	// Support: IE 9 - 11+, Edge 12 - 18+
	// Accessing iframe documents after unload throws "permission denied" errors
	// (see trac-13936).
	// Limit the fix to IE & Edge Legacy; despite Edge 15+ implementing `matches`,
	// all IE 9+ and Edge Legacy versions implement `msMatchesSelector` as well.
	if ( documentElement.msMatchesSelector &&

		// Support: IE 11+, Edge 17 - 18+
		// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		// two documents; shallow comparisons work.
		// eslint-disable-next-line eqeqeq
		preferredDoc != document &&
		( subWindow = document.defaultView ) && subWindow.top !== subWindow ) {

		// Support: IE 9 - 11+, Edge 12 - 18+
		subWindow.addEventListener( "unload", unloadHandler );
	}

	// Support: IE <10
	// Check if getElementById returns elements by name
	// The broken getElementById methods don't pick up programmatically-set names,
	// so use a roundabout getElementsByName test
	support.getById = assert( function( el ) {
		documentElement.appendChild( el ).id = jQuery.expando;
		return !document.getElementsByName ||
			!document.getElementsByName( jQuery.expando ).length;
	} );

	// Support: IE 9 only
	// Check to see if it's possible to do matchesSelector
	// on a disconnected node.
	support.disconnectedMatch = assert( function( el ) {
		return matches.call( el, "*" );
	} );

	// Support: IE 9 - 11+, Edge 12 - 18+
	// IE/Edge don't support the :scope pseudo-class.
	support.scope = assert( function() {
		return document.querySelectorAll( ":scope" );
	} );

	// Support: Chrome 105 - 111 only, Safari 15.4 - 16.3 only
	// Make sure the `:has()` argument is parsed unforgivingly.
	// We include `*` in the test to detect buggy implementations that are
	// _selectively_ forgiving (specifically when the list includes at least
	// one valid selector).
	// Note that we treat complete lack of support for `:has()` as if it were
	// spec-compliant support, which is fine because use of `:has()` in such
	// environments will fail in the qSA path and fall back to jQuery traversal
	// anyway.
	support.cssHas = assert( function() {
		try {
			document.querySelector( ":has(*,:jqfake)" );
			return false;
		} catch ( e ) {
			return true;
		}
	} );

	// ID filter and find
	if ( support.getById ) {
		Expr.filter.ID = function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				return elem.getAttribute( "id" ) === attrId;
			};
		};
		Expr.find.ID = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var elem = context.getElementById( id );
				return elem ? [ elem ] : [];
			}
		};
	} else {
		Expr.filter.ID =  function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				var node = typeof elem.getAttributeNode !== "undefined" &&
					elem.getAttributeNode( "id" );
				return node && node.value === attrId;
			};
		};

		// Support: IE 6 - 7 only
		// getElementById is not reliable as a find shortcut
		Expr.find.ID = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var node, i, elems,
					elem = context.getElementById( id );

				if ( elem ) {

					// Verify the id attribute
					node = elem.getAttributeNode( "id" );
					if ( node && node.value === id ) {
						return [ elem ];
					}

					// Fall back on getElementsByName
					elems = context.getElementsByName( id );
					i = 0;
					while ( ( elem = elems[ i++ ] ) ) {
						node = elem.getAttributeNode( "id" );
						if ( node && node.value === id ) {
							return [ elem ];
						}
					}
				}

				return [];
			}
		};
	}

	// Tag
	Expr.find.TAG = function( tag, context ) {
		if ( typeof context.getElementsByTagName !== "undefined" ) {
			return context.getElementsByTagName( tag );

		// DocumentFragment nodes don't have gEBTN
		} else {
			return context.querySelectorAll( tag );
		}
	};

	// Class
	Expr.find.CLASS = function( className, context ) {
		if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
			return context.getElementsByClassName( className );
		}
	};

	/* QSA/matchesSelector
	---------------------------------------------------------------------- */

	// QSA and matchesSelector support

	rbuggyQSA = [];

	// Build QSA regex
	// Regex strategy adopted from Diego Perini
	assert( function( el ) {

		var input;

		documentElement.appendChild( el ).innerHTML =
			"<a id='" + expando + "' href='' disabled='disabled'></a>" +
			"<select id='" + expando + "-\r\\' disabled='disabled'>" +
			"<option selected=''></option></select>";

		// Support: iOS <=7 - 8 only
		// Boolean attributes and "value" are not treated correctly in some XML documents
		if ( !el.querySelectorAll( "[selected]" ).length ) {
			rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
		}

		// Support: iOS <=7 - 8 only
		if ( !el.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
			rbuggyQSA.push( "~=" );
		}

		// Support: iOS 8 only
		// https://bugs.webkit.org/show_bug.cgi?id=136851
		// In-page `selector#id sibling-combinator selector` fails
		if ( !el.querySelectorAll( "a#" + expando + "+*" ).length ) {
			rbuggyQSA.push( ".#.+[+~]" );
		}

		// Support: Chrome <=105+, Firefox <=104+, Safari <=15.4+
		// In some of the document kinds, these selectors wouldn't work natively.
		// This is probably OK but for backwards compatibility we want to maintain
		// handling them through jQuery traversal in jQuery 3.x.
		if ( !el.querySelectorAll( ":checked" ).length ) {
			rbuggyQSA.push( ":checked" );
		}

		// Support: Windows 8 Native Apps
		// The type and name attributes are restricted during .innerHTML assignment
		input = document.createElement( "input" );
		input.setAttribute( "type", "hidden" );
		el.appendChild( input ).setAttribute( "name", "D" );

		// Support: IE 9 - 11+
		// IE's :disabled selector does not pick up the children of disabled fieldsets
		// Support: Chrome <=105+, Firefox <=104+, Safari <=15.4+
		// In some of the document kinds, these selectors wouldn't work natively.
		// This is probably OK but for backwards compatibility we want to maintain
		// handling them through jQuery traversal in jQuery 3.x.
		documentElement.appendChild( el ).disabled = true;
		if ( el.querySelectorAll( ":disabled" ).length !== 2 ) {
			rbuggyQSA.push( ":enabled", ":disabled" );
		}

		// Support: IE 11+, Edge 15 - 18+
		// IE 11/Edge don't find elements on a `[name='']` query in some cases.
		// Adding a temporary attribute to the document before the selection works
		// around the issue.
		// Interestingly, IE 10 & older don't seem to have the issue.
		input = document.createElement( "input" );
		input.setAttribute( "name", "" );
		el.appendChild( input );
		if ( !el.querySelectorAll( "[name='']" ).length ) {
			rbuggyQSA.push( "\\[" + whitespace + "*name" + whitespace + "*=" +
				whitespace + "*(?:''|\"\")" );
		}
	} );

	if ( !support.cssHas ) {

		// Support: Chrome 105 - 110+, Safari 15.4 - 16.3+
		// Our regular `try-catch` mechanism fails to detect natively-unsupported
		// pseudo-classes inside `:has()` (such as `:has(:contains("Foo"))`)
		// in browsers that parse the `:has()` argument as a forgiving selector list.
		// https://drafts.csswg.org/selectors/#relational now requires the argument
		// to be parsed unforgivingly, but browsers have not yet fully adjusted.
		rbuggyQSA.push( ":has" );
	}

	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join( "|" ) );

	/* Sorting
	---------------------------------------------------------------------- */

	// Document order sorting
	sortOrder = function( a, b ) {

		// Flag for duplicate removal
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if ( compare ) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		// Support: IE 11+, Edge 17 - 18+
		// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		// two documents; shallow comparisons work.
		// eslint-disable-next-line eqeqeq
		compare = ( a.ownerDocument || a ) == ( b.ownerDocument || b ) ?
			a.compareDocumentPosition( b ) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if ( compare & 1 ||
			( !support.sortDetached && b.compareDocumentPosition( a ) === compare ) ) {

			// Choose the first element that is related to our preferred document
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( a === document || a.ownerDocument == preferredDoc &&
				find.contains( preferredDoc, a ) ) {
				return -1;
			}

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( b === document || b.ownerDocument == preferredDoc &&
				find.contains( preferredDoc, b ) ) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				( indexOf.call( sortInput, a ) - indexOf.call( sortInput, b ) ) :
				0;
		}

		return compare & 4 ? -1 : 1;
	};

	return document;
}

find.matches = function( expr, elements ) {
	return find( expr, null, null, elements );
};

find.matchesSelector = function( elem, expr ) {
	setDocument( elem );

	if ( documentIsHTML &&
		!nonnativeSelectorCache[ expr + " " ] &&
		( !rbuggyQSA || !rbuggyQSA.test( expr ) ) ) {

		try {
			var ret = matches.call( elem, expr );

			// IE 9's matchesSelector returns false on disconnected nodes
			if ( ret || support.disconnectedMatch ||

					// As well, disconnected nodes are said to be in a document
					// fragment in IE 9
					elem.document && elem.document.nodeType !== 11 ) {
				return ret;
			}
		} catch ( e ) {
			nonnativeSelectorCache( expr, true );
		}
	}

	return find( expr, document, null, [ elem ] ).length > 0;
};

find.contains = function( context, elem ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( context.ownerDocument || context ) != document ) {
		setDocument( context );
	}
	return jQuery.contains( context, elem );
};


find.attr = function( elem, name ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( elem.ownerDocument || elem ) != document ) {
		setDocument( elem );
	}

	var fn = Expr.attrHandle[ name.toLowerCase() ],

		// Don't get fooled by Object.prototype properties (see trac-13807)
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
			fn( elem, name, !documentIsHTML ) :
			undefined;

	if ( val !== undefined ) {
		return val;
	}

	return elem.getAttribute( name );
};

find.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

/**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */
jQuery.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		j = 0,
		i = 0;

	// Unless we *know* we can detect duplicates, assume their presence
	//
	// Support: Android <=4.0+
	// Testing for detecting duplicates is unpredictable so instead assume we can't
	// depend on duplicate detection in all browsers without a stable sort.
	hasDuplicate = !support.sortStable;
	sortInput = !support.sortStable && slice.call( results, 0 );
	sort.call( results, sortOrder );

	if ( hasDuplicate ) {
		while ( ( elem = results[ i++ ] ) ) {
			if ( elem === results[ i ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			splice.call( results, duplicates[ j ], 1 );
		}
	}

	// Clear input after sorting to release objects
	// See https://github.com/jquery/sizzle/pull/225
	sortInput = null;

	return results;
};

jQuery.fn.uniqueSort = function() {
	return this.pushStack( jQuery.uniqueSort( slice.apply( this ) ) );
};

Expr = jQuery.expr = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	attrHandle: {},

	find: {},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		ATTR: function( match ) {
			match[ 1 ] = match[ 1 ].replace( runescape, funescape );

			// Move the given value to match[3] whether quoted or unquoted
			match[ 3 ] = ( match[ 3 ] || match[ 4 ] || match[ 5 ] || "" )
				.replace( runescape, funescape );

			if ( match[ 2 ] === "~=" ) {
				match[ 3 ] = " " + match[ 3 ] + " ";
			}

			return match.slice( 0, 4 );
		},

		CHILD: function( match ) {

			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
			match[ 1 ] = match[ 1 ].toLowerCase();

			if ( match[ 1 ].slice( 0, 3 ) === "nth" ) {

				// nth-* requires argument
				if ( !match[ 3 ] ) {
					find.error( match[ 0 ] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[ 4 ] = +( match[ 4 ] ?
					match[ 5 ] + ( match[ 6 ] || 1 ) :
					2 * ( match[ 3 ] === "even" || match[ 3 ] === "odd" )
				);
				match[ 5 ] = +( ( match[ 7 ] + match[ 8 ] ) || match[ 3 ] === "odd" );

			// other types prohibit arguments
			} else if ( match[ 3 ] ) {
				find.error( match[ 0 ] );
			}

			return match;
		},

		PSEUDO: function( match ) {
			var excess,
				unquoted = !match[ 6 ] && match[ 2 ];

			if ( matchExpr.CHILD.test( match[ 0 ] ) ) {
				return null;
			}

			// Accept quoted arguments as-is
			if ( match[ 3 ] ) {
				match[ 2 ] = match[ 4 ] || match[ 5 ] || "";

			// Strip excess characters from unquoted arguments
			} else if ( unquoted && rpseudo.test( unquoted ) &&

				// Get excess from tokenize (recursively)
				( excess = tokenize( unquoted, true ) ) &&

				// advance to the next closing parenthesis
				( excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length ) ) {

				// excess is a negative index
				match[ 0 ] = match[ 0 ].slice( 0, excess );
				match[ 2 ] = unquoted.slice( 0, excess );
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {

		TAG: function( nodeNameSelector ) {
			var expectedNodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
			return nodeNameSelector === "*" ?
				function() {
					return true;
				} :
				function( elem ) {
					return nodeName( elem, expectedNodeName );
				};
		},

		CLASS: function( className ) {
			var pattern = classCache[ className + " " ];

			return pattern ||
				( pattern = new RegExp( "(^|" + whitespace + ")" + className +
					"(" + whitespace + "|$)" ) ) &&
				classCache( className, function( elem ) {
					return pattern.test(
						typeof elem.className === "string" && elem.className ||
							typeof elem.getAttribute !== "undefined" &&
								elem.getAttribute( "class" ) ||
							""
					);
				} );
		},

		ATTR: function( name, operator, check ) {
			return function( elem ) {
				var result = find.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				if ( operator === "=" ) {
					return result === check;
				}
				if ( operator === "!=" ) {
					return result !== check;
				}
				if ( operator === "^=" ) {
					return check && result.indexOf( check ) === 0;
				}
				if ( operator === "*=" ) {
					return check && result.indexOf( check ) > -1;
				}
				if ( operator === "$=" ) {
					return check && result.slice( -check.length ) === check;
				}
				if ( operator === "~=" ) {
					return ( " " + result.replace( rwhitespace, " " ) + " " )
						.indexOf( check ) > -1;
				}
				if ( operator === "|=" ) {
					return result === check || result.slice( 0, check.length + 1 ) === check + "-";
				}

				return false;
			};
		},

		CHILD: function( type, what, _argument, first, last ) {
			var simple = type.slice( 0, 3 ) !== "nth",
				forward = type.slice( -4 ) !== "last",
				ofType = what === "of-type";

			return first === 1 && last === 0 ?

				// Shortcut for :nth-*(n)
				function( elem ) {
					return !!elem.parentNode;
				} :

				function( elem, _context, xml ) {
					var cache, outerCache, node, nodeIndex, start,
						dir = simple !== forward ? "nextSibling" : "previousSibling",
						parent = elem.parentNode,
						name = ofType && elem.nodeName.toLowerCase(),
						useCache = !xml && !ofType,
						diff = false;

					if ( parent ) {

						// :(first|last|only)-(child|of-type)
						if ( simple ) {
							while ( dir ) {
								node = elem;
								while ( ( node = node[ dir ] ) ) {
									if ( ofType ?
										nodeName( node, name ) :
										node.nodeType === 1 ) {

										return false;
									}
								}

								// Reverse direction for :only-* (if we haven't yet done so)
								start = dir = type === "only" && !start && "nextSibling";
							}
							return true;
						}

						start = [ forward ? parent.firstChild : parent.lastChild ];

						// non-xml :nth-child(...) stores cache data on `parent`
						if ( forward && useCache ) {

							// Seek `elem` from a previously-cached index
							outerCache = parent[ expando ] || ( parent[ expando ] = {} );
							cache = outerCache[ type ] || [];
							nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
							diff = nodeIndex && cache[ 2 ];
							node = nodeIndex && parent.childNodes[ nodeIndex ];

							while ( ( node = ++nodeIndex && node && node[ dir ] ||

								// Fallback to seeking `elem` from the start
								( diff = nodeIndex = 0 ) || start.pop() ) ) {

								// When found, cache indexes on `parent` and break
								if ( node.nodeType === 1 && ++diff && node === elem ) {
									outerCache[ type ] = [ dirruns, nodeIndex, diff ];
									break;
								}
							}

						} else {

							// Use previously-cached element index if available
							if ( useCache ) {
								outerCache = elem[ expando ] || ( elem[ expando ] = {} );
								cache = outerCache[ type ] || [];
								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
								diff = nodeIndex;
							}

							// xml :nth-child(...)
							// or :nth-last-child(...) or :nth(-last)?-of-type(...)
							if ( diff === false ) {

								// Use the same loop as above to seek `elem` from the start
								while ( ( node = ++nodeIndex && node && node[ dir ] ||
									( diff = nodeIndex = 0 ) || start.pop() ) ) {

									if ( ( ofType ?
										nodeName( node, name ) :
										node.nodeType === 1 ) &&
										++diff ) {

										// Cache the index of each encountered element
										if ( useCache ) {
											outerCache = node[ expando ] ||
												( node[ expando ] = {} );
											outerCache[ type ] = [ dirruns, diff ];
										}

										if ( node === elem ) {
											break;
										}
									}
								}
							}
						}

						// Incorporate the offset, then check against cycle size
						diff -= last;
						return diff === first || ( diff % first === 0 && diff / first >= 0 );
					}
				};
		},

		PSEUDO: function( pseudo, argument ) {

			// pseudo-class names are case-insensitive
			// https://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					find.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as jQuery does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction( function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf.call( seed, matched[ i ] );
							seed[ idx ] = !( matches[ idx ] = matched[ i ] );
						}
					} ) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {

		// Potentially complex pseudos
		not: markFunction( function( selector ) {

			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrimCSS, "$1" ) );

			return matcher[ expando ] ?
				markFunction( function( seed, matches, _context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( ( elem = unmatched[ i ] ) ) {
							seed[ i ] = !( matches[ i ] = elem );
						}
					}
				} ) :
				function( elem, _context, xml ) {
					input[ 0 ] = elem;
					matcher( input, null, xml, results );

					// Don't keep the element
					// (see https://github.com/jquery/sizzle/issues/299)
					input[ 0 ] = null;
					return !results.pop();
				};
		} ),

		has: markFunction( function( selector ) {
			return function( elem ) {
				return find( selector, elem ).length > 0;
			};
		} ),

		contains: markFunction( function( text ) {
			text = text.replace( runescape, funescape );
			return function( elem ) {
				return ( elem.textContent || jQuery.text( elem ) ).indexOf( text ) > -1;
			};
		} ),

		// "Whether an element is represented by a :lang() selector
		// is based solely on the element's language value
		// being equal to the identifier C,
		// or beginning with the identifier C immediately followed by "-".
		// The matching of C against the element's language value is performed case-insensitively.
		// The identifier C does not have to be a valid language name."
		// https://www.w3.org/TR/selectors/#lang-pseudo
		lang: markFunction( function( lang ) {

			// lang value must be a valid identifier
			if ( !ridentifier.test( lang || "" ) ) {
				find.error( "unsupported lang: " + lang );
			}
			lang = lang.replace( runescape, funescape ).toLowerCase();
			return function( elem ) {
				var elemLang;
				do {
					if ( ( elemLang = documentIsHTML ?
						elem.lang :
						elem.getAttribute( "xml:lang" ) || elem.getAttribute( "lang" ) ) ) {

						elemLang = elemLang.toLowerCase();
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
					}
				} while ( ( elem = elem.parentNode ) && elem.nodeType === 1 );
				return false;
			};
		} ),

		// Miscellaneous
		target: function( elem ) {
			var hash = window.location && window.location.hash;
			return hash && hash.slice( 1 ) === elem.id;
		},

		root: function( elem ) {
			return elem === documentElement;
		},

		focus: function( elem ) {
			return elem === safeActiveElement() &&
				document.hasFocus() &&
				!!( elem.type || elem.href || ~elem.tabIndex );
		},

		// Boolean properties
		enabled: createDisabledPseudo( false ),
		disabled: createDisabledPseudo( true ),

		checked: function( elem ) {

			// In CSS3, :checked should return both checked and selected elements
			// https://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			return ( nodeName( elem, "input" ) && !!elem.checked ) ||
				( nodeName( elem, "option" ) && !!elem.selected );
		},

		selected: function( elem ) {

			// Support: IE <=11+
			// Accessing the selectedIndex property
			// forces the browser to treat the default option as
			// selected when in an optgroup.
			if ( elem.parentNode ) {
				// eslint-disable-next-line no-unused-expressions
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		// Contents
		empty: function( elem ) {

			// https://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
			//   but not by others (comment: 8; processing instruction: 7; etc.)
			// nodeType < 6 works because attributes (2) do not appear as children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				if ( elem.nodeType < 6 ) {
					return false;
				}
			}
			return true;
		},

		parent: function( elem ) {
			return !Expr.pseudos.empty( elem );
		},

		// Element/input types
		header: function( elem ) {
			return rheader.test( elem.nodeName );
		},

		input: function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		button: function( elem ) {
			return nodeName( elem, "input" ) && elem.type === "button" ||
				nodeName( elem, "button" );
		},

		text: function( elem ) {
			var attr;
			return nodeName( elem, "input" ) && elem.type === "text" &&

				// Support: IE <10 only
				// New HTML5 attribute values (e.g., "search") appear
				// with elem.type === "text"
				( ( attr = elem.getAttribute( "type" ) ) == null ||
					attr.toLowerCase() === "text" );
		},

		// Position-in-collection
		first: createPositionalPseudo( function() {
			return [ 0 ];
		} ),

		last: createPositionalPseudo( function( _matchIndexes, length ) {
			return [ length - 1 ];
		} ),

		eq: createPositionalPseudo( function( _matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		} ),

		even: createPositionalPseudo( function( matchIndexes, length ) {
			var i = 0;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		odd: createPositionalPseudo( function( matchIndexes, length ) {
			var i = 1;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		lt: createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i;

			if ( argument < 0 ) {
				i = argument + length;
			} else if ( argument > length ) {
				i = length;
			} else {
				i = argument;
			}

			for ( ; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		gt: createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} )
	}
};

Expr.pseudos.nth = Expr.pseudos.eq;

// Add button/input type pseudos
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
	Expr.pseudos[ i ] = createInputPseudo( i );
}
for ( i in { submit: true, reset: true } ) {
	Expr.pseudos[ i ] = createButtonPseudo( i );
}

// Easy API for creating new setFilters
function setFilters() {}
setFilters.prototype = Expr.filters = Expr.pseudos;
Expr.setFilters = new setFilters();

function tokenize( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || ( match = rcomma.exec( soFar ) ) ) {
			if ( match ) {

				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[ 0 ].length ) || soFar;
			}
			groups.push( ( tokens = [] ) );
		}

		matched = false;

		// Combinators
		if ( ( match = rleadingCombinator.exec( soFar ) ) ) {
			matched = match.shift();
			tokens.push( {
				value: matched,

				// Cast descendant combinators to space
				type: match[ 0 ].replace( rtrimCSS, " " )
			} );
			soFar = soFar.slice( matched.length );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( ( match = matchExpr[ type ].exec( soFar ) ) && ( !preFilters[ type ] ||
				( match = preFilters[ type ]( match ) ) ) ) {
				matched = match.shift();
				tokens.push( {
					value: matched,
					type: type,
					matches: match
				} );
				soFar = soFar.slice( matched.length );
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	if ( parseOnly ) {
		return soFar.length;
	}

	return soFar ?
		find.error( selector ) :

		// Cache the tokens
		tokenCache( selector, groups ).slice( 0 );
}

function toSelector( tokens ) {
	var i = 0,
		len = tokens.length,
		selector = "";
	for ( ; i < len; i++ ) {
		selector += tokens[ i ].value;
	}
	return selector;
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		skip = combinator.next,
		key = skip || dir,
		checkNonElements = base && key === "parentNode",
		doneName = done++;

	return combinator.first ?

		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( ( elem = elem[ dir ] ) ) {
				if ( elem.nodeType === 1 || checkNonElements ) {
					return matcher( elem, context, xml );
				}
			}
			return false;
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			var oldCache, outerCache,
				newCache = [ dirruns, doneName ];

			// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
			if ( xml ) {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						if ( matcher( elem, context, xml ) ) {
							return true;
						}
					}
				}
			} else {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						outerCache = elem[ expando ] || ( elem[ expando ] = {} );

						if ( skip && nodeName( elem, skip ) ) {
							elem = elem[ dir ] || elem;
						} else if ( ( oldCache = outerCache[ key ] ) &&
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

							// Assign to newCache so results back-propagate to previous elements
							return ( newCache[ 2 ] = oldCache[ 2 ] );
						} else {

							// Reuse newcache so results back-propagate to previous elements
							outerCache[ key ] = newCache;

							// A match means we're done; a fail means we have to keep checking
							if ( ( newCache[ 2 ] = matcher( elem, context, xml ) ) ) {
								return true;
							}
						}
					}
				}
			}
			return false;
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[ i ]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[ 0 ];
}

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		find( selector, contexts[ i ], results );
	}
	return results;
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( ( elem = unmatched[ i ] ) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction( function( seed, results, context, xml ) {
		var temp, i, elem, matcherOut,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed ||
				multipleContexts( selector || "*",
					context.nodeType ? [ context ] : context, [] ),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems;

		if ( matcher ) {

			// If we have a postFinder, or filtered seed, or non-seed postFilter
			// or preexisting results,
			matcherOut = postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

				// ...intermediate processing is necessary
				[] :

				// ...otherwise use results directly
				results;

			// Find primary matches
			matcher( matcherIn, matcherOut, context, xml );
		} else {
			matcherOut = matcherIn;
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( ( elem = temp[ i ] ) ) {
					matcherOut[ postMap[ i ] ] = !( matcherIn[ postMap[ i ] ] = elem );
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {

					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( ( elem = matcherOut[ i ] ) ) {

							// Restore matcherIn since elem is not yet a final match
							temp.push( ( matcherIn[ i ] = elem ) );
						}
					}
					postFinder( null, ( matcherOut = [] ), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( ( elem = matcherOut[ i ] ) &&
						( temp = postFinder ? indexOf.call( seed, elem ) : preMap[ i ] ) > -1 ) {

						seed[ temp ] = !( results[ temp ] = elem );
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	} );
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[ 0 ].type ],
		implicitRelative = leadingRelative || Expr.relative[ " " ],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf.call( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			var ret = ( !leadingRelative && ( xml || context != outermostContext ) ) || (
				( checkContext = context ).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );

			// Avoid hanging onto element
			// (see https://github.com/jquery/sizzle/issues/299)
			checkContext = null;
			return ret;
		} ];

	for ( ; i < len; i++ ) {
		if ( ( matcher = Expr.relative[ tokens[ i ].type ] ) ) {
			matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];
		} else {
			matcher = Expr.filter[ tokens[ i ].type ].apply( null, tokens[ i ].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {

				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[ j ].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && toSelector(

						// If the preceding token was a descendant combinator, insert an implicit any-element `*`
						tokens.slice( 0, i - 1 )
							.concat( { value: tokens[ i - 2 ].type === " " ? "*" : "" } )
					).replace( rtrimCSS, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( ( tokens = tokens.slice( j ) ) ),
					j < len && toSelector( tokens )
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, outermost ) {
			var elem, j, matcher,
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				setMatched = [],
				contextBackup = outermostContext,

				// We must always have either seed elements or outermost context
				elems = seed || byElement && Expr.find.TAG( "*", outermost ),

				// Use integer dirruns iff this is the outermost matcher
				dirrunsUnique = ( dirruns += contextBackup == null ? 1 : Math.random() || 0.1 ),
				len = elems.length;

			if ( outermost ) {

				// Support: IE 11+, Edge 17 - 18+
				// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
				// two documents; shallow comparisons work.
				// eslint-disable-next-line eqeqeq
				outermostContext = context == document || context || outermost;
			}

			// Add elements passing elementMatchers directly to results
			// Support: iOS <=7 - 9 only
			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching
			// elements by id. (see trac-14142)
			for ( ; i !== len && ( elem = elems[ i ] ) != null; i++ ) {
				if ( byElement && elem ) {
					j = 0;

					// Support: IE 11+, Edge 17 - 18+
					// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
					// two documents; shallow comparisons work.
					// eslint-disable-next-line eqeqeq
					if ( !context && elem.ownerDocument != document ) {
						setDocument( elem );
						xml = !documentIsHTML;
					}
					while ( ( matcher = elementMatchers[ j++ ] ) ) {
						if ( matcher( elem, context || document, xml ) ) {
							push.call( results, elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {

					// They will have gone through all possible matchers
					if ( ( elem = !matcher && elem ) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// `i` is now the count of elements visited above, and adding it to `matchedCount`
			// makes the latter nonnegative.
			matchedCount += i;

			// Apply set filters to unmatched elements
			// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
			// equals `i`), unless we didn't visit _any_ elements in the above loop because we have
			// no element matchers and no seed.
			// Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
			// case, which will result in a "00" `matchedCount` that differs from `i` but is also
			// numerically zero.
			if ( bySet && i !== matchedCount ) {
				j = 0;
				while ( ( matcher = setMatchers[ j++ ] ) ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {

					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !( unmatched[ i ] || setMatched[ i ] ) ) {
								setMatched[ i ] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					jQuery.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

function compile( selector, match /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ selector + " " ];

	if ( !cached ) {

		// Generate a function of recursive functions that can be used to check each element
		if ( !match ) {
			match = tokenize( selector );
		}
		i = match.length;
		while ( i-- ) {
			cached = matcherFromTokens( match[ i ] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache( selector,
			matcherFromGroupMatchers( elementMatchers, setMatchers ) );

		// Save selector and tokenization
		cached.selector = selector;
	}
	return cached;
}

/**
 * A low-level selection function that works with jQuery's compiled
 *  selector functions
 * @param {String|Function} selector A selector or a pre-compiled
 *  selector function built with jQuery selector compile
 * @param {Element} context
 * @param {Array} [results]
 * @param {Array} [seed] A set of elements to match against
 */
function select( selector, context, results, seed ) {
	var i, tokens, token, type, find,
		compiled = typeof selector === "function" && selector,
		match = !seed && tokenize( ( selector = compiled.selector || selector ) );

	results = results || [];

	// Try to minimize operations if there is only one selector in the list and no seed
	// (the latter of which guarantees us context)
	if ( match.length === 1 ) {

		// Reduce context if the leading compound selector is an ID
		tokens = match[ 0 ] = match[ 0 ].slice( 0 );
		if ( tokens.length > 2 && ( token = tokens[ 0 ] ).type === "ID" &&
				context.nodeType === 9 && documentIsHTML && Expr.relative[ tokens[ 1 ].type ] ) {

			context = ( Expr.find.ID(
				token.matches[ 0 ].replace( runescape, funescape ),
				context
			) || [] )[ 0 ];
			if ( !context ) {
				return results;

			// Precompiled matchers will still verify ancestry, so step up a level
			} else if ( compiled ) {
				context = context.parentNode;
			}

			selector = selector.slice( tokens.shift().value.length );
		}

		// Fetch a seed set for right-to-left matching
		i = matchExpr.needsContext.test( selector ) ? 0 : tokens.length;
		while ( i-- ) {
			token = tokens[ i ];

			// Abort if we hit a combinator
			if ( Expr.relative[ ( type = token.type ) ] ) {
				break;
			}
			if ( ( find = Expr.find[ type ] ) ) {

				// Search, expanding context for leading sibling combinators
				if ( ( seed = find(
					token.matches[ 0 ].replace( runescape, funescape ),
					rsibling.test( tokens[ 0 ].type ) &&
						testContext( context.parentNode ) || context
				) ) ) {

					// If seed is empty or no tokens remain, we can return early
					tokens.splice( i, 1 );
					selector = seed.length && toSelector( tokens );
					if ( !selector ) {
						push.apply( results, seed );
						return results;
					}

					break;
				}
			}
		}
	}

	// Compile and execute a filtering function if one is not provided
	// Provide `match` to avoid retokenization if we modified the selector above
	( compiled || compile( selector, match ) )(
		seed,
		context,
		!documentIsHTML,
		results,
		!context || rsibling.test( selector ) && testContext( context.parentNode ) || context
	);
	return results;
}

// One-time assignments

// Support: Android <=4.0 - 4.1+
// Sort stability
support.sortStable = expando.split( "" ).sort( sortOrder ).join( "" ) === expando;

// Initialize against the default document
setDocument();

// Support: Android <=4.0 - 4.1+
// Detached nodes confoundingly follow *each other*
support.sortDetached = assert( function( el ) {

	// Should return 1, but returns 4 (following)
	return el.compareDocumentPosition( document.createElement( "fieldset" ) ) & 1;
} );

jQuery.find = find;

// Deprecated
jQuery.expr[ ":" ] = jQuery.expr.pseudos;
jQuery.unique = jQuery.uniqueSort;

// These have always been private, but they used to be documented as part of
// Sizzle so let's maintain them for now for backwards compatibility purposes.
find.compile = compile;
find.select = select;
find.setDocument = setDocument;
find.tokenize = tokenize;

find.escape = jQuery.escapeSelector;
find.getText = jQuery.text;
find.isXML = jQuery.isXMLDoc;
find.selectors = jQuery.expr;
find.support = jQuery.support;
find.uniqueSort = jQuery.uniqueSort;

	/* eslint-enable */

} )();


var dir = function( elem, dir, until ) {
	var matched = [],
		truncate = until !== undefined;

	while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {
		if ( elem.nodeType === 1 ) {
			if ( truncate && jQuery( elem ).is( until ) ) {
				break;
			}
			matched.push( elem );
		}
	}
	return matched;
};


var siblings = function( n, elem ) {
	var matched = [];

	for ( ; n; n = n.nextSibling ) {
		if ( n.nodeType === 1 && n !== elem ) {
			matched.push( n );
		}
	}

	return matched;
};


var rneedsContext = jQuery.expr.match.needsContext;

var rsingleTag = ( /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i );



// Implement the identical functionality for filter and not
function winnow( elements, qualifier, not ) {
	if ( isFunction( qualifier ) ) {
		return jQuery.grep( elements, function( elem, i ) {
			return !!qualifier.call( elem, i, elem ) !== not;
		} );
	}

	// Single element
	if ( qualifier.nodeType ) {
		return jQuery.grep( elements, function( elem ) {
			return ( elem === qualifier ) !== not;
		} );
	}

	// Arraylike of elements (jQuery, arguments, Array)
	if ( typeof qualifier !== "string" ) {
		return jQuery.grep( elements, function( elem ) {
			return ( indexOf.call( qualifier, elem ) > -1 ) !== not;
		} );
	}

	// Filtered directly for both simple and complex selectors
	return jQuery.filter( qualifier, elements, not );
}

jQuery.filter = function( expr, elems, not ) {
	var elem = elems[ 0 ];

	if ( not ) {
		expr = ":not(" + expr + ")";
	}

	if ( elems.length === 1 && elem.nodeType === 1 ) {
		return jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [];
	}

	return jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
		return elem.nodeType === 1;
	} ) );
};

jQuery.fn.extend( {
	find: function( selector ) {
		var i, ret,
			len = this.length,
			self = this;

		if ( typeof selector !== "string" ) {
			return this.pushStack( jQuery( selector ).filter( function() {
				for ( i = 0; i < len; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			} ) );
		}

		ret = this.pushStack( [] );

		for ( i = 0; i < len; i++ ) {
			jQuery.find( selector, self[ i ], ret );
		}

		return len > 1 ? jQuery.uniqueSort( ret ) : ret;
	},
	filter: function( selector ) {
		return this.pushStack( winnow( this, selector || [], false ) );
	},
	not: function( selector ) {
		return this.pushStack( winnow( this, selector || [], true ) );
	},
	is: function( selector ) {
		return !!winnow(
			this,

			// If this is a positional/relative selector, check membership in the returned set
			// so $("p:first").is("p:last") won't return true for a doc with two "p".
			typeof selector === "string" && rneedsContext.test( selector ) ?
				jQuery( selector ) :
				selector || [],
			false
		).length;
	}
} );


// Initialize a jQuery object


// A central reference to the root jQuery(document)
var rootjQuery,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (trac-9521)
	// Strict HTML recognition (trac-11290: must start with <)
	// Shortcut simple #id case for speed
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,

	init = jQuery.fn.init = function( selector, context, root ) {
		var match, elem;

		// HANDLE: $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Method init() accepts an alternate rootjQuery
		// so migrate can support jQuery.sub (gh-2101)
		root = root || rootjQuery;

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector[ 0 ] === "<" &&
				selector[ selector.length - 1 ] === ">" &&
				selector.length >= 3 ) {

				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && ( match[ 1 ] || !context ) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[ 1 ] ) {
					context = context instanceof jQuery ? context[ 0 ] : context;

					// Option to run scripts is true for back-compat
					// Intentionally let the error be thrown if parseHTML is not present
					jQuery.merge( this, jQuery.parseHTML(
						match[ 1 ],
						context && context.nodeType ? context.ownerDocument || context : document,
						true
					) );

					// HANDLE: $(html, props)
					if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
						for ( match in context ) {

							// Properties of context are called as methods if possible
							if ( isFunction( this[ match ] ) ) {
								this[ match ]( context[ match ] );

							// ...and otherwise set as attributes
							} else {
								this.attr( match, context[ match ] );
							}
						}
					}

					return this;

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[ 2 ] );

					if ( elem ) {

						// Inject the element directly into the jQuery object
						this[ 0 ] = elem;
						this.length = 1;
					}
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || root ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(DOMElement)
		} else if ( selector.nodeType ) {
			this[ 0 ] = selector;
			this.length = 1;
			return this;

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( isFunction( selector ) ) {
			return root.ready !== undefined ?
				root.ready( selector ) :

				// Execute immediately if ready is not present
				selector( jQuery );
		}

		return jQuery.makeArray( selector, this );
	};

// Give the init function the jQuery prototype for later instantiation
init.prototype = jQuery.fn;

// Initialize central reference
rootjQuery = jQuery( document );


var rparentsprev = /^(?:parents|prev(?:Until|All))/,

	// Methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend( {
	has: function( target ) {
		var targets = jQuery( target, this ),
			l = targets.length;

		return this.filter( function() {
			var i = 0;
			for ( ; i < l; i++ ) {
				if ( jQuery.contains( this, targets[ i ] ) ) {
					return true;
				}
			}
		} );
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			matched = [],
			targets = typeof selectors !== "string" && jQuery( selectors );

		// Positional selectors never match, since there's no _selection_ context
		if ( !rneedsContext.test( selectors ) ) {
			for ( ; i < l; i++ ) {
				for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {

					// Always skip document fragments
					if ( cur.nodeType < 11 && ( targets ?
						targets.index( cur ) > -1 :

						// Don't pass non-elements to jQuery#find
						cur.nodeType === 1 &&
							jQuery.find.matchesSelector( cur, selectors ) ) ) {

						matched.push( cur );
						break;
					}
				}
			}
		}

		return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );
	},

	// Determine the position of an element within the set
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;
		}

		// Index in selector
		if ( typeof elem === "string" ) {
			return indexOf.call( jQuery( elem ), this[ 0 ] );
		}

		// Locate the position of the desired element
		return indexOf.call( this,

			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[ 0 ] : elem
		);
	},

	add: function( selector, context ) {
		return this.pushStack(
			jQuery.uniqueSort(
				jQuery.merge( this.get(), jQuery( selector, context ) )
			)
		);
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	}
} );

function sibling( cur, dir ) {
	while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}
	return cur;
}

jQuery.each( {
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, _i, until ) {
		return dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, _i, until ) {
		return dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, _i, until ) {
		return dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return siblings( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return siblings( elem.firstChild );
	},
	contents: function( elem ) {
		if ( elem.contentDocument != null &&

			// Support: IE 11+
			// <object> elements with no `data` attribute has an object
			// `contentDocument` with a `null` prototype.
			getProto( elem.contentDocument ) ) {

			return elem.contentDocument;
		}

		// Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
		// Treat the template element as a regular one in browsers that
		// don't support it.
		if ( nodeName( elem, "template" ) ) {
			elem = elem.content || elem;
		}

		return jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var matched = jQuery.map( this, fn, until );

		if ( name.slice( -5 ) !== "Until" ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			matched = jQuery.filter( selector, matched );
		}

		if ( this.length > 1 ) {

			// Remove duplicates
			if ( !guaranteedUnique[ name ] ) {
				jQuery.uniqueSort( matched );
			}

			// Reverse order for parents* and prev-derivatives
			if ( rparentsprev.test( name ) ) {
				matched.reverse();
			}
		}

		return this.pushStack( matched );
	};
} );
var rnothtmlwhite = ( /[^\x20\t\r\n\f]+/g );



// Convert String-formatted options into Object-formatted ones
function createOptions( options ) {
	var object = {};
	jQuery.each( options.match( rnothtmlwhite ) || [], function( _, flag ) {
		object[ flag ] = true;
	} );
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		createOptions( options ) :
		jQuery.extend( {}, options );

	var // Flag to know if list is currently firing
		firing,

		// Last fire value for non-forgettable lists
		memory,

		// Flag to know if list was already fired
		fired,

		// Flag to prevent firing
		locked,

		// Actual callback list
		list = [],

		// Queue of execution data for repeatable lists
		queue = [],

		// Index of currently firing callback (modified by add/remove as needed)
		firingIndex = -1,

		// Fire callbacks
		fire = function() {

			// Enforce single-firing
			locked = locked || options.once;

			// Execute callbacks for all pending executions,
			// respecting firingIndex overrides and runtime changes
			fired = firing = true;
			for ( ; queue.length; firingIndex = -1 ) {
				memory = queue.shift();
				while ( ++firingIndex < list.length ) {

					// Run callback and check for early termination
					if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&
						options.stopOnFalse ) {

						// Jump to end and forget the data so .add doesn't re-fire
						firingIndex = list.length;
						memory = false;
					}
				}
			}

			// Forget the data if we're done with it
			if ( !options.memory ) {
				memory = false;
			}

			firing = false;

			// Clean up if we're done firing for good
			if ( locked ) {

				// Keep an empty list if we have data for future add calls
				if ( memory ) {
					list = [];

				// Otherwise, this object is spent
				} else {
					list = "";
				}
			}
		},

		// Actual Callbacks object
		self = {

			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {

					// If we have memory from a past run, we should fire after adding
					if ( memory && !firing ) {
						firingIndex = list.length - 1;
						queue.push( memory );
					}

					( function add( args ) {
						jQuery.each( args, function( _, arg ) {
							if ( isFunction( arg ) ) {
								if ( !options.unique || !self.has( arg ) ) {
									list.push( arg );
								}
							} else if ( arg && arg.length && toType( arg ) !== "string" ) {

								// Inspect recursively
								add( arg );
							}
						} );
					} )( arguments );

					if ( memory && !firing ) {
						fire();
					}
				}
				return this;
			},

			// Remove a callback from the list
			remove: function() {
				jQuery.each( arguments, function( _, arg ) {
					var index;
					while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
						list.splice( index, 1 );

						// Handle firing indexes
						if ( index <= firingIndex ) {
							firingIndex--;
						}
					}
				} );
				return this;
			},

			// Check if a given callback is in the list.
			// If no argument is given, return whether or not list has callbacks attached.
			has: function( fn ) {
				return fn ?
					jQuery.inArray( fn, list ) > -1 :
					list.length > 0;
			},

			// Remove all callbacks from the list
			empty: function() {
				if ( list ) {
					list = [];
				}
				return this;
			},

			// Disable .fire and .add
			// Abort any current/pending executions
			// Clear all callbacks and values
			disable: function() {
				locked = queue = [];
				list = memory = "";
				return this;
			},
			disabled: function() {
				return !list;
			},

			// Disable .fire
			// Also disable .add unless we have memory (since it would have no effect)
			// Abort any pending executions
			lock: function() {
				locked = queue = [];
				if ( !memory && !firing ) {
					list = memory = "";
				}
				return this;
			},
			locked: function() {
				return !!locked;
			},

			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				if ( !locked ) {
					args = args || [];
					args = [ context, args.slice ? args.slice() : args ];
					queue.push( args );
					if ( !firing ) {
						fire();
					}
				}
				return this;
			},

			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},

			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};


function Identity( v ) {
	return v;
}
function Thrower( ex ) {
	throw ex;
}

function adoptValue( value, resolve, reject, noValue ) {
	var method;

	try {

		// Check for promise aspect first to privilege synchronous behavior
		if ( value && isFunction( ( method = value.promise ) ) ) {
			method.call( value ).done( resolve ).fail( reject );

		// Other thenables
		} else if ( value && isFunction( ( method = value.then ) ) ) {
			method.call( value, resolve, reject );

		// Other non-thenables
		} else {

			// Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:
			// * false: [ value ].slice( 0 ) => resolve( value )
			// * true: [ value ].slice( 1 ) => resolve()
			resolve.apply( undefined, [ value ].slice( noValue ) );
		}

	// For Promises/A+, convert exceptions into rejections
	// Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
	// Deferred#then to conditionally suppress rejection.
	} catch ( value ) {

		// Support: Android 4.0 only
		// Strict mode functions invoked without .call/.apply get global-object context
		reject.apply( undefined, [ value ] );
	}
}

jQuery.extend( {

	Deferred: function( func ) {
		var tuples = [

				// action, add listener, callbacks,
				// ... .then handlers, argument index, [final state]
				[ "notify", "progress", jQuery.Callbacks( "memory" ),
					jQuery.Callbacks( "memory" ), 2 ],
				[ "resolve", "done", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 0, "resolved" ],
				[ "reject", "fail", jQuery.Callbacks( "once memory" ),
					jQuery.Callbacks( "once memory" ), 1, "rejected" ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				"catch": function( fn ) {
					return promise.then( null, fn );
				},

				// Keep pipe for back-compat
				pipe: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;

					return jQuery.Deferred( function( newDefer ) {
						jQuery.each( tuples, function( _i, tuple ) {

							// Map tuples (progress, done, fail) to arguments (done, fail, progress)
							var fn = isFunction( fns[ tuple[ 4 ] ] ) && fns[ tuple[ 4 ] ];

							// deferred.progress(function() { bind to newDefer or newDefer.notify })
							// deferred.done(function() { bind to newDefer or newDefer.resolve })
							// deferred.fail(function() { bind to newDefer or newDefer.reject })
							deferred[ tuple[ 1 ] ]( function() {
								var returned = fn && fn.apply( this, arguments );
								if ( returned && isFunction( returned.promise ) ) {
									returned.promise()
										.progress( newDefer.notify )
										.done( newDefer.resolve )
										.fail( newDefer.reject );
								} else {
									newDefer[ tuple[ 0 ] + "With" ](
										this,
										fn ? [ returned ] : arguments
									);
								}
							} );
						} );
						fns = null;
					} ).promise();
				},
				then: function( onFulfilled, onRejected, onProgress ) {
					var maxDepth = 0;
					function resolve( depth, deferred, handler, special ) {
						return function() {
							var that = this,
								args = arguments,
								mightThrow = function() {
									var returned, then;

									// Support: Promises/A+ section 2.3.3.3.3
									// https://promisesaplus.com/#point-59
									// Ignore double-resolution attempts
									if ( depth < maxDepth ) {
										return;
									}

									returned = handler.apply( that, args );

									// Support: Promises/A+ section 2.3.1
									// https://promisesaplus.com/#point-48
									if ( returned === deferred.promise() ) {
										throw new TypeError( "Thenable self-resolution" );
									}

									// Support: Promises/A+ sections 2.3.3.1, 3.5
									// https://promisesaplus.com/#point-54
									// https://promisesaplus.com/#point-75
									// Retrieve `then` only once
									then = returned &&

										// Support: Promises/A+ section 2.3.4
										// https://promisesaplus.com/#point-64
										// Only check objects and functions for thenability
										( typeof returned === "object" ||
											typeof returned === "function" ) &&
										returned.then;

									// Handle a returned thenable
									if ( isFunction( then ) ) {

										// Special processors (notify) just wait for resolution
										if ( special ) {
											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special )
											);

										// Normal processors (resolve) also hook into progress
										} else {

											// ...and disregard older resolution values
											maxDepth++;

											then.call(
												returned,
												resolve( maxDepth, deferred, Identity, special ),
												resolve( maxDepth, deferred, Thrower, special ),
												resolve( maxDepth, deferred, Identity,
													deferred.notifyWith )
											);
										}

									// Handle all other returned values
									} else {

										// Only substitute handlers pass on context
										// and multiple values (non-spec behavior)
										if ( handler !== Identity ) {
											that = undefined;
											args = [ returned ];
										}

										// Process the value(s)
										// Default process is resolve
										( special || deferred.resolveWith )( that, args );
									}
								},

								// Only normal processors (resolve) catch and reject exceptions
								process = special ?
									mightThrow :
									function() {
										try {
											mightThrow();
										} catch ( e ) {

											if ( jQuery.Deferred.exceptionHook ) {
												jQuery.Deferred.exceptionHook( e,
													process.error );
											}

											// Support: Promises/A+ section 2.3.3.3.4.1
											// https://promisesaplus.com/#point-61
											// Ignore post-resolution exceptions
											if ( depth + 1 >= maxDepth ) {

												// Only substitute handlers pass on context
												// and multiple values (non-spec behavior)
												if ( handler !== Thrower ) {
													that = undefined;
													args = [ e ];
												}

												deferred.rejectWith( that, args );
											}
										}
									};

							// Support: Promises/A+ section 2.3.3.3.1
							// https://promisesaplus.com/#point-57
							// Re-resolve promises immediately to dodge false rejection from
							// subsequent errors
							if ( depth ) {
								process();
							} else {

								// Call an optional hook to record the error, in case of exception
								// since it's otherwise lost when execution goes async
								if ( jQuery.Deferred.getErrorHook ) {
									process.error = jQuery.Deferred.getErrorHook();

								// The deprecated alias of the above. While the name suggests
								// returning the stack, not an error instance, jQuery just passes
								// it directly to `console.warn` so both will work; an instance
								// just better cooperates with source maps.
								} else if ( jQuery.Deferred.getStackHook ) {
									process.error = jQuery.Deferred.getStackHook();
								}
								window.setTimeout( process );
							}
						};
					}

					return jQuery.Deferred( function( newDefer ) {

						// progress_handlers.add( ... )
						tuples[ 0 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onProgress ) ?
									onProgress :
									Identity,
								newDefer.notifyWith
							)
						);

						// fulfilled_handlers.add( ... )
						tuples[ 1 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onFulfilled ) ?
									onFulfilled :
									Identity
							)
						);

						// rejected_handlers.add( ... )
						tuples[ 2 ][ 3 ].add(
							resolve(
								0,
								newDefer,
								isFunction( onRejected ) ?
									onRejected :
									Thrower
							)
						);
					} ).promise();
				},

				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 5 ];

			// promise.progress = list.add
			// promise.done = list.add
			// promise.fail = list.add
			promise[ tuple[ 1 ] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add(
					function() {

						// state = "resolved" (i.e., fulfilled)
						// state = "rejected"
						state = stateString;
					},

					// rejected_callbacks.disable
					// fulfilled_callbacks.disable
					tuples[ 3 - i ][ 2 ].disable,

					// rejected_handlers.disable
					// fulfilled_handlers.disable
					tuples[ 3 - i ][ 3 ].disable,

					// progress_callbacks.lock
					tuples[ 0 ][ 2 ].lock,

					// progress_handlers.lock
					tuples[ 0 ][ 3 ].lock
				);
			}

			// progress_handlers.fire
			// fulfilled_handlers.fire
			// rejected_handlers.fire
			list.add( tuple[ 3 ].fire );

			// deferred.notify = function() { deferred.notifyWith(...) }
			// deferred.resolve = function() { deferred.resolveWith(...) }
			// deferred.reject = function() { deferred.rejectWith(...) }
			deferred[ tuple[ 0 ] ] = function() {
				deferred[ tuple[ 0 ] + "With" ]( this === deferred ? undefined : this, arguments );
				return this;
			};

			// deferred.notifyWith = list.fireWith
			// deferred.resolveWith = list.fireWith
			// deferred.rejectWith = list.fireWith
			deferred[ tuple[ 0 ] + "With" ] = list.fireWith;
		} );

		// Make the deferred a promise
		promise.promise( deferred );

		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}

		// All done!
		return deferred;
	},

	// Deferred helper
	when: function( singleValue ) {
		var

			// count of uncompleted subordinates
			remaining = arguments.length,

			// count of unprocessed arguments
			i = remaining,

			// subordinate fulfillment data
			resolveContexts = Array( i ),
			resolveValues = slice.call( arguments ),

			// the primary Deferred
			primary = jQuery.Deferred(),

			// subordinate callback factory
			updateFunc = function( i ) {
				return function( value ) {
					resolveContexts[ i ] = this;
					resolveValues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;
					if ( !( --remaining ) ) {
						primary.resolveWith( resolveContexts, resolveValues );
					}
				};
			};

		// Single- and empty arguments are adopted like Promise.resolve
		if ( remaining <= 1 ) {
			adoptValue( singleValue, primary.done( updateFunc( i ) ).resolve, primary.reject,
				!remaining );

			// Use .then() to unwrap secondary thenables (cf. gh-3000)
			if ( primary.state() === "pending" ||
				isFunction( resolveValues[ i ] && resolveValues[ i ].then ) ) {

				return primary.then();
			}
		}

		// Multiple arguments are aggregated like Promise.all array elements
		while ( i-- ) {
			adoptValue( resolveValues[ i ], updateFunc( i ), primary.reject );
		}

		return primary.promise();
	}
} );


// These usually indicate a programmer mistake during development,
// warn about them ASAP rather than swallowing them by default.
var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;

// If `jQuery.Deferred.getErrorHook` is defined, `asyncError` is an error
// captured before the async barrier to get the original error cause
// which may otherwise be hidden.
jQuery.Deferred.exceptionHook = function( error, asyncError ) {

	// Support: IE 8 - 9 only
	// Console exists when dev tools are open, which can happen at any time
	if ( window.console && window.console.warn && error && rerrorNames.test( error.name ) ) {
		window.console.warn( "jQuery.Deferred exception: " + error.message,
			error.stack, asyncError );
	}
};




jQuery.readyException = function( error ) {
	window.setTimeout( function() {
		throw error;
	} );
};




// The deferred used on DOM ready
var readyList = jQuery.Deferred();

jQuery.fn.ready = function( fn ) {

	readyList
		.then( fn )

		// Wrap jQuery.readyException in a function so that the lookup
		// happens at the time of error handling instead of callback
		// registration.
		.catch( function( error ) {
			jQuery.readyException( error );
		} );

	return this;
};

jQuery.extend( {

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See trac-6781
	readyWait: 1,

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );
	}
} );

jQuery.ready.then = readyList.then;

// The ready event handler and self cleanup method
function completed() {
	document.removeEventListener( "DOMContentLoaded", completed );
	window.removeEventListener( "load", completed );
	jQuery.ready();
}

// Catch cases where $(document).ready() is called
// after the browser event has already occurred.
// Support: IE <=9 - 10 only
// Older IE sometimes signals "interactive" too soon
if ( document.readyState === "complete" ||
	( document.readyState !== "loading" && !document.documentElement.doScroll ) ) {

	// Handle it asynchronously to allow scripts the opportunity to delay ready
	window.setTimeout( jQuery.ready );

} else {

	// Use the handy event callback
	document.addEventListener( "DOMContentLoaded", completed );

	// A fallback to window.onload, that will always work
	window.addEventListener( "load", completed );
}




// Multifunctional method to get and set values of a collection
// The value/s can optionally be executed if it's a function
var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {
	var i = 0,
		len = elems.length,
		bulk = key == null;

	// Sets many values
	if ( toType( key ) === "object" ) {
		chainable = true;
		for ( i in key ) {
			access( elems, fn, i, key[ i ], true, emptyGet, raw );
		}

	// Sets one value
	} else if ( value !== undefined ) {
		chainable = true;

		if ( !isFunction( value ) ) {
			raw = true;
		}

		if ( bulk ) {

			// Bulk operations run against the entire set
			if ( raw ) {
				fn.call( elems, value );
				fn = null;

			// ...except when executing function values
			} else {
				bulk = fn;
				fn = function( elem, _key, value ) {
					return bulk.call( jQuery( elem ), value );
				};
			}
		}

		if ( fn ) {
			for ( ; i < len; i++ ) {
				fn(
					elems[ i ], key, raw ?
						value :
						value.call( elems[ i ], i, fn( elems[ i ], key ) )
				);
			}
		}
	}

	if ( chainable ) {
		return elems;
	}

	// Gets
	if ( bulk ) {
		return fn.call( elems );
	}

	return len ? fn( elems[ 0 ], key ) : emptyGet;
};


// Matches dashed string for camelizing
var rmsPrefix = /^-ms-/,
	rdashAlpha = /-([a-z])/g;

// Used by camelCase as callback to replace()
function fcamelCase( _all, letter ) {
	return letter.toUpperCase();
}

// Convert dashed to camelCase; used by the css and data modules
// Support: IE <=9 - 11, Edge 12 - 15
// Microsoft forgot to hump their vendor prefix (trac-9572)
function camelCase( string ) {
	return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
}
var acceptData = function( owner ) {

	// Accepts only:
	//  - Node
	//    - Node.ELEMENT_NODE
	//    - Node.DOCUMENT_NODE
	//  - Object
	//    - Any
	return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );
};




function Data() {
	this.expando = jQuery.expando + Data.uid++;
}

Data.uid = 1;

Data.prototype = {

	cache: function( owner ) {

		// Check if the owner object already has a cache
		var value = owner[ this.expando ];

		// If not, create one
		if ( !value ) {
			value = {};

			// We can accept data for non-element nodes in modern browsers,
			// but we should not, see trac-8335.
			// Always return an empty object.
			if ( acceptData( owner ) ) {

				// If it is a node unlikely to be stringify-ed or looped over
				// use plain assignment
				if ( owner.nodeType ) {
					owner[ this.expando ] = value;

				// Otherwise secure it in a non-enumerable property
				// configurable must be true to allow the property to be
				// deleted when data is removed
				} else {
					Object.defineProperty( owner, this.expando, {
						value: value,
						configurable: true
					} );
				}
			}
		}

		return value;
	},
	set: function( owner, data, value ) {
		var prop,
			cache = this.cache( owner );

		// Handle: [ owner, key, value ] args
		// Always use camelCase key (gh-2257)
		if ( typeof data === "string" ) {
			cache[ camelCase( data ) ] = value;

		// Handle: [ owner, { properties } ] args
		} else {

			// Copy the properties one-by-one to the cache object
			for ( prop in data ) {
				cache[ camelCase( prop ) ] = data[ prop ];
			}
		}
		return cache;
	},
	get: function( owner, key ) {
		return key === undefined ?
			this.cache( owner ) :

			// Always use camelCase key (gh-2257)
			owner[ this.expando ] && owner[ this.expando ][ camelCase( key ) ];
	},
	access: function( owner, key, value ) {

		// In cases where either:
		//
		//   1. No key was specified
		//   2. A string key was specified, but no value provided
		//
		// Take the "read" path and allow the get method to determine
		// which value to return, respectively either:
		//
		//   1. The entire cache object
		//   2. The data stored at the key
		//
		if ( key === undefined ||
				( ( key && typeof key === "string" ) && value === undefined ) ) {

			return this.get( owner, key );
		}

		// When the key is not a string, or both a key and value
		// are specified, set or extend (existing objects) with either:
		//
		//   1. An object of properties
		//   2. A key and value
		//
		this.set( owner, key, value );

		// Since the "set" path can have two possible entry points
		// return the expected data based on which path was taken[*]
		return value !== undefined ? value : key;
	},
	remove: function( owner, key ) {
		var i,
			cache = owner[ this.expando ];

		if ( cache === undefined ) {
			return;
		}

		if ( key !== undefined ) {

			// Support array or space separated string of keys
			if ( Array.isArray( key ) ) {

				// If key is an array of keys...
				// We always set camelCase keys, so remove that.
				key = key.map( camelCase );
			} else {
				key = camelCase( key );

				// If a key with the spaces exists, use it.
				// Otherwise, create an array by matching non-whitespace
				key = key in cache ?
					[ key ] :
					( key.match( rnothtmlwhite ) || [] );
			}

			i = key.length;

			while ( i-- ) {
				delete cache[ key[ i ] ];
			}
		}

		// Remove the expando if there's no more data
		if ( key === undefined || jQuery.isEmptyObject( cache ) ) {

			// Support: Chrome <=35 - 45
			// Webkit & Blink performance suffers when deleting properties
			// from DOM nodes, so set to undefined instead
			// https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
			if ( owner.nodeType ) {
				owner[ this.expando ] = undefined;
			} else {
				delete owner[ this.expando ];
			}
		}
	},
	hasData: function( owner ) {
		var cache = owner[ this.expando ];
		return cache !== undefined && !jQuery.isEmptyObject( cache );
	}
};
var dataPriv = new Data();

var dataUser = new Data();



//	Implementation Summary
//
//	1. Enforce API surface and semantic compatibility with 1.9.x branch
//	2. Improve the module's maintainability by reducing the storage
//		paths to a single mechanism.
//	3. Use the same single mechanism to support "private" and "user" data.
//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
//	5. Avoid exposing implementation details on user objects (eg. expando properties)
//	6. Provide a clear path for implementation upgrade to WeakMap in 2014

var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
	rmultiDash = /[A-Z]/g;

function getData( data ) {
	if ( data === "true" ) {
		return true;
	}

	if ( data === "false" ) {
		return false;
	}

	if ( data === "null" ) {
		return null;
	}

	// Only convert to a number if it doesn't change the string
	if ( data === +data + "" ) {
		return +data;
	}

	if ( rbrace.test( data ) ) {
		return JSON.parse( data );
	}

	return data;
}

function dataAttr( elem, key, data ) {
	var name;

	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {
		name = "data-" + key.replace( rmultiDash, "-$&" ).toLowerCase();
		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = getData( data );
			} catch ( e ) {}

			// Make sure we set the data so it isn't changed later
			dataUser.set( elem, key, data );
		} else {
			data = undefined;
		}
	}
	return data;
}

jQuery.extend( {
	hasData: function( elem ) {
		return dataUser.hasData( elem ) || dataPriv.hasData( elem );
	},

	data: function( elem, name, data ) {
		return dataUser.access( elem, name, data );
	},

	removeData: function( elem, name ) {
		dataUser.remove( elem, name );
	},

	// TODO: Now that all calls to _data and _removeData have been replaced
	// with direct calls to dataPriv methods, these can be deprecated.
	_data: function( elem, name, data ) {
		return dataPriv.access( elem, name, data );
	},

	_removeData: function( elem, name ) {
		dataPriv.remove( elem, name );
	}
} );

jQuery.fn.extend( {
	data: function( key, value ) {
		var i, name, data,
			elem = this[ 0 ],
			attrs = elem && elem.attributes;

		// Gets all values
		if ( key === undefined ) {
			if ( this.length ) {
				data = dataUser.get( elem );

				if ( elem.nodeType === 1 && !dataPriv.get( elem, "hasDataAttrs" ) ) {
					i = attrs.length;
					while ( i-- ) {

						// Support: IE 11 only
						// The attrs elements can be null (trac-14894)
						if ( attrs[ i ] ) {
							name = attrs[ i ].name;
							if ( name.indexOf( "data-" ) === 0 ) {
								name = camelCase( name.slice( 5 ) );
								dataAttr( elem, name, data[ name ] );
							}
						}
					}
					dataPriv.set( elem, "hasDataAttrs", true );
				}
			}

			return data;
		}

		// Sets multiple values
		if ( typeof key === "object" ) {
			return this.each( function() {
				dataUser.set( this, key );
			} );
		}

		return access( this, function( value ) {
			var data;

			// The calling jQuery object (element matches) is not empty
			// (and therefore has an element appears at this[ 0 ]) and the
			// `value` parameter was not undefined. An empty jQuery object
			// will result in `undefined` for elem = this[ 0 ] which will
			// throw an exception if an attempt to read a data cache is made.
			if ( elem && value === undefined ) {

				// Attempt to get data from the cache
				// The key will always be camelCased in Data
				data = dataUser.get( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// Attempt to "discover" the data in
				// HTML5 custom data-* attrs
				data = dataAttr( elem, key );
				if ( data !== undefined ) {
					return data;
				}

				// We tried really hard, but the data doesn't exist.
				return;
			}

			// Set the data...
			this.each( function() {

				// We always store the camelCased key
				dataUser.set( this, key, value );
			} );
		}, null, value, arguments.length > 1, null, true );
	},

	removeData: function( key ) {
		return this.each( function() {
			dataUser.remove( this, key );
		} );
	}
} );


jQuery.extend( {
	queue: function( elem, type, data ) {
		var queue;

		if ( elem ) {
			type = ( type || "fx" ) + "queue";
			queue = dataPriv.get( elem, type );

			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !queue || Array.isArray( data ) ) {
					queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );
				} else {
					queue.push( data );
				}
			}
			return queue || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			startLength = queue.length,
			fn = queue.shift(),
			hooks = jQuery._queueHooks( elem, type ),
			next = function() {
				jQuery.dequeue( elem, type );
			};

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
			startLength--;
		}

		if ( fn ) {

			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift( "inprogress" );
			}

			// Clear up the last queue stop function
			delete hooks.stop;
			fn.call( elem, next, hooks );
		}

		if ( !startLength && hooks ) {
			hooks.empty.fire();
		}
	},

	// Not public - generate a queueHooks object, or return the current one
	_queueHooks: function( elem, type ) {
		var key = type + "queueHooks";
		return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {
			empty: jQuery.Callbacks( "once memory" ).add( function() {
				dataPriv.remove( elem, [ type + "queue", key ] );
			} )
		} );
	}
} );

jQuery.fn.extend( {
	queue: function( type, data ) {
		var setter = 2;

		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
			setter--;
		}

		if ( arguments.length < setter ) {
			return jQuery.queue( this[ 0 ], type );
		}

		return data === undefined ?
			this :
			this.each( function() {
				var queue = jQuery.queue( this, type, data );

				// Ensure a hooks for this queue
				jQuery._queueHooks( this, type );

				if ( type === "fx" && queue[ 0 ] !== "inprogress" ) {
					jQuery.dequeue( this, type );
				}
			} );
	},
	dequeue: function( type ) {
		return this.each( function() {
			jQuery.dequeue( this, type );
		} );
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},

	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, obj ) {
		var tmp,
			count = 1,
			defer = jQuery.Deferred(),
			elements = this,
			i = this.length,
			resolve = function() {
				if ( !( --count ) ) {
					defer.resolveWith( elements, [ elements ] );
				}
			};

		if ( typeof type !== "string" ) {
			obj = type;
			type = undefined;
		}
		type = type || "fx";

		while ( i-- ) {
			tmp = dataPriv.get( elements[ i ], type + "queueHooks" );
			if ( tmp && tmp.empty ) {
				count++;
				tmp.empty.add( resolve );
			}
		}
		resolve();
		return defer.promise( obj );
	}
} );
var pnum = ( /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/ ).source;

var rcssNum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" );


var cssExpand = [ "Top", "Right", "Bottom", "Left" ];

var documentElement = document.documentElement;



	var isAttached = function( elem ) {
			return jQuery.contains( elem.ownerDocument, elem );
		},
		composed = { composed: true };

	// Support: IE 9 - 11+, Edge 12 - 18+, iOS 10.0 - 10.2 only
	// Check attachment across shadow DOM boundaries when possible (gh-3504)
	// Support: iOS 10.0-10.2 only
	// Early iOS 10 versions support `attachShadow` but not `getRootNode`,
	// leading to errors. We need to check for `getRootNode`.
	if ( documentElement.getRootNode ) {
		isAttached = function( elem ) {
			return jQuery.contains( elem.ownerDocument, elem ) ||
				elem.getRootNode( composed ) === elem.ownerDocument;
		};
	}
var isHiddenWithinTree = function( elem, el ) {

		// isHiddenWithinTree might be called from jQuery#filter function;
		// in that case, element will be second argument
		elem = el || elem;

		// Inline style trumps all
		return elem.style.display === "none" ||
			elem.style.display === "" &&

			// Otherwise, check computed style
			// Support: Firefox <=43 - 45
			// Disconnected elements can have computed display: none, so first confirm that elem is
			// in the document.
			isAttached( elem ) &&

			jQuery.css( elem, "display" ) === "none";
	};



function adjustCSS( elem, prop, valueParts, tween ) {
	var adjusted, scale,
		maxIterations = 20,
		currentValue = tween ?
			function() {
				return tween.cur();
			} :
			function() {
				return jQuery.css( elem, prop, "" );
			},
		initial = currentValue(),
		unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),

		// Starting value computation is required for potential unit mismatches
		initialInUnit = elem.nodeType &&
			( jQuery.cssNumber[ prop ] || unit !== "px" && +initial ) &&
			rcssNum.exec( jQuery.css( elem, prop ) );

	if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {

		// Support: Firefox <=54
		// Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
		initial = initial / 2;

		// Trust units reported by jQuery.css
		unit = unit || initialInUnit[ 3 ];

		// Iteratively approximate from a nonzero starting point
		initialInUnit = +initial || 1;

		while ( maxIterations-- ) {

			// Evaluate and update our best guess (doubling guesses that zero out).
			// Finish if the scale equals or crosses 1 (making the old*new product non-positive).
			jQuery.style( elem, prop, initialInUnit + unit );
			if ( ( 1 - scale ) * ( 1 - ( scale = currentValue() / initial || 0.5 ) ) <= 0 ) {
				maxIterations = 0;
			}
			initialInUnit = initialInUnit / scale;

		}

		initialInUnit = initialInUnit * 2;
		jQuery.style( elem, prop, initialInUnit + unit );

		// Make sure we update the tween properties later on
		valueParts = valueParts || [];
	}

	if ( valueParts ) {
		initialInUnit = +initialInUnit || +initial || 0;

		// Apply relative offset (+=/-=) if specified
		adjusted = valueParts[ 1 ] ?
			initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :
			+valueParts[ 2 ];
		if ( tween ) {
			tween.unit = unit;
			tween.start = initialInUnit;
			tween.end = adjusted;
		}
	}
	return adjusted;
}


var defaultDisplayMap = {};

function getDefaultDisplay( elem ) {
	var temp,
		doc = elem.ownerDocument,
		nodeName = elem.nodeName,
		display = defaultDisplayMap[ nodeName ];

	if ( display ) {
		return display;
	}

	temp = doc.body.appendChild( doc.createElement( nodeName ) );
	display = jQuery.css( temp, "display" );

	temp.parentNode.removeChild( temp );

	if ( display === "none" ) {
		display = "block";
	}
	defaultDisplayMap[ nodeName ] = display;

	return display;
}

function showHide( elements, show ) {
	var display, elem,
		values = [],
		index = 0,
		length = elements.length;

	// Determine new display value for elements that need to change
	for ( ; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}

		display = elem.style.display;
		if ( show ) {

			// Since we force visibility upon cascade-hidden elements, an immediate (and slow)
			// check is required in this first loop unless we have a nonempty display value (either
			// inline or about-to-be-restored)
			if ( display === "none" ) {
				values[ index ] = dataPriv.get( elem, "display" ) || null;
				if ( !values[ index ] ) {
					elem.style.display = "";
				}
			}
			if ( elem.style.display === "" && isHiddenWithinTree( elem ) ) {
				values[ index ] = getDefaultDisplay( elem );
			}
		} else {
			if ( display !== "none" ) {
				values[ index ] = "none";

				// Remember what we're overwriting
				dataPriv.set( elem, "display", display );
			}
		}
	}

	// Set the display of the elements in a second loop to avoid constant reflow
	for ( index = 0; index < length; index++ ) {
		if ( values[ index ] != null ) {
			elements[ index ].style.display = values[ index ];
		}
	}

	return elements;
}

jQuery.fn.extend( {
	show: function() {
		return showHide( this, true );
	},
	hide: function() {
		return showHide( this );
	},
	toggle: function( state ) {
		if ( typeof state === "boolean" ) {
			return state ? this.show() : this.hide();
		}

		return this.each( function() {
			if ( isHiddenWithinTree( this ) ) {
				jQuery( this ).show();
			} else {
				jQuery( this ).hide();
			}
		} );
	}
} );
var rcheckableType = ( /^(?:checkbox|radio)$/i );

var rtagName = ( /<([a-z][^\/\0>\x20\t\r\n\f]*)/i );

var rscriptType = ( /^$|^module$|\/(?:java|ecma)script/i );



( function() {
	var fragment = document.createDocumentFragment(),
		div = fragment.appendChild( document.createElement( "div" ) ),
		input = document.createElement( "input" );

	// Support: Android 4.0 - 4.3 only
	// Check state lost if the name is set (trac-11217)
	// Support: Windows Web Apps (WWA)
	// `name` and `type` must use .setAttribute for WWA (trac-14901)
	input.setAttribute( "type", "radio" );
	input.setAttribute( "checked", "checked" );
	input.setAttribute( "name", "t" );

	div.appendChild( input );

	// Support: Android <=4.1 only
	// Older WebKit doesn't clone checked state correctly in fragments
	support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;

	// Support: IE <=11 only
	// Make sure textarea (and checkbox) defaultValue is properly cloned
	div.innerHTML = "<textarea>x</textarea>";
	support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;

	// Support: IE <=9 only
	// IE <=9 replaces <option> tags with their contents when inserted outside of
	// the select element.
	div.innerHTML = "<option></option>";
	support.option = !!div.lastChild;
} )();


// We have to close these tags to support XHTML (trac-13200)
var wrapMap = {

	// XHTML parsers do not magically insert elements in the
	// same way that tag soup parsers do. So we cannot shorten
	// this by omitting <tbody> or other required elements.
	thead: [ 1, "<table>", "</table>" ],
	col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
	tr: [ 2, "<table><tbody>", "</tbody></table>" ],
	td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],

	_default: [ 0, "", "" ]
};

wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;

// Support: IE <=9 only
if ( !support.option ) {
	wrapMap.optgroup = wrapMap.option = [ 1, "<select multiple='multiple'>", "</select>" ];
}


function getAll( context, tag ) {

	// Support: IE <=9 - 11 only
	// Use typeof to avoid zero-argument method invocation on host objects (trac-15151)
	var ret;

	if ( typeof context.getElementsByTagName !== "undefined" ) {
		ret = context.getElementsByTagName( tag || "*" );

	} else if ( typeof context.querySelectorAll !== "undefined" ) {
		ret = context.querySelectorAll( tag || "*" );

	} else {
		ret = [];
	}

	if ( tag === undefined || tag && nodeName( context, tag ) ) {
		return jQuery.merge( [ context ], ret );
	}

	return ret;
}


// Mark scripts as having already been evaluated
function setGlobalEval( elems, refElements ) {
	var i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		dataPriv.set(
			elems[ i ],
			"globalEval",
			!refElements || dataPriv.get( refElements[ i ], "globalEval" )
		);
	}
}


var rhtml = /<|&#?\w+;/;

function buildFragment( elems, context, scripts, selection, ignored ) {
	var elem, tmp, tag, wrap, attached, j,
		fragment = context.createDocumentFragment(),
		nodes = [],
		i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		elem = elems[ i ];

		if ( elem || elem === 0 ) {

			// Add nodes directly
			if ( toType( elem ) === "object" ) {

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );

			// Convert non-html into a text node
			} else if ( !rhtml.test( elem ) ) {
				nodes.push( context.createTextNode( elem ) );

			// Convert html into DOM nodes
			} else {
				tmp = tmp || fragment.appendChild( context.createElement( "div" ) );

				// Deserialize a standard representation
				tag = ( rtagName.exec( elem ) || [ "", "" ] )[ 1 ].toLowerCase();
				wrap = wrapMap[ tag ] || wrapMap._default;
				tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];

				// Descend through wrappers to the right content
				j = wrap[ 0 ];
				while ( j-- ) {
					tmp = tmp.lastChild;
				}

				// Support: Android <=4.0 only, PhantomJS 1 only
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, tmp.childNodes );

				// Remember the top-level container
				tmp = fragment.firstChild;

				// Ensure the created nodes are orphaned (trac-12392)
				tmp.textContent = "";
			}
		}
	}

	// Remove wrapper from fragment
	fragment.textContent = "";

	i = 0;
	while ( ( elem = nodes[ i++ ] ) ) {

		// Skip elements already in the context collection (trac-4087)
		if ( selection && jQuery.inArray( elem, selection ) > -1 ) {
			if ( ignored ) {
				ignored.push( elem );
			}
			continue;
		}

		attached = isAttached( elem );

		// Append to fragment
		tmp = getAll( fragment.appendChild( elem ), "script" );

		// Preserve script evaluation history
		if ( attached ) {
			setGlobalEval( tmp );
		}

		// Capture executables
		if ( scripts ) {
			j = 0;
			while ( ( elem = tmp[ j++ ] ) ) {
				if ( rscriptType.test( elem.type || "" ) ) {
					scripts.push( elem );
				}
			}
		}
	}

	return fragment;
}


var rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

function returnTrue() {
	return true;
}

function returnFalse() {
	return false;
}

function on( elem, types, selector, data, fn, one ) {
	var origFn, type;

	// Types can be a map of types/handlers
	if ( typeof types === "object" ) {

		// ( types-Object, selector, data )
		if ( typeof selector !== "string" ) {

			// ( types-Object, data )
			data = data || selector;
			selector = undefined;
		}
		for ( type in types ) {
			on( elem, type, selector, data, types[ type ], one );
		}
		return elem;
	}

	if ( data == null && fn == null ) {

		// ( types, fn )
		fn = selector;
		data = selector = undefined;
	} else if ( fn == null ) {
		if ( typeof selector === "string" ) {

			// ( types, selector, fn )
			fn = data;
			data = undefined;
		} else {

			// ( types, data, fn )
			fn = data;
			data = selector;
			selector = undefined;
		}
	}
	if ( fn === false ) {
		fn = returnFalse;
	} else if ( !fn ) {
		return elem;
	}

	if ( one === 1 ) {
		origFn = fn;
		fn = function( event ) {

			// Can use an empty set, since event contains the info
			jQuery().off( event );
			return origFn.apply( this, arguments );
		};

		// Use same guid so caller can remove using origFn
		fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
	}
	return elem.each( function() {
		jQuery.event.add( this, types, fn, data, selector );
	} );
}

/*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */
jQuery.event = {

	global: {},

	add: function( elem, types, handler, data, selector ) {

		var handleObjIn, eventHandle, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.get( elem );

		// Only attach events to objects that accept data
		if ( !acceptData( elem ) ) {
			return;
		}

		// Caller can pass in an object of custom data in lieu of the handler
		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
			selector = handleObjIn.selector;
		}

		// Ensure that invalid selectors throw exceptions at attach time
		// Evaluate against documentElement in case elem is a non-element node (e.g., document)
		if ( selector ) {
			jQuery.find.matchesSelector( documentElement, selector );
		}

		// Make sure that the handler has a unique ID, used to find/remove it later
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure and main handler, if this is the first
		if ( !( events = elemData.events ) ) {
			events = elemData.events = Object.create( null );
		}
		if ( !( eventHandle = elemData.handle ) ) {
			eventHandle = elemData.handle = function( e ) {

				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ?
					jQuery.event.dispatch.apply( elem, arguments ) : undefined;
			};
		}

		// Handle multiple events separated by a space
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// There *must* be a type, no attaching namespace-only handlers
			if ( !type ) {
				continue;
			}

			// If event changes its type, use the special event handlers for the changed type
			special = jQuery.event.special[ type ] || {};

			// If selector defined, determine special event api type, otherwise given type
			type = ( selector ? special.delegateType : special.bindType ) || type;

			// Update special based on newly reset type
			special = jQuery.event.special[ type ] || {};

			// handleObj is passed to all event handlers
			handleObj = jQuery.extend( {
				type: type,
				origType: origType,
				data: data,
				handler: handler,
				guid: handler.guid,
				selector: selector,
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
				namespace: namespaces.join( "." )
			}, handleObjIn );

			// Init the event handler queue if we're the first
			if ( !( handlers = events[ type ] ) ) {
				handlers = events[ type ] = [];
				handlers.delegateCount = 0;

				// Only use addEventListener if the special events handler returns false
				if ( !special.setup ||
					special.setup.call( elem, data, namespaces, eventHandle ) === false ) {

					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add to the element's handler list, delegates in front
			if ( selector ) {
				handlers.splice( handlers.delegateCount++, 0, handleObj );
			} else {
				handlers.push( handleObj );
			}

			// Keep track of which events have ever been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

	},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, selector, mappedTypes ) {

		var j, origCount, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );

		if ( !elemData || !( events = elemData.events ) ) {
			return;
		}

		// Once for each type.namespace in types; type may be omitted
		types = ( types || "" ).match( rnothtmlwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// Unbind all events (on this namespace, if provided) for the element
			if ( !type ) {
				for ( type in events ) {
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
				}
				continue;
			}

			special = jQuery.event.special[ type ] || {};
			type = ( selector ? special.delegateType : special.bindType ) || type;
			handlers = events[ type ] || [];
			tmp = tmp[ 2 ] &&
				new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" );

			// Remove matching events
			origCount = j = handlers.length;
			while ( j-- ) {
				handleObj = handlers[ j ];

				if ( ( mappedTypes || origType === handleObj.origType ) &&
					( !handler || handler.guid === handleObj.guid ) &&
					( !tmp || tmp.test( handleObj.namespace ) ) &&
					( !selector || selector === handleObj.selector ||
						selector === "**" && handleObj.selector ) ) {
					handlers.splice( j, 1 );

					if ( handleObj.selector ) {
						handlers.delegateCount--;
					}
					if ( special.remove ) {
						special.remove.call( elem, handleObj );
					}
				}
			}

			// Remove generic event handler if we removed something and no more handlers exist
			// (avoids potential for endless recursion during removal of special event handlers)
			if ( origCount && !handlers.length ) {
				if ( !special.teardown ||
					special.teardown.call( elem, namespaces, elemData.handle ) === false ) {

					jQuery.removeEvent( elem, type, elemData.handle );
				}

				delete events[ type ];
			}
		}

		// Remove data and the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			dataPriv.remove( elem, "handle events" );
		}
	},

	dispatch: function( nativeEvent ) {

		var i, j, ret, matched, handleObj, handlerQueue,
			args = new Array( arguments.length ),

			// Make a writable jQuery.Event from the native event object
			event = jQuery.event.fix( nativeEvent ),

			handlers = (
				dataPriv.get( this, "events" ) || Object.create( null )
			)[ event.type ] || [],
			special = jQuery.event.special[ event.type ] || {};

		// Use the fix-ed jQuery.Event rather than the (read-only) native event
		args[ 0 ] = event;

		for ( i = 1; i < arguments.length; i++ ) {
			args[ i ] = arguments[ i ];
		}

		event.delegateTarget = this;

		// Call the preDispatch hook for the mapped type, and let it bail if desired
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
			return;
		}

		// Determine handlers
		handlerQueue = jQuery.event.handlers.call( this, event, handlers );

		// Run delegates first; they may want to stop propagation beneath us
		i = 0;
		while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {
			event.currentTarget = matched.elem;

			j = 0;
			while ( ( handleObj = matched.handlers[ j++ ] ) &&
				!event.isImmediatePropagationStopped() ) {

				// If the event is namespaced, then each handler is only invoked if it is
				// specially universal or its namespaces are a superset of the event's.
				if ( !event.rnamespace || handleObj.namespace === false ||
					event.rnamespace.test( handleObj.namespace ) ) {

					event.handleObj = handleObj;
					event.data = handleObj.data;

					ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||
						handleObj.handler ).apply( matched.elem, args );

					if ( ret !== undefined ) {
						if ( ( event.result = ret ) === false ) {
							event.preventDefault();
							event.stopPropagation();
						}
					}
				}
			}
		}

		// Call the postDispatch hook for the mapped type
		if ( special.postDispatch ) {
			special.postDispatch.call( this, event );
		}

		return event.result;
	},

	handlers: function( event, handlers ) {
		var i, handleObj, sel, matchedHandlers, matchedSelectors,
			handlerQueue = [],
			delegateCount = handlers.delegateCount,
			cur = event.target;

		// Find delegate handlers
		if ( delegateCount &&

			// Support: IE <=9
			// Black-hole SVG <use> instance trees (trac-13180)
			cur.nodeType &&

			// Support: Firefox <=42
			// Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
			// https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
			// Support: IE 11 only
			// ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
			!( event.type === "click" && event.button >= 1 ) ) {

			for ( ; cur !== this; cur = cur.parentNode || this ) {

				// Don't check non-elements (trac-13208)
				// Don't process clicks on disabled elements (trac-6911, trac-8165, trac-11382, trac-11764)
				if ( cur.nodeType === 1 && !( event.type === "click" && cur.disabled === true ) ) {
					matchedHandlers = [];
					matchedSelectors = {};
					for ( i = 0; i < delegateCount; i++ ) {
						handleObj = handlers[ i ];

						// Don't conflict with Object.prototype properties (trac-13203)
						sel = handleObj.selector + " ";

						if ( matchedSelectors[ sel ] === undefined ) {
							matchedSelectors[ sel ] = handleObj.needsContext ?
								jQuery( sel, this ).index( cur ) > -1 :
								jQuery.find( sel, this, null, [ cur ] ).length;
						}
						if ( matchedSelectors[ sel ] ) {
							matchedHandlers.push( handleObj );
						}
					}
					if ( matchedHandlers.length ) {
						handlerQueue.push( { elem: cur, handlers: matchedHandlers } );
					}
				}
			}
		}

		// Add the remaining (directly-bound) handlers
		cur = this;
		if ( delegateCount < handlers.length ) {
			handlerQueue.push( { elem: cur, handlers: handlers.slice( delegateCount ) } );
		}

		return handlerQueue;
	},

	addProp: function( name, hook ) {
		Object.defineProperty( jQuery.Event.prototype, name, {
			enumerable: true,
			configurable: true,

			get: isFunction( hook ) ?
				function() {
					if ( this.originalEvent ) {
						return hook( this.originalEvent );
					}
				} :
				function() {
					if ( this.originalEvent ) {
						return this.originalEvent[ name ];
					}
				},

			set: function( value ) {
				Object.defineProperty( this, name, {
					enumerable: true,
					configurable: true,
					writable: true,
					value: value
				} );
			}
		} );
	},

	fix: function( originalEvent ) {
		return originalEvent[ jQuery.expando ] ?
			originalEvent :
			new jQuery.Event( originalEvent );
	},

	special: {
		load: {

			// Prevent triggered image.load events from bubbling to window.load
			noBubble: true
		},
		click: {

			// Utilize native event to ensure correct state for checkable inputs
			setup: function( data ) {

				// For mutual compressibility with _default, replace `this` access with a local var.
				// `|| data` is dead code meant only to preserve the variable through minification.
				var el = this || data;

				// Claim the first handler
				if ( rcheckableType.test( el.type ) &&
					el.click && nodeName( el, "input" ) ) {

					// dataPriv.set( el, "click", ... )
					leverageNative( el, "click", true );
				}

				// Return false to allow normal processing in the caller
				return false;
			},
			trigger: function( data ) {

				// For mutual compressibility with _default, replace `this` access with a local var.
				// `|| data` is dead code meant only to preserve the variable through minification.
				var el = this || data;

				// Force setup before triggering a click
				if ( rcheckableType.test( el.type ) &&
					el.click && nodeName( el, "input" ) ) {

					leverageNative( el, "click" );
				}

				// Return non-false to allow normal event-path propagation
				return true;
			},

			// For cross-browser consistency, suppress native .click() on links
			// Also prevent it if we're currently inside a leveraged native-event stack
			_default: function( event ) {
				var target = event.target;
				return rcheckableType.test( target.type ) &&
					target.click && nodeName( target, "input" ) &&
					dataPriv.get( target, "click" ) ||
					nodeName( target, "a" );
			}
		},

		beforeunload: {
			postDispatch: function( event ) {

				// Support: Firefox 20+
				// Firefox doesn't alert if the returnValue field is not set.
				if ( event.result !== undefined && event.originalEvent ) {
					event.originalEvent.returnValue = event.result;
				}
			}
		}
	}
};

// Ensure the presence of an event listener that handles manually-triggered
// synthetic events by interrupting progress until reinvoked in response to
// *native* events that it fires directly, ensuring that state changes have
// already occurred before other listeners are invoked.
function leverageNative( el, type, isSetup ) {

	// Missing `isSetup` indicates a trigger call, which must force setup through jQuery.event.add
	if ( !isSetup ) {
		if ( dataPriv.get( el, type ) === undefined ) {
			jQuery.event.add( el, type, returnTrue );
		}
		return;
	}

	// Register the controller as a special universal handler for all event namespaces
	dataPriv.set( el, type, false );
	jQuery.event.add( el, type, {
		namespace: false,
		handler: function( event ) {
			var result,
				saved = dataPriv.get( this, type );

			if ( ( event.isTrigger & 1 ) && this[ type ] ) {

				// Interrupt processing of the outer synthetic .trigger()ed event
				if ( !saved ) {

					// Store arguments for use when handling the inner native event
					// There will always be at least one argument (an event object), so this array
					// will not be confused with a leftover capture object.
					saved = slice.call( arguments );
					dataPriv.set( this, type, saved );

					// Trigger the native event and capture its result
					this[ type ]();
					result = dataPriv.get( this, type );
					dataPriv.set( this, type, false );

					if ( saved !== result ) {

						// Cancel the outer synthetic event
						event.stopImmediatePropagation();
						event.preventDefault();

						return result;
					}

				// If this is an inner synthetic event for an event with a bubbling surrogate
				// (focus or blur), assume that the surrogate already propagated from triggering
				// the native event and prevent that from happening again here.
				// This technically gets the ordering wrong w.r.t. to `.trigger()` (in which the
				// bubbling surrogate propagates *after* the non-bubbling base), but that seems
				// less bad than duplication.
				} else if ( ( jQuery.event.special[ type ] || {} ).delegateType ) {
					event.stopPropagation();
				}

			// If this is a native event triggered above, everything is now in order
			// Fire an inner synthetic event with the original arguments
			} else if ( saved ) {

				// ...and capture the result
				dataPriv.set( this, type, jQuery.event.trigger(
					saved[ 0 ],
					saved.slice( 1 ),
					this
				) );

				// Abort handling of the native event by all jQuery handlers while allowing
				// native handlers on the same element to run. On target, this is achieved
				// by stopping immediate propagation just on the jQuery event. However,
				// the native event is re-wrapped by a jQuery one on each level of the
				// propagation so the only way to stop it for jQuery is to stop it for
				// everyone via native `stopPropagation()`. This is not a problem for
				// focus/blur which don't bubble, but it does also stop click on checkboxes
				// and radios. We accept this limitation.
				event.stopPropagation();
				event.isImmediatePropagationStopped = returnTrue;
			}
		}
	} );
}

jQuery.removeEvent = function( elem, type, handle ) {

	// This "if" is needed for plain objects
	if ( elem.removeEventListener ) {
		elem.removeEventListener( type, handle );
	}
};

jQuery.Event = function( src, props ) {

	// Allow instantiation without the 'new' keyword
	if ( !( this instanceof jQuery.Event ) ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = src.defaultPrevented ||
				src.defaultPrevented === undefined &&

				// Support: Android <=2.3 only
				src.returnValue === false ?
			returnTrue :
			returnFalse;

		// Create target properties
		// Support: Safari <=6 - 7 only
		// Target should not be a text node (trac-504, trac-13143)
		this.target = ( src.target && src.target.nodeType === 3 ) ?
			src.target.parentNode :
			src.target;

		this.currentTarget = src.currentTarget;
		this.relatedTarget = src.relatedTarget;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Create a timestamp if incoming event doesn't have one
	this.timeStamp = src && src.timeStamp || Date.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	constructor: jQuery.Event,
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse,
	isSimulated: false,

	preventDefault: function() {
		var e = this.originalEvent;

		this.isDefaultPrevented = returnTrue;

		if ( e && !this.isSimulated ) {
			e.preventDefault();
		}
	},
	stopPropagation: function() {
		var e = this.originalEvent;

		this.isPropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopPropagation();
		}
	},
	stopImmediatePropagation: function() {
		var e = this.originalEvent;

		this.isImmediatePropagationStopped = returnTrue;

		if ( e && !this.isSimulated ) {
			e.stopImmediatePropagation();
		}

		this.stopPropagation();
	}
};

// Includes all common event props including KeyEvent and MouseEvent specific props
jQuery.each( {
	altKey: true,
	bubbles: true,
	cancelable: true,
	changedTouches: true,
	ctrlKey: true,
	detail: true,
	eventPhase: true,
	metaKey: true,
	pageX: true,
	pageY: true,
	shiftKey: true,
	view: true,
	"char": true,
	code: true,
	charCode: true,
	key: true,
	keyCode: true,
	button: true,
	buttons: true,
	clientX: true,
	clientY: true,
	offsetX: true,
	offsetY: true,
	pointerId: true,
	pointerType: true,
	screenX: true,
	screenY: true,
	targetTouches: true,
	toElement: true,
	touches: true,
	which: true
}, jQuery.event.addProp );

jQuery.each( { focus: "focusin", blur: "focusout" }, function( type, delegateType ) {

	function focusMappedHandler( nativeEvent ) {
		if ( document.documentMode ) {

			// Support: IE 11+
			// Attach a single focusin/focusout handler on the document while someone wants
			// focus/blur. This is because the former are synchronous in IE while the latter
			// are async. In other browsers, all those handlers are invoked synchronously.

			// `handle` from private data would already wrap the event, but we need
			// to change the `type` here.
			var handle = dataPriv.get( this, "handle" ),
				event = jQuery.event.fix( nativeEvent );
			event.type = nativeEvent.type === "focusin" ? "focus" : "blur";
			event.isSimulated = true;

			// First, handle focusin/focusout
			handle( nativeEvent );

			// ...then, handle focus/blur
			//
			// focus/blur don't bubble while focusin/focusout do; simulate the former by only
			// invoking the handler at the lower level.
			if ( event.target === event.currentTarget ) {

				// The setup part calls `leverageNative`, which, in turn, calls
				// `jQuery.event.add`, so event handle will already have been set
				// by this point.
				handle( event );
			}
		} else {

			// For non-IE browsers, attach a single capturing handler on the document
			// while someone wants focusin/focusout.
			jQuery.event.simulate( delegateType, nativeEvent.target,
				jQuery.event.fix( nativeEvent ) );
		}
	}

	jQuery.event.special[ type ] = {

		// Utilize native event if possible so blur/focus sequence is correct
		setup: function() {

			var attaches;

			// Claim the first handler
			// dataPriv.set( this, "focus", ... )
			// dataPriv.set( this, "blur", ... )
			leverageNative( this, type, true );

			if ( document.documentMode ) {

				// Support: IE 9 - 11+
				// We use the same native handler for focusin & focus (and focusout & blur)
				// so we need to coordinate setup & teardown parts between those events.
				// Use `delegateType` as the key as `type` is already used by `leverageNative`.
				attaches = dataPriv.get( this, delegateType );
				if ( !attaches ) {
					this.addEventListener( delegateType, focusMappedHandler );
				}
				dataPriv.set( this, delegateType, ( attaches || 0 ) + 1 );
			} else {

				// Return false to allow normal processing in the caller
				return false;
			}
		},
		trigger: function() {

			// Force setup before trigger
			leverageNative( this, type );

			// Return non-false to allow normal event-path propagation
			return true;
		},

		teardown: function() {
			var attaches;

			if ( document.documentMode ) {
				attaches = dataPriv.get( this, delegateType ) - 1;
				if ( !attaches ) {
					this.removeEventListener( delegateType, focusMappedHandler );
					dataPriv.remove( this, delegateType );
				} else {
					dataPriv.set( this, delegateType, attaches );
				}
			} else {

				// Return false to indicate standard teardown should be applied
				return false;
			}
		},

		// Suppress native focus or blur if we're currently inside
		// a leveraged native-event stack
		_default: function( event ) {
			return dataPriv.get( event.target, type );
		},

		delegateType: delegateType
	};

	// Support: Firefox <=44
	// Firefox doesn't have focus(in | out) events
	// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
	//
	// Support: Chrome <=48 - 49, Safari <=9.0 - 9.1
	// focus(in | out) events fire after focus & blur events,
	// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
	// Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857
	//
	// Support: IE 9 - 11+
	// To preserve relative focusin/focus & focusout/blur event order guaranteed on the 3.x branch,
	// attach a single handler for both events in IE.
	jQuery.event.special[ delegateType ] = {
		setup: function() {

			// Handle: regular nodes (via `this.ownerDocument`), window
			// (via `this.document`) & document (via `this`).
			var doc = this.ownerDocument || this.document || this,
				dataHolder = document.documentMode ? this : doc,
				attaches = dataPriv.get( dataHolder, delegateType );

			// Support: IE 9 - 11+
			// We use the same native handler for focusin & focus (and focusout & blur)
			// so we need to coordinate setup & teardown parts between those events.
			// Use `delegateType` as the key as `type` is already used by `leverageNative`.
			if ( !attaches ) {
				if ( document.documentMode ) {
					this.addEventListener( delegateType, focusMappedHandler );
				} else {
					doc.addEventListener( type, focusMappedHandler, true );
				}
			}
			dataPriv.set( dataHolder, delegateType, ( attaches || 0 ) + 1 );
		},
		teardown: function() {
			var doc = this.ownerDocument || this.document || this,
				dataHolder = document.documentMode ? this : doc,
				attaches = dataPriv.get( dataHolder, delegateType ) - 1;

			if ( !attaches ) {
				if ( document.documentMode ) {
					this.removeEventListener( delegateType, focusMappedHandler );
				} else {
					doc.removeEventListener( type, focusMappedHandler, true );
				}
				dataPriv.remove( dataHolder, delegateType );
			} else {
				dataPriv.set( dataHolder, delegateType, attaches );
			}
		}
	};
} );

// Create mouseenter/leave events using mouseover/out and event-time checks
// so that event delegation works in jQuery.
// Do the same for pointerenter/pointerleave and pointerover/pointerout
//
// Support: Safari 7 only
// Safari sends mouseenter too often; see:
// https://bugs.chromium.org/p/chromium/issues/detail?id=470258
// for the description of the bug (it existed in older Chrome versions as well).
jQuery.each( {
	mouseenter: "mouseover",
	mouseleave: "mouseout",
	pointerenter: "pointerover",
	pointerleave: "pointerout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		delegateType: fix,
		bindType: fix,

		handle: function( event ) {
			var ret,
				target = this,
				related = event.relatedTarget,
				handleObj = event.handleObj;

			// For mouseenter/leave call the handler if related is outside the target.
			// NB: No relatedTarget if the mouse left/entered the browser window
			if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {
				event.type = handleObj.origType;
				ret = handleObj.handler.apply( this, arguments );
				event.type = fix;
			}
			return ret;
		}
	};
} );

jQuery.fn.extend( {

	on: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn );
	},
	one: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn, 1 );
	},
	off: function( types, selector, fn ) {
		var handleObj, type;
		if ( types && types.preventDefault && types.handleObj ) {

			// ( event )  dispatched jQuery.Event
			handleObj = types.handleObj;
			jQuery( types.delegateTarget ).off(
				handleObj.namespace ?
					handleObj.origType + "." + handleObj.namespace :
					handleObj.origType,
				handleObj.selector,
				handleObj.handler
			);
			return this;
		}
		if ( typeof types === "object" ) {

			// ( types-object [, selector] )
			for ( type in types ) {
				this.off( type, selector, types[ type ] );
			}
			return this;
		}
		if ( selector === false || typeof selector === "function" ) {

			// ( types [, fn] )
			fn = selector;
			selector = undefined;
		}
		if ( fn === false ) {
			fn = returnFalse;
		}
		return this.each( function() {
			jQuery.event.remove( this, types, fn, selector );
		} );
	}
} );


var

	// Support: IE <=10 - 11, Edge 12 - 13 only
	// In IE/Edge using regex groups here causes severe slowdowns.
	// See https://connect.microsoft.com/IE/feedback/details/1736512/
	rnoInnerhtml = /<script|<style|<link/i,

	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,

	rcleanScript = /^\s*<!\[CDATA\[|\]\]>\s*$/g;

// Prefer a tbody over its parent table for containing new rows
function manipulationTarget( elem, content ) {
	if ( nodeName( elem, "table" ) &&
		nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ) {

		return jQuery( elem ).children( "tbody" )[ 0 ] || elem;
	}

	return elem;
}

// Replace/restore the type attribute of script elements for safe DOM manipulation
function disableScript( elem ) {
	elem.type = ( elem.getAttribute( "type" ) !== null ) + "/" + elem.type;
	return elem;
}
function restoreScript( elem ) {
	if ( ( elem.type || "" ).slice( 0, 5 ) === "true/" ) {
		elem.type = elem.type.slice( 5 );
	} else {
		elem.removeAttribute( "type" );
	}

	return elem;
}

function cloneCopyEvent( src, dest ) {
	var i, l, type, pdataOld, udataOld, udataCur, events;

	if ( dest.nodeType !== 1 ) {
		return;
	}

	// 1. Copy private data: events, handlers, etc.
	if ( dataPriv.hasData( src ) ) {
		pdataOld = dataPriv.get( src );
		events = pdataOld.events;

		if ( events ) {
			dataPriv.remove( dest, "handle events" );

			for ( type in events ) {
				for ( i = 0, l = events[ type ].length; i < l; i++ ) {
					jQuery.event.add( dest, type, events[ type ][ i ] );
				}
			}
		}
	}

	// 2. Copy user data
	if ( dataUser.hasData( src ) ) {
		udataOld = dataUser.access( src );
		udataCur = jQuery.extend( {}, udataOld );

		dataUser.set( dest, udataCur );
	}
}

// Fix IE bugs, see support tests
function fixInput( src, dest ) {
	var nodeName = dest.nodeName.toLowerCase();

	// Fails to persist the checked state of a cloned checkbox or radio button.
	if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
		dest.checked = src.checked;

	// Fails to return the selected option to the default selected state when cloning options
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;
	}
}

function domManip( collection, args, callback, ignored ) {

	// Flatten any nested arrays
	args = flat( args );

	var fragment, first, scripts, hasScripts, node, doc,
		i = 0,
		l = collection.length,
		iNoClone = l - 1,
		value = args[ 0 ],
		valueIsFunction = isFunction( value );

	// We can't cloneNode fragments that contain checked, in WebKit
	if ( valueIsFunction ||
			( l > 1 && typeof value === "string" &&
				!support.checkClone && rchecked.test( value ) ) ) {
		return collection.each( function( index ) {
			var self = collection.eq( index );
			if ( valueIsFunction ) {
				args[ 0 ] = value.call( this, index, self.html() );
			}
			domManip( self, args, callback, ignored );
		} );
	}

	if ( l ) {
		fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );
		first = fragment.firstChild;

		if ( fragment.childNodes.length === 1 ) {
			fragment = first;
		}

		// Require either new content or an interest in ignored elements to invoke the callback
		if ( first || ignored ) {
			scripts = jQuery.map( getAll( fragment, "script" ), disableScript );
			hasScripts = scripts.length;

			// Use the original fragment for the last item
			// instead of the first because it can end up
			// being emptied incorrectly in certain situations (trac-8070).
			for ( ; i < l; i++ ) {
				node = fragment;

				if ( i !== iNoClone ) {
					node = jQuery.clone( node, true, true );

					// Keep references to cloned scripts for later restoration
					if ( hasScripts ) {

						// Support: Android <=4.0 only, PhantomJS 1 only
						// push.apply(_, arraylike) throws on ancient WebKit
						jQuery.merge( scripts, getAll( node, "script" ) );
					}
				}

				callback.call( collection[ i ], node, i );
			}

			if ( hasScripts ) {
				doc = scripts[ scripts.length - 1 ].ownerDocument;

				// Re-enable scripts
				jQuery.map( scripts, restoreScript );

				// Evaluate executable scripts on first document insertion
				for ( i = 0; i < hasScripts; i++ ) {
					node = scripts[ i ];
					if ( rscriptType.test( node.type || "" ) &&
						!dataPriv.access( node, "globalEval" ) &&
						jQuery.contains( doc, node ) ) {

						if ( node.src && ( node.type || "" ).toLowerCase()  !== "module" ) {

							// Optional AJAX dependency, but won't run scripts if not present
							if ( jQuery._evalUrl && !node.noModule ) {
								jQuery._evalUrl( node.src, {
									nonce: node.nonce || node.getAttribute( "nonce" )
								}, doc );
							}
						} else {

							// Unwrap a CDATA section containing script contents. This shouldn't be
							// needed as in XML documents they're already not visible when
							// inspecting element contents and in HTML documents they have no
							// meaning but we're preserving that logic for backwards compatibility.
							// This will be removed completely in 4.0. See gh-4904.
							DOMEval( node.textContent.replace( rcleanScript, "" ), node, doc );
						}
					}
				}
			}
		}
	}

	return collection;
}

function remove( elem, selector, keepData ) {
	var node,
		nodes = selector ? jQuery.filter( selector, elem ) : elem,
		i = 0;

	for ( ; ( node = nodes[ i ] ) != null; i++ ) {
		if ( !keepData && node.nodeType === 1 ) {
			jQuery.cleanData( getAll( node ) );
		}

		if ( node.parentNode ) {
			if ( keepData && isAttached( node ) ) {
				setGlobalEval( getAll( node, "script" ) );
			}
			node.parentNode.removeChild( node );
		}
	}

	return elem;
}

jQuery.extend( {
	htmlPrefilter: function( html ) {
		return html;
	},

	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var i, l, srcElements, destElements,
			clone = elem.cloneNode( true ),
			inPage = isAttached( elem );

		// Fix IE cloning issues
		if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&
				!jQuery.isXMLDoc( elem ) ) {

			// We eschew jQuery#find here for performance reasons:
			// https://jsperf.com/getall-vs-sizzle/2
			destElements = getAll( clone );
			srcElements = getAll( elem );

			for ( i = 0, l = srcElements.length; i < l; i++ ) {
				fixInput( srcElements[ i ], destElements[ i ] );
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			if ( deepDataAndEvents ) {
				srcElements = srcElements || getAll( elem );
				destElements = destElements || getAll( clone );

				for ( i = 0, l = srcElements.length; i < l; i++ ) {
					cloneCopyEvent( srcElements[ i ], destElements[ i ] );
				}
			} else {
				cloneCopyEvent( elem, clone );
			}
		}

		// Preserve script evaluation history
		destElements = getAll( clone, "script" );
		if ( destElements.length > 0 ) {
			setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );
		}

		// Return the cloned set
		return clone;
	},

	cleanData: function( elems ) {
		var data, elem, type,
			special = jQuery.event.special,
			i = 0;

		for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {
			if ( acceptData( elem ) ) {
				if ( ( data = elem[ dataPriv.expando ] ) ) {
					if ( data.events ) {
						for ( type in data.events ) {
							if ( special[ type ] ) {
								jQuery.event.remove( elem, type );

							// This is a shortcut to avoid jQuery.event.remove's overhead
							} else {
								jQuery.removeEvent( elem, type, data.handle );
							}
						}
					}

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataPriv.expando ] = undefined;
				}
				if ( elem[ dataUser.expando ] ) {

					// Support: Chrome <=35 - 45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataUser.expando ] = undefined;
				}
			}
		}
	}
} );

jQuery.fn.extend( {
	detach: function( selector ) {
		return remove( this, selector, true );
	},

	remove: function( selector ) {
		return remove( this, selector );
	},

	text: function( value ) {
		return access( this, function( value ) {
			return value === undefined ?
				jQuery.text( this ) :
				this.empty().each( function() {
					if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
						this.textContent = value;
					}
				} );
		}, null, value, arguments.length );
	},

	append: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.appendChild( elem );
			}
		} );
	},

	prepend: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.insertBefore( elem, target.firstChild );
			}
		} );
	},

	before: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this );
			}
		} );
	},

	after: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			}
		} );
	},

	empty: function() {
		var elem,
			i = 0;

		for ( ; ( elem = this[ i ] ) != null; i++ ) {
			if ( elem.nodeType === 1 ) {

				// Prevent memory leaks
				jQuery.cleanData( getAll( elem, false ) );

				// Remove any remaining nodes
				elem.textContent = "";
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map( function() {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		} );
	},

	html: function( value ) {
		return access( this, function( value ) {
			var elem = this[ 0 ] || {},
				i = 0,
				l = this.length;

			if ( value === undefined && elem.nodeType === 1 ) {
				return elem.innerHTML;
			}

			// See if we can take a shortcut and just use innerHTML
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
				!wrapMap[ ( rtagName.exec( value ) || [ "", "" ] )[ 1 ].toLowerCase() ] ) {

				value = jQuery.htmlPrefilter( value );

				try {
					for ( ; i < l; i++ ) {
						elem = this[ i ] || {};

						// Remove element nodes and prevent memory leaks
						if ( elem.nodeType === 1 ) {
							jQuery.cleanData( getAll( elem, false ) );
							elem.innerHTML = value;
						}
					}

					elem = 0;

				// If using innerHTML throws an exception, use the fallback method
				} catch ( e ) {}
			}

			if ( elem ) {
				this.empty().append( value );
			}
		}, null, value, arguments.length );
	},

	replaceWith: function() {
		var ignored = [];

		// Make the changes, replacing each non-ignored context element with the new content
		return domManip( this, arguments, function( elem ) {
			var parent = this.parentNode;

			if ( jQuery.inArray( this, ignored ) < 0 ) {
				jQuery.cleanData( getAll( this ) );
				if ( parent ) {
					parent.replaceChild( elem, this );
				}
			}

		// Force callback invocation
		}, ignored );
	}
} );

jQuery.each( {
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var elems,
			ret = [],
			insert = jQuery( selector ),
			last = insert.length - 1,
			i = 0;

		for ( ; i <= last; i++ ) {
			elems = i === last ? this : this.clone( true );
			jQuery( insert[ i ] )[ original ]( elems );

			// Support: Android <=4.0 only, PhantomJS 1 only
			// .get() because push.apply(_, arraylike) throws on ancient WebKit
			push.apply( ret, elems.get() );
		}

		return this.pushStack( ret );
	};
} );
var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );

var rcustomProp = /^--/;


var getStyles = function( elem ) {

		// Support: IE <=11 only, Firefox <=30 (trac-15098, trac-14150)
		// IE throws on elements created in popups
		// FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
		var view = elem.ownerDocument.defaultView;

		if ( !view || !view.opener ) {
			view = window;
		}

		return view.getComputedStyle( elem );
	};

var swap = function( elem, options, callback ) {
	var ret, name,
		old = {};

	// Remember the old values, and insert the new ones
	for ( name in options ) {
		old[ name ] = elem.style[ name ];
		elem.style[ name ] = options[ name ];
	}

	ret = callback.call( elem );

	// Revert the old values
	for ( name in options ) {
		elem.style[ name ] = old[ name ];
	}

	return ret;
};


var rboxStyle = new RegExp( cssExpand.join( "|" ), "i" );



( function() {

	// Executing both pixelPosition & boxSizingReliable tests require only one layout
	// so they're executed at the same time to save the second computation.
	function computeStyleTests() {

		// This is a singleton, we need to execute it only once
		if ( !div ) {
			return;
		}

		container.style.cssText = "position:absolute;left:-11111px;width:60px;" +
			"margin-top:1px;padding:0;border:0";
		div.style.cssText =
			"position:relative;display:block;box-sizing:border-box;overflow:scroll;" +
			"margin:auto;border:1px;padding:1px;" +
			"width:60%;top:1%";
		documentElement.appendChild( container ).appendChild( div );

		var divStyle = window.getComputedStyle( div );
		pixelPositionVal = divStyle.top !== "1%";

		// Support: Android 4.0 - 4.3 only, Firefox <=3 - 44
		reliableMarginLeftVal = roundPixelMeasures( divStyle.marginLeft ) === 12;

		// Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
		// Some styles come back with percentage values, even though they shouldn't
		div.style.right = "60%";
		pixelBoxStylesVal = roundPixelMeasures( divStyle.right ) === 36;

		// Support: IE 9 - 11 only
		// Detect misreporting of content dimensions for box-sizing:border-box elements
		boxSizingReliableVal = roundPixelMeasures( divStyle.width ) === 36;

		// Support: IE 9 only
		// Detect overflow:scroll screwiness (gh-3699)
		// Support: Chrome <=64
		// Don't get tricked when zoom affects offsetWidth (gh-4029)
		div.style.position = "absolute";
		scrollboxSizeVal = roundPixelMeasures( div.offsetWidth / 3 ) === 12;

		documentElement.removeChild( container );

		// Nullify the div so it wouldn't be stored in the memory and
		// it will also be a sign that checks already performed
		div = null;
	}

	function roundPixelMeasures( measure ) {
		return Math.round( parseFloat( measure ) );
	}

	var pixelPositionVal, boxSizingReliableVal, scrollboxSizeVal, pixelBoxStylesVal,
		reliableTrDimensionsVal, reliableMarginLeftVal,
		container = document.createElement( "div" ),
		div = document.createElement( "div" );

	// Finish early in limited (non-browser) environments
	if ( !div.style ) {
		return;
	}

	// Support: IE <=9 - 11 only
	// Style of cloned element affects source element cloned (trac-8908)
	div.style.backgroundClip = "content-box";
	div.cloneNode( true ).style.backgroundClip = "";
	support.clearCloneStyle = div.style.backgroundClip === "content-box";

	jQuery.extend( support, {
		boxSizingReliable: function() {
			computeStyleTests();
			return boxSizingReliableVal;
		},
		pixelBoxStyles: function() {
			computeStyleTests();
			return pixelBoxStylesVal;
		},
		pixelPosition: function() {
			computeStyleTests();
			return pixelPositionVal;
		},
		reliableMarginLeft: function() {
			computeStyleTests();
			return reliableMarginLeftVal;
		},
		scrollboxSize: function() {
			computeStyleTests();
			return scrollboxSizeVal;
		},

		// Support: IE 9 - 11+, Edge 15 - 18+
		// IE/Edge misreport `getComputedStyle` of table rows with width/height
		// set in CSS while `offset*` properties report correct values.
		// Behavior in IE 9 is more subtle than in newer versions & it passes
		// some versions of this test; make sure not to make it pass there!
		//
		// Support: Firefox 70+
		// Only Firefox includes border widths
		// in computed dimensions. (gh-4529)
		reliableTrDimensions: function() {
			var table, tr, trChild, trStyle;
			if ( reliableTrDimensionsVal == null ) {
				table = document.createElement( "table" );
				tr = document.createElement( "tr" );
				trChild = document.createElement( "div" );

				table.style.cssText = "position:absolute;left:-11111px;border-collapse:separate";
				tr.style.cssText = "box-sizing:content-box;border:1px solid";

				// Support: Chrome 86+
				// Height set through cssText does not get applied.
				// Computed height then comes back as 0.
				tr.style.height = "1px";
				trChild.style.height = "9px";

				// Support: Android 8 Chrome 86+
				// In our bodyBackground.html iframe,
				// display for all div elements is set to "inline",
				// which causes a problem only in Android 8 Chrome 86.
				// Ensuring the div is `display: block`
				// gets around this issue.
				trChild.style.display = "block";

				documentElement
					.appendChild( table )
					.appendChild( tr )
					.appendChild( trChild );

				trStyle = window.getComputedStyle( tr );
				reliableTrDimensionsVal = ( parseInt( trStyle.height, 10 ) +
					parseInt( trStyle.borderTopWidth, 10 ) +
					parseInt( trStyle.borderBottomWidth, 10 ) ) === tr.offsetHeight;

				documentElement.removeChild( table );
			}
			return reliableTrDimensionsVal;
		}
	} );
} )();


function curCSS( elem, name, computed ) {
	var width, minWidth, maxWidth, ret,
		isCustomProp = rcustomProp.test( name ),

		// Support: Firefox 51+
		// Retrieving style before computed somehow
		// fixes an issue with getting wrong values
		// on detached elements
		style = elem.style;

	computed = computed || getStyles( elem );

	// getPropertyValue is needed for:
	//   .css('filter') (IE 9 only, trac-12537)
	//   .css('--customProperty) (gh-3144)
	if ( computed ) {

		// Support: IE <=9 - 11+
		// IE only supports `"float"` in `getPropertyValue`; in computed styles
		// it's only available as `"cssFloat"`. We no longer modify properties
		// sent to `.css()` apart from camelCasing, so we need to check both.
		// Normally, this would create difference in behavior: if
		// `getPropertyValue` returns an empty string, the value returned
		// by `.css()` would be `undefined`. This is usually the case for
		// disconnected elements. However, in IE even disconnected elements
		// with no styles return `"none"` for `getPropertyValue( "float" )`
		ret = computed.getPropertyValue( name ) || computed[ name ];

		if ( isCustomProp && ret ) {

			// Support: Firefox 105+, Chrome <=105+
			// Spec requires trimming whitespace for custom properties (gh-4926).
			// Firefox only trims leading whitespace. Chrome just collapses
			// both leading & trailing whitespace to a single space.
			//
			// Fall back to `undefined` if empty string returned.
			// This collapses a missing definition with property defined
			// and set to an empty string but there's no standard API
			// allowing us to differentiate them without a performance penalty
			// and returning `undefined` aligns with older jQuery.
			//
			// rtrimCSS treats U+000D CARRIAGE RETURN and U+000C FORM FEED
			// as whitespace while CSS does not, but this is not a problem
			// because CSS preprocessing replaces them with U+000A LINE FEED
			// (which *is* CSS whitespace)
			// https://www.w3.org/TR/css-syntax-3/#input-preprocessing
			ret = ret.replace( rtrimCSS, "$1" ) || undefined;
		}

		if ( ret === "" && !isAttached( elem ) ) {
			ret = jQuery.style( elem, name );
		}

		// A tribute to the "awesome hack by Dean Edwards"
		// Android Browser returns percentage for some values,
		// but width seems to be reliably pixels.
		// This is against the CSSOM draft spec:
		// https://drafts.csswg.org/cssom/#resolved-values
		if ( !support.pixelBoxStyles() && rnumnonpx.test( ret ) && rboxStyle.test( name ) ) {

			// Remember the original values
			width = style.width;
			minWidth = style.minWidth;
			maxWidth = style.maxWidth;

			// Put in the new values to get a computed value out
			style.minWidth = style.maxWidth = style.width = ret;
			ret = computed.width;

			// Revert the changed values
			style.width = width;
			style.minWidth = minWidth;
			style.maxWidth = maxWidth;
		}
	}

	return ret !== undefined ?

		// Support: IE <=9 - 11 only
		// IE returns zIndex value as an integer.
		ret + "" :
		ret;
}


function addGetHookIf( conditionFn, hookFn ) {

	// Define the hook, we'll check on the first run if it's really needed.
	return {
		get: function() {
			if ( conditionFn() ) {

				// Hook not needed (or it's not possible to use it due
				// to missing dependency), remove it.
				delete this.get;
				return;
			}

			// Hook needed; redefine it so that the support test is not executed again.
			return ( this.get = hookFn ).apply( this, arguments );
		}
	};
}


var cssPrefixes = [ "Webkit", "Moz", "ms" ],
	emptyStyle = document.createElement( "div" ).style,
	vendorProps = {};

// Return a vendor-prefixed property or undefined
function vendorPropName( name ) {

	// Check for vendor prefixed names
	var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),
		i = cssPrefixes.length;

	while ( i-- ) {
		name = cssPrefixes[ i ] + capName;
		if ( name in emptyStyle ) {
			return name;
		}
	}
}

// Return a potentially-mapped jQuery.cssProps or vendor prefixed property
function finalPropName( name ) {
	var final = jQuery.cssProps[ name ] || vendorProps[ name ];

	if ( final ) {
		return final;
	}
	if ( name in emptyStyle ) {
		return name;
	}
	return vendorProps[ name ] = vendorPropName( name ) || name;
}


var

	// Swappable if display is none or starts with table
	// except "table", "table-cell", or "table-caption"
	// See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,
	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssNormalTransform = {
		letterSpacing: "0",
		fontWeight: "400"
	};

function setPositiveNumber( _elem, value, subtract ) {

	// Any relative (+/-) values have already been
	// normalized at this point
	var matches = rcssNum.exec( value );
	return matches ?

		// Guard against undefined "subtract", e.g., when used as in cssHooks
		Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || "px" ) :
		value;
}

function boxModelAdjustment( elem, dimension, box, isBorderBox, styles, computedVal ) {
	var i = dimension === "width" ? 1 : 0,
		extra = 0,
		delta = 0,
		marginDelta = 0;

	// Adjustment may not be necessary
	if ( box === ( isBorderBox ? "border" : "content" ) ) {
		return 0;
	}

	for ( ; i < 4; i += 2 ) {

		// Both box models exclude margin
		// Count margin delta separately to only add it after scroll gutter adjustment.
		// This is needed to make negative margins work with `outerHeight( true )` (gh-3982).
		if ( box === "margin" ) {
			marginDelta += jQuery.css( elem, box + cssExpand[ i ], true, styles );
		}

		// If we get here with a content-box, we're seeking "padding" or "border" or "margin"
		if ( !isBorderBox ) {

			// Add padding
			delta += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );

			// For "border" or "margin", add border
			if ( box !== "padding" ) {
				delta += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );

			// But still keep track of it otherwise
			} else {
				extra += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}

		// If we get here with a border-box (content + padding + border), we're seeking "content" or
		// "padding" or "margin"
		} else {

			// For "content", subtract padding
			if ( box === "content" ) {
				delta -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );
			}

			// For "content" or "padding", subtract border
			if ( box !== "margin" ) {
				delta -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}
		}
	}

	// Account for positive content-box scroll gutter when requested by providing computedVal
	if ( !isBorderBox && computedVal >= 0 ) {

		// offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border
		// Assuming integer scroll gutter, subtract the rest and round down
		delta += Math.max( 0, Math.ceil(
			elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
			computedVal -
			delta -
			extra -
			0.5

		// If offsetWidth/offsetHeight is unknown, then we can't determine content-box scroll gutter
		// Use an explicit zero to avoid NaN (gh-3964)
		) ) || 0;
	}

	return delta + marginDelta;
}

function getWidthOrHeight( elem, dimension, extra ) {

	// Start with computed style
	var styles = getStyles( elem ),

		// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-4322).
		// Fake content-box until we know it's needed to know the true value.
		boxSizingNeeded = !support.boxSizingReliable() || extra,
		isBorderBox = boxSizingNeeded &&
			jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
		valueIsBorderBox = isBorderBox,

		val = curCSS( elem, dimension, styles ),
		offsetProp = "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 );

	// Support: Firefox <=54
	// Return a confounding non-pixel value or feign ignorance, as appropriate.
	if ( rnumnonpx.test( val ) ) {
		if ( !extra ) {
			return val;
		}
		val = "auto";
	}


	// Support: IE 9 - 11 only
	// Use offsetWidth/offsetHeight for when box sizing is unreliable.
	// In those cases, the computed value can be trusted to be border-box.
	if ( ( !support.boxSizingReliable() && isBorderBox ||

		// Support: IE 10 - 11+, Edge 15 - 18+
		// IE/Edge misreport `getComputedStyle` of table rows with width/height
		// set in CSS while `offset*` properties report correct values.
		// Interestingly, in some cases IE 9 doesn't suffer from this issue.
		!support.reliableTrDimensions() && nodeName( elem, "tr" ) ||

		// Fall back to offsetWidth/offsetHeight when value is "auto"
		// This happens for inline elements with no explicit setting (gh-3571)
		val === "auto" ||

		// Support: Android <=4.1 - 4.3 only
		// Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)
		!parseFloat( val ) && jQuery.css( elem, "display", false, styles ) === "inline" ) &&

		// Make sure the element is visible & connected
		elem.getClientRects().length ) {

		isBorderBox = jQuery.css( elem, "boxSizing", false, styles ) === "border-box";

		// Where available, offsetWidth/offsetHeight approximate border box dimensions.
		// Where not available (e.g., SVG), assume unreliable box-sizing and interpret the
		// retrieved value as a content box dimension.
		valueIsBorderBox = offsetProp in elem;
		if ( valueIsBorderBox ) {
			val = elem[ offsetProp ];
		}
	}

	// Normalize "" and auto
	val = parseFloat( val ) || 0;

	// Adjust for the element's box model
	return ( val +
		boxModelAdjustment(
			elem,
			dimension,
			extra || ( isBorderBox ? "border" : "content" ),
			valueIsBorderBox,
			styles,

			// Provide the current computed size to request scroll gutter calculation (gh-3589)
			val
		)
	) + "px";
}

jQuery.extend( {

	// Add in style property hooks for overriding the default
	// behavior of getting and setting a style property
	cssHooks: {
		opacity: {
			get: function( elem, computed ) {
				if ( computed ) {

					// We should always get a number back from opacity
					var ret = curCSS( elem, "opacity" );
					return ret === "" ? "1" : ret;
				}
			}
		}
	},

	// Don't automatically add "px" to these possibly-unitless properties
	cssNumber: {
		animationIterationCount: true,
		aspectRatio: true,
		borderImageSlice: true,
		columnCount: true,
		flexGrow: true,
		flexShrink: true,
		fontWeight: true,
		gridArea: true,
		gridColumn: true,
		gridColumnEnd: true,
		gridColumnStart: true,
		gridRow: true,
		gridRowEnd: true,
		gridRowStart: true,
		lineHeight: true,
		opacity: true,
		order: true,
		orphans: true,
		scale: true,
		widows: true,
		zIndex: true,
		zoom: true,

		// SVG-related
		fillOpacity: true,
		floodOpacity: true,
		stopOpacity: true,
		strokeMiterlimit: true,
		strokeOpacity: true
	},

	// Add in properties whose names you wish to fix before
	// setting or getting the value
	cssProps: {},

	// Get and set the style property on a DOM Node
	style: function( elem, name, value, extra ) {

		// Don't set styles on text and comment nodes
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
			return;
		}

		// Make sure that we're working with the right name
		var ret, type, hooks,
			origName = camelCase( name ),
			isCustomProp = rcustomProp.test( name ),
			style = elem.style;

		// Make sure that we're working with the right name. We don't
		// want to query the value if it is a CSS custom property
		// since they are user-defined.
		if ( !isCustomProp ) {
			name = finalPropName( origName );
		}

		// Gets hook for the prefixed version, then unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// Check if we're setting a value
		if ( value !== undefined ) {
			type = typeof value;

			// Convert "+=" or "-=" to relative numbers (trac-7345)
			if ( type === "string" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {
				value = adjustCSS( elem, name, ret );

				// Fixes bug trac-9237
				type = "number";
			}

			// Make sure that null and NaN values aren't set (trac-7116)
			if ( value == null || value !== value ) {
				return;
			}

			// If a number was passed in, add the unit (except for certain CSS properties)
			// The isCustomProp check can be removed in jQuery 4.0 when we only auto-append
			// "px" to a few hardcoded values.
			if ( type === "number" && !isCustomProp ) {
				value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? "" : "px" );
			}

			// background-* props affect original clone's values
			if ( !support.clearCloneStyle && value === "" && name.indexOf( "background" ) === 0 ) {
				style[ name ] = "inherit";
			}

			// If a hook was provided, use that value, otherwise just set the specified value
			if ( !hooks || !( "set" in hooks ) ||
				( value = hooks.set( elem, value, extra ) ) !== undefined ) {

				if ( isCustomProp ) {
					style.setProperty( name, value );
				} else {
					style[ name ] = value;
				}
			}

		} else {

			// If a hook was provided get the non-computed value from there
			if ( hooks && "get" in hooks &&
				( ret = hooks.get( elem, false, extra ) ) !== undefined ) {

				return ret;
			}

			// Otherwise just get the value from the style object
			return style[ name ];
		}
	},

	css: function( elem, name, extra, styles ) {
		var val, num, hooks,
			origName = camelCase( name ),
			isCustomProp = rcustomProp.test( name );

		// Make sure that we're working with the right name. We don't
		// want to modify the value if it is a CSS custom property
		// since they are user-defined.
		if ( !isCustomProp ) {
			name = finalPropName( origName );
		}

		// Try prefixed name followed by the unprefixed name
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// If a hook was provided get the computed value from there
		if ( hooks && "get" in hooks ) {
			val = hooks.get( elem, true, extra );
		}

		// Otherwise, if a way to get the computed value exists, use that
		if ( val === undefined ) {
			val = curCSS( elem, name, styles );
		}

		// Convert "normal" to computed value
		if ( val === "normal" && name in cssNormalTransform ) {
			val = cssNormalTransform[ name ];
		}

		// Make numeric if forced or a qualifier was provided and val looks numeric
		if ( extra === "" || extra ) {
			num = parseFloat( val );
			return extra === true || isFinite( num ) ? num || 0 : val;
		}

		return val;
	}
} );

jQuery.each( [ "height", "width" ], function( _i, dimension ) {
	jQuery.cssHooks[ dimension ] = {
		get: function( elem, computed, extra ) {
			if ( computed ) {

				// Certain elements can have dimension info if we invisibly show them
				// but it must have a current display style that would benefit
				return rdisplayswap.test( jQuery.css( elem, "display" ) ) &&

					// Support: Safari 8+
					// Table columns in Safari have non-zero offsetWidth & zero
					// getBoundingClientRect().width unless display is changed.
					// Support: IE <=11 only
					// Running getBoundingClientRect on a disconnected node
					// in IE throws an error.
					( !elem.getClientRects().length || !elem.getBoundingClientRect().width ) ?
					swap( elem, cssShow, function() {
						return getWidthOrHeight( elem, dimension, extra );
					} ) :
					getWidthOrHeight( elem, dimension, extra );
			}
		},

		set: function( elem, value, extra ) {
			var matches,
				styles = getStyles( elem ),

				// Only read styles.position if the test has a chance to fail
				// to avoid forcing a reflow.
				scrollboxSizeBuggy = !support.scrollboxSize() &&
					styles.position === "absolute",

				// To avoid forcing a reflow, only fetch boxSizing if we need it (gh-3991)
				boxSizingNeeded = scrollboxSizeBuggy || extra,
				isBorderBox = boxSizingNeeded &&
					jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
				subtract = extra ?
					boxModelAdjustment(
						elem,
						dimension,
						extra,
						isBorderBox,
						styles
					) :
					0;

			// Account for unreliable border-box dimensions by comparing offset* to computed and
			// faking a content-box to get border and padding (gh-3699)
			if ( isBorderBox && scrollboxSizeBuggy ) {
				subtract -= Math.ceil(
					elem[ "offset" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -
					parseFloat( styles[ dimension ] ) -
					boxModelAdjustment( elem, dimension, "border", false, styles ) -
					0.5
				);
			}

			// Convert to pixels if value adjustment is needed
			if ( subtract && ( matches = rcssNum.exec( value ) ) &&
				( matches[ 3 ] || "px" ) !== "px" ) {

				elem.style[ dimension ] = value;
				value = jQuery.css( elem, dimension );
			}

			return setPositiveNumber( elem, value, subtract );
		}
	};
} );

jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,
	function( elem, computed ) {
		if ( computed ) {
			return ( parseFloat( curCSS( elem, "marginLeft" ) ) ||
				elem.getBoundingClientRect().left -
					swap( elem, { marginLeft: 0 }, function() {
						return elem.getBoundingClientRect().left;
					} )
			) + "px";
		}
	}
);

// These hooks are used by animate to expand properties
jQuery.each( {
	margin: "",
	padding: "",
	border: "Width"
}, function( prefix, suffix ) {
	jQuery.cssHooks[ prefix + suffix ] = {
		expand: function( value ) {
			var i = 0,
				expanded = {},

				// Assumes a single number if not a string
				parts = typeof value === "string" ? value.split( " " ) : [ value ];

			for ( ; i < 4; i++ ) {
				expanded[ prefix + cssExpand[ i ] + suffix ] =
					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
			}

			return expanded;
		}
	};

	if ( prefix !== "margin" ) {
		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
	}
} );

jQuery.fn.extend( {
	css: function( name, value ) {
		return access( this, function( elem, name, value ) {
			var styles, len,
				map = {},
				i = 0;

			if ( Array.isArray( name ) ) {
				styles = getStyles( elem );
				len = name.length;

				for ( ; i < len; i++ ) {
					map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );
				}

				return map;
			}

			return value !== undefined ?
				jQuery.style( elem, name, value ) :
				jQuery.css( elem, name );
		}, name, value, arguments.length > 1 );
	}
} );


function Tween( elem, options, prop, end, easing ) {
	return new Tween.prototype.init( elem, options, prop, end, easing );
}
jQuery.Tween = Tween;

Tween.prototype = {
	constructor: Tween,
	init: function( elem, options, prop, end, easing, unit ) {
		this.elem = elem;
		this.prop = prop;
		this.easing = easing || jQuery.easing._default;
		this.options = options;
		this.start = this.now = this.cur();
		this.end = end;
		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
	},
	cur: function() {
		var hooks = Tween.propHooks[ this.prop ];

		return hooks && hooks.get ?
			hooks.get( this ) :
			Tween.propHooks._default.get( this );
	},
	run: function( percent ) {
		var eased,
			hooks = Tween.propHooks[ this.prop ];

		if ( this.options.duration ) {
			this.pos = eased = jQuery.easing[ this.easing ](
				percent, this.options.duration * percent, 0, 1, this.options.duration
			);
		} else {
			this.pos = eased = percent;
		}
		this.now = ( this.end - this.start ) * eased + this.start;

		if ( this.options.step ) {
			this.options.step.call( this.elem, this.now, this );
		}

		if ( hooks && hooks.set ) {
			hooks.set( this );
		} else {
			Tween.propHooks._default.set( this );
		}
		return this;
	}
};

Tween.prototype.init.prototype = Tween.prototype;

Tween.propHooks = {
	_default: {
		get: function( tween ) {
			var result;

			// Use a property on the element directly when it is not a DOM element,
			// or when there is no matching style property that exists.
			if ( tween.elem.nodeType !== 1 ||
				tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {
				return tween.elem[ tween.prop ];
			}

			// Passing an empty string as a 3rd parameter to .css will automatically
			// attempt a parseFloat and fallback to a string if the parse fails.
			// Simple values such as "10px" are parsed to Float;
			// complex values such as "rotate(1rad)" are returned as-is.
			result = jQuery.css( tween.elem, tween.prop, "" );

			// Empty strings, null, undefined and "auto" are converted to 0.
			return !result || result === "auto" ? 0 : result;
		},
		set: function( tween ) {

			// Use step hook for back compat.
			// Use cssHook if its there.
			// Use .style if available and use plain properties where available.
			if ( jQuery.fx.step[ tween.prop ] ) {
				jQuery.fx.step[ tween.prop ]( tween );
			} else if ( tween.elem.nodeType === 1 && (
				jQuery.cssHooks[ tween.prop ] ||
					tween.elem.style[ finalPropName( tween.prop ) ] != null ) ) {
				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
			} else {
				tween.elem[ tween.prop ] = tween.now;
			}
		}
	}
};

// Support: IE <=9 only
// Panic based approach to setting things on disconnected nodes
Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
	set: function( tween ) {
		if ( tween.elem.nodeType && tween.elem.parentNode ) {
			tween.elem[ tween.prop ] = tween.now;
		}
	}
};

jQuery.easing = {
	linear: function( p ) {
		return p;
	},
	swing: function( p ) {
		return 0.5 - Math.cos( p * Math.PI ) / 2;
	},
	_default: "swing"
};

jQuery.fx = Tween.prototype.init;

// Back compat <1.8 extension point
jQuery.fx.step = {};




var
	fxNow, inProgress,
	rfxtypes = /^(?:toggle|show|hide)$/,
	rrun = /queueHooks$/;

function schedule() {
	if ( inProgress ) {
		if ( document.hidden === false && window.requestAnimationFrame ) {
			window.requestAnimationFrame( schedule );
		} else {
			window.setTimeout( schedule, jQuery.fx.interval );
		}

		jQuery.fx.tick();
	}
}

// Animations created synchronously will run synchronously
function createFxNow() {
	window.setTimeout( function() {
		fxNow = undefined;
	} );
	return ( fxNow = Date.now() );
}

// Generate parameters to create a standard animation
function genFx( type, includeWidth ) {
	var which,
		i = 0,
		attrs = { height: type };

	// If we include width, step value is 1 to do all cssExpand values,
	// otherwise step value is 2 to skip over Left and Right
	includeWidth = includeWidth ? 1 : 0;
	for ( ; i < 4; i += 2 - includeWidth ) {
		which = cssExpand[ i ];
		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
	}

	if ( includeWidth ) {
		attrs.opacity = attrs.width = type;
	}

	return attrs;
}

function createTween( value, prop, animation ) {
	var tween,
		collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ "*" ] ),
		index = 0,
		length = collection.length;
	for ( ; index < length; index++ ) {
		if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {

			// We're done with this property
			return tween;
		}
	}
}

function defaultPrefilter( elem, props, opts ) {
	var prop, value, toggle, hooks, oldfire, propTween, restoreDisplay, display,
		isBox = "width" in props || "height" in props,
		anim = this,
		orig = {},
		style = elem.style,
		hidden = elem.nodeType && isHiddenWithinTree( elem ),
		dataShow = dataPriv.get( elem, "fxshow" );

	// Queue-skipping animations hijack the fx hooks
	if ( !opts.queue ) {
		hooks = jQuery._queueHooks( elem, "fx" );
		if ( hooks.unqueued == null ) {
			hooks.unqueued = 0;
			oldfire = hooks.empty.fire;
			hooks.empty.fire = function() {
				if ( !hooks.unqueued ) {
					oldfire();
				}
			};
		}
		hooks.unqueued++;

		anim.always( function() {

			// Ensure the complete handler is called before this completes
			anim.always( function() {
				hooks.unqueued--;
				if ( !jQuery.queue( elem, "fx" ).length ) {
					hooks.empty.fire();
				}
			} );
		} );
	}

	// Detect show/hide animations
	for ( prop in props ) {
		value = props[ prop ];
		if ( rfxtypes.test( value ) ) {
			delete props[ prop ];
			toggle = toggle || value === "toggle";
			if ( value === ( hidden ? "hide" : "show" ) ) {

				// Pretend to be hidden if this is a "show" and
				// there is still data from a stopped show/hide
				if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {
					hidden = true;

				// Ignore all other no-op show/hide data
				} else {
					continue;
				}
			}
			orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );
		}
	}

	// Bail out if this is a no-op like .hide().hide()
	propTween = !jQuery.isEmptyObject( props );
	if ( !propTween && jQuery.isEmptyObject( orig ) ) {
		return;
	}

	// Restrict "overflow" and "display" styles during box animations
	if ( isBox && elem.nodeType === 1 ) {

		// Support: IE <=9 - 11, Edge 12 - 15
		// Record all 3 overflow attributes because IE does not infer the shorthand
		// from identically-valued overflowX and overflowY and Edge just mirrors
		// the overflowX value there.
		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

		// Identify a display type, preferring old show/hide data over the CSS cascade
		restoreDisplay = dataShow && dataShow.display;
		if ( restoreDisplay == null ) {
			restoreDisplay = dataPriv.get( elem, "display" );
		}
		display = jQuery.css( elem, "display" );
		if ( display === "none" ) {
			if ( restoreDisplay ) {
				display = restoreDisplay;
			} else {

				// Get nonempty value(s) by temporarily forcing visibility
				showHide( [ elem ], true );
				restoreDisplay = elem.style.display || restoreDisplay;
				display = jQuery.css( elem, "display" );
				showHide( [ elem ] );
			}
		}

		// Animate inline elements as inline-block
		if ( display === "inline" || display === "inline-block" && restoreDisplay != null ) {
			if ( jQuery.css( elem, "float" ) === "none" ) {

				// Restore the original display value at the end of pure show/hide animations
				if ( !propTween ) {
					anim.done( function() {
						style.display = restoreDisplay;
					} );
					if ( restoreDisplay == null ) {
						display = style.display;
						restoreDisplay = display === "none" ? "" : display;
					}
				}
				style.display = "inline-block";
			}
		}
	}

	if ( opts.overflow ) {
		style.overflow = "hidden";
		anim.always( function() {
			style.overflow = opts.overflow[ 0 ];
			style.overflowX = opts.overflow[ 1 ];
			style.overflowY = opts.overflow[ 2 ];
		} );
	}

	// Implement show/hide animations
	propTween = false;
	for ( prop in orig ) {

		// General show/hide setup for this element animation
		if ( !propTween ) {
			if ( dataShow ) {
				if ( "hidden" in dataShow ) {
					hidden = dataShow.hidden;
				}
			} else {
				dataShow = dataPriv.access( elem, "fxshow", { display: restoreDisplay } );
			}

			// Store hidden/visible for toggle so `.stop().toggle()` "reverses"
			if ( toggle ) {
				dataShow.hidden = !hidden;
			}

			// Show elements before animating them
			if ( hidden ) {
				showHide( [ elem ], true );
			}

			/* eslint-disable no-loop-func */

			anim.done( function() {

				/* eslint-enable no-loop-func */

				// The final step of a "hide" animation is actually hiding the element
				if ( !hidden ) {
					showHide( [ elem ] );
				}
				dataPriv.remove( elem, "fxshow" );
				for ( prop in orig ) {
					jQuery.style( elem, prop, orig[ prop ] );
				}
			} );
		}

		// Per-property setup
		propTween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );
		if ( !( prop in dataShow ) ) {
			dataShow[ prop ] = propTween.start;
			if ( hidden ) {
				propTween.end = propTween.start;
				propTween.start = 0;
			}
		}
	}
}

function propFilter( props, specialEasing ) {
	var index, name, easing, value, hooks;

	// camelCase, specialEasing and expand cssHook pass
	for ( index in props ) {
		name = camelCase( index );
		easing = specialEasing[ name ];
		value = props[ index ];
		if ( Array.isArray( value ) ) {
			easing = value[ 1 ];
			value = props[ index ] = value[ 0 ];
		}

		if ( index !== name ) {
			props[ name ] = value;
			delete props[ index ];
		}

		hooks = jQuery.cssHooks[ name ];
		if ( hooks && "expand" in hooks ) {
			value = hooks.expand( value );
			delete props[ name ];

			// Not quite $.extend, this won't overwrite existing keys.
			// Reusing 'index' because we have the correct "name"
			for ( index in value ) {
				if ( !( index in props ) ) {
					props[ index ] = value[ index ];
					specialEasing[ index ] = easing;
				}
			}
		} else {
			specialEasing[ name ] = easing;
		}
	}
}

function Animation( elem, properties, options ) {
	var result,
		stopped,
		index = 0,
		length = Animation.prefilters.length,
		deferred = jQuery.Deferred().always( function() {

			// Don't match elem in the :animated selector
			delete tick.elem;
		} ),
		tick = function() {
			if ( stopped ) {
				return false;
			}
			var currentTime = fxNow || createFxNow(),
				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),

				// Support: Android 2.3 only
				// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (trac-12497)
				temp = remaining / animation.duration || 0,
				percent = 1 - temp,
				index = 0,
				length = animation.tweens.length;

			for ( ; index < length; index++ ) {
				animation.tweens[ index ].run( percent );
			}

			deferred.notifyWith( elem, [ animation, percent, remaining ] );

			// If there's more to do, yield
			if ( percent < 1 && length ) {
				return remaining;
			}

			// If this was an empty animation, synthesize a final progress notification
			if ( !length ) {
				deferred.notifyWith( elem, [ animation, 1, 0 ] );
			}

			// Resolve the animation and report its conclusion
			deferred.resolveWith( elem, [ animation ] );
			return false;
		},
		animation = deferred.promise( {
			elem: elem,
			props: jQuery.extend( {}, properties ),
			opts: jQuery.extend( true, {
				specialEasing: {},
				easing: jQuery.easing._default
			}, options ),
			originalProperties: properties,
			originalOptions: options,
			startTime: fxNow || createFxNow(),
			duration: options.duration,
			tweens: [],
			createTween: function( prop, end ) {
				var tween = jQuery.Tween( elem, animation.opts, prop, end,
					animation.opts.specialEasing[ prop ] || animation.opts.easing );
				animation.tweens.push( tween );
				return tween;
			},
			stop: function( gotoEnd ) {
				var index = 0,

					// If we are going to the end, we want to run all the tweens
					// otherwise we skip this part
					length = gotoEnd ? animation.tweens.length : 0;
				if ( stopped ) {
					return this;
				}
				stopped = true;
				for ( ; index < length; index++ ) {
					animation.tweens[ index ].run( 1 );
				}

				// Resolve when we played the last frame; otherwise, reject
				if ( gotoEnd ) {
					deferred.notifyWith( elem, [ animation, 1, 0 ] );
					deferred.resolveWith( elem, [ animation, gotoEnd ] );
				} else {
					deferred.rejectWith( elem, [ animation, gotoEnd ] );
				}
				return this;
			}
		} ),
		props = animation.props;

	propFilter( props, animation.opts.specialEasing );

	for ( ; index < length; index++ ) {
		result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );
		if ( result ) {
			if ( isFunction( result.stop ) ) {
				jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =
					result.stop.bind( result );
			}
			return result;
		}
	}

	jQuery.map( props, createTween, animation );

	if ( isFunction( animation.opts.start ) ) {
		animation.opts.start.call( elem, animation );
	}

	// Attach callbacks from options
	animation
		.progress( animation.opts.progress )
		.done( animation.opts.done, animation.opts.complete )
		.fail( animation.opts.fail )
		.always( animation.opts.always );

	jQuery.fx.timer(
		jQuery.extend( tick, {
			elem: elem,
			anim: animation,
			queue: animation.opts.queue
		} )
	);

	return animation;
}

jQuery.Animation = jQuery.extend( Animation, {

	tweeners: {
		"*": [ function( prop, value ) {
			var tween = this.createTween( prop, value );
			adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );
			return tween;
		} ]
	},

	tweener: function( props, callback ) {
		if ( isFunction( props ) ) {
			callback = props;
			props = [ "*" ];
		} else {
			props = props.match( rnothtmlwhite );
		}

		var prop,
			index = 0,
			length = props.length;

		for ( ; index < length; index++ ) {
			prop = props[ index ];
			Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];
			Animation.tweeners[ prop ].unshift( callback );
		}
	},

	prefilters: [ defaultPrefilter ],

	prefilter: function( callback, prepend ) {
		if ( prepend ) {
			Animation.prefilters.unshift( callback );
		} else {
			Animation.prefilters.push( callback );
		}
	}
} );

jQuery.speed = function( speed, easing, fn ) {
	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
		complete: fn || !fn && easing ||
			isFunction( speed ) && speed,
		duration: speed,
		easing: fn && easing || easing && !isFunction( easing ) && easing
	};

	// Go to the end state if fx are off
	if ( jQuery.fx.off ) {
		opt.duration = 0;

	} else {
		if ( typeof opt.duration !== "number" ) {
			if ( opt.duration in jQuery.fx.speeds ) {
				opt.duration = jQuery.fx.speeds[ opt.duration ];

			} else {
				opt.duration = jQuery.fx.speeds._default;
			}
		}
	}

	// Normalize opt.queue - true/undefined/null -> "fx"
	if ( opt.queue == null || opt.queue === true ) {
		opt.queue = "fx";
	}

	// Queueing
	opt.old = opt.complete;

	opt.complete = function() {
		if ( isFunction( opt.old ) ) {
			opt.old.call( this );
		}

		if ( opt.queue ) {
			jQuery.dequeue( this, opt.queue );
		}
	};

	return opt;
};

jQuery.fn.extend( {
	fadeTo: function( speed, to, easing, callback ) {

		// Show any hidden elements after setting opacity to 0
		return this.filter( isHiddenWithinTree ).css( "opacity", 0 ).show()

			// Animate to the value specified
			.end().animate( { opacity: to }, speed, easing, callback );
	},
	animate: function( prop, speed, easing, callback ) {
		var empty = jQuery.isEmptyObject( prop ),
			optall = jQuery.speed( speed, easing, callback ),
			doAnimation = function() {

				// Operate on a copy of prop so per-property easing won't be lost
				var anim = Animation( this, jQuery.extend( {}, prop ), optall );

				// Empty animations, or finishing resolves immediately
				if ( empty || dataPriv.get( this, "finish" ) ) {
					anim.stop( true );
				}
			};

		doAnimation.finish = doAnimation;

		return empty || optall.queue === false ?
			this.each( doAnimation ) :
			this.queue( optall.queue, doAnimation );
	},
	stop: function( type, clearQueue, gotoEnd ) {
		var stopQueue = function( hooks ) {
			var stop = hooks.stop;
			delete hooks.stop;
			stop( gotoEnd );
		};

		if ( typeof type !== "string" ) {
			gotoEnd = clearQueue;
			clearQueue = type;
			type = undefined;
		}
		if ( clearQueue ) {
			this.queue( type || "fx", [] );
		}

		return this.each( function() {
			var dequeue = true,
				index = type != null && type + "queueHooks",
				timers = jQuery.timers,
				data = dataPriv.get( this );

			if ( index ) {
				if ( data[ index ] && data[ index ].stop ) {
					stopQueue( data[ index ] );
				}
			} else {
				for ( index in data ) {
					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
						stopQueue( data[ index ] );
					}
				}
			}

			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this &&
					( type == null || timers[ index ].queue === type ) ) {

					timers[ index ].anim.stop( gotoEnd );
					dequeue = false;
					timers.splice( index, 1 );
				}
			}

			// Start the next in the queue if the last step wasn't forced.
			// Timers currently will call their complete callbacks, which
			// will dequeue but only if they were gotoEnd.
			if ( dequeue || !gotoEnd ) {
				jQuery.dequeue( this, type );
			}
		} );
	},
	finish: function( type ) {
		if ( type !== false ) {
			type = type || "fx";
		}
		return this.each( function() {
			var index,
				data = dataPriv.get( this ),
				queue = data[ type + "queue" ],
				hooks = data[ type + "queueHooks" ],
				timers = jQuery.timers,
				length = queue ? queue.length : 0;

			// Enable finishing flag on private data
			data.finish = true;

			// Empty the queue first
			jQuery.queue( this, type, [] );

			if ( hooks && hooks.stop ) {
				hooks.stop.call( this, true );
			}

			// Look for any active animations, and finish them
			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this && timers[ index ].queue === type ) {
					timers[ index ].anim.stop( true );
					timers.splice( index, 1 );
				}
			}

			// Look for any animations in the old queue and finish them
			for ( index = 0; index < length; index++ ) {
				if ( queue[ index ] && queue[ index ].finish ) {
					queue[ index ].finish.call( this );
				}
			}

			// Turn off finishing flag
			delete data.finish;
		} );
	}
} );

jQuery.each( [ "toggle", "show", "hide" ], function( _i, name ) {
	var cssFn = jQuery.fn[ name ];
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return speed == null || typeof speed === "boolean" ?
			cssFn.apply( this, arguments ) :
			this.animate( genFx( name, true ), speed, easing, callback );
	};
} );

// Generate shortcuts for custom animations
jQuery.each( {
	slideDown: genFx( "show" ),
	slideUp: genFx( "hide" ),
	slideToggle: genFx( "toggle" ),
	fadeIn: { opacity: "show" },
	fadeOut: { opacity: "hide" },
	fadeToggle: { opacity: "toggle" }
}, function( name, props ) {
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return this.animate( props, speed, easing, callback );
	};
} );

jQuery.timers = [];
jQuery.fx.tick = function() {
	var timer,
		i = 0,
		timers = jQuery.timers;

	fxNow = Date.now();

	for ( ; i < timers.length; i++ ) {
		timer = timers[ i ];

		// Run the timer and safely remove it when done (allowing for external removal)
		if ( !timer() && timers[ i ] === timer ) {
			timers.splice( i--, 1 );
		}
	}

	if ( !timers.length ) {
		jQuery.fx.stop();
	}
	fxNow = undefined;
};

jQuery.fx.timer = function( timer ) {
	jQuery.timers.push( timer );
	jQuery.fx.start();
};

jQuery.fx.interval = 13;
jQuery.fx.start = function() {
	if ( inProgress ) {
		return;
	}

	inProgress = true;
	schedule();
};

jQuery.fx.stop = function() {
	inProgress = null;
};

jQuery.fx.speeds = {
	slow: 600,
	fast: 200,

	// Default speed
	_default: 400
};


// Based off of the plugin by Clint Helfers, with permission.
jQuery.fn.delay = function( time, type ) {
	time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
	type = type || "fx";

	return this.queue( type, function( next, hooks ) {
		var timeout = window.setTimeout( next, time );
		hooks.stop = function() {
			window.clearTimeout( timeout );
		};
	} );
};


( function() {
	var input = document.createElement( "input" ),
		select = document.createElement( "select" ),
		opt = select.appendChild( document.createElement( "option" ) );

	input.type = "checkbox";

	// Support: Android <=4.3 only
	// Default value for a checkbox should be "on"
	support.checkOn = input.value !== "";

	// Support: IE <=11 only
	// Must access selectedIndex to make default options select
	support.optSelected = opt.selected;

	// Support: IE <=11 only
	// An input loses its value after becoming a radio
	input = document.createElement( "input" );
	input.value = "t";
	input.type = "radio";
	support.radioValue = input.value === "t";
} )();


var boolHook,
	attrHandle = jQuery.expr.attrHandle;

jQuery.fn.extend( {
	attr: function( name, value ) {
		return access( this, jQuery.attr, name, value, arguments.length > 1 );
	},

	removeAttr: function( name ) {
		return this.each( function() {
			jQuery.removeAttr( this, name );
		} );
	}
} );

jQuery.extend( {
	attr: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set attributes on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		// Fallback to prop when attributes are not supported
		if ( typeof elem.getAttribute === "undefined" ) {
			return jQuery.prop( elem, name, value );
		}

		// Attribute hooks are determined by the lowercase version
		// Grab necessary hook if one is defined
		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {
			hooks = jQuery.attrHooks[ name.toLowerCase() ] ||
				( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );
		}

		if ( value !== undefined ) {
			if ( value === null ) {
				jQuery.removeAttr( elem, name );
				return;
			}

			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			elem.setAttribute( name, value + "" );
			return value;
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		ret = jQuery.find.attr( elem, name );

		// Non-existent attributes return null, we normalize to undefined
		return ret == null ? undefined : ret;
	},

	attrHooks: {
		type: {
			set: function( elem, value ) {
				if ( !support.radioValue && value === "radio" &&
					nodeName( elem, "input" ) ) {
					var val = elem.value;
					elem.setAttribute( "type", value );
					if ( val ) {
						elem.value = val;
					}
					return value;
				}
			}
		}
	},

	removeAttr: function( elem, value ) {
		var name,
			i = 0,

			// Attribute names can contain non-HTML whitespace characters
			// https://html.spec.whatwg.org/multipage/syntax.html#attributes-2
			attrNames = value && value.match( rnothtmlwhite );

		if ( attrNames && elem.nodeType === 1 ) {
			while ( ( name = attrNames[ i++ ] ) ) {
				elem.removeAttribute( name );
			}
		}
	}
} );

// Hooks for boolean attributes
boolHook = {
	set: function( elem, value, name ) {
		if ( value === false ) {

			// Remove boolean attributes when set to false
			jQuery.removeAttr( elem, name );
		} else {
			elem.setAttribute( name, name );
		}
		return name;
	}
};

jQuery.each( jQuery.expr.match.bool.source.match( /\w+/g ), function( _i, name ) {
	var getter = attrHandle[ name ] || jQuery.find.attr;

	attrHandle[ name ] = function( elem, name, isXML ) {
		var ret, handle,
			lowercaseName = name.toLowerCase();

		if ( !isXML ) {

			// Avoid an infinite loop by temporarily removing this function from the getter
			handle = attrHandle[ lowercaseName ];
			attrHandle[ lowercaseName ] = ret;
			ret = getter( elem, name, isXML ) != null ?
				lowercaseName :
				null;
			attrHandle[ lowercaseName ] = handle;
		}
		return ret;
	};
} );




var rfocusable = /^(?:input|select|textarea|button)$/i,
	rclickable = /^(?:a|area)$/i;

jQuery.fn.extend( {
	prop: function( name, value ) {
		return access( this, jQuery.prop, name, value, arguments.length > 1 );
	},

	removeProp: function( name ) {
		return this.each( function() {
			delete this[ jQuery.propFix[ name ] || name ];
		} );
	}
} );

jQuery.extend( {
	prop: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set properties on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {

			// Fix name and attach hooks
			name = jQuery.propFix[ name ] || name;
			hooks = jQuery.propHooks[ name ];
		}

		if ( value !== undefined ) {
			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			return ( elem[ name ] = value );
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		return elem[ name ];
	},

	propHooks: {
		tabIndex: {
			get: function( elem ) {

				// Support: IE <=9 - 11 only
				// elem.tabIndex doesn't always return the
				// correct value when it hasn't been explicitly set
				// Use proper attribute retrieval (trac-12072)
				var tabindex = jQuery.find.attr( elem, "tabindex" );

				if ( tabindex ) {
					return parseInt( tabindex, 10 );
				}

				if (
					rfocusable.test( elem.nodeName ) ||
					rclickable.test( elem.nodeName ) &&
					elem.href
				) {
					return 0;
				}

				return -1;
			}
		}
	},

	propFix: {
		"for": "htmlFor",
		"class": "className"
	}
} );

// Support: IE <=11 only
// Accessing the selectedIndex property
// forces the browser to respect setting selected
// on the option
// The getter ensures a default option is selected
// when in an optgroup
// eslint rule "no-unused-expressions" is disabled for this code
// since it considers such accessions noop
if ( !support.optSelected ) {
	jQuery.propHooks.selected = {
		get: function( elem ) {

			/* eslint no-unused-expressions: "off" */

			var parent = elem.parentNode;
			if ( parent && parent.parentNode ) {
				parent.parentNode.selectedIndex;
			}
			return null;
		},
		set: function( elem ) {

			/* eslint no-unused-expressions: "off" */

			var parent = elem.parentNode;
			if ( parent ) {
				parent.selectedIndex;

				if ( parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
			}
		}
	};
}

jQuery.each( [
	"tabIndex",
	"readOnly",
	"maxLength",
	"cellSpacing",
	"cellPadding",
	"rowSpan",
	"colSpan",
	"useMap",
	"frameBorder",
	"contentEditable"
], function() {
	jQuery.propFix[ this.toLowerCase() ] = this;
} );




	// Strip and collapse whitespace according to HTML spec
	// https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace
	function stripAndCollapse( value ) {
		var tokens = value.match( rnothtmlwhite ) || [];
		return tokens.join( " " );
	}


function getClass( elem ) {
	return elem.getAttribute && elem.getAttribute( "class" ) || "";
}

function classesToArray( value ) {
	if ( Array.isArray( value ) ) {
		return value;
	}
	if ( typeof value === "string" ) {
		return value.match( rnothtmlwhite ) || [];
	}
	return [];
}

jQuery.fn.extend( {
	addClass: function( value ) {
		var classNames, cur, curValue, className, i, finalValue;

		if ( isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		classNames = classesToArray( value );

		if ( classNames.length ) {
			return this.each( function() {
				curValue = getClass( this );
				cur = this.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

				if ( cur ) {
					for ( i = 0; i < classNames.length; i++ ) {
						className = classNames[ i ];
						if ( cur.indexOf( " " + className + " " ) < 0 ) {
							cur += className + " ";
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = stripAndCollapse( cur );
					if ( curValue !== finalValue ) {
						this.setAttribute( "class", finalValue );
					}
				}
			} );
		}

		return this;
	},

	removeClass: function( value ) {
		var classNames, cur, curValue, className, i, finalValue;

		if ( isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		if ( !arguments.length ) {
			return this.attr( "class", "" );
		}

		classNames = classesToArray( value );

		if ( classNames.length ) {
			return this.each( function() {
				curValue = getClass( this );

				// This expression is here for better compressibility (see addClass)
				cur = this.nodeType === 1 && ( " " + stripAndCollapse( curValue ) + " " );

				if ( cur ) {
					for ( i = 0; i < classNames.length; i++ ) {
						className = classNames[ i ];

						// Remove *all* instances
						while ( cur.indexOf( " " + className + " " ) > -1 ) {
							cur = cur.replace( " " + className + " ", " " );
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = stripAndCollapse( cur );
					if ( curValue !== finalValue ) {
						this.setAttribute( "class", finalValue );
					}
				}
			} );
		}

		return this;
	},

	toggleClass: function( value, stateVal ) {
		var classNames, className, i, self,
			type = typeof value,
			isValidValue = type === "string" || Array.isArray( value );

		if ( isFunction( value ) ) {
			return this.each( function( i ) {
				jQuery( this ).toggleClass(
					value.call( this, i, getClass( this ), stateVal ),
					stateVal
				);
			} );
		}

		if ( typeof stateVal === "boolean" && isValidValue ) {
			return stateVal ? this.addClass( value ) : this.removeClass( value );
		}

		classNames = classesToArray( value );

		return this.each( function() {
			if ( isValidValue ) {

				// Toggle individual class names
				self = jQuery( this );

				for ( i = 0; i < classNames.length; i++ ) {
					className = classNames[ i ];

					// Check each className given, space separated list
					if ( self.hasClass( className ) ) {
						self.removeClass( className );
					} else {
						self.addClass( className );
					}
				}

			// Toggle whole class name
			} else if ( value === undefined || type === "boolean" ) {
				className = getClass( this );
				if ( className ) {

					// Store className if set
					dataPriv.set( this, "__className__", className );
				}

				// If the element has a class name or if we're passed `false`,
				// then remove the whole classname (if there was one, the above saved it).
				// Otherwise bring back whatever was previously saved (if anything),
				// falling back to the empty string if nothing was stored.
				if ( this.setAttribute ) {
					this.setAttribute( "class",
						className || value === false ?
							"" :
							dataPriv.get( this, "__className__" ) || ""
					);
				}
			}
		} );
	},

	hasClass: function( selector ) {
		var className, elem,
			i = 0;

		className = " " + selector + " ";
		while ( ( elem = this[ i++ ] ) ) {
			if ( elem.nodeType === 1 &&
				( " " + stripAndCollapse( getClass( elem ) ) + " " ).indexOf( className ) > -1 ) {
				return true;
			}
		}

		return false;
	}
} );




var rreturn = /\r/g;

jQuery.fn.extend( {
	val: function( value ) {
		var hooks, ret, valueIsFunction,
			elem = this[ 0 ];

		if ( !arguments.length ) {
			if ( elem ) {
				hooks = jQuery.valHooks[ elem.type ] ||
					jQuery.valHooks[ elem.nodeName.toLowerCase() ];

				if ( hooks &&
					"get" in hooks &&
					( ret = hooks.get( elem, "value" ) ) !== undefined
				) {
					return ret;
				}

				ret = elem.value;

				// Handle most common string cases
				if ( typeof ret === "string" ) {
					return ret.replace( rreturn, "" );
				}

				// Handle cases where value is null/undef or number
				return ret == null ? "" : ret;
			}

			return;
		}

		valueIsFunction = isFunction( value );

		return this.each( function( i ) {
			var val;

			if ( this.nodeType !== 1 ) {
				return;
			}

			if ( valueIsFunction ) {
				val = value.call( this, i, jQuery( this ).val() );
			} else {
				val = value;
			}

			// Treat null/undefined as ""; convert numbers to string
			if ( val == null ) {
				val = "";

			} else if ( typeof val === "number" ) {
				val += "";

			} else if ( Array.isArray( val ) ) {
				val = jQuery.map( val, function( value ) {
					return value == null ? "" : value + "";
				} );
			}

			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

			// If set returns undefined, fall back to normal setting
			if ( !hooks || !( "set" in hooks ) || hooks.set( this, val, "value" ) === undefined ) {
				this.value = val;
			}
		} );
	}
} );

jQuery.extend( {
	valHooks: {
		option: {
			get: function( elem ) {

				var val = jQuery.find.attr( elem, "value" );
				return val != null ?
					val :

					// Support: IE <=10 - 11 only
					// option.text throws exceptions (trac-14686, trac-14858)
					// Strip and collapse whitespace
					// https://html.spec.whatwg.org/#strip-and-collapse-whitespace
					stripAndCollapse( jQuery.text( elem ) );
			}
		},
		select: {
			get: function( elem ) {
				var value, option, i,
					options = elem.options,
					index = elem.selectedIndex,
					one = elem.type === "select-one",
					values = one ? null : [],
					max = one ? index + 1 : options.length;

				if ( index < 0 ) {
					i = max;

				} else {
					i = one ? index : 0;
				}

				// Loop through all the selected options
				for ( ; i < max; i++ ) {
					option = options[ i ];

					// Support: IE <=9 only
					// IE8-9 doesn't update selected after form reset (trac-2551)
					if ( ( option.selected || i === index ) &&

							// Don't return options that are disabled or in a disabled optgroup
							!option.disabled &&
							( !option.parentNode.disabled ||
								!nodeName( option.parentNode, "optgroup" ) ) ) {

						// Get the specific value for the option
						value = jQuery( option ).val();

						// We don't need an array for one selects
						if ( one ) {
							return value;
						}

						// Multi-Selects return an array
						values.push( value );
					}
				}

				return values;
			},

			set: function( elem, value ) {
				var optionSet, option,
					options = elem.options,
					values = jQuery.makeArray( value ),
					i = options.length;

				while ( i-- ) {
					option = options[ i ];

					/* eslint-disable no-cond-assign */

					if ( option.selected =
						jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1
					) {
						optionSet = true;
					}

					/* eslint-enable no-cond-assign */
				}

				// Force browsers to behave consistently when non-matching value is set
				if ( !optionSet ) {
					elem.selectedIndex = -1;
				}
				return values;
			}
		}
	}
} );

// Radios and checkboxes getter/setter
jQuery.each( [ "radio", "checkbox" ], function() {
	jQuery.valHooks[ this ] = {
		set: function( elem, value ) {
			if ( Array.isArray( value ) ) {
				return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );
			}
		}
	};
	if ( !support.checkOn ) {
		jQuery.valHooks[ this ].get = function( elem ) {
			return elem.getAttribute( "value" ) === null ? "on" : elem.value;
		};
	}
} );




// Return jQuery for attributes-only inclusion
var location = window.location;

var nonce = { guid: Date.now() };

var rquery = ( /\?/ );



// Cross-browser xml parsing
jQuery.parseXML = function( data ) {
	var xml, parserErrorElem;
	if ( !data || typeof data !== "string" ) {
		return null;
	}

	// Support: IE 9 - 11 only
	// IE throws on parseFromString with invalid input.
	try {
		xml = ( new window.DOMParser() ).parseFromString( data, "text/xml" );
	} catch ( e ) {}

	parserErrorElem = xml && xml.getElementsByTagName( "parsererror" )[ 0 ];
	if ( !xml || parserErrorElem ) {
		jQuery.error( "Invalid XML: " + (
			parserErrorElem ?
				jQuery.map( parserErrorElem.childNodes, function( el ) {
					return el.textContent;
				} ).join( "\n" ) :
				data
		) );
	}
	return xml;
};


var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
	stopPropagationCallback = function( e ) {
		e.stopPropagation();
	};

jQuery.extend( jQuery.event, {

	trigger: function( event, data, elem, onlyHandlers ) {

		var i, cur, tmp, bubbleType, ontype, handle, special, lastElement,
			eventPath = [ elem || document ],
			type = hasOwn.call( event, "type" ) ? event.type : event,
			namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split( "." ) : [];

		cur = lastElement = tmp = elem = elem || document;

		// Don't do events on text and comment nodes
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
			return;
		}

		// focus/blur morphs to focusin/out; ensure we're not firing them right now
		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
			return;
		}

		if ( type.indexOf( "." ) > -1 ) {

			// Namespaced trigger; create a regexp to match event type in handle()
			namespaces = type.split( "." );
			type = namespaces.shift();
			namespaces.sort();
		}
		ontype = type.indexOf( ":" ) < 0 && "on" + type;

		// Caller can pass in a jQuery.Event object, Object, or just an event type string
		event = event[ jQuery.expando ] ?
			event :
			new jQuery.Event( type, typeof event === "object" && event );

		// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
		event.isTrigger = onlyHandlers ? 2 : 3;
		event.namespace = namespaces.join( "." );
		event.rnamespace = event.namespace ?
			new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" ) :
			null;

		// Clean up the event in case it is being reused
		event.result = undefined;
		if ( !event.target ) {
			event.target = elem;
		}

		// Clone any incoming data and prepend the event, creating the handler arg list
		data = data == null ?
			[ event ] :
			jQuery.makeArray( data, [ event ] );

		// Allow special events to draw outside the lines
		special = jQuery.event.special[ type ] || {};
		if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {
			return;
		}

		// Determine event propagation path in advance, per W3C events spec (trac-9951)
		// Bubble up to document, then to window; watch for a global ownerDocument var (trac-9724)
		if ( !onlyHandlers && !special.noBubble && !isWindow( elem ) ) {

			bubbleType = special.delegateType || type;
			if ( !rfocusMorph.test( bubbleType + type ) ) {
				cur = cur.parentNode;
			}
			for ( ; cur; cur = cur.parentNode ) {
				eventPath.push( cur );
				tmp = cur;
			}

			// Only add window if we got to document (e.g., not plain obj or detached DOM)
			if ( tmp === ( elem.ownerDocument || document ) ) {
				eventPath.push( tmp.defaultView || tmp.parentWindow || window );
			}
		}

		// Fire handlers on the event path
		i = 0;
		while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {
			lastElement = cur;
			event.type = i > 1 ?
				bubbleType :
				special.bindType || type;

			// jQuery handler
			handle = ( dataPriv.get( cur, "events" ) || Object.create( null ) )[ event.type ] &&
				dataPriv.get( cur, "handle" );
			if ( handle ) {
				handle.apply( cur, data );
			}

			// Native handler
			handle = ontype && cur[ ontype ];
			if ( handle && handle.apply && acceptData( cur ) ) {
				event.result = handle.apply( cur, data );
				if ( event.result === false ) {
					event.preventDefault();
				}
			}
		}
		event.type = type;

		// If nobody prevented the default action, do it now
		if ( !onlyHandlers && !event.isDefaultPrevented() ) {

			if ( ( !special._default ||
				special._default.apply( eventPath.pop(), data ) === false ) &&
				acceptData( elem ) ) {

				// Call a native DOM method on the target with the same name as the event.
				// Don't do default actions on window, that's where global variables be (trac-6170)
				if ( ontype && isFunction( elem[ type ] ) && !isWindow( elem ) ) {

					// Don't re-trigger an onFOO event when we call its FOO() method
					tmp = elem[ ontype ];

					if ( tmp ) {
						elem[ ontype ] = null;
					}

					// Prevent re-triggering of the same event, since we already bubbled it above
					jQuery.event.triggered = type;

					if ( event.isPropagationStopped() ) {
						lastElement.addEventListener( type, stopPropagationCallback );
					}

					elem[ type ]();

					if ( event.isPropagationStopped() ) {
						lastElement.removeEventListener( type, stopPropagationCallback );
					}

					jQuery.event.triggered = undefined;

					if ( tmp ) {
						elem[ ontype ] = tmp;
					}
				}
			}
		}

		return event.result;
	},

	// Piggyback on a donor event to simulate a different one
	// Used only for `focus(in | out)` events
	simulate: function( type, elem, event ) {
		var e = jQuery.extend(
			new jQuery.Event(),
			event,
			{
				type: type,
				isSimulated: true
			}
		);

		jQuery.event.trigger( e, null, elem );
	}

} );

jQuery.fn.extend( {

	trigger: function( type, data ) {
		return this.each( function() {
			jQuery.event.trigger( type, data, this );
		} );
	},
	triggerHandler: function( type, data ) {
		var elem = this[ 0 ];
		if ( elem ) {
			return jQuery.event.trigger( type, data, elem, true );
		}
	}
} );


var
	rbracket = /\[\]$/,
	rCRLF = /\r?\n/g,
	rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
	rsubmittable = /^(?:input|select|textarea|keygen)/i;

function buildParams( prefix, obj, traditional, add ) {
	var name;

	if ( Array.isArray( obj ) ) {

		// Serialize array item.
		jQuery.each( obj, function( i, v ) {
			if ( traditional || rbracket.test( prefix ) ) {

				// Treat each array item as a scalar.
				add( prefix, v );

			} else {

				// Item is non-scalar (array or object), encode its numeric index.
				buildParams(
					prefix + "[" + ( typeof v === "object" && v != null ? i : "" ) + "]",
					v,
					traditional,
					add
				);
			}
		} );

	} else if ( !traditional && toType( obj ) === "object" ) {

		// Serialize object item.
		for ( name in obj ) {
			buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
		}

	} else {

		// Serialize scalar item.
		add( prefix, obj );
	}
}

// Serialize an array of form elements or a set of
// key/values into a query string
jQuery.param = function( a, traditional ) {
	var prefix,
		s = [],
		add = function( key, valueOrFunction ) {

			// If value is a function, invoke it and use its return value
			var value = isFunction( valueOrFunction ) ?
				valueOrFunction() :
				valueOrFunction;

			s[ s.length ] = encodeURIComponent( key ) + "=" +
				encodeURIComponent( value == null ? "" : value );
		};

	if ( a == null ) {
		return "";
	}

	// If an array was passed in, assume that it is an array of form elements.
	if ( Array.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {

		// Serialize the form elements
		jQuery.each( a, function() {
			add( this.name, this.value );
		} );

	} else {

		// If traditional, encode the "old" way (the way 1.3.2 or older
		// did it), otherwise encode params recursively.
		for ( prefix in a ) {
			buildParams( prefix, a[ prefix ], traditional, add );
		}
	}

	// Return the resulting serialization
	return s.join( "&" );
};

jQuery.fn.extend( {
	serialize: function() {
		return jQuery.param( this.serializeArray() );
	},
	serializeArray: function() {
		return this.map( function() {

			// Can add propHook for "elements" to filter or add form elements
			var elements = jQuery.prop( this, "elements" );
			return elements ? jQuery.makeArray( elements ) : this;
		} ).filter( function() {
			var type = this.type;

			// Use .is( ":disabled" ) so that fieldset[disabled] works
			return this.name && !jQuery( this ).is( ":disabled" ) &&
				rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&
				( this.checked || !rcheckableType.test( type ) );
		} ).map( function( _i, elem ) {
			var val = jQuery( this ).val();

			if ( val == null ) {
				return null;
			}

			if ( Array.isArray( val ) ) {
				return jQuery.map( val, function( val ) {
					return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
				} );
			}

			return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
		} ).get();
	}
} );


var
	r20 = /%20/g,
	rhash = /#.*$/,
	rantiCache = /([?&])_=[^&]*/,
	rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg,

	// trac-7653, trac-8125, trac-8152: local protocol detection
	rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
	rnoContent = /^(?:GET|HEAD)$/,
	rprotocol = /^\/\//,

	/* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
	prefilters = {},

	/* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
	transports = {},

	// Avoid comment-prolog char sequence (trac-10098); must appease lint and evade compression
	allTypes = "*/".concat( "*" ),

	// Anchor tag for parsing the document origin
	originAnchor = document.createElement( "a" );

originAnchor.href = location.href;

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
function addToPrefiltersOrTransports( structure ) {

	// dataTypeExpression is optional and defaults to "*"
	return function( dataTypeExpression, func ) {

		if ( typeof dataTypeExpression !== "string" ) {
			func = dataTypeExpression;
			dataTypeExpression = "*";
		}

		var dataType,
			i = 0,
			dataTypes = dataTypeExpression.toLowerCase().match( rnothtmlwhite ) || [];

		if ( isFunction( func ) ) {

			// For each dataType in the dataTypeExpression
			while ( ( dataType = dataTypes[ i++ ] ) ) {

				// Prepend if requested
				if ( dataType[ 0 ] === "+" ) {
					dataType = dataType.slice( 1 ) || "*";
					( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );

				// Otherwise append
				} else {
					( structure[ dataType ] = structure[ dataType ] || [] ).push( func );
				}
			}
		}
	};
}

// Base inspection function for prefilters and transports
function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {

	var inspected = {},
		seekingTransport = ( structure === transports );

	function inspect( dataType ) {
		var selected;
		inspected[ dataType ] = true;
		jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {
			var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );
			if ( typeof dataTypeOrTransport === "string" &&
				!seekingTransport && !inspected[ dataTypeOrTransport ] ) {

				options.dataTypes.unshift( dataTypeOrTransport );
				inspect( dataTypeOrTransport );
				return false;
			} else if ( seekingTransport ) {
				return !( selected = dataTypeOrTransport );
			}
		} );
		return selected;
	}

	return inspect( options.dataTypes[ 0 ] ) || !inspected[ "*" ] && inspect( "*" );
}

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes trac-9887
function ajaxExtend( target, src ) {
	var key, deep,
		flatOptions = jQuery.ajaxSettings.flatOptions || {};

	for ( key in src ) {
		if ( src[ key ] !== undefined ) {
			( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
		}
	}
	if ( deep ) {
		jQuery.extend( true, target, deep );
	}

	return target;
}

/* Handles responses to an ajax request:
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */
function ajaxHandleResponses( s, jqXHR, responses ) {

	var ct, type, finalDataType, firstDataType,
		contents = s.contents,
		dataTypes = s.dataTypes;

	// Remove auto dataType and get content-type in the process
	while ( dataTypes[ 0 ] === "*" ) {
		dataTypes.shift();
		if ( ct === undefined ) {
			ct = s.mimeType || jqXHR.getResponseHeader( "Content-Type" );
		}
	}

	// Check if we're dealing with a known content-type
	if ( ct ) {
		for ( type in contents ) {
			if ( contents[ type ] && contents[ type ].test( ct ) ) {
				dataTypes.unshift( type );
				break;
			}
		}
	}

	// Check to see if we have a response for the expected dataType
	if ( dataTypes[ 0 ] in responses ) {
		finalDataType = dataTypes[ 0 ];
	} else {

		// Try convertible dataTypes
		for ( type in responses ) {
			if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[ 0 ] ] ) {
				finalDataType = type;
				break;
			}
			if ( !firstDataType ) {
				firstDataType = type;
			}
		}

		// Or just use first one
		finalDataType = finalDataType || firstDataType;
	}

	// If we found a dataType
	// We add the dataType to the list if needed
	// and return the corresponding response
	if ( finalDataType ) {
		if ( finalDataType !== dataTypes[ 0 ] ) {
			dataTypes.unshift( finalDataType );
		}
		return responses[ finalDataType ];
	}
}

/* Chain conversions given the request and the original response
 * Also sets the responseXXX fields on the jqXHR instance
 */
function ajaxConvert( s, response, jqXHR, isSuccess ) {
	var conv2, current, conv, tmp, prev,
		converters = {},

		// Work with a copy of dataTypes in case we need to modify it for conversion
		dataTypes = s.dataTypes.slice();

	// Create converters map with lowercased keys
	if ( dataTypes[ 1 ] ) {
		for ( conv in s.converters ) {
			converters[ conv.toLowerCase() ] = s.converters[ conv ];
		}
	}

	current = dataTypes.shift();

	// Convert to each sequential dataType
	while ( current ) {

		if ( s.responseFields[ current ] ) {
			jqXHR[ s.responseFields[ current ] ] = response;
		}

		// Apply the dataFilter if provided
		if ( !prev && isSuccess && s.dataFilter ) {
			response = s.dataFilter( response, s.dataType );
		}

		prev = current;
		current = dataTypes.shift();

		if ( current ) {

			// There's only work to do if current dataType is non-auto
			if ( current === "*" ) {

				current = prev;

			// Convert response if prev dataType is non-auto and differs from current
			} else if ( prev !== "*" && prev !== current ) {

				// Seek a direct converter
				conv = converters[ prev + " " + current ] || converters[ "* " + current ];

				// If none found, seek a pair
				if ( !conv ) {
					for ( conv2 in converters ) {

						// If conv2 outputs current
						tmp = conv2.split( " " );
						if ( tmp[ 1 ] === current ) {

							// If prev can be converted to accepted input
							conv = converters[ prev + " " + tmp[ 0 ] ] ||
								converters[ "* " + tmp[ 0 ] ];
							if ( conv ) {

								// Condense equivalence converters
								if ( conv === true ) {
									conv = converters[ conv2 ];

								// Otherwise, insert the intermediate dataType
								} else if ( converters[ conv2 ] !== true ) {
									current = tmp[ 0 ];
									dataTypes.unshift( tmp[ 1 ] );
								}
								break;
							}
						}
					}
				}

				// Apply converter (if not an equivalence)
				if ( conv !== true ) {

					// Unless errors are allowed to bubble, catch and return them
					if ( conv && s.throws ) {
						response = conv( response );
					} else {
						try {
							response = conv( response );
						} catch ( e ) {
							return {
								state: "parsererror",
								error: conv ? e : "No conversion from " + prev + " to " + current
							};
						}
					}
				}
			}
		}
	}

	return { state: "success", data: response };
}

jQuery.extend( {

	// Counter for holding the number of active queries
	active: 0,

	// Last-Modified header cache for next request
	lastModified: {},
	etag: {},

	ajaxSettings: {
		url: location.href,
		type: "GET",
		isLocal: rlocalProtocol.test( location.protocol ),
		global: true,
		processData: true,
		async: true,
		contentType: "application/x-www-form-urlencoded; charset=UTF-8",

		/*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/

		accepts: {
			"*": allTypes,
			text: "text/plain",
			html: "text/html",
			xml: "application/xml, text/xml",
			json: "application/json, text/javascript"
		},

		contents: {
			xml: /\bxml\b/,
			html: /\bhtml/,
			json: /\bjson\b/
		},

		responseFields: {
			xml: "responseXML",
			text: "responseText",
			json: "responseJSON"
		},

		// Data converters
		// Keys separate source (or catchall "*") and destination types with a single space
		converters: {

			// Convert anything to text
			"* text": String,

			// Text to html (true = no transformation)
			"text html": true,

			// Evaluate text as a json expression
			"text json": JSON.parse,

			// Parse text as xml
			"text xml": jQuery.parseXML
		},

		// For options that shouldn't be deep extended:
		// you can add your own custom options here if
		// and when you create one that shouldn't be
		// deep extended (see ajaxExtend)
		flatOptions: {
			url: true,
			context: true
		}
	},

	// Creates a full fledged settings object into target
	// with both ajaxSettings and settings fields.
	// If target is omitted, writes into ajaxSettings.
	ajaxSetup: function( target, settings ) {
		return settings ?

			// Building a settings object
			ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :

			// Extending ajaxSettings
			ajaxExtend( jQuery.ajaxSettings, target );
	},

	ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
	ajaxTransport: addToPrefiltersOrTransports( transports ),

	// Main method
	ajax: function( url, options ) {

		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

		var transport,

			// URL without anti-cache param
			cacheURL,

			// Response headers
			responseHeadersString,
			responseHeaders,

			// timeout handle
			timeoutTimer,

			// Url cleanup var
			urlAnchor,

			// Request state (becomes false upon send and true upon completion)
			completed,

			// To know if global events are to be dispatched
			fireGlobals,

			// Loop variable
			i,

			// uncached part of the url
			uncached,

			// Create the final options object
			s = jQuery.ajaxSetup( {}, options ),

			// Callbacks context
			callbackContext = s.context || s,

			// Context for global events is callbackContext if it is a DOM node or jQuery collection
			globalEventContext = s.context &&
				( callbackContext.nodeType || callbackContext.jquery ) ?
				jQuery( callbackContext ) :
				jQuery.event,

			// Deferreds
			deferred = jQuery.Deferred(),
			completeDeferred = jQuery.Callbacks( "once memory" ),

			// Status-dependent callbacks
			statusCode = s.statusCode || {},

			// Headers (they are sent all at once)
			requestHeaders = {},
			requestHeadersNames = {},

			// Default abort message
			strAbort = "canceled",

			// Fake xhr
			jqXHR = {
				readyState: 0,

				// Builds headers hashtable if needed
				getResponseHeader: function( key ) {
					var match;
					if ( completed ) {
						if ( !responseHeaders ) {
							responseHeaders = {};
							while ( ( match = rheaders.exec( responseHeadersString ) ) ) {
								responseHeaders[ match[ 1 ].toLowerCase() + " " ] =
									( responseHeaders[ match[ 1 ].toLowerCase() + " " ] || [] )
										.concat( match[ 2 ] );
							}
						}
						match = responseHeaders[ key.toLowerCase() + " " ];
					}
					return match == null ? null : match.join( ", " );
				},

				// Raw string
				getAllResponseHeaders: function() {
					return completed ? responseHeadersString : null;
				},

				// Caches the header
				setRequestHeader: function( name, value ) {
					if ( completed == null ) {
						name = requestHeadersNames[ name.toLowerCase() ] =
							requestHeadersNames[ name.toLowerCase() ] || name;
						requestHeaders[ name ] = value;
					}
					return this;
				},

				// Overrides response content-type header
				overrideMimeType: function( type ) {
					if ( completed == null ) {
						s.mimeType = type;
					}
					return this;
				},

				// Status-dependent callbacks
				statusCode: function( map ) {
					var code;
					if ( map ) {
						if ( completed ) {

							// Execute the appropriate callbacks
							jqXHR.always( map[ jqXHR.status ] );
						} else {

							// Lazy-add the new callbacks in a way that preserves old ones
							for ( code in map ) {
								statusCode[ code ] = [ statusCode[ code ], map[ code ] ];
							}
						}
					}
					return this;
				},

				// Cancel the request
				abort: function( statusText ) {
					var finalText = statusText || strAbort;
					if ( transport ) {
						transport.abort( finalText );
					}
					done( 0, finalText );
					return this;
				}
			};

		// Attach deferreds
		deferred.promise( jqXHR );

		// Add protocol if not provided (prefilters might expect it)
		// Handle falsy url in the settings object (trac-10093: consistency with old signature)
		// We also use the url parameter if available
		s.url = ( ( url || s.url || location.href ) + "" )
			.replace( rprotocol, location.protocol + "//" );

		// Alias method option to type as per ticket trac-12004
		s.type = options.method || options.type || s.method || s.type;

		// Extract dataTypes list
		s.dataTypes = ( s.dataType || "*" ).toLowerCase().match( rnothtmlwhite ) || [ "" ];

		// A cross-domain request is in order when the origin doesn't match the current origin.
		if ( s.crossDomain == null ) {
			urlAnchor = document.createElement( "a" );

			// Support: IE <=8 - 11, Edge 12 - 15
			// IE throws exception on accessing the href property if url is malformed,
			// e.g. http://example.com:80x/
			try {
				urlAnchor.href = s.url;

				// Support: IE <=8 - 11 only
				// Anchor's host property isn't correctly set when s.url is relative
				urlAnchor.href = urlAnchor.href;
				s.crossDomain = originAnchor.protocol + "//" + originAnchor.host !==
					urlAnchor.protocol + "//" + urlAnchor.host;
			} catch ( e ) {

				// If there is an error parsing the URL, assume it is crossDomain,
				// it can be rejected by the transport if it is invalid
				s.crossDomain = true;
			}
		}

		// Convert data if not already a string
		if ( s.data && s.processData && typeof s.data !== "string" ) {
			s.data = jQuery.param( s.data, s.traditional );
		}

		// Apply prefilters
		inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

		// If request was aborted inside a prefilter, stop there
		if ( completed ) {
			return jqXHR;
		}

		// We can fire global events as of now if asked to
		// Don't fire events if jQuery.event is undefined in an AMD-usage scenario (trac-15118)
		fireGlobals = jQuery.event && s.global;

		// Watch for a new set of requests
		if ( fireGlobals && jQuery.active++ === 0 ) {
			jQuery.event.trigger( "ajaxStart" );
		}

		// Uppercase the type
		s.type = s.type.toUpperCase();

		// Determine if request has content
		s.hasContent = !rnoContent.test( s.type );

		// Save the URL in case we're toying with the If-Modified-Since
		// and/or If-None-Match header later on
		// Remove hash to simplify url manipulation
		cacheURL = s.url.replace( rhash, "" );

		// More options handling for requests with no content
		if ( !s.hasContent ) {

			// Remember the hash so we can put it back
			uncached = s.url.slice( cacheURL.length );

			// If data is available and should be processed, append data to url
			if ( s.data && ( s.processData || typeof s.data === "string" ) ) {
				cacheURL += ( rquery.test( cacheURL ) ? "&" : "?" ) + s.data;

				// trac-9682: remove data so that it's not used in an eventual retry
				delete s.data;
			}

			// Add or update anti-cache param if needed
			if ( s.cache === false ) {
				cacheURL = cacheURL.replace( rantiCache, "$1" );
				uncached = ( rquery.test( cacheURL ) ? "&" : "?" ) + "_=" + ( nonce.guid++ ) +
					uncached;
			}

			// Put hash and anti-cache on the URL that will be requested (gh-1732)
			s.url = cacheURL + uncached;

		// Change '%20' to '+' if this is encoded form body content (gh-2658)
		} else if ( s.data && s.processData &&
			( s.contentType || "" ).indexOf( "application/x-www-form-urlencoded" ) === 0 ) {
			s.data = s.data.replace( r20, "+" );
		}

		// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
		if ( s.ifModified ) {
			if ( jQuery.lastModified[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ cacheURL ] );
			}
			if ( jQuery.etag[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ cacheURL ] );
			}
		}

		// Set the correct header, if data is being sent
		if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
			jqXHR.setRequestHeader( "Content-Type", s.contentType );
		}

		// Set the Accepts header for the server, depending on the dataType
		jqXHR.setRequestHeader(
			"Accept",
			s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?
				s.accepts[ s.dataTypes[ 0 ] ] +
					( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
				s.accepts[ "*" ]
		);

		// Check for headers option
		for ( i in s.headers ) {
			jqXHR.setRequestHeader( i, s.headers[ i ] );
		}

		// Allow custom headers/mimetypes and early abort
		if ( s.beforeSend &&
			( s.beforeSend.call( callbackContext, jqXHR, s ) === false || completed ) ) {

			// Abort if not done already and return
			return jqXHR.abort();
		}

		// Aborting is no longer a cancellation
		strAbort = "abort";

		// Install callbacks on deferreds
		completeDeferred.add( s.complete );
		jqXHR.done( s.success );
		jqXHR.fail( s.error );

		// Get transport
		transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

		// If no transport, we auto-abort
		if ( !transport ) {
			done( -1, "No Transport" );
		} else {
			jqXHR.readyState = 1;

			// Send global event
			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
			}

			// If request was aborted inside ajaxSend, stop there
			if ( completed ) {
				return jqXHR;
			}

			// Timeout
			if ( s.async && s.timeout > 0 ) {
				timeoutTimer = window.setTimeout( function() {
					jqXHR.abort( "timeout" );
				}, s.timeout );
			}

			try {
				completed = false;
				transport.send( requestHeaders, done );
			} catch ( e ) {

				// Rethrow post-completion exceptions
				if ( completed ) {
					throw e;
				}

				// Propagate others as results
				done( -1, e );
			}
		}

		// Callback for when everything is done
		function done( status, nativeStatusText, responses, headers ) {
			var isSuccess, success, error, response, modified,
				statusText = nativeStatusText;

			// Ignore repeat invocations
			if ( completed ) {
				return;
			}

			completed = true;

			// Clear timeout if it exists
			if ( timeoutTimer ) {
				window.clearTimeout( timeoutTimer );
			}

			// Dereference transport for early garbage collection
			// (no matter how long the jqXHR object will be used)
			transport = undefined;

			// Cache response headers
			responseHeadersString = headers || "";

			// Set readyState
			jqXHR.readyState = status > 0 ? 4 : 0;

			// Determine if successful
			isSuccess = status >= 200 && status < 300 || status === 304;

			// Get response data
			if ( responses ) {
				response = ajaxHandleResponses( s, jqXHR, responses );
			}

			// Use a noop converter for missing script but not if jsonp
			if ( !isSuccess &&
				jQuery.inArray( "script", s.dataTypes ) > -1 &&
				jQuery.inArray( "json", s.dataTypes ) < 0 ) {
				s.converters[ "text script" ] = function() {};
			}

			// Convert no matter what (that way responseXXX fields are always set)
			response = ajaxConvert( s, response, jqXHR, isSuccess );

			// If successful, handle type chaining
			if ( isSuccess ) {

				// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
				if ( s.ifModified ) {
					modified = jqXHR.getResponseHeader( "Last-Modified" );
					if ( modified ) {
						jQuery.lastModified[ cacheURL ] = modified;
					}
					modified = jqXHR.getResponseHeader( "etag" );
					if ( modified ) {
						jQuery.etag[ cacheURL ] = modified;
					}
				}

				// if no content
				if ( status === 204 || s.type === "HEAD" ) {
					statusText = "nocontent";

				// if not modified
				} else if ( status === 304 ) {
					statusText = "notmodified";

				// If we have data, let's convert it
				} else {
					statusText = response.state;
					success = response.data;
					error = response.error;
					isSuccess = !error;
				}
			} else {

				// Extract error from statusText and normalize for non-aborts
				error = statusText;
				if ( status || !statusText ) {
					statusText = "error";
					if ( status < 0 ) {
						status = 0;
					}
				}
			}

			// Set data for the fake xhr object
			jqXHR.status = status;
			jqXHR.statusText = ( nativeStatusText || statusText ) + "";

			// Success/Error
			if ( isSuccess ) {
				deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
			} else {
				deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
			}

			// Status-dependent callbacks
			jqXHR.statusCode( statusCode );
			statusCode = undefined;

			if ( fireGlobals ) {
				globalEventContext.trigger( isSuccess ? "ajaxSuccess" : "ajaxError",
					[ jqXHR, s, isSuccess ? success : error ] );
			}

			// Complete
			completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );

				// Handle the global AJAX counter
				if ( !( --jQuery.active ) ) {
					jQuery.event.trigger( "ajaxStop" );
				}
			}
		}

		return jqXHR;
	},

	getJSON: function( url, data, callback ) {
		return jQuery.get( url, data, callback, "json" );
	},

	getScript: function( url, callback ) {
		return jQuery.get( url, undefined, callback, "script" );
	}
} );

jQuery.each( [ "get", "post" ], function( _i, method ) {
	jQuery[ method ] = function( url, data, callback, type ) {

		// Shift arguments if data argument was omitted
		if ( isFunction( data ) ) {
			type = type || callback;
			callback = data;
			data = undefined;
		}

		// The url can be an options object (which then must have .url)
		return jQuery.ajax( jQuery.extend( {
			url: url,
			type: method,
			dataType: type,
			data: data,
			success: callback
		}, jQuery.isPlainObject( url ) && url ) );
	};
} );

jQuery.ajaxPrefilter( function( s ) {
	var i;
	for ( i in s.headers ) {
		if ( i.toLowerCase() === "content-type" ) {
			s.contentType = s.headers[ i ] || "";
		}
	}
} );


jQuery._evalUrl = function( url, options, doc ) {
	return jQuery.ajax( {
		url: url,

		// Make this explicit, since user can override this through ajaxSetup (trac-11264)
		type: "GET",
		dataType: "script",
		cache: true,
		async: false,
		global: false,

		// Only evaluate the response if it is successful (gh-4126)
		// dataFilter is not invoked for failure responses, so using it instead
		// of the default converter is kludgy but it works.
		converters: {
			"text script": function() {}
		},
		dataFilter: function( response ) {
			jQuery.globalEval( response, options, doc );
		}
	} );
};


jQuery.fn.extend( {
	wrapAll: function( html ) {
		var wrap;

		if ( this[ 0 ] ) {
			if ( isFunction( html ) ) {
				html = html.call( this[ 0 ] );
			}

			// The elements to wrap the target around
			wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );

			if ( this[ 0 ].parentNode ) {
				wrap.insertBefore( this[ 0 ] );
			}

			wrap.map( function() {
				var elem = this;

				while ( elem.firstElementChild ) {
					elem = elem.firstElementChild;
				}

				return elem;
			} ).append( this );
		}

		return this;
	},

	wrapInner: function( html ) {
		if ( isFunction( html ) ) {
			return this.each( function( i ) {
				jQuery( this ).wrapInner( html.call( this, i ) );
			} );
		}

		return this.each( function() {
			var self = jQuery( this ),
				contents = self.contents();

			if ( contents.length ) {
				contents.wrapAll( html );

			} else {
				self.append( html );
			}
		} );
	},

	wrap: function( html ) {
		var htmlIsFunction = isFunction( html );

		return this.each( function( i ) {
			jQuery( this ).wrapAll( htmlIsFunction ? html.call( this, i ) : html );
		} );
	},

	unwrap: function( selector ) {
		this.parent( selector ).not( "body" ).each( function() {
			jQuery( this ).replaceWith( this.childNodes );
		} );
		return this;
	}
} );


jQuery.expr.pseudos.hidden = function( elem ) {
	return !jQuery.expr.pseudos.visible( elem );
};
jQuery.expr.pseudos.visible = function( elem ) {
	return !!( elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length );
};




jQuery.ajaxSettings.xhr = function() {
	try {
		return new window.XMLHttpRequest();
	} catch ( e ) {}
};

var xhrSuccessStatus = {

		// File protocol always yields status code 0, assume 200
		0: 200,

		// Support: IE <=9 only
		// trac-1450: sometimes IE returns 1223 when it should be 204
		1223: 204
	},
	xhrSupported = jQuery.ajaxSettings.xhr();

support.cors = !!xhrSupported && ( "withCredentials" in xhrSupported );
support.ajax = xhrSupported = !!xhrSupported;

jQuery.ajaxTransport( function( options ) {
	var callback, errorCallback;

	// Cross domain only allowed if supported through XMLHttpRequest
	if ( support.cors || xhrSupported && !options.crossDomain ) {
		return {
			send: function( headers, complete ) {
				var i,
					xhr = options.xhr();

				xhr.open(
					options.type,
					options.url,
					options.async,
					options.username,
					options.password
				);

				// Apply custom fields if provided
				if ( options.xhrFields ) {
					for ( i in options.xhrFields ) {
						xhr[ i ] = options.xhrFields[ i ];
					}
				}

				// Override mime type if needed
				if ( options.mimeType && xhr.overrideMimeType ) {
					xhr.overrideMimeType( options.mimeType );
				}

				// X-Requested-With header
				// For cross-domain requests, seeing as conditions for a preflight are
				// akin to a jigsaw puzzle, we simply never set it to be sure.
				// (it can always be set on a per-request basis or even using ajaxSetup)
				// For same-domain requests, won't change header if already provided.
				if ( !options.crossDomain && !headers[ "X-Requested-With" ] ) {
					headers[ "X-Requested-With" ] = "XMLHttpRequest";
				}

				// Set headers
				for ( i in headers ) {
					xhr.setRequestHeader( i, headers[ i ] );
				}

				// Callback
				callback = function( type ) {
					return function() {
						if ( callback ) {
							callback = errorCallback = xhr.onload =
								xhr.onerror = xhr.onabort = xhr.ontimeout =
									xhr.onreadystatechange = null;

							if ( type === "abort" ) {
								xhr.abort();
							} else if ( type === "error" ) {

								// Support: IE <=9 only
								// On a manual native abort, IE9 throws
								// errors on any property access that is not readyState
								if ( typeof xhr.status !== "number" ) {
									complete( 0, "error" );
								} else {
									complete(

										// File: protocol always yields status 0; see trac-8605, trac-14207
										xhr.status,
										xhr.statusText
									);
								}
							} else {
								complete(
									xhrSuccessStatus[ xhr.status ] || xhr.status,
									xhr.statusText,

									// Support: IE <=9 only
									// IE9 has no XHR2 but throws on binary (trac-11426)
									// For XHR2 non-text, let the caller handle it (gh-2498)
									( xhr.responseType || "text" ) !== "text"  ||
									typeof xhr.responseText !== "string" ?
										{ binary: xhr.response } :
										{ text: xhr.responseText },
									xhr.getAllResponseHeaders()
								);
							}
						}
					};
				};

				// Listen to events
				xhr.onload = callback();
				errorCallback = xhr.onerror = xhr.ontimeout = callback( "error" );

				// Support: IE 9 only
				// Use onreadystatechange to replace onabort
				// to handle uncaught aborts
				if ( xhr.onabort !== undefined ) {
					xhr.onabort = errorCallback;
				} else {
					xhr.onreadystatechange = function() {

						// Check readyState before timeout as it changes
						if ( xhr.readyState === 4 ) {

							// Allow onerror to be called first,
							// but that will not handle a native abort
							// Also, save errorCallback to a variable
							// as xhr.onerror cannot be accessed
							window.setTimeout( function() {
								if ( callback ) {
									errorCallback();
								}
							} );
						}
					};
				}

				// Create the abort callback
				callback = callback( "abort" );

				try {

					// Do send the request (this may raise an exception)
					xhr.send( options.hasContent && options.data || null );
				} catch ( e ) {

					// trac-14683: Only rethrow if this hasn't been notified as an error yet
					if ( callback ) {
						throw e;
					}
				}
			},

			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




// Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)
jQuery.ajaxPrefilter( function( s ) {
	if ( s.crossDomain ) {
		s.contents.script = false;
	}
} );

// Install script dataType
jQuery.ajaxSetup( {
	accepts: {
		script: "text/javascript, application/javascript, " +
			"application/ecmascript, application/x-ecmascript"
	},
	contents: {
		script: /\b(?:java|ecma)script\b/
	},
	converters: {
		"text script": function( text ) {
			jQuery.globalEval( text );
			return text;
		}
	}
} );

// Handle cache's special case and crossDomain
jQuery.ajaxPrefilter( "script", function( s ) {
	if ( s.cache === undefined ) {
		s.cache = false;
	}
	if ( s.crossDomain ) {
		s.type = "GET";
	}
} );

// Bind script tag hack transport
jQuery.ajaxTransport( "script", function( s ) {

	// This transport only deals with cross domain or forced-by-attrs requests
	if ( s.crossDomain || s.scriptAttrs ) {
		var script, callback;
		return {
			send: function( _, complete ) {
				script = jQuery( "<script>" )
					.attr( s.scriptAttrs || {} )
					.prop( { charset: s.scriptCharset, src: s.url } )
					.on( "load error", callback = function( evt ) {
						script.remove();
						callback = null;
						if ( evt ) {
							complete( evt.type === "error" ? 404 : 200, evt.type );
						}
					} );

				// Use native DOM manipulation to avoid our domManip AJAX trickery
				document.head.appendChild( script[ 0 ] );
			},
			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




var oldCallbacks = [],
	rjsonp = /(=)\?(?=&|$)|\?\?/;

// Default jsonp settings
jQuery.ajaxSetup( {
	jsonp: "callback",
	jsonpCallback: function() {
		var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce.guid++ ) );
		this[ callback ] = true;
		return callback;
	}
} );

// Detect, normalize options and install callbacks for jsonp requests
jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

	var callbackName, overwritten, responseContainer,
		jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?
			"url" :
			typeof s.data === "string" &&
				( s.contentType || "" )
					.indexOf( "application/x-www-form-urlencoded" ) === 0 &&
				rjsonp.test( s.data ) && "data"
		);

	// Handle iff the expected data type is "jsonp" or we have a parameter to set
	if ( jsonProp || s.dataTypes[ 0 ] === "jsonp" ) {

		// Get callback name, remembering preexisting value associated with it
		callbackName = s.jsonpCallback = isFunction( s.jsonpCallback ) ?
			s.jsonpCallback() :
			s.jsonpCallback;

		// Insert callback into url or form data
		if ( jsonProp ) {
			s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, "$1" + callbackName );
		} else if ( s.jsonp !== false ) {
			s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
		}

		// Use data converter to retrieve json after script execution
		s.converters[ "script json" ] = function() {
			if ( !responseContainer ) {
				jQuery.error( callbackName + " was not called" );
			}
			return responseContainer[ 0 ];
		};

		// Force json dataType
		s.dataTypes[ 0 ] = "json";

		// Install callback
		overwritten = window[ callbackName ];
		window[ callbackName ] = function() {
			responseContainer = arguments;
		};

		// Clean-up function (fires after converters)
		jqXHR.always( function() {

			// If previous value didn't exist - remove it
			if ( overwritten === undefined ) {
				jQuery( window ).removeProp( callbackName );

			// Otherwise restore preexisting value
			} else {
				window[ callbackName ] = overwritten;
			}

			// Save back as free
			if ( s[ callbackName ] ) {

				// Make sure that re-using the options doesn't screw things around
				s.jsonpCallback = originalSettings.jsonpCallback;

				// Save the callback name for future use
				oldCallbacks.push( callbackName );
			}

			// Call if it was a function and we have a response
			if ( responseContainer && isFunction( overwritten ) ) {
				overwritten( responseContainer[ 0 ] );
			}

			responseContainer = overwritten = undefined;
		} );

		// Delegate to script
		return "script";
	}
} );




// Support: Safari 8 only
// In Safari 8 documents created via document.implementation.createHTMLDocument
// collapse sibling forms: the second one becomes a child of the first one.
// Because of that, this security measure has to be disabled in Safari 8.
// https://bugs.webkit.org/show_bug.cgi?id=137337
support.createHTMLDocument = ( function() {
	var body = document.implementation.createHTMLDocument( "" ).body;
	body.innerHTML = "<form></form><form></form>";
	return body.childNodes.length === 2;
} )();


// Argument "data" should be string of html
// context (optional): If specified, the fragment will be created in this context,
// defaults to document
// keepScripts (optional): If true, will include scripts passed in the html string
jQuery.parseHTML = function( data, context, keepScripts ) {
	if ( typeof data !== "string" ) {
		return [];
	}
	if ( typeof context === "boolean" ) {
		keepScripts = context;
		context = false;
	}

	var base, parsed, scripts;

	if ( !context ) {

		// Stop scripts or inline event handlers from being executed immediately
		// by using document.implementation
		if ( support.createHTMLDocument ) {
			context = document.implementation.createHTMLDocument( "" );

			// Set the base href for the created document
			// so any parsed elements with URLs
			// are based on the document's URL (gh-2965)
			base = context.createElement( "base" );
			base.href = document.location.href;
			context.head.appendChild( base );
		} else {
			context = document;
		}
	}

	parsed = rsingleTag.exec( data );
	scripts = !keepScripts && [];

	// Single tag
	if ( parsed ) {
		return [ context.createElement( parsed[ 1 ] ) ];
	}

	parsed = buildFragment( [ data ], context, scripts );

	if ( scripts && scripts.length ) {
		jQuery( scripts ).remove();
	}

	return jQuery.merge( [], parsed.childNodes );
};


/**
 * Load a url into a page
 */
jQuery.fn.load = function( url, params, callback ) {
	var selector, type, response,
		self = this,
		off = url.indexOf( " " );

	if ( off > -1 ) {
		selector = stripAndCollapse( url.slice( off ) );
		url = url.slice( 0, off );
	}

	// If it's a function
	if ( isFunction( params ) ) {

		// We assume that it's the callback
		callback = params;
		params = undefined;

	// Otherwise, build a param string
	} else if ( params && typeof params === "object" ) {
		type = "POST";
	}

	// If we have elements to modify, make the request
	if ( self.length > 0 ) {
		jQuery.ajax( {
			url: url,

			// If "type" variable is undefined, then "GET" method will be used.
			// Make value of this field explicit since
			// user can override it through ajaxSetup method
			type: type || "GET",
			dataType: "html",
			data: params
		} ).done( function( responseText ) {

			// Save response for use in complete callback
			response = arguments;

			self.html( selector ?

				// If a selector was specified, locate the right elements in a dummy div
				// Exclude scripts to avoid IE 'Permission Denied' errors
				jQuery( "<div>" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :

				// Otherwise use the full result
				responseText );

		// If the request succeeds, this function gets "data", "status", "jqXHR"
		// but they are ignored because response was set above.
		// If it fails, this function gets "jqXHR", "status", "error"
		} ).always( callback && function( jqXHR, status ) {
			self.each( function() {
				callback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );
			} );
		} );
	}

	return this;
};




jQuery.expr.pseudos.animated = function( elem ) {
	return jQuery.grep( jQuery.timers, function( fn ) {
		return elem === fn.elem;
	} ).length;
};




jQuery.offset = {
	setOffset: function( elem, options, i ) {
		var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,
			position = jQuery.css( elem, "position" ),
			curElem = jQuery( elem ),
			props = {};

		// Set position first, in-case top/left are set even on static elem
		if ( position === "static" ) {
			elem.style.position = "relative";
		}

		curOffset = curElem.offset();
		curCSSTop = jQuery.css( elem, "top" );
		curCSSLeft = jQuery.css( elem, "left" );
		calculatePosition = ( position === "absolute" || position === "fixed" ) &&
			( curCSSTop + curCSSLeft ).indexOf( "auto" ) > -1;

		// Need to be able to calculate position if either
		// top or left is auto and position is either absolute or fixed
		if ( calculatePosition ) {
			curPosition = curElem.position();
			curTop = curPosition.top;
			curLeft = curPosition.left;

		} else {
			curTop = parseFloat( curCSSTop ) || 0;
			curLeft = parseFloat( curCSSLeft ) || 0;
		}

		if ( isFunction( options ) ) {

			// Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
			options = options.call( elem, i, jQuery.extend( {}, curOffset ) );
		}

		if ( options.top != null ) {
			props.top = ( options.top - curOffset.top ) + curTop;
		}
		if ( options.left != null ) {
			props.left = ( options.left - curOffset.left ) + curLeft;
		}

		if ( "using" in options ) {
			options.using.call( elem, props );

		} else {
			curElem.css( props );
		}
	}
};

jQuery.fn.extend( {

	// offset() relates an element's border box to the document origin
	offset: function( options ) {

		// Preserve chaining for setter
		if ( arguments.length ) {
			return options === undefined ?
				this :
				this.each( function( i ) {
					jQuery.offset.setOffset( this, options, i );
				} );
		}

		var rect, win,
			elem = this[ 0 ];

		if ( !elem ) {
			return;
		}

		// Return zeros for disconnected and hidden (display: none) elements (gh-2310)
		// Support: IE <=11 only
		// Running getBoundingClientRect on a
		// disconnected node in IE throws an error
		if ( !elem.getClientRects().length ) {
			return { top: 0, left: 0 };
		}

		// Get document-relative position by adding viewport scroll to viewport-relative gBCR
		rect = elem.getBoundingClientRect();
		win = elem.ownerDocument.defaultView;
		return {
			top: rect.top + win.pageYOffset,
			left: rect.left + win.pageXOffset
		};
	},

	// position() relates an element's margin box to its offset parent's padding box
	// This corresponds to the behavior of CSS absolute positioning
	position: function() {
		if ( !this[ 0 ] ) {
			return;
		}

		var offsetParent, offset, doc,
			elem = this[ 0 ],
			parentOffset = { top: 0, left: 0 };

		// position:fixed elements are offset from the viewport, which itself always has zero offset
		if ( jQuery.css( elem, "position" ) === "fixed" ) {

			// Assume position:fixed implies availability of getBoundingClientRect
			offset = elem.getBoundingClientRect();

		} else {
			offset = this.offset();

			// Account for the *real* offset parent, which can be the document or its root element
			// when a statically positioned element is identified
			doc = elem.ownerDocument;
			offsetParent = elem.offsetParent || doc.documentElement;
			while ( offsetParent &&
				( offsetParent === doc.body || offsetParent === doc.documentElement ) &&
				jQuery.css( offsetParent, "position" ) === "static" ) {

				offsetParent = offsetParent.parentNode;
			}
			if ( offsetParent && offsetParent !== elem && offsetParent.nodeType === 1 ) {

				// Incorporate borders into its offset, since they are outside its content origin
				parentOffset = jQuery( offsetParent ).offset();
				parentOffset.top += jQuery.css( offsetParent, "borderTopWidth", true );
				parentOffset.left += jQuery.css( offsetParent, "borderLeftWidth", true );
			}
		}

		// Subtract parent offsets and element margins
		return {
			top: offset.top - parentOffset.top - jQuery.css( elem, "marginTop", true ),
			left: offset.left - parentOffset.left - jQuery.css( elem, "marginLeft", true )
		};
	},

	// This method will return documentElement in the following cases:
	// 1) For the element inside the iframe without offsetParent, this method will return
	//    documentElement of the parent window
	// 2) For the hidden or detached element
	// 3) For body or html element, i.e. in case of the html node - it will return itself
	//
	// but those exceptions were never presented as a real life use-cases
	// and might be considered as more preferable results.
	//
	// This logic, however, is not guaranteed and can change at any point in the future
	offsetParent: function() {
		return this.map( function() {
			var offsetParent = this.offsetParent;

			while ( offsetParent && jQuery.css( offsetParent, "position" ) === "static" ) {
				offsetParent = offsetParent.offsetParent;
			}

			return offsetParent || documentElement;
		} );
	}
} );

// Create scrollLeft and scrollTop methods
jQuery.each( { scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function( method, prop ) {
	var top = "pageYOffset" === prop;

	jQuery.fn[ method ] = function( val ) {
		return access( this, function( elem, method, val ) {

			// Coalesce documents and windows
			var win;
			if ( isWindow( elem ) ) {
				win = elem;
			} else if ( elem.nodeType === 9 ) {
				win = elem.defaultView;
			}

			if ( val === undefined ) {
				return win ? win[ prop ] : elem[ method ];
			}

			if ( win ) {
				win.scrollTo(
					!top ? val : win.pageXOffset,
					top ? val : win.pageYOffset
				);

			} else {
				elem[ method ] = val;
			}
		}, method, val, arguments.length );
	};
} );

// Support: Safari <=7 - 9.1, Chrome <=37 - 49
// Add the top/left cssHooks using jQuery.fn.position
// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
// Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347
// getComputedStyle returns percent when specified for top/left/bottom/right;
// rather than make the css module depend on the offset module, just check for it here
jQuery.each( [ "top", "left" ], function( _i, prop ) {
	jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,
		function( elem, computed ) {
			if ( computed ) {
				computed = curCSS( elem, prop );

				// If curCSS returns percentage, fallback to offset
				return rnumnonpx.test( computed ) ?
					jQuery( elem ).position()[ prop ] + "px" :
					computed;
			}
		}
	);
} );


// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
	jQuery.each( {
		padding: "inner" + name,
		content: type,
		"": "outer" + name
	}, function( defaultExtra, funcName ) {

		// Margin is only for outerHeight, outerWidth
		jQuery.fn[ funcName ] = function( margin, value ) {
			var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
				extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

			return access( this, function( elem, type, value ) {
				var doc;

				if ( isWindow( elem ) ) {

					// $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)
					return funcName.indexOf( "outer" ) === 0 ?
						elem[ "inner" + name ] :
						elem.document.documentElement[ "client" + name ];
				}

				// Get document width or height
				if ( elem.nodeType === 9 ) {
					doc = elem.documentElement;

					// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
					// whichever is greatest
					return Math.max(
						elem.body[ "scroll" + name ], doc[ "scroll" + name ],
						elem.body[ "offset" + name ], doc[ "offset" + name ],
						doc[ "client" + name ]
					);
				}

				return value === undefined ?

					// Get width or height on the element, requesting but not forcing parseFloat
					jQuery.css( elem, type, extra ) :

					// Set width or height on the element
					jQuery.style( elem, type, value, extra );
			}, type, chainable ? margin : undefined, chainable );
		};
	} );
} );


jQuery.each( [
	"ajaxStart",
	"ajaxStop",
	"ajaxComplete",
	"ajaxError",
	"ajaxSuccess",
	"ajaxSend"
], function( _i, type ) {
	jQuery.fn[ type ] = function( fn ) {
		return this.on( type, fn );
	};
} );




jQuery.fn.extend( {

	bind: function( types, data, fn ) {
		return this.on( types, null, data, fn );
	},
	unbind: function( types, fn ) {
		return this.off( types, null, fn );
	},

	delegate: function( selector, types, data, fn ) {
		return this.on( types, selector, data, fn );
	},
	undelegate: function( selector, types, fn ) {

		// ( namespace ) or ( selector, types [, fn] )
		return arguments.length === 1 ?
			this.off( selector, "**" ) :
			this.off( types, selector || "**", fn );
	},

	hover: function( fnOver, fnOut ) {
		return this
			.on( "mouseenter", fnOver )
			.on( "mouseleave", fnOut || fnOver );
	}
} );

jQuery.each(
	( "blur focus focusin focusout resize scroll click dblclick " +
	"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
	"change select submit keydown keypress keyup contextmenu" ).split( " " ),
	function( _i, name ) {

		// Handle event binding
		jQuery.fn[ name ] = function( data, fn ) {
			return arguments.length > 0 ?
				this.on( name, null, data, fn ) :
				this.trigger( name );
		};
	}
);




// Support: Android <=4.0 only
// Make sure we trim BOM and NBSP
// Require that the "whitespace run" starts from a non-whitespace
// to avoid O(N^2) behavior when the engine would try matching "\s+$" at each space position.
var rtrim = /^[\s\uFEFF\xA0]+|([^\s\uFEFF\xA0])[\s\uFEFF\xA0]+$/g;

// Bind a function to a context, optionally partially applying any
// arguments.
// jQuery.proxy is deprecated to promote standards (specifically Function#bind)
// However, it is not slated for removal any time soon
jQuery.proxy = function( fn, context ) {
	var tmp, args, proxy;

	if ( typeof context === "string" ) {
		tmp = fn[ context ];
		context = fn;
		fn = tmp;
	}

	// Quick check to determine if target is callable, in the spec
	// this throws a TypeError, but we will just return undefined.
	if ( !isFunction( fn ) ) {
		return undefined;
	}

	// Simulated bind
	args = slice.call( arguments, 2 );
	proxy = function() {
		return fn.apply( context || this, args.concat( slice.call( arguments ) ) );
	};

	// Set the guid of unique handler to the same of original handler, so it can be removed
	proxy.guid = fn.guid = fn.guid || jQuery.guid++;

	return proxy;
};

jQuery.holdReady = function( hold ) {
	if ( hold ) {
		jQuery.readyWait++;
	} else {
		jQuery.ready( true );
	}
};
jQuery.isArray = Array.isArray;
jQuery.parseJSON = JSON.parse;
jQuery.nodeName = nodeName;
jQuery.isFunction = isFunction;
jQuery.isWindow = isWindow;
jQuery.camelCase = camelCase;
jQuery.type = toType;

jQuery.now = Date.now;

jQuery.isNumeric = function( obj ) {

	// As of jQuery 3.0, isNumeric is limited to
	// strings and numbers (primitives or objects)
	// that can be coerced to finite numbers (gh-2662)
	var type = jQuery.type( obj );
	return ( type === "number" || type === "string" ) &&

		// parseFloat NaNs numeric-cast false positives ("")
		// ...but misinterprets leading-number strings, particularly hex literals ("0x...")
		// subtraction forces infinities to NaN
		!isNaN( obj - parseFloat( obj ) );
};

jQuery.trim = function( text ) {
	return text == null ?
		"" :
		( text + "" ).replace( rtrim, "$1" );
};



// Register as a named AMD module, since jQuery can be concatenated with other
// files that may use define, but not via a proper concatenation script that
// understands anonymous AMD modules. A named AMD is safest and most robust
// way to register. Lowercase jquery is used because AMD module names are
// derived from file names, and jQuery is normally delivered in a lowercase
// file name. Do this after creating the global so that if an AMD module wants
// to call noConflict to hide this version of jQuery, it will work.

// Note that for maximum portability, libraries that are not jQuery should
// declare themselves as anonymous modules, and avoid setting a global if an
// AMD loader is present. jQuery is a special case. For more information, see
// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon

if ( typeof define === "function" && define.amd ) {
	define( "jquery", [], function() {
		return jQuery;
	} );
}




var

	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$;

jQuery.noConflict = function( deep ) {
	if ( window.$ === jQuery ) {
		window.$ = _$;
	}

	if ( deep && window.jQuery === jQuery ) {
		window.jQuery = _jQuery;
	}

	return jQuery;
};

// Expose jQuery and $ identifiers, even in AMD
// (trac-7102#comment:10, https://github.com/jquery/jquery/pull/557)
// and CommonJS for browser emulators (trac-13566)
if ( typeof noGlobal === "undefined" ) {
	window.jQuery = window.$ = jQuery;
}




return jQuery;
} );

;/*!
  * Bootstrap v4.6.2 (https://getbootstrap.com/)
  * Copyright 2011-2022 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)
  * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
  */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('jquery'), require('popper.js')) :
  typeof define === 'function' && define.amd ? define(['exports', 'jquery', 'popper.js'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.bootstrap = {}, global.jQuery, global.Popper));
})(this, (function (exports, $, Popper) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  var $__default = /*#__PURE__*/_interopDefaultLegacy($);
  var Popper__default = /*#__PURE__*/_interopDefaultLegacy(Popper);

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }

  function _extends() {
    _extends = Object.assign ? Object.assign.bind() : function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };
    return _extends.apply(this, arguments);
  }

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;

    _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };
    return _setPrototypeOf(o, p);
  }

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v4.6.2): util.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * Private TransitionEnd Helpers
   */

  var TRANSITION_END = 'transitionend';
  var MAX_UID = 1000000;
  var MILLISECONDS_MULTIPLIER = 1000; // Shoutout AngusCroll (https://goo.gl/pxwQGp)

  function toType(obj) {
    if (obj === null || typeof obj === 'undefined') {
      return "" + obj;
    }

    return {}.toString.call(obj).match(/\s([a-z]+)/i)[1].toLowerCase();
  }

  function getSpecialTransitionEndEvent() {
    return {
      bindType: TRANSITION_END,
      delegateType: TRANSITION_END,
      handle: function handle(event) {
        if ($__default["default"](event.target).is(this)) {
          return event.handleObj.handler.apply(this, arguments); // eslint-disable-line prefer-rest-params
        }

        return undefined;
      }
    };
  }

  function transitionEndEmulator(duration) {
    var _this = this;

    var called = false;
    $__default["default"](this).one(Util.TRANSITION_END, function () {
      called = true;
    });
    setTimeout(function () {
      if (!called) {
        Util.triggerTransitionEnd(_this);
      }
    }, duration);
    return this;
  }

  function setTransitionEndSupport() {
    $__default["default"].fn.emulateTransitionEnd = transitionEndEmulator;
    $__default["default"].event.special[Util.TRANSITION_END] = getSpecialTransitionEndEvent();
  }
  /**
   * Public Util API
   */


  var Util = {
    TRANSITION_END: 'bsTransitionEnd',
    getUID: function getUID(prefix) {
      do {
        // eslint-disable-next-line no-bitwise
        prefix += ~~(Math.random() * MAX_UID); // "~~" acts like a faster Math.floor() here
      } while (document.getElementById(prefix));

      return prefix;
    },
    getSelectorFromElement: function getSelectorFromElement(element) {
      var selector = element.getAttribute('data-target');

      if (!selector || selector === '#') {
        var hrefAttr = element.getAttribute('href');
        selector = hrefAttr && hrefAttr !== '#' ? hrefAttr.trim() : '';
      }

      try {
        return document.querySelector(selector) ? selector : null;
      } catch (_) {
        return null;
      }
    },
    getTransitionDurationFromElement: function getTransitionDurationFromElement(element) {
      if (!element) {
        return 0;
      } // Get transition-duration of the element


      var transitionDuration = $__default["default"](element).css('transition-duration');
      var transitionDelay = $__default["default"](element).css('transition-delay');
      var floatTransitionDuration = parseFloat(transitionDuration);
      var floatTransitionDelay = parseFloat(transitionDelay); // Return 0 if element or transition duration is not found

      if (!floatTransitionDuration && !floatTransitionDelay) {
        return 0;
      } // If multiple durations are defined, take the first


      transitionDuration = transitionDuration.split(',')[0];
      transitionDelay = transitionDelay.split(',')[0];
      return (parseFloat(transitionDuration) + parseFloat(transitionDelay)) * MILLISECONDS_MULTIPLIER;
    },
    reflow: function reflow(element) {
      return element.offsetHeight;
    },
    triggerTransitionEnd: function triggerTransitionEnd(element) {
      $__default["default"](element).trigger(TRANSITION_END);
    },
    supportsTransitionEnd: function supportsTransitionEnd() {
      return Boolean(TRANSITION_END);
    },
    isElement: function isElement(obj) {
      return (obj[0] || obj).nodeType;
    },
    typeCheckConfig: function typeCheckConfig(componentName, config, configTypes) {
      for (var property in configTypes) {
        if (Object.prototype.hasOwnProperty.call(configTypes, property)) {
          var expectedTypes = configTypes[property];
          var value = config[property];
          var valueType = value && Util.isElement(value) ? 'element' : toType(value);

          if (!new RegExp(expectedTypes).test(valueType)) {
            throw new Error(componentName.toUpperCase() + ": " + ("Option \"" + property + "\" provided type \"" + valueType + "\" ") + ("but expected type \"" + expectedTypes + "\"."));
          }
        }
      }
    },
    findShadowRoot: function findShadowRoot(element) {
      if (!document.documentElement.attachShadow) {
        return null;
      } // Can find the shadow root otherwise it'll return the document


      if (typeof element.getRootNode === 'function') {
        var root = element.getRootNode();
        return root instanceof ShadowRoot ? root : null;
      }

      if (element instanceof ShadowRoot) {
        return element;
      } // when we don't find a shadow root


      if (!element.parentNode) {
        return null;
      }

      return Util.findShadowRoot(element.parentNode);
    },
    jQueryDetection: function jQueryDetection() {
      if (typeof $__default["default"] === 'undefined') {
        throw new TypeError('Bootstrap\'s JavaScript requires jQuery. jQuery must be included before Bootstrap\'s JavaScript.');
      }

      var version = $__default["default"].fn.jquery.split(' ')[0].split('.');
      var minMajor = 1;
      var ltMajor = 2;
      var minMinor = 9;
      var minPatch = 1;
      var maxMajor = 4;

      if (version[0] < ltMajor && version[1] < minMinor || version[0] === minMajor && version[1] === minMinor && version[2] < minPatch || version[0] >= maxMajor) {
        throw new Error('Bootstrap\'s JavaScript requires at least jQuery v1.9.1 but less than v4.0.0');
      }
    }
  };
  Util.jQueryDetection();
  setTransitionEndSupport();

  /**
   * Constants
   */

  var NAME$a = 'alert';
  var VERSION$a = '4.6.2';
  var DATA_KEY$a = 'bs.alert';
  var EVENT_KEY$a = "." + DATA_KEY$a;
  var DATA_API_KEY$7 = '.data-api';
  var JQUERY_NO_CONFLICT$a = $__default["default"].fn[NAME$a];
  var CLASS_NAME_ALERT = 'alert';
  var CLASS_NAME_FADE$5 = 'fade';
  var CLASS_NAME_SHOW$7 = 'show';
  var EVENT_CLOSE = "close" + EVENT_KEY$a;
  var EVENT_CLOSED = "closed" + EVENT_KEY$a;
  var EVENT_CLICK_DATA_API$6 = "click" + EVENT_KEY$a + DATA_API_KEY$7;
  var SELECTOR_DISMISS = '[data-dismiss="alert"]';
  /**
   * Class definition
   */

  var Alert = /*#__PURE__*/function () {
    function Alert(element) {
      this._element = element;
    } // Getters


    var _proto = Alert.prototype;

    // Public
    _proto.close = function close(element) {
      var rootElement = this._element;

      if (element) {
        rootElement = this._getRootElement(element);
      }

      var customEvent = this._triggerCloseEvent(rootElement);

      if (customEvent.isDefaultPrevented()) {
        return;
      }

      this._removeElement(rootElement);
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$a);
      this._element = null;
    } // Private
    ;

    _proto._getRootElement = function _getRootElement(element) {
      var selector = Util.getSelectorFromElement(element);
      var parent = false;

      if (selector) {
        parent = document.querySelector(selector);
      }

      if (!parent) {
        parent = $__default["default"](element).closest("." + CLASS_NAME_ALERT)[0];
      }

      return parent;
    };

    _proto._triggerCloseEvent = function _triggerCloseEvent(element) {
      var closeEvent = $__default["default"].Event(EVENT_CLOSE);
      $__default["default"](element).trigger(closeEvent);
      return closeEvent;
    };

    _proto._removeElement = function _removeElement(element) {
      var _this = this;

      $__default["default"](element).removeClass(CLASS_NAME_SHOW$7);

      if (!$__default["default"](element).hasClass(CLASS_NAME_FADE$5)) {
        this._destroyElement(element);

        return;
      }

      var transitionDuration = Util.getTransitionDurationFromElement(element);
      $__default["default"](element).one(Util.TRANSITION_END, function (event) {
        return _this._destroyElement(element, event);
      }).emulateTransitionEnd(transitionDuration);
    };

    _proto._destroyElement = function _destroyElement(element) {
      $__default["default"](element).detach().trigger(EVENT_CLOSED).remove();
    } // Static
    ;

    Alert._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $element = $__default["default"](this);
        var data = $element.data(DATA_KEY$a);

        if (!data) {
          data = new Alert(this);
          $element.data(DATA_KEY$a, data);
        }

        if (config === 'close') {
          data[config](this);
        }
      });
    };

    Alert._handleDismiss = function _handleDismiss(alertInstance) {
      return function (event) {
        if (event) {
          event.preventDefault();
        }

        alertInstance.close(this);
      };
    };

    _createClass(Alert, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$a;
      }
    }]);

    return Alert;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API$6, SELECTOR_DISMISS, Alert._handleDismiss(new Alert()));
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$a] = Alert._jQueryInterface;
  $__default["default"].fn[NAME$a].Constructor = Alert;

  $__default["default"].fn[NAME$a].noConflict = function () {
    $__default["default"].fn[NAME$a] = JQUERY_NO_CONFLICT$a;
    return Alert._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$9 = 'button';
  var VERSION$9 = '4.6.2';
  var DATA_KEY$9 = 'bs.button';
  var EVENT_KEY$9 = "." + DATA_KEY$9;
  var DATA_API_KEY$6 = '.data-api';
  var JQUERY_NO_CONFLICT$9 = $__default["default"].fn[NAME$9];
  var CLASS_NAME_ACTIVE$3 = 'active';
  var CLASS_NAME_BUTTON = 'btn';
  var CLASS_NAME_FOCUS = 'focus';
  var EVENT_CLICK_DATA_API$5 = "click" + EVENT_KEY$9 + DATA_API_KEY$6;
  var EVENT_FOCUS_BLUR_DATA_API = "focus" + EVENT_KEY$9 + DATA_API_KEY$6 + " " + ("blur" + EVENT_KEY$9 + DATA_API_KEY$6);
  var EVENT_LOAD_DATA_API$2 = "load" + EVENT_KEY$9 + DATA_API_KEY$6;
  var SELECTOR_DATA_TOGGLE_CARROT = '[data-toggle^="button"]';
  var SELECTOR_DATA_TOGGLES = '[data-toggle="buttons"]';
  var SELECTOR_DATA_TOGGLE$4 = '[data-toggle="button"]';
  var SELECTOR_DATA_TOGGLES_BUTTONS = '[data-toggle="buttons"] .btn';
  var SELECTOR_INPUT = 'input:not([type="hidden"])';
  var SELECTOR_ACTIVE$2 = '.active';
  var SELECTOR_BUTTON = '.btn';
  /**
   * Class definition
   */

  var Button = /*#__PURE__*/function () {
    function Button(element) {
      this._element = element;
      this.shouldAvoidTriggerChange = false;
    } // Getters


    var _proto = Button.prototype;

    // Public
    _proto.toggle = function toggle() {
      var triggerChangeEvent = true;
      var addAriaPressed = true;
      var rootElement = $__default["default"](this._element).closest(SELECTOR_DATA_TOGGLES)[0];

      if (rootElement) {
        var input = this._element.querySelector(SELECTOR_INPUT);

        if (input) {
          if (input.type === 'radio') {
            if (input.checked && this._element.classList.contains(CLASS_NAME_ACTIVE$3)) {
              triggerChangeEvent = false;
            } else {
              var activeElement = rootElement.querySelector(SELECTOR_ACTIVE$2);

              if (activeElement) {
                $__default["default"](activeElement).removeClass(CLASS_NAME_ACTIVE$3);
              }
            }
          }

          if (triggerChangeEvent) {
            // if it's not a radio button or checkbox don't add a pointless/invalid checked property to the input
            if (input.type === 'checkbox' || input.type === 'radio') {
              input.checked = !this._element.classList.contains(CLASS_NAME_ACTIVE$3);
            }

            if (!this.shouldAvoidTriggerChange) {
              $__default["default"](input).trigger('change');
            }
          }

          input.focus();
          addAriaPressed = false;
        }
      }

      if (!(this._element.hasAttribute('disabled') || this._element.classList.contains('disabled'))) {
        if (addAriaPressed) {
          this._element.setAttribute('aria-pressed', !this._element.classList.contains(CLASS_NAME_ACTIVE$3));
        }

        if (triggerChangeEvent) {
          $__default["default"](this._element).toggleClass(CLASS_NAME_ACTIVE$3);
        }
      }
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$9);
      this._element = null;
    } // Static
    ;

    Button._jQueryInterface = function _jQueryInterface(config, avoidTriggerChange) {
      return this.each(function () {
        var $element = $__default["default"](this);
        var data = $element.data(DATA_KEY$9);

        if (!data) {
          data = new Button(this);
          $element.data(DATA_KEY$9, data);
        }

        data.shouldAvoidTriggerChange = avoidTriggerChange;

        if (config === 'toggle') {
          data[config]();
        }
      });
    };

    _createClass(Button, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$9;
      }
    }]);

    return Button;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API$5, SELECTOR_DATA_TOGGLE_CARROT, function (event) {
    var button = event.target;
    var initialButton = button;

    if (!$__default["default"](button).hasClass(CLASS_NAME_BUTTON)) {
      button = $__default["default"](button).closest(SELECTOR_BUTTON)[0];
    }

    if (!button || button.hasAttribute('disabled') || button.classList.contains('disabled')) {
      event.preventDefault(); // work around Firefox bug #1540995
    } else {
      var inputBtn = button.querySelector(SELECTOR_INPUT);

      if (inputBtn && (inputBtn.hasAttribute('disabled') || inputBtn.classList.contains('disabled'))) {
        event.preventDefault(); // work around Firefox bug #1540995

        return;
      }

      if (initialButton.tagName === 'INPUT' || button.tagName !== 'LABEL') {
        Button._jQueryInterface.call($__default["default"](button), 'toggle', initialButton.tagName === 'INPUT');
      }
    }
  }).on(EVENT_FOCUS_BLUR_DATA_API, SELECTOR_DATA_TOGGLE_CARROT, function (event) {
    var button = $__default["default"](event.target).closest(SELECTOR_BUTTON)[0];
    $__default["default"](button).toggleClass(CLASS_NAME_FOCUS, /^focus(in)?$/.test(event.type));
  });
  $__default["default"](window).on(EVENT_LOAD_DATA_API$2, function () {
    // ensure correct active class is set to match the controls' actual values/states
    // find all checkboxes/readio buttons inside data-toggle groups
    var buttons = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLES_BUTTONS));

    for (var i = 0, len = buttons.length; i < len; i++) {
      var button = buttons[i];
      var input = button.querySelector(SELECTOR_INPUT);

      if (input.checked || input.hasAttribute('checked')) {
        button.classList.add(CLASS_NAME_ACTIVE$3);
      } else {
        button.classList.remove(CLASS_NAME_ACTIVE$3);
      }
    } // find all button toggles


    buttons = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$4));

    for (var _i = 0, _len = buttons.length; _i < _len; _i++) {
      var _button = buttons[_i];

      if (_button.getAttribute('aria-pressed') === 'true') {
        _button.classList.add(CLASS_NAME_ACTIVE$3);
      } else {
        _button.classList.remove(CLASS_NAME_ACTIVE$3);
      }
    }
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$9] = Button._jQueryInterface;
  $__default["default"].fn[NAME$9].Constructor = Button;

  $__default["default"].fn[NAME$9].noConflict = function () {
    $__default["default"].fn[NAME$9] = JQUERY_NO_CONFLICT$9;
    return Button._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$8 = 'carousel';
  var VERSION$8 = '4.6.2';
  var DATA_KEY$8 = 'bs.carousel';
  var EVENT_KEY$8 = "." + DATA_KEY$8;
  var DATA_API_KEY$5 = '.data-api';
  var JQUERY_NO_CONFLICT$8 = $__default["default"].fn[NAME$8];
  var ARROW_LEFT_KEYCODE = 37; // KeyboardEvent.which value for left arrow key

  var ARROW_RIGHT_KEYCODE = 39; // KeyboardEvent.which value for right arrow key

  var TOUCHEVENT_COMPAT_WAIT = 500; // Time for mouse compat events to fire after touch

  var SWIPE_THRESHOLD = 40;
  var CLASS_NAME_CAROUSEL = 'carousel';
  var CLASS_NAME_ACTIVE$2 = 'active';
  var CLASS_NAME_SLIDE = 'slide';
  var CLASS_NAME_RIGHT = 'carousel-item-right';
  var CLASS_NAME_LEFT = 'carousel-item-left';
  var CLASS_NAME_NEXT = 'carousel-item-next';
  var CLASS_NAME_PREV = 'carousel-item-prev';
  var CLASS_NAME_POINTER_EVENT = 'pointer-event';
  var DIRECTION_NEXT = 'next';
  var DIRECTION_PREV = 'prev';
  var DIRECTION_LEFT = 'left';
  var DIRECTION_RIGHT = 'right';
  var EVENT_SLIDE = "slide" + EVENT_KEY$8;
  var EVENT_SLID = "slid" + EVENT_KEY$8;
  var EVENT_KEYDOWN = "keydown" + EVENT_KEY$8;
  var EVENT_MOUSEENTER = "mouseenter" + EVENT_KEY$8;
  var EVENT_MOUSELEAVE = "mouseleave" + EVENT_KEY$8;
  var EVENT_TOUCHSTART = "touchstart" + EVENT_KEY$8;
  var EVENT_TOUCHMOVE = "touchmove" + EVENT_KEY$8;
  var EVENT_TOUCHEND = "touchend" + EVENT_KEY$8;
  var EVENT_POINTERDOWN = "pointerdown" + EVENT_KEY$8;
  var EVENT_POINTERUP = "pointerup" + EVENT_KEY$8;
  var EVENT_DRAG_START = "dragstart" + EVENT_KEY$8;
  var EVENT_LOAD_DATA_API$1 = "load" + EVENT_KEY$8 + DATA_API_KEY$5;
  var EVENT_CLICK_DATA_API$4 = "click" + EVENT_KEY$8 + DATA_API_KEY$5;
  var SELECTOR_ACTIVE$1 = '.active';
  var SELECTOR_ACTIVE_ITEM = '.active.carousel-item';
  var SELECTOR_ITEM = '.carousel-item';
  var SELECTOR_ITEM_IMG = '.carousel-item img';
  var SELECTOR_NEXT_PREV = '.carousel-item-next, .carousel-item-prev';
  var SELECTOR_INDICATORS = '.carousel-indicators';
  var SELECTOR_DATA_SLIDE = '[data-slide], [data-slide-to]';
  var SELECTOR_DATA_RIDE = '[data-ride="carousel"]';
  var Default$7 = {
    interval: 5000,
    keyboard: true,
    slide: false,
    pause: 'hover',
    wrap: true,
    touch: true
  };
  var DefaultType$7 = {
    interval: '(number|boolean)',
    keyboard: 'boolean',
    slide: '(boolean|string)',
    pause: '(string|boolean)',
    wrap: 'boolean',
    touch: 'boolean'
  };
  var PointerType = {
    TOUCH: 'touch',
    PEN: 'pen'
  };
  /**
   * Class definition
   */

  var Carousel = /*#__PURE__*/function () {
    function Carousel(element, config) {
      this._items = null;
      this._interval = null;
      this._activeElement = null;
      this._isPaused = false;
      this._isSliding = false;
      this.touchTimeout = null;
      this.touchStartX = 0;
      this.touchDeltaX = 0;
      this._config = this._getConfig(config);
      this._element = element;
      this._indicatorsElement = this._element.querySelector(SELECTOR_INDICATORS);
      this._touchSupported = 'ontouchstart' in document.documentElement || navigator.maxTouchPoints > 0;
      this._pointerEvent = Boolean(window.PointerEvent || window.MSPointerEvent);

      this._addEventListeners();
    } // Getters


    var _proto = Carousel.prototype;

    // Public
    _proto.next = function next() {
      if (!this._isSliding) {
        this._slide(DIRECTION_NEXT);
      }
    };

    _proto.nextWhenVisible = function nextWhenVisible() {
      var $element = $__default["default"](this._element); // Don't call next when the page isn't visible
      // or the carousel or its parent isn't visible

      if (!document.hidden && $element.is(':visible') && $element.css('visibility') !== 'hidden') {
        this.next();
      }
    };

    _proto.prev = function prev() {
      if (!this._isSliding) {
        this._slide(DIRECTION_PREV);
      }
    };

    _proto.pause = function pause(event) {
      if (!event) {
        this._isPaused = true;
      }

      if (this._element.querySelector(SELECTOR_NEXT_PREV)) {
        Util.triggerTransitionEnd(this._element);
        this.cycle(true);
      }

      clearInterval(this._interval);
      this._interval = null;
    };

    _proto.cycle = function cycle(event) {
      if (!event) {
        this._isPaused = false;
      }

      if (this._interval) {
        clearInterval(this._interval);
        this._interval = null;
      }

      if (this._config.interval && !this._isPaused) {
        this._updateInterval();

        this._interval = setInterval((document.visibilityState ? this.nextWhenVisible : this.next).bind(this), this._config.interval);
      }
    };

    _proto.to = function to(index) {
      var _this = this;

      this._activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM);

      var activeIndex = this._getItemIndex(this._activeElement);

      if (index > this._items.length - 1 || index < 0) {
        return;
      }

      if (this._isSliding) {
        $__default["default"](this._element).one(EVENT_SLID, function () {
          return _this.to(index);
        });
        return;
      }

      if (activeIndex === index) {
        this.pause();
        this.cycle();
        return;
      }

      var direction = index > activeIndex ? DIRECTION_NEXT : DIRECTION_PREV;

      this._slide(direction, this._items[index]);
    };

    _proto.dispose = function dispose() {
      $__default["default"](this._element).off(EVENT_KEY$8);
      $__default["default"].removeData(this._element, DATA_KEY$8);
      this._items = null;
      this._config = null;
      this._element = null;
      this._interval = null;
      this._isPaused = null;
      this._isSliding = null;
      this._activeElement = null;
      this._indicatorsElement = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default$7, config);
      Util.typeCheckConfig(NAME$8, config, DefaultType$7);
      return config;
    };

    _proto._handleSwipe = function _handleSwipe() {
      var absDeltax = Math.abs(this.touchDeltaX);

      if (absDeltax <= SWIPE_THRESHOLD) {
        return;
      }

      var direction = absDeltax / this.touchDeltaX;
      this.touchDeltaX = 0; // swipe left

      if (direction > 0) {
        this.prev();
      } // swipe right


      if (direction < 0) {
        this.next();
      }
    };

    _proto._addEventListeners = function _addEventListeners() {
      var _this2 = this;

      if (this._config.keyboard) {
        $__default["default"](this._element).on(EVENT_KEYDOWN, function (event) {
          return _this2._keydown(event);
        });
      }

      if (this._config.pause === 'hover') {
        $__default["default"](this._element).on(EVENT_MOUSEENTER, function (event) {
          return _this2.pause(event);
        }).on(EVENT_MOUSELEAVE, function (event) {
          return _this2.cycle(event);
        });
      }

      if (this._config.touch) {
        this._addTouchEventListeners();
      }
    };

    _proto._addTouchEventListeners = function _addTouchEventListeners() {
      var _this3 = this;

      if (!this._touchSupported) {
        return;
      }

      var start = function start(event) {
        if (_this3._pointerEvent && PointerType[event.originalEvent.pointerType.toUpperCase()]) {
          _this3.touchStartX = event.originalEvent.clientX;
        } else if (!_this3._pointerEvent) {
          _this3.touchStartX = event.originalEvent.touches[0].clientX;
        }
      };

      var move = function move(event) {
        // ensure swiping with one touch and not pinching
        _this3.touchDeltaX = event.originalEvent.touches && event.originalEvent.touches.length > 1 ? 0 : event.originalEvent.touches[0].clientX - _this3.touchStartX;
      };

      var end = function end(event) {
        if (_this3._pointerEvent && PointerType[event.originalEvent.pointerType.toUpperCase()]) {
          _this3.touchDeltaX = event.originalEvent.clientX - _this3.touchStartX;
        }

        _this3._handleSwipe();

        if (_this3._config.pause === 'hover') {
          // If it's a touch-enabled device, mouseenter/leave are fired as
          // part of the mouse compatibility events on first tap - the carousel
          // would stop cycling until user tapped out of it;
          // here, we listen for touchend, explicitly pause the carousel
          // (as if it's the second time we tap on it, mouseenter compat event
          // is NOT fired) and after a timeout (to allow for mouse compatibility
          // events to fire) we explicitly restart cycling
          _this3.pause();

          if (_this3.touchTimeout) {
            clearTimeout(_this3.touchTimeout);
          }

          _this3.touchTimeout = setTimeout(function (event) {
            return _this3.cycle(event);
          }, TOUCHEVENT_COMPAT_WAIT + _this3._config.interval);
        }
      };

      $__default["default"](this._element.querySelectorAll(SELECTOR_ITEM_IMG)).on(EVENT_DRAG_START, function (e) {
        return e.preventDefault();
      });

      if (this._pointerEvent) {
        $__default["default"](this._element).on(EVENT_POINTERDOWN, function (event) {
          return start(event);
        });
        $__default["default"](this._element).on(EVENT_POINTERUP, function (event) {
          return end(event);
        });

        this._element.classList.add(CLASS_NAME_POINTER_EVENT);
      } else {
        $__default["default"](this._element).on(EVENT_TOUCHSTART, function (event) {
          return start(event);
        });
        $__default["default"](this._element).on(EVENT_TOUCHMOVE, function (event) {
          return move(event);
        });
        $__default["default"](this._element).on(EVENT_TOUCHEND, function (event) {
          return end(event);
        });
      }
    };

    _proto._keydown = function _keydown(event) {
      if (/input|textarea/i.test(event.target.tagName)) {
        return;
      }

      switch (event.which) {
        case ARROW_LEFT_KEYCODE:
          event.preventDefault();
          this.prev();
          break;

        case ARROW_RIGHT_KEYCODE:
          event.preventDefault();
          this.next();
          break;
      }
    };

    _proto._getItemIndex = function _getItemIndex(element) {
      this._items = element && element.parentNode ? [].slice.call(element.parentNode.querySelectorAll(SELECTOR_ITEM)) : [];
      return this._items.indexOf(element);
    };

    _proto._getItemByDirection = function _getItemByDirection(direction, activeElement) {
      var isNextDirection = direction === DIRECTION_NEXT;
      var isPrevDirection = direction === DIRECTION_PREV;

      var activeIndex = this._getItemIndex(activeElement);

      var lastItemIndex = this._items.length - 1;
      var isGoingToWrap = isPrevDirection && activeIndex === 0 || isNextDirection && activeIndex === lastItemIndex;

      if (isGoingToWrap && !this._config.wrap) {
        return activeElement;
      }

      var delta = direction === DIRECTION_PREV ? -1 : 1;
      var itemIndex = (activeIndex + delta) % this._items.length;
      return itemIndex === -1 ? this._items[this._items.length - 1] : this._items[itemIndex];
    };

    _proto._triggerSlideEvent = function _triggerSlideEvent(relatedTarget, eventDirectionName) {
      var targetIndex = this._getItemIndex(relatedTarget);

      var fromIndex = this._getItemIndex(this._element.querySelector(SELECTOR_ACTIVE_ITEM));

      var slideEvent = $__default["default"].Event(EVENT_SLIDE, {
        relatedTarget: relatedTarget,
        direction: eventDirectionName,
        from: fromIndex,
        to: targetIndex
      });
      $__default["default"](this._element).trigger(slideEvent);
      return slideEvent;
    };

    _proto._setActiveIndicatorElement = function _setActiveIndicatorElement(element) {
      if (this._indicatorsElement) {
        var indicators = [].slice.call(this._indicatorsElement.querySelectorAll(SELECTOR_ACTIVE$1));
        $__default["default"](indicators).removeClass(CLASS_NAME_ACTIVE$2);

        var nextIndicator = this._indicatorsElement.children[this._getItemIndex(element)];

        if (nextIndicator) {
          $__default["default"](nextIndicator).addClass(CLASS_NAME_ACTIVE$2);
        }
      }
    };

    _proto._updateInterval = function _updateInterval() {
      var element = this._activeElement || this._element.querySelector(SELECTOR_ACTIVE_ITEM);

      if (!element) {
        return;
      }

      var elementInterval = parseInt(element.getAttribute('data-interval'), 10);

      if (elementInterval) {
        this._config.defaultInterval = this._config.defaultInterval || this._config.interval;
        this._config.interval = elementInterval;
      } else {
        this._config.interval = this._config.defaultInterval || this._config.interval;
      }
    };

    _proto._slide = function _slide(direction, element) {
      var _this4 = this;

      var activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM);

      var activeElementIndex = this._getItemIndex(activeElement);

      var nextElement = element || activeElement && this._getItemByDirection(direction, activeElement);

      var nextElementIndex = this._getItemIndex(nextElement);

      var isCycling = Boolean(this._interval);
      var directionalClassName;
      var orderClassName;
      var eventDirectionName;

      if (direction === DIRECTION_NEXT) {
        directionalClassName = CLASS_NAME_LEFT;
        orderClassName = CLASS_NAME_NEXT;
        eventDirectionName = DIRECTION_LEFT;
      } else {
        directionalClassName = CLASS_NAME_RIGHT;
        orderClassName = CLASS_NAME_PREV;
        eventDirectionName = DIRECTION_RIGHT;
      }

      if (nextElement && $__default["default"](nextElement).hasClass(CLASS_NAME_ACTIVE$2)) {
        this._isSliding = false;
        return;
      }

      var slideEvent = this._triggerSlideEvent(nextElement, eventDirectionName);

      if (slideEvent.isDefaultPrevented()) {
        return;
      }

      if (!activeElement || !nextElement) {
        // Some weirdness is happening, so we bail
        return;
      }

      this._isSliding = true;

      if (isCycling) {
        this.pause();
      }

      this._setActiveIndicatorElement(nextElement);

      this._activeElement = nextElement;
      var slidEvent = $__default["default"].Event(EVENT_SLID, {
        relatedTarget: nextElement,
        direction: eventDirectionName,
        from: activeElementIndex,
        to: nextElementIndex
      });

      if ($__default["default"](this._element).hasClass(CLASS_NAME_SLIDE)) {
        $__default["default"](nextElement).addClass(orderClassName);
        Util.reflow(nextElement);
        $__default["default"](activeElement).addClass(directionalClassName);
        $__default["default"](nextElement).addClass(directionalClassName);
        var transitionDuration = Util.getTransitionDurationFromElement(activeElement);
        $__default["default"](activeElement).one(Util.TRANSITION_END, function () {
          $__default["default"](nextElement).removeClass(directionalClassName + " " + orderClassName).addClass(CLASS_NAME_ACTIVE$2);
          $__default["default"](activeElement).removeClass(CLASS_NAME_ACTIVE$2 + " " + orderClassName + " " + directionalClassName);
          _this4._isSliding = false;
          setTimeout(function () {
            return $__default["default"](_this4._element).trigger(slidEvent);
          }, 0);
        }).emulateTransitionEnd(transitionDuration);
      } else {
        $__default["default"](activeElement).removeClass(CLASS_NAME_ACTIVE$2);
        $__default["default"](nextElement).addClass(CLASS_NAME_ACTIVE$2);
        this._isSliding = false;
        $__default["default"](this._element).trigger(slidEvent);
      }

      if (isCycling) {
        this.cycle();
      }
    } // Static
    ;

    Carousel._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default["default"](this).data(DATA_KEY$8);

        var _config = _extends({}, Default$7, $__default["default"](this).data());

        if (typeof config === 'object') {
          _config = _extends({}, _config, config);
        }

        var action = typeof config === 'string' ? config : _config.slide;

        if (!data) {
          data = new Carousel(this, _config);
          $__default["default"](this).data(DATA_KEY$8, data);
        }

        if (typeof config === 'number') {
          data.to(config);
        } else if (typeof action === 'string') {
          if (typeof data[action] === 'undefined') {
            throw new TypeError("No method named \"" + action + "\"");
          }

          data[action]();
        } else if (_config.interval && _config.ride) {
          data.pause();
          data.cycle();
        }
      });
    };

    Carousel._dataApiClickHandler = function _dataApiClickHandler(event) {
      var selector = Util.getSelectorFromElement(this);

      if (!selector) {
        return;
      }

      var target = $__default["default"](selector)[0];

      if (!target || !$__default["default"](target).hasClass(CLASS_NAME_CAROUSEL)) {
        return;
      }

      var config = _extends({}, $__default["default"](target).data(), $__default["default"](this).data());

      var slideIndex = this.getAttribute('data-slide-to');

      if (slideIndex) {
        config.interval = false;
      }

      Carousel._jQueryInterface.call($__default["default"](target), config);

      if (slideIndex) {
        $__default["default"](target).data(DATA_KEY$8).to(slideIndex);
      }

      event.preventDefault();
    };

    _createClass(Carousel, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$8;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$7;
      }
    }]);

    return Carousel;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API$4, SELECTOR_DATA_SLIDE, Carousel._dataApiClickHandler);
  $__default["default"](window).on(EVENT_LOAD_DATA_API$1, function () {
    var carousels = [].slice.call(document.querySelectorAll(SELECTOR_DATA_RIDE));

    for (var i = 0, len = carousels.length; i < len; i++) {
      var $carousel = $__default["default"](carousels[i]);

      Carousel._jQueryInterface.call($carousel, $carousel.data());
    }
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$8] = Carousel._jQueryInterface;
  $__default["default"].fn[NAME$8].Constructor = Carousel;

  $__default["default"].fn[NAME$8].noConflict = function () {
    $__default["default"].fn[NAME$8] = JQUERY_NO_CONFLICT$8;
    return Carousel._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$7 = 'collapse';
  var VERSION$7 = '4.6.2';
  var DATA_KEY$7 = 'bs.collapse';
  var EVENT_KEY$7 = "." + DATA_KEY$7;
  var DATA_API_KEY$4 = '.data-api';
  var JQUERY_NO_CONFLICT$7 = $__default["default"].fn[NAME$7];
  var CLASS_NAME_SHOW$6 = 'show';
  var CLASS_NAME_COLLAPSE = 'collapse';
  var CLASS_NAME_COLLAPSING = 'collapsing';
  var CLASS_NAME_COLLAPSED = 'collapsed';
  var DIMENSION_WIDTH = 'width';
  var DIMENSION_HEIGHT = 'height';
  var EVENT_SHOW$4 = "show" + EVENT_KEY$7;
  var EVENT_SHOWN$4 = "shown" + EVENT_KEY$7;
  var EVENT_HIDE$4 = "hide" + EVENT_KEY$7;
  var EVENT_HIDDEN$4 = "hidden" + EVENT_KEY$7;
  var EVENT_CLICK_DATA_API$3 = "click" + EVENT_KEY$7 + DATA_API_KEY$4;
  var SELECTOR_ACTIVES = '.show, .collapsing';
  var SELECTOR_DATA_TOGGLE$3 = '[data-toggle="collapse"]';
  var Default$6 = {
    toggle: true,
    parent: ''
  };
  var DefaultType$6 = {
    toggle: 'boolean',
    parent: '(string|element)'
  };
  /**
   * Class definition
   */

  var Collapse = /*#__PURE__*/function () {
    function Collapse(element, config) {
      this._isTransitioning = false;
      this._element = element;
      this._config = this._getConfig(config);
      this._triggerArray = [].slice.call(document.querySelectorAll("[data-toggle=\"collapse\"][href=\"#" + element.id + "\"]," + ("[data-toggle=\"collapse\"][data-target=\"#" + element.id + "\"]")));
      var toggleList = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$3));

      for (var i = 0, len = toggleList.length; i < len; i++) {
        var elem = toggleList[i];
        var selector = Util.getSelectorFromElement(elem);
        var filterElement = [].slice.call(document.querySelectorAll(selector)).filter(function (foundElem) {
          return foundElem === element;
        });

        if (selector !== null && filterElement.length > 0) {
          this._selector = selector;

          this._triggerArray.push(elem);
        }
      }

      this._parent = this._config.parent ? this._getParent() : null;

      if (!this._config.parent) {
        this._addAriaAndCollapsedClass(this._element, this._triggerArray);
      }

      if (this._config.toggle) {
        this.toggle();
      }
    } // Getters


    var _proto = Collapse.prototype;

    // Public
    _proto.toggle = function toggle() {
      if ($__default["default"](this._element).hasClass(CLASS_NAME_SHOW$6)) {
        this.hide();
      } else {
        this.show();
      }
    };

    _proto.show = function show() {
      var _this = this;

      if (this._isTransitioning || $__default["default"](this._element).hasClass(CLASS_NAME_SHOW$6)) {
        return;
      }

      var actives;
      var activesData;

      if (this._parent) {
        actives = [].slice.call(this._parent.querySelectorAll(SELECTOR_ACTIVES)).filter(function (elem) {
          if (typeof _this._config.parent === 'string') {
            return elem.getAttribute('data-parent') === _this._config.parent;
          }

          return elem.classList.contains(CLASS_NAME_COLLAPSE);
        });

        if (actives.length === 0) {
          actives = null;
        }
      }

      if (actives) {
        activesData = $__default["default"](actives).not(this._selector).data(DATA_KEY$7);

        if (activesData && activesData._isTransitioning) {
          return;
        }
      }

      var startEvent = $__default["default"].Event(EVENT_SHOW$4);
      $__default["default"](this._element).trigger(startEvent);

      if (startEvent.isDefaultPrevented()) {
        return;
      }

      if (actives) {
        Collapse._jQueryInterface.call($__default["default"](actives).not(this._selector), 'hide');

        if (!activesData) {
          $__default["default"](actives).data(DATA_KEY$7, null);
        }
      }

      var dimension = this._getDimension();

      $__default["default"](this._element).removeClass(CLASS_NAME_COLLAPSE).addClass(CLASS_NAME_COLLAPSING);
      this._element.style[dimension] = 0;

      if (this._triggerArray.length) {
        $__default["default"](this._triggerArray).removeClass(CLASS_NAME_COLLAPSED).attr('aria-expanded', true);
      }

      this.setTransitioning(true);

      var complete = function complete() {
        $__default["default"](_this._element).removeClass(CLASS_NAME_COLLAPSING).addClass(CLASS_NAME_COLLAPSE + " " + CLASS_NAME_SHOW$6);
        _this._element.style[dimension] = '';

        _this.setTransitioning(false);

        $__default["default"](_this._element).trigger(EVENT_SHOWN$4);
      };

      var capitalizedDimension = dimension[0].toUpperCase() + dimension.slice(1);
      var scrollSize = "scroll" + capitalizedDimension;
      var transitionDuration = Util.getTransitionDurationFromElement(this._element);
      $__default["default"](this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      this._element.style[dimension] = this._element[scrollSize] + "px";
    };

    _proto.hide = function hide() {
      var _this2 = this;

      if (this._isTransitioning || !$__default["default"](this._element).hasClass(CLASS_NAME_SHOW$6)) {
        return;
      }

      var startEvent = $__default["default"].Event(EVENT_HIDE$4);
      $__default["default"](this._element).trigger(startEvent);

      if (startEvent.isDefaultPrevented()) {
        return;
      }

      var dimension = this._getDimension();

      this._element.style[dimension] = this._element.getBoundingClientRect()[dimension] + "px";
      Util.reflow(this._element);
      $__default["default"](this._element).addClass(CLASS_NAME_COLLAPSING).removeClass(CLASS_NAME_COLLAPSE + " " + CLASS_NAME_SHOW$6);
      var triggerArrayLength = this._triggerArray.length;

      if (triggerArrayLength > 0) {
        for (var i = 0; i < triggerArrayLength; i++) {
          var trigger = this._triggerArray[i];
          var selector = Util.getSelectorFromElement(trigger);

          if (selector !== null) {
            var $elem = $__default["default"]([].slice.call(document.querySelectorAll(selector)));

            if (!$elem.hasClass(CLASS_NAME_SHOW$6)) {
              $__default["default"](trigger).addClass(CLASS_NAME_COLLAPSED).attr('aria-expanded', false);
            }
          }
        }
      }

      this.setTransitioning(true);

      var complete = function complete() {
        _this2.setTransitioning(false);

        $__default["default"](_this2._element).removeClass(CLASS_NAME_COLLAPSING).addClass(CLASS_NAME_COLLAPSE).trigger(EVENT_HIDDEN$4);
      };

      this._element.style[dimension] = '';
      var transitionDuration = Util.getTransitionDurationFromElement(this._element);
      $__default["default"](this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
    };

    _proto.setTransitioning = function setTransitioning(isTransitioning) {
      this._isTransitioning = isTransitioning;
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$7);
      this._config = null;
      this._parent = null;
      this._element = null;
      this._triggerArray = null;
      this._isTransitioning = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default$6, config);
      config.toggle = Boolean(config.toggle); // Coerce string values

      Util.typeCheckConfig(NAME$7, config, DefaultType$6);
      return config;
    };

    _proto._getDimension = function _getDimension() {
      var hasWidth = $__default["default"](this._element).hasClass(DIMENSION_WIDTH);
      return hasWidth ? DIMENSION_WIDTH : DIMENSION_HEIGHT;
    };

    _proto._getParent = function _getParent() {
      var _this3 = this;

      var parent;

      if (Util.isElement(this._config.parent)) {
        parent = this._config.parent; // It's a jQuery object

        if (typeof this._config.parent.jquery !== 'undefined') {
          parent = this._config.parent[0];
        }
      } else {
        parent = document.querySelector(this._config.parent);
      }

      var selector = "[data-toggle=\"collapse\"][data-parent=\"" + this._config.parent + "\"]";
      var children = [].slice.call(parent.querySelectorAll(selector));
      $__default["default"](children).each(function (i, element) {
        _this3._addAriaAndCollapsedClass(Collapse._getTargetFromElement(element), [element]);
      });
      return parent;
    };

    _proto._addAriaAndCollapsedClass = function _addAriaAndCollapsedClass(element, triggerArray) {
      var isOpen = $__default["default"](element).hasClass(CLASS_NAME_SHOW$6);

      if (triggerArray.length) {
        $__default["default"](triggerArray).toggleClass(CLASS_NAME_COLLAPSED, !isOpen).attr('aria-expanded', isOpen);
      }
    } // Static
    ;

    Collapse._getTargetFromElement = function _getTargetFromElement(element) {
      var selector = Util.getSelectorFromElement(element);
      return selector ? document.querySelector(selector) : null;
    };

    Collapse._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $element = $__default["default"](this);
        var data = $element.data(DATA_KEY$7);

        var _config = _extends({}, Default$6, $element.data(), typeof config === 'object' && config ? config : {});

        if (!data && _config.toggle && typeof config === 'string' && /show|hide/.test(config)) {
          _config.toggle = false;
        }

        if (!data) {
          data = new Collapse(this, _config);
          $element.data(DATA_KEY$7, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(Collapse, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$7;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$6;
      }
    }]);

    return Collapse;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API$3, SELECTOR_DATA_TOGGLE$3, function (event) {
    // preventDefault only for <a> elements (which change the URL) not inside the collapsible element
    if (event.currentTarget.tagName === 'A') {
      event.preventDefault();
    }

    var $trigger = $__default["default"](this);
    var selector = Util.getSelectorFromElement(this);
    var selectors = [].slice.call(document.querySelectorAll(selector));
    $__default["default"](selectors).each(function () {
      var $target = $__default["default"](this);
      var data = $target.data(DATA_KEY$7);
      var config = data ? 'toggle' : $trigger.data();

      Collapse._jQueryInterface.call($target, config);
    });
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$7] = Collapse._jQueryInterface;
  $__default["default"].fn[NAME$7].Constructor = Collapse;

  $__default["default"].fn[NAME$7].noConflict = function () {
    $__default["default"].fn[NAME$7] = JQUERY_NO_CONFLICT$7;
    return Collapse._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$6 = 'dropdown';
  var VERSION$6 = '4.6.2';
  var DATA_KEY$6 = 'bs.dropdown';
  var EVENT_KEY$6 = "." + DATA_KEY$6;
  var DATA_API_KEY$3 = '.data-api';
  var JQUERY_NO_CONFLICT$6 = $__default["default"].fn[NAME$6];
  var ESCAPE_KEYCODE$1 = 27; // KeyboardEvent.which value for Escape (Esc) key

  var SPACE_KEYCODE = 32; // KeyboardEvent.which value for space key

  var TAB_KEYCODE = 9; // KeyboardEvent.which value for tab key

  var ARROW_UP_KEYCODE = 38; // KeyboardEvent.which value for up arrow key

  var ARROW_DOWN_KEYCODE = 40; // KeyboardEvent.which value for down arrow key

  var RIGHT_MOUSE_BUTTON_WHICH = 3; // MouseEvent.which value for the right button (assuming a right-handed mouse)

  var REGEXP_KEYDOWN = new RegExp(ARROW_UP_KEYCODE + "|" + ARROW_DOWN_KEYCODE + "|" + ESCAPE_KEYCODE$1);
  var CLASS_NAME_DISABLED$1 = 'disabled';
  var CLASS_NAME_SHOW$5 = 'show';
  var CLASS_NAME_DROPUP = 'dropup';
  var CLASS_NAME_DROPRIGHT = 'dropright';
  var CLASS_NAME_DROPLEFT = 'dropleft';
  var CLASS_NAME_MENURIGHT = 'dropdown-menu-right';
  var CLASS_NAME_POSITION_STATIC = 'position-static';
  var EVENT_HIDE$3 = "hide" + EVENT_KEY$6;
  var EVENT_HIDDEN$3 = "hidden" + EVENT_KEY$6;
  var EVENT_SHOW$3 = "show" + EVENT_KEY$6;
  var EVENT_SHOWN$3 = "shown" + EVENT_KEY$6;
  var EVENT_CLICK = "click" + EVENT_KEY$6;
  var EVENT_CLICK_DATA_API$2 = "click" + EVENT_KEY$6 + DATA_API_KEY$3;
  var EVENT_KEYDOWN_DATA_API = "keydown" + EVENT_KEY$6 + DATA_API_KEY$3;
  var EVENT_KEYUP_DATA_API = "keyup" + EVENT_KEY$6 + DATA_API_KEY$3;
  var SELECTOR_DATA_TOGGLE$2 = '[data-toggle="dropdown"]';
  var SELECTOR_FORM_CHILD = '.dropdown form';
  var SELECTOR_MENU = '.dropdown-menu';
  var SELECTOR_NAVBAR_NAV = '.navbar-nav';
  var SELECTOR_VISIBLE_ITEMS = '.dropdown-menu .dropdown-item:not(.disabled):not(:disabled)';
  var PLACEMENT_TOP = 'top-start';
  var PLACEMENT_TOPEND = 'top-end';
  var PLACEMENT_BOTTOM = 'bottom-start';
  var PLACEMENT_BOTTOMEND = 'bottom-end';
  var PLACEMENT_RIGHT = 'right-start';
  var PLACEMENT_LEFT = 'left-start';
  var Default$5 = {
    offset: 0,
    flip: true,
    boundary: 'scrollParent',
    reference: 'toggle',
    display: 'dynamic',
    popperConfig: null
  };
  var DefaultType$5 = {
    offset: '(number|string|function)',
    flip: 'boolean',
    boundary: '(string|element)',
    reference: '(string|element)',
    display: 'string',
    popperConfig: '(null|object)'
  };
  /**
   * Class definition
   */

  var Dropdown = /*#__PURE__*/function () {
    function Dropdown(element, config) {
      this._element = element;
      this._popper = null;
      this._config = this._getConfig(config);
      this._menu = this._getMenuElement();
      this._inNavbar = this._detectNavbar();

      this._addEventListeners();
    } // Getters


    var _proto = Dropdown.prototype;

    // Public
    _proto.toggle = function toggle() {
      if (this._element.disabled || $__default["default"](this._element).hasClass(CLASS_NAME_DISABLED$1)) {
        return;
      }

      var isActive = $__default["default"](this._menu).hasClass(CLASS_NAME_SHOW$5);

      Dropdown._clearMenus();

      if (isActive) {
        return;
      }

      this.show(true);
    };

    _proto.show = function show(usePopper) {
      if (usePopper === void 0) {
        usePopper = false;
      }

      if (this._element.disabled || $__default["default"](this._element).hasClass(CLASS_NAME_DISABLED$1) || $__default["default"](this._menu).hasClass(CLASS_NAME_SHOW$5)) {
        return;
      }

      var relatedTarget = {
        relatedTarget: this._element
      };
      var showEvent = $__default["default"].Event(EVENT_SHOW$3, relatedTarget);

      var parent = Dropdown._getParentFromElement(this._element);

      $__default["default"](parent).trigger(showEvent);

      if (showEvent.isDefaultPrevented()) {
        return;
      } // Totally disable Popper for Dropdowns in Navbar


      if (!this._inNavbar && usePopper) {
        // Check for Popper dependency
        if (typeof Popper__default["default"] === 'undefined') {
          throw new TypeError('Bootstrap\'s dropdowns require Popper (https://popper.js.org)');
        }

        var referenceElement = this._element;

        if (this._config.reference === 'parent') {
          referenceElement = parent;
        } else if (Util.isElement(this._config.reference)) {
          referenceElement = this._config.reference; // Check if it's jQuery element

          if (typeof this._config.reference.jquery !== 'undefined') {
            referenceElement = this._config.reference[0];
          }
        } // If boundary is not `scrollParent`, then set position to `static`
        // to allow the menu to "escape" the scroll parent's boundaries
        // https://github.com/twbs/bootstrap/issues/24251


        if (this._config.boundary !== 'scrollParent') {
          $__default["default"](parent).addClass(CLASS_NAME_POSITION_STATIC);
        }

        this._popper = new Popper__default["default"](referenceElement, this._menu, this._getPopperConfig());
      } // If this is a touch-enabled device we add extra
      // empty mouseover listeners to the body's immediate children;
      // only needed because of broken event delegation on iOS
      // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html


      if ('ontouchstart' in document.documentElement && $__default["default"](parent).closest(SELECTOR_NAVBAR_NAV).length === 0) {
        $__default["default"](document.body).children().on('mouseover', null, $__default["default"].noop);
      }

      this._element.focus();

      this._element.setAttribute('aria-expanded', true);

      $__default["default"](this._menu).toggleClass(CLASS_NAME_SHOW$5);
      $__default["default"](parent).toggleClass(CLASS_NAME_SHOW$5).trigger($__default["default"].Event(EVENT_SHOWN$3, relatedTarget));
    };

    _proto.hide = function hide() {
      if (this._element.disabled || $__default["default"](this._element).hasClass(CLASS_NAME_DISABLED$1) || !$__default["default"](this._menu).hasClass(CLASS_NAME_SHOW$5)) {
        return;
      }

      var relatedTarget = {
        relatedTarget: this._element
      };
      var hideEvent = $__default["default"].Event(EVENT_HIDE$3, relatedTarget);

      var parent = Dropdown._getParentFromElement(this._element);

      $__default["default"](parent).trigger(hideEvent);

      if (hideEvent.isDefaultPrevented()) {
        return;
      }

      if (this._popper) {
        this._popper.destroy();
      }

      $__default["default"](this._menu).toggleClass(CLASS_NAME_SHOW$5);
      $__default["default"](parent).toggleClass(CLASS_NAME_SHOW$5).trigger($__default["default"].Event(EVENT_HIDDEN$3, relatedTarget));
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$6);
      $__default["default"](this._element).off(EVENT_KEY$6);
      this._element = null;
      this._menu = null;

      if (this._popper !== null) {
        this._popper.destroy();

        this._popper = null;
      }
    };

    _proto.update = function update() {
      this._inNavbar = this._detectNavbar();

      if (this._popper !== null) {
        this._popper.scheduleUpdate();
      }
    } // Private
    ;

    _proto._addEventListeners = function _addEventListeners() {
      var _this = this;

      $__default["default"](this._element).on(EVENT_CLICK, function (event) {
        event.preventDefault();
        event.stopPropagation();

        _this.toggle();
      });
    };

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, this.constructor.Default, $__default["default"](this._element).data(), config);
      Util.typeCheckConfig(NAME$6, config, this.constructor.DefaultType);
      return config;
    };

    _proto._getMenuElement = function _getMenuElement() {
      if (!this._menu) {
        var parent = Dropdown._getParentFromElement(this._element);

        if (parent) {
          this._menu = parent.querySelector(SELECTOR_MENU);
        }
      }

      return this._menu;
    };

    _proto._getPlacement = function _getPlacement() {
      var $parentDropdown = $__default["default"](this._element.parentNode);
      var placement = PLACEMENT_BOTTOM; // Handle dropup

      if ($parentDropdown.hasClass(CLASS_NAME_DROPUP)) {
        placement = $__default["default"](this._menu).hasClass(CLASS_NAME_MENURIGHT) ? PLACEMENT_TOPEND : PLACEMENT_TOP;
      } else if ($parentDropdown.hasClass(CLASS_NAME_DROPRIGHT)) {
        placement = PLACEMENT_RIGHT;
      } else if ($parentDropdown.hasClass(CLASS_NAME_DROPLEFT)) {
        placement = PLACEMENT_LEFT;
      } else if ($__default["default"](this._menu).hasClass(CLASS_NAME_MENURIGHT)) {
        placement = PLACEMENT_BOTTOMEND;
      }

      return placement;
    };

    _proto._detectNavbar = function _detectNavbar() {
      return $__default["default"](this._element).closest('.navbar').length > 0;
    };

    _proto._getOffset = function _getOffset() {
      var _this2 = this;

      var offset = {};

      if (typeof this._config.offset === 'function') {
        offset.fn = function (data) {
          data.offsets = _extends({}, data.offsets, _this2._config.offset(data.offsets, _this2._element));
          return data;
        };
      } else {
        offset.offset = this._config.offset;
      }

      return offset;
    };

    _proto._getPopperConfig = function _getPopperConfig() {
      var popperConfig = {
        placement: this._getPlacement(),
        modifiers: {
          offset: this._getOffset(),
          flip: {
            enabled: this._config.flip
          },
          preventOverflow: {
            boundariesElement: this._config.boundary
          }
        }
      }; // Disable Popper if we have a static display

      if (this._config.display === 'static') {
        popperConfig.modifiers.applyStyle = {
          enabled: false
        };
      }

      return _extends({}, popperConfig, this._config.popperConfig);
    } // Static
    ;

    Dropdown._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default["default"](this).data(DATA_KEY$6);

        var _config = typeof config === 'object' ? config : null;

        if (!data) {
          data = new Dropdown(this, _config);
          $__default["default"](this).data(DATA_KEY$6, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    Dropdown._clearMenus = function _clearMenus(event) {
      if (event && (event.which === RIGHT_MOUSE_BUTTON_WHICH || event.type === 'keyup' && event.which !== TAB_KEYCODE)) {
        return;
      }

      var toggles = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$2));

      for (var i = 0, len = toggles.length; i < len; i++) {
        var parent = Dropdown._getParentFromElement(toggles[i]);

        var context = $__default["default"](toggles[i]).data(DATA_KEY$6);
        var relatedTarget = {
          relatedTarget: toggles[i]
        };

        if (event && event.type === 'click') {
          relatedTarget.clickEvent = event;
        }

        if (!context) {
          continue;
        }

        var dropdownMenu = context._menu;

        if (!$__default["default"](parent).hasClass(CLASS_NAME_SHOW$5)) {
          continue;
        }

        if (event && (event.type === 'click' && /input|textarea/i.test(event.target.tagName) || event.type === 'keyup' && event.which === TAB_KEYCODE) && $__default["default"].contains(parent, event.target)) {
          continue;
        }

        var hideEvent = $__default["default"].Event(EVENT_HIDE$3, relatedTarget);
        $__default["default"](parent).trigger(hideEvent);

        if (hideEvent.isDefaultPrevented()) {
          continue;
        } // If this is a touch-enabled device we remove the extra
        // empty mouseover listeners we added for iOS support


        if ('ontouchstart' in document.documentElement) {
          $__default["default"](document.body).children().off('mouseover', null, $__default["default"].noop);
        }

        toggles[i].setAttribute('aria-expanded', 'false');

        if (context._popper) {
          context._popper.destroy();
        }

        $__default["default"](dropdownMenu).removeClass(CLASS_NAME_SHOW$5);
        $__default["default"](parent).removeClass(CLASS_NAME_SHOW$5).trigger($__default["default"].Event(EVENT_HIDDEN$3, relatedTarget));
      }
    };

    Dropdown._getParentFromElement = function _getParentFromElement(element) {
      var parent;
      var selector = Util.getSelectorFromElement(element);

      if (selector) {
        parent = document.querySelector(selector);
      }

      return parent || element.parentNode;
    } // eslint-disable-next-line complexity
    ;

    Dropdown._dataApiKeydownHandler = function _dataApiKeydownHandler(event) {
      // If not input/textarea:
      //  - And not a key in REGEXP_KEYDOWN => not a dropdown command
      // If input/textarea:
      //  - If space key => not a dropdown command
      //  - If key is other than escape
      //    - If key is not up or down => not a dropdown command
      //    - If trigger inside the menu => not a dropdown command
      if (/input|textarea/i.test(event.target.tagName) ? event.which === SPACE_KEYCODE || event.which !== ESCAPE_KEYCODE$1 && (event.which !== ARROW_DOWN_KEYCODE && event.which !== ARROW_UP_KEYCODE || $__default["default"](event.target).closest(SELECTOR_MENU).length) : !REGEXP_KEYDOWN.test(event.which)) {
        return;
      }

      if (this.disabled || $__default["default"](this).hasClass(CLASS_NAME_DISABLED$1)) {
        return;
      }

      var parent = Dropdown._getParentFromElement(this);

      var isActive = $__default["default"](parent).hasClass(CLASS_NAME_SHOW$5);

      if (!isActive && event.which === ESCAPE_KEYCODE$1) {
        return;
      }

      event.preventDefault();
      event.stopPropagation();

      if (!isActive || event.which === ESCAPE_KEYCODE$1 || event.which === SPACE_KEYCODE) {
        if (event.which === ESCAPE_KEYCODE$1) {
          $__default["default"](parent.querySelector(SELECTOR_DATA_TOGGLE$2)).trigger('focus');
        }

        $__default["default"](this).trigger('click');
        return;
      }

      var items = [].slice.call(parent.querySelectorAll(SELECTOR_VISIBLE_ITEMS)).filter(function (item) {
        return $__default["default"](item).is(':visible');
      });

      if (items.length === 0) {
        return;
      }

      var index = items.indexOf(event.target);

      if (event.which === ARROW_UP_KEYCODE && index > 0) {
        // Up
        index--;
      }

      if (event.which === ARROW_DOWN_KEYCODE && index < items.length - 1) {
        // Down
        index++;
      }

      if (index < 0) {
        index = 0;
      }

      items[index].focus();
    };

    _createClass(Dropdown, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$6;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$5;
      }
    }, {
      key: "DefaultType",
      get: function get() {
        return DefaultType$5;
      }
    }]);

    return Dropdown;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_KEYDOWN_DATA_API, SELECTOR_DATA_TOGGLE$2, Dropdown._dataApiKeydownHandler).on(EVENT_KEYDOWN_DATA_API, SELECTOR_MENU, Dropdown._dataApiKeydownHandler).on(EVENT_CLICK_DATA_API$2 + " " + EVENT_KEYUP_DATA_API, Dropdown._clearMenus).on(EVENT_CLICK_DATA_API$2, SELECTOR_DATA_TOGGLE$2, function (event) {
    event.preventDefault();
    event.stopPropagation();

    Dropdown._jQueryInterface.call($__default["default"](this), 'toggle');
  }).on(EVENT_CLICK_DATA_API$2, SELECTOR_FORM_CHILD, function (e) {
    e.stopPropagation();
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$6] = Dropdown._jQueryInterface;
  $__default["default"].fn[NAME$6].Constructor = Dropdown;

  $__default["default"].fn[NAME$6].noConflict = function () {
    $__default["default"].fn[NAME$6] = JQUERY_NO_CONFLICT$6;
    return Dropdown._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$5 = 'modal';
  var VERSION$5 = '4.6.2';
  var DATA_KEY$5 = 'bs.modal';
  var EVENT_KEY$5 = "." + DATA_KEY$5;
  var DATA_API_KEY$2 = '.data-api';
  var JQUERY_NO_CONFLICT$5 = $__default["default"].fn[NAME$5];
  var ESCAPE_KEYCODE = 27; // KeyboardEvent.which value for Escape (Esc) key

  var CLASS_NAME_SCROLLABLE = 'modal-dialog-scrollable';
  var CLASS_NAME_SCROLLBAR_MEASURER = 'modal-scrollbar-measure';
  var CLASS_NAME_BACKDROP = 'modal-backdrop';
  var CLASS_NAME_OPEN = 'modal-open';
  var CLASS_NAME_FADE$4 = 'fade';
  var CLASS_NAME_SHOW$4 = 'show';
  var CLASS_NAME_STATIC = 'modal-static';
  var EVENT_HIDE$2 = "hide" + EVENT_KEY$5;
  var EVENT_HIDE_PREVENTED = "hidePrevented" + EVENT_KEY$5;
  var EVENT_HIDDEN$2 = "hidden" + EVENT_KEY$5;
  var EVENT_SHOW$2 = "show" + EVENT_KEY$5;
  var EVENT_SHOWN$2 = "shown" + EVENT_KEY$5;
  var EVENT_FOCUSIN = "focusin" + EVENT_KEY$5;
  var EVENT_RESIZE = "resize" + EVENT_KEY$5;
  var EVENT_CLICK_DISMISS$1 = "click.dismiss" + EVENT_KEY$5;
  var EVENT_KEYDOWN_DISMISS = "keydown.dismiss" + EVENT_KEY$5;
  var EVENT_MOUSEUP_DISMISS = "mouseup.dismiss" + EVENT_KEY$5;
  var EVENT_MOUSEDOWN_DISMISS = "mousedown.dismiss" + EVENT_KEY$5;
  var EVENT_CLICK_DATA_API$1 = "click" + EVENT_KEY$5 + DATA_API_KEY$2;
  var SELECTOR_DIALOG = '.modal-dialog';
  var SELECTOR_MODAL_BODY = '.modal-body';
  var SELECTOR_DATA_TOGGLE$1 = '[data-toggle="modal"]';
  var SELECTOR_DATA_DISMISS$1 = '[data-dismiss="modal"]';
  var SELECTOR_FIXED_CONTENT = '.fixed-top, .fixed-bottom, .is-fixed, .sticky-top';
  var SELECTOR_STICKY_CONTENT = '.sticky-top';
  var Default$4 = {
    backdrop: true,
    keyboard: true,
    focus: true,
    show: true
  };
  var DefaultType$4 = {
    backdrop: '(boolean|string)',
    keyboard: 'boolean',
    focus: 'boolean',
    show: 'boolean'
  };
  /**
   * Class definition
   */

  var Modal = /*#__PURE__*/function () {
    function Modal(element, config) {
      this._config = this._getConfig(config);
      this._element = element;
      this._dialog = element.querySelector(SELECTOR_DIALOG);
      this._backdrop = null;
      this._isShown = false;
      this._isBodyOverflowing = false;
      this._ignoreBackdropClick = false;
      this._isTransitioning = false;
      this._scrollbarWidth = 0;
    } // Getters


    var _proto = Modal.prototype;

    // Public
    _proto.toggle = function toggle(relatedTarget) {
      return this._isShown ? this.hide() : this.show(relatedTarget);
    };

    _proto.show = function show(relatedTarget) {
      var _this = this;

      if (this._isShown || this._isTransitioning) {
        return;
      }

      var showEvent = $__default["default"].Event(EVENT_SHOW$2, {
        relatedTarget: relatedTarget
      });
      $__default["default"](this._element).trigger(showEvent);

      if (showEvent.isDefaultPrevented()) {
        return;
      }

      this._isShown = true;

      if ($__default["default"](this._element).hasClass(CLASS_NAME_FADE$4)) {
        this._isTransitioning = true;
      }

      this._checkScrollbar();

      this._setScrollbar();

      this._adjustDialog();

      this._setEscapeEvent();

      this._setResizeEvent();

      $__default["default"](this._element).on(EVENT_CLICK_DISMISS$1, SELECTOR_DATA_DISMISS$1, function (event) {
        return _this.hide(event);
      });
      $__default["default"](this._dialog).on(EVENT_MOUSEDOWN_DISMISS, function () {
        $__default["default"](_this._element).one(EVENT_MOUSEUP_DISMISS, function (event) {
          if ($__default["default"](event.target).is(_this._element)) {
            _this._ignoreBackdropClick = true;
          }
        });
      });

      this._showBackdrop(function () {
        return _this._showElement(relatedTarget);
      });
    };

    _proto.hide = function hide(event) {
      var _this2 = this;

      if (event) {
        event.preventDefault();
      }

      if (!this._isShown || this._isTransitioning) {
        return;
      }

      var hideEvent = $__default["default"].Event(EVENT_HIDE$2);
      $__default["default"](this._element).trigger(hideEvent);

      if (!this._isShown || hideEvent.isDefaultPrevented()) {
        return;
      }

      this._isShown = false;
      var transition = $__default["default"](this._element).hasClass(CLASS_NAME_FADE$4);

      if (transition) {
        this._isTransitioning = true;
      }

      this._setEscapeEvent();

      this._setResizeEvent();

      $__default["default"](document).off(EVENT_FOCUSIN);
      $__default["default"](this._element).removeClass(CLASS_NAME_SHOW$4);
      $__default["default"](this._element).off(EVENT_CLICK_DISMISS$1);
      $__default["default"](this._dialog).off(EVENT_MOUSEDOWN_DISMISS);

      if (transition) {
        var transitionDuration = Util.getTransitionDurationFromElement(this._element);
        $__default["default"](this._element).one(Util.TRANSITION_END, function (event) {
          return _this2._hideModal(event);
        }).emulateTransitionEnd(transitionDuration);
      } else {
        this._hideModal();
      }
    };

    _proto.dispose = function dispose() {
      [window, this._element, this._dialog].forEach(function (htmlElement) {
        return $__default["default"](htmlElement).off(EVENT_KEY$5);
      });
      /**
       * `document` has 2 events `EVENT_FOCUSIN` and `EVENT_CLICK_DATA_API`
       * Do not move `document` in `htmlElements` array
       * It will remove `EVENT_CLICK_DATA_API` event that should remain
       */

      $__default["default"](document).off(EVENT_FOCUSIN);
      $__default["default"].removeData(this._element, DATA_KEY$5);
      this._config = null;
      this._element = null;
      this._dialog = null;
      this._backdrop = null;
      this._isShown = null;
      this._isBodyOverflowing = null;
      this._ignoreBackdropClick = null;
      this._isTransitioning = null;
      this._scrollbarWidth = null;
    };

    _proto.handleUpdate = function handleUpdate() {
      this._adjustDialog();
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default$4, config);
      Util.typeCheckConfig(NAME$5, config, DefaultType$4);
      return config;
    };

    _proto._triggerBackdropTransition = function _triggerBackdropTransition() {
      var _this3 = this;

      var hideEventPrevented = $__default["default"].Event(EVENT_HIDE_PREVENTED);
      $__default["default"](this._element).trigger(hideEventPrevented);

      if (hideEventPrevented.isDefaultPrevented()) {
        return;
      }

      var isModalOverflowing = this._element.scrollHeight > document.documentElement.clientHeight;

      if (!isModalOverflowing) {
        this._element.style.overflowY = 'hidden';
      }

      this._element.classList.add(CLASS_NAME_STATIC);

      var modalTransitionDuration = Util.getTransitionDurationFromElement(this._dialog);
      $__default["default"](this._element).off(Util.TRANSITION_END);
      $__default["default"](this._element).one(Util.TRANSITION_END, function () {
        _this3._element.classList.remove(CLASS_NAME_STATIC);

        if (!isModalOverflowing) {
          $__default["default"](_this3._element).one(Util.TRANSITION_END, function () {
            _this3._element.style.overflowY = '';
          }).emulateTransitionEnd(_this3._element, modalTransitionDuration);
        }
      }).emulateTransitionEnd(modalTransitionDuration);

      this._element.focus();
    };

    _proto._showElement = function _showElement(relatedTarget) {
      var _this4 = this;

      var transition = $__default["default"](this._element).hasClass(CLASS_NAME_FADE$4);
      var modalBody = this._dialog ? this._dialog.querySelector(SELECTOR_MODAL_BODY) : null;

      if (!this._element.parentNode || this._element.parentNode.nodeType !== Node.ELEMENT_NODE) {
        // Don't move modal's DOM position
        document.body.appendChild(this._element);
      }

      this._element.style.display = 'block';

      this._element.removeAttribute('aria-hidden');

      this._element.setAttribute('aria-modal', true);

      this._element.setAttribute('role', 'dialog');

      if ($__default["default"](this._dialog).hasClass(CLASS_NAME_SCROLLABLE) && modalBody) {
        modalBody.scrollTop = 0;
      } else {
        this._element.scrollTop = 0;
      }

      if (transition) {
        Util.reflow(this._element);
      }

      $__default["default"](this._element).addClass(CLASS_NAME_SHOW$4);

      if (this._config.focus) {
        this._enforceFocus();
      }

      var shownEvent = $__default["default"].Event(EVENT_SHOWN$2, {
        relatedTarget: relatedTarget
      });

      var transitionComplete = function transitionComplete() {
        if (_this4._config.focus) {
          _this4._element.focus();
        }

        _this4._isTransitioning = false;
        $__default["default"](_this4._element).trigger(shownEvent);
      };

      if (transition) {
        var transitionDuration = Util.getTransitionDurationFromElement(this._dialog);
        $__default["default"](this._dialog).one(Util.TRANSITION_END, transitionComplete).emulateTransitionEnd(transitionDuration);
      } else {
        transitionComplete();
      }
    };

    _proto._enforceFocus = function _enforceFocus() {
      var _this5 = this;

      $__default["default"](document).off(EVENT_FOCUSIN) // Guard against infinite focus loop
      .on(EVENT_FOCUSIN, function (event) {
        if (document !== event.target && _this5._element !== event.target && $__default["default"](_this5._element).has(event.target).length === 0) {
          _this5._element.focus();
        }
      });
    };

    _proto._setEscapeEvent = function _setEscapeEvent() {
      var _this6 = this;

      if (this._isShown) {
        $__default["default"](this._element).on(EVENT_KEYDOWN_DISMISS, function (event) {
          if (_this6._config.keyboard && event.which === ESCAPE_KEYCODE) {
            event.preventDefault();

            _this6.hide();
          } else if (!_this6._config.keyboard && event.which === ESCAPE_KEYCODE) {
            _this6._triggerBackdropTransition();
          }
        });
      } else if (!this._isShown) {
        $__default["default"](this._element).off(EVENT_KEYDOWN_DISMISS);
      }
    };

    _proto._setResizeEvent = function _setResizeEvent() {
      var _this7 = this;

      if (this._isShown) {
        $__default["default"](window).on(EVENT_RESIZE, function (event) {
          return _this7.handleUpdate(event);
        });
      } else {
        $__default["default"](window).off(EVENT_RESIZE);
      }
    };

    _proto._hideModal = function _hideModal() {
      var _this8 = this;

      this._element.style.display = 'none';

      this._element.setAttribute('aria-hidden', true);

      this._element.removeAttribute('aria-modal');

      this._element.removeAttribute('role');

      this._isTransitioning = false;

      this._showBackdrop(function () {
        $__default["default"](document.body).removeClass(CLASS_NAME_OPEN);

        _this8._resetAdjustments();

        _this8._resetScrollbar();

        $__default["default"](_this8._element).trigger(EVENT_HIDDEN$2);
      });
    };

    _proto._removeBackdrop = function _removeBackdrop() {
      if (this._backdrop) {
        $__default["default"](this._backdrop).remove();
        this._backdrop = null;
      }
    };

    _proto._showBackdrop = function _showBackdrop(callback) {
      var _this9 = this;

      var animate = $__default["default"](this._element).hasClass(CLASS_NAME_FADE$4) ? CLASS_NAME_FADE$4 : '';

      if (this._isShown && this._config.backdrop) {
        this._backdrop = document.createElement('div');
        this._backdrop.className = CLASS_NAME_BACKDROP;

        if (animate) {
          this._backdrop.classList.add(animate);
        }

        $__default["default"](this._backdrop).appendTo(document.body);
        $__default["default"](this._element).on(EVENT_CLICK_DISMISS$1, function (event) {
          if (_this9._ignoreBackdropClick) {
            _this9._ignoreBackdropClick = false;
            return;
          }

          if (event.target !== event.currentTarget) {
            return;
          }

          if (_this9._config.backdrop === 'static') {
            _this9._triggerBackdropTransition();
          } else {
            _this9.hide();
          }
        });

        if (animate) {
          Util.reflow(this._backdrop);
        }

        $__default["default"](this._backdrop).addClass(CLASS_NAME_SHOW$4);

        if (!callback) {
          return;
        }

        if (!animate) {
          callback();
          return;
        }

        var backdropTransitionDuration = Util.getTransitionDurationFromElement(this._backdrop);
        $__default["default"](this._backdrop).one(Util.TRANSITION_END, callback).emulateTransitionEnd(backdropTransitionDuration);
      } else if (!this._isShown && this._backdrop) {
        $__default["default"](this._backdrop).removeClass(CLASS_NAME_SHOW$4);

        var callbackRemove = function callbackRemove() {
          _this9._removeBackdrop();

          if (callback) {
            callback();
          }
        };

        if ($__default["default"](this._element).hasClass(CLASS_NAME_FADE$4)) {
          var _backdropTransitionDuration = Util.getTransitionDurationFromElement(this._backdrop);

          $__default["default"](this._backdrop).one(Util.TRANSITION_END, callbackRemove).emulateTransitionEnd(_backdropTransitionDuration);
        } else {
          callbackRemove();
        }
      } else if (callback) {
        callback();
      }
    } // ----------------------------------------------------------------------
    // the following methods are used to handle overflowing modals
    // todo (fat): these should probably be refactored out of modal.js
    // ----------------------------------------------------------------------
    ;

    _proto._adjustDialog = function _adjustDialog() {
      var isModalOverflowing = this._element.scrollHeight > document.documentElement.clientHeight;

      if (!this._isBodyOverflowing && isModalOverflowing) {
        this._element.style.paddingLeft = this._scrollbarWidth + "px";
      }

      if (this._isBodyOverflowing && !isModalOverflowing) {
        this._element.style.paddingRight = this._scrollbarWidth + "px";
      }
    };

    _proto._resetAdjustments = function _resetAdjustments() {
      this._element.style.paddingLeft = '';
      this._element.style.paddingRight = '';
    };

    _proto._checkScrollbar = function _checkScrollbar() {
      var rect = document.body.getBoundingClientRect();
      this._isBodyOverflowing = Math.round(rect.left + rect.right) < window.innerWidth;
      this._scrollbarWidth = this._getScrollbarWidth();
    };

    _proto._setScrollbar = function _setScrollbar() {
      var _this10 = this;

      if (this._isBodyOverflowing) {
        // Note: DOMNode.style.paddingRight returns the actual value or '' if not set
        //   while $(DOMNode).css('padding-right') returns the calculated value or 0 if not set
        var fixedContent = [].slice.call(document.querySelectorAll(SELECTOR_FIXED_CONTENT));
        var stickyContent = [].slice.call(document.querySelectorAll(SELECTOR_STICKY_CONTENT)); // Adjust fixed content padding

        $__default["default"](fixedContent).each(function (index, element) {
          var actualPadding = element.style.paddingRight;
          var calculatedPadding = $__default["default"](element).css('padding-right');
          $__default["default"](element).data('padding-right', actualPadding).css('padding-right', parseFloat(calculatedPadding) + _this10._scrollbarWidth + "px");
        }); // Adjust sticky content margin

        $__default["default"](stickyContent).each(function (index, element) {
          var actualMargin = element.style.marginRight;
          var calculatedMargin = $__default["default"](element).css('margin-right');
          $__default["default"](element).data('margin-right', actualMargin).css('margin-right', parseFloat(calculatedMargin) - _this10._scrollbarWidth + "px");
        }); // Adjust body padding

        var actualPadding = document.body.style.paddingRight;
        var calculatedPadding = $__default["default"](document.body).css('padding-right');
        $__default["default"](document.body).data('padding-right', actualPadding).css('padding-right', parseFloat(calculatedPadding) + this._scrollbarWidth + "px");
      }

      $__default["default"](document.body).addClass(CLASS_NAME_OPEN);
    };

    _proto._resetScrollbar = function _resetScrollbar() {
      // Restore fixed content padding
      var fixedContent = [].slice.call(document.querySelectorAll(SELECTOR_FIXED_CONTENT));
      $__default["default"](fixedContent).each(function (index, element) {
        var padding = $__default["default"](element).data('padding-right');
        $__default["default"](element).removeData('padding-right');
        element.style.paddingRight = padding ? padding : '';
      }); // Restore sticky content

      var elements = [].slice.call(document.querySelectorAll("" + SELECTOR_STICKY_CONTENT));
      $__default["default"](elements).each(function (index, element) {
        var margin = $__default["default"](element).data('margin-right');

        if (typeof margin !== 'undefined') {
          $__default["default"](element).css('margin-right', margin).removeData('margin-right');
        }
      }); // Restore body padding

      var padding = $__default["default"](document.body).data('padding-right');
      $__default["default"](document.body).removeData('padding-right');
      document.body.style.paddingRight = padding ? padding : '';
    };

    _proto._getScrollbarWidth = function _getScrollbarWidth() {
      // thx d.walsh
      var scrollDiv = document.createElement('div');
      scrollDiv.className = CLASS_NAME_SCROLLBAR_MEASURER;
      document.body.appendChild(scrollDiv);
      var scrollbarWidth = scrollDiv.getBoundingClientRect().width - scrollDiv.clientWidth;
      document.body.removeChild(scrollDiv);
      return scrollbarWidth;
    } // Static
    ;

    Modal._jQueryInterface = function _jQueryInterface(config, relatedTarget) {
      return this.each(function () {
        var data = $__default["default"](this).data(DATA_KEY$5);

        var _config = _extends({}, Default$4, $__default["default"](this).data(), typeof config === 'object' && config ? config : {});

        if (!data) {
          data = new Modal(this, _config);
          $__default["default"](this).data(DATA_KEY$5, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config](relatedTarget);
        } else if (_config.show) {
          data.show(relatedTarget);
        }
      });
    };

    _createClass(Modal, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$5;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$4;
      }
    }]);

    return Modal;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API$1, SELECTOR_DATA_TOGGLE$1, function (event) {
    var _this11 = this;

    var target;
    var selector = Util.getSelectorFromElement(this);

    if (selector) {
      target = document.querySelector(selector);
    }

    var config = $__default["default"](target).data(DATA_KEY$5) ? 'toggle' : _extends({}, $__default["default"](target).data(), $__default["default"](this).data());

    if (this.tagName === 'A' || this.tagName === 'AREA') {
      event.preventDefault();
    }

    var $target = $__default["default"](target).one(EVENT_SHOW$2, function (showEvent) {
      if (showEvent.isDefaultPrevented()) {
        // Only register focus restorer if modal will actually get shown
        return;
      }

      $target.one(EVENT_HIDDEN$2, function () {
        if ($__default["default"](_this11).is(':visible')) {
          _this11.focus();
        }
      });
    });

    Modal._jQueryInterface.call($__default["default"](target), config, this);
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$5] = Modal._jQueryInterface;
  $__default["default"].fn[NAME$5].Constructor = Modal;

  $__default["default"].fn[NAME$5].noConflict = function () {
    $__default["default"].fn[NAME$5] = JQUERY_NO_CONFLICT$5;
    return Modal._jQueryInterface;
  };

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v4.6.2): tools/sanitizer.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  var uriAttrs = ['background', 'cite', 'href', 'itemtype', 'longdesc', 'poster', 'src', 'xlink:href'];
  var ARIA_ATTRIBUTE_PATTERN = /^aria-[\w-]*$/i;
  var DefaultWhitelist = {
    // Global attributes allowed on any supplied element below.
    '*': ['class', 'dir', 'id', 'lang', 'role', ARIA_ATTRIBUTE_PATTERN],
    a: ['target', 'href', 'title', 'rel'],
    area: [],
    b: [],
    br: [],
    col: [],
    code: [],
    div: [],
    em: [],
    hr: [],
    h1: [],
    h2: [],
    h3: [],
    h4: [],
    h5: [],
    h6: [],
    i: [],
    img: ['src', 'srcset', 'alt', 'title', 'width', 'height'],
    li: [],
    ol: [],
    p: [],
    pre: [],
    s: [],
    small: [],
    span: [],
    sub: [],
    sup: [],
    strong: [],
    u: [],
    ul: []
  };
  /**
   * A pattern that recognizes a commonly useful subset of URLs that are safe.
   *
   * Shoutout to Angular https://github.com/angular/angular/blob/12.2.x/packages/core/src/sanitization/url_sanitizer.ts
   */

  var SAFE_URL_PATTERN = /^(?:(?:https?|mailto|ftp|tel|file|sms):|[^#&/:?]*(?:[#/?]|$))/i;
  /**
   * A pattern that matches safe data URLs. Only matches image, video and audio types.
   *
   * Shoutout to Angular https://github.com/angular/angular/blob/12.2.x/packages/core/src/sanitization/url_sanitizer.ts
   */

  var DATA_URL_PATTERN = /^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[\d+/a-z]+=*$/i;

  function allowedAttribute(attr, allowedAttributeList) {
    var attrName = attr.nodeName.toLowerCase();

    if (allowedAttributeList.indexOf(attrName) !== -1) {
      if (uriAttrs.indexOf(attrName) !== -1) {
        return Boolean(SAFE_URL_PATTERN.test(attr.nodeValue) || DATA_URL_PATTERN.test(attr.nodeValue));
      }

      return true;
    }

    var regExp = allowedAttributeList.filter(function (attrRegex) {
      return attrRegex instanceof RegExp;
    }); // Check if a regular expression validates the attribute.

    for (var i = 0, len = regExp.length; i < len; i++) {
      if (regExp[i].test(attrName)) {
        return true;
      }
    }

    return false;
  }

  function sanitizeHtml(unsafeHtml, whiteList, sanitizeFn) {
    if (unsafeHtml.length === 0) {
      return unsafeHtml;
    }

    if (sanitizeFn && typeof sanitizeFn === 'function') {
      return sanitizeFn(unsafeHtml);
    }

    var domParser = new window.DOMParser();
    var createdDocument = domParser.parseFromString(unsafeHtml, 'text/html');
    var whitelistKeys = Object.keys(whiteList);
    var elements = [].slice.call(createdDocument.body.querySelectorAll('*'));

    var _loop = function _loop(i, len) {
      var el = elements[i];
      var elName = el.nodeName.toLowerCase();

      if (whitelistKeys.indexOf(el.nodeName.toLowerCase()) === -1) {
        el.parentNode.removeChild(el);
        return "continue";
      }

      var attributeList = [].slice.call(el.attributes); // eslint-disable-next-line unicorn/prefer-spread

      var whitelistedAttributes = [].concat(whiteList['*'] || [], whiteList[elName] || []);
      attributeList.forEach(function (attr) {
        if (!allowedAttribute(attr, whitelistedAttributes)) {
          el.removeAttribute(attr.nodeName);
        }
      });
    };

    for (var i = 0, len = elements.length; i < len; i++) {
      var _ret = _loop(i);

      if (_ret === "continue") continue;
    }

    return createdDocument.body.innerHTML;
  }

  /**
   * Constants
   */

  var NAME$4 = 'tooltip';
  var VERSION$4 = '4.6.2';
  var DATA_KEY$4 = 'bs.tooltip';
  var EVENT_KEY$4 = "." + DATA_KEY$4;
  var JQUERY_NO_CONFLICT$4 = $__default["default"].fn[NAME$4];
  var CLASS_PREFIX$1 = 'bs-tooltip';
  var BSCLS_PREFIX_REGEX$1 = new RegExp("(^|\\s)" + CLASS_PREFIX$1 + "\\S+", 'g');
  var DISALLOWED_ATTRIBUTES = ['sanitize', 'whiteList', 'sanitizeFn'];
  var CLASS_NAME_FADE$3 = 'fade';
  var CLASS_NAME_SHOW$3 = 'show';
  var HOVER_STATE_SHOW = 'show';
  var HOVER_STATE_OUT = 'out';
  var SELECTOR_TOOLTIP_INNER = '.tooltip-inner';
  var SELECTOR_ARROW = '.arrow';
  var TRIGGER_HOVER = 'hover';
  var TRIGGER_FOCUS = 'focus';
  var TRIGGER_CLICK = 'click';
  var TRIGGER_MANUAL = 'manual';
  var AttachmentMap = {
    AUTO: 'auto',
    TOP: 'top',
    RIGHT: 'right',
    BOTTOM: 'bottom',
    LEFT: 'left'
  };
  var Default$3 = {
    animation: true,
    template: '<div class="tooltip" role="tooltip">' + '<div class="arrow"></div>' + '<div class="tooltip-inner"></div></div>',
    trigger: 'hover focus',
    title: '',
    delay: 0,
    html: false,
    selector: false,
    placement: 'top',
    offset: 0,
    container: false,
    fallbackPlacement: 'flip',
    boundary: 'scrollParent',
    customClass: '',
    sanitize: true,
    sanitizeFn: null,
    whiteList: DefaultWhitelist,
    popperConfig: null
  };
  var DefaultType$3 = {
    animation: 'boolean',
    template: 'string',
    title: '(string|element|function)',
    trigger: 'string',
    delay: '(number|object)',
    html: 'boolean',
    selector: '(string|boolean)',
    placement: '(string|function)',
    offset: '(number|string|function)',
    container: '(string|element|boolean)',
    fallbackPlacement: '(string|array)',
    boundary: '(string|element)',
    customClass: '(string|function)',
    sanitize: 'boolean',
    sanitizeFn: '(null|function)',
    whiteList: 'object',
    popperConfig: '(null|object)'
  };
  var Event$1 = {
    HIDE: "hide" + EVENT_KEY$4,
    HIDDEN: "hidden" + EVENT_KEY$4,
    SHOW: "show" + EVENT_KEY$4,
    SHOWN: "shown" + EVENT_KEY$4,
    INSERTED: "inserted" + EVENT_KEY$4,
    CLICK: "click" + EVENT_KEY$4,
    FOCUSIN: "focusin" + EVENT_KEY$4,
    FOCUSOUT: "focusout" + EVENT_KEY$4,
    MOUSEENTER: "mouseenter" + EVENT_KEY$4,
    MOUSELEAVE: "mouseleave" + EVENT_KEY$4
  };
  /**
   * Class definition
   */

  var Tooltip = /*#__PURE__*/function () {
    function Tooltip(element, config) {
      if (typeof Popper__default["default"] === 'undefined') {
        throw new TypeError('Bootstrap\'s tooltips require Popper (https://popper.js.org)');
      } // Private


      this._isEnabled = true;
      this._timeout = 0;
      this._hoverState = '';
      this._activeTrigger = {};
      this._popper = null; // Protected

      this.element = element;
      this.config = this._getConfig(config);
      this.tip = null;

      this._setListeners();
    } // Getters


    var _proto = Tooltip.prototype;

    // Public
    _proto.enable = function enable() {
      this._isEnabled = true;
    };

    _proto.disable = function disable() {
      this._isEnabled = false;
    };

    _proto.toggleEnabled = function toggleEnabled() {
      this._isEnabled = !this._isEnabled;
    };

    _proto.toggle = function toggle(event) {
      if (!this._isEnabled) {
        return;
      }

      if (event) {
        var dataKey = this.constructor.DATA_KEY;
        var context = $__default["default"](event.currentTarget).data(dataKey);

        if (!context) {
          context = new this.constructor(event.currentTarget, this._getDelegateConfig());
          $__default["default"](event.currentTarget).data(dataKey, context);
        }

        context._activeTrigger.click = !context._activeTrigger.click;

        if (context._isWithActiveTrigger()) {
          context._enter(null, context);
        } else {
          context._leave(null, context);
        }
      } else {
        if ($__default["default"](this.getTipElement()).hasClass(CLASS_NAME_SHOW$3)) {
          this._leave(null, this);

          return;
        }

        this._enter(null, this);
      }
    };

    _proto.dispose = function dispose() {
      clearTimeout(this._timeout);
      $__default["default"].removeData(this.element, this.constructor.DATA_KEY);
      $__default["default"](this.element).off(this.constructor.EVENT_KEY);
      $__default["default"](this.element).closest('.modal').off('hide.bs.modal', this._hideModalHandler);

      if (this.tip) {
        $__default["default"](this.tip).remove();
      }

      this._isEnabled = null;
      this._timeout = null;
      this._hoverState = null;
      this._activeTrigger = null;

      if (this._popper) {
        this._popper.destroy();
      }

      this._popper = null;
      this.element = null;
      this.config = null;
      this.tip = null;
    };

    _proto.show = function show() {
      var _this = this;

      if ($__default["default"](this.element).css('display') === 'none') {
        throw new Error('Please use show on visible elements');
      }

      var showEvent = $__default["default"].Event(this.constructor.Event.SHOW);

      if (this.isWithContent() && this._isEnabled) {
        $__default["default"](this.element).trigger(showEvent);
        var shadowRoot = Util.findShadowRoot(this.element);
        var isInTheDom = $__default["default"].contains(shadowRoot !== null ? shadowRoot : this.element.ownerDocument.documentElement, this.element);

        if (showEvent.isDefaultPrevented() || !isInTheDom) {
          return;
        }

        var tip = this.getTipElement();
        var tipId = Util.getUID(this.constructor.NAME);
        tip.setAttribute('id', tipId);
        this.element.setAttribute('aria-describedby', tipId);
        this.setContent();

        if (this.config.animation) {
          $__default["default"](tip).addClass(CLASS_NAME_FADE$3);
        }

        var placement = typeof this.config.placement === 'function' ? this.config.placement.call(this, tip, this.element) : this.config.placement;

        var attachment = this._getAttachment(placement);

        this.addAttachmentClass(attachment);

        var container = this._getContainer();

        $__default["default"](tip).data(this.constructor.DATA_KEY, this);

        if (!$__default["default"].contains(this.element.ownerDocument.documentElement, this.tip)) {
          $__default["default"](tip).appendTo(container);
        }

        $__default["default"](this.element).trigger(this.constructor.Event.INSERTED);
        this._popper = new Popper__default["default"](this.element, tip, this._getPopperConfig(attachment));
        $__default["default"](tip).addClass(CLASS_NAME_SHOW$3);
        $__default["default"](tip).addClass(this.config.customClass); // If this is a touch-enabled device we add extra
        // empty mouseover listeners to the body's immediate children;
        // only needed because of broken event delegation on iOS
        // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html

        if ('ontouchstart' in document.documentElement) {
          $__default["default"](document.body).children().on('mouseover', null, $__default["default"].noop);
        }

        var complete = function complete() {
          if (_this.config.animation) {
            _this._fixTransition();
          }

          var prevHoverState = _this._hoverState;
          _this._hoverState = null;
          $__default["default"](_this.element).trigger(_this.constructor.Event.SHOWN);

          if (prevHoverState === HOVER_STATE_OUT) {
            _this._leave(null, _this);
          }
        };

        if ($__default["default"](this.tip).hasClass(CLASS_NAME_FADE$3)) {
          var transitionDuration = Util.getTransitionDurationFromElement(this.tip);
          $__default["default"](this.tip).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
        } else {
          complete();
        }
      }
    };

    _proto.hide = function hide(callback) {
      var _this2 = this;

      var tip = this.getTipElement();
      var hideEvent = $__default["default"].Event(this.constructor.Event.HIDE);

      var complete = function complete() {
        if (_this2._hoverState !== HOVER_STATE_SHOW && tip.parentNode) {
          tip.parentNode.removeChild(tip);
        }

        _this2._cleanTipClass();

        _this2.element.removeAttribute('aria-describedby');

        $__default["default"](_this2.element).trigger(_this2.constructor.Event.HIDDEN);

        if (_this2._popper !== null) {
          _this2._popper.destroy();
        }

        if (callback) {
          callback();
        }
      };

      $__default["default"](this.element).trigger(hideEvent);

      if (hideEvent.isDefaultPrevented()) {
        return;
      }

      $__default["default"](tip).removeClass(CLASS_NAME_SHOW$3); // If this is a touch-enabled device we remove the extra
      // empty mouseover listeners we added for iOS support

      if ('ontouchstart' in document.documentElement) {
        $__default["default"](document.body).children().off('mouseover', null, $__default["default"].noop);
      }

      this._activeTrigger[TRIGGER_CLICK] = false;
      this._activeTrigger[TRIGGER_FOCUS] = false;
      this._activeTrigger[TRIGGER_HOVER] = false;

      if ($__default["default"](this.tip).hasClass(CLASS_NAME_FADE$3)) {
        var transitionDuration = Util.getTransitionDurationFromElement(tip);
        $__default["default"](tip).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      } else {
        complete();
      }

      this._hoverState = '';
    };

    _proto.update = function update() {
      if (this._popper !== null) {
        this._popper.scheduleUpdate();
      }
    } // Protected
    ;

    _proto.isWithContent = function isWithContent() {
      return Boolean(this.getTitle());
    };

    _proto.addAttachmentClass = function addAttachmentClass(attachment) {
      $__default["default"](this.getTipElement()).addClass(CLASS_PREFIX$1 + "-" + attachment);
    };

    _proto.getTipElement = function getTipElement() {
      this.tip = this.tip || $__default["default"](this.config.template)[0];
      return this.tip;
    };

    _proto.setContent = function setContent() {
      var tip = this.getTipElement();
      this.setElementContent($__default["default"](tip.querySelectorAll(SELECTOR_TOOLTIP_INNER)), this.getTitle());
      $__default["default"](tip).removeClass(CLASS_NAME_FADE$3 + " " + CLASS_NAME_SHOW$3);
    };

    _proto.setElementContent = function setElementContent($element, content) {
      if (typeof content === 'object' && (content.nodeType || content.jquery)) {
        // Content is a DOM node or a jQuery
        if (this.config.html) {
          if (!$__default["default"](content).parent().is($element)) {
            $element.empty().append(content);
          }
        } else {
          $element.text($__default["default"](content).text());
        }

        return;
      }

      if (this.config.html) {
        if (this.config.sanitize) {
          content = sanitizeHtml(content, this.config.whiteList, this.config.sanitizeFn);
        }

        $element.html(content);
      } else {
        $element.text(content);
      }
    };

    _proto.getTitle = function getTitle() {
      var title = this.element.getAttribute('data-original-title');

      if (!title) {
        title = typeof this.config.title === 'function' ? this.config.title.call(this.element) : this.config.title;
      }

      return title;
    } // Private
    ;

    _proto._getPopperConfig = function _getPopperConfig(attachment) {
      var _this3 = this;

      var defaultBsConfig = {
        placement: attachment,
        modifiers: {
          offset: this._getOffset(),
          flip: {
            behavior: this.config.fallbackPlacement
          },
          arrow: {
            element: SELECTOR_ARROW
          },
          preventOverflow: {
            boundariesElement: this.config.boundary
          }
        },
        onCreate: function onCreate(data) {
          if (data.originalPlacement !== data.placement) {
            _this3._handlePopperPlacementChange(data);
          }
        },
        onUpdate: function onUpdate(data) {
          return _this3._handlePopperPlacementChange(data);
        }
      };
      return _extends({}, defaultBsConfig, this.config.popperConfig);
    };

    _proto._getOffset = function _getOffset() {
      var _this4 = this;

      var offset = {};

      if (typeof this.config.offset === 'function') {
        offset.fn = function (data) {
          data.offsets = _extends({}, data.offsets, _this4.config.offset(data.offsets, _this4.element));
          return data;
        };
      } else {
        offset.offset = this.config.offset;
      }

      return offset;
    };

    _proto._getContainer = function _getContainer() {
      if (this.config.container === false) {
        return document.body;
      }

      if (Util.isElement(this.config.container)) {
        return $__default["default"](this.config.container);
      }

      return $__default["default"](document).find(this.config.container);
    };

    _proto._getAttachment = function _getAttachment(placement) {
      return AttachmentMap[placement.toUpperCase()];
    };

    _proto._setListeners = function _setListeners() {
      var _this5 = this;

      var triggers = this.config.trigger.split(' ');
      triggers.forEach(function (trigger) {
        if (trigger === 'click') {
          $__default["default"](_this5.element).on(_this5.constructor.Event.CLICK, _this5.config.selector, function (event) {
            return _this5.toggle(event);
          });
        } else if (trigger !== TRIGGER_MANUAL) {
          var eventIn = trigger === TRIGGER_HOVER ? _this5.constructor.Event.MOUSEENTER : _this5.constructor.Event.FOCUSIN;
          var eventOut = trigger === TRIGGER_HOVER ? _this5.constructor.Event.MOUSELEAVE : _this5.constructor.Event.FOCUSOUT;
          $__default["default"](_this5.element).on(eventIn, _this5.config.selector, function (event) {
            return _this5._enter(event);
          }).on(eventOut, _this5.config.selector, function (event) {
            return _this5._leave(event);
          });
        }
      });

      this._hideModalHandler = function () {
        if (_this5.element) {
          _this5.hide();
        }
      };

      $__default["default"](this.element).closest('.modal').on('hide.bs.modal', this._hideModalHandler);

      if (this.config.selector) {
        this.config = _extends({}, this.config, {
          trigger: 'manual',
          selector: ''
        });
      } else {
        this._fixTitle();
      }
    };

    _proto._fixTitle = function _fixTitle() {
      var titleType = typeof this.element.getAttribute('data-original-title');

      if (this.element.getAttribute('title') || titleType !== 'string') {
        this.element.setAttribute('data-original-title', this.element.getAttribute('title') || '');
        this.element.setAttribute('title', '');
      }
    };

    _proto._enter = function _enter(event, context) {
      var dataKey = this.constructor.DATA_KEY;
      context = context || $__default["default"](event.currentTarget).data(dataKey);

      if (!context) {
        context = new this.constructor(event.currentTarget, this._getDelegateConfig());
        $__default["default"](event.currentTarget).data(dataKey, context);
      }

      if (event) {
        context._activeTrigger[event.type === 'focusin' ? TRIGGER_FOCUS : TRIGGER_HOVER] = true;
      }

      if ($__default["default"](context.getTipElement()).hasClass(CLASS_NAME_SHOW$3) || context._hoverState === HOVER_STATE_SHOW) {
        context._hoverState = HOVER_STATE_SHOW;
        return;
      }

      clearTimeout(context._timeout);
      context._hoverState = HOVER_STATE_SHOW;

      if (!context.config.delay || !context.config.delay.show) {
        context.show();
        return;
      }

      context._timeout = setTimeout(function () {
        if (context._hoverState === HOVER_STATE_SHOW) {
          context.show();
        }
      }, context.config.delay.show);
    };

    _proto._leave = function _leave(event, context) {
      var dataKey = this.constructor.DATA_KEY;
      context = context || $__default["default"](event.currentTarget).data(dataKey);

      if (!context) {
        context = new this.constructor(event.currentTarget, this._getDelegateConfig());
        $__default["default"](event.currentTarget).data(dataKey, context);
      }

      if (event) {
        context._activeTrigger[event.type === 'focusout' ? TRIGGER_FOCUS : TRIGGER_HOVER] = false;
      }

      if (context._isWithActiveTrigger()) {
        return;
      }

      clearTimeout(context._timeout);
      context._hoverState = HOVER_STATE_OUT;

      if (!context.config.delay || !context.config.delay.hide) {
        context.hide();
        return;
      }

      context._timeout = setTimeout(function () {
        if (context._hoverState === HOVER_STATE_OUT) {
          context.hide();
        }
      }, context.config.delay.hide);
    };

    _proto._isWithActiveTrigger = function _isWithActiveTrigger() {
      for (var trigger in this._activeTrigger) {
        if (this._activeTrigger[trigger]) {
          return true;
        }
      }

      return false;
    };

    _proto._getConfig = function _getConfig(config) {
      var dataAttributes = $__default["default"](this.element).data();
      Object.keys(dataAttributes).forEach(function (dataAttr) {
        if (DISALLOWED_ATTRIBUTES.indexOf(dataAttr) !== -1) {
          delete dataAttributes[dataAttr];
        }
      });
      config = _extends({}, this.constructor.Default, dataAttributes, typeof config === 'object' && config ? config : {});

      if (typeof config.delay === 'number') {
        config.delay = {
          show: config.delay,
          hide: config.delay
        };
      }

      if (typeof config.title === 'number') {
        config.title = config.title.toString();
      }

      if (typeof config.content === 'number') {
        config.content = config.content.toString();
      }

      Util.typeCheckConfig(NAME$4, config, this.constructor.DefaultType);

      if (config.sanitize) {
        config.template = sanitizeHtml(config.template, config.whiteList, config.sanitizeFn);
      }

      return config;
    };

    _proto._getDelegateConfig = function _getDelegateConfig() {
      var config = {};

      if (this.config) {
        for (var key in this.config) {
          if (this.constructor.Default[key] !== this.config[key]) {
            config[key] = this.config[key];
          }
        }
      }

      return config;
    };

    _proto._cleanTipClass = function _cleanTipClass() {
      var $tip = $__default["default"](this.getTipElement());
      var tabClass = $tip.attr('class').match(BSCLS_PREFIX_REGEX$1);

      if (tabClass !== null && tabClass.length) {
        $tip.removeClass(tabClass.join(''));
      }
    };

    _proto._handlePopperPlacementChange = function _handlePopperPlacementChange(popperData) {
      this.tip = popperData.instance.popper;

      this._cleanTipClass();

      this.addAttachmentClass(this._getAttachment(popperData.placement));
    };

    _proto._fixTransition = function _fixTransition() {
      var tip = this.getTipElement();
      var initConfigAnimation = this.config.animation;

      if (tip.getAttribute('x-placement') !== null) {
        return;
      }

      $__default["default"](tip).removeClass(CLASS_NAME_FADE$3);
      this.config.animation = false;
      this.hide();
      this.show();
      this.config.animation = initConfigAnimation;
    } // Static
    ;

    Tooltip._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $element = $__default["default"](this);
        var data = $element.data(DATA_KEY$4);

        var _config = typeof config === 'object' && config;

        if (!data && /dispose|hide/.test(config)) {
          return;
        }

        if (!data) {
          data = new Tooltip(this, _config);
          $element.data(DATA_KEY$4, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(Tooltip, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$4;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$3;
      }
    }, {
      key: "NAME",
      get: function get() {
        return NAME$4;
      }
    }, {
      key: "DATA_KEY",
      get: function get() {
        return DATA_KEY$4;
      }
    }, {
      key: "Event",
      get: function get() {
        return Event$1;
      }
    }, {
      key: "EVENT_KEY",
      get: function get() {
        return EVENT_KEY$4;
      }
    }, {
      key: "DefaultType",
      get: function get() {
        return DefaultType$3;
      }
    }]);

    return Tooltip;
  }();
  /**
   * jQuery
   */


  $__default["default"].fn[NAME$4] = Tooltip._jQueryInterface;
  $__default["default"].fn[NAME$4].Constructor = Tooltip;

  $__default["default"].fn[NAME$4].noConflict = function () {
    $__default["default"].fn[NAME$4] = JQUERY_NO_CONFLICT$4;
    return Tooltip._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$3 = 'popover';
  var VERSION$3 = '4.6.2';
  var DATA_KEY$3 = 'bs.popover';
  var EVENT_KEY$3 = "." + DATA_KEY$3;
  var JQUERY_NO_CONFLICT$3 = $__default["default"].fn[NAME$3];
  var CLASS_PREFIX = 'bs-popover';
  var BSCLS_PREFIX_REGEX = new RegExp("(^|\\s)" + CLASS_PREFIX + "\\S+", 'g');
  var CLASS_NAME_FADE$2 = 'fade';
  var CLASS_NAME_SHOW$2 = 'show';
  var SELECTOR_TITLE = '.popover-header';
  var SELECTOR_CONTENT = '.popover-body';

  var Default$2 = _extends({}, Tooltip.Default, {
    placement: 'right',
    trigger: 'click',
    content: '',
    template: '<div class="popover" role="tooltip">' + '<div class="arrow"></div>' + '<h3 class="popover-header"></h3>' + '<div class="popover-body"></div></div>'
  });

  var DefaultType$2 = _extends({}, Tooltip.DefaultType, {
    content: '(string|element|function)'
  });

  var Event = {
    HIDE: "hide" + EVENT_KEY$3,
    HIDDEN: "hidden" + EVENT_KEY$3,
    SHOW: "show" + EVENT_KEY$3,
    SHOWN: "shown" + EVENT_KEY$3,
    INSERTED: "inserted" + EVENT_KEY$3,
    CLICK: "click" + EVENT_KEY$3,
    FOCUSIN: "focusin" + EVENT_KEY$3,
    FOCUSOUT: "focusout" + EVENT_KEY$3,
    MOUSEENTER: "mouseenter" + EVENT_KEY$3,
    MOUSELEAVE: "mouseleave" + EVENT_KEY$3
  };
  /**
   * Class definition
   */

  var Popover = /*#__PURE__*/function (_Tooltip) {
    _inheritsLoose(Popover, _Tooltip);

    function Popover() {
      return _Tooltip.apply(this, arguments) || this;
    }

    var _proto = Popover.prototype;

    // Overrides
    _proto.isWithContent = function isWithContent() {
      return this.getTitle() || this._getContent();
    };

    _proto.addAttachmentClass = function addAttachmentClass(attachment) {
      $__default["default"](this.getTipElement()).addClass(CLASS_PREFIX + "-" + attachment);
    };

    _proto.getTipElement = function getTipElement() {
      this.tip = this.tip || $__default["default"](this.config.template)[0];
      return this.tip;
    };

    _proto.setContent = function setContent() {
      var $tip = $__default["default"](this.getTipElement()); // We use append for html objects to maintain js events

      this.setElementContent($tip.find(SELECTOR_TITLE), this.getTitle());

      var content = this._getContent();

      if (typeof content === 'function') {
        content = content.call(this.element);
      }

      this.setElementContent($tip.find(SELECTOR_CONTENT), content);
      $tip.removeClass(CLASS_NAME_FADE$2 + " " + CLASS_NAME_SHOW$2);
    } // Private
    ;

    _proto._getContent = function _getContent() {
      return this.element.getAttribute('data-content') || this.config.content;
    };

    _proto._cleanTipClass = function _cleanTipClass() {
      var $tip = $__default["default"](this.getTipElement());
      var tabClass = $tip.attr('class').match(BSCLS_PREFIX_REGEX);

      if (tabClass !== null && tabClass.length > 0) {
        $tip.removeClass(tabClass.join(''));
      }
    } // Static
    ;

    Popover._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default["default"](this).data(DATA_KEY$3);

        var _config = typeof config === 'object' ? config : null;

        if (!data && /dispose|hide/.test(config)) {
          return;
        }

        if (!data) {
          data = new Popover(this, _config);
          $__default["default"](this).data(DATA_KEY$3, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(Popover, null, [{
      key: "VERSION",
      get: // Getters
      function get() {
        return VERSION$3;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$2;
      }
    }, {
      key: "NAME",
      get: function get() {
        return NAME$3;
      }
    }, {
      key: "DATA_KEY",
      get: function get() {
        return DATA_KEY$3;
      }
    }, {
      key: "Event",
      get: function get() {
        return Event;
      }
    }, {
      key: "EVENT_KEY",
      get: function get() {
        return EVENT_KEY$3;
      }
    }, {
      key: "DefaultType",
      get: function get() {
        return DefaultType$2;
      }
    }]);

    return Popover;
  }(Tooltip);
  /**
   * jQuery
   */


  $__default["default"].fn[NAME$3] = Popover._jQueryInterface;
  $__default["default"].fn[NAME$3].Constructor = Popover;

  $__default["default"].fn[NAME$3].noConflict = function () {
    $__default["default"].fn[NAME$3] = JQUERY_NO_CONFLICT$3;
    return Popover._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$2 = 'scrollspy';
  var VERSION$2 = '4.6.2';
  var DATA_KEY$2 = 'bs.scrollspy';
  var EVENT_KEY$2 = "." + DATA_KEY$2;
  var DATA_API_KEY$1 = '.data-api';
  var JQUERY_NO_CONFLICT$2 = $__default["default"].fn[NAME$2];
  var CLASS_NAME_DROPDOWN_ITEM = 'dropdown-item';
  var CLASS_NAME_ACTIVE$1 = 'active';
  var EVENT_ACTIVATE = "activate" + EVENT_KEY$2;
  var EVENT_SCROLL = "scroll" + EVENT_KEY$2;
  var EVENT_LOAD_DATA_API = "load" + EVENT_KEY$2 + DATA_API_KEY$1;
  var METHOD_OFFSET = 'offset';
  var METHOD_POSITION = 'position';
  var SELECTOR_DATA_SPY = '[data-spy="scroll"]';
  var SELECTOR_NAV_LIST_GROUP$1 = '.nav, .list-group';
  var SELECTOR_NAV_LINKS = '.nav-link';
  var SELECTOR_NAV_ITEMS = '.nav-item';
  var SELECTOR_LIST_ITEMS = '.list-group-item';
  var SELECTOR_DROPDOWN$1 = '.dropdown';
  var SELECTOR_DROPDOWN_ITEMS = '.dropdown-item';
  var SELECTOR_DROPDOWN_TOGGLE$1 = '.dropdown-toggle';
  var Default$1 = {
    offset: 10,
    method: 'auto',
    target: ''
  };
  var DefaultType$1 = {
    offset: 'number',
    method: 'string',
    target: '(string|element)'
  };
  /**
   * Class definition
   */

  var ScrollSpy = /*#__PURE__*/function () {
    function ScrollSpy(element, config) {
      var _this = this;

      this._element = element;
      this._scrollElement = element.tagName === 'BODY' ? window : element;
      this._config = this._getConfig(config);
      this._selector = this._config.target + " " + SELECTOR_NAV_LINKS + "," + (this._config.target + " " + SELECTOR_LIST_ITEMS + ",") + (this._config.target + " " + SELECTOR_DROPDOWN_ITEMS);
      this._offsets = [];
      this._targets = [];
      this._activeTarget = null;
      this._scrollHeight = 0;
      $__default["default"](this._scrollElement).on(EVENT_SCROLL, function (event) {
        return _this._process(event);
      });
      this.refresh();

      this._process();
    } // Getters


    var _proto = ScrollSpy.prototype;

    // Public
    _proto.refresh = function refresh() {
      var _this2 = this;

      var autoMethod = this._scrollElement === this._scrollElement.window ? METHOD_OFFSET : METHOD_POSITION;
      var offsetMethod = this._config.method === 'auto' ? autoMethod : this._config.method;
      var offsetBase = offsetMethod === METHOD_POSITION ? this._getScrollTop() : 0;
      this._offsets = [];
      this._targets = [];
      this._scrollHeight = this._getScrollHeight();
      var targets = [].slice.call(document.querySelectorAll(this._selector));
      targets.map(function (element) {
        var target;
        var targetSelector = Util.getSelectorFromElement(element);

        if (targetSelector) {
          target = document.querySelector(targetSelector);
        }

        if (target) {
          var targetBCR = target.getBoundingClientRect();

          if (targetBCR.width || targetBCR.height) {
            // TODO (fat): remove sketch reliance on jQuery position/offset
            return [$__default["default"](target)[offsetMethod]().top + offsetBase, targetSelector];
          }
        }

        return null;
      }).filter(Boolean).sort(function (a, b) {
        return a[0] - b[0];
      }).forEach(function (item) {
        _this2._offsets.push(item[0]);

        _this2._targets.push(item[1]);
      });
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$2);
      $__default["default"](this._scrollElement).off(EVENT_KEY$2);
      this._element = null;
      this._scrollElement = null;
      this._config = null;
      this._selector = null;
      this._offsets = null;
      this._targets = null;
      this._activeTarget = null;
      this._scrollHeight = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default$1, typeof config === 'object' && config ? config : {});

      if (typeof config.target !== 'string' && Util.isElement(config.target)) {
        var id = $__default["default"](config.target).attr('id');

        if (!id) {
          id = Util.getUID(NAME$2);
          $__default["default"](config.target).attr('id', id);
        }

        config.target = "#" + id;
      }

      Util.typeCheckConfig(NAME$2, config, DefaultType$1);
      return config;
    };

    _proto._getScrollTop = function _getScrollTop() {
      return this._scrollElement === window ? this._scrollElement.pageYOffset : this._scrollElement.scrollTop;
    };

    _proto._getScrollHeight = function _getScrollHeight() {
      return this._scrollElement.scrollHeight || Math.max(document.body.scrollHeight, document.documentElement.scrollHeight);
    };

    _proto._getOffsetHeight = function _getOffsetHeight() {
      return this._scrollElement === window ? window.innerHeight : this._scrollElement.getBoundingClientRect().height;
    };

    _proto._process = function _process() {
      var scrollTop = this._getScrollTop() + this._config.offset;

      var scrollHeight = this._getScrollHeight();

      var maxScroll = this._config.offset + scrollHeight - this._getOffsetHeight();

      if (this._scrollHeight !== scrollHeight) {
        this.refresh();
      }

      if (scrollTop >= maxScroll) {
        var target = this._targets[this._targets.length - 1];

        if (this._activeTarget !== target) {
          this._activate(target);
        }

        return;
      }

      if (this._activeTarget && scrollTop < this._offsets[0] && this._offsets[0] > 0) {
        this._activeTarget = null;

        this._clear();

        return;
      }

      for (var i = this._offsets.length; i--;) {
        var isActiveTarget = this._activeTarget !== this._targets[i] && scrollTop >= this._offsets[i] && (typeof this._offsets[i + 1] === 'undefined' || scrollTop < this._offsets[i + 1]);

        if (isActiveTarget) {
          this._activate(this._targets[i]);
        }
      }
    };

    _proto._activate = function _activate(target) {
      this._activeTarget = target;

      this._clear();

      var queries = this._selector.split(',').map(function (selector) {
        return selector + "[data-target=\"" + target + "\"]," + selector + "[href=\"" + target + "\"]";
      });

      var $link = $__default["default"]([].slice.call(document.querySelectorAll(queries.join(','))));

      if ($link.hasClass(CLASS_NAME_DROPDOWN_ITEM)) {
        $link.closest(SELECTOR_DROPDOWN$1).find(SELECTOR_DROPDOWN_TOGGLE$1).addClass(CLASS_NAME_ACTIVE$1);
        $link.addClass(CLASS_NAME_ACTIVE$1);
      } else {
        // Set triggered link as active
        $link.addClass(CLASS_NAME_ACTIVE$1); // Set triggered links parents as active
        // With both <ul> and <nav> markup a parent is the previous sibling of any nav ancestor

        $link.parents(SELECTOR_NAV_LIST_GROUP$1).prev(SELECTOR_NAV_LINKS + ", " + SELECTOR_LIST_ITEMS).addClass(CLASS_NAME_ACTIVE$1); // Handle special case when .nav-link is inside .nav-item

        $link.parents(SELECTOR_NAV_LIST_GROUP$1).prev(SELECTOR_NAV_ITEMS).children(SELECTOR_NAV_LINKS).addClass(CLASS_NAME_ACTIVE$1);
      }

      $__default["default"](this._scrollElement).trigger(EVENT_ACTIVATE, {
        relatedTarget: target
      });
    };

    _proto._clear = function _clear() {
      [].slice.call(document.querySelectorAll(this._selector)).filter(function (node) {
        return node.classList.contains(CLASS_NAME_ACTIVE$1);
      }).forEach(function (node) {
        return node.classList.remove(CLASS_NAME_ACTIVE$1);
      });
    } // Static
    ;

    ScrollSpy._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default["default"](this).data(DATA_KEY$2);

        var _config = typeof config === 'object' && config;

        if (!data) {
          data = new ScrollSpy(this, _config);
          $__default["default"](this).data(DATA_KEY$2, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(ScrollSpy, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$2;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$1;
      }
    }]);

    return ScrollSpy;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](window).on(EVENT_LOAD_DATA_API, function () {
    var scrollSpys = [].slice.call(document.querySelectorAll(SELECTOR_DATA_SPY));
    var scrollSpysLength = scrollSpys.length;

    for (var i = scrollSpysLength; i--;) {
      var $spy = $__default["default"](scrollSpys[i]);

      ScrollSpy._jQueryInterface.call($spy, $spy.data());
    }
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$2] = ScrollSpy._jQueryInterface;
  $__default["default"].fn[NAME$2].Constructor = ScrollSpy;

  $__default["default"].fn[NAME$2].noConflict = function () {
    $__default["default"].fn[NAME$2] = JQUERY_NO_CONFLICT$2;
    return ScrollSpy._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME$1 = 'tab';
  var VERSION$1 = '4.6.2';
  var DATA_KEY$1 = 'bs.tab';
  var EVENT_KEY$1 = "." + DATA_KEY$1;
  var DATA_API_KEY = '.data-api';
  var JQUERY_NO_CONFLICT$1 = $__default["default"].fn[NAME$1];
  var CLASS_NAME_DROPDOWN_MENU = 'dropdown-menu';
  var CLASS_NAME_ACTIVE = 'active';
  var CLASS_NAME_DISABLED = 'disabled';
  var CLASS_NAME_FADE$1 = 'fade';
  var CLASS_NAME_SHOW$1 = 'show';
  var EVENT_HIDE$1 = "hide" + EVENT_KEY$1;
  var EVENT_HIDDEN$1 = "hidden" + EVENT_KEY$1;
  var EVENT_SHOW$1 = "show" + EVENT_KEY$1;
  var EVENT_SHOWN$1 = "shown" + EVENT_KEY$1;
  var EVENT_CLICK_DATA_API = "click" + EVENT_KEY$1 + DATA_API_KEY;
  var SELECTOR_DROPDOWN = '.dropdown';
  var SELECTOR_NAV_LIST_GROUP = '.nav, .list-group';
  var SELECTOR_ACTIVE = '.active';
  var SELECTOR_ACTIVE_UL = '> li > .active';
  var SELECTOR_DATA_TOGGLE = '[data-toggle="tab"], [data-toggle="pill"], [data-toggle="list"]';
  var SELECTOR_DROPDOWN_TOGGLE = '.dropdown-toggle';
  var SELECTOR_DROPDOWN_ACTIVE_CHILD = '> .dropdown-menu .active';
  /**
   * Class definition
   */

  var Tab = /*#__PURE__*/function () {
    function Tab(element) {
      this._element = element;
    } // Getters


    var _proto = Tab.prototype;

    // Public
    _proto.show = function show() {
      var _this = this;

      if (this._element.parentNode && this._element.parentNode.nodeType === Node.ELEMENT_NODE && $__default["default"](this._element).hasClass(CLASS_NAME_ACTIVE) || $__default["default"](this._element).hasClass(CLASS_NAME_DISABLED) || this._element.hasAttribute('disabled')) {
        return;
      }

      var target;
      var previous;
      var listElement = $__default["default"](this._element).closest(SELECTOR_NAV_LIST_GROUP)[0];
      var selector = Util.getSelectorFromElement(this._element);

      if (listElement) {
        var itemSelector = listElement.nodeName === 'UL' || listElement.nodeName === 'OL' ? SELECTOR_ACTIVE_UL : SELECTOR_ACTIVE;
        previous = $__default["default"].makeArray($__default["default"](listElement).find(itemSelector));
        previous = previous[previous.length - 1];
      }

      var hideEvent = $__default["default"].Event(EVENT_HIDE$1, {
        relatedTarget: this._element
      });
      var showEvent = $__default["default"].Event(EVENT_SHOW$1, {
        relatedTarget: previous
      });

      if (previous) {
        $__default["default"](previous).trigger(hideEvent);
      }

      $__default["default"](this._element).trigger(showEvent);

      if (showEvent.isDefaultPrevented() || hideEvent.isDefaultPrevented()) {
        return;
      }

      if (selector) {
        target = document.querySelector(selector);
      }

      this._activate(this._element, listElement);

      var complete = function complete() {
        var hiddenEvent = $__default["default"].Event(EVENT_HIDDEN$1, {
          relatedTarget: _this._element
        });
        var shownEvent = $__default["default"].Event(EVENT_SHOWN$1, {
          relatedTarget: previous
        });
        $__default["default"](previous).trigger(hiddenEvent);
        $__default["default"](_this._element).trigger(shownEvent);
      };

      if (target) {
        this._activate(target, target.parentNode, complete);
      } else {
        complete();
      }
    };

    _proto.dispose = function dispose() {
      $__default["default"].removeData(this._element, DATA_KEY$1);
      this._element = null;
    } // Private
    ;

    _proto._activate = function _activate(element, container, callback) {
      var _this2 = this;

      var activeElements = container && (container.nodeName === 'UL' || container.nodeName === 'OL') ? $__default["default"](container).find(SELECTOR_ACTIVE_UL) : $__default["default"](container).children(SELECTOR_ACTIVE);
      var active = activeElements[0];
      var isTransitioning = callback && active && $__default["default"](active).hasClass(CLASS_NAME_FADE$1);

      var complete = function complete() {
        return _this2._transitionComplete(element, active, callback);
      };

      if (active && isTransitioning) {
        var transitionDuration = Util.getTransitionDurationFromElement(active);
        $__default["default"](active).removeClass(CLASS_NAME_SHOW$1).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      } else {
        complete();
      }
    };

    _proto._transitionComplete = function _transitionComplete(element, active, callback) {
      if (active) {
        $__default["default"](active).removeClass(CLASS_NAME_ACTIVE);
        var dropdownChild = $__default["default"](active.parentNode).find(SELECTOR_DROPDOWN_ACTIVE_CHILD)[0];

        if (dropdownChild) {
          $__default["default"](dropdownChild).removeClass(CLASS_NAME_ACTIVE);
        }

        if (active.getAttribute('role') === 'tab') {
          active.setAttribute('aria-selected', false);
        }
      }

      $__default["default"](element).addClass(CLASS_NAME_ACTIVE);

      if (element.getAttribute('role') === 'tab') {
        element.setAttribute('aria-selected', true);
      }

      Util.reflow(element);

      if (element.classList.contains(CLASS_NAME_FADE$1)) {
        element.classList.add(CLASS_NAME_SHOW$1);
      }

      var parent = element.parentNode;

      if (parent && parent.nodeName === 'LI') {
        parent = parent.parentNode;
      }

      if (parent && $__default["default"](parent).hasClass(CLASS_NAME_DROPDOWN_MENU)) {
        var dropdownElement = $__default["default"](element).closest(SELECTOR_DROPDOWN)[0];

        if (dropdownElement) {
          var dropdownToggleList = [].slice.call(dropdownElement.querySelectorAll(SELECTOR_DROPDOWN_TOGGLE));
          $__default["default"](dropdownToggleList).addClass(CLASS_NAME_ACTIVE);
        }

        element.setAttribute('aria-expanded', true);
      }

      if (callback) {
        callback();
      }
    } // Static
    ;

    Tab._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $this = $__default["default"](this);
        var data = $this.data(DATA_KEY$1);

        if (!data) {
          data = new Tab(this);
          $this.data(DATA_KEY$1, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(Tab, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$1;
      }
    }]);

    return Tab;
  }();
  /**
   * Data API implementation
   */


  $__default["default"](document).on(EVENT_CLICK_DATA_API, SELECTOR_DATA_TOGGLE, function (event) {
    event.preventDefault();

    Tab._jQueryInterface.call($__default["default"](this), 'show');
  });
  /**
   * jQuery
   */

  $__default["default"].fn[NAME$1] = Tab._jQueryInterface;
  $__default["default"].fn[NAME$1].Constructor = Tab;

  $__default["default"].fn[NAME$1].noConflict = function () {
    $__default["default"].fn[NAME$1] = JQUERY_NO_CONFLICT$1;
    return Tab._jQueryInterface;
  };

  /**
   * Constants
   */

  var NAME = 'toast';
  var VERSION = '4.6.2';
  var DATA_KEY = 'bs.toast';
  var EVENT_KEY = "." + DATA_KEY;
  var JQUERY_NO_CONFLICT = $__default["default"].fn[NAME];
  var CLASS_NAME_FADE = 'fade';
  var CLASS_NAME_HIDE = 'hide';
  var CLASS_NAME_SHOW = 'show';
  var CLASS_NAME_SHOWING = 'showing';
  var EVENT_CLICK_DISMISS = "click.dismiss" + EVENT_KEY;
  var EVENT_HIDE = "hide" + EVENT_KEY;
  var EVENT_HIDDEN = "hidden" + EVENT_KEY;
  var EVENT_SHOW = "show" + EVENT_KEY;
  var EVENT_SHOWN = "shown" + EVENT_KEY;
  var SELECTOR_DATA_DISMISS = '[data-dismiss="toast"]';
  var Default = {
    animation: true,
    autohide: true,
    delay: 500
  };
  var DefaultType = {
    animation: 'boolean',
    autohide: 'boolean',
    delay: 'number'
  };
  /**
   * Class definition
   */

  var Toast = /*#__PURE__*/function () {
    function Toast(element, config) {
      this._element = element;
      this._config = this._getConfig(config);
      this._timeout = null;

      this._setListeners();
    } // Getters


    var _proto = Toast.prototype;

    // Public
    _proto.show = function show() {
      var _this = this;

      var showEvent = $__default["default"].Event(EVENT_SHOW);
      $__default["default"](this._element).trigger(showEvent);

      if (showEvent.isDefaultPrevented()) {
        return;
      }

      this._clearTimeout();

      if (this._config.animation) {
        this._element.classList.add(CLASS_NAME_FADE);
      }

      var complete = function complete() {
        _this._element.classList.remove(CLASS_NAME_SHOWING);

        _this._element.classList.add(CLASS_NAME_SHOW);

        $__default["default"](_this._element).trigger(EVENT_SHOWN);

        if (_this._config.autohide) {
          _this._timeout = setTimeout(function () {
            _this.hide();
          }, _this._config.delay);
        }
      };

      this._element.classList.remove(CLASS_NAME_HIDE);

      Util.reflow(this._element);

      this._element.classList.add(CLASS_NAME_SHOWING);

      if (this._config.animation) {
        var transitionDuration = Util.getTransitionDurationFromElement(this._element);
        $__default["default"](this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      } else {
        complete();
      }
    };

    _proto.hide = function hide() {
      if (!this._element.classList.contains(CLASS_NAME_SHOW)) {
        return;
      }

      var hideEvent = $__default["default"].Event(EVENT_HIDE);
      $__default["default"](this._element).trigger(hideEvent);

      if (hideEvent.isDefaultPrevented()) {
        return;
      }

      this._close();
    };

    _proto.dispose = function dispose() {
      this._clearTimeout();

      if (this._element.classList.contains(CLASS_NAME_SHOW)) {
        this._element.classList.remove(CLASS_NAME_SHOW);
      }

      $__default["default"](this._element).off(EVENT_CLICK_DISMISS);
      $__default["default"].removeData(this._element, DATA_KEY);
      this._element = null;
      this._config = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default, $__default["default"](this._element).data(), typeof config === 'object' && config ? config : {});
      Util.typeCheckConfig(NAME, config, this.constructor.DefaultType);
      return config;
    };

    _proto._setListeners = function _setListeners() {
      var _this2 = this;

      $__default["default"](this._element).on(EVENT_CLICK_DISMISS, SELECTOR_DATA_DISMISS, function () {
        return _this2.hide();
      });
    };

    _proto._close = function _close() {
      var _this3 = this;

      var complete = function complete() {
        _this3._element.classList.add(CLASS_NAME_HIDE);

        $__default["default"](_this3._element).trigger(EVENT_HIDDEN);
      };

      this._element.classList.remove(CLASS_NAME_SHOW);

      if (this._config.animation) {
        var transitionDuration = Util.getTransitionDurationFromElement(this._element);
        $__default["default"](this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      } else {
        complete();
      }
    };

    _proto._clearTimeout = function _clearTimeout() {
      clearTimeout(this._timeout);
      this._timeout = null;
    } // Static
    ;

    Toast._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $element = $__default["default"](this);
        var data = $element.data(DATA_KEY);

        var _config = typeof config === 'object' && config;

        if (!data) {
          data = new Toast(this, _config);
          $element.data(DATA_KEY, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config](this);
        }
      });
    };

    _createClass(Toast, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION;
      }
    }, {
      key: "DefaultType",
      get: function get() {
        return DefaultType;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default;
      }
    }]);

    return Toast;
  }();
  /**
   * jQuery
   */


  $__default["default"].fn[NAME] = Toast._jQueryInterface;
  $__default["default"].fn[NAME].Constructor = Toast;

  $__default["default"].fn[NAME].noConflict = function () {
    $__default["default"].fn[NAME] = JQUERY_NO_CONFLICT;
    return Toast._jQueryInterface;
  };

  exports.Alert = Alert;
  exports.Button = Button;
  exports.Carousel = Carousel;
  exports.Collapse = Collapse;
  exports.Dropdown = Dropdown;
  exports.Modal = Modal;
  exports.Popover = Popover;
  exports.Scrollspy = ScrollSpy;
  exports.Tab = Tab;
  exports.Toast = Toast;
  exports.Tooltip = Tooltip;
  exports.Util = Util;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=bootstrap.js.map

;/*\
|*| ========================================================================
|*| Bootstrap Toggle: bootstrap4-toggle.js v3.6.1
|*| https://gitbrent.github.io/bootstrap4-toggle/
|*| ========================================================================
|*| Copyright 2018-2019 Brent Ely
|*| Licensed under MIT
|*| ========================================================================
\*/
!function(a){"use strict";function l(t,e){this.$element=a(t),this.options=a.extend({},this.defaults(),e),this.render()}l.VERSION="3.6.0",l.DEFAULTS={on:"On",off:"Off",onstyle:"primary",offstyle:"light",size:"normal",style:"",width:null,height:null},l.prototype.defaults=function(){return{on:this.$element.attr("data-on")||l.DEFAULTS.on,off:this.$element.attr("data-off")||l.DEFAULTS.off,onstyle:this.$element.attr("data-onstyle")||l.DEFAULTS.onstyle,offstyle:this.$element.attr("data-offstyle")||l.DEFAULTS.offstyle,size:this.$element.attr("data-size")||l.DEFAULTS.size,style:this.$element.attr("data-style")||l.DEFAULTS.style,width:this.$element.attr("data-width")||l.DEFAULTS.width,height:this.$element.attr("data-height")||l.DEFAULTS.height}},l.prototype.render=function(){this._onstyle="btn-"+this.options.onstyle,this._offstyle="btn-"+this.options.offstyle;var t="large"===this.options.size||"lg"===this.options.size?"btn-lg":"small"===this.options.size||"sm"===this.options.size?"btn-sm":"mini"===this.options.size||"xs"===this.options.size?"btn-xs":"",e=a('<label for="'+this.$element.prop("id")+'" class="btn">').html(this.options.on).addClass(this._onstyle+" "+t),s=a('<label for="'+this.$element.prop("id")+'" class="btn">').html(this.options.off).addClass(this._offstyle+" "+t),o=a('<span class="toggle-handle btn btn-light">').addClass(t),i=a('<div class="toggle-group">').append(e,s,o),l=a('<div class="toggle btn" data-toggle="toggle" role="button">').addClass(this.$element.prop("checked")?this._onstyle:this._offstyle+" off").addClass(t).addClass(this.options.style);this.$element.wrap(l),a.extend(this,{$toggle:this.$element.parent(),$toggleOn:e,$toggleOff:s,$toggleGroup:i}),this.$toggle.append(i);var n=this.options.width||Math.max(e.outerWidth(),s.outerWidth())+o.outerWidth()/2,h=this.options.height||Math.max(e.outerHeight(),s.outerHeight());e.addClass("toggle-on"),s.addClass("toggle-off"),this.$toggle.css({width:n,height:h}),this.options.height&&(e.css("line-height",e.height()+"px"),s.css("line-height",s.height()+"px")),this.update(!0),this.trigger(!0)},l.prototype.toggle=function(){this.$element.prop("checked")?this.off():this.on()},l.prototype.on=function(t){if(this.$element.prop("disabled"))return!1;this.$toggle.removeClass(this._offstyle+" off").addClass(this._onstyle),this.$element.prop("checked",!0),t||this.trigger()},l.prototype.off=function(t){if(this.$element.prop("disabled"))return!1;this.$toggle.removeClass(this._onstyle).addClass(this._offstyle+" off"),this.$element.prop("checked",!1),t||this.trigger()},l.prototype.enable=function(){this.$toggle.removeClass("disabled"),this.$toggle.removeAttr("disabled"),this.$element.prop("disabled",!1)},l.prototype.disable=function(){this.$toggle.addClass("disabled"),this.$toggle.attr("disabled","disabled"),this.$element.prop("disabled",!0)},l.prototype.update=function(t){this.$element.prop("disabled")?this.disable():this.enable(),this.$element.prop("checked")?this.on(t):this.off(t)},l.prototype.trigger=function(t){this.$element.off("change.bs.toggle"),t||this.$element.change(),this.$element.on("change.bs.toggle",a.proxy(function(){this.update()},this))},l.prototype.destroy=function(){this.$element.off("change.bs.toggle"),this.$toggleGroup.remove(),this.$element.removeData("bs.toggle"),this.$element.unwrap()};var t=a.fn.bootstrapToggle;a.fn.bootstrapToggle=function(o){var i=Array.prototype.slice.call(arguments,1)[0];return this.each(function(){var t=a(this),e=t.data("bs.toggle"),s="object"==typeof o&&o;e||t.data("bs.toggle",e=new l(this,s)),"string"==typeof o&&e[o]&&"boolean"==typeof i?e[o](i):"string"==typeof o&&e[o]&&e[o]()})},a.fn.bootstrapToggle.Constructor=l,a.fn.toggle.noConflict=function(){return a.fn.bootstrapToggle=t,this},a(function(){a("input[type=checkbox][data-toggle^=toggle]").bootstrapToggle()}),a(document).on("click.bs.toggle","div[data-toggle^=toggle]",function(t){a(this).find("input[type=checkbox]").bootstrapToggle("toggle"),t.preventDefault()})}(jQuery);
//# sourceMappingURL=bootstrap4-toggle.min.js.map

;(function() {/*

   ----
   tiff.js: https://github.com/seikichi/tiff.js

   Copyright (C) 2013 seikichi[at]kmc.gr.jp

   This software is provided 'as-is', without any express or implied
   warranty. In no event will the authors be held liable for any damages
   arising from the use of this software.

   Permission is granted to anyone to use this software for any purpose,
   including commercial applications, and to alter it and redistribute it
   freely, subject to the following restrictions:

   1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.

   2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

   3. This notice may not be removed or altered from any source
   distribution.
   ----
   zlib: http://www.zlib.net/

   Copyright (C) 1995-2013 Jean-loup Gailly and Mark Adler

   This software is provided 'as-is', without any express or implied
   warranty.  In no event will the authors be held liable for any damages
   arising from the use of this software.

   Permission is granted to anyone to use this software for any purpose,
   including commercial applications, and to alter it and redistribute it
   freely, subject to the following restrictions:

   1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
   2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
   3. This notice may not be removed or altered from any source distribution.

   Jean-loup Gailly        Mark Adler
   jloup@gzip.org          madler@alumni.caltech.edu


   The data format used by the zlib library is described by RFCs (Request for
   Comments) 1950 to 1952 in the files http://tools.ietf.org/html/rfc1950
   (zlib format), rfc1951 (deflate format) and rfc1952 (gzip format).
   ----
   LibTIFF: http://www.remotesensing.org/libtiff/

   Copyright (c) 1988-1997 Sam Leffler
   Copyright (c) 1991-1997 Silicon Graphics, Inc.

   Permission to use, copy, modify, distribute, and sell this software and 
   its documentation for any purpose is hereby granted without fee, provided
   that (i) the above copyright notices and this permission notice appear in
   all copies of the software and related documentation, and (ii) the names of
   Sam Leffler and Silicon Graphics may not be used in any advertising or
   publicity relating to the software without the specific, prior written
   permission of Sam Leffler and Silicon Graphics.

   THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
   EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
   WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  

   IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
   ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
   OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
   WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
   LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
   OF THIS SOFTWARE.
*/
var loadModule=function(Lb){function nc(r){eval.call(null,r)}function fb(r,v){r||Vc("Assertion failed: "+v)}function me(r){var v=F["_"+r];if(!v)try{v=eval("_"+r)}catch(A){}fb(v,"Cannot call unknown function "+r+" (perhaps LLVM optimizations or closure removed it?)");return v}function If(r,v,A,fa){A=A||"i8";"*"===A.charAt(A.length-1)&&(A="i32");switch(A){case "i1":Dd[r>>0]=v;break;case "i8":Dd[r>>0]=v;break;case "i16":gf[r>>1]=v;break;case "i32":Sb[r>>2]=v;break;case "i64":kg=[v>>>0,(Re=v,1<=+Fg(Re)?
0<Re?(dj(+Lh(Re/4294967296),4294967295)|0)>>>0:~~+ej((Re-+(~~Re>>>0))/4294967296)>>>0:0)];Sb[r>>2]=kg[0];Sb[r+4>>2]=kg[1];break;case "float":mf[r>>2]=v;break;case "double":tf[r>>3]=v;break;default:Vc("invalid type for setValue: "+A)}}function dg(r,v,A){v=v||"i8";"*"===v.charAt(v.length-1)&&(v="i32");switch(v){case "i1":return Dd[r>>0];case "i8":return Dd[r>>0];case "i16":return gf[r>>1];case "i32":return Sb[r>>2];case "i64":return Sb[r>>2];case "float":return mf[r>>2];case "double":return tf[r>>3];
default:Vc("invalid type for setValue: "+v)}return null}function vc(r,v,A,fa){var D,F;"number"===typeof r?(D=!0,F=r):(D=!1,F=r.length);var ya="string"===typeof v?v:null;A=4==A?fa:[uf,ra.stackAlloc,ra.staticAlloc,ra.dynamicAlloc][void 0===A?2:A](Math.max(F,ya?1:v.length));if(D){fa=A;fb(0==(A&3));for(r=A+(F&-4);fa<r;fa+=4)Sb[fa>>2]=0;for(r=A+F;fa<r;)Dd[fa++>>0]=0;return A}if("i8"===ya)return r.subarray||r.slice?Od.set(r,A):Od.set(new Uint8Array(r),A),A;fa=0;for(var S,ca;fa<F;){var Xd=r[fa];"function"===
typeof Xd&&(Xd=ra.getFunctionIndex(Xd));D=ya||v[fa];0===D?fa++:("i64"==D&&(D="i32"),If(A+fa,Xd,D),ca!==D&&(S=ra.getNativeTypeSize(D),ca=D),fa+=S)}return A}function Yd(r,v){if(0===v||!r)return"";for(var A=0,fa,D=0;;){fa=Od[r+D>>0];A|=fa;if(0==fa&&!v)break;D++;if(v&&D==v)break}v||(v=D);fa="";if(128>A){for(;0<v;)A=String.fromCharCode.apply(String,Od.subarray(r,r+Math.min(v,1024))),fa=fa?fa+A:A,r+=1024,v-=1024;return fa}return F.UTF8ToString(r)}function nf(r,v){for(var A,fa,D,F,ya,S,ca="";;){A=r[v++];
if(!A)return ca;A&128?(fa=r[v++]&63,192==(A&224)?ca+=String.fromCharCode((A&31)<<6|fa):(D=r[v++]&63,224==(A&240)?A=(A&15)<<12|fa<<6|D:(F=r[v++]&63,240==(A&248)?A=(A&7)<<18|fa<<12|D<<6|F:(ya=r[v++]&63,248==(A&252)?A=(A&3)<<24|fa<<18|D<<12|F<<6|ya:(S=r[v++]&63,A=(A&1)<<30|fa<<24|D<<18|F<<12|ya<<6|S))),65536>A?ca+=String.fromCharCode(A):(A-=65536,ca+=String.fromCharCode(55296|A>>10,56320|A&1023)))):ca+=String.fromCharCode(A)}}function Ug(r,v,A,fa){if(!(0<fa))return 0;var D=A;fa=A+fa-1;for(var F=0;F<
r.length;++F){var ya=r.charCodeAt(F);55296<=ya&&57343>=ya&&(ya=65536+((ya&1023)<<10)|r.charCodeAt(++F)&1023);if(127>=ya){if(A>=fa)break;v[A++]=ya}else{if(2047>=ya){if(A+1>=fa)break;v[A++]=192|ya>>6}else{if(65535>=ya){if(A+2>=fa)break;v[A++]=224|ya>>12}else{if(2097151>=ya){if(A+3>=fa)break;v[A++]=240|ya>>18}else{if(67108863>=ya){if(A+4>=fa)break;v[A++]=248|ya>>24}else{if(A+5>=fa)break;v[A++]=252|ya>>30;v[A++]=128|ya>>24&63}v[A++]=128|ya>>18&63}v[A++]=128|ya>>12&63}v[A++]=128|ya>>6&63}v[A++]=128|ya&
63}}v[A]=0;return A-D}function lg(r){for(var v=0,A=0;A<r.length;++A){var fa=r.charCodeAt(A);55296<=fa&&57343>=fa&&(fa=65536+((fa&1023)<<10)|r.charCodeAt(++A)&1023);127>=fa?++v:v=2047>=fa?v+2:65535>=fa?v+3:2097151>=fa?v+4:67108863>=fa?v+5:v+6}return v}function fj(r){function v(A,fa,D){fa=fa||Infinity;var F="",yc=[],aa;if("N"===r[ya]){ya++;"K"===r[ya]&&ya++;for(aa=[];"E"!==r[ya];)if("S"===r[ya]){ya++;var S=r.indexOf("_",ya),ra=r.substring(ya,S)||0;aa.push(Hk[ra]||"?");ya=S+1}else if("C"===r[ya])aa.push(aa[aa.length-
1]),ya+=2;else{S=parseInt(r.substr(ya));ra=S.toString().length;if(!S||!ra){ya--;break}var Ka=r.substr(ya+ra,S);aa.push(Ka);Hk.push(Ka);ya+=ra+S}ya++;aa=aa.join("::");fa--;if(0===fa)return A?[aa]:aa}else if(("K"===r[ya]||Xd&&"L"===r[ya])&&ya++,S=parseInt(r.substr(ya)))ra=S.toString().length,aa=r.substr(ya+ra,S),ya+=ra+S;Xd=!1;"I"===r[ya]?(ya++,S=v(!0),ra=v(!0,1,!0),F+=ra[0]+" "+aa+"<"+S.join(", ")+">"):F=aa;a:for(;ya<r.length&&0<fa--;)if(aa=r[ya++],aa in ca)yc.push(ca[aa]);else switch(aa){case "P":yc.push(v(!0,
1,!0)[0]+"*");break;case "R":yc.push(v(!0,1,!0)[0]+"&");break;case "L":ya++;S=r.indexOf("E",ya)-ya;yc.push(r.substr(ya,S));ya+=S+2;break;case "A":S=parseInt(r.substr(ya));ya+=S.toString().length;if("_"!==r[ya])throw"?";ya++;yc.push(v(!0,1,!0)[0]+" ["+S+"]");break;case "E":break a;default:F+="?"+aa;break a}D||1!==yc.length||"void"!==yc[0]||(yc=[]);return A?(F&&yc.push(F+"?"),yc):F+("("+yc.join(", ")+")")}var A=!!F.___cxa_demangle;if(A)try{var fa=uf(r.length);Ji(r.substr(1),fa);var D=uf(4),aa=F.___cxa_demangle(fa,
0,0,D);if(0===dg(D,"i32")&&aa)return Yd(aa)}catch(S){}finally{fa&&vf(fa),D&&vf(D),aa&&vf(aa)}var ya=3,ca={v:"void",b:"bool",c:"char",s:"short",i:"int",l:"long",f:"float",d:"double",w:"wchar_t",a:"signed char",h:"unsigned char",t:"unsigned short",j:"unsigned int",m:"unsigned long",x:"long long",y:"unsigned long long",z:"..."},Hk=[],Xd=!0,fa=r;try{if("Object._main"==r||"_main"==r)return"main()";"number"===typeof r&&(r=Yd(r));if("_"!==r[0]||"_"!==r[1]||"Z"!==r[2])return r;switch(r[3]){case "n":return"operator new()";
case "d":return"operator delete()"}fa=v()}catch(S){fa+="?"}0<=fa.indexOf("?")&&!A&&ra.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling");return fa}function gj(r){return r.replace(/__Z[\w\d_]+/g,function(r){var A=fj(r);return r===A?r:r+" ["+A+"]"})}function wf(){var r=gj,v;a:{v=Error();if(!v.stack){try{throw Error(0);}catch(A){v=A}if(!v.stack){v="(no stack trace available)";break a}}v=v.stack.toString()}return r(v)}
function Gg(r){0<r%4096&&(r+=4096-r%4096);return r}function Cj(){var r=Math.pow(2,31);if(we>=r)return!1;for(;ld<=we;)if(ld<r/2)ld=Gg(2*ld);else{var v=ld;ld=Gg((3*ld+r)/4);if(ld<=v)return!1}ld=Math.max(ld,16777216);if(ld>=r)return!1;try{if(ArrayBuffer.transfer)rd=ArrayBuffer.transfer(rd,ld);else{var A=Dd;rd=new ArrayBuffer(ld)}}catch(fa){return!1}if(!Dj(rd))return!1;F.buffer=rd;F.HEAP8=Dd=new Int8Array(rd);F.HEAP16=gf=new Int16Array(rd);F.HEAP32=Sb=new Int32Array(rd);F.HEAPU8=Od=new Uint8Array(rd);
F.HEAPU16=Vg=new Uint16Array(rd);F.HEAPU32=xf=new Uint32Array(rd);F.HEAPF32=mf=new Float32Array(rd);F.HEAPF64=tf=new Float64Array(rd);ArrayBuffer.transfer||Dd.set(A);return!0}function mg(r){for(;0<r.length;){var v=r.shift();if("function"==typeof v)v();else{var A=v.func;"number"===typeof A?void 0===v.arg?ra.dynCall("v",A):ra.dynCall("vi",A,[v.arg]):A(void 0===v.arg?null:v.arg)}}}function Mh(r){Jf.unshift(r)}function Hg(r){Wg.unshift(r)}function yf(r,v,A){A=0<A?A:lg(r)+1;A=Array(A);r=Ug(r,A,0,A.length);
v&&(A.length=r);return A}function Ji(r,v,A){r=yf(r,A);for(A=0;A<r.length;)Dd[v+A>>0]=r[A],A+=1}function Xg(r,v){for(var A=0;A<r.length;A++)Dd[v++>>0]=r[A]}function zf(r,v,A){for(var fa=0;fa<r.length;++fa)Dd[v++>>0]=r.charCodeAt(fa);A||(Dd[v>>0]=0)}function Yg(r){Uf++;F.monitorRunDependencies&&F.monitorRunDependencies(Uf)}function ng(r){Uf--;F.monitorRunDependencies&&F.monitorRunDependencies(Uf);0==Uf&&(null!==Nh&&(clearInterval(Nh),Nh=null),Vf&&(r=Vf,Vf=null,r()))}function eg(r){F.___errno_location&&
(Sb[F.___errno_location()>>2]=r);return r}function hj(r,v){S.mainLoop.timingMode=r;S.mainLoop.timingValue=v;if(!S.mainLoop.func)return 1;if(0==r)S.mainLoop.scheduler=function(){setTimeout(S.mainLoop.runner,v)},S.mainLoop.method="timeout";else if(1==r)S.mainLoop.scheduler=function(){S.requestAnimationFrame(S.mainLoop.runner)},S.mainLoop.method="rAF";else if(2==r){if(!window.setImmediate){var A=[];window.addEventListener("message",function(r){r.source===window&&"__emcc"===r.data&&(r.stopPropagation(),
A.shift()())},!0);window.setImmediate=function(r){A.push(r);window.postMessage("__emcc","*")}}S.mainLoop.scheduler=function(){window.setImmediate(S.mainLoop.runner)};S.mainLoop.method="immediate"}return 0}function Oh(r,v,A,fa,D){F.noExitRuntime=!0;fb(!S.mainLoop.func,"emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.");S.mainLoop.func=r;S.mainLoop.arg=fa;var aa=
S.mainLoop.currentlyRunningMainloop;S.mainLoop.runner=function(){if(!xe)if(0<S.mainLoop.queue.length){var v=Date.now(),A=S.mainLoop.queue.shift();A.func(A.arg);if(S.mainLoop.remainingBlockers){var D=S.mainLoop.remainingBlockers,yc=0==D%1?D-1:Math.floor(D);S.mainLoop.remainingBlockers=A.counted?yc:(8*D+(yc+.5))/9}console.log('main loop blocker "'+A.name+'" took '+(Date.now()-v)+" ms");S.mainLoop.updateStatus();setTimeout(S.mainLoop.runner,0)}else aa<S.mainLoop.currentlyRunningMainloop||(S.mainLoop.currentFrameNumber=
S.mainLoop.currentFrameNumber+1|0,1==S.mainLoop.timingMode&&1<S.mainLoop.timingValue&&0!=S.mainLoop.currentFrameNumber%S.mainLoop.timingValue?S.mainLoop.scheduler():("timeout"===S.mainLoop.method&&F.ctx&&(F.printErr("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!"),S.mainLoop.method=""),S.mainLoop.runIter(function(){"undefined"!==
typeof fa?ra.dynCall("vi",r,[fa]):ra.dynCall("v",r)}),aa<S.mainLoop.currentlyRunningMainloop||("object"===typeof SDL&&SDL.audio&&SDL.audio.queueNewAudioData&&SDL.audio.queueNewAudioData(),S.mainLoop.scheduler())))};D||(v&&0<v?hj(0,1E3/v):hj(1,1),S.mainLoop.scheduler());if(A)throw"SimulateInfiniteLoop";}function Ph(){throw"bad";}function Qh(r){F.exit(r)}function Zg(r,v){ab.setThrew(r,v||1);throw"longjmp";}function ni(r,v){re.push(function(){ra.dynCall("vi",r,[v])});ni.level=re.length}function Af(r){var v,
A;Af.called?(A=Sb[Rh>>2],v=Sb[A>>2]):(Af.called=!0,Td.USER=Td.LOGNAME="web_user",Td.PATH="/",Td.PWD="/",Td.HOME="/home/web_user",Td.LANG="C",Td._=F.thisProgram,v=vc(1024,"i8",2),A=vc(256,"i8*",2),Sb[A>>2]=v,Sb[Rh>>2]=A);var fa=[],D=0,aa;for(aa in r)if("string"===typeof r[aa]){var ya=aa+"="+r[aa];fa.push(ya);D+=ya.length}if(1024<D)throw Error("Environment size exceeded TOTAL_ENV_SIZE!");for(r=0;r<fa.length;r++)ya=fa[r],zf(ya,v),Sb[A+4*r>>2]=v,v+=ya.length+1;Sb[A+4*fa.length>>2]=0}function Ig(r){if(0===
r)return 0;r=Yd(r);if(!Td.hasOwnProperty(r))return 0;Ig.ret&&vf(Ig.ret);Ig.ret=vc(yf(Td[r]),"i8",0);return Ig.ret}function og(r){var v=og;v.called||(we=Gg(we),v.called=!0,fb(ra.dynamicAlloc),v.alloc=ra.dynamicAlloc,ra.dynamicAlloc=function(){Vc("cannot dynamically allocate, sbrk now has control")});var A=we;return 0==r||v.alloc(r)?A:4294967295}function of(r){this.name="ExitStatus";this.message="Program terminated with exit("+r+")";this.status=r}function $g(r){function v(){if(!F.calledRun&&(F.calledRun=
!0,!xe)){pg||(pg=!0,mg(qg));mg(rg);if(F.onRuntimeInitialized)F.onRuntimeInitialized();F._main&&Sh&&F.callMain(r);if(F.postRun)for("function"==typeof F.postRun&&(F.postRun=[F.postRun]);F.postRun.length;)Hg(F.postRun.shift());mg(Wg)}}r=r||F.arguments;null===Th&&(Th=Date.now());if(!(0<Uf)){if(F.preRun)for("function"==typeof F.preRun&&(F.preRun=[F.preRun]);F.preRun.length;)Mh(F.preRun.shift());mg(Jf);0<Uf||F.calledRun||(F.setStatus?(F.setStatus("Running..."),setTimeout(function(){setTimeout(function(){F.setStatus("")},
1);v()},1)):v())}}function Jg(r,v){if(!v||!F.noExitRuntime){if(!F.noExitRuntime&&(xe=!0,se=Ej,mg(re),F.onExit))F.onExit(r);Bf?(process.stdout.once("drain",function(){process.exit(r)}),console.log(" "),setTimeout(function(){process.exit(r)},500)):ah&&"function"===typeof quit&&quit(r);throw new of(r);}}function Vc(r){void 0!==r?(F.print(r),F.printErr(r),r=JSON.stringify(r)):r="";xe=!0;var v="abort("+r+") at "+wf()+"\nIf this abort() is unexpected, build with -s ASSERTIONS=1 which can give more information.";
bh&&bh.forEach(function(A){v=A(v,r)});throw v;}var F={};"TOTAL_MEMORY"in Lb&&(F.TOTAL_MEMORY=Lb.TOTAL_MEMORY);F||(F=("undefined"!==typeof F?F:null)||{});var sg={},Kf;for(Kf in F)F.hasOwnProperty(Kf)&&(sg[Kf]=F[Kf]);var Uh="object"===typeof window,fg="function"===typeof importScripts,Bf="object"===typeof process&&"function"===typeof require&&!Uh&&!fg,ah=!Uh&&!Bf&&!fg;if(Bf){F.print||(F.print=function(r){process.stdout.write(r+"\n")});F.printErr||(F.printErr=function(r){process.stderr.write(r+"\n")});
var Vh=require("fs"),Wh=require("path");F.read=function(r,v){r=Wh.normalize(r);var A=Vh.readFileSync(r);A||r==Wh.resolve(r)||(r=path.join(__dirname,"..","src",r),A=Vh.readFileSync(r));A&&!v&&(A=A.toString());return A};F.readBinary=function(r){r=F.read(r,!0);r.buffer||(r=new Uint8Array(r));fb(r.buffer);return r};F.load=function(r){nc(read(r))};F.thisProgram||(F.thisProgram=1<process.argv.length?process.argv[1].replace(/\\/g,"/"):"unknown-program");F.arguments=process.argv.slice(2);"undefined"!==typeof module&&
(module.exports=F);process.on("uncaughtException",function(r){if(!(r instanceof of))throw r;});F.inspect=function(){return"[Emscripten Module object]"}}else if(ah)F.print||(F.print=print),"undefined"!=typeof printErr&&(F.printErr=printErr),F.read="undefined"!=typeof read?read:function(){throw"no read() available (jsc?)";},F.readBinary=function(r){if("function"===typeof readbuffer)return new Uint8Array(readbuffer(r));r=read(r,"binary");fb("object"===typeof r);return r},"undefined"!=typeof scriptArgs?
F.arguments=scriptArgs:"undefined"!=typeof arguments&&(F.arguments=arguments);else if(Uh||fg)F.read=function(r){var v=new XMLHttpRequest;v.open("GET",r,!1);v.send(null);return v.responseText},"undefined"!=typeof arguments&&(F.arguments=arguments),"undefined"!==typeof console?(F.print||(F.print=function(r){console.log(r)}),F.printErr||(F.printErr=function(r){console.log(r)})):F.print||(F.print=function(r){}),fg&&(F.load=importScripts),"undefined"===typeof F.setWindowTitle&&(F.setWindowTitle=function(r){document.title=
r});else throw"Unknown runtime environment. Where are we?";!F.load&&F.read&&(F.load=function(r){nc(F.read(r))});F.print||(F.print=function(){});F.printErr||(F.printErr=F.print);F.arguments||(F.arguments=[]);F.thisProgram||(F.thisProgram="./this.program");F.print=F.print;F.printErr=F.printErr;F.preRun=[];F.postRun=[];for(Kf in sg)sg.hasOwnProperty(Kf)&&(F[Kf]=sg[Kf]);var ra={setTempRet0:function(r){oi=r},getTempRet0:function(){return oi},stackSave:function(){return se},stackRestore:function(r){se=
r},getNativeTypeSize:function(r){switch(r){case "i1":case "i8":return 1;case "i16":return 2;case "i32":return 4;case "i64":return 8;case "float":return 4;case "double":return 8;default:return"*"===r[r.length-1]?ra.QUANTUM_SIZE:"i"===r[0]?(r=parseInt(r.substr(1)),fb(0===r%8),r/8):0}},getNativeFieldSize:function(r){return Math.max(ra.getNativeTypeSize(r),ra.QUANTUM_SIZE)},STACK_ALIGN:16,prepVararg:function(r,v){"double"===v||"i64"===v?r&7&&(fb(4===(r&7)),r+=4):fb(0===(r&3));return r},getAlignSize:function(r,
v,A){return A||"i64"!=r&&"double"!=r?r?Math.min(v||(r?ra.getNativeFieldSize(r):0),ra.QUANTUM_SIZE):Math.min(v,8):8},dynCall:function(r,v,A){return A&&A.length?(A.splice||(A=Array.prototype.slice.call(A)),A.splice(0,0,v),F["dynCall_"+r].apply(null,A)):F["dynCall_"+r].call(null,v)},functionPointers:[],addFunction:function(r){for(var v=0;v<ra.functionPointers.length;v++)if(!ra.functionPointers[v])return ra.functionPointers[v]=r,2*(1+v);throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.";
},removeFunction:function(r){ra.functionPointers[(r-2)/2]=null},warnOnce:function(r){ra.warnOnce.shown||(ra.warnOnce.shown={});ra.warnOnce.shown[r]||(ra.warnOnce.shown[r]=1,F.printErr(r))},funcWrappers:{},getFuncWrapper:function(r,v){fb(v);ra.funcWrappers[v]||(ra.funcWrappers[v]={});var A=ra.funcWrappers[v];A[r]||(A[r]=function(){return ra.dynCall(v,r,arguments)});return A[r]},getCompilerSetting:function(r){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work";
},stackAlloc:function(r){var v=se;se=se+r|0;se=se+15&-16;return v},staticAlloc:function(r){var v=Se;Se=Se+r|0;Se=Se+15&-16;return v},dynamicAlloc:function(r){var v=we;we=we+r|0;we=we+15&-16;return we>=ld&&!Cj()?(we=v,0):v},alignMemory:function(r,v){return Math.ceil(r/(v?v:16))*(v?v:16)},makeBigInt:function(r,v,A){return A?+(r>>>0)+4294967296*+(v>>>0):+(r>>>0)+4294967296*+(v|0)},GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};F.Runtime=ra;var xe=!1,Re,kg,oi,Xh,Yh;(function(){function r(r){r=r.toString().match(fa).slice(1);
return{arguments:r[0],body:r[1],returnValue:r[2]}}var v={stackSave:function(){ra.stackSave()},stackRestore:function(){ra.stackRestore()},arrayToC:function(r){var v=ra.stackAlloc(r.length);Xg(r,v);return v},stringToC:function(r){var v=0;null!==r&&void 0!==r&&0!==r&&(v=ra.stackAlloc((r.length<<2)+1),Ji(r,v));return v}},A={string:v.stringToC,array:v.arrayToC};Yh=function(r,v,D,fa,F){r=me(r);var yc=[],Y=0;if(fa)for(var aa=0;aa<fa.length;aa++){var S=A[D[aa]];S?(0===Y&&(Y=ra.stackSave()),yc[aa]=S(fa[aa])):
yc[aa]=fa[aa]}D=r.apply(null,yc);"string"===v&&(D=Yd(D));if(0!==Y){if(F&&F.async){EmterpreterAsync.asyncFinalizers.push(function(){ra.stackRestore(Y)});return}ra.stackRestore(Y)}return D};var fa=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/,D={},F;for(F in v)v.hasOwnProperty(F)&&(D[F]=r(v[F]));Xh=function(v,A,fa){fa=fa||[];var F=me(v);v=fa.every(function(r){return"number"===r});var aa="string"!==A;if(aa&&v)return F;var S=fa.map(function(r,v){return"$"+v});A="(function("+
S.join(",")+") {";var Y=fa.length;if(!v){A+="var stack = "+D.stackSave.body+";";for(var ca=0;ca<Y;ca++){var ra=S[ca],Ka=fa[ca];"number"!==Ka&&(Ka=D[Ka+"ToC"],A+="var "+Ka.arguments+" = "+ra+";",A+=Ka.body+";",A+=ra+"="+Ka.returnValue+";")}}fa=r(function(){return F}).returnValue;A+="var ret = "+fa+"("+S.join(",")+");";aa||(fa=r(function(){return Yd}).returnValue,A+="ret = "+fa+"(ret);");v||(A+=D.stackRestore.body.replace("()","(stack)")+";");return eval(A+"return ret})")}})();F.ccall=Yh;F.cwrap=Xh;
F.setValue=If;F.getValue=dg;F.ALLOC_NORMAL=0;F.ALLOC_STACK=1;F.ALLOC_STATIC=2;F.ALLOC_DYNAMIC=3;F.ALLOC_NONE=4;F.allocate=vc;F.getMemory=function(r){return pi?"undefined"!==typeof og&&!og.called||!pg?ra.dynamicAlloc(r):uf(r):ra.staticAlloc(r)};F.Pointer_stringify=Yd;F.AsciiToString=function(r){for(var v="";;){var A=Dd[r++>>0];if(!A)return v;v+=String.fromCharCode(A)}};F.stringToAscii=function(r,v){return zf(r,v,!1)};F.UTF8ArrayToString=nf;F.UTF8ToString=function(r){return nf(Od,r)};F.stringToUTF8Array=
Ug;F.stringToUTF8=function(r,v,A){return Ug(r,Od,v,A)};F.lengthBytesUTF8=lg;F.UTF16ToString=function(r){for(var v=0,A="";;){var fa=gf[r+2*v>>1];if(0==fa)return A;++v;A+=String.fromCharCode(fa)}};F.stringToUTF16=function(r,v,A){void 0===A&&(A=2147483647);if(2>A)return 0;A-=2;var fa=v;A=A<2*r.length?A/2:r.length;for(var D=0;D<A;++D){var F=r.charCodeAt(D);gf[v>>1]=F;v+=2}gf[v>>1]=0;return v-fa};F.lengthBytesUTF16=function(r){return 2*r.length};F.UTF32ToString=function(r){for(var v=0,A="";;){var fa=Sb[r+
4*v>>2];if(0==fa)return A;++v;65536<=fa?(fa-=65536,A+=String.fromCharCode(55296|fa>>10,56320|fa&1023)):A+=String.fromCharCode(fa)}};F.stringToUTF32=function(r,v,A){void 0===A&&(A=2147483647);if(4>A)return 0;var fa=v;A=fa+A-4;for(var D=0;D<r.length;++D){var F=r.charCodeAt(D);if(55296<=F&&57343>=F)var ya=r.charCodeAt(++D),F=65536+((F&1023)<<10)|ya&1023;Sb[v>>2]=F;v+=4;if(v+4>A)break}Sb[v>>2]=0;return v-fa};F.lengthBytesUTF32=function(r){for(var v=0,A=0;A<r.length;++A){var D=r.charCodeAt(A);55296<=D&&
57343>=D&&++A;v+=4}return v};F.stackTrace=wf;var Dd,Od,gf,Vg,Sb,xf,mf,tf,Ki=0,Se=0,pi=!1,Zh=0,se=0,vh=0,ch=0,we=0,Kg;try{Kg=Function.prototype.call.bind(Object.getOwnPropertyDescriptor(ArrayBuffer.prototype,"byteLength").get),Kg(new ArrayBuffer(4))}catch(r){Kg=function(r){return r.byteLength}}for(var $h=F.TOTAL_STACK||5242880,ld=F.TOTAL_MEMORY||16777216,Pc=65536;Pc<ld||Pc<2*$h;)Pc=16777216>Pc?2*Pc:Pc+16777216;Pc=Math.max(Pc,16777216);Pc!==ld&&(ld=Pc);fb("undefined"!==typeof Int32Array&&"undefined"!==
typeof Float64Array&&!!(new Int32Array(1)).subarray&&!!(new Int32Array(1)).set,"JS engine does not provide full typed array support");var rd;rd=new ArrayBuffer(ld);Dd=new Int8Array(rd);gf=new Int16Array(rd);Sb=new Int32Array(rd);Od=new Uint8Array(rd);Vg=new Uint16Array(rd);xf=new Uint32Array(rd);mf=new Float32Array(rd);tf=new Float64Array(rd);Sb[0]=255;fb(255===Od[0]&&0===Od[3],"Typed arrays 2 must be run on a little-endian system");F.HEAP=void 0;F.buffer=rd;F.HEAP8=Dd;F.HEAP16=gf;F.HEAP32=Sb;F.HEAPU8=
Od;F.HEAPU16=Vg;F.HEAPU32=xf;F.HEAPF32=mf;F.HEAPF64=tf;var Jf=[],qg=[],rg=[],re=[],Wg=[],pg=!1;F.addOnPreRun=Mh;F.addOnInit=function(r){qg.unshift(r)};F.addOnPreMain=function(r){rg.unshift(r)};F.addOnExit=function(r){re.unshift(r)};F.addOnPostRun=Hg;F.intArrayFromString=yf;F.intArrayToString=function(r){for(var v=[],A=0;A<r.length;A++){var D=r[A];255<D&&(D&=255);v.push(String.fromCharCode(D))}return v.join("")};F.writeStringToMemory=Ji;F.writeArrayToMemory=Xg;F.writeAsciiToMemory=zf;Math.imul&&-5===
Math.imul(4294967295,5)||(Math.imul=function(r,v){var A=r&65535,D=v&65535;return A*D+((r>>>16)*D+A*(v>>>16)<<16)|0});Math.imul=Math.imul;Math.clz32||(Math.clz32=function(r){r>>>=0;for(var v=0;32>v;v++)if(r&1<<31-v)return v;return 32});Math.clz32=Math.clz32;var Fg=Math.abs,Fj=Math.atan2,Gj=Math.exp,Hj=Math.log,Ij=Math.sqrt,ej=Math.ceil,Lh=Math.floor,Jj=Math.pow,dj=Math.min,Uf=0,Nh=null,Vf=null;F.addRunDependency=Yg;F.removeRunDependency=ng;F.preloadedImages={};F.preloadedAudios={};Ki=8;Se=Ki+164992;
qg.push();vc([0,0,0,0,0,0,240,63,239,97,72,177,80,49,246,63,202,111,77,145,174,231,244,63,170,17,108,239,98,208,242,63,0,0,0,0,0,0,240,63,59,191,167,192,105,36,233,63,187,32,199,123,122,81,225,63,93,171,114,222,85,168,209,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,0,0,0,84,8,0,0,1,0,0,0,0,0,0,0,56,0,0,0,116,0,0,0,154,130,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,82,251,1,0,0,0,0,0,157,130,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,95,251,1,0,0,0,0,0,34,136,0,0,1,0,1,0,3,
0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,103,251,1,0,0,0,0,0,36,136,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,119,251,1,0,0,0,0,0,39,136,0,0,255,255,255,255,3,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,65,0,1,1,139,251,1,0,0,0,0,0,40,136,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,155,251,1,0,0,0,0,0,0,144,0,0,4,0,4,0,7,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,1,0,184,251,1,0,0,0,0,0,3,144,0,0,20,0,20,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,196,251,1,0,0,0,0,0,4,144,0,0,20,0,
20,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,213,251,1,0,0,0,0,0,1,145,0,0,4,0,4,0,7,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,1,0,231,251,1,0,0,0,0,0,2,145,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,255,251,1,0,0,0,0,0,1,146,0,0,1,0,1,0,10,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,22,252,1,0,0,0,0,0,2,146,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,40,252,1,0,0,0,0,0,3,146,0,0,1,0,1,0,10,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,54,252,1,0,0,0,0,0,4,146,0,0,1,0,1,0,10,0,0,0,0,0,0,0,11,
0,0,0,0,0,0,0,65,0,1,0,70,252,1,0,0,0,0,0,5,146,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,88,252,1,0,0,0,0,0,6,146,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,105,252,1,0,0,0,0,0,7,146,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,121,252,1,0,0,0,0,0,8,146,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,134,252,1,0,0,0,0,0,9,146,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,146,252,1,0,0,0,0,0,10,146,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,152,
252,1,0,0,0,0,0,20,146,0,0,255,255,255,255,3,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,65,0,1,1,164,252,1,0,0,0,0,0,124,146,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,176,252,1,0,0,0,0,0,134,146,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,186,252,1,0,0,0,0,0,144,146,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,198,252,1,0,0,0,0,0,145,146,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,209,252,1,0,0,0,0,0,146,146,0,0,255,255,255,255,2,0,0,0,0,
0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,228,252,1,0,0,0,0,0,0,160,0,0,4,0,4,0,7,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,1,0,248,252,1,0,0,0,0,0,1,160,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,8,253,1,0,0,0,0,0,2,160,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,1,0,19,253,1,0,0,0,0,0,3,160,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,1,0,35,253,1,0,0,0,0,0,4,160,0,0,13,0,13,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,51,253,1,0,0,0,0,0,11,162,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,
1,0,68,253,1,0,0,0,0,0,12,162,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,80,253,1,0,0,0,0,0,14,162,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,105,253,1,0,0,0,0,0,15,162,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,127,253,1,0,0,0,0,0,16,162,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,149,253,1,0,0,0,0,0,20,162,0,0,2,0,2,0,3,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,65,0,1,0,174,253,1,0,0,0,0,0,21,162,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,190,253,
1,0,0,0,0,0,23,162,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,204,253,1,0,0,0,0,0,0,163,0,0,1,0,1,0,7,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,65,0,1,0,218,253,1,0,0,0,0,0,1,163,0,0,1,0,1,0,7,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,65,0,1,0,229,253,1,0,0,0,0,0,2,163,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,239,253,1,0,0,0,0,0,1,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,250,253,1,0,0,0,0,0,2,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,9,254,1,0,0,0,0,0,3,164,0,
0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,22,254,1,0,0,0,0,0,4,164,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,35,254,1,0,0,0,0,0,5,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,52,254,1,0,0,0,0,0,6,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,74,254,1,0,0,0,0,0,7,164,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,1,0,91,254,1,0,0,0,0,0,8,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,103,254,1,0,0,0,0,0,9,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,
0,0,0,0,0,0,65,0,1,0,112,254,1,0,0,0,0,0,10,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,123,254,1,0,0,0,0,0,11,164,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,133,254,1,0,0,0,0,0,12,164,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,158,254,1,0,0,0,0,0,32,164,0,0,33,0,33,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,179,254,1,0,0,0,0,0,254,0,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,5,0,1,0,193,254,1,0,0,0,0,0,255,0,0,0,1,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,
0,1,0,205,254,1,0,0,0,0,0,0,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,1,0,0,0,220,254,1,0,0,0,0,0,1,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,1,0,1,0,211,8,2,0,0,0,0,0,2,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,6,0,0,0,231,254,1,0,0,0,0,0,3,1,0,0,255,255,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,7,0,0,0,99,20,2,0,0,0,0,0,6,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,8,0,0,0,245,254,1,0,0,0,0,0,7,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,9,0,1,0,15,255,1,0,0,0,0,0,8,1,0,0,1,0,
1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,29,255,1,0,0,0,0,0,9,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,39,255,1,0,0,0,0,0,10,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,10,0,0,0,50,255,1,0,0,0,0,0,13,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,60,255,1,0,0,0,0,0,14,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,73,255,1,0,0,0,0,0,15,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,90,255,1,0,0,0,0,0,16,1,0,0,255,255,255,255,2,0,0,
0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,95,255,1,0,0,0,0,0,17,1,0,0,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,24,9,2,0,0,0,0,0,18,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,15,0,0,0,101,255,1,0,0,0,0,0,21,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,16,0,0,0,113,255,1,0,0,0,0,0,22,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,17,0,0,0,129,255,1,0,0,0,0,0,23,1,0,0,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,191,10,2,0,0,0,0,0,24,1,0,0,254,255,255,255,3,0,0,0,0,0,0,0,4,
0,0,0,0,0,0,0,18,0,1,0,142,255,1,0,0,0,0,0,25,1,0,0,254,255,255,255,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,19,0,1,0,157,255,1,0,0,0,0,0,26,1,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,3,0,1,0,172,255,1,0,0,0,0,0,27,1,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,3,0,1,0,184,255,1,0,0,0,0,0,28,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,20,0,0,0,196,255,1,0,0,0,0,0,29,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,216,255,1,0,0,0,0,0,30,1,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,4,
0,1,0,225,255,1,0,0,0,0,0,31,1,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,4,0,1,0,235,255,1,0,0,0,0,0,32,1,0,0,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,255,1,0,0,0,0,0,33,1,0,0,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,0,0,0,0,34,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,16,0,2,0,0,0,0,0,35,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,33,0,2,0,0,0,0,0,40,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,22,0,1,0,51,0,2,0,0,0,0,
0,41,1,0,0,2,0,2,0,3,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,23,0,1,0,66,0,2,0,0,0,0,0,44,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,77,0,2,0,0,0,0,0,45,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,51,0,0,0,0,0,0,0,44,0,1,0,95,0,2,0,0,0,0,0,49,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,112,0,2,0,0,0,0,0,50,1,0,0,20,0,20,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,121,0,2,0,0,0,0,0,59,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,130,0,2,0,0,0,0,0,60,1,0,0,255,255,255,
255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,137,0,2,0,0,0,0,0,62,1,0,0,2,0,2,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,1,0,150,0,2,0,0,0,0,0,63,1,0,0,6,0,6,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,1,0,161,0,2,0,0,0,0,0,64,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,51,0,0,0,0,0,0,0,26,0,1,0,183,0,2,0,0,0,0,0,65,1,0,0,2,0,2,0,3,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,37,0,1,0,192,0,2,0,0,0,0,0,66,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,2,0,0,0,206,0,2,0,0,0,0,0,67,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,
0,2,0,0,0,216,0,2,0,0,0,0,0,68,1,0,0,255,255,1,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,12,9,2,0,0,0,0,0,69,1,0,0,255,255,1,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,227,0,2,0,0,0,0,0,74,1,0,0,255,255,255,255,18,0,0,0,0,0,0,0,38,0,0,0,0,0,0,0,49,0,1,1,242,0,2,0,84,0,0,0,76,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,59,20,2,0,0,0,0,0,77,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,27,0,0,0,0,0,0,0,46,0,1,1,249,0,2,0,0,0,0,0,78,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,1,0,2,1,2,
0,0,0,0,0,80,1,0,0,2,0,2,0,3,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,65,0,0,0,15,1,2,0,0,0,0,0,81,1,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,24,1,2,0,0,0,0,0,82,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,31,0,0,1,38,1,2,0,0,0,0,0,83,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,32,0,0,0,51,1,2,0,0,0,0,0,84,1,0,0,254,255,255,255,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,33,0,1,0,64,1,2,0,0,0,0,0,85,1,0,0,254,255,255,255,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,34,0,1,0,80,1,2,0,0,0,0,
0,87,1,0,0,255,255,253,255,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,1,96,1,2,0,0,0,0,0,88,1,0,0,1,0,1,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,105,1,2,0,0,0,0,0,88,1,0,0,1,0,1,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,105,1,2,0,0,0,0,0,89,1,0,0,1,0,1,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,120,1,2,0,0,0,0,0,17,2,0,0,3,0,3,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,135,1,2,0,0,0,0,0,18,2,0,0,2,0,2,0,3,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,39,0,0,0,153,1,2,0,0,0,0,0,19,2,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,
0,0,0,0,0,0,0,40,0,0,0,170,1,2,0,0,0,0,0,20,2,0,0,6,0,6,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,41,0,1,0,187,1,2,0,0,0,0,0,188,2,0,0,253,255,253,255,1,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,65,0,0,1,207,1,2,0,0,0,0,0,227,128,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,31,0,0,0,217,1,2,0,0,0,0,0,228,128,0,0,254,255,255,255,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,32,0,0,0,226,1,2,0,0,0,0,0,229,128,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,35,0,0,0,235,1,2,0,0,0,0,0,230,128,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,
36,0,0,0,246,1,2,0,0,0,0,0,20,130,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,1,0,0,2,2,0,0,0,0,0,21,130,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,1,0,15,2,2,0,0,0,0,0,22,130,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,31,2,2,0,0,0,0,0,23,130,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,45,2,2,0,0,0,0,0,24,130,0,0,1,0,1,0,11,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,65,0,1,0,62,2,2,0,0,0,0,0,25,130,0,0,16,0,16,0,11,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,1,0,83,2,2,0,
0,0,0,0,26,130,0,0,16,0,16,0,11,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,1,0,103,2,2,0,0,0,0,0,141,130,0,0,2,0,2,0,3,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,65,0,0,0,123,2,2,0,0,0,0,0,142,130,0,0,4,0,4,0,1,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,0,0,239,253,1,0,0,0,0,0,152,130,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,143,2,2,0,0,0,0,0,187,131,0,0,253,255,253,255,4,0,0,0,0,0,0,0,44,0,0,0,0,0,0,0,65,0,0,1,153,2,2,0,0,0,0,0,73,134,0,0,253,255,253,255,1,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,65,0,0,1,166,2,
2,0,0,0,0,0,105,135,0,0,1,0,1,0,18,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,65,0,0,0,176,2,2,0,100,0,0,0,115,135,0,0,253,255,253,255,7,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,65,0,0,1,190,2,2,0,0,0,0,0,37,136,0,0,1,0,1,0,18,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,65,0,0,0,202,2,2,0,0,0,0,0,92,136,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,65,0,1,0,215,2,2,0,0,0,0,0,93,136,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,65,0,1,0,229,2,2,0,0,0,0,0,94,136,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,65,0,1,0,243,2,2,0,0,0,
0,0,95,136,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,65,0,1,0,255,2,2,0,0,0,0,0,63,146,0,0,1,0,1,0,12,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,6,3,2,0,0,0,0,0,5,160,0,0,1,0,1,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,14,3,2,0,0,0,0,0,18,198,0,0,4,0,4,0,1,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,0,0,40,3,2,0,0,0,0,0,19,198,0,0,4,0,4,0,1,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,0,0,51,3,2,0,0,0,0,0,20,198,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,70,3,2,0,0,0,0,0,21,198,0,0,255,
255,255,255,1,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,88,3,2,0,0,0,0,0,22,198,0,0,255,255,255,255,1,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,0,1,109,3,2,0,0,0,0,0,23,198,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,123,3,2,0,0,0,0,0,24,198,0,0,255,255,255,255,3,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,65,0,0,1,133,3,2,0,0,0,0,0,25,198,0,0,2,0,2,0,3,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,65,0,0,0,152,3,2,0,0,0,0,0,26,198,0,0,255,255,255,255,5,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,172,3,2,0,0,0,0,0,27,198,0,0,255,
255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,183,3,2,0,0,0,0,0,28,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,200,3,2,0,0,0,0,0,29,198,0,0,255,255,255,255,4,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,65,0,0,1,217,3,2,0,0,0,0,0,30,198,0,0,2,0,2,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,228,3,2,0,0,0,0,0,92,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,241,3,2,0,0,0,0,0,31,198,0,0,2,0,2,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,2,4,2,0,0,0,0,0,32,198,0,0,2,0,2,0,
5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,20,4,2,0,0,0,0,0,33,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,36,4,2,0,0,0,0,0,34,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,49,4,2,0,0,0,0,0,35,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,62,4,2,0,0,0,0,0,36,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,81,4,2,0,0,0,0,0,37,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,100,4,2,0,0,0,0,0,38,198,
0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,117,4,2,0,0,0,0,0,39,198,0,0,255,255,255,255,5,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,134,4,2,0,0,0,0,0,40,198,0,0,255,255,255,255,5,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,148,4,2,0,0,0,0,0,41,198,0,0,2,0,2,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,162,4,2,0,0,0,0,0,42,198,0,0,1,0,1,0,10,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,176,4,2,0,0,0,0,0,43,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,193,4,2,0,0,0,0,0,44,198,0,
0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,207,4,2,0,0,0,0,0,45,198,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,0,0,225,4,2,0,0,0,0,0,46,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,241,4,2,0,0,0,0,0,47,198,0,0,255,255,255,255,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,65,0,1,0,5,5,2,0,0,0,0,0,48,198,0,0,4,0,4,0,5,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,65,0,0,0,24,5,2,0,0,0,0,0,49,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,33,5,2,0,0,0,0,0,50,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,
11,0,0,0,0,0,0,0,65,0,0,0,50,5,2,0,0,0,0,0,51,198,0,0,1,0,1,0,5,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,65,0,0,0,68,5,2,0,0,0,0,0,52,198,0,0,255,255,255,255,1,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,0,1,80,5,2,0,0,0,0,0,53,198,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,95,5,2,0,0,0,0,0,90,198,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,111,5,2,0,0,0,0,0,91,198,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,134,5,2,0,0,0,0,0,93,198,0,0,16,0,16,0,1,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,0,
0,157,5,2,0,0,0,0,0,139,198,0,0,255,255,255,255,1,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,1,1,173,5,2,0,0,0,0,0,140,198,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,0,1,193,5,2,0,0,0,0,0,141,198,0,0,4,0,4,0,4,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,65,0,0,0,213,5,2,0,0,0,0,0,142,198,0,0,255,255,255,255,4,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,65,0,0,1,224,5,2,0,0,0,0,0,143,198,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,0,1,236,5,2,0,0,0,0,0,144,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,
0,0,0,0,0,0,65,0,0,1,253,5,2,0,0,0,0,0,145,198,0,0,255,255,255,255,7,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,65,0,0,1,20,6,2,0,0,0,0,0,146,198,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,38,6,2,0,0,0,0,0,27,0,1,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,62,6,2,0,0,0,0,0,90,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,65,0,0,0,72,6,2,0,0,0,0,0,144,1,0,0,1,0,1,0,18,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,65,0,0,0,80,6,2,0,0,0,0,0,145,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,0,0,100,
6,2,0,0,0,0,0,146,1,0,0,1,0,1,0,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,65,0,0,0,112,6,2,0,0,0,0,0,147,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,0,0,123,6,2,0,0,0,0,0,148,1,0,0,4,0,4,0,1,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,65,0,0,0,137,6,2,0,0,0,0,0,149,1,0,0,1,0,1,0,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,65,0,0,0,149,6,2,0,0,0,0,0,177,1,0,0,255,255,255,255,10,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,65,0,0,1,160,6,2,0,0,0,0,0,178,1,0,0,255,255,255,255,3,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,65,0,0,1,167,6,2,0,0,0,0,0,179,1,
0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,65,0,0,0,182,6,2,0,0,0,0,0,47,2,0,0,255,255,255,255,4,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,65,0,0,1,193,6,2,0,0,0,0,0,172,135,0,0,2,0,2,0,4,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,65,0,0,0,208,6,2,0,0,0,0,0,0,0,0,0,139,108,79,64,134,201,196,191,128,72,255,190,126,29,120,191,197,32,240,63,195,100,42,61,211,188,99,61,96,229,80,190,199,75,135,63,0,0,200,66,0,0,200,66,0,0,200,66,255,0,0,0,255,0,0,0,255,0,0,0,0,0,128,63,0,0,128,63,0,0,128,63,154,153,25,64,154,153,25,64,154,
153,25,64,0,0,0,0,1,0,0,0,2,0,0,0,135,22,153,62,162,69,22,63,213,120,233,61,0,0,0,0,0,0,0,0,0,0,0,0,101,44,2,0,1,0,0,0,1,0,0,0,106,44,2,0,5,0,0,0,2,0,0,0,110,44,2,0,5,128,0,0,3,0,0,0,119,44,2,0,41,128,0,0,4,0,0,0,131,44,2,0,254,127,0,0,5,0,0,0,136,44,2,0,7,0,0,0,6,0,0,0,141,44,2,0,6,0,0,0,7,0,0,0,156,44,2,0,2,0,0,0,8,0,0,0,166,44,2,0,3,128,0,0,9,0,0,0,178,44,2,0,3,0,0,0,10,0,0,0,192,44,2,0,4,0,0,0,11,0,0,0,206,44,2,0,101,135,0,0,12,0,0,0,215,44,2,0,178,128,0,0,13,0,0,0,223,44,2,0,8,0,0,0,13,0,0,0,
236,44,2,0,141,128,0,0,14,0,0,0,245,44,2,0,116,135,0,0,15,0,0,0,252,44,2,0,117,135,0,0,15,0,0,0,5,45,2,0,109,136,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,73,0,0,0,3,50,2,0,0,0,0,0,37,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,73,0,0,0,245,49,2,0,0,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,7,0,0,0,15,0,0,0,31,0,0,0,63,0,0,0,127,0,0,0,255,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,168,52,2,0,0,0,0,0,4,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,51,0,0,0,0,0,
0,0,0,0,0,0,176,52,2,0,0,0,0,0,70,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,66,0,1,0,188,52,2,0,0,0,0,0,71,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,67,0,1,0,200,52,2,0,0,0,0,0,72,1,0,0,1,0,1,0,4,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,68,0,1,0,213,52,2,0,0,0,0,0,12,7,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,
0,3,1,0,0,0,0,0,0,5,6,0,0,2,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,5,7,0,0,3,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,
0,0,1,0,0,0,3,1,0,0,0,0,0,0,4,6,0,0,2,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,6,7,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,
0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,5,6,0,0,2,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,4,7,0,0,3,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,
3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,4,6,0,0,2,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,1,4,0,0,0,0,0,0,3,1,0,0,0,0,0,0,5,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,2,3,0,0,0,0,0,0,3,1,0,0,0,0,0,0,4,3,0,0,1,0,0,0,3,1,0,0,0,0,0,0,12,11,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,
0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,
0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,
7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,
9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17],"i8",4,ra.GLOBAL_BASE);vc([9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,0,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,
0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,
7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,
0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,
4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,
0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,
0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,
6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,
0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,
0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,64,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,
0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,
7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,
7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,
7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,
0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,
0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,
0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,
0,9,9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,64,8,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,
7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,
5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,
30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,
0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,
0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,
9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,
0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,
6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,
0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,64,9,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,
0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,
9,0,0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,
8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,
4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,
0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,
0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,
0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,
0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,192,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,
7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,
4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,
3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,
0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,
0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,
7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,
0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,
31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17],"i8",4,ra.GLOBAL_BASE+
10240);vc([9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,128,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,
0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,
0,0,0,9,9,0,0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,
0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,
0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,
0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,
8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,
0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,
0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,192,8,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,
0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,
11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,
0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,
0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,
7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,
0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,
0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,
0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,
9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,192,9,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,
8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,
0,192,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,
0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,
0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,12,11,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,
28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,
0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,
0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,
0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,0,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,
5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,
0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,
0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,
0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,
0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,
5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,
192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,
0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,
7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,64,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,
6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,0,
0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,
3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,
7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,
0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,
0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,
7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,
0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17],"i8",4,ra.GLOBAL_BASE+20480);vc([9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,128,8,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,
0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,
0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,
4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,
0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,
0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,
0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,
9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,
8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,
0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,128,9,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,
40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,
6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,
0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,
0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,
7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,
0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,
0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,0,7,4,0,0,
6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,0,8,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,
0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,
0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,
0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,
0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,
2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,
0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,
9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,
0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,
0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,11,0,0,128,7,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,
0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,0,0,5,0,0,
0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,
7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,
7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,
0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,
0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,5,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,192,4,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,
49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,192,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,192,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,
0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,0,9,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,
0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,
7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,64,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,64,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,
0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,64,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,
3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,
0,0,0,0,0,0,0,0,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,39,0,0,0,7,6,0,0,16,0,0,0,9,8,0,0,64,2,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,55,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,
0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,45,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,53,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,192,1,0,0,7,4,0,0,6,0,0,0,7,8,0,0,35,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,51,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,63,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,0,6,0,0,7,4,0,0,5,0,0,0,7,8,0,0,43,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,0,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,
7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,29,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,33,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,49,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,61,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,47,0,0,0,7,4,0,0,3,0,0,0,7,8,0,0,59,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,41,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,0,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,31,0,0,0,7,5,0,0,8,0,0,0,7,8,
0,0,57,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,9,0,0,0,3,0,0,7,4,0,0,6,0,0,0,7,8,0,0,37,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,64,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17],"i8",4,ra.GLOBAL_BASE+30720);vc([9,7,0,0,0,1,0,
0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,11,12,0,0,0,10,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,7,0,0,20,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,24,0,0,0,7,6,0,0,14,0,0,0,7,7,0,0,28,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,23,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,27,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,40,0,0,0,
7,6,0,0,16,0,0,0,9,9,0,0,128,3,0,0,7,4,0,0,6,0,0,0,7,7,0,0,19,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,56,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,46,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,54,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,0,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,36,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,52,0,0,0,7,6,0,0,15,0,0,0,7,8,0,0,0,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,9,9,0,0,192,6,0,0,7,4,
0,0,5,0,0,0,7,8,0,0,44,0,0,0,7,6,0,0,17,0,0,0,9,9,0,0,128,5,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,30,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,6,0,0,12,0,0,0,7,5,0,0,9,0,0,0,9,6,0,0,128,6,0,0,7,4,0,0,6,0,0,0,7,8,0,0,34,0,0,0,9,5,0,0,128,0,0,0,7,8,0,0,50,0,0,0,7,6,0,0,14,0,0,0,7,8,0,0,62,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,8,0,0,48,0,0,0,7,4,0,
0,3,0,0,0,7,8,0,0,60,0,0,0,7,4,0,0,5,0,0,0,7,8,0,0,42,0,0,0,7,6,0,0,16,0,0,0,9,9,0,0,128,4,0,0,7,4,0,0,6,0,0,0,7,8,0,0,32,0,0,0,7,5,0,0,8,0,0,0,7,8,0,0,58,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,7,7,0,0,22,0,0,0,7,4,0,0,3,0,0,0,7,5,0,0,11,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,26,0,0,0,7,5,0,0,9,0,0,0,9,8,0,0,128,2,0,0,7,4,0,0,6,0,0,0,7,8,0,0,38,0,0,0,9,5,0,0,128,0,0,0,7,7,0,0,25,0,0,0,7,6,0,0,15,0,0,0,9,8,0,0,128,1,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,
0,7,0,0,0,7,6,0,0,13,0,0,0,7,4,0,0,3,0,0,0,7,7,0,0,18,0,0,0,7,4,0,0,5,0,0,0,7,7,0,0,21,0,0,0,7,6,0,0,17,0,0,0,9,7,0,0,0,1,0,0,7,4,0,0,6,0,0,0,7,6,0,0,1,0,0,0,7,5,0,0,8,0,0,0,9,6,0,0,192,0,0,0,9,5,0,0,64,0,0,0,7,5,0,0,10,0,0,0,7,4,0,0,4,0,0,0,7,4,0,0,2,0,0,0,7,4,0,0,7,0,0,0,12,11,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,
3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,
0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,
5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,
0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,0,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,
0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,23,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,
0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,20,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,25,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,
8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,
0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,
2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,
0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,128,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,56,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,30,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,
0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,64,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,
8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,57,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,
2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,21,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,54,0,0,0,8,2,0,0,3,0,0,0,8,3,
0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,
3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,
0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,
8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,
0,0,2,0,0,0,8,12,0,0,52,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,
0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,48,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,
3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,64,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,
0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,44,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,36,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,
0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,128,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,
0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,
8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,
0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,28,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,
0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,60,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,
2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,40,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,
0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,64,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,
0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,
8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,
0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,
1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,
0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,
7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",4,ra.GLOBAL_BASE+40960);vc([8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,192,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,
0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,50,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,
5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,34,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,128,6,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,
2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,
0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,
8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,
0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,26,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,128,5,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,
0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,32,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,
0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,128,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,
0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,61,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,
3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,42,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,0,4,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,
0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,
0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,
2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,
0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,0,3,0,0,8,2,0,0,
3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,62,
0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,
0,11,12,0,0,192,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,
0,8,2,0,0,2,0,0,0,8,12,0,0,46,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,38,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,
8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,0,2,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,
2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,
0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,
0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,19,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,
0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,24,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,
0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,22,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,
8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,192,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,
8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,
2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,
0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,
3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,12,11,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,
0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,
0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,
8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,
3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,0,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,
0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,23,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,
0,20,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,25,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,
2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,
0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,
8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,
0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,192,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,0,5,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,
0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,31,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,
0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",4,ra.GLOBAL_BASE+51200);vc([8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,64,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,
0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,58,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,
0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,21,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,128,3,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,
0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,
3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,
0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,
0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,128,2,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,
0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,49,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,
0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,128,8,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,45,0,0,
0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,37,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,
12,0,0,192,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,
0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,
4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,29,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,
0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,0,6,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,
8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,41,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,
2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,128,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,
3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,
0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,
0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,
0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,
0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,
3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,
0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,
0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,0,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,
2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,51,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,35,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,
0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,64,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,
8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,
0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,
0,0,0,8,12,0,0,27,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,59,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,
0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,33,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,
0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,128,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,
0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,0,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,
8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,43,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,128,4,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,
8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,
0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,
3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,
0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,55,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,
0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,63,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,
8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",4,ra.GLOBAL_BASE+61440);vc([8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,0,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,
0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,47,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,
2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,39,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,53,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,
0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,
0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,
2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,
0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,19,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,
2,0,0,0,8,11,0,0,24,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,
0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,22,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,0,10,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,
0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,
8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,
2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,
0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,12,11,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,
3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,
0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,
0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,
8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,0,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,
3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,23,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,20,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,
0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,25,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,
0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,
0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,
0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,128,0,0,0,8,2,0,0,3,0,0,
0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,56,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,
8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,30,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,
0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,64,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,
0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,57,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,
4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,21,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,54,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,
0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,
0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,
4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,
0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,52,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,
1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,48,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,
0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,64,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,
0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,44,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,
0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,36,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,128,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,
0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,
3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,
0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,
0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,28,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,60,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,
0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,40,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,
0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",4,ra.GLOBAL_BASE+71680);vc([8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,
0,0,64,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,
2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,
0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,
8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,
0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,
2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,
0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,192,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,
0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,50,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,34,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,
0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,192,6,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,
0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,
3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,
0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,26,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,
6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,192,5,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,
2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,32,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,
0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,128,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,
0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,61,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,42,0,
0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,64,4,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,
0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,
2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,
0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,
0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,64,3,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,
0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,62,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,
0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,192,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,
0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,46,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,
8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,38,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,64,2,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,
8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,
0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,
2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,
0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,19,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,24,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,
0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,22,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,
8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,192,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,
8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,
2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,
0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,
3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,12,11,0,0,0,
0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,
0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,
2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,
0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",4,ra.GLOBAL_BASE+81920);vc([8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,
0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,0,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,
0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,23,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,20,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,
0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,25,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,
8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,
0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,
2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,192,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,
4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,64,5,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,
0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,31,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,
0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,64,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,
0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,58,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,21,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,
8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,192,3,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,
8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,
0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,
0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,
0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,192,2,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,
0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,49,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,
8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,128,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,
8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,45,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,
4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,37,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,192,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,
2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,
0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,
0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,
0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,29,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,64,6,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,
0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,41,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,
8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,128,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,
8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,
2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,
0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,
2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,
0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,
8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,18,0,0,0,8,
2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,
0,17,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,
0,0,0,11,12,0,0,0,8,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,
0,0,8,2,0,0,2,0,0,0,8,12,0,0,51,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,35,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,
0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,64,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,
8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,
0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,
2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,27,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,
0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,59,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,33,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3],"i8",4,ra.GLOBAL_BASE+92160);vc([8,3,0,0,4,0,0,0,8,
2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,11,0,0,128,7,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,
3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,12,0,0,0,1,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,43,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,
0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,13,0,0,192,4,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,
0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,
2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,
0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,9,0,0,15,0,0,0,8,2,0,0,3,0,0,0,
8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,55,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,
2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,63,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,
0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,0,9,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,
2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,47,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,
0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,39,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,12,0,0,53,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,
8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,
0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,13,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,
2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,19,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,24,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,
0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,11,0,0,22,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,
0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,11,12,0,0,0,10,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,9,0,0,
0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,10,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,16,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,
8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,10,0,0,0,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,10,10,0,0,64,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,
2,0,0,2,0,0,0,8,6,0,0,9,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,11,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,8,0,0,14,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,
0,4,0,0,0,8,2,0,0,2,0,0,0,8,6,0,0,8,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,7,0,0,12,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,6,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,8,5,0,0,7,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,1,0,0,0,8,2,0,0,2,0,0,0,8,4,0,0,5,0,0,0,8,2,0,0,3,0,0,0,8,3,0,0,4,0,0,0,8,2,0,0,2,0,0,0,91,1,0,0,253,255,253,255,7,0,0,0,0,0,0,0,40,0,0,0,40,0,0,0,66,0,0,1,140,60,2,0,0,0,0,0,1,0,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,1,0,39,96,2,0,0,0,0,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,39,96,2,0,0,0,0,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,39,96,2,0,0,0,0,0,95,155,125,62,4,0,0,0,52,161,121,62,6,0,4,0,3,124,119,62,7,0,10,0,62,149,115,62,9,0,17,0,88,145,113,62,10,0,26,0,132,185,109,62,12,0,36,0,27,213,105,62,14,0,48,0,112,176,103,62,15,0,62,0,57,181,99,62,17,0,77,0,41,179,97,62,18,0,94,0,240,220,91,62,21,0,112,0,179,209,89,62,22,0,133,
0,63,199,87,62,23,0,155,0,59,229,81,62,26,0,178,0,144,219,79,62,27,0,204,0,226,6,76,62,29,0,231,0,181,55,72,62,31,0,4,1,152,52,70,62,32,0,35,1,97,111,66,62,34,0,67,1,104,175,62,62,36,0,101,1,104,175,62,62,36,0,137,1,102,249,58,62,38,0,173,1,144,76,55,62,40,0,211,1,92,173,51,62,42,0,251,1,8,33,48,62,44,0,37,2,8,33,48,62,44,0,81,2,160,168,44,62,46,0,125,2,160,168,44,62,46,0,171,2,52,128,39,62,49,0,217,2,12,115,34,62,52,0,10,3,12,115,34,62,52,0,62,3,12,115,34,62,52,0,114,3,174,129,29,62,55,0,166,3,174,
129,29,62,55,0,221,3,226,172,24,62,58,0,20,4,226,172,24,62,58,0,78,4,2,44,18,62,62,0,136,4,2,44,18,62,62,0,198,4,2,44,18,62,62,0,4,5,167,150,13,62,65,0,66,5,167,150,13,62,65,0,131,5,167,150,13,62,65,0,196,5,134,86,7,62,69,0,5,6,134,86,7,62,69,0,74,6,159,59,1,62,73,0,143,6,159,59,1,62,73,0,216,6,159,59,1,62,73,0,33,7,80,138,246,61,77,0,106,7,80,138,246,61,77,0,183,7,80,138,246,61,77,0,4,8,80,138,246,61,77,0,81,8,159,88,231,61,82,0,158,8,159,88,231,61,82,0,240,8,159,88,231,61,82,0,66,9,191,14,220,61,
86,0,148,9,191,14,220,61,86,0,234,9,191,14,220,61,86,0,64,10,191,14,220,61,86,0,150,10,161,128,205,61,91,0,236,10,161,128,205,61,91,0,71,11,161,128,205,61,91,0,162,11,108,209,194,61,95,0,253,11,108,209,194,61,95,0,92,12,108,209,194,61,95,0,187,12,108,209,194,61,95,0,26,13,12,202,180,61,100,0,121,13,12,202,180,61,100,0,221,13,12,202,180,61,100,0,65,14,12,202,180,61,100,0,165,14,136,245,166,61,105,0,9,15,136,245,166,61,105,0,114,15,136,245,166,61,105,0,219,15,136,245,166,61,105,0,68,16,185,80,153,61,
110,0,173,16,185,80,153,61,110,0,27,17,185,80,153,61,110,0,137,17,185,80,153,61,110,0,247,17,161,219,139,61,115,0,101,18,161,219,139,61,115,0,216,18,161,219,139,61,115,0,75,19,161,219,139,61,115,0,190,19,144,50,130,61,119,0,49,20,144,50,130,61,119,0,168,20,144,50,130,61,119,0,31,21,144,50,130,61,119,0,150,21,120,94,106,61,124,0,13,22,120,94,106,61,124,0,137,22,120,94,106,61,124,0,5,23,120,94,106,61,124,0,129,23,166,213,80,61,129,0,253,23,166,213,80,61,129,0,126,24,166,213,80,61,129,0,255,24,166,213,
80,61,129,0,128,25,166,213,80,61,129,0,1,26,18,190,55,61,134,0,130,26,18,190,55,61,134,0,8,27,18,190,55,61,134,0,142,27,18,190,55,61,134,0,20,28,199,45,38,61,138,0,154,28,199,45,38,61,138,0,36,29,199,45,38,61,138,0,174,29,199,45,38,61,138,0,56,30,52,216,20,61,142,0,194,30,52,216,20,61,142,0,80,31,52,216,20,61,142,0,222,31,52,216,20,61,142,0,108,32,47,164,3,61,146,0,250,32,47,164,3,61,146,0,140,33,47,164,3,61,146,0,30,34,47,164,3,61,146,0,176,34,27,241,228,60,150,0,66,35,27,241,228,60,150,0,216,35,
27,241,228,60,150,0,110,36,75,120,194,60,154,0,4,37,75,120,194,60,154,0,158,37,75,120,194,60,154,0,56,38,75,120,194,60,154,0,210,38,218,198,159,60,158,0,108,39,218,198,159,60,158,0,10,40,218,198,159,60,158,0,168,40,65,17,139,60,161,0,70,41,65,17,139,60,161,0,231,41,65,17,139,60,161,0,136,42,65,17,139,60,161,0,41,43,207,19,79,60,165,0,202,43,207,19,79,60,165,0,111,44,207,19,79,60,165,0,20,45,75,177,35,60,168,0,185,45,75,177,35,60,168,0,97,46,75,177,35,60,168,0,9,47,216,183,19,60,170,0,177,47,216,183,
19,60,170,0,91,48,216,183,19,60,170,0,5,49,250,183,203,59,173,0,175,49,250,183,203,59,173,0,92,50,188,4,167,59,175,0,9,51,188,4,167,59,175,0,184,51,188,4,167,59,175,0,103,52,18,23,128,59,177,0,22,53,18,23,128,59,177,0,199,53,175,90,25,59,177,0,120,54,197,144,28,59,170,0,41,55,34,252,139,58,164,0,211,55,122,169,216,58,157,0,119,56,14,245,59,58,150,0,20,57,218,140,211,58,143,0,170,57,201,142,141,57,136,0,57,58,97,193,253,57,129,0,193,58,138,146,144,58,123,0,66,59,155,202,162,58,115,0,189,59,170,182,
155,58,109,0,48,60,136,131,132,58,103,0,157,60,47,220,57,58,97,0,4,61,137,207,157,57,89,0,101,61,193,85,30,59,82,0,190,61,187,14,85,59,76,0,16,62,216,186,84,59,69,0,92,62,58,177,135,59,62,0,161,62,69,101,195,59,55,0,223,62,116,209,16,60,47,0,22,63,64,222,43,60,40,0,69,63,0,55,139,60,31,0,109,63,133,208,193,60,21,0,140,63,24,0,1,0,0,0,0,0,3,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,1,0,173,64,2,0,0,0,0,0,25,0,1,0,0,0,0,0,3,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,1,0,187,64,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,1,0,1,0,16,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,66,0,1,0,190,81,2,0,0,0,0,0,2,2,0,0,1,0,1,0,16,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,67,0,1,0,212,81,2,0,0,0,0,0,7,2,0,0,253,255,253,255,16,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,68,0,0,
1,240,81,2,0,0,0,0,0,8,2,0,0,253,255,253,255,16,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,69,0,0,1,252,81,2,0,0,0,0,0,9,2,0,0,253,255,253,255,16,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,70,0,0,1,9,82,2,0,0,0,0,0,0,2,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,71,0,0,0,22,82,2,0,0,0,0,0,3,2,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,72,0,0,0,31,82,2,0,0,0,0,0,13,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,39,96,2,0,0,0,0,0,22,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,39,96,2,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,61,1,0,0,1,0,1,0,3,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,66,0,0,0,166,88,2,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,253,255,255,255,254,255,255,255,255,255,255,255,21,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,1,0,39,96,2,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,4,0,4,0,8,0,4,0,17,0,0,0,4,0,5,0,16,0,8,0,17,0,0,0,4,0,6,0,32,0,32,0,17,0,0,0,4,0,4,0,16,0,16,0,18,0,0,0,8,0,16,0,32,0,32,0,18,0,0,0,8,0,16,0,128,0,128,0,18,0,0,0,8,0,32,0,128,0,0,
1,18,0,0,0,32,0,128,0,2,1,0,4,18,0,0,0,32,0,2,1,2,1,0,16,18,0,0,0,48,242,1,0,88,174,1,0,1,1,0,0,30,1,0,0,15,0,0,0,176,246,1,0,64,175,1,0,0,0,0,0,30,0,0,0,15,0,0,0,0,0,0,0,48,176,1,0,0,0,0,0,19,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,
0,8,0,0,0,10,0,0,0,12,0,0,0,14,0,0,0,16,0,0,0,20,0,0,0,24,0,0,0,28,0,0,0,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,80,0,0,0,96,0,0,0,112,0,0,0,128,0,0,0,160,0,0,0,192,0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,6,0,0,0,7,0,0,0,7,0,0,0,8,0,0,0,8,0,0,0,9,0,0,0,9,0,0,0,10,0,0,0,10,0,0,0,11,0,0,0,11,0,0,0,12,0,0,0,12,0,0,0,13,0,0,0,13,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,6,0,0,0,8,0,0,0,12,
0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,48,0,0,0,64,0,0,0,96,0,0,0,128,0,0,0,192,0,0,0,0,1,0,0,128,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,6,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,48,0,0,0,64,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,7,0,0,0,12,96,2,0,28,96,2,0,39,96,2,0,40,96,2,0,51,96,2,0,64,96,2,0,75,96,2,0,95,96,2,0,108,96,2,0,39,96,2,0,0,0,0,0,150,48,7,119,44,97,14,238,186,81,9,153,
25,196,109,7,143,244,106,112,53,165,99,233,163,149,100,158,50,136,219,14,164,184,220,121,30,233,213,224,136,217,210,151,43,76,182,9,189,124,177,126,7,45,184,231,145,29,191,144,100,16,183,29,242,32,176,106,72,113,185,243,222,65,190,132,125,212,218,26,235,228,221,109,81,181,212,244,199,133,211,131,86,152,108,19,192,168,107,100,122,249,98,253,236,201,101,138,79,92,1,20,217,108,6,99,99,61,15,250,245,13,8,141,200,32,110,59,94,16,105,76,228,65,96,213,114,113,103,162,209,228,3,60,71,212,4,75,253,133,13,
210,107,181,10,165,250,168,181,53,108,152,178,66,214,201,187,219,64,249,188,172,227,108,216,50,117,92,223,69,207,13,214,220,89,61,209,171,172,48,217,38,58,0,222,81,128,81,215,200,22,97,208,191,181,244,180,33,35,196,179,86,153,149,186,207,15,165,189,184,158,184,2,40,8,136,5,95,178,217,12,198,36,233,11,177,135,124,111,47,17,76,104,88,171,29,97,193,61,45,102,182,144,65,220,118,6,113,219,1,188,32,210,152,42,16,213,239,137,133,177,113,31,181,182,6,165,228,191,159,51,212,184,232,162,201,7,120,52,249,0,
15,142,168,9,150,24,152,14,225,187,13,106,127,45,61,109,8,151,108,100,145,1,92,99,230,244,81,107,107,98,97,108,28,216,48,101,133,78,0,98,242,237,149,6,108,123,165,1,27,193,244,8,130,87,196,15,245,198,217,176,101,80,233,183,18,234,184,190,139,124,136,185,252,223,29,221,98,73,45,218,21,243,124,211,140,101,76,212,251,88,97,178,77,206,81,181,58,116,0,188,163,226,48,187,212,65,165,223,74,215,149,216,61,109,196,209,164,251,244,214,211,106,233,105,67,252,217,110,52,70,136,103,173,208,184,96,218,115,45,4,
68,229,29,3,51,95,76,10,170,201,124,13,221,60,113,5,80,170,65,2,39,16,16,11,190,134,32,12,201,37,181,104,87,179,133,111,32,9,212,102,185,159,228,97,206,14,249,222,94,152,201,217,41,34,152,208,176,180,168,215,199,23,61,179,89,129,13,180,46,59,92,189,183,173,108,186,192,32,131,184,237,182,179,191,154,12,226,182,3,154,210,177,116,57,71,213,234,175,119,210,157,21,38,219,4,131,22,220,115,18,11,99,227,132,59,100,148,62,106,109,13,168,90,106,122,11,207,14,228,157,255,9,147,39,174,0,10,177,158,7,125,68,147,
15,240,210,163,8,135,104,242,1,30,254,194,6,105,93,87,98,247,203,103,101,128,113,54,108,25,231,6,107,110,118,27,212,254,224,43,211,137,90,122,218,16,204,74,221,103,111,223,185,249,249,239,190,142,67,190,183,23,213,142,176,96,232,163,214,214,126,147,209,161,196,194,216,56,82,242,223,79,241,103,187,209,103,87,188,166,221,6,181,63,75,54,178,72,218,43,13,216,76,27,10,175,246,74,3,54,96,122,4,65,195,239,96,223,85,223,103,168,239,142,110,49,121,190,105,70,140,179,97,203,26,131,102,188,160,210,111,37,54,
226,104,82,149,119,12,204,3,71,11,187,185,22,2,34,47,38,5,85,190,59,186,197,40,11,189,178,146,90,180,43,4,106,179,92,167,255,215,194,49,207,208,181,139,158,217,44,29,174,222,91,176,194,100,155,38,242,99,236,156,163,106,117,10,147,109,2,169,6,9,156,63,54,14,235,133,103,7,114,19,87,0,5,130,74,191,149,20,122,184,226,174,43,177,123,56,27,182,12,155,142,210,146,13,190,213,229,183,239,220,124,33,223,219,11,212,210,211,134,66,226,212,241,248,179,221,104,110,131,218,31,205,22,190,129,91,38,185,246,225,119,
176,111,119,71,183,24,230,90,8,136,112,106,15,255,202,59,6,102,92,11,1,17,255,158,101,143,105,174,98,248,211,255,107,97,69,207,108,22,120,226,10,160,238,210,13,215,84,131,4,78,194,179,3,57,97,38,103,167,247,22,96,208,77,71,105,73,219,119,110,62,74,106,209,174,220,90,214,217,102,11,223,64,240,59,216,55,83,174,188,169,197,158,187,222,127,207,178,71,233,255,181,48,28,242,189,189,138,194,186,202,48,147,179,83,166,163,180,36,5,54,208,186,147,6,215,205,41,87,222,84,191,103,217,35,46,122,102,179,184,74,
97,196,2,27,104,93,148,43,111,42,55,190,11,180,161,142,12,195,27,223,5,90,141,239,2,45,0,0,0,0,65,49,27,25,130,98,54,50,195,83,45,43,4,197,108,100,69,244,119,125,134,167,90,86,199,150,65,79,8,138,217,200,73,187,194,209,138,232,239,250,203,217,244,227,12,79,181,172,77,126,174,181,142,45,131,158,207,28,152,135,81,18,194,74,16,35,217,83,211,112,244,120,146,65,239,97,85,215,174,46,20,230,181,55,215,181,152,28,150,132,131,5,89,152,27,130,24,169,0,155,219,250,45,176,154,203,54,169,93,93,119,230,28,108,
108,255,223,63,65,212,158,14,90,205,162,36,132,149,227,21,159,140,32,70,178,167,97,119,169,190,166,225,232,241,231,208,243,232,36,131,222,195,101,178,197,218,170,174,93,93,235,159,70,68,40,204,107,111,105,253,112,118,174,107,49,57,239,90,42,32,44,9,7,11,109,56,28,18,243,54,70,223,178,7,93,198,113,84,112,237,48,101,107,244,247,243,42,187,182,194,49,162,117,145,28,137,52,160,7,144,251,188,159,23,186,141,132,14,121,222,169,37,56,239,178,60,255,121,243,115,190,72,232,106,125,27,197,65,60,42,222,88,5,
79,121,240,68,126,98,233,135,45,79,194,198,28,84,219,1,138,21,148,64,187,14,141,131,232,35,166,194,217,56,191,13,197,160,56,76,244,187,33,143,167,150,10,206,150,141,19,9,0,204,92,72,49,215,69,139,98,250,110,202,83,225,119,84,93,187,186,21,108,160,163,214,63,141,136,151,14,150,145,80,152,215,222,17,169,204,199,210,250,225,236,147,203,250,245,92,215,98,114,29,230,121,107,222,181,84,64,159,132,79,89,88,18,14,22,25,35,21,15,218,112,56,36,155,65,35,61,167,107,253,101,230,90,230,124,37,9,203,87,100,56,
208,78,163,174,145,1,226,159,138,24,33,204,167,51,96,253,188,42,175,225,36,173,238,208,63,180,45,131,18,159,108,178,9,134,171,36,72,201,234,21,83,208,41,70,126,251,104,119,101,226,246,121,63,47,183,72,36,54,116,27,9,29,53,42,18,4,242,188,83,75,179,141,72,82,112,222,101,121,49,239,126,96,254,243,230,231,191,194,253,254,124,145,208,213,61,160,203,204,250,54,138,131,187,7,145,154,120,84,188,177,57,101,167,168,75,152,131,59,10,169,152,34,201,250,181,9,136,203,174,16,79,93,239,95,14,108,244,70,205,63,
217,109,140,14,194,116,67,18,90,243,2,35,65,234,193,112,108,193,128,65,119,216,71,215,54,151,6,230,45,142,197,181,0,165,132,132,27,188,26,138,65,113,91,187,90,104,152,232,119,67,217,217,108,90,30,79,45,21,95,126,54,12,156,45,27,39,221,28,0,62,18,0,152,185,83,49,131,160,144,98,174,139,209,83,181,146,22,197,244,221,87,244,239,196,148,167,194,239,213,150,217,246,233,188,7,174,168,141,28,183,107,222,49,156,42,239,42,133,237,121,107,202,172,72,112,211,111,27,93,248,46,42,70,225,225,54,222,102,160,7,197,
127,99,84,232,84,34,101,243,77,229,243,178,2,164,194,169,27,103,145,132,48,38,160,159,41,184,174,197,228,249,159,222,253,58,204,243,214,123,253,232,207,188,107,169,128,253,90,178,153,62,9,159,178,127,56,132,171,176,36,28,44,241,21,7,53,50,70,42,30,115,119,49,7,180,225,112,72,245,208,107,81,54,131,70,122,119,178,93,99,78,215,250,203,15,230,225,210,204,181,204,249,141,132,215,224,74,18,150,175,11,35,141,182,200,112,160,157,137,65,187,132,70,93,35,3,7,108,56,26,196,63,21,49,133,14,14,40,66,152,79,103,
3,169,84,126,192,250,121,85,129,203,98,76,31,197,56,129,94,244,35,152,157,167,14,179,220,150,21,170,27,0,84,229,90,49,79,252,153,98,98,215,216,83,121,206,23,79,225,73],"i8",4,ra.GLOBAL_BASE+102400);vc([86,126,250,80,149,45,215,123,212,28,204,98,19,138,141,45,82,187,150,52,145,232,187,31,208,217,160,6,236,243,126,94,173,194,101,71,110,145,72,108,47,160,83,117,232,54,18,58,169,7,9,35,106,84,36,8,43,101,63,17,228,121,167,150,165,72,188,143,102,27,145,164,39,42,138,189,224,188,203,242,161,141,208,235,
98,222,253,192,35,239,230,217,189,225,188,20,252,208,167,13,63,131,138,38,126,178,145,63,185,36,208,112,248,21,203,105,59,70,230,66,122,119,253,91,181,107,101,220,244,90,126,197,55,9,83,238,118,56,72,247,177,174,9,184,240,159,18,161,51,204,63,138,114,253,36,147,0,0,0,0,55,106,194,1,110,212,132,3,89,190,70,2,220,168,9,7,235,194,203,6,178,124,141,4,133,22,79,5,184,81,19,14,143,59,209,15,214,133,151,13,225,239,85,12,100,249,26,9,83,147,216,8,10,45,158,10,61,71,92,11,112,163,38,28,71,201,228,29,30,119,
162,31,41,29,96,30,172,11,47,27,155,97,237,26,194,223,171,24,245,181,105,25,200,242,53,18,255,152,247,19,166,38,177,17,145,76,115,16,20,90,60,21,35,48,254,20,122,142,184,22,77,228,122,23,224,70,77,56,215,44,143,57,142,146,201,59,185,248,11,58,60,238,68,63,11,132,134,62,82,58,192,60,101,80,2,61,88,23,94,54,111,125,156,55,54,195,218,53,1,169,24,52,132,191,87,49,179,213,149,48,234,107,211,50,221,1,17,51,144,229,107,36,167,143,169,37,254,49,239,39,201,91,45,38,76,77,98,35,123,39,160,34,34,153,230,32,
21,243,36,33,40,180,120,42,31,222,186,43,70,96,252,41,113,10,62,40,244,28,113,45,195,118,179,44,154,200,245,46,173,162,55,47,192,141,154,112,247,231,88,113,174,89,30,115,153,51,220,114,28,37,147,119,43,79,81,118,114,241,23,116,69,155,213,117,120,220,137,126,79,182,75,127,22,8,13,125,33,98,207,124,164,116,128,121,147,30,66,120,202,160,4,122,253,202,198,123,176,46,188,108,135,68,126,109,222,250,56,111,233,144,250,110,108,134,181,107,91,236,119,106,2,82,49,104,53,56,243,105,8,127,175,98,63,21,109,99,
102,171,43,97,81,193,233,96,212,215,166,101,227,189,100,100,186,3,34,102,141,105,224,103,32,203,215,72,23,161,21,73,78,31,83,75,121,117,145,74,252,99,222,79,203,9,28,78,146,183,90,76,165,221,152,77,152,154,196,70,175,240,6,71,246,78,64,69,193,36,130,68,68,50,205,65,115,88,15,64,42,230,73,66,29,140,139,67,80,104,241,84,103,2,51,85,62,188,117,87,9,214,183,86,140,192,248,83,187,170,58,82,226,20,124,80,213,126,190,81,232,57,226,90,223,83,32,91,134,237,102,89,177,135,164,88,52,145,235,93,3,251,41,92,90,
69,111,94,109,47,173,95,128,27,53,225,183,113,247,224,238,207,177,226,217,165,115,227,92,179,60,230,107,217,254,231,50,103,184,229,5,13,122,228,56,74,38,239,15,32,228,238,86,158,162,236,97,244,96,237,228,226,47,232,211,136,237,233,138,54,171,235,189,92,105,234,240,184,19,253,199,210,209,252,158,108,151,254,169,6,85,255,44,16,26,250,27,122,216,251,66,196,158,249,117,174,92,248,72,233,0,243,127,131,194,242,38,61,132,240,17,87,70,241,148,65,9,244,163,43,203,245,250,149,141,247,205,255,79,246,96,93,120,
217,87,55,186,216,14,137,252,218,57,227,62,219,188,245,113,222,139,159,179,223,210,33,245,221,229,75,55,220,216,12,107,215,239,102,169,214,182,216,239,212,129,178,45,213,4,164,98,208,51,206,160,209,106,112,230,211,93,26,36,210,16,254,94,197,39,148,156,196,126,42,218,198,73,64,24,199,204,86,87,194,251,60,149,195,162,130,211,193,149,232,17,192,168,175,77,203,159,197,143,202,198,123,201,200,241,17,11,201,116,7,68,204,67,109,134,205,26,211,192,207,45,185,2,206,64,150,175,145,119,252,109,144,46,66,43,
146,25,40,233,147,156,62,166,150,171,84,100,151,242,234,34,149,197,128,224,148,248,199,188,159,207,173,126,158,150,19,56,156,161,121,250,157,36,111,181,152,19,5,119,153,74,187,49,155,125,209,243,154,48,53,137,141,7,95,75,140,94,225,13,142,105,139,207,143,236,157,128,138,219,247,66,139,130,73,4,137,181,35,198,136,136,100,154,131,191,14,88,130,230,176,30,128,209,218,220,129,84,204,147,132,99,166,81,133,58,24,23,135,13,114,213,134,160,208,226,169,151,186,32,168,206,4,102,170,249,110,164,171,124,120,
235,174,75,18,41,175,18,172,111,173,37,198,173,172,24,129,241,167,47,235,51,166,118,85,117,164,65,63,183,165,196,41,248,160,243,67,58,161,170,253,124,163,157,151,190,162,208,115,196,181,231,25,6,180,190,167,64,182,137,205,130,183,12,219,205,178,59,177,15,179,98,15,73,177,85,101,139,176,104,34,215,187,95,72,21,186,6,246,83,184,49,156,145,185,180,138,222,188,131,224,28,189,218,94,90,191,237,52,152,190,0,0,0,0,101,103,188,184,139,200,9,170,238,175,181,18,87,151,98,143,50,240,222,55,220,95,107,37,185,
56,215,157,239,40,180,197,138,79,8,125,100,224,189,111,1,135,1,215,184,191,214,74,221,216,106,242,51,119,223,224,86,16,99,88,159,87,25,80,250,48,165,232,20,159,16,250,113,248,172,66,200,192,123,223,173,167,199,103,67,8,114,117,38,111,206,205,112,127,173,149,21,24,17,45,251,183,164,63,158,208,24,135,39,232,207,26,66,143,115,162,172,32,198,176,201,71,122,8,62,175,50,160,91,200,142,24,181,103,59,10,208,0,135,178,105,56,80,47,12,95,236,151,226,240,89,133,135,151,229,61,209,135,134,101,180,224,58,221,
90,79,143,207,63,40,51,119,134,16,228,234,227,119,88,82,13,216,237,64,104,191,81,248,161,248,43,240,196,159,151,72,42,48,34,90,79,87,158,226,246,111,73,127,147,8,245,199,125,167,64,213,24,192,252,109,78,208,159,53,43,183,35,141,197,24,150,159,160,127,42,39,25,71,253,186,124,32,65,2,146,143,244,16,247,232,72,168,61,88,20,155,88,63,168,35,182,144,29,49,211,247,161,137,106,207,118,20,15,168,202,172,225,7,127,190,132,96,195,6,210,112,160,94,183,23,28,230,89,184,169,244,60,223,21,76,133,231,194,209,224,
128,126,105,14,47,203,123,107,72,119,195,162,15,13,203,199,104,177,115,41,199,4,97,76,160,184,217,245,152,111,68,144,255,211,252,126,80,102,238,27,55,218,86,77,39,185,14,40,64,5,182,198,239,176,164,163,136,12,28,26,176,219,129,127,215,103,57,145,120,210,43,244,31,110,147,3,247,38,59,102,144,154,131,136,63,47,145,237,88,147,41,84,96,68,180,49,7,248,12,223,168,77,30,186,207,241,166,236,223,146,254,137,184,46,70,103,23,155,84,2,112,39,236,187,72,240,113,222,47,76,201,48,128,249,219,85,231,69,99,156,
160,63,107,249,199,131,211,23,104,54,193,114,15,138,121,203,55,93,228,174,80,225,92,64,255,84,78,37,152,232,246,115,136,139,174,22,239,55,22,248,64,130,4,157,39,62,188,36,31,233,33,65,120,85,153,175,215,224,139,202,176,92,51,59,182,89,237,94,209,229,85,176,126,80,71,213,25,236,255,108,33,59,98,9,70,135,218,231,233,50,200,130,142,142,112,212,158,237,40,177,249,81,144,95,86,228,130,58,49,88,58,131,9,143,167,230,110,51,31,8,193,134,13,109,166,58,181,164,225,64,189,193,134,252,5,47,41,73,23,74,78,245,
175,243,118,34,50,150,17,158,138,120,190,43,152,29,217,151,32,75,201,244,120,46,174,72,192,192,1,253,210,165,102,65,106,28,94,150,247,121,57,42,79,151,150,159,93,242,241,35,229,5,25,107,77,96,126,215,245,142,209,98,231,235,182,222,95,82,142,9,194,55,233,181,122,217,70,0,104,188,33,188,208,234,49,223,136,143,86,99,48,97,249,214,34,4,158,106,154,189,166,189,7,216,193,1,191,54,110,180,173,83,9,8,21,154,78,114,29,255,41,206,165,17,134,123,183,116,225,199,15,205,217,16,146,168,190,172,42,70,17,25,56,35,
118,165,128,117,102,198,216,16,1,122,96,254,174,207,114,155,201,115,202,34,241,164,87,71,150,24,239,169,57,173,253,204,94,17,69,6,238,77,118,99,137,241,206,141,38,68,220,232,65,248,100,81,121,47,249,52,30,147,65,218,177,38,83,191,214,154,235,233,198,249,179,140,161,69,11,98,14,240,25,7,105,76,161,190,81,155,60,219,54,39,132,53,153,146,150,80,254,46,46,153,185,84,38,252,222,232,158,18,113,93,140,119,22,225,52,206,46,54,169,171,73,138,17,69,230,63,3,32,129,131,187,118,145,224,227,19,246,92,91,253,89,
233,73,152,62,85,241,33,6,130,108,68,97,62,212,170,206,139,198,207,169,55,126,56,65,127,214,93,38,195,110,179,137,118,124,214,238,202,196,111,214,29,89,10,177,161,225,228,30,20,243,129,121,168,75,215,105,203,19,178,14,119,171,92,161,194,185,57,198,126,1,128,254,169,156,229,153,21,36,11,54,160,54,110,81,28,142,167,22,102,134,194,113,218,62,44,222,111,44,73,185,211,148,240,129,4,9,149,230,184,177,123,73,13,163,30,46,177,27,72,62,210,67,45,89,110,251,195,246,219,233,166,145,103,81,31,169,176,204,122,
206,12,116,148,97,185,102,241,6,5,222,0,0,0,0,119,7,48,150,238,14,97,44,153,9,81,186,7,109,196,25,112,106,244,143,233,99,165,53,158,100,149,163,14,219,136,50,121,220,184,164,224,213,233,30,151,210,217,136,9,182,76,43,126,177,124,189,231,184,45,7,144,191,29,145,29,183,16,100,106,176,32,242,243,185,113,72,132,190,65,222,26,218,212,125,109,221,228,235,244,212,181,81,131,211,133,199,19,108,152,86,100,107,168,192,253,98,249,122,138,101,201,236,20,1,92,79,99,6,108,217,250,15,61,99,141,8,13,245,59,110,32,
200,76,105,16,94,213,96,65,228,162,103,113,114,60,3,228,209,75,4,212,71,210,13,133,253,165,10,181,107,53,181,168,250,66,178,152,108,219,187,201,214,172,188,249,64,50,216,108,227,69,223,92,117,220,214,13,207,171,209,61,89,38,217,48,172,81,222,0,58,200,215,81,128,191,208,97,22,33,180,244,181,86,179,196,35,207,186,149,153,184,189,165,15,40,2,184,158,95,5,136,8,198,12,217,178,177,11,233,36,47,111,124,135,88,104,76,17,193,97,29,171,182,102,45,61,118,220,65,144,1,219,113,6,152,210,32,188,239,213,16,42,
113,177,133,137,6,182,181,31,159,191,228,165,232,184,212,51,120,7,201,162,15,0,249,52,150,9,168,142,225,14,152,24,127,106,13,187,8,109,61,45,145,100,108,151,230,99,92,1,107,107,81,244,28,108,97,98,133,101,48,216,242,98,0,78,108,6,149,237,27,1,165,123,130,8,244,193,245,15,196,87,101,176,217,198,18,183,233,80,139,190,184,234,252,185,136,124,98,221,29,223,21,218,45,73,140,211,124,243,251,212,76,101,77,178,97,88,58,181,81,206,163,188,0,116,212,187,48,226,74,223,165,65,61,216,149,215,164,209,196,109,211,
214,244,251,67,105,233,106,52,110,217,252,173,103,136,70,218,96,184,208,68,4,45,115,51,3,29,229,170,10,76,95,221,13,124,201,80,5,113,60,39,2,65,170,190,11,16,16,201,12,32,134,87,104,181,37,32,111,133,179,185,102,212,9,206,97,228,159,94,222,249,14,41,217,201,152,176,208,152,34,199,215,168,180,89,179,61,23,46,180,13,129,183,189,92,59,192,186,108,173,237,184,131,32,154,191,179,182,3,182,226,12,116,177,210,154,234,213,71,57,157,210,119,175,4,219,38,21,115,220,22,131,227,99,11,18,148,100,59,132,13,109,
106,62,122,106,90,168,228,14,207,11,147,9,255,157,10,0,174,39,125,7,158,177,240,15,147,68,135,8,163,210,30,1,242,104,105,6,194,254,247,98,87,93,128,101,103,203,25,108,54,113,110,107,6,231,254,212,27,118,137,211,43,224,16,218,122,90,103,221,74,204,249,185,223,111,142,190,239,249,23,183,190,67,96,176,142,213,214,214,163,232,161,209,147,126,56,216,194,196,79,223,242,82,209,187,103,241,166,188,87,103,63,181,6,221,72,178,54,75,216,13,43,218,175,10,27,76,54,3,74,246,65,4,122,96,223,96,239,195,168,103,223,
85,49,110,142,239,70,105,190,121,203,97,179,140,188,102,131,26,37,111,210,160,82,104,226,54,204,12,119,149,187,11,71,3,34,2,22,185,85,5,38,47,197,186,59,190,178,189,11,40,43,180,90,146,92,179,106,4,194,215,255,167,181,208,207,49,44,217,158,139,91,222,174,29,155,100,194,176,236,99,242,38,117,106,163,156,2,109,147,10,156,9,6,169,235,14,54,63,114,7,103,133,5,0,87,19,149,191,74,130,226,184,122,20,123,177,43,174,12,182,27,56,146,210,142,155,229,213,190,13,124,220,239,183,11,219,223,33,134,211,210,212,
241,212,226,66,104,221,179,248,31,218,131,110,129,190,22,205,246,185,38,91,111,176,119,225,24,183,71,119,136,8,90,230,255,15,106,112,102,6,59,202,17,1,11,92,143,101,158,255,248,98,174,105,97,107,255,211,22,108,207,69,160,10,226,120,215,13,210,238,78,4,131,84,57,3,179,194,167,103,38,97,208,96,22,247,73,105,71,77,62,110,119,219,174,209,106,74,217,214,90,220,64,223,11,102,55,216,59,240,169,188,174,83,222,187,158,197,71,178,207,127,48,181,255,233,189,189,242,28,202,186,194,138,83,179,147,48,36,180,163,
166,186,208,54,5,205,215,6,147,84,222,87,41,35,217,103,191,179,102,122,46,196,97,74,184,93,104,27,2,42,111,43,148,180,11,190,55,195,12,142,161,90,5,223,27,45,2,239,141,0,0,0,0,25,27,49,65,50,54,98,130,43,45,83,195,100,108,197,4,125,119,244,69,86,90,167,134,79,65,150,199,200,217,138,8,209,194,187,73,250,239,232,138,227,244,217,203,172,181,79,12,181,174,126,77,158,131,45,142,135,152,28,207,74,194,18,81,83,217,35,16,120,244,112,211,97,239,65,146,46,174,215,85,55,181,230,20,28,152,181,215,5,131,132,150,
130,27,152,89,155,0,169,24,176,45,250,219,169,54,203,154,230,119,93,93,255,108,108,28,212,65,63,223,205,90,14,158,149,132,36,162,140,159,21,227,167,178,70,32,190,169,119,97,241,232,225,166,232,243,208,231,195,222,131,36,218,197,178,101,93,93,174,170,68,70,159,235,111,107,204,40,118,112,253,105,57,49,107,174,32,42,90,239,11,7,9,44,18,28,56,109,223,70,54,243,198,93,7,178,237,112,84,113,244,107,101,48,187,42,243,247,162,49,194,182,137,28,145,117,144,7,160,52,23,159,188,251,14,132,141,186,37,169,222,
121,60,178,239,56,115,243,121,255,106,232,72,190,65,197,27,125,88,222,42,60,240,121,79,5,233,98,126,68,194,79,45,135,219,84,28,198,148,21,138,1,141,14,187,64,166,35,232,131,191,56,217,194,56,160,197,13,33,187,244,76,10,150,167,143,19,141,150,206,92,204,0,9,69,215,49,72,110,250,98,139,119,225,83,202,186,187,93,84,163,160,108,21,136,141,63,214,145,150,14,151,222,215,152,80,199,204,169,17,236,225,250,210,245,250,203,147,114,98,215,92,107,121,230,29,64,84,181,222,89,79,132,159,22,14,18,88,15,21,35,25,
36,56,112,218,61,35,65,155,101,253,107,167,124,230,90,230,87,203,9,37,78,208,56,100,1,145,174,163,24,138,159,226,51,167,204,33,42,188,253,96,173,36,225,175,180,63,208,238,159,18,131,45,134,9,178,108,201,72,36,171,208,83,21,234,251,126,70,41,226,101,119,104,47,63,121,246,54,36,72,183,29,9,27,116,4,18,42,53,75,83,188,242,82,72,141,179,121,101,222,112,96,126,239,49,231,230,243,254,254,253,194,191,213,208,145,124,204,203,160,61,131,138,54,250,154,145,7,187,177,188,84,120,168,167,101,57,59,131,152,75,
34,152,169,10,9,181,250,201,16,174,203,136,95,239,93,79,70,244,108,14,109,217,63,205,116,194,14,140,243,90,18,67,234,65,35,2,193,108,112,193,216,119,65,128,151,54,215,71,142,45,230,6,165,0,181,197,188,27,132,132,113,65,138,26,104,90,187,91,67,119,232,152,90,108,217,217,21,45,79,30,12,54,126,95,39,27,45,156,62,0,28,221,185,152,0,18,160,131,49,83,139,174,98,144,146,181,83,209,221,244,197,22,196,239,244,87,239,194,167,148,246,217,150,213,174,7,188,233,183,28,141,168,156,49,222,107,133,42,239,42,202,
107,121,237,211,112,72,172,248,93,27,111,225,70,42,46,102,222,54,225,127,197,7,160,84,232,84,99,77,243,101,34,2,178,243,229,27,169,194,164,48,132,145,103,41,159,160,38,228,197,174,184,253,222,159,249,214,243,204,58,207,232,253,123,128,169,107,188,153,178,90,253,178,159,9,62,171,132,56,127,44,28,36,176,53,7,21,241,30,42,70,50,7,49,119,115,72,112,225,180,81,107,208,245,122,70,131,54,99,93,178,119,203,250,215,78,210,225,230,15,249,204,181,204,224,215,132,141,175,150,18,74,182,141,35,11,157,160,112,200,
132,187,65,137,3,35,93,70,26,56,108,7,49,21,63,196,40,14,14,133,103,79,152,66,126,84,169,3,85,121,250,192,76,98,203,129,129,56,197,31,152,35,244,94,179,14,167,157,170,21,150,220,229,84,0,27,252,79,49,90,215,98,98,153,206,121,83,216,73,225,79,23,80,250,126,86,123,215,45,149,98,204,28,212,45,141,138,19,52,150,187,82,31,187,232,145,6,160,217,208,94,126,243,236,71,101,194,173,108,72,145,110,117,83,160,47,58,18,54,232,35,9,7,169,8,36,84,106,17,63,101,43,150,167,121,228,143,188,72,165,164,145,27,102,189,
138,42,39,242,203,188,224,235,208,141,161,192,253,222,98,217,230,239,35,20,188,225,189,13,167,208,252,38,138,131,63,63,145,178,126,112,208,36,185,105,203,21,248,66,230,70,59,91,253,119,122,220,101,107,181,197,126,90,244,238,83,9,55,247,72,56,118,184,9,174,177,161,18,159,240,138,63,204,51,147,36,253,114,0,0,0,0,1,194,106,55,3,132,212,110,2,70,190,89,7,9,168,220,6,203,194,235,4,141,124,178,5,79,22,133,14,19,81,184,15,209,59,143,13,151,133,214,12,85,239,225,9,26,249,100,8,216,147,83,10,158,45,10,11,
92,71,61,28,38,163,112,29,228,201,71,31,162,119,30,30,96,29,41,27,47,11,172,26,237,97,155,24,171,223,194,25,105,181,245,18,53,242,200,19,247,152,255,17,177,38,166,16,115,76,145,21,60,90,20,20,254,48,35,22,184,142,122,23,122,228,77,56,77,70,224,57,143,44,215,59,201,146,142,58,11,248,185,63,68,238,60,62,134,132,11,60,192,58,82,61,2,80,101,54,94,23,88,55,156,125,111,53,218,195,54,52,24,169,1,49,87,191,132,48,149,213,179,50,211,107,234,51,17,1,221,36,107,229,144,37,169,143,167,39,239,49,254,38,45,91,
201,35,98,77,76,34,160,39,123,32,230,153,34,33,36,243,21,42,120,180,40,43,186,222,31,41,252,96,70,40,62,10,113,45,113,28,244,44,179,118,195,46,245,200,154,47,55,162,173,112,154,141,192,113,88,231,247,115,30,89,174,114,220,51,153,119,147,37,28,118,81,79,43,116,23,241,114,117,213,155,69,126,137,220,120,127,75,182,79,125,13,8,22,124,207,98,33,121,128,116,164,120,66,30,147,122,4,160,202,123,198,202,253,108,188,46,176,109,126,68,135,111,56,250,222,110,250,144,233,107,181,134,108,106,119,236,91,104,49,
82,2,105,243,56,53,98,175,127,8,99,109,21,63,97,43,171,102,96,233,193,81,101,166,215,212,100,100,189,227,102,34,3,186,103,224,105,141,72,215,203,32,73,21,161,23,75,83,31,78,74,145,117,121,79,222,99,252,78,28,9,203,76,90,183,146,77,152,221,165,70,196,154,152,71,6,240,175,69,64,78,246,68,130,36,193,65,205,50,68,64,15,88,115,66,73,230,42,67,139,140,29,84,241,104,80,85,51,2,103,87,117,188,62,86,183,214,9,83,248,192,140,82,58,170,187,80,124,20,226,81,190,126,213,90,226,57,232,91,32,83,223,89,102,237,134,
88,164,135,177,93,235,145,52,92,41,251,3,94,111,69,90,95,173,47,109,225,53,27,128,224,247,113,183,226,177,207,238,227,115,165,217,230,60,179,92,231,254,217,107,229,184,103,50,228,122,13,5,239,38,74,56,238,228,32,15,236,162,158,86,237,96,244,97,232,47,226,228,233,237,136,211,235,171,54,138,234,105,92,189,253,19,184,240,252,209,210,199,254,151,108,158,255,85,6,169,250,26,16,44,251,216,122,27,249,158,196,66,248,92,174,117,243,0,233,72,242,194,131,127,240,132,61,38,241,70,87,17,244,9,65,148,245,203,43,
163,247,141,149,250,246,79,255,205,217,120,93,96,216,186,55,87,218,252,137,14,219,62,227,57,222,113,245,188,223,179,159,139,221,245,33,210,220,55,75,229,215,107,12,216,214,169,102,239,212,239,216,182,213,45,178,129,208,98,164,4,209,160,206,51,211,230,112,106,210,36,26,93,197,94,254,16,196,156,148,39,198,218,42,126,199,24,64,73,194,87,86,204,195,149,60,251,193,211,130,162,192,17,232,149,203,77,175,168,202,143,197,159,200,201,123,198,201,11,17,241,204,68,7,116,205,134,109,67,207,192,211,26,206,2,185,
45,145,175,150,64,144,109,252,119,146,43,66,46,147,233,40,25,150,166,62,156,151,100,84,171,149,34,234,242,148,224,128,197,159,188,199,248,158,126,173,207,156,56,19,150,157,250,121,161,152,181,111,36,153,119,5,19,155,49,187,74,154,243,209,125,141,137,53,48,140,75,95,7,142,13,225,94,143,207,139,105,138,128,157,236,139,66,247,219,137,4,73,130,136,198,35,181,131,154,100,136,130,88,14,191,128,30,176,230,129,220,218,209,132,147,204,84,133,81,166,99,135,23,24,58,134,213,114,13,169,226,208,160,168,32,186,
151,170,102,4,206,171,164,110,249,174,235,120,124,175,41,18,75,173,111,172,18,172,173,198,37,167,241,129,24,166,51,235,47,164,117,85,118,165,183,63,65,160,248,41,196,161,58,67,243,163,124,253,170,162,190,151,157,181,196,115,208,180,6,25,231,182,64,167,190,183,130,205,137,178,205,219,12,179,15,177,59,177,73,15,98,176,139,101,85,187,215,34,104,186,21,72,95,184,83,246,6,185,145,156,49,188,222,138,180,189,28,224,131,191,90,94,218,190,152,52,237,0,0,0,0,184,188,103,101,170,9,200,139,18,181,175,238,143,
98,151,87,55,222,240,50,37,107,95,220,157,215,56,185,197,180,40,239,125,8,79,138,111,189,224,100,215,1,135,1,74,214,191,184,242,106,216,221,224,223,119,51,88,99,16,86,80,25,87,159,232,165,48,250,250,16,159,20,66,172,248,113,223,123,192,200,103,199,167,173,117,114,8,67,205,206,111,38,149,173,127,112,45,17,24,21,63,164,183,251,135,24,208,158,26,207,232,39,162,115,143,66,176,198,32,172,8,122,71,201,160,50,175,62,24,142,200,91,10,59,103,181,178,135,0,208,47,80,56,105,151,236,95,12,133,89,240,226,61,229,
151,135,101,134,135,209,221,58,224,180,207,143,79,90,119,51,40,63,234,228,16,134,82,88,119,227,64,237,216,13,248,81,191,104,240,43,248,161,72,151,159,196,90,34,48,42,226,158,87,79,127,73,111,246,199,245,8,147,213,64,167,125,109,252,192,24,53,159,208,78,141,35,183,43,159,150,24,197,39,42,127,160,186,253,71,25,2,65,32,124,16,244,143,146,168,72,232,247,155,20,88,61,35,168,63,88,49,29,144,182,137,161,247,211,20,118,207,106,172,202,168,15,190,127,7,225,6,195,96,132,94,160,112,210,230,28,23,183,244,169,
184,89,76,21,223,60,209,194,231,133,105,126,128,224,123,203,47,14,195,119,72,107,203,13,15,162,115,177,104,199,97,4,199,41,217,184,160,76,68,111,152,245,252,211,255,144,238,102,80,126,86,218,55,27,14,185,39,77,182,5,64,40,164,176,239,198,28,12,136,163,129,219,176,26,57,103,215,127,43,210,120,145,147,110,31,244,59,38,247,3,131,154,144,102,145,47,63,136,41,147,88,237,180,68,96,84,12,248,7,49,30,77,168,223,166,241,207,186,254,146,223,236,70,46,184,137,84,155,23,103,236,39,112,2,113,240,72,187,201,76,
47,222,219,249,128,48,99,69,231,85,107,63,160,156,211,131,199,249,193,54,104,23,121,138,15,114,228,93,55,203,92,225,80,174,78,84,255,64,246,232,152,37,174,139,136,115,22,55,239,22,4,130,64,248,188,62,39,157,33,233,31,36,153,85,120,65,139,224,215,175,51,92,176,202,237,89,182,59,85,229,209,94,71,80,126,176,255,236,25,213,98,59,33,108,218,135,70,9,200,50,233,231,112,142,142,130,40,237,158,212,144,81,249,177,130,228,86,95,58,88,49,58,167,143,9,131,31,51,110,230,13,134,193,8,181,58,166,109,189,64,225,
164,5,252,134,193,23,73,41,47,175,245,78,74,50,34,118,243,138,158,17,150,152,43,190,120,32,151,217,29,120,244,201,75,192,72,174,46,210,253,1,192,106,65,102,165,247,150,94,28,79,42,57,121,93,159,150,151,229,35,241,242,77,107,25,5,245,215,126,96,231,98,209,142,95,222,182,235,194,9,142,82,122,181,233,55,104,0,70,217,208,188,33,188,136,223,49,234,48,99,86,143,34,214,249,97,154,106,158,4,7,189,166,189,191,1,193,216,173,180,110,54,21,8,9,83,29,114,78,154,165,206,41,255,183,123,134,17,15,199,225,116,146,
16,217,205,42,172,190,168,56,25,17,70,128,165,118,35,216,198,102,117,96,122,1,16,114,207,174,254,202,115,201,155,87,164,241,34,239,24,150,71,253,173,57,169,69,17,94,204,118,77,238,6,206,241,137,99,220,68,38,141,100,248,65,232,249,47,121,81,65,147,30,52,83,38,177,218,235,154,214,191,179,249,198,233,11,69,161,140,25,240,14,98,161,76,105,7,60,155,81,190,132,39,54,219,150,146,153,53,46,46,254,80,38,84,185,153,158,232,222,252,140,93,113,18,52,225,22,119,169,54,46,206,17,138,73,171,3,63,230,69,187,131,
129,32,227,224,145,118,91,92,246,19,73,233,89,253,241,85,62,152,108,130,6,33,212,62,97,68,198,139,206,170,126,55,169,207,214,127,65,56,110,195,38,93,124,118,137,179,196,202,238,214,89,29,214,111,225,161,177,10,243,20,30,228,75,168,121,129,19,203,105,215,171,119,14,178,185,194,161,92,1,126,198,57,156,169,254,128,36,21,153,229,54,160,54,11,142,28,81,110,134,102,22,167,62,218,113,194,44,111,222,44,148,211,185,73,9,4,129,240,177,184,230,149,163,13,73,123,27,177,46,30,67,210,62,72,251,110,89,45,233,219,
246,195,81,103,145,166,204,176,169,31,116,12,206,122,102,185,97,148,222,5,6,241,16,0,0,0,11,0,0,0,10,0,0,0,16,0,0,0,24,0,0,0,40,0,0,0,51,0,0,0,61,0,0,0,12,0,0,0,12,0,0,0,14,0,0,0,19,0,0,0,26,0,0,0,58,0,0,0,60,0,0,0,55,0,0,0,14,0,0,0,13,0,0,0,16,0,0,0,24,0,0,0,40,0,0,0,57,0,0,0,69,0,0,0,56,0,0,0,14,0,0,0,17,0,0,0,22,0,0,0,29,0,0,0,51,0,0,0,87,0,0,0,80,0,0,0,62,0,0,0,18,0,0,0,22,0,0,0,37,0,0,0,56,0,0,0,68,0,0,0,109,0,0,0,103,0,0,0,77,0,0,0,24,0,0,0,35,0,0,0,55,0,0,0,64,0,0,0,81,0,0,0,104,0,0,0,113,
0,0,0,92,0,0,0,49,0,0,0,64,0,0,0,78,0,0,0,87,0,0,0,103,0,0,0,121,0,0,0,120,0,0,0,101,0,0,0,72,0,0,0,92,0,0,0,95,0,0,0,98,0,0,0,112,0,0,0,100,0,0,0,103,0,0,0,99,0,0,0,17,0,0,0,18,0,0,0,24,0,0,0,47,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,18,0,0,0,21,0,0,0,26,0,0,0,66,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,24,0,0,0,26,0,0,0,56,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,47,0,0,0,66,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,
0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,99,0,0,0,121,98,2,0,143,98,2,0,175,98,2,0,212,98,2,0,238,98,2,0,13,99,2,0,34,99,2,0,63,99,2,0,105,99,2,0,169,99,2,0,200,99,2,0,223,99,2,0,245,99,2,0,9,100,2,0,70,100,2,0,118,100,2,0,146,100,2,0,181,100,2,0,236,100,2,0,35,101,2,0,58,101,2,0,90,101,2,0,132,101,2,0,209,101,
2,0,236,101,2,0,23,102,2,0,51,102,2,0,88,102,2,0,126,102,2,0,163,102,2,0,182,102,2,0,203,102,2,0,222,102,2,0,241,102,2,0,22,103,2,0,43,103,2,0,63,103,2,0,96,103,2,0,118,103,2,0,165,103,2,0,205,103,2,0,238,103,2,0,15,104,2,0,62,104,2,0,79,104,2,0,107,104,2,0,169,104,2,0,208,104,2,0,247,104,2,0,11,105,2,0,57,105,2,0,97,105,2,0,125,105,2,0,162,105,2,0,196,105,2,0,238,105,2,0,25,106,2,0,55,106,2,0,101,106,2,0,141,106,2,0,180,106,2,0,223,106,2,0,12,107,2,0,60,107,2,0,102,107,2,0,147,107,2,0,182,107,2,
0,212,107,2,0,242,107,2,0,40,108,2,0,82,108,2,0,113,108,2,0,148,108,2,0,187,108,2,0,208,108,2,0,228,108,2,0,25,109,2,0,41,109,2,0,103,109,2,0,169,109,2,0,211,109,2,0,255,109,2,0,38,110,2,0,66,110,2,0,109,110,2,0,136,110,2,0,156,110,2,0,179,110,2,0,192,110,2,0,232,110,2,0,29,111,2,0,89,111,2,0,135,111,2,0,168,111,2,0,207,111,2,0,232,111,2,0,16,112,2,0,51,112,2,0,75,112,2,0,111,112,2,0,148,112,2,0,154,112,2,0,211,112,2,0,13,113,2,0,44,113,2,0,59,113,2,0,88,113,2,0,118,113,2,0,147,113,2,0,172,113,2,
0,197,113,2,0,7,114,2,0,65,114,2,0,119,114,2,0,171,114,2,0,191,114,2,0,214,114,2,0,252,114,2,0,35,115,2,0,101,115,2,0,161,115,2,0,210,115,2,0,246,115,2,0,36,116,2,0,63,116,2,0,119,116,2,0,162,116,2,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,0,0,0,9,0,0,0,2,0,0,0,3,0,0,0,10,0,0,0,17,0,0,0,24,0,0,0,32,0,0,0,25,0,0,0,18,0,0,0,11,0,0,0,4,0,0,0,5,0,0,0,12,0,0,0,19,0,0,0,26,0,0,0,33,0,0,0,40,0,0,0,48,0,0,0,41,0,0,0,34,0,0,0,27,0,0,0,20,0,0,0,13,0,0,0,6,0,0,0,7,0,0,0,14,0,0,0,21,0,0,0,
28,0,0,0,35,0,0,0,42,0,0,0,49,0,0,0,56,0,0,0,57,0,0,0,50,0,0,0,43,0,0,0,36,0,0,0,29,0,0,0,22,0,0,0,15,0,0,0,23,0,0,0,30,0,0,0,37,0,0,0,44,0,0,0,51,0,0,0,58,0,0,0,59,0,0,0,52,0,0,0,45,0,0,0,38,0,0,0,31,0,0,0,39,0,0,0,46,0,0,0,53,0,0,0,60,0,0,0,61,0,0,0,54,0,0,0,47,0,0,0,55,0,0,0,62,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,0,0,0,9,0,0,0,2,0,0,0,3,0,0,0,10,
0,0,0,17,0,0,0,24,0,0,0,32,0,0,0,25,0,0,0,18,0,0,0,11,0,0,0,4,0,0,0,5,0,0,0,12,0,0,0,19,0,0,0,26,0,0,0,33,0,0,0,40,0,0,0,48,0,0,0,41,0,0,0,34,0,0,0,27,0,0,0,20,0,0,0,13,0,0,0,6,0,0,0,14,0,0,0,21,0,0,0,28,0,0,0,35,0,0,0,42,0,0,0,49,0,0,0,50,0,0,0,43,0,0,0,36,0,0,0,29,0,0,0,22,0,0,0,30,0,0,0,37,0,0,0,44,0,0,0,51,0,0,0,52,0,0,0,45,0,0,0,38,0,0,0,46,0,0,0,53,0,0,0,54,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,
0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,0,0,0,9,0,0,0,2,0,0,0,3,0,0,0,10,0,0,0,17,0,0,0,24,0,0,0,32,0,0,0,25,0,0,0,18,0,0,0,11,0,0,0,4,0,0,0,5,0,0,0,12,0,0,0,19,0,0,0,26,0,0,0,33,0,0,0,40,0,0,0,41,0,0,0,34,0,0,0,27,0,0,0,20,0,0,0,13,0,0,0,21,0,0,0,28,0,0,0,35,0,0,0,42,0,0,0,43,0,0,0,36,0,0,0,29,0,0,0,37,0,0,0,44,0,0,0,45,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,
0,0,0,9,0,0,0,2,0,0,0,3,0,0,0,10,0,0,0,17,0,0,0,24,0,0,0,32,0,0,0,25,0,0,0,18,0,0,0,11,0,0,0,4,0,0,0,12,0,0,0,19,0,0,0,26,0,0,0,33,0,0,0,34,0,0,0,27,0,0,0,20,0,0,0,28,0,0,0,35,0,0,0,36,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,0,0,0,9,0,0,0,2,0,0,0,3,0,0,0,10,0,0,0,17,0,0,0,24,0,0,0,25,0,0,0,18,0,0,0,11,0,0,0,19,0,0,0,26,0,0,0,27,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,
0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,16,0,0,0,9,0,0,0,2,0,0,0,10,0,0,0,17,0,0,0,18,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,9,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,
63,0,0,0,64,6,0,0,128,62,0,0,0,0,0,0,136,19,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,2,0,0,0,4,0,0,0,6,0,0,0,3,0,0,0,7,0,0,0,8,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,12,0,0,0,3,0,0,0,8,0,0,0,11,0,0,0,13,0,0,0,9,0,0,0,10,0,0,0,14,0,0,0,15,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,14,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,13,0,0,0,15,0,0,0,3,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,21,0,0,0,9,0,0,0,11,0,0,0,17,0,0,0,20,0,0,0,22,0,0,0,10,0,0,0,18,0,0,0,19,0,0,0,23,0,0,0,24,0,0,0,
0,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,14,0,0,0,15,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,13,0,0,0,16,0,0,0,25,0,0,0,3,0,0,0,8,0,0,0,12,0,0,0,17,0,0,0,24,0,0,0,26,0,0,0,9,0,0,0,11,0,0,0,18,0,0,0,23,0,0,0,27,0,0,0,32,0,0,0,10,0,0,0,19,0,0,0,22,0,0,0,28,0,0,0,31,0,0,0,33,0,0,0,20,0,0,0,21,0,0,0,29,0,0,0,30,0,0,0,34,0,0,0,35,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,14,0,0,0,15,0,0,0,27,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,13,0,0,0,16,0,0,0,26,0,0,0,28,0,0,0,3,0,0,0,8,0,0,0,12,0,0,0,17,0,0,0,25,0,0,0,29,0,0,0,38,0,0,0,9,0,0,0,
11,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,37,0,0,0,39,0,0,0,10,0,0,0,19,0,0,0,23,0,0,0,31,0,0,0,36,0,0,0,40,0,0,0,45,0,0,0,20,0,0,0,22,0,0,0,32,0,0,0,35,0,0,0,41,0,0,0,44,0,0,0,46,0,0,0,21,0,0,0,33,0,0,0,34,0,0,0,42,0,0,0,43,0,0,0,47,0,0,0,48,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,14,0,0,0,15,0,0,0,27,0,0,0,28,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,13,0,0,0,16,0,0,0,26,0,0,0,29,0,0,0,42,0,0,0,3,0,0,0,8,0,0,0,12,0,0,0,17,0,0,0,25,0,0,0,30,0,0,0,41,0,0,0,43,0,0,0,9,0,0,0,11,0,0,0,18,0,0,0,24,0,0,0,31,0,0,0,40,0,0,
0,44,0,0,0,53,0,0,0,10,0,0,0,19,0,0,0,23,0,0,0,32,0,0,0,39,0,0,0,45,0,0,0,52,0,0,0,54,0,0,0,20,0,0,0,22,0,0,0,33,0,0,0,38,0,0,0,46,0,0,0,51,0,0,0,55,0,0,0,60,0,0,0,21,0,0,0,34,0,0,0,37,0,0,0,47,0,0,0,50,0,0,0,56,0,0,0,59,0,0,0,61,0,0,0,35,0,0,0,36,0,0,0,48,0,0,0,49,0,0,0,57,0,0,0,58,0,0,0,62,0,0,0,63,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,7,0,0,0,15,0,0,0,31,0,0,0,63,0,0,0,127,0,0,0,255,0,0,0,255,1,0,0,255,3,0,0,255,7,0,0,255,15,0,0,255,31,0,0,255,63,0,0,255,127,0,0,129,1,29,90,14,2,134,37,16,3,20,17,18,4,
11,8,20,5,216,3,23,6,218,1,25,7,229,0,28,8,111,0,30,9,54,0,33,10,26,0,35,11,13,0,9,12,6,0,10,13,3,0,12,13,1,0,143,15,127,90,36,16,37,63,38,17,242,44,39,18,124,32,40,19,185,23,42,20,130,17,43,21,239,12,45,22,161,9,46,23,47,7,48,24,92,5,49,25,6,4,51,26,3,3,52,27,64,2,54,28,177,1,56,29,68,1,57,30,245,0,59,31,183,0,60,32,138,0,62,33,104,0,63,34,78,0,32,35,59,0,33,9,44,0,165,37,225,90,64,38,76,72,65,39,13,58,67,40,241,46,68,41,31,38,69,42,51,31,70,43,168,25,72,44,24,21,73,45,119,17,74,46,116,14,75,47,
251,11,77,48,248,9,78,49,97,8,79,50,6,7,48,51,205,5,50,52,222,4,50,53,15,4,51,54,99,3,52,55,212,2,53,56,92,2,54,57,248,1,55,58,164,1,56,59,96,1,57,60,37,1,58,61,246,0,59,62,203,0,61,63,171,0,61,32,143,0,193,65,18,91,80,66,4,77,81,67,44,65,82,68,216,55,83,69,232,47,84,70,60,41,86,71,121,35,87,72,223,30,87,73,169,26,72,74,78,23,72,75,36,20,74,76,156,17,74,77,107,15,75,78,81,13,77,79,182,11,77,48,64,10,208,81,50,88,88,82,28,77,89,83,142,67,90,84,221,59,91,85,238,52,92,86,174,46,93,87,154,41,86,71,22,
37,216,89,112,85,95,90,169,76,96,91,217,68,97,92,34,62,99,93,36,56,99,94,180,50,93,86,23,46,223,96,168,86,101,97,70,79,102,98,229,71,103,99,207,65,104,100,61,60,99,93,94,55,105,102,49,82,106,103,15,76,107,104,57,70,103,99,94,65,233,106,39,86,108,107,231,80,109,103,133,75,110,109,151,85,111,107,79,80,238,111,16,90,112,109,34,85,240,111,235,89,113,113,29,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,192,3,0,0,192,4,0,0,192,5,0,0,192,6,0,0,192,7,0,0,
192,8,0,0,192,9,0,0,192,10,0,0,192,11,0,0,192,12,0,0,192,13,0,0,192,14,0,0,192,15,0,0,192,16,0,0,192,17,0,0,192,18,0,0,192,19,0,0,192,20,0,0,192,21,0,0,192,22,0,0,192,23,0,0,192,24,0,0,192,25,0,0,192,26,0,0,192,27,0,0,192,28,0,0,192,29,0,0,192,30,0,0,192,31,0,0,192,0,0,0,179,1,0,0,195,2,0,0,195,3,0,0,195,4,0,0,195,5,0,0,195,6,0,0,195,7,0,0,195,8,0,0,195,9,0,0,195,10,0,0,195,11,0,0,195,12,0,0,195,13,0,0,211,14,0,0,195,15,0,0,195,0,0,12,187,1,0,12,195,2,0,12,195,3,0,12,195,4,0,12,211,120,224,1,0,232,
224,1,0,0,0,0,0,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5],"i8",4,ra.GLOBAL_BASE+112640);vc([1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,102,130,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,3,0,0,0,94,126,2,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,53,0,0,0,6,0,7,0,1,0,4,0,7,0,2,0,4,0,8,0,3,0,4,0,11,0,4,0,4,0,12,0,5,0,4,0,14,0,6,0,4,0,15,0,7,0,5,0,19,0,8,0,5,0,20,0,9,0,5,0,7,0,10,0,5,0,8,0,11,0,6,0,8,0,12,0,6,0,3,0,13,0,6,0,52,0,14,0,6,0,53,0,15,0,6,0,42,0,16,0,6,0,43,0,17,0,7,0,
39,0,18,0,7,0,12,0,19,0,7,0,8,0,20,0,7,0,23,0,21,0,7,0,3,0,22,0,7,0,4,0,23,0,7,0,40,0,24,0,7,0,43,0,25,0,7,0,19,0,26,0,7,0,36,0,27,0,7,0,24,0,28,0,8,0,2,0,29,0,8,0,3,0,30,0,8,0,26,0,31,0,8,0,27,0,32,0,8,0,18,0,33,0,8,0,19,0,34,0,8,0,20,0,35,0,8,0,21,0,36,0,8,0,22,0,37,0,8,0,23,0,38,0,8,0,40,0,39,0,8,0,41,0,40,0,8,0,42,0,41,0,8,0,43,0,42,0,8,0,44,0,43,0,8,0,45,0,44,0,8,0,4,0,45,0,8,0,5,0,46,0,8,0,10,0,47,0,8,0,11,0,48,0,8,0,82,0,49,0,8,0,83,0,50,0,8,0,84,0,51,0,8,0,85,0,52,0,8,0,36,0,53,0,8,0,37,0,
54,0,8,0,88,0,55,0,8,0,89,0,56,0,8,0,90,0,57,0,8,0,91,0,58,0,8,0,74,0,59,0,8,0,75,0,60,0,8,0,50,0,61,0,8,0,51,0,62,0,8,0,52,0,63,0,5,0,27,0,64,0,5,0,18,0,128,0,6,0,23,0,192,0,7,0,55,0,0,1,8,0,54,0,64,1,8,0,55,0,128,1,8,0,100,0,192,1,8,0,101,0,0,2,8,0,104,0,64,2,8,0,103,0,128,2,9,0,204,0,192,2,9,0,205,0,0,3,9,0,210,0,64,3,9,0,211,0,128,3,9,0,212,0,192,3,9,0,213,0,0,4,9,0,214,0,64,4,9,0,215,0,128,4,9,0,216,0,192,4,9,0,217,0,0,5,9,0,218,0,64,5,9,0,219,0,128,5,9,0,152,0,192,5,9,0,153,0,0,6,9,0,154,0,
64,6,6,0,24,0,128,6,9,0,155,0,192,6,11,0,8,0,0,7,11,0,12,0,64,7,11,0,13,0,128,7,12,0,18,0,192,7,12,0,19,0,0,8,12,0,20,0,64,8,12,0,21,0,128,8,12,0,22,0,192,8,12,0,23,0,0,9,12,0,28,0,64,9,12,0,29,0,128,9,12,0,30,0,192,9,12,0,31,0,0,10,12,0,1,0,255,255,9,0,1,0,254,255,10,0,1,0,254,255,11,0,1,0,254,255,12,0,0,0,254,255,10,0,55,0,0,0,3,0,2,0,1,0,2,0,3,0,2,0,2,0,2,0,3,0,3,0,3,0,4,0,4,0,3,0,5,0,4,0,2,0,6,0,5,0,3,0,7,0,6,0,5,0,8,0,6,0,4,0,9,0,7,0,4,0,10,0,7,0,5,0,11,0,7,0,7,0,12,0,8,0,4,0,13,0,8,0,7,0,14,
0,9,0,24,0,15,0,10,0,23,0,16,0,10,0,24,0,17,0,10,0,8,0,18,0,11,0,103,0,19,0,11,0,104,0,20,0,11,0,108,0,21,0,11,0,55,0,22,0,11,0,40,0,23,0,11,0,23,0,24,0,11,0,24,0,25,0,12,0,202,0,26,0,12,0,203,0,27,0,12,0,204,0,28,0,12,0,205,0,29,0,12,0,104,0,30,0,12,0,105,0,31,0,12,0,106,0,32,0,12,0,107,0,33,0,12,0,210,0,34,0,12,0,211,0,35,0,12,0,212,0,36,0,12,0,213,0,37,0,12,0,214,0,38,0,12,0,215,0,39,0,12,0,108,0,40,0,12,0,109,0,41,0,12,0,218,0,42,0,12,0,219,0,43,0,12,0,84,0,44,0,12,0,85,0,45,0,12,0,86,0,46,0,
12,0,87,0,47,0,12,0,100,0,48,0,12,0,101,0,49,0,12,0,82,0,50,0,12,0,83,0,51,0,12,0,36,0,52,0,12,0,55,0,53,0,12,0,56,0,54,0,12,0,39,0,55,0,12,0,40,0,56,0,12,0,88,0,57,0,12,0,89,0,58,0,12,0,43,0,59,0,12,0,44,0,60,0,12,0,90,0,61,0,12,0,102,0,62,0,12,0,103,0,63,0,10,0,15,0,64,0,12,0,200,0,128,0,12,0,201,0,192,0,12,0,91,0,0,1,12,0,51,0,64,1,12,0,52,0,128,1,12,0,53,0,192,1,13,0,108,0,0,2,13,0,109,0,64,2,13,0,74,0,128,2,13,0,75,0,192,2,13,0,76,0,0,3,13,0,77,0,64,3,13,0,114,0,128,3,13,0,115,0,192,3,13,0,116,
0,0,4,13,0,117,0,64,4,13,0,118,0,128,4,13,0,119,0,192,4,13,0,82,0,0,5,13,0,83,0,64,5,13,0,84,0,128,5,13,0,85,0,192,5,13,0,90,0,0,6,13,0,91,0,64,6,13,0,100,0,128,6,13,0,101,0,192,6,11,0,8,0,0,7,11,0,12,0,64,7,11,0,13,0,128,7,12,0,18,0,192,7,12,0,19,0,0,8,12,0,20,0,64,8,12,0,21,0,128,8,12,0,22,0,192,8,12,0,23,0,0,9,12,0,28,0,64,9,12,0,29,0,128,9,12,0,30,0,192,9,12,0,31,0,0,10,12,0,1,0,255,255,9,0,1,0,254,255,10,0,1,0,254,255,11,0,1,0,254,255,12,0,0,0,254,255,7,0,3,0,0,0,6,0,3,0,0,0,3,0,3,0,0,0,1,0,
1,0,0,0,3,0,2,0,0,0,6,0,2,0,0,0,7,0,2,0,0,0,96,7,0,0,0,8,80,0,0,8,16,0,20,8,115,0,18,7,31,0,0,8,112,0,0,8,48,0,0,9,192,0,16,7,10,0,0,8,96,0,0,8,32,0,0,9,160,0,0,8,0,0,0,8,128,0,0,8,64,0,0,9,224,0,16,7,6,0,0,8,88,0,0,8,24,0,0,9,144,0,19,7,59,0,0,8,120,0,0,8,56,0,0,9,208,0,17,7,17,0,0,8,104,0,0,8,40,0,0,9,176,0,0,8,8,0,0,8,136,0,0,8,72,0,0,9,240,0,16,7,4,0,0,8,84,0,0,8,20,0,21,8,227,0,19,7,43,0,0,8,116,0,0,8,52,0,0,9,200,0,17,7,13,0,0,8,100,0,0,8,36,0,0,9,168,0,0,8,4,0,0,8,132,0,0,8,68,0,0,9,232,0,
16,7,8,0,0,8,92,0,0,8,28,0,0,9,152,0,20,7,83,0,0,8,124,0,0,8,60,0,0,9,216,0,18,7,23,0,0,8,108,0,0,8,44,0,0,9,184,0,0,8,12,0,0,8,140,0,0,8,76,0,0,9,248,0,16,7,3,0,0,8,82,0,0,8,18,0,21,8,163,0,19,7,35,0,0,8,114,0,0,8,50,0,0,9,196,0,17,7,11,0,0,8,98,0,0,8,34,0,0,9,164,0,0,8,2,0,0,8,130,0,0,8,66,0,0,9,228,0,16,7,7,0,0,8,90,0,0,8,26,0,0,9,148,0,20,7,67,0,0,8,122,0,0,8,58,0,0,9,212,0,18,7,19,0,0,8,106,0,0,8,42,0,0,9,180,0,0,8,10,0,0,8,138,0,0,8,74,0,0,9,244,0,16,7,5,0,0,8,86,0,0,8,22,0,64,8,0,0,19,7,51,
0,0,8,118,0,0,8,54,0,0,9,204,0,17,7,15,0,0,8,102,0,0,8,38,0,0,9,172,0,0,8,6,0,0,8,134,0,0,8,70,0,0,9,236,0,16,7,9,0,0,8,94,0,0,8,30,0,0,9,156,0,20,7,99,0,0,8,126,0,0,8,62,0,0,9,220,0,18,7,27,0,0,8,110,0,0,8,46,0,0,9,188,0,0,8,14,0,0,8,142,0,0,8,78,0,0,9,252,0,96,7,0,0,0,8,81,0,0,8,17,0,21,8,131,0,18,7,31,0,0,8,113,0,0,8,49,0,0,9,194,0,16,7,10,0,0,8,97,0,0,8,33,0,0,9,162,0,0,8,1,0,0,8,129,0,0,8,65,0,0,9,226,0,16,7,6,0,0,8,89,0,0,8,25,0,0,9,146,0,19,7,59,0,0,8,121,0,0,8,57,0,0,9,210,0,17,7,17,0,0,8,
105,0,0,8,41,0,0,9,178,0,0,8,9,0,0,8,137,0,0,8,73,0,0,9,242,0,16,7,4,0,0,8,85,0,0,8,21,0,16,8,2,1,19,7,43,0,0,8,117,0,0,8,53,0,0,9,202,0,17,7,13,0,0,8,101,0,0,8,37,0,0,9,170,0,0,8,5,0,0,8,133,0,0,8,69,0,0,9,234,0,16,7,8,0,0,8,93,0,0,8,29,0,0,9,154,0,20,7,83,0,0,8,125,0,0,8,61,0,0,9,218,0,18,7,23,0,0,8,109,0,0,8,45,0,0,9,186,0,0,8,13,0,0,8,141,0,0,8,77,0,0,9,250,0,16,7,3,0,0,8,83,0,0,8,19,0,21,8,195,0,19,7,35,0,0,8,115,0,0,8,51,0,0,9,198,0,17,7,11,0,0,8,99,0,0,8,35,0,0,9,166,0,0,8,3,0,0,8,131,0,0,
8,67,0,0,9,230,0,16,7,7,0,0,8,91,0,0,8,27,0,0,9,150,0,20,7,67,0,0,8,123,0,0,8,59,0,0,9,214,0,18,7,19,0,0,8,107,0,0,8,43,0,0,9,182,0,0,8,11,0,0,8,139,0,0,8,75,0,0,9,246,0,16,7,5,0,0,8,87,0,0,8,23,0,64,8,0,0,19,7,51,0,0,8,119,0,0,8,55,0,0,9,206,0,17,7,15,0,0,8,103,0,0,8,39,0,0,9,174,0,0,8,7,0,0,8,135,0,0,8,71,0,0,9,238,0,16,7,9,0,0,8,95,0,0,8,31,0,0,9,158,0,20,7,99,0,0,8,127,0,0,8,63,0,0,9,222,0,18,7,27,0,0,8,111,0,0,8,47,0,0,9,190,0,0,8,15,0,0,8,143,0,0,8,79,0,0,9,254,0,96,7,0,0,0,8,80,0,0,8,16,0,
20,8,115,0,18,7,31,0,0,8,112,0,0,8,48,0,0,9,193,0,16,7,10,0,0,8,96,0,0,8,32,0,0,9,161,0,0,8,0,0,0,8,128,0,0,8,64,0,0,9,225,0,16,7,6,0,0,8,88,0,0,8,24,0,0,9,145,0,19,7,59,0,0,8,120,0,0,8,56,0,0,9,209,0,17,7,17,0,0,8,104,0,0,8,40,0,0,9,177,0,0,8,8,0,0,8,136,0,0,8,72,0,0,9,241,0,16,7,4,0,0,8,84,0,0,8,20,0,21,8,227,0,19,7,43,0,0,8,116,0,0,8,52,0,0,9,201,0,17,7,13,0,0,8,100,0,0,8,36,0,0,9,169,0,0,8,4,0,0,8,132,0,0,8,68,0,0,9,233,0,16,7,8,0,0,8,92,0,0,8,28,0,0,9,153,0,20,7,83,0,0,8,124,0,0,8,60,0,0,9,217,
0,18,7,23,0,0,8,108,0,0,8,44,0,0,9,185,0,0,8,12,0,0,8,140,0,0,8,76,0,0,9,249,0,16,7,3,0,0,8,82,0,0,8,18,0,21,8,163,0,19,7,35,0,0,8,114,0,0,8,50,0,0,9,197,0,17,7,11,0,0,8,98,0,0,8,34,0,0,9,165,0,0,8,2,0,0,8,130,0,0,8,66,0,0,9,229,0,16,7,7,0,0,8,90,0,0,8,26,0,0,9,149,0,20,7,67,0,0,8,122,0,0,8,58,0,0,9,213,0,18,7,19,0,0,8,106,0,0,8,42,0,0,9,181,0,0,8,10,0,0,8,138,0,0,8,74,0,0,9,245,0,16,7,5,0,0,8,86,0,0,8,22,0,64,8,0,0,19,7,51,0,0,8,118,0,0,8,54,0,0,9,205,0,17,7,15,0,0,8,102,0,0,8,38,0,0,9,173,0,0,8,
6,0,0,8,134,0,0,8,70,0,0,9,237,0,16,7,9,0,0,8,94,0,0,8,30,0,0,9,157,0,20,7,99,0,0,8,126,0,0,8,62,0,0,9,221,0,18,7,27,0,0,8,110,0,0,8,46,0,0,9,189,0,0,8,14,0,0,8,142,0,0,8,78,0,0,9,253,0,96,7,0,0,0,8,81,0,0,8,17,0,21,8,131,0,18,7,31,0,0,8,113,0,0,8,49,0,0,9,195,0,16,7,10,0,0,8,97,0,0,8,33,0,0,9,163,0,0,8,1,0,0,8,129,0,0,8,65,0,0,9,227,0,16,7,6,0,0,8,89,0,0,8,25,0,0,9,147,0,19,7,59,0,0,8,121,0,0,8,57,0,0,9,211,0,17,7,17,0,0,8,105,0,0,8,41,0,0,9,179,0,0,8,9,0,0,8,137,0,0,8,73,0,0,9,243,0,16,7,4,0,0,
8,85,0,0,8,21,0,16,8,2,1,19,7,43,0,0,8,117,0,0,8,53,0,0,9,203,0,17,7,13,0,0,8,101,0,0,8,37,0,0,9,171,0,0,8,5,0,0,8,133,0,0,8,69,0,0,9,235,0,16,7,8,0,0,8,93,0,0,8,29,0,0,9,155,0,20,7,83,0,0,8,125,0,0,8,61,0,0,9,219,0,18,7,23,0,0,8,109,0,0,8,45,0,0,9,187,0,0,8,13,0,0,8,141,0,0,8,77,0,0,9,251,0,16,7,3,0,0,8,83,0,0,8,19,0,21,8,195,0,19,7,35,0,0,8,115,0,0,8,51,0,0,9,199,0,17,7,11,0,0,8,99,0,0,8,35,0,0,9,167,0,0,8,3,0,0,8,131,0,0,8,67,0,0,9,231,0,16,7,7,0,0,8,91,0,0,8,27,0,0,9,151,0,20,7,67,0,0,8,123,0,
0,8,59,0,0,9,215,0,18,7,19,0,0,8,107,0,0,8,43,0,0,9,183,0,0,8,11,0,0,8,139,0,0,8,75,0,0,9,247,0,16,7,5,0,0,8,87,0,0,8,23,0,64,8,0,0,19,7,51,0,0,8,119,0,0,8,55,0,0,9,207,0,17,7,15,0,0,8,103,0,0,8,39,0,0,9,175,0,0,8,7,0,0,8,135,0,0,8,71,0,0,9,239,0,16,7,9,0,0,8,95,0,0,8,31,0,0,9,159,0,20,7,99,0,0,8,127,0,0,8,63,0,0,9,223,0,18,7,27,0,0,8,111,0,0,8,47,0,0,9,191,0,0,8,15,0,0,8,143,0,0,8,79,0,0,9,255,0,16,5,1,0,23,5,1,1,19,5,17,0,27,5,1,16,17,5,5,0,25,5,1,4,21,5,65,0,29,5,1,64,16,5,3,0,24,5,1,2,20,5,33,
0,28,5,1,32,18,5,9,0,26,5,1,8,22,5,129,0,64,5,0,0,16,5,2,0,23,5,129,1,19,5,25,0,27,5,1,24,17,5,7,0,25,5,1,6,21,5,97,0,29,5,1,96,16,5,4,0,24,5,1,3,20,5,49,0,28,5,1,48,18,5,13,0,26,5,1,12,22,5,193,0,64,5,0,0,16,0,17,0,18,0,0,0,8,0,7,0,9,0,6,0,10,0,5,0,11,0,4,0,12,0,3,0,13,0,2,0,14,0,1,0,15,0,1,0,2,0,3,0,4,0,5,0,7,0,9,0,13,0,17,0,25,0,33,0,49,0,65,0,97,0,129,0,193,0,1,1,129,1,1,2,1,3,1,4,1,6,1,8,1,12,1,16,1,24,1,32,1,48,1,64,1,96,0,0,0,0,3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,11,0,13,0,15,0,17,0,19,0,23,0,
27,0,31,0,35,0,43,0,51,0,59,0,67,0,83,0,99,0,115,0,131,0,163,0,195,0,227,0,2,1,0,0,0,0,16,0,16,0,16,0,16,0,17,0,17,0,18,0,18,0,19,0,19,0,20,0,20,0,21,0,21,0,22,0,22,0,23,0,23,0,24,0,24,0,25,0,25,0,26,0,26,0,27,0,27,0,28,0,28,0,29,0,29,0,64,0,64,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,17,0,17,0,17,0,17,0,18,0,18,0,18,0,18,0,19,0,19,0,19,0,19,0,20,0,20,0,20,0,20,0,21,0,21,0,21,0,21,0,16,0,72,0,78,0,12,0,8,0,140,0,8,0,76,0,8,0,204,0,8,0,44,0,8,0,172,0,8,0,108,0,8,0,236,0,8,0,28,0,8,0,156,0,8,0,92,
0,8,0,220,0,8,0,60,0,8,0,188,0,8,0,124,0,8,0,252,0,8,0,2,0,8,0,130,0,8,0,66,0,8,0,194,0,8,0,34,0,8,0,162,0,8,0,98,0,8,0,226,0,8,0,18,0,8,0,146,0,8,0,82,0,8,0,210,0,8,0,50,0,8,0,178,0,8,0,114,0,8,0,242,0,8,0,10,0,8,0,138,0,8,0,74,0,8,0,202,0,8,0,42,0,8,0,170,0,8,0,106,0,8,0,234,0,8,0,26,0,8,0,154,0,8,0,90,0,8,0,218,0,8,0,58,0,8,0,186,0,8,0,122,0,8,0,250,0,8,0,6,0,8,0,134,0,8,0,70,0,8,0,198,0,8,0,38,0,8,0,166,0,8,0,102,0,8,0,230,0,8,0,22,0,8,0,150,0,8,0,86,0,8,0,214,0,8,0,54,0,8,0,182,0,8,0,118,0,8,
0,246,0,8,0,14,0,8,0,142,0,8,0,78,0,8,0,206,0,8,0,46,0,8,0,174,0,8,0,110,0,8,0,238,0,8,0,30,0,8,0,158,0,8,0,94,0,8,0,222,0,8,0,62,0,8,0,190,0,8,0,126,0,8,0,254,0,8,0,1,0,8,0,129,0,8,0,65,0,8,0,193,0,8,0,33,0,8,0,161,0,8,0,97,0,8,0,225,0,8,0,17,0,8,0,145,0,8,0,81,0,8,0,209,0,8,0,49,0,8,0,177,0,8,0,113,0,8,0,241,0,8,0,9,0,8,0,137,0,8,0,73,0,8,0,201,0,8,0,41,0,8,0,169,0,8,0,105,0,8,0,233,0,8,0,25,0,8,0,153,0,8,0,89,0,8,0,217,0,8,0,57,0,8,0,185,0,8,0,121,0,8,0,249,0,8,0,5,0,8,0,133,0,8,0,69,0,8,0,197,
0,8,0,37,0,8,0,165,0,8,0,101,0,8,0,229,0,8,0,21,0,8,0,149,0,8,0,85,0,8,0,213,0,8,0,53,0,8,0,181,0,8,0,117,0,8,0,245,0,8,0,13,0,8,0,141,0,8,0,77,0,8,0,205,0,8,0,45,0,8,0,173,0,8,0,109,0,8,0,237,0,8,0,29,0,8,0,157,0,8,0,93,0,8,0,221,0,8,0,61,0,8,0,189,0,8,0,125,0,8,0,253,0,8,0,19,0,9,0,19,1,9,0,147,0,9,0,147,1,9,0,83,0,9,0,83,1,9,0,211,0,9,0,211,1,9,0,51,0,9,0,51,1,9,0,179,0,9,0,179,1,9,0,115,0,9,0,115,1,9,0,243,0,9,0,243,1,9,0,11,0,9,0,11,1,9,0,139,0,9,0,139,1,9,0,75,0,9,0,75,1,9,0,203,0,9,0,203,1,
9,0,43,0,9,0,43,1,9,0,171,0,9,0,171,1,9,0,107,0,9,0,107,1,9,0,235,0,9,0,235,1,9,0,27,0,9,0,27,1,9,0,155,0,9,0,155,1,9,0,91,0,9,0,91,1,9,0,219,0,9,0,219,1,9,0,59,0,9,0,59,1,9,0,187,0,9,0,187,1,9,0,123,0,9,0,123,1,9,0,251,0,9,0,251,1,9,0,7,0,9,0,7,1,9,0,135,0,9,0,135,1,9,0,71,0,9,0,71,1,9,0,199,0,9,0,199,1,9,0,39,0,9,0,39,1,9,0,167,0,9,0,167,1,9,0,103,0,9,0,103,1,9,0,231,0,9,0,231,1,9,0,23,0,9,0,23,1,9,0,151,0,9,0,151,1,9,0,87,0,9,0,87,1,9,0,215,0,9,0,215,1,9,0,55,0,9,0,55,1,9,0,183,0,9,0,183,1,9,0,
119,0,9,0,119,1,9,0,247,0,9,0,247,1,9,0,15,0,9,0,15,1,9,0,143,0,9,0,143,1,9,0,79,0,9,0,79,1,9,0,207,0,9,0,207,1,9,0,47,0,9,0,47,1,9,0,175,0,9,0,175,1,9,0,111,0,9,0,111,1,9,0,239,0,9,0,239,1,9,0,31,0,9,0,31,1,9,0,159,0,9,0,159,1,9,0,95,0,9,0,95,1,9,0,223,0,9,0,223,1,9,0,63,0,9,0,63,1,9,0,191,0,9,0,191,1,9,0,127,0,9,0,127,1,9,0,255,0,9,0,255,1,9,0,0,0,7,0,64,0,7,0,32,0,7,0,96,0,7,0,16,0,7,0,80,0,7,0,48,0,7,0,112,0,7,0,8,0,7,0,72,0,7,0,40,0,7,0,104,0,7,0,24,0,7,0,88,0,7,0,56,0,7,0,120,0,7,0,4,0,7,0,
68,0,7,0,36,0,7,0,100,0,7,0,20,0,7,0,84,0,7,0,52,0,7,0,116,0,7,0,3,0,8,0,131,0,8,0,67,0,8,0,195,0,8,0,35,0,8,0,163,0,8,0,99,0,8,0,227,0,8,0,0,0,5,0,16,0,5,0,8,0,5,0,24,0,5,0,4,0,5,0,20,0,5,0,12,0,5,0,28,0,5,0,2,0,5,0,18,0,5,0,10,0,5,0,26,0,5,0,6,0,5,0,22,0,5,0,14,0,5,0,30,0,5,0,1,0,5,0,17,0,5,0,9,0,5,0,25,0,5,0,5,0,5,0,21,0,5,0,13,0,5,0,29,0,5,0,3,0,5,0,19,0,5,0,11,0,5,0,27,0,5,0,7,0,5,0,23,0,5,0,0,64,197,88,159,83,66,75,0,64,73,50,163,34,168,17,197,88,33,123,252,115,98,104,197,88,191,69,11,48,126,
24,159,83,252,115,65,109,84,98,159,83,179,65,65,45,18,23,66,75,98,104,84,98,126,88,66,75,33,59,186,40,195,20,0,64,197,88,159,83,66,75,0,64,73,50,163,34,168,17,73,50,191,69,179,65,33,59,73,50,130,39,55,27,224,13,163,34,11,48,65,45,186,40,163,34,55,27,191,18,142,9,168,17,126,24,18,23,195,20,168,17,224,13,142,9,223,4,112,115,101,117,100,111,45,0,84,73,70,70,83,101,116,70,105,101,108,100,0,37,115,58,32,85,110,107,110,111,119,110,32,37,115,116,97,103,32,37,117,0,37,115,58,32,67,97,110,110,111,116,32,109,
111,100,105,102,121,32,116,97,103,32,34,37,115,34,32,119,104,105,108,101,32,119,114,105,116,105,110,103,0,116,105,102,95,100,105,114,46,99,0,84,73,70,70,65,100,118,97,110,99,101,68,105,114,101,99,116,111,114,121,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,32,102,97,105,108,101,100,0,37,115,58,32,69,114,114,111,114,32,102,101,116,99,104,105,110,103,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,0,37,115,58,32,69,114,
114,111,114,32,102,101,116,99,104,105,110,103,32,100,105,114,101,99,116,111,114,121,32,108,105,110,107,0,95,84,73,70,70,86,71,101,116,70,105,101,108,100,0,37,115,58,32,73,110,118,97,108,105,100,32,37,115,116,97,103,32,34,37,115,34,32,40,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,99,111,100,101,99,41,0,116,118,45,62,99,111,117,110,116,32,61,61,32,49,0,78,111,110,115,116,97,110,100,97,114,100,32,116,105,108,101,32,119,105,100,116,104,32,37,100,44,32,99,111,110,118,101,114,116,32,
102,105,108,101,0,78,111,110,115,116,97,110,100,97,114,100,32,116,105,108,101,32,108,101,110,103,116,104,32,37,100,44,32,99,111,110,118,101,114,116,32,102,105,108,101,0,95,84,73,70,70,86,83,101,116,70,105,101,108,100,0,37,115,58,32,83,111,114,114,121,44,32,99,97,110,110,111,116,32,110,101,115,116,32,83,117,98,73,70,68,115,0,37,115,58,32,73,110,118,97,108,105,100,32,73,110,107,78,97,109,101,115,32,118,97,108,117,101,59,32,101,120,112,101,99,116,105,110,103,32,37,100,32,110,97,109,101,115,44,32,102,
111,117,110,100,32,37,100,0,37,115,58,32,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,115,112,97,99,101,32,102,111,114,32,108,105,115,116,32,111,102,32,99,117,115,116,111,109,32,118,97,108,117,101,115,0,37,115,58,32,66,97,100,32,102,105,101,108,100,32,116,121,112,101,32,37,100,32,102,111,114,32,34,37,115,34,0,102,105,112,45,62,102,105,101,108,100,95,119,114,105,116,101,99,111,117,110,116,61,61,84,73,70,70,95,86,65,82,73,65,66,76,69,50,0,37,115,58,32,78,117,108,108,32,99,111,
117,110,116,32,102,111,114,32,34,37,115,34,32,40,116,121,112,101,32,37,100,44,32,119,114,105,116,101,99,111,117,110,116,32,37,100,44,32,112,97,115,115,99,111,117,110,116,32,37,100,41,0,99,117,115,116,111,109,32,116,97,103,32,98,105,110,97,114,121,32,111,98,106,101,99,116,0,85,110,107,110,111,119,110,0,37,115,58,32,66,97,100,32,118,97,108,117,101,32,37,117,32,102,111,114,32,34,37,115,34,32,116,97,103,0,37,115,58,32,66,97,100,32,118,97,108,117,101,32,37,102,32,102,111,114,32,34,37,115,34,32,116,97,
103,0,84,97,103,32,0,95,84,73,70,70,83,101,116,117,112,70,105,101,108,100,115,0,83,101,116,116,105,110,103,32,117,112,32,102,105,101,108,100,32,105,110,102,111,32,102,97,105,108,101,100,0,102,111,114,32,102,105,101,108,100,115,32,97,114,114,97,121,0,95,84,73,70,70,77,101,114,103,101,70,105,101,108,100,115,0,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,102,105,101,108,100,115,32,97,114,114,97,121,0,84,73,70,70,70,105,101,108,100,87,105,116,104,84,97,103,0,73,110,116,101,114,
110,97,108,32,101,114,114,111,114,44,32,117,110,107,110,111,119,110,32,116,97,103,32,48,120,37,120,0,84,97,103,32,37,100,0,69,120,112,111,115,117,114,101,84,105,109,101,0,70,78,117,109,98,101,114,0,69,120,112,111,115,117,114,101,80,114,111,103,114,97,109,0,83,112,101,99,116,114,97,108,83,101,110,115,105,116,105,118,105,116,121,0,73,83,79,83,112,101,101,100,82,97,116,105,110,103,115,0,79,112,116,111,101,108,101,99,116,114,105,99,67,111,110,118,101,114,115,105,111,110,70,97,99,116,111,114,0,69,120,
105,102,86,101,114,115,105,111,110,0,68,97,116,101,84,105,109,101,79,114,105,103,105,110,97,108,0,68,97,116,101,84,105,109,101,68,105,103,105,116,105,122,101,100,0,67,111,109,112,111,110,101,110,116,115,67,111,110,102,105,103,117,114,97,116,105,111,110,0,67,111,109,112,114,101,115,115,101,100,66,105,116,115,80,101,114,80,105,120,101,108,0,83,104,117,116,116,101,114,83,112,101,101,100,86,97,108,117,101,0,65,112,101,114,116,117,114,101,86,97,108,117,101,0,66,114,105,103,104,116,110,101,115,115,86,97,
108,117,101,0,69,120,112,111,115,117,114,101,66,105,97,115,86,97,108,117,101,0,77,97,120,65,112,101,114,116,117,114,101,86,97,108,117,101,0,83,117,98,106,101,99,116,68,105,115,116,97,110,99,101,0,77,101,116,101,114,105,110,103,77,111,100,101,0,76,105,103,104,116,83,111,117,114,99,101,0,70,108,97,115,104,0,70,111,99,97,108,76,101,110,103,116,104,0,83,117,98,106,101,99,116,65,114,101,97,0,77,97,107,101,114,78,111,116,101,0,85,115,101,114,67,111,109,109,101,110,116,0,83,117,98,83,101,99,84,105,109,101,
0,83,117,98,83,101,99,84,105,109,101,79,114,105,103,105,110,97,108,0,83,117,98,83,101,99,84,105,109,101,68,105,103,105,116,105,122,101,100,0,70,108,97,115,104,112,105,120,86,101,114,115,105,111,110,0,67,111,108,111,114,83,112,97,99,101,0,80,105,120,101,108,88,68,105,109,101,110,115,105,111,110,0,80,105,120,101,108,89,68,105,109,101,110,115,105,111,110,0,82,101,108,97,116,101,100,83,111,117,110,100,70,105,108,101,0,70,108,97,115,104,69,110,101,114,103,121,0,83,112,97,116,105,97,108,70,114,101,113,
117,101,110,99,121,82,101,115,112,111,110,115,101,0,70,111,99,97,108,80,108,97,110,101,88,82,101,115,111,108,117,116,105,111,110,0,70,111,99,97,108,80,108,97,110,101,89,82,101,115,111,108,117,116,105,111,110,0,70,111,99,97,108,80,108,97,110,101,82,101,115,111,108,117,116,105,111,110,85,110,105,116,0,83,117,98,106,101,99,116,76,111,99,97,116,105,111,110,0,69,120,112,111,115,117,114,101,73,110,100,101,120,0,83,101,110,115,105,110,103,77,101,116,104,111,100,0,70,105,108,101,83,111,117,114,99,101,0,83,
99,101,110,101,84,121,112,101,0,67,70,65,80,97,116,116,101,114,110,0,67,117,115,116,111,109,82,101,110,100,101,114,101,100,0,69,120,112,111,115,117,114,101,77,111,100,101,0,87,104,105,116,101,66,97,108,97,110,99,101,0,68,105,103,105,116,97,108,90,111,111,109,82,97,116,105,111,0,70,111,99,97,108,76,101,110,103,116,104,73,110,51,53,109,109,70,105,108,109,0,83,99,101,110,101,67,97,112,116,117,114,101,84,121,112,101,0,71,97,105,110,67,111,110,116,114,111,108,0,67,111,110,116,114,97,115,116,0,83,97,116,
117,114,97,116,105,111,110,0,83,104,97,114,112,110,101,115,115,0,68,101,118,105,99,101,83,101,116,116,105,110,103,68,101,115,99,114,105,112,116,105,111,110,0,83,117,98,106,101,99,116,68,105,115,116,97,110,99,101,82,97,110,103,101,0,73,109,97,103,101,85,110,105,113,117,101,73,68,0,83,117,98,102,105,108,101,84,121,112,101,0,79,108,100,83,117,98,102,105,108,101,84,121,112,101,0,73,109,97,103,101,87,105,100,116,104,0,66,105,116,115,80,101,114,83,97,109,112,108,101,0,80,104,111,116,111,109,101,116,114,
105,99,73,110,116,101,114,112,114,101,116,97,116,105,111,110,0,84,104,114,101,115,104,104,111,108,100,105,110,103,0,67,101,108,108,87,105,100,116,104,0,67,101,108,108,76,101,110,103,116,104,0,70,105,108,108,79,114,100,101,114,0,68,111,99,117,109,101,110,116,78,97,109,101,0,73,109,97,103,101,68,101,115,99,114,105,112,116,105,111,110,0,77,97,107,101,0,77,111,100,101,108,0,79,114,105,101,110,116,97,116,105,111,110,0,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,0,82,111,119,115,80,101,114,
83,116,114,105,112,0,77,105,110,83,97,109,112,108,101,86,97,108,117,101,0,77,97,120,83,97,109,112,108,101,86,97,108,117,101,0,88,82,101,115,111,108,117,116,105,111,110,0,89,82,101,115,111,108,117,116,105,111,110,0,80,108,97,110,97,114,67,111,110,102,105,103,117,114,97,116,105,111,110,0,80,97,103,101,78,97,109,101,0,88,80,111,115,105,116,105,111,110,0,89,80,111,115,105,116,105,111,110,0,70,114,101,101,79,102,102,115,101,116,115,0,70,114,101,101,66,121,116,101,67,111,117,110,116,115,0,71,114,97,121,
82,101,115,112,111,110,115,101,85,110,105,116,0,71,114,97,121,82,101,115,112,111,110,115,101,67,117,114,118,101,0,82,101,115,111,108,117,116,105,111,110,85,110,105,116,0,80,97,103,101,78,117,109,98,101,114,0,67,111,108,111,114,82,101,115,112,111,110,115,101,85,110,105,116,0,84,114,97,110,115,102,101,114,70,117,110,99,116,105,111,110,0,83,111,102,116,119,97,114,101,0,68,97,116,101,84,105,109,101,0,65,114,116,105,115,116,0,72,111,115,116,67,111,109,112,117,116,101,114,0,87,104,105,116,101,80,111,105,
110,116,0,80,114,105,109,97,114,121,67,104,114,111,109,97,116,105,99,105,116,105,101,115,0,67,111,108,111,114,77,97,112,0,72,97,108,102,116,111,110,101,72,105,110,116,115,0,84,105,108,101,87,105,100,116,104,0,84,105,108,101,76,101,110,103,116,104,0,84,105,108,101,66,121,116,101,67,111,117,110,116,115,0,83,117,98,73,70,68,0,73,110,107,78,97,109,101,115,0,78,117,109,98,101,114,79,102,73,110,107,115,0,68,111,116,82,97,110,103,101,0,84,97,114,103,101,116,80,114,105,110,116,101,114,0,69,120,116,114,97,
83,97,109,112,108,101,115,0,83,97,109,112,108,101,70,111,114,109,97,116,0,83,77,105,110,83,97,109,112,108,101,86,97,108,117,101,0,83,77,97,120,83,97,109,112,108,101,86,97,108,117,101,0,67,108,105,112,80,97,116,104,0,88,67,108,105,112,80,97,116,104,85,110,105,116,115,0,89,67,108,105,112,80,97,116,104,85,110,105,116,115,0,89,67,98,67,114,67,111,101,102,102,105,99,105,101,110,116,115,0,89,67,98,67,114,83,117,98,115,97,109,112,108,105,110,103,0,89,67,98,67,114,80,111,115,105,116,105,111,110,105,110,103,
0,82,101,102,101,114,101,110,99,101,66,108,97,99,107,87,104,105,116,101,0,88,77,76,80,97,99,107,101,116,0,77,97,116,116,101,105,110,103,0,68,97,116,97,84,121,112,101,0,73,109,97,103,101,68,101,112,116,104,0,84,105,108,101,68,101,112,116,104,0,73,109,97,103,101,70,117,108,108,87,105,100,116,104,0,73,109,97,103,101,70,117,108,108,76,101,110,103,116,104,0,84,101,120,116,117,114,101,70,111,114,109,97,116,0,84,101,120,116,117,114,101,87,114,97,112,77,111,100,101,115,0,70,105,101,108,100,79,102,86,105,
101,119,67,111,116,97,110,103,101,110,116,0,77,97,116,114,105,120,87,111,114,108,100,84,111,83,99,114,101,101,110,0,77,97,116,114,105,120,87,111,114,108,100,84,111,67,97,109,101,114,97,0,67,70,65,82,101,112,101,97,116,80,97,116,116,101,114,110,68,105,109,0,67,111,112,121,114,105,103,104,116,0,82,105,99,104,84,73,70,70,73,80,84,67,0,80,104,111,116,111,115,104,111,112,0,69,88,73,70,73,70,68,79,102,102,115,101,116,0,73,67,67,32,80,114,111,102,105,108,101,0,71,80,83,73,70,68,79,102,102,115,101,116,0,
70,97,120,82,101,99,118,80,97,114,97,109,115,0,70,97,120,83,117,98,65,100,100,114,101,115,115,0,70,97,120,82,101,99,118,84,105,109,101,0,70,97,120,68,99,115,0,83,116,111,78,105,116,115,0,73,110,116,101,114,111,112,101,114,97,98,105,108,105,116,121,73,70,68,79,102,102,115,101,116,0,68,78,71,86,101,114,115,105,111,110,0,68,78,71,66,97,99,107,119,97,114,100,86,101,114,115,105,111,110,0,85,110,105,113,117,101,67,97,109,101,114,97,77,111,100,101,108,0,76,111,99,97,108,105,122,101,100,67,97,109,101,114,
97,77,111,100,101,108,0,67,70,65,80,108,97,110,101,67,111,108,111,114,0,67,70,65,76,97,121,111,117,116,0,76,105,110,101,97,114,105,122,97,116,105,111,110,84,97,98,108,101,0,66,108,97,99,107,76,101,118,101,108,82,101,112,101,97,116,68,105,109,0,66,108,97,99,107,76,101,118,101,108,0,66,108,97,99,107,76,101,118,101,108,68,101,108,116,97,72,0,66,108,97,99,107,76,101,118,101,108,68,101,108,116,97,86,0,87,104,105,116,101,76,101,118,101,108,0,68,101,102,97,117,108,116,83,99,97,108,101,0,66,101,115,116,81,
117,97,108,105,116,121,83,99,97,108,101,0,68,101,102,97,117,108,116,67,114,111,112,79,114,105,103,105,110,0,68,101,102,97,117,108,116,67,114,111,112,83,105,122,101,0,67,111,108,111,114,77,97,116,114,105,120,49,0,67,111,108,111,114,77,97,116,114,105,120,50,0,67,97,109,101,114,97,67,97,108,105,98,114,97,116,105,111,110,49,0,67,97,109,101,114,97,67,97,108,105,98,114,97,116,105,111,110,50,0,82,101,100,117,99,116,105,111,110,77,97,116,114,105,120,49,0,82,101,100,117,99,116,105,111,110,77,97,116,114,105,
120,50,0,65,110,97,108,111,103,66,97,108,97,110,99,101,0,65,115,83,104,111,116,78,101,117,116,114,97,108,0,65,115,83,104,111,116,87,104,105,116,101,88,89,0,66,97,115,101,108,105,110,101,69,120,112,111,115,117,114,101,0,66,97,115,101,108,105,110,101,78,111,105,115,101,0,66,97,115,101,108,105,110,101,83,104,97,114,112,110,101,115,115,0,66,97,121,101,114,71,114,101,101,110,83,112,108,105,116,0,76,105,110,101,97,114,82,101,115,112,111,110,115,101,76,105,109,105,116,0,67,97,109,101,114,97,83,101,114,105,
97,108,78,117,109,98,101,114,0,76,101,110,115,73,110,102,111,0,67,104,114,111,109,97,66,108,117,114,82,97,100,105,117,115,0,65,110,116,105,65,108,105,97,115,83,116,114,101,110,103,116,104,0,83,104,97,100,111,119,83,99,97,108,101,0,68,78,71,80,114,105,118,97,116,101,68,97,116,97,0,77,97,107,101,114,78,111,116,101,83,97,102,101,116,121,0,67,97,108,105,98,114,97,116,105,111,110,73,108,108,117,109,105,110,97,110,116,49,0,67,97,108,105,98,114,97,116,105,111,110,73,108,108,117,109,105,110,97,110,116,50,
0,82,97,119,68,97,116,97,85,110,105,113,117,101,73,68,0,79,114,105,103,105,110,97,108,82,97,119,70,105,108,101,78,97,109,101,0,79,114,105,103,105,110,97,108,82,97,119,70,105,108,101,68,97,116,97,0,65,99,116,105,118,101,65,114,101,97,0,77,97,115,107,101,100,65,114,101,97,115,0,65,115,83,104,111,116,73,67,67,80,114,111,102,105,108,101,0,65,115,83,104,111,116,80,114,101,80,114,111,102,105,108,101,77,97,116,114,105,120,0,67,117,114,114,101,110,116,73,67,67,80,114,111,102,105,108,101,0,67,117,114,114,
101,110,116,80,114,101,80,114,111,102,105,108,101,77,97,116,114,105,120,0,80,101,114,83,97,109,112,108,101,0,73,110,100,101,120,101,100,0,71,108,111,98,97,108,80,97,114,97,109,101,116,101,114,115,73,70,68,0,80,114,111,102,105,108,101,84,121,112,101,0,70,97,120,80,114,111,102,105,108,101,0,67,111,100,105,110,103,77,101,116,104,111,100,115,0,86,101,114,115,105,111,110,89,101,97,114,0,77,111,100,101,78,117,109,98,101,114,0,68,101,99,111,100,101,0,73,109,97,103,101,66,97,115,101,67,111,108,111,114,0,
84,56,50,79,112,116,105,111,110,115,0,83,116,114,105,112,82,111,119,67,111,117,110,116,115,0,73,109,97,103,101,76,97,121,101,114,0,84,73,70,70,67,104,101,99,107,68,105,114,79,102,102,115,101,116,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,109,111,114,101,32,116,104,97,110,32,54,53,53,51,53,32,84,73,70,70,32,100,105,114,101,99,116,111,114,105,101,115,0,102,111,114,32,73,70,68,32,108,105,115,116,0,84,73,70,70,82,101,97,100,68,105,114,101,99,116,111,114,121,0,70,97,105,108,101,100,32,116,111,
32,114,101,97,100,32,100,105,114,101,99,116,111,114,121,32,97,116,32,111,102,102,115,101,116,32,37,108,117,0,84,73,70,70,82,101,97,100,68,105,114,101,99,116,111,114,121,67,104,101,99,107,79,114,100,101,114,0,73,110,118,97,108,105,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,59,32,116,97,103,115,32,97,114,101,32,110,111,116,32,115,111,114,116,101,100,32,105,110,32,97,115,99,101,110,100,105,110,103,32,111,114,100,101,114,0,85,110,107,110,111,119,110,32,102,105,101,108,100,32,119,105,116,
104,32,116,97,103,32,37,100,32,40,48,120,37,120,41,32,101,110,99,111,117,110,116,101,114,101,100,0,82,101,103,105,115,116,101,114,105,110,103,32,97,110,111,110,121,109,111,117,115,32,102,105,101,108,100,32,119,105,116,104,32,116,97,103,32,37,100,32,40,48,120,37,120,41,32,102,97,105,108,101,100,0,102,105,105,32,33,61,32,70,65,73,76],"i8",4,ra.GLOBAL_BASE+122916);vc([69,68,95,70,73,73,0,116,105,102,95,100,105,114,114,101,97,100,46,99,0,80,108,97,110,97,114,99,111,110,102,105,103,32,116,97,103,32,118,
97,108,117,101,32,97,115,115,117,109,101,100,32,105,110,99,111,114,114,101,99,116,44,32,97,115,115,117,109,105,110,103,32,100,97,116,97,32,105,115,32,99,111,110,116,105,103,32,105,110,115,116,101,97,100,32,111,102,32,99,104,117,110,107,121,0,77,105,115,115,105,110,103,82,101,113,117,105,114,101,100,0,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,105,115,32,109,105,115,115,105,110,103,32,114,101,113,117,105,114,101,100,32,34,37,115,34,32,102,105,101,108,100,0,73,109,97,103,101,76,101,110,103,
116,104,0,116,105,108,101,115,0,115,116,114,105,112,115,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,122,101,114,111,32,110,117,109,98,101,114,32,111,102,32,37,115,0,84,105,108,101,79,102,102,115,101,116,115,0,83,116,114,105,112,79,102,102,115,101,116,115,0,117,110,107,110,111,119,110,32,116,97,103,110,97,109,101,0,73,103,110,111,114,105,110,103,32,37,115,32,115,105,110,99,101,32,66,105,116,115,80,101,114,83,97,109,112,108,101,32,116,97,103,32,110,111,116,32,102,111,117,110,100,0,80,104,111,
116,111,109,101,116,114,105,99,32,116,97,103,32,105,115,32,109,105,115,115,105,110,103,44,32,97,115,115,117,109,105,110,103,32,100,97,116,97,32,105,115,32,89,67,98,67,114,0,80,104,111,116,111,109,101,116,114,105,99,32,116,97,103,32,118,97,108,117,101,32,97,115,115,117,109,101,100,32,105,110,99,111,114,114,101,99,116,44,32,97,115,115,117,109,105,110,103,32,100,97,116,97,32,105,115,32,89,67,98,67,114,32,105,110,115,116,101,97,100,32,111,102,32,82,71,66,0,66,105,116,115,80,101,114,83,97,109,112,108,
101,32,116,97,103,32,105,115,32,109,105,115,115,105,110,103,44,32,97,115,115,117,109,105,110,103,32,56,32,98,105,116,115,32,112,101,114,32,115,97,109,112,108,101,0,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,32,116,97,103,32,105,115,32,109,105,115,115,105,110,103,44,32,97,115,115,117,109,105,110,103,32,99,111,114,114,101,99,116,32,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,32,118,97,108,117,101,32,105,115,32,51,0,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,32,
116,97,103,32,105,115,32,109,105,115,115,105,110,103,44,32,97,112,112,108,121,105,110,103,32,99,111,114,114,101,99,116,32,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,32,118,97,108,117,101,32,111,102,32,51,0,67,111,108,111,114,109,97,112,0,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,0,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,105,115,32,109,105,115,115,105,110,103,32,114,101,113,117,105,114,101,100,32,34,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,34,
32,102,105,101,108,100,44,32,99,97,108,99,117,108,97,116,105,110,103,32,102,114,111,109,32,105,109,97,103,101,108,101,110,103,116,104,0,66,111,103,117,115,32,34,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,34,32,102,105,101,108,100,44,32,105,103,110,111,114,105,110,103,32,97,110,100,32,99,97,108,99,117,108,97,116,105,110,103,32,102,114,111,109,32,105,109,97,103,101,108,101,110,103,116,104,0,87,114,111,110,103,32,34,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,34,32,102,105,
101,108,100,44,32,105,103,110,111,114,105,110,103,32,97,110,100,32,99,97,108,99,117,108,97,116,105,110,103,32,102,114,111,109,32,105,109,97,103,101,108,101,110,103,116,104,0,102,111,114,32,99,104,111,112,112,101,100,32,34,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,34,32,97,114,114,97,121,0,102,111,114,32,99,104,111,112,112,101,100,32,34,83,116,114,105,112,79,102,102,115,101,116,115,34,32,97,114,114,97,121,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,122,101,114,111,32,115,99,
97,110,108,105,110,101,32,115,105,122,101,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,122,101,114,111,32,116,105,108,101,32,115,105,122,101,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,122,101,114,111,32,115,116,114,105,112,32,115,105,122,101,0,102,111,114,32,34,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,34,32,97,114,114,97,121,0,69,115,116,105,109,97,116,101,83,116,114,105,112,66,121,116,101,67,111,117,110,116,115,0,67,97,110,110,111,116,32,100,101,116,101,114,109,
105,110,101,32,115,105,122,101,32,111,102,32,117,110,107,110,111,119,110,32,116,97,103,32,116,121,112,101,32,37,100,0,84,73,70,70,70,101,116,99,104,83,116,114,105,112,84,104,105,110,103,0,102,111,114,32,115,116,114,105,112,32,97,114,114,97,121,0,40,116,109,115,105,122,101,95,116,41,100,97,116,97,115,105,122,101,62,48,0,84,73,70,70,82,101,97,100,68,105,114,69,110,116,114,121,65,114,114,97,121,0,82,101,97,100,68,105,114,69,110,116,114,121,65,114,114,97,121,0,73,110,99,111,114,114,101,99,116,32,99,111,
117,110,116,32,102,111,114,32,34,37,115,34,0,73,110,99,111,109,112,97,116,105,98,108,101,32,116,121,112,101,32,102,111,114,32,34,37,115,34,0,73,79,32,101,114,114,111,114,32,100,117,114,105,110,103,32,114,101,97,100,105,110,103,32,111,102,32,34,37,115,34,0,73,110,99,111,114,114,101,99,116,32,118,97,108,117,101,32,102,111,114,32,34,37,115,34,0,67,97,110,110,111,116,32,104,97,110,100,108,101,32,100,105,102,102,101,114,101,110,116,32,118,97,108,117,101,115,32,112,101,114,32,115,97,109,112,108,101,32,
102,111,114,32,34,37,115,34,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,115,105,122,101,32,111,102,32,34,37,115,34,32,118,97,108,117,101,32,102,97,105,108,101,100,0,79,117,116,32,111,102,32,109,101,109,111,114,121,32,114,101,97,100,105,110,103,32,111,102,32,34,37,115,34,0,84,73,70,70,82,101,97,100,68,105,114,69,110,116,114,121,79,117,116,112,117,116,69,114,114,0,73,110,99,111,114,114,101,99,116,32,99,111,117,110,116,32,102,111,114,32,34,37,115,34,59,32,116,97,103,32,105,103,110,111,
114,101,100,0,73,110,99,111,109,112,97,116,105,98,108,101,32,116,121,112,101,32,102,111,114,32,34,37,115,34,59,32,116,97,103,32,105,103,110,111,114,101,100,0,73,79,32,101,114,114,111,114,32,100,117,114,105,110,103,32,114,101,97,100,105,110,103,32,111,102,32,34,37,115,34,59,32,116,97,103,32,105,103,110,111,114,101,100,0,73,110,99,111,114,114,101,99,116,32,118,97,108,117,101,32,102,111,114,32,34,37,115,34,59,32,116,97,103,32,105,103,110,111,114,101,100,0,67,97,110,110,111,116,32,104,97,110,100,108,
101,32,100,105,102,102,101,114,101,110,116,32,118,97,108,117,101,115,32,112,101,114,32,115,97,109,112,108,101,32,102,111,114,32,34,37,115,34,59,32,116,97,103,32,105,103,110,111,114,101,100,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,115,105,122,101,32,111,102,32,34,37,115,34,32,118,97,108,117,101,32,102,97,105,108,101,100,59,32,116,97,103,32,105,103,110,111,114,101,100,0,79,117,116,32,111,102,32,109,101,109,111,114,121,32,114,101,97,100,105,110,103,32,111,102,32,34,37,115,34,59,32,
116,97,103,32,105,103,110,111,114,101,100,0,84,73,70,70,70,101,116,99,104,78,111,114,109,97,108,84,97,103,0,78,111,32,100,101,102,105,110,105,116,105,111,110,32,102,111,117,110,100,32,102,111,114,32,116,97,103,32,37,100,0,102,105,112,32,33,61,32,78,85,76,76,0,102,105,112,45,62,115,101,116,95,102,105,101,108,100,95,116,121,112,101,33,61,84,73,70,70,95,83,69,84,71,69,84,95,79,84,72,69,82,0,102,105,112,45,62,115,101,116,95,102,105,101,108,100,95,116,121,112,101,33,61,84,73,70,70,95,83,69,84,71,69,84,
95,73,78,84,0,102,105,112,45,62,102,105,101,108,100,95,112,97,115,115,99,111,117,110,116,61,61,48,0,65,83,67,73,73,32,118,97,108,117,101,32,102,111,114,32,116,97,103,32,34,37,115,34,32,99,111,110,116,97,105,110,115,32,110,117,108,108,32,98,121,116,101,32,105,110,32,118,97,108,117,101,59,32,118,97,108,117,101,32,105,110,99,111,114,114,101,99,116,108,121,32,116,114,117,110,99,97,116,101,100,32,100,117,114,105,110,103,32,114,101,97,100,105,110,103,32,100,117,101,32,116,111,32,105,109,112,108,101,109,
101,110,116,97,116,105,111,110,32,108,105,109,105,116,97,116,105,111,110,115,0,65,83,67,73,73,32,118,97,108,117,101,32,102,111,114,32,116,97,103,32,34,37,115,34,32,100,111,101,115,32,110,111,116,32,101,110,100,32,105,110,32,110,117,108,108,32,98,121,116,101,0,102,105,112,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,49,0,102,105,112,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,50,0,105,110,99,111,114,114,101,99,116,32,99,111,117,110,116,32,102,111,114,
32,102,105,101,108,100,32,34,37,115,34,44,32,101,120,112,101,99,116,101,100,32,50,44,32,103,111,116,32,37,100,0,102,105,112,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,62,61,49,0,105,110,99,111,114,114,101,99,116,32,99,111,117,110,116,32,102,111,114,32,102,105,101,108,100,32,34,37,115,34,44,32,101,120,112,101,99,116,101,100,32,37,100,44,32,103,111,116,32,37,100,0,102,105,112,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,84,73,70,70,95,86,65,82,73,65,66,76,
69,0,102,105,112,45,62,102,105,101,108,100,95,112,97,115,115,99,111,117,110,116,61,61,49,0,102,105,112,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,84,73,70,70,95,86,65,82,73,65,66,76,69,50,0,112,100,105,114,0,84,73,70,70,70,101,116,99,104,68,105,114,101,99,116,111,114,121,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,32,102,97,105,108,101,100,44,32,116,104,105,115,32,105,115,32,112,114,111,98,97,98,108,
121,32,110,111,116,32,97,32,118,97,108,105,100,32,73,70,68,32,111,102,102,115,101,116,0,116,111,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,0,37,46,49,48,48,115,58,32,67,97,110,32,110,111,116,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,0,67,97,110,32,110,111,116,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,100,105,114,101,99,116,111,114,121,
32,99,111,117,110,116,32,102,97,105,108,101,100,44,32,122,101,114,111,32,116,97,103,32,100,105,114,101,99,116,111,114,105,101,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,67,97,110,32,110,111,116,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,0,83,111,114,114,121,44,32,114,101,113,117,101,115,116,101,100,32,99,111,109,112,114,101,115,115,105,111,110,32,109,101,116,104,111,100,32,105,115,32,110,111,116,32,99,111,110,102,105,103,117,114,101,100,0,83,111,114,114,
121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,105,109,97,103,101,115,32,119,105,116,104,32,37,100,45,98,105,116,32,115,97,109,112,108,101,115,0,77,105,115,115,105,110,103,32,110,101,101,100,101,100,32,37,115,32,116,97,103,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,99,111,110,116,105,103,117,111,117,115,32,100,97,116,97,32,119,105,116,104,32,37,115,61,37,100,44,32,97,110,100,32,37,115,61,37,100,32,97,110,100,32,66,105,116,115,47,83,97,109,112,
108,101,61,37,100,0,83,97,109,112,108,101,115,47,112,105,120,101,108,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,82,71,66,32,105,109,97,103,101,32,119,105,116,104,32,37,115,61,37,100,0,67,111,108,111,114,32,99,104,97,110,110,101,108,115,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,115,101,112,97,114,97,116,101,100,32,105,109,97,103,101,32,119,105,116,104,32,37,115,61,37,100,0,73,110,107,83,101,116,0,83,111,114,114,121,44,32,
76,111,103,76,32,100,97,116,97,32,109,117,115,116,32,104,97,118,101,32,37,115,61,37,100,0,67,111,109,112,114,101,115,115,105,111,110,0,83,111,114,114,121,44,32,76,111,103,76,117,118,32,100,97,116,97,32,109,117,115,116,32,104,97,118,101,32,37,115,61,37,100,32,111,114,32,37,100,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,76,111,103,76,117,118,32,105,109,97,103,101,115,32,119,105,116,104,32,37,115,61,37,100,0,80,108,97,110,97,114,99,111,110,102,105,103,117,114,97,
116,105,111,110,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,105,109,97,103,101,32,119,105,116,104,32,37,115,61,37,100,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,105,109,97,103,101,32,119,105,116,104,32,37,115,61,37,100,32,97,110,100,32,37,115,61,37,100,0,66,105,116,115,47,115,97,109,112,108,101,0,77,105,115,115,105,110,103,32,114,101,113,117,105,114,101,100,32,34,67,111,108,111,114,109,97,112,34,32,116,97,103,0,79,117,116,
32,111,102,32,109,101,109,111,114,121,32,102,111,114,32,99,111,108,111,114,109,97,112,32,99,111,112,121,0,105,109,103,45,62,85,97,84,111,65,97,61,61,78,85,76,76,0,116,105,102,95,103,101,116,105,109,97,103,101,46,99,0,66,117,105,108,100,77,97,112,85,97,84,111,65,97,0,105,109,103,45,62,66,105,116,100,101,112,116,104,49,54,84,111,56,61,61,78,85,76,76,0,66,117,105,108,100,77,97,112,66,105,116,100,101,112,116,104,49,54,84,111,56,0,105,110,105,116,67,73,69,76,97,98,67,111,110,118,101,114,115,105,111,110,
0,78,111,32,115,112,97,99,101,32,102,111,114,32,67,73,69,32,76,42,97,42,98,42,45,62,82,71,66,32,99,111,110,118,101,114,115,105,111,110,32,115,116,97,116,101,46,0,70,97,105,108,101,100,32,116,111,32,105,110,105,116,105,97,108,105,122,101,32,67,73,69,32,76,42,97,42,98,42,45,62,82,71,66,32,99,111,110,118,101,114,115,105,111,110,32,115,116,97,116,101,46,0,83,111,114,114,121,44,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,105,109,97,103,101,0,78,111,32,34,103,101,116,34,32,114,111,117,116,
105,110,101,32,115,101,116,117,112,0,78,111,32,34,112,117,116,34,32,114,111,117,116,105,110,101,32,115,101,116,117,112,108,59,32,112,114,111,98,97,98,108,121,32,99,97,110,32,110,111,116,32,104,97,110,100,108,101,32,105,109,97,103,101,32,102,111,114,109,97,116,0,103,116,83,116,114,105,112,83,101,112,97,114,97,116,101,0,78,111,32,115,112,97,99,101,32,102,111,114,32,116,105,108,101,32,98,117,102,102,101,114,0,103,116,84,105,108,101,83,101,112,97,114,97,116,101,0,105,110,105,116,89,67,98,67,114,67,111,
110,118,101,114,115,105,111,110,0,78,111,32,115,112,97,99,101,32,102,111,114,32,89,67,98,67,114,45,62,82,71,66,32,99,111,110,118,101,114,115,105,111,110,32,115,116,97,116,101,0,78,111,32,115,112,97,99,101,32,102,111,114,32,112,104,111,116,111,109,101,116,114,105,99,32,99,111,110,118,101,114,115,105,111,110,32,116,97,98,108,101,0,78,111,32,115,112,97,99,101,32,102,111,114,32,66,38,87,32,109,97,112,112,105,110,103,32,116,97,98,108,101,0,65,115,115,117,109,105,110,103,32,56,45,98,105,116,32,99,111,108,
111,114,109,97,112,0,78,111,32,115,112,97,99,101,32,102,111,114,32,80,97,108,101,116,116,101,32,109,97,112,112,105,110,103,32,116,97,98,108,101,0,73,110,118,97,108,105,100,32,118,101,114,116,105,99,97,108,32,89,67,98,67,114,32,115,117,98,115,97,109,112,108,105,110,103,0,78,111,32,115,112,97,99,101,32,102,111,114,32,115,116,114,105,112,32,98,117,102,102,101,114,0,34,37,115,34,58,32,66,97,100,32,109,111,100,101,0,84,73,70,70,67,108,105,101,110,116,79,112,101,110,0,37,115,58,32,79,117,116,32,111,102,
32,109,101,109,111,114,121,32,40,84,73,70,70,32,115,116,114,117,99,116,117,114,101,41,0,79,110,101,32,111,102,32,116,104,101,32,99,108,105,101,110,116,32,112,114,111,99,101,100,117,114,101,115,32,105,115,32,78,85,76,76,32,112,111,105,110,116,101,114,46,0,67,97,110,110,111,116,32,114,101,97,100,32,84,73,70,70,32,104,101,97,100,101,114,0,78,111,116,32,97,32,84,73,70,70,32,111,114,32,77,68,73,32,102,105,108,101,44,32,98,97,100,32,109,97,103,105,99,32,110,117,109,98,101,114,32,37,100,32,40,48,120,37,
120,41,0,78,111,116,32,97,32,84,73,70,70,32,102,105,108,101,44,32,98,97,100,32,118,101,114,115,105,111,110,32,110,117,109,98,101,114,32,37,100,32,40,48,120,37,120,41,0,78,111,116,32,97,32,84,73,70,70,32,102,105,108,101,44,32,98,97,100,32,66,105,103,84,73,70,70,32,111,102,102,115,101,116,115,105,122,101,32,37,100,32,40,48,120,37,120,41,0,78,111,116,32,97,32,84,73,70,70,32,102,105,108,101,44,32,98,97,100,32,66,105,103,84,73,70,70,32,117,110,117,115,101,100,32,37,100,32,40,48,120,37,120,41,0,40,116,
111,102,102,95,116,41,116,105,102,45,62,116,105,102,95,115,105,122,101,61,61,110,0,116,105,102,95,111,112,101,110,46,99,0,70,105,108,101,32,110,111,116,32,111,112,101,110,32,102,111,114,32,114,101,97,100,105,110,103,0,67,97,110,32,110,111,116,32,114,101,97,100,32,115,99,97,110,108,105,110,101,115,32,102,114,111,109,32,97,32,116,105,108,101,100,32,105,109,97,103,101,0,40,116,105,102,45,62,116,105,102,95,102,108,97,103,115,38,84,73,70,70,95,78,79,82,69,65,68,82,65,87,41,61,61,48,0,116,105,102,95,114,
101,97,100,46,99,0,84,73,70,70,82,101,97,100,66,117,102,102,101,114,83,101,116,117,112,0,73,110,118,97,108,105,100,32,98,117,102,102,101,114,32,115,105,122,101,0,83,101,101,107,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,44,32,115,116,114,105,112,32,37,108,117,0,82,101,97,100,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,59,32,103,111,116,32,37,108,108,117,32,98,121,116,101,115,44,32,101,120,112,101,99,116,101,100,32,37,108,108,
117,0,84,73,70,70,82,101,97,100,69,110,99,111,100,101,100,83,116,114,105,112,0,37,108,117,58,32,83,116,114,105,112,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,0,84,73,70,70,70,105,108,108,83,116,114,105,112,0,73,110,118,97,108,105,100,32,115,116,114,105,112,32,98,121,116,101,32,99,111,117,110,116,32,37,108,108,117,44,32,115,116,114,105,112,32,37,108,117,0,82,101,97,100,32,101,114,114,111,114,32,111,110,32,115,116,114,105,112,32,37,108,117,59,32,103,111,116,32,37,
108,108,117,32,98,121,116,101,115,44,32,101,120,112,101,99,116,101,100,32,37,108,108,117,0,68,97,116,97,32,98,117,102,102,101,114,32,116,111,111,32,115,109,97,108,108,32,116,111,32,104,111,108,100,32,115,116,114,105,112,32,37,108,117,0,78,111,32,115,112,97,99,101,32,102,111,114,32,100,97,116,97,32,98,117,102,102,101,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,0,67,97,110,32,110,111,116,32,114,101,97,100,32,116,105,108,101,115,32,102,114,111,109,32,97,32,115,116,114,105,112,112,101,
100,32,105,109,97,103,101,0,84,73,70,70,82,101,97,100,69,110,99,111,100,101,100,84,105,108,101,0,37,108,117,58,32,84,105,108,101,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,0,84,73,70,70,70,105,108,108,84,105,108,101,0,37,108,108,117,58,32,73,110,118,97,108,105,100,32,116,105,108,101,32,98,121,116,101,32,99,111,117,110,116,44,32,116,105,108,101,32,37,108,117,0,68,97,116,97,32,98,117,102,102,101,114,32,116,111,111,32,115,109,97,108,108,32,116,111,32,104,111,108,100,
32,116,105,108,101,32,37,108,117,0,84,73,70,70,83,116,97,114,116,84,105,108,101,0,90,101,114,111,32,116,105,108,101,115,0,40,99,99,32,38,32,49,41,32,61,61,32,48,0,95,84,73,70,70,83,119,97,98,49,54,66,105,116,68,97,116,97,0,40,99,99,32,37,32,51,41,32,61,61,32,48,0,95,84,73,70,70,83,119,97,98,50,52,66,105,116,68,97,116,97,0,40,99,99,32,38,32,51,41,32,61,61,32,48,0,95,84,73,70,70,83,119,97,98,51,50,66,105,116,68,97,116,97,0,40,99,99,32,38,32,55,41,32,61,61,32,48,0,95,84,73,70,70,83,119,97,98,54,52,66,
105,116,68,97,116,97,0,84,73,70,70,82,101,97,100,82,97,119,84,105,108,101,49,0,83,101,101,107,32,101,114,114,111,114,32,97,116,32,114,111,119,32,37,108,117,44,32,99,111,108,32,37,108,117,44,32,116,105,108,101,32,37,108,117,0,82,101,97,100,32,101,114,114,111,114,32,97,116,32,114,111,119,32,37,108,117,44,32,99,111,108,32,37,108,117,59,32,103,111,116,32,37,108,108,117,32,98,121,116,101,115,44,32,101,120,112,101,99,116,101,100,32,37,108,108,117,0,82,101,97,100,32,101,114,114,111,114,32,97,116,32,114,
111,119,32,37,108,117,44,32,99,111,108,32,37,108,117,44,32,116,105,108,101,32,37,108,117,59,32,103,111,116,32,37,108,108,117,32,98,121,116,101,115,44,32,101,120,112,101,99,116,101,100,32,37,108,108,117,0,84,73,70,70,82,101,97,100,82,97,119,83,116,114,105,112,49,0,82,101,97,100,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,44,32,115,116,114,105,112,32,37,108,117,59,32,103,111,116,32,37,108,108,117,32,98,121,116,101,115,44,32,101,120,112,101,99,116,101,100,32,37,108,
108,117,0,84,73,70,70,67,111,109,112,117,116,101,83,116,114,105,112,0,84,73,70,70,78,117,109,98,101,114,79,102,83,116,114,105,112,115,0,84,73,70,70,86,83,116,114,105,112,83,105,122,101,54,52,0,73,110,118,97,108,105,100,32,116,100,95,115,97,109,112,108,101,115,112,101,114,112,105,120,101,108,32,118,97,108,117,101,0,84,73,70,70,83,99,97,110,108,105,110,101,83,105,122,101,54,52,0,73,110,118,97,108,105,100,32,89,67,98,67,114,32,115,117,98,115,97,109,112,108,105,110,103,0,67,111,109,112,117,116,101,100,
32,115,99,97,110,108,105,110,101,32,115,105,122,101,32,105,115,32,122,101,114,111,0,84,73,70,70,86,83,116,114,105,112,83,105,122,101,0,84,73,70,70,83,116,114,105,112,83,105,122,101,0,84,73,70,70,83,99,97,110,108,105,110,101,83,105,122,101,0,73,110,116,101,103,101,114,32,97,114,105,116,104,109,101,116,105,99,32,111,118,101,114,102,108,111,119,0,0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,
52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,
29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,
85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,
214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,37,108,117,58,32,67,111,108,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,0,37,108,117,58,32,82,111,119,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,0,37,108,117,58,32,68,101,112,116,104,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,
0,37,108,117,58,32,83,97,109,112,108,101,32,111,117,116,32,111,102,32,114,97,110,103,101,44,32,109,97,120,32,37,108,117,0,84,73,70,70,78,117,109,98,101,114,79,102,84,105,108,101,115,0,84,73,70,70,84,105,108,101,82,111,119,83,105,122,101,54,52,0,84,105,108,101,32,108,101,110,103,116,104,32,105,115,32,122,101,114,111,0,84,105,108,101,32,119,105,100,116,104,32,105,115,32,122,101,114,111,0,84,73,70,70,84,105,108,101,82,111,119,83,105,122,101,0,83,97,109,112,108,101,115,32,112,101,114,32,112,105,120,101,
108,32,105,115,32,122,101,114,111,0,67,111,109,112,117,116,101,100,32,116,105,108,101,32,114,111,119,32,115,105,122,101,32,105,115,32,122,101,114,111,0,73,110,116,101,103,101,114,32,111,118,101,114,102,108,111,119,0,84,73,70,70,86,84,105,108,101,83,105,122,101,54,52,0,73,110,118,97,108,105,100,32,89,67,98,67,114,32,115,117,98,115,97,109,112,108,105,110,103,32,40,37,100,120,37,100,41,0,84,73,70,70,84,105,108,101,83,105,122,101,0,116,100,45,62,116,100,95,110,115,116,114,105,112,115,32,62,32,48,0,116,
105,102,95,119,114,105,116,101,46,99,0,84,73,70,70,65,112,112,101,110,100,84,111,83,116,114,105,112,0,83,101,101,107,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,0,87,114,105,116,101,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,0,84,73,70,70,79,112,101,110,0,37,115,58,32,37,115,0,37,115,58,32,67,97,110,110,111,116,32,111,112,101,110,0,37,115,58,32,0,46,10,0,87,97,114,110,105,110,103,44,32,0,73,110,116,101,103,101,114,32,111,118,
101,114,102,108,111,119,32,105,110,32,37,115,0,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,32,102,111,114,32,37,115,32,40,37,108,100,32,101,108,101,109,101,110,116,115,32,111,102,32,37,108,100,32,98,121,116,101,115,32,101,97,99,104,41,0,78,111,32,115,112,97,99,101,32,102,111,114,32,34,84,114,97,110,115,102,101,114,70,117,110,99,116,105,111,110,34,32,116,97,103,0,37,115,32,37,115,32,101,110,99,111,100,105,110,103,32,105,115,32,110,111,116,32,105,109,
112,108,101,109,101,110,116,101,100,0,115,99,97,110,108,105,110,101,0,67,111,109,112,114,101,115,115,105,111,110,32,115,99,104,101,109,101,32,37,117,32,37,115,32,101,110,99,111,100,105,110,103,32,105,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,37,115,32,37,115,32,100,101,99,111,100,105,110,103,32,105,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,67,111,109,112,114,101,115,115,105,111,110,32,115,99,104,101,109,101,32,37,117,32,37,115,32,100,101,99,111,
100,105,110,103,32,105,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,67,111,109,112,114,101,115,115,105,111,110,32,97,108,103,111,114,105,116,104,109,32,100,111,101,115,32,110,111,116,32,115,117,112,112,111,114,116,32,114,97,110,100,111,109,32,97,99,99,101,115,115,0,69,114,114,111,114,32,117,112,100,97,116,105,110,103,32,84,73,70,70,32,104,101,97,100,101,114,0,84,73,70,70,82,101,119,114,105,116,101,68,105,114,101,99,116,111,114,121,0,69,114,114,111,114,32,102,101,116,99,104,
105,110,103,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,0,69,114,114,111,114,32,102,101,116,99,104,105,110,103,32,100,105,114,101,99,116,111,114,121,32,108,105,110,107,0,69,114,114,111,114,32,119,114,105,116,105,110,103,32,100,105,114,101,99,116,111,114,121,32,108,105,110,107,0,83,97,110,105,116,121,32,99,104,101,99,107,32,111,110,32,116,97,103,32,99,111,117,110,116,32,102,97,105,108,101,100,44,32,108,105,107,101,108,121,32,99,111,114,114,117,112,116,32,84,73,70,70,0,84,73,70,70,82,
101,115,101,116,70,105,101,108,100,0,77,101,109,111,114,121,32,109,97,112,112,101,100,32,102,105,108,101,115,32,110,111,116,32,99,117,114,114,101,110,116,108,121,32,115,117,112,112,111,114,116,101,100,32,102,111,114,32,116,104,105,115,32,111,112,101,114,97,116,105,111,110,46,0,65,116,116,101,109,112,116,32,116,111,32,114,101,115,101,116,32,102,105,101,108,100,32,111,110,32,100,105,114,101,99,116,111,114,121,32,110,111,116,32,97,108,114,101,97,100,121,32,111,110,32,100,105,115,107,46,0,37,115,58,32,
83,101,101,107,32,101,114,114,111,114,32,97,99,99,101,115,115,105,110,103,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,0,37,115,58,32,67,97,110,32,110,111,116,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,99,111,117,110,116,0,37,115,58,32,67,97,110,32,110,111,116,32,114,101,97,100,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,101,110,116,114,121,46,0,37,115,58,32,67,111,117,108,100,32,110,111,116,32,102,105,110,100,32,116,97,103,32,37,100,46,0,102,111,
114,32,102,105,101,108,100,32,98,117,102,102,101,114,46,0,86,97,108,117,101,32,101,120,99,101,101,100,115,32,51,50,98,105,116,32,114,97,110,103,101,32,111,102,32,111,117,116,112,117,116,32,116,121,112,101,46,0,37,115,58,32,67,97,110,32,110,111,116,32,119,114,105,116,101,32,84,73,70,70,32,100,105,114,101,99,116,111,114,121,32,101,110,116,114,121,46,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,83,101,99,0,69,114,114,111,114,32,112,111,115,116,45,101,110,99,111,100,105,110,103,
32,98,101,102,111,114,101,32,100,105,114,101,99,116,111,114,121,32,119,114,105,116,101,0,69,114,114,111,114,32,102,108,117,115,104,105,110,103,32,100,97,116,97,32,98,101,102,111,114,101,32,100,105,114,101,99,116,111,114,121,32,119,114,105,116,101,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,83,104,111,114,116,80,101,114,83,97,109,112,108,101,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,111,108,111,114,109,97,112,0,99,111,117,110,116,
60,48,120,56,48,48,48,48,48,48,48,0,116,105,102,95,100,105,114,119,114,105,116,101,46,99,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,83,104,111,114,116,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,84,114,97,110,115,102,101,114,102,117,110,99,116,105,111,110,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,83,117,98,105,102,100,0,112,97,32,33,61,32,48,0,42,112,97,
32,60,61,32,48,120,70,70,70,70,70,70,70,70,85,76,0,111,45,62,102,105,101,108,100,95,116,121,112,101,61,61,84,73,70,70,95,65,83,67,73,73,0,111,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,84,73,70,70,95,86,65,82,73,65,66,76,69,0,111,45,62,102,105,101,108,100,95,112,97,115,115,99,111,117,110,116,61,61,48,0,111,45,62,102,105,101,108,100,95,116,121,112,101,61,61,84,73,70,70,95,83,72,79,82,84,0,111,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,49,0,111,45,
62,102,105,101,108,100,95,116,121,112,101,61,61,84,73,70,70,95,76,79,78,71,0,111,45,62,102,105,101,108,100,95,116,121,112,101,61,61,84,73,70,70,95,85,78,68,69,70,73,78,69,68,0,111,45,62,102,105,101,108,100,95,114,101,97,100,99,111,117,110,116,61,61,84,73,70,70,95,86,65,82,73,65,66,76,69,50,0,111,45,62,102,105,101,108,100,95,112,97,115,115,99,111,117,110,116,61,61,49,0,48,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,83,115,104,111,114,116,65,
114,114,97,121,0,99,111,117,110,116,60,48,120,52,48,48,48,48,48,48,48,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,76,111,110,103,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,83,108,111,110,103,65,114,114,97,121,0,99,111,117,110,116,60,48,120,50,48,48,48,48,48,48,48,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,
76,111,110,103,56,65,114,114,97,121,0,116,105,102,45,62,116,105,102,95,102,108,97,103,115,38,84,73,70,70,95,66,73,71,84,73,70,70,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,83,108,111,110,103,56,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,83,114,97,116,105,111,110,97,108,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,
67,104,101,99,107,101,100,70,108,111,97,116,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,68,111,117,98,108,101,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,73,102,100,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,73,102,100,56,65,114,114,97,121,0,84,73,70,70,87,114,105,116,
101,68,105,114,101,99,116,111,114,121,84,97,103,73,102,100,73,102,100,56,65,114,114,97,121,0,65,116,116,101,109,112,116,32,116,111,32,119,114,105,116,101,32,118,97,108,117,101,32,108,97,114,103,101,114,32,116,104,97,110,32,48,120,70,70,70,70,70,70,70,70,32,105,110,32,67,108,97,115,115,105,99,32,84,73,70,70,32,102,105,108,101,46,0,84,73,70,70,76,105,110,107,68,105,114,101,99,116,111,114,121,0,69,114,114,111,114,32,119,114,105,116,105,110,103,32,83,117,98,73,70,68,32,100,105,114,101,99,116,111,114,
121,32,108,105,110,107,0,69,114,114,111,114,32,119,114,105,116,105,110,103,32,84,73,70,70,32,104,101,97,100,101,114,0,77,97,120,105,109,117,109,32,84,73,70,70,32,102,105,108,101,32,115,105,122,101,32,101,120,99,101,101,100,101,100,0,110,97,60,110,100,105,114,0,73,79,32,101,114,114,111,114,32,119,114,105,116,105,110,103,32,100,105,114,101,99,116,111,114,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,82,97,116,105,111,110,97,108,65,114,114,
97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,83,97,109,112,108,101,102,111,114,109,97,116,65,114,114,97,121,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,76,111,110,103,76,111,110,103,56,65,114,114,97,121,0,118,97,108,117,101,62,61,48,46,48,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,67,104,101,99,107,101,100,82,97,116,105,111,110,97,108,0,100,105,114,91,109,93,46,116,100,105,114,95,116,97,103,33,
61,116,97,103,0,84,73,70,70,87,114,105,116,101,68,105,114,101,99,116,111,114,121,84,97,103,68,97,116,97,0,73,79,32,101,114,114,111,114,32,119,114,105,116,105,110,103,32,116,97,103,32,100,97,116,97,0,100,97,116,97,108,101,110,103,116,104,60,48,120,56,48,48,48,48,48,48,48,85,76,0,78,111,110,101,0,76,90,87,0,80,97,99,107,66,105,116,115,0,84,104,117,110,100,101,114,83,99,97,110,0,78,101,88,84,0,74,80,69,71,0,79,108,100,45,115,116,121,108,101,32,74,80,69,71,0,67,67,73,84,84,32,82,76,69,0,67,67,73,84,84,
32,82,76,69,47,87,0,67,67,73,84,84,32,71,114,111,117,112,32,51,0,67,67,73,84,84,32,71,114,111,117,112,32,52,0,73,83,79,32,74,66,73,71,0,68,101,102,108,97,116,101,0,65,100,111,98,101,68,101,102,108,97,116,101,0,80,105,120,97,114,76,111,103,0,83,71,73,76,111,103,0,83,71,73,76,111,103,50,52,0,76,90,77,65,0,37,100,0,37,115,32,99,111,109,112,114,101,115,115,105,111,110,32,115,117,112,112,111,114,116,32,105,115,32,110,111,116,32,99,111,110,102,105,103,117,114,101,100,0,110,32,62,32,48,0,116,105,102,95,
100,117,109,112,109,111,100,101,46,99,0,68,117,109,112,77,111,100,101,69,110,99,111,100,101,0,68,117,109,112,77,111,100,101,68,101,99,111,100,101,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,102,111,114,32,115,99,97,110,108,105,110,101,32,37,108,117,44,32,101,120,112,101,99,116,101,100,32,97,32,114,101,113,117,101,115,116,32,102,111,114,32,97,116,32,109,111,115,116,32,37,108,108,100,32,98,121,116,101,115,44,32,103,111,116,32,97,32,114,101,113,117,101,115,116,32,102,111,114,32,37,108,
108,100,32,98,121,116,101,115,0,0,128,192,224,240,248,252,254,255,120,32,61,61,32,108,97,115,116,120,0,116,105,102,95,102,97,120,51,46,99,0,95,84,73,70,70,70,97,120,51,102,105,108,108,114,117,110,115,0,84,73,70,70,73,110,105,116,67,67,73,84,84,70,97,120,51,0,77,101,114,103,105,110,103,32,67,67,73,84,84,32,70,97,120,32,51,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,84,73,70,70,73,110,105,116,67,67,73,84,84,70,97,120,52,0,77,101,114,103,105,110,
103,32,67,67,73,84,84,32,70,97,120,32,52,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,70,97,120,51,68,101,99,111,100,101,82,76,69,0,116,105,108,101,0,115,116,114,105,112,0,66,97,100,32,99,111,100,101,32,119,111,114,100,32,97,116,32,108,105,110,101,32,37,117,32,111,102,32,37,115,32,37,117,32,40,120,32,37,117,41,0,80,114,101,109,97,116,117,114,101,32,69,79,70,32,97,116,32,108,105,110,101,32,37,117,32,111,102,32,37,115,32,37,117,32,40,120,32,37,
117,41,0,80,114,101,109,97,116,117,114,101,32,69,79,76,0,76,105,110,101,32,108,101,110,103,116,104,32,109,105,115,109,97,116,99,104,0,37,115,32,97,116,32,108,105,110,101,32,37,117,32,111,102,32,37,115,32,37,117,32,40,103,111,116,32,37,117,44,32,101,120,112,101,99,116,101,100,32,37,117,41,0,108,101,110,103,116,104,32,60,32,57,0,70,97,120,51,80,117,116,66,105,116,115,0,70,97,120,52,69,110,99,111,100,101,0,70,114,97,99,116,105,111,110,97,108,32,115,99,97,110,108,105,110,101,115,32,99,97,110,110,111,
116,32,98,101,32,119,114,105,116,116,101,110,0,8,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],"i8",4,ra.GLOBAL_BASE+133156);vc([112,117,116,115,112,97,110,0,116,101,45,62,114,117,110,108,101,110,32,61,61,32,54,52,42,40,115,112,97,110,62,62,54,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,6,6,7,8,70,97,120,52,68,101,99,111,100,101,
0,85,110,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,40,110,111,116,32,115,117,112,112,111,114,116,101,100,41,32,97,116,32,108,105,110,101,32,37,117,32,111,102,32,37,115,32,37,117,32,40,120,32,37,117,41,0,71,114,111,117,112,52,79,112,116,105,111,110,115,0,71,114,111,117,112,51,79,112,116,105,111,110,115,0,73,110,105,116,67,67,73,84,84,70,97,120,51,0,77,101,114,103,105,110,103,32,99,111,109,109,111,110,32,67,67,73,84,84,32,70,97,120,32,99,111,100,101,99,45,115,112,101,99,105,102,105,
99,32,116,97,103,115,32,102,97,105,108,101,100,0,78,111,32,115,112,97,99,101,32,102,111,114,32,115,116,97,116,101,32,98,108,111,99,107,0,70,97,120,51,67,108,101,97,110,117,112,0,70,97,120,51,69,110,99,111,100,101,0,116,112,97,114,109,32,60,32,57,0,70,97,120,51,80,117,116,69,79,76,0,70,97,120,51,80,114,101,69,110,99,111,100,101,0,70,97,120,51,68,101,99,111,100,101,49,68,0,70,97,120,51,80,114,101,68,101,99,111,100,101,0,70,97,120,51,83,101,116,117,112,83,116,97,116,101,0,66,105,116,115,47,115,97,109,
112,108,101,32,109,117,115,116,32,98,101,32,49,32,102,111,114,32,71,114,111,117,112,32,51,47,52,32,101,110,99,111,100,105,110,103,47,100,101,99,111,100,105,110,103,0,82,111,119,32,112,105,120,101,108,115,32,105,110,116,101,103,101,114,32,111,118,101,114,102,108,111,119,32,40,114,111,119,112,105,120,101,108,115,32,37,117,41,0,102,111,114,32,71,114,111,117,112,32,51,47,52,32,114,117,110,32,97,114,114,97,121,115,0,78,111,32,115,112,97,99,101,32,102,111,114,32,71,114,111,117,112,32,51,47,52,32,114,101,
102,101,114,101,110,99,101,32,108,105,110,101,0,70,97,120,51,68,101,99,111,100,101,50,68,0,70,97,120,51,80,114,105,110,116,68,105,114,0,32,32,71,114,111,117,112,32,52,32,79,112,116,105,111,110,115,58,0,37,115,117,110,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,0,32,0,32,32,71,114,111,117,112,32,51,32,79,112,116,105,111,110,115,58,0,37,115,50,45,100,32,101,110,99,111,100,105,110,103,0,43,0,37,115,69,79,76,32,112,97,100,100,105,110,103,0,32,40,37,108,117,32,61,32,48,120,37,108,120,41,10,
0,32,32,70,97,120,32,68,97,116,97,58,0,32,99,108,101,97,110,0,32,114,101,99,101,105,118,101,114,32,114,101,103,101,110,101,114,97,116,101,100,0,32,117,110,99,111,114,114,101,99,116,101,100,32,101,114,114,111,114,115,0,32,40,37,117,32,61,32,48,120,37,120,41,10,0,32,32,66,97,100,32,70,97,120,32,76,105,110,101,115,58,32,37,108,117,10,0,32,32,67,111,110,115,101,99,117,116,105,118,101,32,66,97,100,32,70,97,120,32,76,105,110,101,115,58,32,37,108,117,10,0,70,97,120,51,86,83,101,116,70,105,101,108,100,0,
115,112,45,62,118,115,101,116,112,97,114,101,110,116,32,33,61,32,48,0,70,97,120,51,86,71,101,116,70,105,101,108,100,0,70,97,120,77,111,100,101,0,70,97,120,70,105,108,108,70,117,110,99,0,66,97,100,70,97,120,76,105,110,101,115,0,67,108,101,97,110,70,97,120,68,97,116,97,0,67,111,110,115,101,99,117,116,105,118,101,66,97,100,70,97,120,76,105,110,101,115,0,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,74,80,69,71,0,116,105,102,95,106,112,101,103,46,99,0,84,73,70,70,73,110,105,116,
74,80,69,71,0,77,101,114,103,105,110,103,32,74,80,69,71,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,78,111,32,115,112,97,99,101,32,102,111,114,32,74,80,69,71,32,115,116,97,116,101,32,98,108,111,99,107,0,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,32,102,111,114,32,74,80,69,71,32,116,97,98,108,101,115,0,74,80,69,71,67,108,101,97,110,117,112,0,74,80,69,71,69,110,99,111,100,101,0,102,114,97,99,116,
105,111,110,97,108,32,115,99,97,110,108,105,110,101,32,100,105,115,99,97,114,100,101,100,0,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,0,74,80,69,71,80,114,101,69,110,99,111,100,101,0,33,115,112,45,62,99,105,110,102,111,46,99,111,109,109,46,105,115,95,100,101,99,111,109,112,114,101,115,115,111,114,0,83,116,114,105,112,47,116,105,108,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,74,80,69,71,0,74,80,69,71,69,110,99,111,100,101,82,97,119,0,
74,80,69,71,83,101,116,117,112,69,110,99,111,100,101,0,80,104,111,116,111,109,101,116,114,105,99,73,110,116,101,114,112,114,101,116,97,116,105,111,110,32,37,100,32,110,111,116,32,97,108,108,111,119,101,100,32,102,111,114,32,74,80,69,71,0,66,105,116,115,80,101,114,83,97,109,112,108,101,32,37,100,32,110,111,116,32,97,108,108,111,119,101,100,32,102,111,114,32,74,80,69,71,0,74,80,69,71,32,116,105,108,101,32,104,101,105,103,104,116,32,109,117,115,116,32,98,101,32,109,117,108,116,105,112,108,101,32,111,
102,32,37,100,0,74,80,69,71,32,116,105,108,101,32,119,105,100,116,104,32,109,117,115,116,32,98,101,32,109,117,108,116,105,112,108,101,32,111,102,32,37,100,0,82,111,119,115,80,101,114,83,116,114,105,112,32,109,117,115,116,32,98,101,32,109,117,108,116,105,112,108,101,32,111,102,32,37,100,32,102,111,114,32,74,80,69,71,0,0,0,0,0,0,0,0,0,0,0,84,73,70,70,106,112,101,103,95,116,97,98,108,101,115,95,100,101,115,116,0,78,111,32,115,112,97,99,101,32,102,111,114,32,74,80,69,71,84,97,98,108,101,115,0,74,80,69,
71,76,105,98,0,102,114,97,99,116,105,111,110,97,108,32,115,99,97,110,108,105,110,101,32,110,111,116,32,114,101,97,100,0,74,80,69,71,80,114,101,68,101,99,111,100,101,0,115,112,45,62,99,105,110,102,111,46,99,111,109,109,46,105,115,95,100,101,99,111,109,112,114,101,115,115,111,114,0,73,109,112,114,111,112,101,114,32,74,80,69,71,32,115,116,114,105,112,47,116,105,108,101,32,115,105,122,101,44,32,101,120,112,101,99,116,101,100,32,37,100,120,37,100,44,32,103,111,116,32,37,100,120,37,100,0,74,80,69,71,32,
115,116,114,105,112,47,116,105,108,101,32,115,105,122,101,32,101,120,99,101,101,100,115,32,101,120,112,101,99,116,101,100,32,100,105,109,101,110,115,105,111,110,115,44,32,101,120,112,101,99,116,101,100,32,37,100,120,37,100,44,32,103,111,116,32,37,100,120,37,100,0,73,109,112,114,111,112,101,114,32,74,80,69,71,32,99,111,109,112,111,110,101,110,116,32,99,111,117,110,116,0,73,109,112,114,111,112,101,114,32,74,80,69,71,32,100,97,116,97,32,112,114,101,99,105,115,105,111,110,0,73,109,112,114,111,112,101,
114,32,74,80,69,71,32,115,97,109,112,108,105,110,103,32,102,97,99,116,111,114,115,32,37,100,44,37,100,10,65,112,112,97,114,101,110,116,108,121,32,115,104,111,117,108,100,32,98,101,32,37,100,44,37,100,46,0,73,109,112,114,111,112,101,114,32,74,80,69,71,32,115,97,109,112,108,105,110,103,32,102,97,99,116,111,114,115,0,74,80,69,71,68,101,99,111,100,101,82,97,119,0,97,112,112,108,105,99,97,116,105,111,110,32,98,117,102,102,101,114,32,110,111,116,32,108,97,114,103,101,32,101,110,111,117,103,104,32,102,111,
114,32,97,108,108,32,100,97,116,97,46,0,97,112,112,108,105,99,97,116,105,111,110,32,98,117,102,102,101,114,32,110,111,116,32,108,97,114,103,101,32,101,110,111,117,103,104,32,102,111,114,32,97,108,108,32,100,97,116,97,44,32,112,111,115,115,105,98,108,101,32,115,117,98,115,97,109,112,108,105,110,103,32,105,115,115,117,101,0,84,73,70,70,82,101,97,100,83,99,97,110,108,105,110,101,0,115,99,97,110,108,105,110,101,32,111,114,105,101,110,116,101,100,32,97,99,99,101,115,115,32,105,115,32,110,111,116,32,115,
117,112,112,111,114,116,101,100,32,102,111,114,32,100,111,119,110,115,97,109,112,108,101,100,32,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,105,109,97,103,101,115,44,32,99,111,110,115,105,100,101,114,32,101,110,97,98,108,105,110,103,32,84,73,70,70,95,74,80,69,71,67,79,76,79,82,77,79,68,69,32,97,115,32,74,80,69,71,67,79,76,79,82,77,79,68,69,95,82,71,66,46,0,74,80,69,71,83,101,116,117,112,68,101,99,111,100,101,0,66,111,103,117,115,32,74,80,69,71,84,97,98,108,101,115,32,102,105,101,108,
100,0,255,217,74,80,69,71,70,105,120,117,112,84,97,103,115,83,117,98,115,97,109,112,108,105,110,103,0,85,110,97,98,108,101,32,116,111,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,32,102,111,114,32,97,117,116,111,45,99,111,114,114,101,99,116,105,110,103,32,111,102,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,59,32,97,117,116,111,45,99,111,114,114,101,99,116,105,110,103,32,115,107,105,112,112,101,100,0,109,60,48,120,56,48,48,48,48,48,48,48,85,76,0,74,80,69,71,
70,105,120,117,112,84,97,103,115,83,117,98,115,97,109,112,108,105,110,103,82,101,97,100,66,121,116,101,0,74,80,69,71,70,105,120,117,112,84,97,103,115,83,117,98,115,97,109,112,108,105,110,103,83,101,99,0,83,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,32,105,110,115,105,100,101,32,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,104,97,118,101,32,110,111,32,84,73,70,70,32,101,113,117,105,118,97,108,101,110,116,44,32,97,117,116,111,45,99,111,114,114,101,99,
116,105,111,110,32,111,102,32,84,73,70,70,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,32,102,97,105,108,101,100,0,65,117,116,111,45,99,111,114,114,101,99,116,101,100,32,102,111,114,109,101,114,32,84,73,70,70,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,32,91,37,100,44,37,100,93,32,116,111,32,109,97,116,99,104,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,32,105,110,115,105,100,101,32,74,80,69,71,32,99,111,109,112,114,101,
115,115,101,100,32,100,97,116,97,32,91,37,100,44,37,100,93,0,85,110,97,98,108,101,32,116,111,32,97,117,116,111,45,99,111,114,114,101,99,116,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,44,32,108,105,107,101,108,121,32,99,111,114,114,117,112,116,32,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,110,32,102,105,114,115,116,32,115,116,114,105,112,47,116,105,108,101,59,32,97,117,116,111,45,99,111,114,114,101,99,116,105,110,103,32,115,107,105,112,
112,101,100,0,74,80,69,71,80,114,105,110,116,68,105,114,0,32,32,74,80,69,71,32,84,97,98,108,101,115,58,32,40,37,108,117,32,98,121,116,101,115,41,10,0,74,80,69,71,86,83,101,116,70,105,101,108,100,0,74,80,69,71,86,71,101,116,70,105,101,108,100,0,74,80,69,71,84,97,98,108,101,115,0,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,83,71,73,76,79,71,50,52,32,124,124,32,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,83,71,73,76,79,71,0,116,105,102,95,108,117,
118,46,99,0,84,73,70,70,73,110,105,116,83,71,73,76,111,103,0,77,101,114,103,105,110,103,32,83,71,73,76,111,103,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,37,115,58,32,78,111,32,115,112,97,99,101,32,102,111,114,32,76,111,103,76,117,118,32,115,116,97,116,101,32,98,108,111,99,107,0,85,110,107,110,111,119,110,32,100,97,116,97,32,102,111,114,109,97,116,32,37,100,32,102,111,114,32,76,111,103,76,117,118,32,99,111,109,112,114,101,115,115,105,111,110,
0,76,111,103,76,117,118,86,83,101,116,70,105,101,108,100,0,85,110,107,110,111,119,110,32,101,110,99,111,100,105,110,103,32,37,100,32,102,111,114,32,76,111,103,76,117,118,32,99,111,109,112,114,101,115,115,105,111,110,0,76,111,103,76,117,118,67,108,101,97,110,117,112,0,99,99,37,114,111,119,108,101,110,32,61,61,32,48,0,76,111,103,76,117,118,69,110,99,111,100,101,84,105,108,101,0,76,111,103,76,117,118,69,110,99,111,100,101,83,116,114,105,112,0,76,111,103,76,117,118,83,101,116,117,112,69,110,99,111,100,
101,0,73,110,97,112,112,114,111,112,114,105,97,116,101,32,112,104,111,116,111,109,101,116,114,105,99,32,105,110,116,101,114,112,114,101,116,97,116,105,111,110,32,37,100,32,102,111,114,32,83,71,73,76,111,103,32,99,111,109,112,114,101,115,115,105,111,110,59,32,37,115,0,109,117,115,116,32,98,101,32,101,105,116,104,101,114,32,76,111,103,76,85,86,32,111,114,32,76,111,103,76,0,89,44,32,76,0,88,89,90,44,32,76,117,118,0,83,71,73,76,111,103,32,99,111,109,112,114,101,115,115,105,111,110,32,115,117,112,112,
111,114,116,101,100,32,111,110,108,121,32,102,111,114,32,37,115,44,32,111,114,32,114,97,119,32,100,97,116,97,0,115,32,61,61,32,48,0,76,111,103,76,49,54,69,110,99,111,100,101,0,115,112,45,62,116,98,117,102,108,101,110,32,62,61,32,110,112,105,120,101,108,115,0,76,111,103,76,49,54,73,110,105,116,83,116,97,116,101,0,116,100,45,62,116,100,95,112,104,111,116,111,109,101,116,114,105,99,32,61,61,32,80,72,79,84,79,77,69,84,82,73,67,95,76,79,71,76,0,78,111,32,115,117,112,112,111,114,116,32,102,111,114,32,99,
111,110,118,101,114,116,105,110,103,32,117,115,101,114,32,100,97,116,97,32,102,111,114,109,97,116,32,116,111,32,76,111,103,76,0,78,111,32,115,112,97,99,101,32,102,111,114,32,83,71,73,76,111,103,32,116,114,97,110,115,108,97,116,105,111,110,32,98,117,102,102,101,114,0,76,111,103,76,117,118,69,110,99,111,100,101,51,50,0,76,111,103,76,117,118,69,110,99,111,100,101,50,52,0,76,111,103,76,117,118,73,110,105,116,83,116,97,116,101,0,116,100,45,62,116,100,95,112,104,111,116,111,109,101,116,114,105,99,32,61,
61,32,80,72,79,84,79,77,69,84,82,73,67,95,76,79,71,76,85,86,0,83,71,73,76,111,103,32,99,111,109,112,114,101,115,115,105,111,110,32,99,97,110,110,111,116,32,104,97,110,100,108,101,32,110,111,110,45,99,111,110,116,105,103,117,111,117,115,32,100,97,116,97,0,78,111,32,115,117,112,112,111,114,116,32,102,111,114,32,99,111,110,118,101,114,116,105,110,103,32,117,115,101,114,32,100,97,116,97,32,102,111,114,109,97,116,32,116,111,32,76,111,103,76,117,118,0,76,111,103,76,117,118,68,101,99,111,100,101,84,105,
108,101,0,76,111,103,76,117,118,68,101,99,111,100,101,83,116,114,105,112,0,76,111,103,76,117,118,83,101,116,117,112,68,101,99,111,100,101,0,76,111,103,76,49,54,68,101,99,111,100,101,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,97,116,32,114,111,119,32,37,108,117,32,40,115,104,111,114,116,32,37,108,108,117,32,112,105,120,101,108,115,41,0,76,111,103,76,117,118,68,101,99,111,100,101,51,50,0,76,111,103,76,117,118,68,101,99,111,100,101,50,52,0,83,71,73,76,111,103,68,97,116,97,70,109,116,
0,83,71,73,76,111,103,69,110,99,111,100,101,0,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,76,90,87,0,116,105,102,95,108,122,119,46,99,0,84,73,70,70,73,110,105,116,76,90,87,0,78,111,32,115,112,97,99,101,32,102,111,114,32,76,90,87,32,115,116,97,116,101,32,98,108,111,99,107,0,116,105,102,45,62,116,105,102,95,100,97,116,97,32,33,61,32,48,0,76,90,87,67,108,101,97,110,117,112,0,115,112,45,62,101,110,99,95,104,97,115,104,116,97,98,32,33,61,32,78,85,76,76,0,76,90,87,69,110,99,111,
100,101,0,110,98,105,116,115,32,60,61,32,66,73,84,83,95,77,65,88,0,76,90,87,80,114,101,69,110,99,111,100,101,0,76,90,87,83,101,116,117,112,69,110,99,111,100,101,0,78,111,32,115,112,97,99,101,32,102,111,114,32,76,90,87,32,104,97,115,104,32,116,97,98,108,101,0,76,90,87,68,101,99,111,100,101,0,115,112,45,62,100,101,99,95,99,111,100,101,116,97,98,32,33,61,32,78,85,76,76,0,76,90,87,68,101,99,111,100,101,58,32,83,116,114,105,112,32,37,100,32,110,111,116,32,116,101,114,109,105,110,97,116,101,100,32,119,
105,116,104,32,69,79,73,32,99,111,100,101,0,76,90,87,68,101,99,111,100,101,58,32,67,111,114,114,117,112,116,101,100,32,76,90,87,32,116,97,98,108,101,32,97,116,32,115,99,97,110,108,105,110,101,32,37,100,0,67,111,114,114,117,112,116,101,100,32,76,90,87,32,116,97,98,108,101,32,97,116,32,115,99,97,110,108,105,110,101,32,37,100,0,87,114,111,110,103,32,108,101,110,103,116,104,32,111,102,32,100,101,99,111,100,101,100,32,115,116,114,105,110,103,58,32,100,97,116,97,32,112,114,111,98,97,98,108,121,32,99,111,
114,114,117,112,116,101,100,32,97,116,32,115,99,97,110,108,105,110,101,32,37,100,0,66,111,103,117,115,32,101,110,99,111,100,105,110,103,44,32,108,111,111,112,32,105,110,32,116,104,101,32,99,111,100,101,32,116,97,98,108,101,59,32,115,99,97,110,108,105,110,101,32,37,100,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,97,116,32,115,99,97,110,108,105,110,101,32,37,100,32,40,115,104,111,114,116,32,37,108,108,117,32,98,121,116,101,115,41,0,76,90,87,80,114,101,68,101,99,111,100,101,0,79,108,
100,45,115,116,121,108,101,32,76,90,87,32,99,111,100,101,115,44,32,99,111,110,118,101,114,116,32,102,105,108,101,0,76,90,87,68,101,99,111,100,101,67,111,109,112,97,116,0,76,90,87,83,101,116,117,112,68,101,99,111,100,101,0,78,111,32,115,112,97,99,101,32,102,111,114,32,76,90,87,32,99,111,100,101,32,116,97,98,108,101,0,78,101,88,84,68,101,99,111,100,101,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,102,111,114,32,115,99,97,110,108,105,110,101,32,37,108,100,0,78,101,88,84,80,114,101,68,
101,99,111,100,101,0,85,110,115,117,112,112,111,114,116,101,100,32,66,105,116,115,80,101,114,83,97,109,112,108,101,32,61,32,37,100,0,115,99,104,101,109,101,61,61,67,79,77,80,82,69,83,83,73,79,78,95,79,74,80,69,71,0,116,105,102,95,111,106,112,101,103,46,99,0,84,73,70,70,73,110,105,116,79,74,80,69,71,0,77,101,114,103,105,110,103,32,79,108,100,32,74,80,69,71,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,78,111,32,115,112,97,99,101,32,102,111,114,
32,79,74,80,69,71,32,115,116,97,116,101,32,98,108,111,99,107,0,115,112,33,61,78,85,76,76,0,79,74,80,69,71,80,114,105,110,116,68,105,114,0,32,32,74,112,101,103,73,110,116,101,114,99,104,97,110,103,101,70,111,114,109,97,116,58,32,37,108,117,10,0,32,32,74,112,101,103,73,110,116,101,114,99,104,97,110,103,101,70,111,114,109,97,116,76,101,110,103,116,104,58,32,37,108,117,10,0,32,32,74,112,101,103,81,84,97,98,108,101,115,58,0,32,37,108,117,0,32,32,74,112,101,103,68,99,84,97,98,108,101,115,58,0,32,32,74,
112,101,103,65,99,84,97,98,108,101,115,58,0,32,32,74,112,101,103,80,114,111,99,58,32,37,117,10,0,32,32,74,112,101,103,82,101,115,116,97,114,116,73,110,116,101,114,118,97,108,58,32,37,117,10,0,79,74,80,69,71,86,83,101,116,70,105,101,108,100,0,74,112,101,103,81,84,97,98,108,101,115,32,116,97,103,32,104,97,115,32,105,110,99,111,114,114,101,99,116,32,99,111,117,110,116,0,74,112,101,103,68,99,84,97,98,108,101,115,32,116,97,103,32,104,97,115,32,105,110,99,111,114,114,101,99,116,32,99,111,117,110,116,0,
74,112,101,103,65,99,84,97,98,108,101,115,32,116,97,103,32,104,97,115,32,105,110,99,111,114,114,101,99,116,32,99,111,117,110,116,0,115,112,45,62,115,117,98,115,97,109,112,108,105,110,103,99,111,114,114,101,99,116,95,100,111,110,101,61,61,48,0,79,74,80,69,71,83,117,98,115,97,109,112,108,105,110,103,67,111,114,114,101,99,116,0,83,117,98,115,97,109,112,108,105,110,103,32,116,97,103,32,110,111,116,32,97,112,112,114,111,112,114,105,97,116,101,32,102,111,114,32,116,104,105,115,32,80,104,111,116,111,109,
101,116,114,105,99,32,97,110,100,47,111,114,32,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,0,83,117,98,115,97,109,112,108,105,110,103,32,116,97,103,32,105,115,32,110,111,116,32,115,101,116,44,32,121,101,116,32,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,91,37,100,44,37,100,93,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,100,101,102,97,117,108,116,32,118,97,108,117,101,115,32,91,50,44,50,93,59,32,97,115,115,117,109,
105,110,103,32,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,105,115,32,99,111,114,114,101,99,116,0,83,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,91,37,100,44,37,100,93,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,115,117,98,115,97,109,112,108,105,110,103,32,116,97,103,32,118,97,108,117,101,115,32,91,37,100,44,37,100,93,59,32,97,115,115,117,109,105,110,103,32,115,117,98,
115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,105,115,32,99,111,114,114,101,99,116,0,83,117,98,115,97,109,112,108,105,110,103,32,116,97,103,32,105,115,32,110,111,116,32,115,101,116,44,32,121,101,116,32,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,100,101,102,97,117,108,116,32,118,97,108,117,101,115,32,91,50,44,50,93,32,40,110,111,114,32,97,
110,121,32,111,116,104,101,114,32,118,97,108,117,101,115,32,97,108,108,111,119,101,100,32,105,110,32,84,73,70,70,41,59,32,97,115,115,117,109,105,110,103,32,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,105,115,32,99,111,114,114,101,99,116,32,97,110,100,32,100,101,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,101,99,111,109,112,114,101,115,115,105,111,110,0,83,117,98,115,97,109,112,108,105,110,103,
32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,97,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,115,117,98,115,97,109,112,108,105,110,103,32,116,97,103,32,118,97,108,117,101,115,32,91,37,100,44,37,100,93,32,40,110,111,114,32,97,110,121,32,111,116,104,101,114,32,118,97,108,117,101,115,32,97,108,108,111,119,101,100,32,105,110,32,84,73,70,70,41,59,32,97,115,115,117,109,105,110,103,32,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,97,116,
97,32,105,115,32,99,111,114,114,101,99,116,32,97,110,100,32,100,101,115,117,98,115,97,109,112,108,105,110,103,32,105,110,115,105,100,101,32,74,80,69,71,32,100,101,99,111,109,112,114,101,115,115,105,111,110,0,83,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,32,91,37,100,44,37,100,93,32,97,114,101,32,110,111,116,32,97,108,108,111,119,101,100,32,105,110,32,84,73,70,70,0,115,112,45,62,105,110,95,98,117,102,102,101,114,95,116,111,103,111,62,48,0,79,74,80,69,71,82,101,97,100,66,121,116,
101,80,101,101,107,0,79,74,80,69,71,82,101,97,100,66,121,116,101,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,0,67,111,114,114,117,112,116,32,74,80,69,71,32,100,97,116,97,0,115,112,45,62,105,110,95,98,117,102,102,101,114,95,116,111,103,111,61,61,48,0,79,74,80,69,71,82,101,97,100,83,107,105,112,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,83,116,114,101,97,109,68,114,105,0,67,111,114,114,117,112,116,32,68,82,73,32,109,97,114,107,101,
114,32,105,110,32,74,80,69,71,32,100,97,116,97,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,83,116,114,101,97,109,68,113,116,0,67,111,114,114,117,112,116,32,68,81,84,32,109,97,114,107,101,114,32,105,110,32,74,80,69,71,32,100,97,116,97,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,79,74,80,69,71,82,101,97,100,66,108,111,99,107,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,83,116,114,101,97,109,68,104,116,0,67,111,114,114,117,112,
116,32,68,72,84,32,109,97,114,107,101,114,32,105,110,32,74,80,69,71,32,100,97,116,97,0,108,101,110,62,48,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,83,116,114,101,97,109,83,111,102,0,67,111,114,114,117,112,116,32,83,79,70,32,109,97,114,107,101,114,32,105,110,32,74,80,69,71,32,100,97,116,97,0,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,110,100,105,99,97,116,101,115,32,117,110,101,120,112,101,99,116,101,100,32,110,117,109,98,101,114,
32,111,102,32,115,97,109,112,108,101,115,0,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,110,100,105,99,97,116,101,115,32,117,110,101,120,112,101,99,116,101,100,32,110,117,109,98,101,114,32,111,102,32,98,105,116,115,32,112,101,114,32,115,97,109,112,108,101,0,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,110,100,105,99,97,116,101,115,32,117,110,101,120,112,101,99,116,101,100,32,104,101,105,103,104,116,0,74,80,69,71,32,99,111,109,112,114,
101,115,115,101,100,32,100,97,116,97,32,105,110,100,105,99,97,116,101,115,32,117,110,101,120,112,101,99,116,101,100,32,119,105,100,116,104,0,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,109,97,103,101,32,119,105,100,116,104,32,101,120,99,101,101,100,115,32,101,120,112,101,99,116,101,100,32,105,109,97,103,101,32,119,105,100,116,104,0,74,80,69,71,32,99,111,109,112,114,101,115,115,101,100,32,100,97,116,97,32,105,110,100,105,99,97,116,101,115,32,117,110,101,120,112,101,
99,116,101,100,32,115,117,98,115,97,109,112,108,105,110,103,32,118,97,108,117,101,115,0,115,112,45,62,112,108,97,110,101,95,115,97,109,112,108,101,95,111,102,102,115,101,116,61,61,48,0,85,110,107,110,111,119,110,32,109,97,114,107,101,114,32,116,121,112,101,32,37,100,32,105,110,32,74,80,69,71,32,100,97,116,97,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,84,97,98,108,101,115,81,84,97,98,108,101,0,77,105,115,115,105,110,103,32,74,80,69,71,32,116,97,98,108,101,115,0,67,
111,114,114,117,112,116,32,74,112,101,103,81,84,97,98,108,101,115,32,116,97,103,32,118,97,108,117,101,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,84,97,98,108,101,115,68,99,84,97,98,108,101,0,67,111,114,114,117,112,116,32,74,112,101,103,68,99,84,97,98,108,101,115,32,116,97,103,32,118,97,108,117,101,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,84,97,98,108,101,115,65,99,84,97,98,108,101,0,67,111,114,114,117,112,116,32,74,112,101,103,
65,99,84,97,98,108,101,115,32,116,97,103,32,118,97,108,117,101,0,115,112,45,62,115,117,98,115,97,109,112,108,105,110,103,99,111,114,114,101,99,116,61,61,48,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,83,101,99,83,116,114,101,97,109,83,111,115,0,67,111,114,114,117,112,116,32,83,79,83,32,109,97,114,107,101,114,32,105,110,32,74,80,69,71,32,100,97,116,97,0,110,62,48,0,79,74,80,69,71,82,101,97,100,66,117,102,102,101,114,70,105,108,108,0,110,60,61,79,74,80,69,71,95,66,85,70,70,69,
82,0,40,117,105,110,116,54,52,41,110,60,61,115,112,45,62,105,110,95,98,117,102,102,101,114,95,102,105,108,101,95,116,111,103,111,0,115,112,45,62,108,105,98,106,112,101,103,95,115,101,115,115,105,111,110,95,97,99,116,105,118,101,33,61,48,0,79,74,80,69,71,76,105,98,106,112,101,103,83,101,115,115,105,111,110,65,98,111,114,116,0,79,74,80,69,71,69,110,99,111,100,101,0,79,74,80,69,71,32,101,110,99,111,100,105,110,103,32,110,111,116,32,115,117,112,112,111,114,116,101,100,59,32,117,115,101,32,110,101,119,
45,115,116,121,108,101,32,74,80,69,71,32,99,111,109,112,114,101,115,115,105,111,110,32,105,110,115,116,101,97,100,0,79,74,80,69,71,80,111,115,116,69,110,99,111,100,101,0,79,74,80,69,71,80,114,101,69,110,99,111,100,101,0,79,74,80,69,71,83,101,116,117,112,69,110,99,111,100,101,0,79,74,80,69,71,68,101,99,111,100,101,82,97,119,0,70,114,97,99,116,105,111,110,97,108,32,115,99,97,110,108,105,110,101,32,110,111,116,32,114,101,97,100,0,99,99,62,48,0,79,74,80,69,71,68,101,99,111,100,101,83,99,97,110,108,105,
110,101,115,0,79,74,80,69,71,80,111,115,116,68,101,99,111,100,101,0,115,112,45,62,114,101,97,100,104,101,97,100,101,114,95,100,111,110,101,61,61,48,0,79,74,80,69,71,82,101,97,100,72,101,97,100,101,114,73,110,102,111,0,83,97,109,112,108,101,115,80,101,114,80,105,120,101,108,32,37,100,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,102,111,114,32,116,104,105,115,32,99,111,109,112,114,101,115,115,105,111,110,32,115,99,104,101,109,101,0,73,110,99,111,109,112,97,116,105,98,108,101,32,118,101,
114,116,105,99,97,108,32,115,117,98,115,97,109,112,108,105,110,103,32,97,110,100,32,105,109,97,103,101,32,115,116,114,105,112,47,116,105,108,101,32,108,101,110,103,116,104,0,115,62,48,0,79,74,80,69,71,82,101,97,100,83,101,99,111,110,100,97,114,121,83,111,115,0,115,60,51,0,115,112,45,62,115,111,115,95,101,110,100,91,48,93,46,108,111,103,33,61,48,0,115,112,45,62,115,111,115,95,101,110,100,91,115,93,46,108,111,103,61,61,48,0,115,112,45,62,115,117,98,115,97,109,112,108,105,110,103,95,99,111,110,118,101,
114,116,95,121,99,98,99,114,98,117,102,61,61,48,0,79,74,80,69,71,87,114,105,116,101,72,101,97,100,101,114,73,110,102,111,0,115,112,45,62,115,117,98,115,97,109,112,108,105,110,103,95,99,111,110,118,101,114,116,95,121,99,98,99,114,105,109,97,103,101,61,61,48,0,79,74,80,69,71,80,114,101,68,101,99,111,100,101,83,107,105,112,83,99,97,110,108,105,110,101,115,0,76,105,98,74,112,101,103,0,85,110,101,120,112,101,99,116,101,100,32,101,114,114,111,114,0,115,112,45,62,111,117,116,95,115,116,97,116,101,60,61,
111,115,111,115,69,111,105,0,79,74,80,69,71,87,114,105,116,101,83,116,114,101,97,109,0,50,53,53,62,61,56,43,115,112,45,62,115,97,109,112,108,101,115,95,112,101,114,95,112,105,120,101,108,95,112,101,114,95,112,108,97,110,101,42,51,0,79,74,80,69,71,87,114,105,116,101,83,116,114,101,97,109,83,111,102,0,50,53,53,62,61,54,43,115,112,45,62,115,97,109,112,108,101,115,95,112,101,114,95,112,105,120,101,108,95,112,101,114,95,112,108,97,110,101,42,50,0,79,74,80,69,71,87,114,105,116,101,83,116,114,101,97,109,
83,111,115,0,79,74,80,69,71,87,114,105,116,101,83,116,114,101,97,109,67,111,109,112,114,101,115,115,101,100,0,80,114,101,109,97,116,117,114,101,32,101,110,100,32,111,102,32,74,80,69,71,32,100,97,116,97,0,79,74,80,69,71,83,101,116,117,112,68,101,99,111,100,101,0,68,101,112,114,101,99,105,97,116,101,100,32,97,110,100,32,116,114,111,117,98,108,101,115,111,109,101,32,111,108,100,45,115,116,121,108,101,32,74,80,69,71,32,99,111,109,112,114,101,115,115,105,111,110,32,109,111,100,101,44,32,112,108,101,97,
115,101,32,99,111,110,118,101,114,116,32,116,111,32,110,101,119,45,115,116,121,108,101,32,74,80,69,71,32,99,111,109,112,114,101,115,115,105,111,110,32,97,110,100,32,110,111,116,105,102,121,32,118,101,110,100,111,114,32,111,102,32,119,114,105,116,105,110,103,32,115,111,102,116,119,97,114,101,0,74,112,101,103,73,110,116,101,114,99,104,97,110,103,101,70,111,114,109,97,116,0,74,112,101,103,73,110,116,101,114,99,104,97,110,103,101,70,111,114,109,97,116,76,101,110,103,116,104,0,74,112,101,103,81,84,97,
98,108,101,115,0,74,112,101,103,68,99,84,97,98,108,101,115,0,74,112,101,103,65,99,84,97,98,108,101,115,0,74,112,101,103,80,114,111,99,0,74,112,101,103,82,101,115,116,97,114,116,73,110,116,101,114,118,97,108,0,80,97,99,107,66,105,116,115,68,101,99,111,100,101,0,68,105,115,99,97,114,100,105,110,103,32,37,108,117,32,98,121,116,101,115,32,116,111,32,97,118,111,105,100,32,98,117,102,102,101,114,32,111,118,101,114,114,117,110,0,84,101,114,109,105,110,97,116,105,110,103,32,80,97,99,107,66,105,116,115,68,
101,99,111,100,101,32,100,117,101,32,116,111,32,108,97,99,107,32,111,102,32,100,97,116,97,46,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,102,111,114,32,115,99,97,110,108,105,110,101,32,37,108,117,0,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,80,73,88,65,82,76,79,71,0,116,105,102,95,112,105,120,97,114,108,111,103,46,99,0,84,73,70,70,73,110,105,116,80,105,120,97,114,76,111,103,0,77,101,114,103,105,110,103,32,80,105,120,97,114,76,111,103,32,99,111,100,101,99,
45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,78,111,32,115,112,97,99,101,32,102,111,114,32,80,105,120,97,114,76,111,103,32,115,116,97,116,101,32,98,108,111,99,107,0,80,105,120,97,114,76,111,103,86,83,101,116,70,105,101,108,100,0,80,105,120,97,114,76,111,103,67,108,101,97,110,117,112,0,80,105,120,97,114,76,111,103,69,110,99,111,100,101,0,37,100,32,98,105,116,32,105,110,112,117,116,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,105,110,32,80,105,120,97,114,
76,111,103,0,90,76,105,98,32,99,97,110,110,111,116,32,100,101,97,108,32,119,105,116,104,32,98,117,102,102,101,114,115,32,116,104,105,115,32,115,105,122,101,0,80,105,120,97,114,76,111,103,80,111,115,116,69,110,99,111,100,101,0,80,105,120,97,114,76,111,103,80,114,101,69,110,99,111,100,101,0,80,105,120,97,114,76,111,103,83,101,116,117,112,69,110,99,111,100,101,0,80,105,120,97,114,76,111,103,32,99,111,109,112,114,101,115,115,105,111,110,32,99,97,110,39,116,32,104,97,110,100,108,101,32,37,100,32,98,105,
116,32,108,105,110,101,97,114,32,101,110,99,111,100,105,110,103,115,0,80,105,120,97,114,76,111,103,68,101,99,111,100,101,0,115,116,114,105,100,101,32,37,108,117,32,105,115,32,110,111,116,32,97,32,109,117,108,116,105,112,108,101,32,111,102,32,115,97,109,112,108,101,32,99,111,117,110,116,44,32,37,108,117,44,32,100,97,116,97,32,116,114,117,110,99,97,116,101,100,46,0,85,110,115,117,112,112,111,114,116,101,100,32,98,105,116,115,47,115,97,109,112,108,101,58,32,37,100,0,80,105,120,97,114,76,111,103,80,114,
101,68,101,99,111,100,101,0,80,105,120,97,114,76,111,103,83,101,116,117,112,68,101,99,111,100,101,0,80,105,120,97,114,76,111,103,32,99,111,109,112,114,101,115,115,105,111,110,32,99,97,110,39,116,32,104,97,110,100,108,101,32,98,105,116,115,32,100,101,112,116,104,47,100,97,116,97,32,102,111,114,109,97,116,32,99,111,109,98,105,110,97,116,105,111,110,32,40,100,101,112,116,104,58,32,37,100,41,0,116,105,102,95,112,114,101,100,105,99,116,46,99,0,84,73,70,70,80,114,101,100,105,99,116,111,114,73,110,105,116,
0,77,101,114,103,105,110,103,32,80,114,101,100,105,99,116,111,114,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,84,73,70,70,80,114,101,100,105,99,116,111,114,67,108,101,97,110,117,112,0,40,99,99,37,40,98,112,115,42,115,116,114,105,100,101,41,41,61,61,48,0,102,112,68,105,102,102,0,80,114,101,100,105,99,116,111,114,69,110,99,111,100,101,84,105,108,101,0,115,112,45,62,101,110,99,111,100,101,112,102,117,110,99,32,33,61,32,78,85,76,76,0,115,112,45,
62,101,110,99,111,100,101,116,105,108,101,32,33,61,32,78,85,76,76,0,79,117,116,32,111,102,32,109,101,109,111,114,121,32,97,108,108,111,99,97,116,105,110,103,32,37,108,100,32,98,121,116,101,32,116,101,109,112,32,98,117,102,102,101,114,46,0,114,111,119,115,105,122,101,32,62,32,48,0,40,99,99,48,37,114,111,119,115,105,122,101,41,61,61,48,0,80,114,101,100,105,99,116,111,114,69,110,99,111,100,101,82,111,119,0,115,112,45,62,101,110,99,111,100,101,114,111,119,32,33,61,32,78,85,76,76,0,40,99,99,37,40,52,42,
115,116,114,105,100,101,41,41,61,61,48,0,104,111,114,68,105,102,102,51,50,0,40,99,99,37,40,50,42,115,116,114,105,100,101,41,41,61,61,48,0,104,111,114,68,105,102,102,49,54,0,40,99,99,37,115,116,114,105,100,101,41,61,61,48,0,104,111,114,68,105,102,102,56,0,80,114,101,100,105,99,116,111,114,83,101,116,117,112,0,72,111,114,105,122,111,110,116,97,108,32,100,105,102,102,101,114,101,110,99,105,110,103,32,34,80,114,101,100,105,99,116,111,114,34,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,119,
105,116,104,32,37,100,45,98,105,116,32,115,97,109,112,108,101,115,0,70,108,111,97,116,105,110,103,32,112,111,105,110,116,32,34,80,114,101,100,105,99,116,111,114,34,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,119,105,116,104,32,37,100,32,100,97,116,97,32,102,111,114,109,97,116,0,34,80,114,101,100,105,99,116,111,114,34,32,118,97,108,117,101,32,37,100,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,102,112,65,99,99,0,80,114,101,100,105,99,116,111,114,68,101,99,111,100,101,84,105,
108,101,0,115,112,45,62,100,101,99,111,100,101,116,105,108,101,32,33,61,32,78,85,76,76,0,40,111,99,99,48,37,114,111,119,115,105,122,101,41,61,61,48,0,115,112,45,62,100,101,99,111,100,101,112,102,117,110,99,32,33,61,32,78,85,76,76,0,80,114,101,100,105,99,116,111,114,68,101,99,111,100,101,82,111,119,0,115,112,45,62,100,101,99,111,100,101,114,111,119,32,33,61,32,78,85,76,76,0,104,111,114,65,99,99,51,50,0,104,111,114,65,99,99,49,54,0,104,111,114,65,99,99,56,0,32,32,80,114,101,100,105,99,116,111,114,58,
32,0,110,111,110,101,32,0,104,111,114,105,122,111,110,116,97,108,32,100,105,102,102,101,114,101,110,99,105,110,103,32,0,102,108,111,97,116,105,110,103,32,112,111,105,110,116,32,112,114,101,100,105,99,116,111,114,32,0,37,117,32,40,48,120,37,120,41,10,0,80,114,101,100,105,99,116,111,114,86,83,101,116,70,105,101,108,100,0,115,112,45,62,118,115,101,116,112,97,114,101,110,116,32,33,61,32,78,85,76,76,0,80,114,101,100,105,99,116,111,114,86,71,101,116,70],"i8",4,ra.GLOBAL_BASE+143490);vc([105,101,108,100,
0,115,112,45,62,118,103,101,116,112,97,114,101,110,116,32,33,61,32,78,85,76,76,0,80,114,101,100,105,99,116,111,114,0,84,104,117,110,100,101,114,68,101,99,111,100,101,82,111,119,0,70,114,97,99,116,105,111,110,97,108,32,115,99,97,110,108,105,110,101,115,32,99,97,110,110,111,116,32,98,101,32,114,101,97,100,0,78,111,116,32,101,110,111,117,103,104,0,84,111,111,32,109,117,99,104,0,84,104,117,110,100,101,114,68,101,99,111,100,101,0,37,115,32,100,97,116,97,32,97,116,32,115,99,97,110,108,105,110,101,32,37,
108,117,32,40,37,108,108,117,32,33,61,32,37,108,108,117,41,0,84,104,117,110,100,101,114,83,101,116,117,112,68,101,99,111,100,101,0,87,114,111,110,103,32,98,105,116,115,112,101,114,115,97,109,112,108,101,32,118,97,108,117,101,32,40,37,100,41,44,32,84,104,117,110,100,101,114,32,100,101,99,111,100,101,114,32,111,110,108,121,32,115,117,112,112,111,114,116,115,32,52,98,105,116,115,32,112,101,114,32,115,97,109,112,108,101,46,0,40,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,68,
69,70,76,65,84,69,41,32,124,124,32,40,115,99,104,101,109,101,32,61,61,32,67,79,77,80,82,69,83,83,73,79,78,95,65,68,79,66,69,95,68,69,70,76,65,84,69,41,0,116,105,102,95,122,105,112,46,99,0,84,73,70,70,73,110,105,116,90,73,80,0,77,101,114,103,105,110,103,32,68,101,102,108,97,116,101,32,99,111,100,101,99,45,115,112,101,99,105,102,105,99,32,116,97,103,115,32,102,97,105,108,101,100,0,78,111,32,115,112,97,99,101,32,102,111,114,32,90,73,80,32,115,116,97,116,101,32,98,108,111,99,107,0,115,112,32,33,61,32,
48,0,90,73,80,67,108,101,97,110,117,112,0,115,112,32,33,61,32,78,85,76,76,0,90,73,80,69,110,99,111,100,101,0,115,112,45,62,115,116,97,116,101,32,61,61,32,90,83,84,65,84,69,95,73,78,73,84,95,69,78,67,79,68,69,0,69,110,99,111,100,101,114,32,101,114,114,111,114,58,32,37,115,0,90,73,80,80,111,115,116,69,110,99,111,100,101,0,90,76,105,98,32,101,114,114,111,114,58,32,37,115,0,90,73,80,80,114,101,69,110,99,111,100,101,0,90,73,80,83,101,116,117,112,69,110,99,111,100,101,0,49,46,50,46,56,0,37,115,0,90,73,
80,68,101,99,111,100,101,0,115,112,45,62,115,116,97,116,101,32,61,61,32,90,83,84,65,84,69,95,73,78,73,84,95,68,69,67,79,68,69,0,68,101,99,111,100,105,110,103,32,101,114,114,111,114,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,44,32,37,115,0,78,111,116,32,101,110,111,117,103,104,32,100,97,116,97,32,97,116,32,115,99,97,110,108,105,110,101,32,37,108,117,32,40,115,104,111,114,116,32,37,108,117,32,98,121,116,101,115,41,0,90,73,80,80,114,101,68,101,99,111,100,101,0,90,73,80,83,101,116,117,112,
68,101,99,111,100,101,0,90,73,80,86,83,101,116,70,105,101,108,100,0,105,110,99,111,114,114,101,99,116,32,104,101,97,100,101,114,32,99,104,101,99,107,0,117,110,107,110,111,119,110,32,99,111,109,112,114,101,115,115,105,111,110,32,109,101,116,104,111,100,0,105,110,118,97,108,105,100,32,119,105,110,100,111,119,32,115,105,122,101,0,117,110,107,110,111,119,110,32,104,101,97,100,101,114,32,102,108,97,103,115,32,115,101,116,0,104,101,97,100,101,114,32,99,114,99,32,109,105,115,109,97,116,99,104,0,105,110,
118,97,108,105,100,32,98,108,111,99,107,32,116,121,112,101,0,105,110,118,97,108,105,100,32,115,116,111,114,101,100,32,98,108,111,99,107,32,108,101,110,103,116,104,115,0,116,111,111,32,109,97,110,121,32,108,101,110,103,116,104,32,111,114,32,100,105,115,116,97,110,99,101,32,115,121,109,98,111,108,115,0,105,110,118,97,108,105,100,32,99,111,100,101,32,108,101,110,103,116,104,115,32,115,101,116,0,105,110,118,97,108,105,100,32,98,105,116,32,108,101,110,103,116,104,32,114,101,112,101,97,116,0,105,110,118,
97,108,105,100,32,99,111,100,101,32,45,45,32,109,105,115,115,105,110,103,32,101,110,100,45,111,102,45,98,108,111,99,107,0,105,110,118,97,108,105,100,32,108,105,116,101,114,97,108,47,108,101,110,103,116,104,115,32,115,101,116,0,105,110,118,97,108,105,100,32,100,105,115,116,97,110,99,101,115,32,115,101,116,0,105,110,99,111,114,114,101,99,116,32,100,97,116,97,32,99,104,101,99,107,0,105,110,99,111,114,114,101,99,116,32,108,101,110,103,116,104,32,99,104,101,99,107,0,0,1,2,3,4,4,5,5,6,6,6,6,7,7,7,7,8,8,
8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,
14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,0,0,16,17,18,18,19,19,20,20,20,20,21,21,21,21,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,0,1,2,3,4,5,6,7,8,8,9,9,10,10,11,11,12,
12,12,12,13,13,13,13,14,14,14,14,15,15,15,15,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,28,16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15,110,101,101,100,32,100,105,99,116,105,111,110,97,114,121,0,115,116,114,101,97,109,32,101,110,100,0,0,102,105,108,101,32,101,114,114,111,114,0,115,116,114,101,97,109,32,101,114,114,111,114,0,100,97,116,97,32,101,114,114,111,114,0,105,110,115,
117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,0,98,117,102,102,101,114,32,101,114,114,111,114,0,105,110,99,111,109,112,97,116,105,98,108,101,32,118,101,114,115,105,111,110,0,105,110,118,97,108,105,100,32,100,105,115,116,97,110,99,101,32,116,111,111,32,102,97,114,32,98,97,99,107,0,105,110,118,97,108,105,100,32,100,105,115,116,97,110,99,101,32,99,111,100,101,0,105,110,118,97,108,105,100,32,108,105,116,101,114,97,108,47,108,101,110,103,116,104,32,99,111,100,101,0,0,0,1,5,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,0,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125,1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,
195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250,0,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,0,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119,0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,
116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,248,249,250,83,79,83,0,76,83,69,0,66,111,103,117,115,32,109,101,115,115,97,103,101,32,99,111,100,101,32,37,100,0,65,76,73,71,78,95,84,89,80,69,32,105,115,32,119,114,111,110,103,44,32,112,108,101,97,
115,101,32,102,105,120,0,77,65,88,95,65,76,76,79,67,95,67,72,85,78,75,32,105,115,32,119,114,111,110,103,44,32,112,108,101,97,115,101,32,102,105,120,0,66,111,103,117,115,32,98,117,102,102,101,114,32,99,111,110,116,114,111,108,32,109,111,100,101,0,73,110,118,97,108,105,100,32,99,111,109,112,111,110,101,110,116,32,73,68,32,37,100,32,105,110,32,83,79,83,0,73,110,118,97,108,105,100,32,99,114,111,112,32,114,101,113,117,101,115,116,0,68,67,84,32,99,111,101,102,102,105,99,105,101,110,116,32,111,117,116,32,
111,102,32,114,97,110,103,101,0,68,67,84,32,115,99,97,108,101,100,32,98,108,111,99,107,32,115,105,122,101,32,37,100,120,37,100,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,67,111,109,112,111,110,101,110,116,32,105,110,100,101,120,32,37,100,58,32,109,105,115,109,97,116,99,104,105,110,103,32,115,97,109,112,108,105,110,103,32,114,97,116,105,111,32,37,100,58,37,100,44,32,37,100,58,37,100,44,32,37,99,0,66,111,103,117,115,32,72,117,102,102,109,97,110,32,116,97,98,108,101,32,100,101,102,105,110,
105,116,105,111,110,0,66,111,103,117,115,32,105,110,112,117,116,32,99,111,108,111,114,115,112,97,99,101,0,66,111,103,117,115,32,74,80,69,71,32,99,111,108,111,114,115,112,97,99,101,0,66,111,103,117,115,32,109,97,114,107,101,114,32,108,101,110,103,116,104,0,87,114,111,110,103,32,74,80,69,71,32,108,105,98,114,97,114,121,32,118,101,114,115,105,111,110,58,32,108,105,98,114,97,114,121,32,105,115,32,37,100,44,32,99,97,108,108,101,114,32,101,120,112,101,99,116,115,32,37,100,0,83,97,109,112,108,105,110,103,
32,102,97,99,116,111,114,115,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,105,110,116,101,114,108,101,97,118,101,100,32,115,99,97,110,0,73,110,118,97,108,105,100,32,109,101,109,111,114,121,32,112,111,111,108,32,99,111,100,101,32,37,100,0,85,110,115,117,112,112,111,114,116,101,100,32,74,80,69,71,32,100,97,116,97,32,112,114,101,99,105,115,105,111,110,32,37,100,0,73,110,118,97,108,105,100,32,112,114,111,103,114,101,115,115,105,118,101,32,112,97,114,97,109,101,116,101,114,115,32,83,115,61,37,
100,32,83,101,61,37,100,32,65,104,61,37,100,32,65,108,61,37,100,0,73,110,118,97,108,105,100,32,112,114,111,103,114,101,115,115,105,118,101,32,112,97,114,97,109,101,116,101,114,115,32,97,116,32,115,99,97,110,32,115,99,114,105,112,116,32,101,110,116,114,121,32,37,100,0,66,111,103,117,115,32,115,97,109,112,108,105,110,103,32,102,97,99,116,111,114,115,0,73,110,118,97,108,105,100,32,115,99,97,110,32,115,99,114,105,112,116,32,97,116,32,101,110,116,114,121,32,37,100,0,73,109,112,114,111,112,101,114,32,99,
97,108,108,32,116,111,32,74,80,69,71,32,108,105,98,114,97,114,121,32,105,110,32,115,116,97,116,101,32,37,100,0,74,80,69,71,32,112,97,114,97,109,101,116,101,114,32,115,116,114,117,99,116,32,109,105,115,109,97,116,99,104,58,32,108,105,98,114,97,114,121,32,116,104,105,110,107,115,32,115,105,122,101,32,105,115,32,37,117,44,32,99,97,108,108,101,114,32,101,120,112,101,99,116,115,32,37,117,0,66,111,103,117,115,32,118,105,114,116,117,97,108,32,97,114,114,97,121,32,97,99,99,101,115,115,0,66,117,102,102,101,
114,32,112,97,115,115,101,100,32,116,111,32,74,80,69,71,32,108,105,98,114,97,114,121,32,105,115,32,116,111,111,32,115,109,97,108,108,0,83,117,115,112,101,110,115,105,111,110,32,110,111,116,32,97,108,108,111,119,101,100,32,104,101,114,101,0,67,67,73,82,54,48,49,32,115,97,109,112,108,105,110,103,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,32,121,101,116,0,84,111,111,32,109,97,110,121,32,99,111,108,111,114,32,99,111,109,112,111,110,101,110,116,115,58,32,37,100,44,32,109,97,120,32,37,
100,0,85,110,115,117,112,112,111,114,116,101,100,32,99,111,108,111,114,32,99,111,110,118,101,114,115,105,111,110,32,114,101,113,117,101,115,116,0,66,111,103,117,115,32,68,65,67,32,105,110,100,101,120,32,37,100,0,66,111,103,117,115,32,68,65,67,32,118,97,108,117,101,32,48,120,37,120,0,66,111,103,117,115,32,68,72,84,32,105,110,100,101,120,32,37,100,0,66,111,103,117,115,32,68,81,84,32,105,110,100,101,120,32,37,100,0,69,109,112,116,121,32,74,80,69,71,32,105,109,97,103,101,32,40,68,78,76,32,110,111,116,
32,115,117,112,112,111,114,116,101,100,41,0,82,101,97,100,32,102,114,111,109,32,69,77,83,32,102,97,105,108,101,100,0,87,114,105,116,101,32,116,111,32,69,77,83,32,102,97,105,108,101,100,0,68,105,100,110,39,116,32,101,120,112,101,99,116,32,109,111,114,101,32,116,104,97,110,32,111,110,101,32,115,99,97,110,0,73,110,112,117,116,32,102,105,108,101,32,114,101,97,100,32,101,114,114,111,114,0,79,117,116,112,117,116,32,102,105,108,101,32,119,114,105,116,101,32,101,114,114,111,114,32,45,45,45,32,111,117,116,
32,111,102,32,100,105,115,107,32,115,112,97,99,101,63,0,70,114,97,99,116,105,111,110,97,108,32,115,97,109,112,108,105,110,103,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,32,121,101,116,0,72,117,102,102,109,97,110,32,99,111,100,101,32,115,105,122,101,32,116,97,98,108,101,32,111,118,101,114,102,108,111,119,0,77,105,115,115,105,110,103,32,72,117,102,102,109,97,110,32,99,111,100,101,32,116,97,98,108,101,32,101,110,116,114,121,0,77,97,120,105,109,117,109,32,115,117,112,112,111,114,116,
101,100,32,105,109,97,103,101,32,100,105,109,101,110,115,105,111,110,32,105,115,32,37,117,32,112,105,120,101,108,115,0,69,109,112,116,121,32,105,110,112,117,116,32,102,105,108,101,0,80,114,101,109,97,116,117,114,101,32,101,110,100,32,111,102,32,105,110,112,117,116,32,102,105,108,101,0,67,97,110,110,111,116,32,116,114,97,110,115,99,111,100,101,32,100,117,101,32,116,111,32,109,117,108,116,105,112,108,101,32,117,115,101,32,111,102,32,113,117,97,110,116,105,122,97,116,105,111,110,32,116,97,98,108,101,
32,37,100,0,83,99,97,110,32,115,99,114,105,112,116,32,100,111,101,115,32,110,111,116,32,116,114,97,110,115,109,105,116,32,97,108,108,32,100,97,116,97,0,73,110,118,97,108,105,100,32,99,111,108,111,114,32,113,117,97,110,116,105,122,97,116,105,111,110,32,109,111,100,101,32,99,104,97,110,103,101,0,78,111,116,32,105,109,112,108,101,109,101,110,116,101,100,32,121,101,116,0,82,101,113,117,101,115,116,101,100,32,102,101,97,116,117,114,101,32,119,97,115,32,111,109,105,116,116,101,100,32,97,116,32,99,111,109,
112,105,108,101,32,116,105,109,101,0,65,114,105,116,104,109,101,116,105,99,32,116,97,98,108,101,32,48,120,37,48,50,120,32,119,97,115,32,110,111,116,32,100,101,102,105,110,101,100,0,66,97,99,107,105,110,103,32,115,116,111,114,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,72,117,102,102,109,97,110,32,116,97,98,108,101,32,48,120,37,48,50,120,32,119,97,115,32,110,111,116,32,100,101,102,105,110,101,100,0,74,80,69,71,32,100,97,116,97,115,116,114,101,97,109,32,99,111,110,116,97,105,110,115,
32,110,111,32,105,109,97,103,101,0,81,117,97,110,116,105,122,97,116,105,111,110,32,116,97,98,108,101,32,48,120,37,48,50,120,32,119,97,115,32,110,111,116,32,100,101,102,105,110,101,100,0,78,111,116,32,97,32,74,80,69,71,32,102,105,108,101,58,32,115,116,97,114,116,115,32,119,105,116,104,32,48,120,37,48,50,120,32,48,120,37,48,50,120,0,73,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,32,40,99,97,115,101,32,37,100,41,0,67,97,110,110,111,116,32,113,117,97,110,116,105,122,101,32,109,
111,114,101,32,116,104,97,110,32,37,100,32,99,111,108,111,114,32,99,111,109,112,111,110,101,110,116,115,0,67,97,110,110,111,116,32,113,117,97,110,116,105,122,101,32,116,111,32,102,101,119,101,114,32,116,104,97,110,32,37,100,32,99,111,108,111,114,115,0,67,97,110,110,111,116,32,113,117,97,110,116,105,122,101,32,116,111,32,109,111,114,101,32,116,104,97,110,32,37,100,32,99,111,108,111,114,115,0,73,110,118,97,108,105,100,32,74,80,69,71,32,102,105,108,101,32,115,116,114,117,99,116,117,114,101,58,32,37,
115,32,98,101,102,111,114,101,32,83,79,70,0,73,110,118,97,108,105,100,32,74,80,69,71,32,102,105,108,101,32,115,116,114,117,99,116,117,114,101,58,32,116,119,111,32,83,79,70,32,109,97,114,107,101,114,115,0,73,110,118,97,108,105,100,32,74,80,69,71,32,102,105,108,101,32,115,116,114,117,99,116,117,114,101,58,32,109,105,115,115,105,110,103,32,83,79,83,32,109,97,114,107,101,114,0,85,110,115,117,112,112,111,114,116,101,100,32,74,80,69,71,32,112,114,111,99,101,115,115,58,32,83,79,70,32,116,121,112,101,32,
48,120,37,48,50,120,0,73,110,118,97,108,105,100,32,74,80,69,71,32,102,105,108,101,32,115,116,114,117,99,116,117,114,101,58,32,116,119,111,32,83,79,73,32,109,97,114,107,101,114,115,0,70,97,105,108,101,100,32,116,111,32,99,114,101,97,116,101,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,32,37,115,0,82,101,97,100,32,102,97,105,108,101,100,32,111,110,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,0,83,101,101,107,32,102,97,105,108,101,100,32,111,110,32,116,101,109,112,111,114,97,
114,121,32,102,105,108,101,0,87,114,105,116,101,32,102,97,105,108,101,100,32,111,110,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,32,45,45,45,32,111,117,116,32,111,102,32,100,105,115,107,32,115,112,97,99,101,63,0,65,112,112,108,105,99,97,116,105,111,110,32,116,114,97,110,115,102,101,114,114,101,100,32,116,111,111,32,102,101,119,32,115,99,97,110,108,105,110,101,115,0,85,110,115,117,112,112,111,114,116,101,100,32,109,97,114,107,101,114,32,116,121,112,101,32,48,120,37,48,50,120,0,86,105,
114,116,117,97,108,32,97,114,114,97,121,32,99,111,110,116,114,111,108,108,101,114,32,109,101,115,115,101,100,32,117,112,0,73,109,97,103,101,32,116,111,111,32,119,105,100,101,32,102,111,114,32,116,104,105,115,32,105,109,112,108,101,109,101,110,116,97,116,105,111,110,0,82,101,97,100,32,102,114,111,109,32,88,77,83,32,102,97,105,108,101,100,0,87,114,105,116,101,32,116,111,32,88,77,83,32,102,97,105,108,101,100,0,67,111,112,121,114,105,103,104,116,32,40,67,41,32,50,48,49,54,44,32,84,104,111,109,97,115,
32,71,46,32,76,97,110,101,44,32,71,117,105,100,111,32,86,111,108,108,98,101,100,105,110,103,0,57,98,32,32,49,55,45,74,97,110,45,50,48,49,54,0,67,97,117,116,105,111,110,58,32,113,117,97,110,116,105,122,97,116,105,111,110,32,116,97,98,108,101,115,32,97,114,101,32,116,111,111,32,99,111,97,114,115,101,32,102,111,114,32,98,97,115,101,108,105,110,101,32,74,80,69,71,0,65,100,111,98,101,32,65,80,80,49,52,32,109,97,114,107,101,114,58,32,118,101,114,115,105,111,110,32,37,100,44,32,102,108,97,103,115,32,48,
120,37,48,52,120,32,48,120,37,48,52,120,44,32,116,114,97,110,115,102,111,114,109,32,37,100,0,85,110,107,110,111,119,110,32,65,80,80,48,32,109,97,114,107,101,114,32,40,110,111,116,32,74,70,73,70,41,44,32,108,101,110,103,116,104,32,37,117,0,85,110,107,110,111,119,110,32,65,80,80,49,52,32,109,97,114,107,101,114,32,40,110,111,116,32,65,100,111,98,101,41,44,32,108,101,110,103,116,104,32,37,117,0,68,101,102,105,110,101,32,65,114,105,116,104,109,101,116,105,99,32,84,97,98,108,101,32,48,120,37,48,50,120,
58,32,48,120,37,48,50,120,0,68,101,102,105,110,101,32,72,117,102,102,109,97,110,32,84,97,98,108,101,32,48,120,37,48,50,120,0,68,101,102,105,110,101,32,81,117,97,110,116,105,122,97,116,105,111,110,32,84,97,98,108,101,32,37,100,32,32,112,114,101,99,105,115,105,111,110,32,37,100,0,68,101,102,105,110,101,32,82,101,115,116,97,114,116,32,73,110,116,101,114,118,97,108,32,37,117,0,70,114,101,101,100,32,69,77,83,32,104,97,110,100,108,101,32,37,117,0,79,98,116,97,105,110,101,100,32,69,77,83,32,104,97,110,100,
108,101,32,37,117,0,69,110,100,32,79,102,32,73,109,97,103,101,0,32,32,32,32,32,32,32,32,37,51,100,32,37,51,100,32,37,51,100,32,37,51,100,32,37,51,100,32,37,51,100,32,37,51,100,32,37,51,100,0,74,70,73,70,32,65,80,80,48,32,109,97,114,107,101,114,58,32,118,101,114,115,105,111,110,32,37,100,46,37,48,50,100,44,32,100,101,110,115,105,116,121,32,37,100,120,37,100,32,32,37,100,0,87,97,114,110,105,110,103,58,32,116,104,117,109,98,110,97,105,108,32,105,109,97,103,101,32,115,105,122,101,32,100,111,101,115,32,
110,111,116,32,109,97,116,99,104,32,100,97,116,97,32,108,101,110,103,116,104,32,37,117,0,74,70,73,70,32,101,120,116,101,110,115,105,111,110,32,109,97,114,107,101,114,58,32,116,121,112,101,32,48,120,37,48,50,120,44,32,108,101,110,103,116,104,32,37,117,0,32,32,32,32,119,105,116,104,32,37,100,32,120,32,37,100,32,116,104,117,109,98,110,97,105,108,32,105,109,97,103,101,0,77,105,115,99,101,108,108,97,110,101,111,117,115,32,109,97,114,107,101,114,32,48,120,37,48,50,120,44,32,108,101,110,103,116,104,32,37,
117,0,85,110,101,120,112,101,99,116,101,100,32,109,97,114,107,101,114,32,48,120,37,48,50,120,0,32,32,32,32,32,32,32,32,37,52,117,32,37,52,117,32,37,52,117,32,37,52,117,32,37,52,117,32,37,52,117,32,37,52,117,32,37,52,117,0,81,117,97,110,116,105,122,105,110,103,32,116,111,32,37,100,32,61,32,37,100,42,37,100,42,37,100,32,99,111,108,111,114,115,0,81,117,97,110,116,105,122,105,110,103,32,116,111,32,37,100,32,99,111,108,111,114,115,0,83,101,108,101,99,116,101,100,32,37,100,32,99,111,108,111,114,115,32,
102,111,114,32,113,117,97,110,116,105,122,97,116,105,111,110,0,65,116,32,109,97,114,107,101,114,32,48,120,37,48,50,120,44,32,114,101,99,111,118,101,114,121,32,97,99,116,105,111,110,32,37,100,0,82,83,84,37,100,0,83,109,111,111,116,104,105,110,103,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,119,105,116,104,32,110,111,110,115,116,97,110,100,97,114,100,32,115,97,109,112,108,105,110,103,32,114,97,116,105,111,115,0,83,116,97,114,116,32,79,102,32,70,114,97,109,101,32,48,120,37,48,50,120,58,
32,119,105,100,116,104,61,37,117,44,32,104,101,105,103,104,116,61,37,117,44,32,99,111,109,112,111,110,101,110,116,115,61,37,100,0,32,32,32,32,67,111,109,112,111,110,101,110,116,32,37,100,58,32,37,100,104,120,37,100,118,32,113,61,37,100,0,83,116,97,114,116,32,111,102,32,73,109,97,103,101,0,83,116,97,114,116,32,79,102,32,83,99,97,110,58,32,37,100,32,99,111,109,112,111,110,101,110,116,115,0,32,32,32,32,67,111,109,112,111,110,101,110,116,32,37,100,58,32,100,99,61,37,100,32,97,99,61,37,100,0,32,32,83,
115,61,37,100,44,32,83,101,61,37,100,44,32,65,104,61,37,100,44,32,65,108,61,37,100,0,67,108,111,115,101,100,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,32,37,115,0,79,112,101,110,101,100,32,116,101,109,112,111,114,97,114,121,32,102,105,108,101,32,37,115,0,74,70,73,70,32,101,120,116,101,110,115,105,111,110,32,109,97,114,107,101,114,58,32,74,80,69,71,45,99,111,109,112,114,101,115,115,101,100,32,116,104,117,109,98,110,97,105,108,32,105,109,97,103,101,44,32,108,101,110,103,116,104,32,37,
117,0,74,70,73,70,32,101,120,116,101,110,115,105,111,110,32,109,97,114,107,101,114,58,32,112,97,108,101,116,116,101,32,116,104,117,109,98,110,97,105,108,32,105,109,97,103,101,44,32,108,101,110,103,116,104,32,37,117,0,74,70,73,70,32,101,120,116,101,110,115,105,111,110,32,109,97,114,107,101,114,58,32,82,71,66,32,116,104,117,109,98,110,97,105,108,32,105,109,97,103,101,44,32,108,101,110,103,116,104,32,37,117,0,85,110,114,101,99,111,103,110,105,122,101,100,32,99,111,109,112,111,110,101,110,116,32,73,68,
115,32,37,100,32,37,100,32,37,100,44,32,97,115,115,117,109,105,110,103,32,89,67,98,67,114,0,70,114,101,101,100,32,88,77,83,32,104,97,110,100,108,101,32,37,117,0,79,98,116,97,105,110,101,100,32,88,77,83,32,104,97,110,100,108,101,32,37,117,0,85,110,107,110,111,119,110,32,65,100,111,98,101,32,99,111,108,111,114,32,116,114,97,110,115,102,111,114,109,32,99,111,100,101,32,37,100,0,67,111,114,114,117,112,116,32,74,80,69,71,32,100,97,116,97,58,32,98,97,100,32,97,114,105,116,104,109,101,116,105,99,32,99,111,
100,101,0,73,110,99,111,110,115,105,115,116,101,110,116,32,112,114,111,103,114,101,115,115,105,111,110,32,115,101,113,117,101,110,99,101,32,102,111,114,32,99,111,109,112,111,110,101,110,116,32,37,100,32,99,111,101,102,102,105,99,105,101,110,116,32,37,100,0,67,111,114,114,117,112,116,32,74,80,69,71,32,100,97,116,97,58,32,37,117,32,101,120,116,114,97,110,101,111,117,115,32,98,121,116,101,115,32,98,101,102,111,114,101,32,109,97,114,107,101,114,32,48,120,37,48,50,120,0,67,111,114,114,117,112,116,32,74,
80,69,71,32,100,97,116,97,58,32,112,114,101,109,97,116,117,114,101,32,101,110,100,32,111,102,32,100,97,116,97,32,115,101,103,109,101,110,116,0,67,111,114,114,117,112,116,32,74,80,69,71,32,100,97,116,97,58,32,98,97,100,32,72,117,102,102,109,97,110,32,99,111,100,101,0,87,97,114,110,105,110,103,58,32,117,110,107,110,111,119,110,32,74,70,73,70,32,114,101,118,105,115,105,111,110,32,110,117,109,98,101,114,32,37,100,46,37,48,50,100,0,80,114,101,109,97,116,117,114,101,32,101,110,100,32,111,102,32,74,80,69,
71,32,102,105,108,101,0,67,111,114,114,117,112,116,32,74,80,69,71,32,100,97,116,97,58,32,102,111,117,110,100,32,109,97,114,107,101,114,32,48,120,37,48,50,120,32,105,110,115,116,101,97,100,32,111,102,32,82,83,84,37,100,0,73,110,118,97,108,105,100,32,83,79,83,32,112,97,114,97,109,101,116,101,114,115,32,102,111,114,32,115,101,113,117,101,110,116,105,97,108,32,74,80,69,71,0,65,112,112,108,105,99,97,116,105,111,110,32,116,114,97,110,115,102,101,114,114,101,100,32,116,111,111,32,109,97,110,121,32,115,99,
97,110,108,105,110,101,115,0,37,115,10,0,0,192,48,240,12,204,60,252,3,195,51,243,15,207,63,255,128,64,176,112,140,76,188,124,131,67,179,115,143,79,191,127,32,224,16,208,44,236,28,220,35,227,19,211,47,239,31,223,160,96,144,80,172,108,156,92,163,99,147,83,175,111,159,95,8,200,56,248,4,196,52,244,11,203,59,251,7,199,55,247,136,72,184,120,132,68,180,116,139,75,187,123,135,71,183,119,40,232,24,216,36,228,20,212,43,235,27,219,39,231,23,215,168,104,152,88,164,100,148,84,171,107,155,91,167,103,151,87,2,194,
50,242,14,206,62,254,1,193,49,241,13,205,61,253,130,66,178,114,142,78,190,126,129,65,177,113,141,77,189,125,34,226,18,210,46,238,30,222,33,225,17,209,45,237,29,221,162,98,146,82,174,110,158,94,161,97,145,81,173,109,157,93,10,202,58,250,6,198,54,246,9,201,57,249,5,197,53,245,138,74,186,122,134,70,182,118,137,73,185,121,133,69,181,117,42,234,26,218,38,230,22,214,41,233,25,217,37,229,21,213,170,106,154,90,166,102,150,86,169,105,153,89,165,101,149,85,74,80,69,71,77,69,77,0,37,108,100,37,99,0,84,33,34,
25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,
97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,
99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,
45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,
100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,
98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,
32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,
111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,
101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,
101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,
114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,
100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,
99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,
109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,105,110,102,105,110,105,116,121,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,4,7,3,6,5],"i8",4,ra.GLOBAL_BASE+153730);vc([17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,
0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0],"i8",4,ra.GLOBAL_BASE+164446);var ai=ra.alignMemory(vc(12,"i8",2),8);fb(0==ai%8);var ca={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,
EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,
ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,
ESTRPIPE:86},Kj={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",
23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",
43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",
64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",
81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",
98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",
115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"},ye={ttys:[],init:function(){},shutdown:function(){},register:function(r,v){ye.ttys[r]={input:[],output:[],ops:v};D.registerDevice(r,ye.stream_ops)},stream_ops:{open:function(r){var v=ye.ttys[r.node.rdev];if(!v)throw new D.ErrnoError(ca.ENODEV);r.tty=v;r.seekable=!1},close:function(r){r.tty.ops.flush(r.tty)},
flush:function(r){r.tty.ops.flush(r.tty)},read:function(r,v,A,fa,F){if(!r.tty||!r.tty.ops.get_char)throw new D.ErrnoError(ca.ENXIO);for(var aa=F=0;aa<fa;aa++){var ya;try{ya=r.tty.ops.get_char(r.tty)}catch(S){throw new D.ErrnoError(ca.EIO);}if(void 0===ya&&0===F)throw new D.ErrnoError(ca.EAGAIN);if(null===ya||void 0===ya)break;F++;v[A+aa]=ya}F&&(r.node.timestamp=Date.now());return F},write:function(r,v,A,fa,F){if(!r.tty||!r.tty.ops.put_char)throw new D.ErrnoError(ca.ENXIO);for(F=0;F<fa;F++)try{r.tty.ops.put_char(r.tty,
v[A+F])}catch(aa){throw new D.ErrnoError(ca.EIO);}fa&&(r.node.timestamp=Date.now());return F}},default_tty_ops:{get_char:function(r){if(!r.input.length){var v=null;if(Bf){var v=new Buffer(256),A,D=process.stdin.fd,F=!1;try{D=cd.openSync("/dev/stdin","r"),F=!0}catch(aa){}A=cd.readSync(D,v,0,256,null);F&&cd.closeSync(D);v=0<A?v.slice(0,A).toString("utf-8"):null}else"undefined"!=typeof window&&"function"==typeof window.prompt?(v=window.prompt("Input: "),null!==v&&(v+="\n")):"function"==typeof readline&&
(v=readline(),null!==v&&(v+="\n"));if(!v)return null;r.input=yf(v,!0)}return r.input.shift()},put_char:function(r,v){null===v||10===v?(F.print(nf(r.output,0)),r.output=[]):0!=v&&r.output.push(v)},flush:function(r){r.output&&0<r.output.length&&(F.print(nf(r.output,0)),r.output=[])}},default_tty1_ops:{put_char:function(r,v){null===v||10===v?(F.printErr(nf(r.output,0)),r.output=[]):0!=v&&r.output.push(v)},flush:function(r){r.output&&0<r.output.length&&(F.printErr(nf(r.output,0)),r.output=[])}}},lc={ops_table:null,
mount:function(r){return lc.createNode(null,"/",16895,0)},createNode:function(r,v,A,fa){if(D.isBlkdev(A)||D.isFIFO(A))throw new D.ErrnoError(ca.EPERM);lc.ops_table||(lc.ops_table={dir:{node:{getattr:lc.node_ops.getattr,setattr:lc.node_ops.setattr,lookup:lc.node_ops.lookup,mknod:lc.node_ops.mknod,rename:lc.node_ops.rename,unlink:lc.node_ops.unlink,rmdir:lc.node_ops.rmdir,readdir:lc.node_ops.readdir,symlink:lc.node_ops.symlink},stream:{llseek:lc.stream_ops.llseek}},file:{node:{getattr:lc.node_ops.getattr,
setattr:lc.node_ops.setattr},stream:{llseek:lc.stream_ops.llseek,read:lc.stream_ops.read,write:lc.stream_ops.write,allocate:lc.stream_ops.allocate,mmap:lc.stream_ops.mmap,msync:lc.stream_ops.msync}},link:{node:{getattr:lc.node_ops.getattr,setattr:lc.node_ops.setattr,readlink:lc.node_ops.readlink},stream:{}},chrdev:{node:{getattr:lc.node_ops.getattr,setattr:lc.node_ops.setattr},stream:D.chrdev_stream_ops}});A=D.createNode(r,v,A,fa);D.isDir(A.mode)?(A.node_ops=lc.ops_table.dir.node,A.stream_ops=lc.ops_table.dir.stream,
A.contents={}):D.isFile(A.mode)?(A.node_ops=lc.ops_table.file.node,A.stream_ops=lc.ops_table.file.stream,A.usedBytes=0,A.contents=null):D.isLink(A.mode)?(A.node_ops=lc.ops_table.link.node,A.stream_ops=lc.ops_table.link.stream):D.isChrdev(A.mode)&&(A.node_ops=lc.ops_table.chrdev.node,A.stream_ops=lc.ops_table.chrdev.stream);A.timestamp=Date.now();r&&(r.contents[v]=A);return A},getFileDataAsRegularArray:function(r){if(r.contents&&r.contents.subarray){for(var v=[],A=0;A<r.usedBytes;++A)v.push(r.contents[A]);
return v}return r.contents},getFileDataAsTypedArray:function(r){return r.contents?r.contents.subarray?r.contents.subarray(0,r.usedBytes):new Uint8Array(r.contents):new Uint8Array},expandFileStorage:function(r,v){r.contents&&r.contents.subarray&&v>r.contents.length&&(r.contents=lc.getFileDataAsRegularArray(r),r.usedBytes=r.contents.length);if(!r.contents||r.contents.subarray){var A=r.contents?r.contents.buffer.byteLength:0;A>=v||(v=Math.max(v,A*(1048576>A?2:1.125)|0),0!=A&&(v=Math.max(v,256)),A=r.contents,
r.contents=new Uint8Array(v),0<r.usedBytes&&r.contents.set(A.subarray(0,r.usedBytes),0))}else for(!r.contents&&0<v&&(r.contents=[]);r.contents.length<v;)r.contents.push(0)},resizeFileStorage:function(r,v){if(r.usedBytes!=v)if(0==v)r.contents=null,r.usedBytes=0;else{if(!r.contents||r.contents.subarray){var A=r.contents;r.contents=new Uint8Array(new ArrayBuffer(v));A&&r.contents.set(A.subarray(0,Math.min(v,r.usedBytes)))}else if(r.contents||(r.contents=[]),r.contents.length>v)r.contents.length=v;else for(;r.contents.length<
v;)r.contents.push(0);r.usedBytes=v}},node_ops:{getattr:function(r){var v={};v.dev=D.isChrdev(r.mode)?r.id:1;v.ino=r.id;v.mode=r.mode;v.nlink=1;v.uid=0;v.gid=0;v.rdev=r.rdev;D.isDir(r.mode)?v.size=4096:D.isFile(r.mode)?v.size=r.usedBytes:D.isLink(r.mode)?v.size=r.link.length:v.size=0;v.atime=new Date(r.timestamp);v.mtime=new Date(r.timestamp);v.ctime=new Date(r.timestamp);v.blksize=4096;v.blocks=Math.ceil(v.size/v.blksize);return v},setattr:function(r,v){void 0!==v.mode&&(r.mode=v.mode);void 0!==
v.timestamp&&(r.timestamp=v.timestamp);void 0!==v.size&&lc.resizeFileStorage(r,v.size)},lookup:function(r,v){throw D.genericErrors[ca.ENOENT];},mknod:function(r,v,A,D){return lc.createNode(r,v,A,D)},rename:function(r,v,A){if(D.isDir(r.mode)){var fa;try{fa=D.lookupNode(v,A)}catch(F){}if(fa)for(var yc in fa.contents)throw new D.ErrnoError(ca.ENOTEMPTY);}delete r.parent.contents[r.name];r.name=A;v.contents[A]=r;r.parent=v},unlink:function(r,v){delete r.contents[v]},rmdir:function(r,v){var A=D.lookupNode(r,
v),fa;for(fa in A.contents)throw new D.ErrnoError(ca.ENOTEMPTY);delete r.contents[v]},readdir:function(r){var v=[".",".."],A;for(A in r.contents)r.contents.hasOwnProperty(A)&&v.push(A);return v},symlink:function(r,v,A){r=lc.createNode(r,v,41471,0);r.link=A;return r},readlink:function(r){if(!D.isLink(r.mode))throw new D.ErrnoError(ca.EINVAL);return r.link}},stream_ops:{read:function(r,v,A,D,F){var aa=r.node.contents;if(F>=r.node.usedBytes)return 0;r=Math.min(r.node.usedBytes-F,D);fb(0<=r);if(8<r&&
aa.subarray)v.set(aa.subarray(F,F+r),A);else for(D=0;D<r;D++)v[A+D]=aa[F+D];return r},write:function(r,v,A,D,F,aa){if(!D)return 0;r=r.node;r.timestamp=Date.now();if(v.subarray&&(!r.contents||r.contents.subarray)){if(aa)return r.contents=v.subarray(A,A+D),r.usedBytes=D;if(0===r.usedBytes&&0===F)return r.contents=new Uint8Array(v.subarray(A,A+D)),r.usedBytes=D;if(F+D<=r.usedBytes)return r.contents.set(v.subarray(A,A+D),F),D}lc.expandFileStorage(r,F+D);if(r.contents.subarray&&v.subarray)r.contents.set(v.subarray(A,
A+D),F);else for(aa=0;aa<D;aa++)r.contents[F+aa]=v[A+aa];r.usedBytes=Math.max(r.usedBytes,F+D);return D},llseek:function(r,v,A){1===A?v+=r.position:2===A&&D.isFile(r.node.mode)&&(v+=r.node.usedBytes);if(0>v)throw new D.ErrnoError(ca.EINVAL);return v},allocate:function(r,v,A){lc.expandFileStorage(r.node,v+A);r.node.usedBytes=Math.max(r.node.usedBytes,v+A)},mmap:function(r,v,A,fa,F,aa,ya){if(!D.isFile(r.node.mode))throw new D.ErrnoError(ca.ENODEV);A=r.node.contents;if(ya&2||A.buffer!==v&&A.buffer!==
v.buffer){if(0<F||F+fa<r.node.usedBytes)A=A.subarray?A.subarray(F,F+fa):Array.prototype.slice.call(A,F,F+fa);r=!0;fa=uf(fa);if(!fa)throw new D.ErrnoError(ca.ENOMEM);v.set(A,fa)}else r=!1,fa=A.byteOffset;return{ptr:fa,allocated:r}},msync:function(r,v,A,fa,F){if(!D.isFile(r.node.mode))throw new D.ErrnoError(ca.ENODEV);if(F&2)return 0;lc.stream_ops.write(r,v,0,fa,A,!1);return 0}}},Bc={dbs:{},indexedDB:function(){if("undefined"!==typeof indexedDB)return indexedDB;var r=null;"object"===typeof window&&
(r=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB);fb(r,"IDBFS used, but indexedDB not supported");return r},DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:function(r){return lc.mount.apply(null,arguments)},syncfs:function(r,v,A){Bc.getLocalSet(r,function(D,F){if(D)return A(D);Bc.getRemoteSet(r,function(r,D){if(r)return A(r);Bc.reconcile(v?D:F,v?F:D,A)})})},getDB:function(r,v){var A=Bc.dbs[r];if(A)return v(null,A);var D;try{D=Bc.indexedDB().open(r,Bc.DB_VERSION)}catch(F){return v(F)}D.onupgradeneeded=
function(r){var v=r.target.result;r=r.target.transaction;v=v.objectStoreNames.contains(Bc.DB_STORE_NAME)?r.objectStore(Bc.DB_STORE_NAME):v.createObjectStore(Bc.DB_STORE_NAME);v.indexNames.contains("timestamp")||v.createIndex("timestamp","timestamp",{unique:!1})};D.onsuccess=function(){A=D.result;Bc.dbs[r]=A;v(null,A)};D.onerror=function(r){v(this.error);r.preventDefault()}},getLocalSet:function(r,v){function A(r){return"."!==r&&".."!==r}function fa(r){return function(v){return jc.join2(r,v)}}for(var F=
{},aa=D.readdir(r.mountpoint).filter(A).map(fa(r.mountpoint));aa.length;){var ya=aa.pop(),S;try{S=D.stat(ya)}catch(ca){return v(ca)}D.isDir(S.mode)&&aa.push.apply(aa,D.readdir(ya).filter(A).map(fa(ya)));F[ya]={timestamp:S.mtime}}return v(null,{type:"local",entries:F})},getRemoteSet:function(r,v){var A={};Bc.getDB(r.mountpoint,function(r,D){if(r)return v(r);var F=D.transaction([Bc.DB_STORE_NAME],"readonly");F.onerror=function(r){v(this.error);r.preventDefault()};F.objectStore(Bc.DB_STORE_NAME).index("timestamp").openKeyCursor().onsuccess=
function(r){r=r.target.result;if(!r)return v(null,{type:"remote",db:D,entries:A});A[r.primaryKey]={timestamp:r.key};r["continue"]()}})},loadLocalEntry:function(r,v){var A,fa;try{fa=D.lookupPath(r).node,A=D.stat(r)}catch(F){return v(F)}return D.isDir(A.mode)?v(null,{timestamp:A.mtime,mode:A.mode}):D.isFile(A.mode)?(fa.contents=lc.getFileDataAsTypedArray(fa),v(null,{timestamp:A.mtime,mode:A.mode,contents:fa.contents})):v(Error("node type not supported"))},storeLocalEntry:function(r,v,A){try{if(D.isDir(v.mode))D.mkdir(r,
v.mode);else if(D.isFile(v.mode))D.writeFile(r,v.contents,{encoding:"binary",canOwn:!0});else return A(Error("node type not supported"));D.chmod(r,v.mode);D.utime(r,v.timestamp,v.timestamp)}catch(fa){return A(fa)}A(null)},removeLocalEntry:function(r,v){try{D.lookupPath(r);var A=D.stat(r);D.isDir(A.mode)?D.rmdir(r):D.isFile(A.mode)&&D.unlink(r)}catch(fa){return v(fa)}v(null)},loadRemoteEntry:function(r,v,A){r=r.get(v);r.onsuccess=function(r){A(null,r.target.result)};r.onerror=function(r){A(this.error);
r.preventDefault()}},storeRemoteEntry:function(r,v,A,D){r=r.put(A,v);r.onsuccess=function(){D(null)};r.onerror=function(r){D(this.error);r.preventDefault()}},removeRemoteEntry:function(r,v,A){r=r["delete"](v);r.onsuccess=function(){A(null)};r.onerror=function(r){A(this.error);r.preventDefault()}},reconcile:function(r,v,A){function D(r){if(r){if(!D.errored)return D.errored=!0,A(r)}else if(++S>=F)return A(null)}var F=0,aa=[];Object.keys(r.entries).forEach(function(A){var D=r.entries[A],fa=v.entries[A];
if(!fa||D.timestamp>fa.timestamp)aa.push(A),F++});var ya=[];Object.keys(v.entries).forEach(function(v){r.entries[v]||(ya.push(v),F++)});if(!F)return A(null);var S=0,ca=("remote"===r.type?r.db:v.db).transaction([Bc.DB_STORE_NAME],"readwrite"),Xd=ca.objectStore(Bc.DB_STORE_NAME);ca.onerror=function(r){D(this.error);r.preventDefault()};aa.sort().forEach(function(r){"local"===v.type?Bc.loadRemoteEntry(Xd,r,function(v,A){if(v)return D(v);Bc.storeLocalEntry(r,A,D)}):Bc.loadLocalEntry(r,function(v,A){if(v)return D(v);
Bc.storeRemoteEntry(Xd,r,A,D)})});ya.sort().reverse().forEach(function(r){"local"===v.type?Bc.removeLocalEntry(r,D):Bc.removeRemoteEntry(Xd,r,D)})}},Wc={isWindows:!1,staticInit:function(){Wc.isWindows=!!process.platform.match(/^win/)},mount:function(r){fb(Bf);return Wc.createNode(null,"/",Wc.getMode(r.opts.root),0)},createNode:function(r,v,A,fa){if(!D.isDir(A)&&!D.isFile(A)&&!D.isLink(A))throw new D.ErrnoError(ca.EINVAL);r=D.createNode(r,v,A);r.node_ops=Wc.node_ops;r.stream_ops=Wc.stream_ops;return r},
getMode:function(r){var v;try{v=cd.lstatSync(r),Wc.isWindows&&(v.mode|=(v.mode&146)>>1)}catch(A){if(!A.code)throw A;throw new D.ErrnoError(ca[A.code]);}return v.mode},realPath:function(r){for(var v=[];r.parent!==r;)v.push(r.name),r=r.parent;v.push(r.mount.opts.root);v.reverse();return jc.join.apply(null,v)},flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",
1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:function(r){r&=-32769;if(r in Wc.flagsToPermissionStringMap)return Wc.flagsToPermissionStringMap[r];throw new D.ErrnoError(ca.EINVAL);},node_ops:{getattr:function(r){r=Wc.realPath(r);var v;try{v=cd.lstatSync(r)}catch(A){if(!A.code)throw A;throw new D.ErrnoError(ca[A.code]);}Wc.isWindows&&!v.blksize&&(v.blksize=4096);Wc.isWindows&&!v.blocks&&(v.blocks=(v.size+v.blksize-1)/v.blksize|0);return{dev:v.dev,ino:v.ino,mode:v.mode,
nlink:v.nlink,uid:v.uid,gid:v.gid,rdev:v.rdev,size:v.size,atime:v.atime,mtime:v.mtime,ctime:v.ctime,blksize:v.blksize,blocks:v.blocks}},setattr:function(r,v){var A=Wc.realPath(r);try{void 0!==v.mode&&(cd.chmodSync(A,v.mode),r.mode=v.mode);if(void 0!==v.timestamp){var fa=new Date(v.timestamp);cd.utimesSync(A,fa,fa)}void 0!==v.size&&cd.truncateSync(A,v.size)}catch(F){if(!F.code)throw F;throw new D.ErrnoError(ca[F.code]);}},lookup:function(r,v){var A=jc.join2(Wc.realPath(r),v),A=Wc.getMode(A);return Wc.createNode(r,
v,A)},mknod:function(r,v,A,fa){r=Wc.createNode(r,v,A,fa);v=Wc.realPath(r);try{D.isDir(r.mode)?cd.mkdirSync(v,r.mode):cd.writeFileSync(v,"",{mode:r.mode})}catch(F){if(!F.code)throw F;throw new D.ErrnoError(ca[F.code]);}return r},rename:function(r,v,A){r=Wc.realPath(r);v=jc.join2(Wc.realPath(v),A);try{cd.renameSync(r,v)}catch(fa){if(!fa.code)throw fa;throw new D.ErrnoError(ca[fa.code]);}},unlink:function(r,v){var A=jc.join2(Wc.realPath(r),v);try{cd.unlinkSync(A)}catch(fa){if(!fa.code)throw fa;throw new D.ErrnoError(ca[fa.code]);
}},rmdir:function(r,v){var A=jc.join2(Wc.realPath(r),v);try{cd.rmdirSync(A)}catch(fa){if(!fa.code)throw fa;throw new D.ErrnoError(ca[fa.code]);}},readdir:function(r){r=Wc.realPath(r);try{return cd.readdirSync(r)}catch(v){if(!v.code)throw v;throw new D.ErrnoError(ca[v.code]);}},symlink:function(r,v,A){r=jc.join2(Wc.realPath(r),v);try{cd.symlinkSync(A,r)}catch(fa){if(!fa.code)throw fa;throw new D.ErrnoError(ca[fa.code]);}},readlink:function(r){var v=Wc.realPath(r);try{return v=cd.readlinkSync(v),v=
Li.relative(Li.resolve(r.mount.opts.root),v)}catch(A){if(!A.code)throw A;throw new D.ErrnoError(ca[A.code]);}}},stream_ops:{open:function(r){var v=Wc.realPath(r.node);try{D.isFile(r.node.mode)&&(r.nfd=cd.openSync(v,Wc.flagsToPermissionString(r.flags)))}catch(A){if(!A.code)throw A;throw new D.ErrnoError(ca[A.code]);}},close:function(r){try{D.isFile(r.node.mode)&&r.nfd&&cd.closeSync(r.nfd)}catch(v){if(!v.code)throw v;throw new D.ErrnoError(ca[v.code]);}},read:function(r,v,A,fa,F){if(0===fa)return 0;
var aa=new Buffer(fa),ya;try{ya=cd.readSync(r.nfd,aa,0,fa,F)}catch(S){throw new D.ErrnoError(ca[S.code]);}if(0<ya)for(r=0;r<ya;r++)v[A+r]=aa[r];return ya},write:function(r,v,A,fa,F){v=new Buffer(v.subarray(A,A+fa));var aa;try{aa=cd.writeSync(r.nfd,v,0,fa,F)}catch(ya){throw new D.ErrnoError(ca[ya.code]);}return aa},llseek:function(r,v,A){if(1===A)v+=r.position;else if(2===A&&D.isFile(r.node.mode))try{var fa=cd.fstatSync(r.nfd);v+=fa.size}catch(F){throw new D.ErrnoError(ca[F.code]);}if(0>v)throw new D.ErrnoError(ca.EINVAL);
return v}}},sd={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:function(r){function v(r){r=r.split("/");for(var v=D,A=0;A<r.length-1;A++){var S=r.slice(0,A+1).join("/");F[S]||(F[S]=sd.createNode(v,S,sd.DIR_MODE,0));v=F[S]}return v}function A(r){r=r.split("/");return r[r.length-1]}fb(fg);sd.reader||(sd.reader=new FileReaderSync);var D=sd.createNode(null,"/",sd.DIR_MODE,0),F={};Array.prototype.forEach.call(r.opts.files||[],function(r){sd.createNode(v(r.name),A(r.name),sd.FILE_MODE,0,r,r.lastModifiedDate)});
(r.opts.blobs||[]).forEach(function(r){sd.createNode(v(r.name),A(r.name),sd.FILE_MODE,0,r.data)});(r.opts.packages||[]).forEach(function(r){r.metadata.files.forEach(function(D){var fa=D.filename.substr(1);sd.createNode(v(fa),A(fa),sd.FILE_MODE,0,r.blob.slice(D.start,D.end))})});return D},createNode:function(r,v,A,fa,F,aa){fa=D.createNode(r,v,A);fa.mode=A;fa.node_ops=sd.node_ops;fa.stream_ops=sd.stream_ops;fa.timestamp=(aa||new Date).getTime();fb(sd.FILE_MODE!==sd.DIR_MODE);A===sd.FILE_MODE?(fa.size=
F.size,fa.contents=F):(fa.size=4096,fa.contents={});r&&(r.contents[v]=fa);return fa},node_ops:{getattr:function(r){return{dev:1,ino:void 0,mode:r.mode,nlink:1,uid:0,gid:0,rdev:void 0,size:r.size,atime:new Date(r.timestamp),mtime:new Date(r.timestamp),ctime:new Date(r.timestamp),blksize:4096,blocks:Math.ceil(r.size/4096)}},setattr:function(r,v){void 0!==v.mode&&(r.mode=v.mode);void 0!==v.timestamp&&(r.timestamp=v.timestamp)},lookup:function(r,v){throw new D.ErrnoError(ca.ENOENT);},mknod:function(r,
v,A,fa){throw new D.ErrnoError(ca.EPERM);},rename:function(r,v,A){throw new D.ErrnoError(ca.EPERM);},unlink:function(r,v){throw new D.ErrnoError(ca.EPERM);},rmdir:function(r,v){throw new D.ErrnoError(ca.EPERM);},readdir:function(r){throw new D.ErrnoError(ca.EPERM);},symlink:function(r,v,A){throw new D.ErrnoError(ca.EPERM);},readlink:function(r){throw new D.ErrnoError(ca.EPERM);}},stream_ops:{read:function(r,v,A,D,F){if(F>=r.node.size)return 0;r=r.node.contents.slice(F,F+D);D=sd.reader.readAsArrayBuffer(r);
v.set(new Uint8Array(D),A);return r.size},write:function(r,v,A,fa,F){throw new D.ErrnoError(ca.EIO);},llseek:function(r,v,A){1===A?v+=r.position:2===A&&D.isFile(r.node.mode)&&(v+=r.node.size);if(0>v)throw new D.ErrnoError(ca.EINVAL);return v}}};vc(1,"i32*",2);vc(1,"i32*",2);vc(1,"i32*",2);var D={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:!1,ignorePermissions:!0,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},
filesystems:null,handleFSError:function(r){if(!(r instanceof D.ErrnoError))throw r+" : "+wf();return eg(r.errno)},lookupPath:function(r,v){r=jc.resolve(D.cwd(),r);v=v||{};if(!r)return{path:"",node:null};var A={follow_mount:!0,recurse_count:0},fa;for(fa in A)void 0===v[fa]&&(v[fa]=A[fa]);if(8<v.recurse_count)throw new D.ErrnoError(ca.ELOOP);var A=jc.normalizeArray(r.split("/").filter(function(r){return!!r}),!1),F=D.root;fa="/";for(var aa=0;aa<A.length;aa++){var ya=aa===A.length-1;if(ya&&v.parent)break;
F=D.lookupNode(F,A[aa]);fa=jc.join2(fa,A[aa]);D.isMountpoint(F)&&(!ya||ya&&v.follow_mount)&&(F=F.mounted.root);if(!ya||v.follow)for(ya=0;D.isLink(F.mode);)if(F=D.readlink(fa),fa=jc.resolve(jc.dirname(fa),F),F=D.lookupPath(fa,{recurse_count:v.recurse_count}).node,40<ya++)throw new D.ErrnoError(ca.ELOOP);}return{path:fa,node:F}},getPath:function(r){for(var v;;){if(D.isRoot(r))return r=r.mount.mountpoint,v?"/"!==r[r.length-1]?r+"/"+v:r+v:r;v=v?r.name+"/"+v:r.name;r=r.parent}},hashName:function(r,v){for(var A=
0,fa=0;fa<v.length;fa++)A=(A<<5)-A+v.charCodeAt(fa)|0;return(r+A>>>0)%D.nameTable.length},hashAddNode:function(r){var v=D.hashName(r.parent.id,r.name);r.name_next=D.nameTable[v];D.nameTable[v]=r},hashRemoveNode:function(r){var v=D.hashName(r.parent.id,r.name);if(D.nameTable[v]===r)D.nameTable[v]=r.name_next;else for(v=D.nameTable[v];v;){if(v.name_next===r){v.name_next=r.name_next;break}v=v.name_next}},lookupNode:function(r,v){var A=D.mayLookup(r);if(A)throw new D.ErrnoError(A,r);A=D.hashName(r.id,
v);for(A=D.nameTable[A];A;A=A.name_next){var fa=A.name;if(A.parent.id===r.id&&fa===v)return A}return D.lookup(r,v)},createNode:function(r,v,A,fa){D.FSNode||(D.FSNode=function(r,v,A,fa){r||(r=this);this.parent=r;this.mount=r.mount;this.mounted=null;this.id=D.nextInode++;this.name=v;this.mode=A;this.node_ops={};this.stream_ops={};this.rdev=fa},D.FSNode.prototype={},Object.defineProperties(D.FSNode.prototype,{read:{get:function(){return 365===(this.mode&365)},set:function(r){r?this.mode|=365:this.mode&=
-366}},write:{get:function(){return 146===(this.mode&146)},set:function(r){r?this.mode|=146:this.mode&=-147}},isFolder:{get:function(){return D.isDir(this.mode)}},isDevice:{get:function(){return D.isChrdev(this.mode)}}}));r=new D.FSNode(r,v,A,fa);D.hashAddNode(r);return r},destroyNode:function(r){D.hashRemoveNode(r)},isRoot:function(r){return r===r.parent},isMountpoint:function(r){return!!r.mounted},isFile:function(r){return 32768===(r&61440)},isDir:function(r){return 16384===(r&61440)},isLink:function(r){return 40960===
(r&61440)},isChrdev:function(r){return 8192===(r&61440)},isBlkdev:function(r){return 24576===(r&61440)},isFIFO:function(r){return 4096===(r&61440)},isSocket:function(r){return 49152===(r&49152)},flagModes:{r:0,rs:1052672,"r+":2,w:577,wx:705,xw:705,"w+":578,"wx+":706,"xw+":706,a:1089,ax:1217,xa:1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function(r){var v=D.flagModes[r];if("undefined"===typeof v)throw Error("Unknown file open mode: "+r);return v},flagsToPermissionString:function(r){var v=
["r","w","rw"][r&3];r&512&&(v+="w");return v},nodePermissions:function(r,v){if(D.ignorePermissions)return 0;if(-1===v.indexOf("r")||r.mode&292){if(-1!==v.indexOf("w")&&!(r.mode&146)||-1!==v.indexOf("x")&&!(r.mode&73))return ca.EACCES}else return ca.EACCES;return 0},mayLookup:function(r){var v=D.nodePermissions(r,"x");return v?v:r.node_ops.lookup?0:ca.EACCES},mayCreate:function(r,v){try{return D.lookupNode(r,v),ca.EEXIST}catch(A){}return D.nodePermissions(r,"wx")},mayDelete:function(r,v,A){var fa;
try{fa=D.lookupNode(r,v)}catch(F){return F.errno}if(r=D.nodePermissions(r,"wx"))return r;if(A){if(!D.isDir(fa.mode))return ca.ENOTDIR;if(D.isRoot(fa)||D.getPath(fa)===D.cwd())return ca.EBUSY}else if(D.isDir(fa.mode))return ca.EISDIR;return 0},mayOpen:function(r,v){return r?D.isLink(r.mode)?ca.ELOOP:D.isDir(r.mode)&&(0!==(v&2097155)||v&512)?ca.EISDIR:D.nodePermissions(r,D.flagsToPermissionString(v)):ca.ENOENT},MAX_OPEN_FDS:4096,nextfd:function(r,v){v=v||D.MAX_OPEN_FDS;for(var A=r||0;A<=v;A++)if(!D.streams[A])return A;
throw new D.ErrnoError(ca.EMFILE);},getStream:function(r){return D.streams[r]},createStream:function(r,v,A){D.FSStream||(D.FSStream=function(){},D.FSStream.prototype={},Object.defineProperties(D.FSStream.prototype,{object:{get:function(){return this.node},set:function(r){this.node=r}},isRead:{get:function(){return 1!==(this.flags&2097155)}},isWrite:{get:function(){return 0!==(this.flags&2097155)}},isAppend:{get:function(){return this.flags&1024}}}));var fa=new D.FSStream,F;for(F in r)fa[F]=r[F];r=
fa;v=D.nextfd(v,A);r.fd=v;return D.streams[v]=r},closeStream:function(r){D.streams[r]=null},chrdev_stream_ops:{open:function(r){var v=D.getDevice(r.node.rdev);r.stream_ops=v.stream_ops;r.stream_ops.open&&r.stream_ops.open(r)},llseek:function(){throw new D.ErrnoError(ca.ESPIPE);}},major:function(r){return r>>8},minor:function(r){return r&255},makedev:function(r,v){return r<<8|v},registerDevice:function(r,v){D.devices[r]={stream_ops:v}},getDevice:function(r){return D.devices[r]},getMounts:function(r){var v=
[];for(r=[r];r.length;){var A=r.pop();v.push(A);r.push.apply(r,A.mounts)}return v},syncfs:function(r,v){function A(r){if(r){if(!A.errored)return A.errored=!0,v(r)}else++F>=fa.length&&v(null)}"function"===typeof r&&(v=r,r=!1);var fa=D.getMounts(D.root.mount),F=0;fa.forEach(function(v){if(!v.type.syncfs)return A(null);v.type.syncfs(v,r,A)})},mount:function(r,v,A){var fa="/"===A,F=!A,aa;if(fa&&D.root)throw new D.ErrnoError(ca.EBUSY);if(!fa&&!F){aa=D.lookupPath(A,{follow_mount:!1});A=aa.path;aa=aa.node;
if(D.isMountpoint(aa))throw new D.ErrnoError(ca.EBUSY);if(!D.isDir(aa.mode))throw new D.ErrnoError(ca.ENOTDIR);}v={type:r,opts:v,mountpoint:A,mounts:[]};r=r.mount(v);r.mount=v;v.root=r;fa?D.root=r:aa&&(aa.mounted=v,aa.mount&&aa.mount.mounts.push(v));return r},unmount:function(r){r=D.lookupPath(r,{follow_mount:!1});if(!D.isMountpoint(r.node))throw new D.ErrnoError(ca.EINVAL);r=r.node;var v=r.mounted,A=D.getMounts(v);Object.keys(D.nameTable).forEach(function(r){for(r=D.nameTable[r];r;){var v=r.name_next;
-1!==A.indexOf(r.mount)&&D.destroyNode(r);r=v}});r.mounted=null;v=r.mount.mounts.indexOf(v);fb(-1!==v);r.mount.mounts.splice(v,1)},lookup:function(r,v){return r.node_ops.lookup(r,v)},mknod:function(r,v,A){var fa=D.lookupPath(r,{parent:!0}).node;r=jc.basename(r);if(!r||"."===r||".."===r)throw new D.ErrnoError(ca.EINVAL);var F=D.mayCreate(fa,r);if(F)throw new D.ErrnoError(F);if(!fa.node_ops.mknod)throw new D.ErrnoError(ca.EPERM);return fa.node_ops.mknod(fa,r,v,A)},create:function(r,v){return D.mknod(r,
(void 0!==v?v:438)&4095|32768,0)},mkdir:function(r,v){return D.mknod(r,(void 0!==v?v:511)&1023|16384,0)},mkdev:function(r,v,A){"undefined"===typeof A&&(A=v,v=438);return D.mknod(r,v|8192,A)},symlink:function(r,v){if(!jc.resolve(r))throw new D.ErrnoError(ca.ENOENT);var A=D.lookupPath(v,{parent:!0}).node;if(!A)throw new D.ErrnoError(ca.ENOENT);var fa=jc.basename(v),F=D.mayCreate(A,fa);if(F)throw new D.ErrnoError(F);if(!A.node_ops.symlink)throw new D.ErrnoError(ca.EPERM);return A.node_ops.symlink(A,
fa,r)},rename:function(r,v){var A=jc.dirname(r),fa=jc.dirname(v),F=jc.basename(r),aa=jc.basename(v),ya,S,ra;try{ya=D.lookupPath(r,{parent:!0}),S=ya.node,ya=D.lookupPath(v,{parent:!0}),ra=ya.node}catch(Ka){throw new D.ErrnoError(ca.EBUSY);}if(!S||!ra)throw new D.ErrnoError(ca.ENOENT);if(S.mount!==ra.mount)throw new D.ErrnoError(ca.EXDEV);ya=D.lookupNode(S,F);fa=jc.relative(r,fa);if("."!==fa.charAt(0))throw new D.ErrnoError(ca.EINVAL);fa=jc.relative(v,A);if("."!==fa.charAt(0))throw new D.ErrnoError(ca.ENOTEMPTY);
var Xd;try{Xd=D.lookupNode(ra,aa)}catch(Ka){}if(ya!==Xd){A=D.isDir(ya.mode);if(F=D.mayDelete(S,F,A))throw new D.ErrnoError(F);if(F=Xd?D.mayDelete(ra,aa,A):D.mayCreate(ra,aa))throw new D.ErrnoError(F);if(!S.node_ops.rename)throw new D.ErrnoError(ca.EPERM);if(D.isMountpoint(ya)||Xd&&D.isMountpoint(Xd))throw new D.ErrnoError(ca.EBUSY);if(ra!==S&&(F=D.nodePermissions(S,"w")))throw new D.ErrnoError(F);try{D.trackingDelegate.willMovePath&&D.trackingDelegate.willMovePath(r,v)}catch(Ka){console.log("FS.trackingDelegate['willMovePath']('"+
r+"', '"+v+"') threw an exception: "+Ka.message)}D.hashRemoveNode(ya);try{S.node_ops.rename(ya,ra,aa)}catch(Ka){throw Ka;}finally{D.hashAddNode(ya)}try{if(D.trackingDelegate.onMovePath)D.trackingDelegate.onMovePath(r,v)}catch(Ka){console.log("FS.trackingDelegate['onMovePath']('"+r+"', '"+v+"') threw an exception: "+Ka.message)}}},rmdir:function(r){var v=D.lookupPath(r,{parent:!0}).node,A=jc.basename(r),fa=D.lookupNode(v,A),F=D.mayDelete(v,A,!0);if(F)throw new D.ErrnoError(F);if(!v.node_ops.rmdir)throw new D.ErrnoError(ca.EPERM);
if(D.isMountpoint(fa))throw new D.ErrnoError(ca.EBUSY);try{D.trackingDelegate.willDeletePath&&D.trackingDelegate.willDeletePath(r)}catch(aa){console.log("FS.trackingDelegate['willDeletePath']('"+r+"') threw an exception: "+aa.message)}v.node_ops.rmdir(v,A);D.destroyNode(fa);try{if(D.trackingDelegate.onDeletePath)D.trackingDelegate.onDeletePath(r)}catch(aa){console.log("FS.trackingDelegate['onDeletePath']('"+r+"') threw an exception: "+aa.message)}},readdir:function(r){r=D.lookupPath(r,{follow:!0}).node;
if(!r.node_ops.readdir)throw new D.ErrnoError(ca.ENOTDIR);return r.node_ops.readdir(r)},unlink:function(r){var v=D.lookupPath(r,{parent:!0}).node,A=jc.basename(r),F=D.lookupNode(v,A),yc=D.mayDelete(v,A,!1);if(yc)throw yc===ca.EISDIR&&(yc=ca.EPERM),new D.ErrnoError(yc);if(!v.node_ops.unlink)throw new D.ErrnoError(ca.EPERM);if(D.isMountpoint(F))throw new D.ErrnoError(ca.EBUSY);try{D.trackingDelegate.willDeletePath&&D.trackingDelegate.willDeletePath(r)}catch(aa){console.log("FS.trackingDelegate['willDeletePath']('"+
r+"') threw an exception: "+aa.message)}v.node_ops.unlink(v,A);D.destroyNode(F);try{if(D.trackingDelegate.onDeletePath)D.trackingDelegate.onDeletePath(r)}catch(aa){console.log("FS.trackingDelegate['onDeletePath']('"+r+"') threw an exception: "+aa.message)}},readlink:function(r){r=D.lookupPath(r).node;if(!r)throw new D.ErrnoError(ca.ENOENT);if(!r.node_ops.readlink)throw new D.ErrnoError(ca.EINVAL);return jc.resolve(D.getPath(r.parent),r.node_ops.readlink(r))},stat:function(r,v){var A=D.lookupPath(r,
{follow:!v}).node;if(!A)throw new D.ErrnoError(ca.ENOENT);if(!A.node_ops.getattr)throw new D.ErrnoError(ca.EPERM);return A.node_ops.getattr(A)},lstat:function(r){return D.stat(r,!0)},chmod:function(r,v,A){r="string"===typeof r?D.lookupPath(r,{follow:!A}).node:r;if(!r.node_ops.setattr)throw new D.ErrnoError(ca.EPERM);r.node_ops.setattr(r,{mode:v&4095|r.mode&-4096,timestamp:Date.now()})},lchmod:function(r,v){D.chmod(r,v,!0)},fchmod:function(r,v){var A=D.getStream(r);if(!A)throw new D.ErrnoError(ca.EBADF);
D.chmod(A.node,v)},chown:function(r,v,A,F){r="string"===typeof r?D.lookupPath(r,{follow:!F}).node:r;if(!r.node_ops.setattr)throw new D.ErrnoError(ca.EPERM);r.node_ops.setattr(r,{timestamp:Date.now()})},lchown:function(r,v,A){D.chown(r,v,A,!0)},fchown:function(r,v,A){r=D.getStream(r);if(!r)throw new D.ErrnoError(ca.EBADF);D.chown(r.node,v,A)},truncate:function(r,v){if(0>v)throw new D.ErrnoError(ca.EINVAL);var A;A="string"===typeof r?D.lookupPath(r,{follow:!0}).node:r;if(!A.node_ops.setattr)throw new D.ErrnoError(ca.EPERM);
if(D.isDir(A.mode))throw new D.ErrnoError(ca.EISDIR);if(!D.isFile(A.mode))throw new D.ErrnoError(ca.EINVAL);var F=D.nodePermissions(A,"w");if(F)throw new D.ErrnoError(F);A.node_ops.setattr(A,{size:v,timestamp:Date.now()})},ftruncate:function(r,v){var A=D.getStream(r);if(!A)throw new D.ErrnoError(ca.EBADF);if(0===(A.flags&2097155))throw new D.ErrnoError(ca.EINVAL);D.truncate(A.node,v)},utime:function(r,v,A){r=D.lookupPath(r,{follow:!0}).node;r.node_ops.setattr(r,{timestamp:Math.max(v,A)})},open:function(r,
v,A,fa,yc){if(""===r)throw new D.ErrnoError(ca.ENOENT);v="string"===typeof v?D.modeStringToFlags(v):v;A=v&64?("undefined"===typeof A?438:A)&4095|32768:0;var aa;if("object"===typeof r)aa=r;else{r=jc.normalize(r);try{aa=D.lookupPath(r,{follow:!(v&131072)}).node}catch(S){}}var ya=!1;if(v&64)if(aa){if(v&128)throw new D.ErrnoError(ca.EEXIST);}else aa=D.mknod(r,A,0),ya=!0;if(!aa)throw new D.ErrnoError(ca.ENOENT);D.isChrdev(aa.mode)&&(v&=-513);if(v&65536&&!D.isDir(aa.mode))throw new D.ErrnoError(ca.ENOTDIR);
if(!ya&&(A=D.mayOpen(aa,v)))throw new D.ErrnoError(A);v&512&&D.truncate(aa,0);v&=-641;fa=D.createStream({node:aa,path:D.getPath(aa),flags:v,seekable:!0,position:0,stream_ops:aa.stream_ops,ungotten:[],error:!1},fa,yc);fa.stream_ops.open&&fa.stream_ops.open(fa);!F.logReadFiles||v&1||(D.readFiles||(D.readFiles={}),r in D.readFiles||(D.readFiles[r]=1,F.printErr("read file: "+r)));try{D.trackingDelegate.onOpenFile&&(yc=0,1!==(v&2097155)&&(yc|=D.tracking.openFlags.READ),0!==(v&2097155)&&(yc|=D.tracking.openFlags.WRITE),
D.trackingDelegate.onOpenFile(r,yc))}catch(S){console.log("FS.trackingDelegate['onOpenFile']('"+r+"', flags) threw an exception: "+S.message)}return fa},close:function(r){r.getdents&&(r.getdents=null);try{r.stream_ops.close&&r.stream_ops.close(r)}catch(v){throw v;}finally{D.closeStream(r.fd)}},llseek:function(r,v,A){if(!r.seekable||!r.stream_ops.llseek)throw new D.ErrnoError(ca.ESPIPE);r.position=r.stream_ops.llseek(r,v,A);r.ungotten=[];return r.position},read:function(r,v,A,F,S){if(0>F||0>S)throw new D.ErrnoError(ca.EINVAL);
if(1===(r.flags&2097155))throw new D.ErrnoError(ca.EBADF);if(D.isDir(r.node.mode))throw new D.ErrnoError(ca.EISDIR);if(!r.stream_ops.read)throw new D.ErrnoError(ca.EINVAL);var aa=!0;if("undefined"===typeof S)S=r.position,aa=!1;else if(!r.seekable)throw new D.ErrnoError(ca.ESPIPE);v=r.stream_ops.read(r,v,A,F,S);aa||(r.position+=v);return v},write:function(r,v,A,F,S,aa){if(0>F||0>S)throw new D.ErrnoError(ca.EINVAL);if(0===(r.flags&2097155))throw new D.ErrnoError(ca.EBADF);if(D.isDir(r.node.mode))throw new D.ErrnoError(ca.EISDIR);
if(!r.stream_ops.write)throw new D.ErrnoError(ca.EINVAL);r.flags&1024&&D.llseek(r,0,2);var ya=!0;if("undefined"===typeof S)S=r.position,ya=!1;else if(!r.seekable)throw new D.ErrnoError(ca.ESPIPE);v=r.stream_ops.write(r,v,A,F,S,aa);ya||(r.position+=v);try{if(r.path&&D.trackingDelegate.onWriteToFile)D.trackingDelegate.onWriteToFile(r.path)}catch(ra){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+ra.message)}return v},allocate:function(r,v,A){if(0>v||0>=A)throw new D.ErrnoError(ca.EINVAL);
if(0===(r.flags&2097155))throw new D.ErrnoError(ca.EBADF);if(!D.isFile(r.node.mode)&&!D.isDir(node.mode))throw new D.ErrnoError(ca.ENODEV);if(!r.stream_ops.allocate)throw new D.ErrnoError(ca.EOPNOTSUPP);r.stream_ops.allocate(r,v,A)},mmap:function(r,v,A,F,S,aa,ya){if(1===(r.flags&2097155))throw new D.ErrnoError(ca.EACCES);if(!r.stream_ops.mmap)throw new D.ErrnoError(ca.ENODEV);return r.stream_ops.mmap(r,v,A,F,S,aa,ya)},msync:function(r,v,A,D,F){return r&&r.stream_ops.msync?r.stream_ops.msync(r,v,A,
D,F):0},munmap:function(r){return 0},ioctl:function(r,v,A){if(!r.stream_ops.ioctl)throw new D.ErrnoError(ca.ENOTTY);return r.stream_ops.ioctl(r,v,A)},readFile:function(r,v){v=v||{};v.flags=v.flags||"r";v.encoding=v.encoding||"binary";if("utf8"!==v.encoding&&"binary"!==v.encoding)throw Error('Invalid encoding type "'+v.encoding+'"');var A,F=D.open(r,v.flags),S=D.stat(r).size,aa=new Uint8Array(S);D.read(F,aa,0,S,0);"utf8"===v.encoding?A=nf(aa,0):"binary"===v.encoding&&(A=aa);D.close(F);return A},writeFile:function(r,
v,A){A=A||{};A.flags=A.flags||"w";A.encoding=A.encoding||"utf8";if("utf8"!==A.encoding&&"binary"!==A.encoding)throw Error('Invalid encoding type "'+A.encoding+'"');r=D.open(r,A.flags,A.mode);if("utf8"===A.encoding){var F=new Uint8Array(lg(v)+1);v=Ug(v,F,0,F.length);D.write(r,F,0,v,0,A.canOwn)}else"binary"===A.encoding&&D.write(r,v,0,v.length,0,A.canOwn);D.close(r)},cwd:function(){return D.currentPath},chdir:function(r){r=D.lookupPath(r,{follow:!0});if(!D.isDir(r.node.mode))throw new D.ErrnoError(ca.ENOTDIR);
var v=D.nodePermissions(r.node,"x");if(v)throw new D.ErrnoError(v);D.currentPath=r.path},createDefaultDirectories:function(){D.mkdir("/tmp");D.mkdir("/home");D.mkdir("/home/web_user")},createDefaultDevices:function(){D.mkdir("/dev");D.registerDevice(D.makedev(1,3),{read:function(){return 0},write:function(r,v,D,F,S){return F}});D.mkdev("/dev/null",D.makedev(1,3));ye.register(D.makedev(5,0),ye.default_tty_ops);ye.register(D.makedev(6,0),ye.default_tty1_ops);D.mkdev("/dev/tty",D.makedev(5,0));D.mkdev("/dev/tty1",
D.makedev(6,0));var r;if("undefined"!==typeof crypto){var v=new Uint8Array(1);r=function(){crypto.getRandomValues(v);return v[0]}}else r=Bf?function(){return require("crypto").randomBytes(1)[0]}:function(){return 256*Math.random()|0};D.createDevice("/dev","random",r);D.createDevice("/dev","urandom",r);D.mkdir("/dev/shm");D.mkdir("/dev/shm/tmp")},createSpecialDirectories:function(){D.mkdir("/proc");D.mkdir("/proc/self");D.mkdir("/proc/self/fd");D.mount({mount:function(){var r=D.createNode("/proc/self",
"fd",16895,73);r.node_ops={lookup:function(r,A){var F=D.getStream(+A);if(!F)throw new D.ErrnoError(ca.EBADF);var S={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:function(){return F.path}}};return S.parent=S}};return r}},{},"/proc/self/fd")},createStandardStreams:function(){F.stdin?D.createDevice("/dev","stdin",F.stdin):D.symlink("/dev/tty","/dev/stdin");F.stdout?D.createDevice("/dev","stdout",null,F.stdout):D.symlink("/dev/tty","/dev/stdout");F.stderr?D.createDevice("/dev","stderr",null,
F.stderr):D.symlink("/dev/tty1","/dev/stderr");var r=D.open("/dev/stdin","r");fb(0===r.fd,"invalid handle for stdin ("+r.fd+")");r=D.open("/dev/stdout","w");fb(1===r.fd,"invalid handle for stdout ("+r.fd+")");r=D.open("/dev/stderr","w");fb(2===r.fd,"invalid handle for stderr ("+r.fd+")")},ensureErrnoError:function(){D.ErrnoError||(D.ErrnoError=function(r,v){this.node=v;this.setErrno=function(r){this.errno=r;for(var v in ca)if(ca[v]===r){this.code=v;break}};this.setErrno(r);this.message=Kj[r]},D.ErrnoError.prototype=
Error(),D.ErrnoError.prototype.constructor=D.ErrnoError,[ca.ENOENT].forEach(function(r){D.genericErrors[r]=new D.ErrnoError(r);D.genericErrors[r].stack="<generic error, no stack>"}))},staticInit:function(){D.ensureErrnoError();D.nameTable=Array(4096);D.mount(lc,{},"/");D.createDefaultDirectories();D.createDefaultDevices();D.createSpecialDirectories();D.filesystems={MEMFS:lc,IDBFS:Bc,NODEFS:Wc,WORKERFS:sd}},init:function(r,v,A){fb(!D.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");
D.init.initialized=!0;D.ensureErrnoError();F.stdin=r||F.stdin;F.stdout=v||F.stdout;F.stderr=A||F.stderr;D.createStandardStreams()},quit:function(){D.init.initialized=!1;var r=F._fflush;r&&r(0);for(r=0;r<D.streams.length;r++){var v=D.streams[r];v&&D.close(v)}},getMode:function(r,v){var A=0;r&&(A|=365);v&&(A|=146);return A},joinPath:function(r,v){var A=jc.join.apply(null,r);v&&"/"==A[0]&&(A=A.substr(1));return A},absolutePath:function(r,v){return jc.resolve(v,r)},standardizePath:function(r){return jc.normalize(r)},
findObject:function(r,v){var A=D.analyzePath(r,v);if(A.exists)return A.object;eg(A.error);return null},analyzePath:function(r,v){try{var A=D.lookupPath(r,{follow:!v});r=A.path}catch(F){}var fa={isRoot:!1,exists:!1,error:0,name:null,path:null,object:null,parentExists:!1,parentPath:null,parentObject:null};try{A=D.lookupPath(r,{parent:!0}),fa.parentExists=!0,fa.parentPath=A.path,fa.parentObject=A.node,fa.name=jc.basename(r),A=D.lookupPath(r,{follow:!v}),fa.exists=!0,fa.path=A.path,fa.object=A.node,fa.name=
A.node.name,fa.isRoot="/"===A.path}catch(F){fa.error=F.errno}return fa},createFolder:function(r,v,A,F){r=jc.join2("string"===typeof r?r:D.getPath(r),v);A=D.getMode(A,F);return D.mkdir(r,A)},createPath:function(r,v,A,F){r="string"===typeof r?r:D.getPath(r);for(v=v.split("/").reverse();v.length;)if(A=v.pop()){var S=jc.join2(r,A);try{D.mkdir(S)}catch(aa){}r=S}return S},createFile:function(r,v,A,F,S){r=jc.join2("string"===typeof r?r:D.getPath(r),v);F=D.getMode(F,S);return D.create(r,F)},createDataFile:function(r,
v,A,F,S,aa){r=v?jc.join2("string"===typeof r?r:D.getPath(r),v):r;F=D.getMode(F,S);S=D.create(r,F);if(A){if("string"===typeof A){r=Array(A.length);v=0;for(var ya=A.length;v<ya;++v)r[v]=A.charCodeAt(v);A=r}D.chmod(S,F|146);r=D.open(S,"w");D.write(r,A,0,A.length,0,aa);D.close(r);D.chmod(S,F)}return S},createDevice:function(r,v,A,F){r=jc.join2("string"===typeof r?r:D.getPath(r),v);v=D.getMode(!!A,!!F);D.createDevice.major||(D.createDevice.major=64);var S=D.makedev(D.createDevice.major++,0);D.registerDevice(S,
{open:function(r){r.seekable=!1},close:function(r){F&&F.buffer&&F.buffer.length&&F(10)},read:function(r,v,F,fa,S){for(var yc=S=0;yc<fa;yc++){var ra;try{ra=A()}catch(Y){throw new D.ErrnoError(ca.EIO);}if(void 0===ra&&0===S)throw new D.ErrnoError(ca.EAGAIN);if(null===ra||void 0===ra)break;S++;v[F+yc]=ra}S&&(r.node.timestamp=Date.now());return S},write:function(r,v,A,S,yc){for(yc=0;yc<S;yc++)try{F(v[A+yc])}catch(ra){throw new D.ErrnoError(ca.EIO);}S&&(r.node.timestamp=Date.now());return yc}});return D.mkdev(r,
v,S)},createLink:function(r,v,A,F,S){r=jc.join2("string"===typeof r?r:D.getPath(r),v);return D.symlink(A,r)},forceLoadFile:function(r){if(r.isDevice||r.isFolder||r.link||r.contents)return!0;var v=!0;if("undefined"!==typeof XMLHttpRequest)throw Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");if(F.read)try{r.contents=yf(F.read(r.url),!0),r.usedBytes=
r.contents.length}catch(A){v=!1}else throw Error("Cannot load without read() or XMLHttpRequest.");v||eg(ca.EIO);return v},createLazyFile:function(r,v,A,F,S){function aa(){this.lengthKnown=!1;this.chunks=[]}aa.prototype.get=function(r){if(!(r>this.length-1||0>r)){var v=r%this.chunkSize;return this.getter(r/this.chunkSize|0)[v]}};aa.prototype.setDataGetter=function(r){this.getter=r};aa.prototype.cacheLength=function(){var r=new XMLHttpRequest;r.open("HEAD",A,!1);r.send(null);if(!(200<=r.status&&300>
r.status||304===r.status))throw Error("Couldn't load "+A+". Status: "+r.status);var v=Number(r.getResponseHeader("Content-length")),D,F=1048576;(D=r.getResponseHeader("Accept-Ranges"))&&"bytes"===D||(F=v);var fa=this;fa.setDataGetter(function(r){var D=r*F,S=(r+1)*F-1,S=Math.min(S,v-1);if("undefined"===typeof fa.chunks[r]){var aa=fa.chunks;if(D>S)throw Error("invalid range ("+D+", "+S+") or no bytes requested!");if(S>v-1)throw Error("only "+v+" bytes available! programmer error!");var ya=new XMLHttpRequest;
ya.open("GET",A,!1);v!==F&&ya.setRequestHeader("Range","bytes="+D+"-"+S);"undefined"!=typeof Uint8Array&&(ya.responseType="arraybuffer");ya.overrideMimeType&&ya.overrideMimeType("text/plain; charset=x-user-defined");ya.send(null);if(!(200<=ya.status&&300>ya.status||304===ya.status))throw Error("Couldn't load "+A+". Status: "+ya.status);D=void 0!==ya.response?new Uint8Array(ya.response||[]):yf(ya.responseText||"",!0);aa[r]=D}if("undefined"===typeof fa.chunks[r])throw Error("doXHR failed!");return fa.chunks[r]});
this._length=v;this._chunkSize=F;this.lengthKnown=!0};if("undefined"!==typeof XMLHttpRequest){if(!fg)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var ya=new aa;Object.defineProperty(ya,"length",{get:function(){this.lengthKnown||this.cacheLength();return this._length}});Object.defineProperty(ya,"chunkSize",{get:function(){this.lengthKnown||this.cacheLength();return this._chunkSize}});ya={isDevice:!1,contents:ya}}else ya=
{isDevice:!1,url:A};var ra=D.createFile(r,v,ya,F,S);ya.contents?ra.contents=ya.contents:ya.url&&(ra.contents=null,ra.url=ya.url);Object.defineProperty(ra,"usedBytes",{get:function(){return this.contents.length}});var Ka={};Object.keys(ra.stream_ops).forEach(function(r){var v=ra.stream_ops[r];Ka[r]=function(){if(!D.forceLoadFile(ra))throw new D.ErrnoError(ca.EIO);return v.apply(null,arguments)}});Ka.read=function(r,v,A,F,fa){if(!D.forceLoadFile(ra))throw new D.ErrnoError(ca.EIO);r=r.node.contents;
if(fa>=r.length)return 0;F=Math.min(r.length-fa,F);fb(0<=F);if(r.slice)for(var S=0;S<F;S++)v[A+S]=r[fa+S];else for(S=0;S<F;S++)v[A+S]=r.get(fa+S);return F};ra.stream_ops=Ka;return ra},createPreloadedFile:function(r,v,A,fa,yc,aa,ya,ca,ra,Ka){function ab(A){function S(A){Ka&&Ka();ca||D.createDataFile(r,v,A,fa,yc,ra);aa&&aa();ng(Y)}var Lb=!1;F.preloadPlugins.forEach(function(r){!Lb&&r.canHandle(fb)&&(r.handle(A,fb,S,function(){ya&&ya();ng(Y)}),Lb=!0)});Lb||S(A)}S.init();var fb=v?jc.resolve(jc.join2(r,
v)):r,Y="cp "+fb;Yg(Y);"string"==typeof A?S.asyncLoad(A,function(r){ab(r)},ya):ab(A)},indexedDB:function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB},DB_NAME:function(){return"EM_FS_"+window.location.pathname},DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function(r,v,A){v=v||function(){};A=A||function(){};var F=D.indexedDB();try{var S=F.open(D.DB_NAME(),D.DB_VERSION)}catch(aa){return A(aa)}S.onupgradeneeded=function(){console.log("creating db");
S.result.createObjectStore(D.DB_STORE_NAME)};S.onsuccess=function(){var F=S.result.transaction([D.DB_STORE_NAME],"readwrite"),fa=F.objectStore(D.DB_STORE_NAME),ca=0,ra=0,Ka=r.length;r.forEach(function(r){r=fa.put(D.analyzePath(r).object.contents,r);r.onsuccess=function(){ca++;ca+ra==Ka&&(0==ra?v():A())};r.onerror=function(){ra++;ca+ra==Ka&&(0==ra?v():A())}});F.onerror=A};S.onerror=A},loadFilesFromDB:function(r,v,A){v=v||function(){};A=A||function(){};var F=D.indexedDB();try{var S=F.open(D.DB_NAME(),
D.DB_VERSION)}catch(aa){return A(aa)}S.onupgradeneeded=A;S.onsuccess=function(){var F=S.result;try{var fa=F.transaction([D.DB_STORE_NAME],"readonly")}catch(ca){A(ca);return}var ra=fa.objectStore(D.DB_STORE_NAME),Ka=0,ab=0,fb=r.length;r.forEach(function(r){var F=ra.get(r);F.onsuccess=function(){D.analyzePath(r).exists&&D.unlink(r);D.createDataFile(jc.dirname(r),jc.basename(r),F.result,!0,!0,!0);Ka++;Ka+ab==fb&&(0==ab?v():A())};F.onerror=function(){ab++;Ka+ab==fb&&(0==ab?v():A())}});fa.onerror=A};S.onerror=
A}};F.FS=D;var jc={splitPath:function(r){return/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/.exec(r).slice(1)},normalizeArray:function(r,v){for(var A=0,D=r.length-1;0<=D;D--){var F=r[D];"."===F?r.splice(D,1):".."===F?(r.splice(D,1),A++):A&&(r.splice(D,1),A--)}if(v)for(;A--;A)r.unshift("..");return r},normalize:function(r){var v="/"===r.charAt(0),A="/"===r.substr(-1);(r=jc.normalizeArray(r.split("/").filter(function(r){return!!r}),!v).join("/"))||v||(r=".");r&&A&&(r+="/");return(v?
"/":"")+r},dirname:function(r){var v=jc.splitPath(r);r=v[0];v=v[1];if(!r&&!v)return".";v&&(v=v.substr(0,v.length-1));return r+v},basename:function(r){if("/"===r)return"/";var v=r.lastIndexOf("/");return-1===v?r:r.substr(v+1)},extname:function(r){return jc.splitPath(r)[3]},join:function(){var r=Array.prototype.slice.call(arguments,0);return jc.normalize(r.join("/"))},join2:function(r,v){return jc.normalize(r+"/"+v)},resolve:function(){for(var r="",v=!1,A=arguments.length-1;-1<=A&&!v;A--){v=0<=A?arguments[A]:
D.cwd();if("string"!==typeof v)throw new TypeError("Arguments to path.resolve must be strings");if(!v)return"";r=v+"/"+r;v="/"===v.charAt(0)}r=jc.normalizeArray(r.split("/").filter(function(r){return!!r}),!v).join("/");return(v?"/":"")+r||"."},relative:function(r,v){function A(r){for(var v=0;v<r.length&&""===r[v];v++);for(var A=r.length-1;0<=A&&""===r[A];A--);return v>A?[]:r.slice(v,A-v+1)}r=jc.resolve(r).substr(1);v=jc.resolve(v).substr(1);for(var D=A(r.split("/")),F=A(v.split("/")),S=Math.min(D.length,
F.length),ya=S,ca=0;ca<S;ca++)if(D[ca]!==F[ca]){ya=ca;break}S=[];for(ca=ya;ca<D.length;ca++)S.push("..");S=S.concat(F.slice(ya));return S.join("/")}},S={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:function(){S.mainLoop.scheduler=null;S.mainLoop.currentlyRunningMainloop++},resume:function(){S.mainLoop.currentlyRunningMainloop++;var r=S.mainLoop.timingMode,v=S.mainLoop.timingValue,A=S.mainLoop.func;S.mainLoop.func=
null;Oh(A,0,!1,S.mainLoop.arg,!0);hj(r,v);S.mainLoop.scheduler()},updateStatus:function(){if(F.setStatus){var r=F.statusMessage||"Please wait...",v=S.mainLoop.remainingBlockers,A=S.mainLoop.expectedBlockers;v?v<A?F.setStatus(r+" ("+(A-v)+"/"+A+")"):F.setStatus(r):F.setStatus("")}},runIter:function(r){if(!(xe||F.preMainLoop&&!1===F.preMainLoop())){try{r()}catch(v){if(v instanceof of)return;v&&"object"===typeof v&&v.stack&&F.printErr("exception thrown: "+[v,v.stack]);throw v;}F.postMainLoop&&F.postMainLoop()}}},
isFullScreen:!1,pointerLock:!1,moduleContextCreatedCallbacks:[],workers:[],init:function(){function r(){S.pointerLock=document.pointerLockElement===v||document.mozPointerLockElement===v||document.webkitPointerLockElement===v||document.msPointerLockElement===v}F.preloadPlugins||(F.preloadPlugins=[]);if(!S.initted){S.initted=!0;try{new Blob,S.hasBlobConstructor=!0}catch(A){S.hasBlobConstructor=!1,console.log("warning: no blob constructor, cannot create blobs with mimetypes")}S.BlobBuilder="undefined"!=
typeof MozBlobBuilder?MozBlobBuilder:"undefined"!=typeof WebKitBlobBuilder?WebKitBlobBuilder:S.hasBlobConstructor?null:console.log("warning: no BlobBuilder");S.URLObject="undefined"!=typeof window?window.URL?window.URL:window.webkitURL:void 0;F.noImageDecoding||"undefined"!==typeof S.URLObject||(console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available."),F.noImageDecoding=!0);F.preloadPlugins.push({canHandle:function(r){return!F.noImageDecoding&&
/\.(jpg|jpeg|png|bmp)$/i.test(r)},handle:function(r,v,D,aa){var ya=null;if(S.hasBlobConstructor)try{ya=new Blob([r],{type:S.getMimetype(v)}),ya.size!==r.length&&(ya=new Blob([(new Uint8Array(r)).buffer],{type:S.getMimetype(v)}))}catch(ca){ra.warnOnce("Blob constructor present but fails: "+ca+"; falling back to blob builder")}ya||(ya=new S.BlobBuilder,ya.append((new Uint8Array(r)).buffer),ya=ya.getBlob());var Ka=S.URLObject.createObjectURL(ya),ab=new Image;ab.onload=function(){fb(ab.complete,"Image "+
v+" could not be decoded");var aa=document.createElement("canvas");aa.width=ab.width;aa.height=ab.height;aa.getContext("2d").drawImage(ab,0,0);F.preloadedImages[v]=aa;S.URLObject.revokeObjectURL(Ka);D&&D(r)};ab.onerror=function(r){console.log("Image "+Ka+" could not be decoded");aa&&aa()};ab.src=Ka}});F.preloadPlugins.push({canHandle:function(r){return!F.noAudioDecoding&&r.substr(-4)in{".ogg":1,".wav":1,".mp3":1}},handle:function(r,v,D,aa){function ya(S){ra||(ra=!0,F.preloadedAudios[v]=S,D&&D(r))}
function ca(){ra||(ra=!0,F.preloadedAudios[v]=new Audio,aa&&aa())}var ra=!1;if(S.hasBlobConstructor){try{var Ka=new Blob([r],{type:S.getMimetype(v)})}catch(ab){return ca()}var Ka=S.URLObject.createObjectURL(Ka),fb=new Audio;fb.addEventListener("canplaythrough",function(){ya(fb)},!1);fb.onerror=function(D){if(!ra){console.log("warning: browser could not fully decode audio "+v+", trying slower base64 approach");D="data:audio/x-"+v.substr(-3)+";base64,";for(var F="",S=0,aa=0,ca=0;ca<r.length;ca++)for(S=
S<<8|r[ca],aa+=8;6<=aa;)var yc=S>>aa-6&63,aa=aa-6,F=F+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"[yc];2==aa?(F+="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"[(S&3)<<4],F+="=="):4==aa&&(F+="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"[(S&15)<<2],F+="=");fb.src=D+F;ya(fb)}};fb.src=Ka;S.safeSetTimeout(function(){ya(fb)},1E4)}else return ca()}});var v=F.canvas;v&&(v.requestPointerLock=v.requestPointerLock||v.mozRequestPointerLock||v.webkitRequestPointerLock||
v.msRequestPointerLock||function(){},v.exitPointerLock=document.exitPointerLock||document.mozExitPointerLock||document.webkitExitPointerLock||document.msExitPointerLock||function(){},v.exitPointerLock=v.exitPointerLock.bind(document),document.addEventListener("pointerlockchange",r,!1),document.addEventListener("mozpointerlockchange",r,!1),document.addEventListener("webkitpointerlockchange",r,!1),document.addEventListener("mspointerlockchange",r,!1),F.elementPointerLock&&v.addEventListener("click",
function(r){!S.pointerLock&&v.requestPointerLock&&(v.requestPointerLock(),r.preventDefault())},!1))}},createContext:function(r,v,A,D){if(v&&F.ctx&&r==F.canvas)return F.ctx;var ca,aa;if(v){aa={antialias:!1,alpha:!1};if(D)for(var ya in D)aa[ya]=D[ya];if(aa=GL.createContext(r,aa))ca=GL.getContext(aa).GLctx;r.style.backgroundColor="black"}else ca=r.getContext("2d");if(!ca)return null;A&&(v||fb("undefined"===typeof GLctx,"cannot set in module if GLctx is used, but we are a non-GL context that would replace it"),
F.ctx=ca,v&&GL.makeContextCurrent(aa),F.useWebGL=v,S.moduleContextCreatedCallbacks.forEach(function(r){r()}),S.init());return ca},destroyContext:function(r,v,A){},fullScreenHandlersInstalled:!1,lockPointer:void 0,resizeCanvas:void 0,requestFullScreen:function(r,v,A){function D(){S.isFullScreen=!1;var r=ca.parentNode;(document.webkitFullScreenElement||document.webkitFullscreenElement||document.mozFullScreenElement||document.mozFullscreenElement||document.fullScreenElement||document.fullscreenElement||
document.msFullScreenElement||document.msFullscreenElement||document.webkitCurrentFullScreenElement)===r?(ca.cancelFullScreen=document.cancelFullScreen||document.mozCancelFullScreen||document.webkitCancelFullScreen||document.msExitFullscreen||document.exitFullscreen||function(){},ca.cancelFullScreen=ca.cancelFullScreen.bind(document),S.lockPointer&&ca.requestPointerLock(),S.isFullScreen=!0,S.resizeCanvas&&S.setFullScreenCanvasSize()):(r.parentNode.insertBefore(ca,r),r.parentNode.removeChild(r),S.resizeCanvas&&
S.setWindowedCanvasSize());if(F.onFullScreen)F.onFullScreen(S.isFullScreen);S.updateCanvasDimensions(ca)}S.lockPointer=r;S.resizeCanvas=v;S.vrDevice=A;"undefined"===typeof S.lockPointer&&(S.lockPointer=!0);"undefined"===typeof S.resizeCanvas&&(S.resizeCanvas=!1);"undefined"===typeof S.vrDevice&&(S.vrDevice=null);var ca=F.canvas;S.fullScreenHandlersInstalled||(S.fullScreenHandlersInstalled=!0,document.addEventListener("fullscreenchange",D,!1),document.addEventListener("mozfullscreenchange",D,!1),document.addEventListener("webkitfullscreenchange",
D,!1),document.addEventListener("MSFullscreenChange",D,!1));var aa=document.createElement("div");ca.parentNode.insertBefore(aa,ca);aa.appendChild(ca);aa.requestFullScreen=aa.requestFullScreen||aa.mozRequestFullScreen||aa.msRequestFullscreen||(aa.webkitRequestFullScreen?function(){aa.webkitRequestFullScreen(Element.ALLOW_KEYBOARD_INPUT)}:null);A?aa.requestFullScreen({vrDisplay:A}):aa.requestFullScreen()},nextRAF:0,fakeRequestAnimationFrame:function(r){var v=Date.now();if(0===S.nextRAF)S.nextRAF=v+
1E3/60;else for(;v+2>=S.nextRAF;)S.nextRAF+=1E3/60;setTimeout(r,Math.max(S.nextRAF-v,0))},requestAnimationFrame:function(r){"undefined"===typeof window?S.fakeRequestAnimationFrame(r):(window.requestAnimationFrame||(window.requestAnimationFrame=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame||S.fakeRequestAnimationFrame),window.requestAnimationFrame(r))},safeCallback:function(r){return function(){if(!xe)return r.apply(null,
arguments)}},allowAsyncCallbacks:!0,queuedAsyncCallbacks:[],pauseAsyncCallbacks:function(){S.allowAsyncCallbacks=!1},resumeAsyncCallbacks:function(){S.allowAsyncCallbacks=!0;if(0<S.queuedAsyncCallbacks.length){var r=S.queuedAsyncCallbacks;S.queuedAsyncCallbacks=[];r.forEach(function(r){r()})}},safeRequestAnimationFrame:function(r){return S.requestAnimationFrame(function(){xe||(S.allowAsyncCallbacks?r():S.queuedAsyncCallbacks.push(r))})},safeSetTimeout:function(r,v){F.noExitRuntime=!0;return setTimeout(function(){xe||
(S.allowAsyncCallbacks?r():S.queuedAsyncCallbacks.push(r))},v)},safeSetInterval:function(r,v){F.noExitRuntime=!0;return setInterval(function(){xe||S.allowAsyncCallbacks&&r()},v)},getMimetype:function(r){return{jpg:"image/jpeg",jpeg:"image/jpeg",png:"image/png",bmp:"image/bmp",ogg:"audio/ogg",wav:"audio/wav",mp3:"audio/mpeg"}[r.substr(r.lastIndexOf(".")+1)]},getUserMedia:function(r){window.getUserMedia||(window.getUserMedia=navigator.getUserMedia||navigator.mozGetUserMedia);window.getUserMedia(r)},
getMovementX:function(r){return r.movementX||r.mozMovementX||r.webkitMovementX||0},getMovementY:function(r){return r.movementY||r.mozMovementY||r.webkitMovementY||0},getMouseWheelDelta:function(r){switch(r.type){case "DOMMouseScroll":r=r.detail;break;case "mousewheel":r=r.wheelDelta;break;case "wheel":r=r.deltaY;break;default:throw"unrecognized mouse wheel event: "+r.type;}return r},mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:function(r){if(S.pointerLock)"mousemove"!=
r.type&&"mozMovementX"in r?S.mouseMovementX=S.mouseMovementY=0:(S.mouseMovementX=S.getMovementX(r),S.mouseMovementY=S.getMovementY(r)),"undefined"!=typeof SDL?(S.mouseX=SDL.mouseX+S.mouseMovementX,S.mouseY=SDL.mouseY+S.mouseMovementY):(S.mouseX+=S.mouseMovementX,S.mouseY+=S.mouseMovementY);else{var v=F.canvas.getBoundingClientRect(),A=F.canvas.width,D=F.canvas.height,ca="undefined"!==typeof window.scrollX?window.scrollX:window.pageXOffset,aa="undefined"!==typeof window.scrollY?window.scrollY:window.pageYOffset;
if("touchstart"===r.type||"touchend"===r.type||"touchmove"===r.type){var ya=r.touch;if(void 0!==ya)if(ca=ya.pageX-(ca+v.left),aa=ya.pageY-(aa+v.top),ca*=A/v.width,aa*=D/v.height,v={x:ca,y:aa},"touchstart"===r.type)S.lastTouches[ya.identifier]=v,S.touches[ya.identifier]=v;else if("touchend"===r.type||"touchmove"===r.type)(r=S.touches[ya.identifier])||(r=v),S.lastTouches[ya.identifier]=r,S.touches[ya.identifier]=v}else ya=r.pageX-(ca+v.left),r=r.pageY-(aa+v.top),ya*=A/v.width,r*=D/v.height,S.mouseMovementX=
ya-S.mouseX,S.mouseMovementY=r-S.mouseY,S.mouseX=ya,S.mouseY=r}},xhrLoad:function(r,v,A){var D=new XMLHttpRequest;D.open("GET",r,!0);D.responseType="arraybuffer";D.onload=function(){200==D.status||0==D.status&&D.response?v(D.response):A()};D.onerror=A;D.send(null)},asyncLoad:function(r,v,A,D){S.xhrLoad(r,function(A){fb(A,'Loading data file "'+r+'" failed (no arrayBuffer).');v(new Uint8Array(A));D||ng("al "+r)},function(v){if(A)A();else throw'Loading data file "'+r+'" failed.';});D||Yg("al "+r)},resizeListeners:[],
updateResizeListeners:function(){var r=F.canvas;S.resizeListeners.forEach(function(v){v(r.width,r.height)})},setCanvasSize:function(r,v,A){S.updateCanvasDimensions(F.canvas,r,v);A||S.updateResizeListeners()},windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function(){"undefined"!=typeof SDL&&(Sb[SDL.screen+0*ra.QUANTUM_SIZE>>2]=xf[SDL.screen+0*ra.QUANTUM_SIZE>>2]|8388608);S.updateResizeListeners()},setWindowedCanvasSize:function(){"undefined"!=typeof SDL&&(Sb[SDL.screen+0*ra.QUANTUM_SIZE>>
2]=xf[SDL.screen+0*ra.QUANTUM_SIZE>>2]&-8388609);S.updateResizeListeners()},updateCanvasDimensions:function(r,v,A){v&&A?(r.widthNative=v,r.heightNative=A):(v=r.widthNative,A=r.heightNative);var D=v,ca=A;F.forcedAspectRatio&&0<F.forcedAspectRatio&&(D/ca<F.forcedAspectRatio?D=Math.round(ca*F.forcedAspectRatio):ca=Math.round(D/F.forcedAspectRatio));if((document.webkitFullScreenElement||document.webkitFullscreenElement||document.mozFullScreenElement||document.mozFullscreenElement||document.fullScreenElement||
document.fullscreenElement||document.msFullScreenElement||document.msFullscreenElement||document.webkitCurrentFullScreenElement)===r.parentNode&&"undefined"!=typeof screen)var aa=Math.min(screen.width/D,screen.height/ca),D=Math.round(D*aa),ca=Math.round(ca*aa);S.resizeCanvas?(r.width!=D&&(r.width=D),r.height!=ca&&(r.height=ca),"undefined"!=typeof r.style&&(r.style.removeProperty("width"),r.style.removeProperty("height"))):(r.width!=v&&(r.width=v),r.height!=A&&(r.height=A),"undefined"!=typeof r.style&&
(D!=v||ca!=A?(r.style.setProperty("width",D+"px","important"),r.style.setProperty("height",ca+"px","important")):(r.style.removeProperty("width"),r.style.removeProperty("height"))))},wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:function(){var r=S.nextWgetRequestHandle;S.nextWgetRequestHandle++;return r}};F._i64Subtract=Lj;F._memset=Mi;F._bitshift64Shl=Mj;var Ka={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:function(r,v){if("/"!==v[0]){var A;if(-100===r)A=D.cwd();else{A=
D.getStream(r);if(!A)throw new D.ErrnoError(ca.EBADF);A=A.path}v=jc.join2(A,v)}return v},doStat:function(r,v,A){try{var F=r(v)}catch(S){if(S&&S.node&&jc.normalize(v)!==jc.normalize(D.getPath(S.node)))return-ca.ENOTDIR;throw S;}Sb[A>>2]=F.dev;Sb[A+4>>2]=0;Sb[A+8>>2]=F.ino;Sb[A+12>>2]=F.mode;Sb[A+16>>2]=F.nlink;Sb[A+20>>2]=F.uid;Sb[A+24>>2]=F.gid;Sb[A+28>>2]=F.rdev;Sb[A+32>>2]=0;Sb[A+36>>2]=F.size;Sb[A+40>>2]=4096;Sb[A+44>>2]=F.blocks;Sb[A+48>>2]=F.atime.getTime()/1E3|0;Sb[A+52>>2]=0;Sb[A+56>>2]=F.mtime.getTime()/
1E3|0;Sb[A+60>>2]=0;Sb[A+64>>2]=F.ctime.getTime()/1E3|0;Sb[A+68>>2]=0;Sb[A+72>>2]=F.ino;return 0},doMsync:function(r,v,A,F){r=new Uint8Array(Od.subarray(r,r+A));D.msync(v,r,0,A,F)},doMkdir:function(r,v){r=jc.normalize(r);"/"===r[r.length-1]&&(r=r.substr(0,r.length-1));D.mkdir(r,v,0);return 0},doMknod:function(r,v,A){switch(v&61440){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-ca.EINVAL}D.mknod(r,v,A);return 0},doReadlink:function(r,v,A){if(0>=A)return-ca.EINVAL;r=D.readlink(r);
r=r.slice(0,Math.max(0,A));Ji(r,v,!0);return r.length},doAccess:function(r,v){if(v&-8)return-ca.EINVAL;var A;A=D.lookupPath(r,{follow:!0}).node;var F="";v&4&&(F+="r");v&2&&(F+="w");v&1&&(F+="x");return F&&D.nodePermissions(A,F)?-ca.EACCES:0},doDup:function(r,v,A){var F=D.getStream(A);F&&D.close(F);return D.open(r,v,0,A,A).fd},doReadv:function(r,v,A,F){for(var S=0,aa=0;aa<A;aa++){var ca=Sb[v+(8*aa+4)>>2],ra=D.read(r,Dd,Sb[v+8*aa>>2],ca,F);if(0>ra)return-1;S+=ra;if(ra<ca)break}return S},doWritev:function(r,
v,A,F){for(var S=0,aa=0;aa<A;aa++){var ca=D.write(r,Dd,Sb[v+8*aa>>2],Sb[v+(8*aa+4)>>2],F);if(0>ca)return-1;S+=ca}return S},varargs:0,get:function(r){Ka.varargs+=4;return Sb[Ka.varargs-4>>2]},getStr:function(){return Yd(Ka.get())},getStreamFromFD:function(){var r=D.getStream(Ka.get());if(!r)throw new D.ErrnoError(ca.EBADF);return r},getSocketFromFD:function(){var r=SOCKFS.getSocket(Ka.get());if(!r)throw new D.ErrnoError(ca.EBADF);return r},getSocketAddress:function(r){var v=Ka.get(),A=Ka.get();if(r&&
0===v)return null;r=__read_sockaddr(v,A);if(r.errno)throw new D.ErrnoError(r.errno);r.addr=DNS.lookup_addr(r.addr)||r.addr;return r},get64:function(){var r=Ka.get(),v=Ka.get();0<=r?fb(0===v):fb(-1===v);return r},getZero:function(){fb(0===Ka.get())}};F._i64Add=Nj;var Oj=Lh,Pj=Ij;F._realloc=Ph;F._saveSetjmp=Qj;F._bitshift64Lshr=Rj;F._testSetjmp=Sj;var Rh=vc(1,"i32*",2),Td={},Tj=Hj,Uj=Fg;F._memcpy=Vj;var Wj=Fj;F._llvm_bswap_i32=Xj;var Yj=Gj,Zj=Jj;F.requestFullScreen=function(r,v,A){S.requestFullScreen(r,
v,A)};F.requestAnimationFrame=function(r){S.requestAnimationFrame(r)};F.setCanvasSize=function(r,v,A){S.setCanvasSize(r,v,A)};F.pauseMainLoop=function(){S.mainLoop.pause()};F.resumeMainLoop=function(){S.mainLoop.resume()};F.getUserMedia=function(){S.getUserMedia()};F.createContext=function(r,v,A,D){return S.createContext(r,v,A,D)};D.staticInit();qg.unshift(function(){F.noFSInit||D.init.initialized||D.init()});rg.push(function(){D.ignorePermissions=!1});re.push(function(){D.quit()});F.FS_createFolder=
D.createFolder;F.FS_createPath=D.createPath;F.FS_createDataFile=D.createDataFile;F.FS_createPreloadedFile=D.createPreloadedFile;F.FS_createLazyFile=D.createLazyFile;F.FS_createLink=D.createLink;F.FS_createDevice=D.createDevice;F.FS_unlink=D.unlink;qg.unshift(function(){ye.init()});re.push(function(){ye.shutdown()});if(Bf){var cd=require("fs"),Li=require("path");Wc.staticInit()}Af(Td);Zh=se=ra.alignMemory(Se);pi=!0;vh=Zh+$h;ch=we=ra.alignMemory(vh);fb(ch<ld,"TOTAL_MEMORY not big enough for stack");
var ak=vc([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,
0,1,0,3,0,1,0,2,0,1,0],"i8",3);F.asmGlobalArg={Math:Math,Int8Array:Int8Array,Int16Array:Int16Array,Int32Array:Int32Array,Uint8Array:Uint8Array,Uint16Array:Uint16Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array,NaN:NaN,Infinity:Infinity,byteLength:Kg};F.asmLibraryArg={abort:Vc,assert:fb,invoke_iiii:function(r,v,A,D){try{return F.dynCall_iiii(r,v,A,D)}catch(S){if("number"!==typeof S&&"longjmp"!==S)throw S;ab.setThrew(1,0)}},invoke_viiiiiii:function(r,v,A,D,S,aa,ca,ra){try{F.dynCall_viiiiiii(r,
v,A,D,S,aa,ca,ra)}catch(Ka){if("number"!==typeof Ka&&"longjmp"!==Ka)throw Ka;ab.setThrew(1,0)}},invoke_viiiii:function(r,v,A,D,S,aa){try{F.dynCall_viiiii(r,v,A,D,S,aa)}catch(ca){if("number"!==typeof ca&&"longjmp"!==ca)throw ca;ab.setThrew(1,0)}},invoke_vi:function(r,v){try{F.dynCall_vi(r,v)}catch(A){if("number"!==typeof A&&"longjmp"!==A)throw A;ab.setThrew(1,0)}},invoke_vii:function(r,v,A){try{F.dynCall_vii(r,v,A)}catch(D){if("number"!==typeof D&&"longjmp"!==D)throw D;ab.setThrew(1,0)}},invoke_iiiiiii:function(r,
v,A,D,S,aa,ca){try{return F.dynCall_iiiiiii(r,v,A,D,S,aa,ca)}catch(ra){if("number"!==typeof ra&&"longjmp"!==ra)throw ra;ab.setThrew(1,0)}},invoke_viiiiiiiiiiii:function(r,v,A,D,S,aa,ca,ra,Ka,fb,Lb,jc,Y){try{F.dynCall_viiiiiiiiiiii(r,v,A,D,S,aa,ca,ra,Ka,fb,Lb,jc,Y)}catch(Sb){if("number"!==typeof Sb&&"longjmp"!==Sb)throw Sb;ab.setThrew(1,0)}},invoke_ii:function(r,v){try{return F.dynCall_ii(r,v)}catch(A){if("number"!==typeof A&&"longjmp"!==A)throw A;ab.setThrew(1,0)}},invoke_viii:function(r,v,A,D){try{F.dynCall_viii(r,
v,A,D)}catch(S){if("number"!==typeof S&&"longjmp"!==S)throw S;ab.setThrew(1,0)}},invoke_viiiiiiiii:function(r,v,A,D,S,aa,ca,ra,Ka,fb){try{F.dynCall_viiiiiiiii(r,v,A,D,S,aa,ca,ra,Ka,fb)}catch(Lb){if("number"!==typeof Lb&&"longjmp"!==Lb)throw Lb;ab.setThrew(1,0)}},invoke_iiiii:function(r,v,A,D,S){try{return F.dynCall_iiiii(r,v,A,D,S)}catch(aa){if("number"!==typeof aa&&"longjmp"!==aa)throw aa;ab.setThrew(1,0)}},invoke_iii:function(r,v,A){try{return F.dynCall_iii(r,v,A)}catch(D){if("number"!==typeof D&&
"longjmp"!==D)throw D;ab.setThrew(1,0)}},invoke_iiiiii:function(r,v,A,D,S,aa){try{return F.dynCall_iiiiii(r,v,A,D,S,aa)}catch(ca){if("number"!==typeof ca&&"longjmp"!==ca)throw ca;ab.setThrew(1,0)}},invoke_viiii:function(r,v,A,D,S){try{F.dynCall_viiii(r,v,A,D,S)}catch(aa){if("number"!==typeof aa&&"longjmp"!==aa)throw aa;ab.setThrew(1,0)}},_pthread_cleanup_pop:function(){fb(ni.level==re.length,"cannot pop if something else added meanwhile!");re.pop();ni.level=re.length},_fabs:Uj,_exp:Yj,_llvm_pow_f64:Zj,
___syscall54:function(r,v){Ka.varargs=v;try{var A=Ka.getStreamFromFD(),F=Ka.get();switch(F){case 21505:return A.tty?0:-ca.ENOTTY;case 21506:return A.tty?0:-ca.ENOTTY;case 21519:if(!A.tty)return-ca.ENOTTY;var S=Ka.get();return Sb[S>>2]=0;case 21520:return A.tty?-ca.EINVAL:-ca.ENOTTY;case 21531:return S=Ka.get(),D.ioctl(A,F,S);default:Vc("bad ioctl syscall "+F)}}catch(aa){return"undefined"!==typeof D&&aa instanceof D.ErrnoError||Vc(aa),-aa.errno}},_pthread_cleanup_push:ni,___syscall6:function(r,v){Ka.varargs=
v;try{var A=Ka.getStreamFromFD();D.close(A);return 0}catch(F){return"undefined"!==typeof D&&F instanceof D.ErrnoError||Vc(F),-F.errno}},_atan2:Wj,___setErrNo:eg,___assert_fail:function(r,v,A,D){xe=!0;throw"Assertion failed: "+Yd(r)+", at: "+[v?Yd(v):"unknown filename",A,D?Yd(D):"unknown function"]+" at "+wf();},___buildEnvironment:Af,_longjmp:Zg,___syscall91:function(r,v){Ka.varargs=v;try{var A=Ka.get(),F=Ka.get(),S=Ka.mappings[A];if(!S)return 0;if(F===S.len){var aa=D.getStream(S.fd);Ka.doMsync(A,
aa,F,S.flags);D.munmap(aa);Ka.mappings[A]=null;S.allocated&&vf(S.malloc)}return 0}catch(ca){return"undefined"!==typeof D&&ca instanceof D.ErrnoError||Vc(ca),-ca.errno}},_emscripten_set_main_loop_timing:hj,_sbrk:og,___syscall192:function(r,v){Ka.varargs=v;try{var A=Ka.get(),F=Ka.get(),S=Ka.get(),aa=Ka.get(),ya=Ka.get(),ra=Ka.get(),ra=ra<<12,ab,fb=!1;if(-1===ya){ab=uf(F);if(!ab)return-ca.ENOMEM;Mi(ab,0,F);fb=!0}else{var Lb=D.getStream(ya);if(!Lb)return-ca.EBADF;var Sb=D.mmap(Lb,Od,A,F,ra,S,aa);ab=Sb.ptr;
fb=Sb.allocated}Ka.mappings[ab]={malloc:ab,len:F,allocated:fb,fd:ya,flags:aa};return ab}catch(Y){return"undefined"!==typeof D&&Y instanceof D.ErrnoError||Vc(Y),-Y.errno}},___syscall197:function(r,v){Ka.varargs=v;try{var A=Ka.getStreamFromFD(),F=Ka.get();return Ka.doStat(D.stat,A.path,F)}catch(S){return"undefined"!==typeof D&&S instanceof D.ErrnoError||Vc(S),-S.errno}},_emscripten_memcpy_big:function(r,v,A){Od.set(Od.subarray(v,v+A),r);return r},__exit:Qh,___syscall195:function(r,v){Ka.varargs=v;try{var A=
Ka.getStr(),F=Ka.get();return Ka.doStat(D.stat,A,F)}catch(S){return"undefined"!==typeof D&&S instanceof D.ErrnoError||Vc(S),-S.errno}},___syscall221:function(r,v){Ka.varargs=v;try{var A=Ka.getStreamFromFD();switch(Ka.get()){case 0:var F=Ka.get();return 0>F?-ca.EINVAL:D.open(A.path,A.flags,0,F).fd;case 1:case 2:return 0;case 3:return A.flags;case 4:return F=Ka.get(),A.flags|=F,0;case 12:case 12:return F=Ka.get(),gf[F+0>>1]=2,0;case 13:case 14:case 13:case 14:return 0;case 16:case 8:return-ca.EINVAL;
case 9:return eg(ca.EINVAL),-1;default:return-ca.EINVAL}}catch(S){return"undefined"!==typeof D&&S instanceof D.ErrnoError||Vc(S),-S.errno}},_floor:Oj,_pthread_self:function(){return 0},_getenv:Ig,_sqrt:Pj,_log:Tj,___unlock:function(){},_emscripten_set_main_loop:Oh,___syscall3:function(r,v){Ka.varargs=v;try{var A=Ka.getStreamFromFD(),F=Ka.get(),S=Ka.get();return D.read(A,Dd,F,S)}catch(aa){return"undefined"!==typeof D&&aa instanceof D.ErrnoError||Vc(aa),-aa.errno}},_sysconf:function(r){switch(r){case 30:return 4096;
case 85:return Pc/4096;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;
case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1E3;case 89:return 700;case 71:return 256;
case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:return"object"===typeof navigator?navigator.hardwareConcurrency||1:1}eg(ca.EINVAL);return-1},___lock:function(){},_abort:function(){F.abort()},___syscall5:function(r,v){Ka.varargs=v;try{var A=Ka.getStr(),F=Ka.get(),S=Ka.get();return D.open(A,F,S).fd}catch(aa){return"undefined"!==typeof D&&aa instanceof D.ErrnoError||Vc(aa),-aa.errno}},___syscall4:function(r,v){Ka.varargs=
v;try{var A=Ka.getStreamFromFD(),F=Ka.get(),S=Ka.get();return D.write(A,Dd,F,S)}catch(aa){return"undefined"!==typeof D&&aa instanceof D.ErrnoError||Vc(aa),-aa.errno}},_time:function(r){var v=Date.now()/1E3|0;r&&(Sb[r>>2]=v);return v},_emscripten_longjmp:function(r,v){Zg(r,v)},___syscall140:function(r,v){Ka.varargs=v;try{var A=Ka.getStreamFromFD(),F=Ka.get(),S=Ka.get(),aa=Ka.get(),ca=Ka.get();fb(0===F);D.llseek(A,S,ca);Sb[aa>>2]=A.position;A.getdents&&0===S&&0===ca&&(A.getdents=null);return 0}catch(ra){return"undefined"!==
typeof D&&ra instanceof D.ErrnoError||Vc(ra),-ra.errno}},_exit:function(r){Qh(r)},___syscall146:function(r,v){Ka.varargs=v;try{var A=Ka.getStreamFromFD(),F=Ka.get(),S=Ka.get();return Ka.doWritev(A,F,S)}catch(aa){return"undefined"!==typeof D&&aa instanceof D.ErrnoError||Vc(aa),-aa.errno}},STACKTOP:se,STACK_MAX:vh,tempDoublePtr:ai,ABORT:xe,cttz_i8:ak};var ab=function(r,v,A){function D(b,d,c){b|=0;d|=0;c|=0;var e,f,g,h,m,k,l,n,p,q,y;e=u;u=u+16|0;f=e+4|0;g=e;h=d+2|0;switch(N[h>>1]|0){case 12:case 11:case 10:case 5:case 17:case 16:case 9:case 4:case 8:case 3:case 6:case 1:break;
default:return u=e,2}m=ra(b,d,f,8,g)|0;g=d=a[g>>2]|0;if(0!=(m|0)|0==(d|0))return a[c>>2]=0,u=e,m|0;if(12==(w[h>>1]|0))return a[b+12>>2]&128&&Ae(d,a[f>>2]|0),a[c>>2]=g,u=e,0;g=a[f>>2]|0;f=eb(g<<3)|0;if(!f)return ja(d),u=e,7;do switch(N[h>>1]|0){case 1:if(g)for(m=d,k=f,l=0;!(Hb[k>>3]=+(x[m>>0]|0),l=l+1|0,l>>>0>=g>>>0);)m=m+1|0,k=k+8|0;break;case 6:if(g)for(k=d,m=f,l=0;!(Hb[m>>3]=+(t[k>>0]|0),l=l+1|0,l>>>0>=g>>>0);)k=k+1|0,m=m+8|0;break;case 3:if(g)for(m=b+12|0,k=d,l=f,n=0;!(a[m>>2]&128&&ac(k),Hb[l>>
3]=+(N[k>>1]|0),n=n+1|0,n>>>0>=g>>>0);)k=k+2|0,l=l+8|0;break;case 8:if(g)for(l=b+12|0,k=d,n=f,m=0;!(a[l>>2]&128&&ac(k),Hb[n>>3]=+(w[k>>1]|0),m=m+1|0,m>>>0>=g>>>0);)k=k+2|0,n=n+8|0;break;case 4:if(g)for(n=b+12|0,k=d,m=f,l=0;!(a[n>>2]&128&&pb(k),Hb[m>>3]=+((a[k>>2]|0)>>>0),l=l+1|0,l>>>0>=g>>>0);)k=k+4|0,m=m+8|0;break;case 9:if(g)for(m=b+12|0,k=d,l=f,n=0;!(a[m>>2]&128&&pb(k),Hb[l>>3]=+(a[k>>2]|0),n=n+1|0,n>>>0>=g>>>0);)k=k+4|0,l=l+8|0;break;case 16:if(g)for(l=b+12|0,k=d,n=f,m=0;!(a[l>>2]&128&&kc(k),
p=k,Hb[n>>3]=+((a[p>>2]|0)>>>0)+4294967296*+((a[p+4>>2]|0)>>>0),m=m+1|0,m>>>0>=g>>>0);)k=k+8|0,n=n+8|0;break;case 17:if(g)for(n=b+12|0,k=d,m=f,l=0;!(a[n>>2]&128&&kc(k),p=k,Hb[m>>3]=+((a[p>>2]|0)>>>0)+4294967296*+(a[p+4>>2]|0),l=l+1|0,l>>>0>=g>>>0);)k=k+8|0,m=m+8|0;break;case 5:if(g)for(m=b+12|0,k=d,l=f,n=0;!(p=a[m>>2]|0,p&128?(pb(k),q=a[m>>2]|0):q=p,p=k+4|0,y=a[k>>2]|0,q&128&&pb(p),y=(q=a[p>>2]|0)?+(y>>>0)/+(q>>>0):0,Hb[l>>3]=y,n=n+1|0,n>>>0>=g>>>0);)k=k+8|0,l=l+8|0;break;case 10:if(g)for(l=b+12|
0,k=d,n=f,m=0;!(q=a[l>>2]|0,q&128?(pb(k),p=a[l>>2]|0):p=q,q=a[k>>2]|0,y=k+4|0,p&128&&pb(y),y=(p=a[y>>2]|0)?+(q|0)/+(p>>>0):0,Hb[n>>3]=y,m=m+1|0,m>>>0>=g>>>0);)k=k+8|0,n=n+8|0;break;case 11:if(a[b+12>>2]&128&&Id(d,g),g)for(n=d,k=f,m=0;!(Hb[k>>3]=+W[n>>2],m=m+1|0,m>>>0>=g>>>0);)n=n+4|0,k=k+8|0}while(0);ja(d);a[c>>2]=f;u=e;return 0}function F(b,d,c,e){b|=0;d|=0;c|=0;e|=0;var f,g,h,m;f=u;u=u+16|0;if(g=ca(b,d,f)|0)return m=(h=Lf(b,N[d>>1]|0)|0)?a[h+28>>2]|0:133413,wh(b,g,134332,m,0),u=f,0;d=m=d+8|0;if(0==
(a[d+4>>2]|0)&&(a[d>>2]|0)==(c|0))b=a[f>>2]|0;else{d=Mf(b,c,8,134352)|0;if(!d)return ja(a[f>>2]|0),u=f,0;b=m;g=a[b>>2]|0;h=a[b+4>>2]|0;b=a[f>>2]|0;0>h>>>0|0==(h|0)&g>>>0<c>>>0?(Ab(d,b,g<<3),g=a[m>>2]|0,$c(d+(g<<3)|0,0,c-g<<3)):Ab(d,b,c<<3);ja(b);b=a[f>>2]=d}a[e>>2]=b;u=f;return 1}function S(b,d,c){b|=0;d|=0;c|=0;var e,f,g,h,m,k,l,n,p,q,y,B,H,t;e=u;u=u+16|0;f=b+176|0;(g=a[f>>2]|0)&&ja(g);g=b+168|0;h=Mf(b,a[g>>2]|0,8,134235)|0;a[f>>2]=h;if(!h)return u=e,-1;do if(1==(w[b+88>>1]|0))if(a[b+12>>2]&1024){if(h=
b,h|=0,m=Kf(h,a[h+72>>2]|0)|0,n=U,h=a[g>>2]|0){k=a[f>>2]|0;l=0;do p=k+(l<<3)|0,a[p>>2]=m,a[p+4>>2]=n,l=l+1|0;while(l>>>0<h>>>0)}}else{if(h=Td(b)|0,m=a[g>>2]|0){k=Cf(((a[b+60>>2]|0)>>>0)/((a[b+164>>2]|0)>>>0)|0,0,h|0,U|0)|0;h=U;l=a[f>>2]|0;n=0;do p=l+(n<<3)|0,a[p>>2]=k,a[p+4>>2]=h,n=n+1|0;while(n>>>0<m>>>0)}}else{h=b+628|0;l=da[a[b+648>>2]&63](a[h>>2]|0)|0;n=U;m=b+12|0;k=c&65535;p=0==(a[m>>2]&524288|0)?(12*k|0)+14|0:(20*k|0)+32|0;a:do{if(c<<16>>16){k=p;y=0;q=d;for(B=c;;){H=q+2|0;p=Ne(N[H>>1]|0)|0;
if(!p){b=H;break}H=q+8|0;t=Cf(a[H>>2]|0,a[H+4>>2]|0,p|0,0)|0;p=U;H=0==(a[m>>2]&524288|0)?0>p>>>0|0==(p|0)&5>t>>>0:0>p>>>0|0==(p|0)&9>t>>>0;y=Qb((H?0:t)|0,(H?0:p)|0,k|0,y|0)|0;p=U;B=B+-1<<16>>16;if(B<<16>>16)k=y,y=p,q=q+24|0;else{q=y;y=p;break a}}q=a[h>>2]|0;a[e>>2]=N[b>>1];Y(q,134263,134287,e);u=e;return-1}q=p;y=0}while(0);h=Ic(l|0,n|0,q|0,y|0)|0;m=U;2==(w[b+126>>1]|0)?(B=p=pf(h|0,m|0,N[b+98>>1]|0,0)|0,k=U):(B=h,k=m);m=a[g>>2]|0;h=a[f>>2]|0;if(m){p=1<m>>>0;q=0;do y=h+(q<<3)|0,a[y>>2]=B,a[y+4>>2]=
k,q=q+1|0;while(q>>>0<m>>>0);m=p?m+-1|0:0}else m=-1;q=(a[b+172>>2]|0)+(m<<3)|0;y=a[q>>2]|0;k=a[q+4>>2]|0;B=q=h+(m<<3)|0;p=Qb(a[B>>2]|0,a[B+4>>2]|0,y|0,k|0)|0;B=U;B>>>0>n>>>0|(B|0)==(n|0)&p>>>0>l>>>0&&(p=Ic(l|0,n|0,y|0,k|0)|0,k=q,a[k>>2]=p,a[k+4>>2]=U)}while(0);m=b+40|0;k=a[m>>2]|0;a[m>>2]=k|16777216;if(k&131072)return u=e,1;a[b+100>>2]=a[b+60>>2];u=e;return 1}function ca(b,d,c){b|=0;d|=0;c|=0;var e,f,g,h,m,k,l,n,p,q,y=0;e=u;u=u+16|0;f=e+4|0;g=e;h=d+2|0;switch(N[h>>1]|0){case 17:case 16:case 9:case 4:case 8:case 3:case 6:case 1:break;
default:return u=e,2}m=ra(b,d,f,8,g)|0;g=d=a[g>>2]|0;if(0!=(m|0)|0==(d|0))return a[c>>2]=0,u=e,m|0;switch(N[h>>1]|0){case 16:a[c>>2]=d;if(!(a[b+12>>2]&128)){u=e;break}Ae(d,a[f>>2]|0);u=e;break;case 17:m=a[f>>2]|0;a:do if(m){k=b+12|0;l=d;for(n=0;;){a[k>>2]&128&&kc(l);p=l;q=a[p+4>>2]|0;if(!(-1<(q|0)|-1==(q|0)&4294967295<(a[p>>2]|0)>>>0))break;n=n+1|0;if(n>>>0>=m>>>0)break a;else l=l+8|0}ja(d);u=e;return 4}while(0);a[c>>2]=g;u=e;break;default:g=a[f>>2]|0;f=eb(g<<3)|0;if(!f)return ja(d),u=e,7;a:do switch(N[h>>
1]|0){case 1:if(g)for(m=d,l=f,n=0;;)if(k=l,a[k>>2]=x[m>>0],a[k+4>>2]=0,n=n+1|0,n>>>0>=g>>>0){m=46;break}else m=m+1|0,l=l+8|0;else m=46;break;case 6:if(g)for(l=d,m=f,n=0;;){k=t[l>>0]|0;if(-1>=k<<24>>24){y=4;m=45;break a}p=k<<24>>24;k=m;a[k>>2]=p;a[k+4>>2]=(0>(p|0))<<31>>31;n=n+1|0;if(n>>>0>=g>>>0){m=46;break}else l=l+1|0,m=m+8|0}else m=46;break;case 3:if(g)for(m=b+12|0,l=d,n=f,p=0;;)if(a[m>>2]&128&&ac(l),k=n,a[k>>2]=N[l>>1],a[k+4>>2]=0,p=p+1|0,p>>>0>=g>>>0){m=46;break}else l=l+2|0,n=n+8|0;else m=46;
break;case 8:if(g)for(n=b+12|0,l=d,p=f,m=0;;){a[n>>2]&128&&ac(l);k=w[l>>1]|0;if(-1>=k<<16>>16){y=4;m=45;break a}q=k<<16>>16;k=p;a[k>>2]=q;a[k+4>>2]=(0>(q|0))<<31>>31;m=m+1|0;if(m>>>0>=g>>>0){m=46;break}else l=l+2|0,p=p+8|0}else m=46;break;case 4:if(g)for(p=b+12|0,l=d,m=f,n=0;;)if(a[p>>2]&128&&pb(l),q=m,a[q>>2]=a[l>>2],a[q+4>>2]=0,n=n+1|0,n>>>0>=g>>>0){m=46;break}else l=l+4|0,m=m+8|0;else m=46;break;case 9:if(g)for(m=b+12|0,l=d,n=f,p=0;;){a[m>>2]&128&&pb(l);q=a[l>>2]|0;if(k=q>>31&4){y=k;m=45;break a}k=
n;a[k>>2]=q;a[k+4>>2]=(0>(q|0))<<31>>31;p=p+1|0;if(p>>>0>=g>>>0){m=46;break}else l=l+4|0,n=n+8|0}else m=46;break;default:m=46}while(0);if(45==(m|0))return ja(d),ja(f),u=e,y|0;46==(m|0)&&(ja(d),a[c>>2]=f,u=e)}return 0}function ra(b,d,c,e,f){b|=0;d|=0;c|=0;e|=0;f|=0;var g,h,m,k,l,n,p;g=u;u=u+16|0;h=g+8|0;m=Ne(N[d+2>>1]|0)|0;k=d+8|0;l=a[k>>2]|0;n=a[k+4>>2]|0;if(0==(m|0)|0==(l|0)&0==(n|0))return a[f>>2]=0,u=g,0;k=2147483647/(m|0)|0;p=(0>(k|0))<<31>>31;if(p>>>0<n>>>0|(p|0)==(n|0)&k>>>0<l>>>0||0<n>>>0|
(0==(n|0)?(2147483647/(e>>>0)|0)>>>0<l>>>0:0))return u=g,6;a[c>>2]=l;c=E(l,m)|0;0>=(c|0)&&Z(134368,133171,790,134389);e=Mf(b,l,m,134411)|0;if(!e)return u=g,7;m=b+12|0;l=a[m>>2]|0;do if(l&524288)if(9>c>>>0)Ab(e,d+16|0,c);else{k=d+16|0;n=a[k>>2]|0;p=a[k+4>>2]|0;k=g;a[k>>2]=n;a[k+4>>2]=p;l&128?(kc(g),p=g,k=a[m>>2]|0,h=a[p>>2]|0,d=a[p+4>>2]|0):(k=l,h=n,d=p);if(k&2048){if(p=h+c|0,p>>>0<c>>>0|(h|0)!=(h|0)|0!=(d|0)|p>>>0<h>>>0?0:p>>>0<=(a[b+616>>2]|0)>>>0){Ab(e,(a[b+612>>2]|0)+h|0,c);break}}else if(p=b+
628|0,n=rb[a[b+640>>2]&63](a[p>>2]|0,h,d,0)|0,(n|0)==(h|0)&(U|0)==(d|0)&&(Aa[a[b+632>>2]&63](a[p>>2]|0,e,c)|0)==(c|0))break;ja(e);b=3;u=g;return b|0}else if(n=d+16|0,5>c>>>0)Ab(e,n,c);else{k=a[n>>2]|0;a[h>>2]=k;l&128?(pb(h),n=a[m>>2]|0,p=a[h>>2]|0):(n=l,p=k);if(n&2048){if(k=p+c|0,k>>>0<c>>>0|k>>>0<p>>>0?0:k>>>0<=(a[b+616>>2]|0)>>>0){Ab(e,(a[b+612>>2]|0)+p|0,c);break}}else if(k=b+628|0,n=rb[a[b+640>>2]&63](a[k>>2]|0,p,0,0)|0,(n|0)==(p|0)&0==(U|0)&&(Aa[a[b+632>>2]&63](a[k>>2]|0,e,c)|0)==(c|0))break;
ja(e);b=3;u=g;return b|0}while(0);a[f>>2]=e;u=g;return 0}function Ka(b,d,c){b|=0;d|=0;c|=0;var e,f,g,h,m,k,l,n,p,q,y,B;e=u;u=u+16|0;f=e+4|0;g=d+2|0;switch(N[g>>1]|0){case 17:case 16:case 9:case 4:case 8:case 3:case 6:case 1:case 7:case 2:break;default:return u=e,2}h=ra(b,d,f,1,e)|0;m=d=a[e>>2]|0;if(0!=(h|0)|0==(d|0))return a[c>>2]=0,u=e,h|0;switch(N[g>>1]|0){case 1:case 7:case 2:a[c>>2]=m;u=e;break;case 6:h=a[f>>2]|0;a:do if(h){k=d;for(l=0;!(-1>=(t[k>>0]|0));)if(l=l+1|0,l>>>0>=h>>>0)break a;else k=
k+1|0;ja(d);u=e;return 4}while(0);a[c>>2]=m;u=e;break;default:m=a[f>>2]|0;h=eb(m)|0;if(!h)return ja(d),u=e,7;a:do switch(N[g>>1]|0){case 3:if(m)for(k=b+12|0,l=d,n=h,p=0;;){a[k>>2]&128&&ac(l);q=w[l>>1]|0;if(256<=(q&65535)){k=50;break a}t[n>>0]=q;p=p+1|0;if(p>>>0>=(a[f>>2]|0)>>>0){k=51;break}else l=l+2|0,n=n+1|0}else k=51;break;case 8:if(m)for(n=b+12|0,l=d,p=h,k=0;;){a[n>>2]&128&&ac(l);q=w[l>>1]|0;if(256<=(q&65535)){k=50;break a}t[p>>0]=q;k=k+1|0;if(k>>>0>=(a[f>>2]|0)>>>0){k=51;break}else l=l+2|0,p=
p+1|0}else k=51;break;case 4:if(m)for(p=b+12|0,l=d,k=h,n=0;;){a[p>>2]&128&&pb(l);q=a[l>>2]|0;if(256<=q>>>0){k=50;break a}t[k>>0]=q;n=n+1|0;if(n>>>0>=(a[f>>2]|0)>>>0){k=51;break}else l=l+4|0,k=k+1|0}else k=51;break;case 9:if(m)for(k=b+12|0,l=d,n=h,p=0;;){a[k>>2]&128&&pb(l);q=a[l>>2]|0;if(256<=q>>>0){k=50;break a}t[n>>0]=q;p=p+1|0;if(p>>>0>=(a[f>>2]|0)>>>0){k=51;break}else l=l+4|0,n=n+1|0}else k=51;break;case 16:if(m)for(n=b+12|0,l=d,p=h,k=0;;){a[n>>2]&128&&kc(l);q=l;y=a[q>>2]|0;B=a[q+4>>2]|0;if(!(0>
B>>>0|0==(B|0)&256>y>>>0)){k=50;break a}t[p>>0]=y;k=k+1|0;if(k>>>0>=(a[f>>2]|0)>>>0){k=51;break}else l=l+8|0,p=p+1|0}else k=51;break;case 17:if(m)for(p=b+12|0,l=d,k=h,n=0;;){a[p>>2]&128&&kc(l);y=l;B=a[y>>2]|0;q=a[y+4>>2]|0;if(!(0>q>>>0|0==(q|0)&256>B>>>0)){k=50;break a}t[k>>0]=B;n=n+1|0;if(n>>>0>=(a[f>>2]|0)>>>0){k=51;break}else l=l+8|0,k=k+1|0}else k=51;break;default:k=51}while(0);if(50==(k|0))return ja(a[e>>2]|0),ja(h),u=e,4;51==(k|0)&&(ja(a[e>>2]|0),a[c>>2]=h,u=e)}return 0}function ab(b,d,c){b|=
0;d|=0;c|=0;var e,f,g,h,m,k,l,n,p,q,y,B;e=u;u=u+16|0;f=e+4|0;g=e;h=d+2|0;switch(N[h>>1]|0){case 17:case 16:case 9:case 4:case 8:case 3:case 6:case 1:break;default:return u=e,2}m=ra(b,d,f,4,g)|0;g=d=a[g>>2]|0;if(0!=(m|0)|0==(d|0))return a[c>>2]=0,u=e,m|0;switch(N[h>>1]|0){case 4:a[c>>2]=d;if(!(a[b+12>>2]&128)){u=e;break}Id(d,a[f>>2]|0);u=e;break;case 9:m=a[f>>2]|0;a:do if(m){k=b+12|0;l=d;for(n=0;;){a[k>>2]&128&&pb(l);if(p=a[l>>2]>>31&4){q=p;break}n=n+1|0;if(n>>>0>=m>>>0)break a;else l=l+4|0}ja(d);
b=q;u=e;return b|0}while(0);a[c>>2]=g;u=e;break;default:g=a[f>>2]|0;q=eb(g<<2)|0;if(!q)return ja(d),u=e,7;a:do switch(N[h>>1]|0){case 1:if(g)for(m=d,l=q,n=0;;)if(a[l>>2]=x[m>>0],n=n+1|0,n>>>0>=(a[f>>2]|0)>>>0){m=47;break}else m=m+1|0,l=l+4|0;else m=47;break;case 6:if(g)for(l=d,m=q,n=0;;){k=t[l>>0]|0;if(-1>=k<<24>>24){m=46;break a}a[m>>2]=k<<24>>24;n=n+1|0;if(n>>>0>=(a[f>>2]|0)>>>0){m=47;break}else l=l+1|0,m=m+4|0}else m=47;break;case 3:if(g)for(m=b+12|0,l=d,n=q,k=0;;)if(a[m>>2]&128&&ac(l),a[n>>2]=
N[l>>1],k=k+1|0,k>>>0>=(a[f>>2]|0)>>>0){m=47;break}else l=l+2|0,n=n+4|0;else m=47;break;case 8:if(g)for(n=b+12|0,l=d,k=q,m=0;;){a[n>>2]&128&&ac(l);p=w[l>>1]|0;if(-1>=p<<16>>16){m=46;break a}a[k>>2]=p<<16>>16;m=m+1|0;if(m>>>0>=(a[f>>2]|0)>>>0){m=47;break}else l=l+2|0,k=k+4|0}else m=47;break;case 16:if(g)for(k=b+12|0,l=d,m=q,n=0;;){a[k>>2]&128&&kc(l);p=l;y=a[p>>2]|0;B=a[p+4>>2]|0;if(!(1>B>>>0|1==(B|0)&0>y>>>0)){m=46;break a}a[m>>2]=y;n=n+1|0;if(n>>>0>=(a[f>>2]|0)>>>0){m=47;break}else l=l+8|0,m=m+4|
0}else m=47;break;case 17:if(g)for(m=b+12|0,l=d,n=q,k=0;;){a[m>>2]&128&&kc(l);y=l;B=a[y>>2]|0;p=a[y+4>>2]|0;if(!(1>p>>>0|1==(p|0)&0>B>>>0)){m=46;break a}a[n>>2]=B;k=k+1|0;if(k>>>0>=(a[f>>2]|0)>>>0){m=47;break}else l=l+8|0,n=n+4|0}else m=47;break;default:m=47}while(0);if(46==(m|0))return ja(d),ja(q),u=e,4;47==(m|0)&&(ja(d),a[c>>2]=q,u=e)}return 0}function fb(b,d,c){b|=0;d|=0;c|=0;var e,f,g,h,m,k,l,n,p,q,y;e=u;u=u+16|0;f=e+4|0;g=e;h=d+2|0;switch(N[h>>1]|0){case 12:case 11:case 10:case 5:case 17:case 16:case 9:case 4:case 8:case 3:case 6:case 1:break;
default:return u=e,2}m=ra(b,d,f,4,g)|0;g=d=a[g>>2]|0;if(0!=(m|0)|0==(d|0))return a[c>>2]=0,u=e,m|0;if(11==(w[h>>1]|0))return a[b+12>>2]&128&&Id(d,a[f>>2]|0),a[c>>2]=g,u=e,0;g=a[f>>2]|0;f=eb(g<<2)|0;if(!f)return ja(d),u=e,7;do switch(N[h>>1]|0){case 1:if(g)for(m=d,k=f,l=0;!(W[k>>2]=+(x[m>>0]|0),l=l+1|0,l>>>0>=g>>>0);)m=m+1|0,k=k+4|0;break;case 6:if(g)for(k=d,m=f,l=0;!(W[m>>2]=+(t[k>>0]|0),l=l+1|0,l>>>0>=g>>>0);)k=k+1|0,m=m+4|0;break;case 3:if(g)for(m=b+12|0,k=d,l=f,n=0;!(a[m>>2]&128&&ac(k),W[l>>2]=
+(N[k>>1]|0),n=n+1|0,n>>>0>=g>>>0);)k=k+2|0,l=l+4|0;break;case 8:if(g)for(l=b+12|0,k=d,n=f,m=0;!(a[l>>2]&128&&ac(k),W[n>>2]=+(w[k>>1]|0),m=m+1|0,m>>>0>=g>>>0);)k=k+2|0,n=n+4|0;break;case 4:if(g)for(n=b+12|0,k=d,m=f,l=0;!(a[n>>2]&128&&pb(k),W[m>>2]=+((a[k>>2]|0)>>>0),l=l+1|0,l>>>0>=g>>>0);)k=k+4|0,m=m+4|0;break;case 9:if(g)for(m=b+12|0,k=d,l=f,n=0;!(a[m>>2]&128&&pb(k),W[l>>2]=+(a[k>>2]|0),n=n+1|0,n>>>0>=g>>>0);)k=k+4|0,l=l+4|0;break;case 16:if(g)for(l=b+12|0,k=d,n=f,m=0;!(a[l>>2]&128&&kc(k),p=k,W[n>>
2]=+((a[p>>2]|0)>>>0)+4294967296*+((a[p+4>>2]|0)>>>0),m=m+1|0,m>>>0>=g>>>0);)k=k+8|0,n=n+4|0;break;case 17:if(g)for(n=b+12|0,k=d,m=f,l=0;!(a[n>>2]&128&&kc(k),p=k,W[m>>2]=+((a[p>>2]|0)>>>0)+4294967296*+(a[p+4>>2]|0),l=l+1|0,l>>>0>=g>>>0);)k=k+8|0,m=m+4|0;break;case 5:if(g)for(m=b+12|0,k=d,l=f,n=0;!(p=a[m>>2]|0,p&128?(pb(k),q=a[m>>2]|0):q=p,p=k+4|0,y=a[k>>2]|0,q&128&&pb(p),y=(q=a[p>>2]|0)?+(y>>>0)/+(q>>>0):0,W[l>>2]=y,n=n+1|0,n>>>0>=g>>>0);)k=k+8|0,l=l+4|0;break;case 10:if(g)for(l=b+12|0,k=d,n=f,m=
0;!(q=a[l>>2]|0,q&128?(pb(k),p=a[l>>2]|0):p=q,q=a[k>>2]|0,y=k+4|0,p&128&&pb(y),y=(p=a[y>>2]|0)?+(q|0)/+(p>>>0):0,W[n>>2]=y,m=m+1|0,m>>>0>=g>>>0);)k=k+8|0,n=n+4|0;break;case 12:if(a[b+12>>2]&128&&Ae(d,g),g)for(n=d,k=f,m=0;!(W[k>>2]=+Hb[n>>3],m=m+1|0,m>>>0>=g>>>0);)n=n+8|0,k=k+4|0}while(0);ja(d);a[c>>2]=f;u=e;return 0}function Lb(b,d,c){b|=0;d|=0;c|=0;var e,f,g,h,m,k,l;e=u;u=u+16|0;f=e+4|0;g=e;h=d+2|0;switch(N[h>>1]|0){case 18:case 13:case 16:case 4:break;default:return u=e,2}m=ra(b,d,f,8,g)|0;d=a[g>>
2]|0;if(0!=(m|0)|0==(d|0))return a[c>>2]=0,u=e,m|0;switch(N[h>>1]|0){case 18:case 16:a[c>>2]=d;if(!(a[b+12>>2]&128))return u=e,0;Ae(d,a[f>>2]|0);u=e;return 0}m=a[f>>2]|0;f=eb(m<<3)|0;if(!f)return ja(d),u=e,7;switch(N[h>>1]|0){case 13:case 4:if(m)for(h=b+12|0,b=d,g=f,k=0;!(a[h>>2]&128&&pb(b),l=g,a[l>>2]=a[b>>2],a[l+4>>2]=0,k=k+1|0,k>>>0>=m>>>0);)b=b+4|0,g=g+8|0}ja(d);a[c>>2]=f;u=e;return 0}function Y(b,d,c,e){b|=0;d|=0;c|=0;var f;f=u;u=u+16|0;a[f>>2]=e|0;if(e=a[1934]|0)td[e&127](d,c,f);if(e=a[1910]|
0)Ud[e&31](b,d,c,f);u=f}function Sb(b){b|=0;var d,c,e,f,g,h,m,k,l;d=u;u=u+48|0;c=d+24|0;e=d+16|0;f=d+8|0;g=d+32|0;h=d+28|0;m=b+8|0;if(!(a[m>>2]|0))return u=d,1;k=b+12|0;l=a[k>>2]|0;if(l&64)if((0==(l&4096|0)||(a[k>>2]=l&-4097,0!=(da[a[b+528>>2]&63](b)|0)))&&Lc(b)|0)l=a[k>>2]|0;else return u=d,0;if(2097152==(l&2097160|0)&&2==(a[m>>2]|0))if(a[g>>2]=0,a[h>>2]=0,cd(b)|0){if(a[d>>2]=g,Pd(b,324,d)|0&&(a[f>>2]=h,Pd(b,325,f)|0&&(l=b+168|0,Ni(b,324,16,a[l>>2]|0,a[g>>2]|0)|0&&Ni(b,325,16,a[l>>2]|0,a[h>>2]|0)|
0)))return a[k>>2]&=-2097217,u=d,1}else if(a[e>>2]=g,Pd(b,273,e)|0&&(a[c>>2]=h,Pd(b,279,c)|0&&(l=b+168|0,Ni(b,273,16,a[l>>2]|0,a[g>>2]|0)|0&&Ni(b,279,16,a[l>>2]|0,a[h>>2]|0)|0)))return a[k>>2]&=-2097217,u=d,1;if(0!=(a[k>>2]&2097160|0)&&0==(Fj(b)|0))return u=d,0;u=d;return 1}function jc(b,d){b|=0;d|=0;var c,e,f,g,h,m,k,l,n,p,q,y,B,H,ka,z,Q,C,Ra,V;c=u;u=u+160|0;e=c+136|0;f=c+120|0;g=c+112|0;h=c+104|0;m=c+88|0;k=c+80|0;l=c+72|0;n=c+64|0;p=c+56|0;q=c+48|0;y=c+24|0;B=c+16|0;H=c+8|0;ka=c;z=c+146|0;Q=c+
144|0;if(!(a[b+500>>2]|0)){C=d;Ra=135926;e=C+54|0;do t[C>>0]=t[Ra>>0]|0,C=C+1|0,Ra=Ra+1|0;while((C|0)<(e|0));u=c;return 0}Ra=b+84|0;C=N[Ra>>1]|0;switch(C|0){case 16:case 8:case 4:case 2:case 1:break;default:return a[ka>>2]=C,ad(d,135980,ka)|0,u=c,0}ka=b+98|0;C=(N[ka>>1]|0)-(N[b+156>>1]|0)|0;a[H>>2]=z;a:do if(Pd(b,262,H)|0)V=w[z>>1]|0;else switch(C|0){case 1:V=w[z>>1]=1;break a;case 3:V=w[z>>1]=2;break a;default:return a[B>>2]=130805,ad(d,136029,B)|0,C=0,u=c,C|0}while(0);z=V&65535;a:do{if(5>(z|0)){switch(z|
0){case 3:case 1:case 0:break;case 2:if(3<=(C|0))return C=1,u=c,C|0;a[q>>2]=136187;a[q+4>>2]=C;ad(d,136144,q)|0;C=0;u=c;return C|0;default:break a}if(1!=(w[b+126>>1]|0))return C=1,u=c,C|0;V=w[ka>>1]|0;if(1==V<<16>>16)return C=1,u=c,C|0;B=w[Ra>>1]|0;if(8<=(B&65535))return C=1,u=c,C|0;a[y>>2]=130805;a[y+4>>2]=z;a[y+8>>2]=136130;a[y+12>>2]=V&65535;a[y+16>>2]=B&65535;ad(d,136051,y)|0}else{if(8>(z|0)){switch(z|0){case 5:break;case 6:return C=1,u=c,C|0;default:break a}a[p>>2]=Q;ne(b,332,p)|0;B=w[Q>>1]|
0;if(1!=B<<16>>16)return a[n>>2]=136251,a[n+4>>2]=B&65535,ad(d,136202,n)|0,C=0,u=c,C|0;B=w[ka>>1]|0;if(4<=(B&65535))return C=1,u=c,C|0;a[l>>2]=136130;a[l+4>>2]=B&65535;ad(d,136202,l)|0;C=0;u=c;return C|0}if(32844>(z|0)){switch(z|0){case 8:break;default:break a}B=w[ka>>1]|0;V=w[Ra>>1]|0;if(3==B<<16>>16&8==V<<16>>16)return C=1,u=c,C|0;a[f>>2]=136130;a[f+4>>2]=B&65535;a[f+8>>2]=136499;a[f+12>>2]=V&65535;ad(d,136450,f)|0;C=0;u=c;return C|0}switch(z|0){case 32844:if(-30860==(w[b+88>>1]|0))return C=1,u=
c,C|0;a[k>>2]=136291;a[k+4>>2]=34676;ad(d,136258,k)|0;C=0;u=c;return C|0;case 32845:break;default:break a}if(-30860!=(w[b+88>>1]&-2)<<16>>16)return a[m>>2]=136291,a[m+4>>2]=34676,a[m+8>>2]=34677,ad(d,136303,m)|0,C=0,u=c,C|0;V=w[b+126>>1]|0;if(1!=V<<16>>16)return a[h>>2]=136391,a[h+4>>2]=V&65535,ad(d,136344,h)|0,C=0,u=c,C|0;V=w[ka>>1]|0;if(3==V<<16>>16)return C=1,u=c,C|0;a[g>>2]=136130;a[g+4>>2]=V&65535;ad(d,136411,g)|0}C=0;u=c;return C|0}while(0);a[e>>2]=130805;a[e+4>>2]=z;ad(d,136411,e)|0;u=c;return 0}
function lc(b,d,c,e){b|=0;d|=0;e|=0;var f,g,h,m,k,l,n,p,q,y,B,H,ka,z,Q,C,Ra,V,Ed,r,x,G,L,K,v,fd,O,M,T,X,P,Oa,A,D,ba,F,Te,R,ga,Ha,ma,bc,ha,U,S,pc,Nb,da,fa,oa,sa,Kc,ua,Ia,Da,na,Na,hf=0,Ca=0,Ga,Ea,La,ca=0,aa,dh=0,ya,xb,Aa,ra=0,jb,mc,pa,Ta,Ya,Sa,mb=0,Db,cc,Za,ia,qa,Ja,ea,wa=0,Ma,xa,$a,la;f=u;u=u+384|0;g=f+344|0;h=f+336|0;m=f+328|0;k=f+320|0;l=f+312|0;n=f+296|0;p=f+288|0;q=f+280|0;y=f+272|0;B=f+264|0;H=f+256|0;ka=f+248|0;z=f+240|0;Q=f+224|0;C=f+216|0;Ra=f+208|0;V=f+200|0;Ed=f+192|0;r=f+176|0;x=f+168|0;
G=f+160|0;L=f+152|0;K=f+144|0;v=f+136|0;fd=f+128|0;O=f+120|0;M=f+96|0;T=f+80|0;X=f+72|0;P=f+64|0;Oa=f+56|0;A=f+48|0;D=f+40|0;ba=f+32|0;F=f+24|0;Te=f+16|0;R=f+8|0;ga=f;Ha=f+364|0;ma=f+374|0;bc=f+372|0;ha=f+370|0;U=f+360|0;S=f+356|0;pc=f+352|0;Nb=f+368|0;a[b+84>>2]=0;a[b+88>>2]=0;da=b+36|0;a[da>>2]=0;fa=b+40|0;a[fa>>2]=0;oa=b+44|0;a[oa>>2]=0;w[b+30>>1]=4;a[b>>2]=d;a[b+4>>2]=c|0;c=b+24|0;a[ga>>2]=c;ne(d,258,ga)|0;ga=N[c>>1]|0;a:do switch(ga|0){case 16:case 8:case 4:case 2:case 1:sa=b+12|0;a[sa>>2]=0;
Kc=b+26|0;a[Te>>2]=Kc;ne(d,277,Te)|0;a[F>>2]=ma;a[F+4>>2]=Ha;ne(d,338,F)|0;b:do if(w[ma>>1]|0){ua=N[a[Ha>>2]>>1]|0;switch(ua|0){case 0:break;case 2:case 1:a[sa>>2]=ua;break b;default:break b}3<(N[Kc>>1]|0)&&(a[sa>>2]=1)}while(0);ua=b+32|0;a[ba>>2]=ua;Pd(d,262,ba)|0||(w[ua>>1]=0);Ia=w[ma>>1]|0;Da=w[Kc>>1]|0;Ia<<16>>16?(na=Da,Na=Ia):4==Da<<16>>16?2==(w[ua>>1]|0)?(a[sa>>2]=1,w[ma>>1]=1,na=4,Na=1):(na=4,Na=0):(na=Da,Na=0);Ia=(na&65535)-(Na&65535)|0;a[D>>2]=ha;ne(d,259,D)|0;a[A>>2]=bc;ne(d,284,A)|0;a[Oa>>
2]=ua;b:do if(Pd(d,262,Oa)|0)Ca=w[ua>>1]|0;else switch(Ia|0){case 1:a[P>>2]=Oa;Pd(d,259,P)|0;Da=w[Oa>>1]|0;c:do if(3>Da<<16>>16)if(2>Da<<16>>16)switch(Da<<16>>16){case -32765:hf=18;break c;default:hf=19;break c}else switch(Da<<16>>16){case 2:hf=18;break c;default:hf=19;break c}else switch(Da<<16>>16){case 4:case 3:hf=18;break;default:hf=19}while(0);if(18==(hf|0)){Ca=w[ua>>1]=0;break b}else if(19==(hf|0)){Ca=w[ua>>1]=1;break b}break;case 3:Ca=w[ua>>1]=2;break b;default:a[X>>2]=130805;ad(e,136029,X)|
0;break a}while(0);Da=Ca&65535;b:do if(5>(Da|0)){switch(Da|0){case 3:hf=23;break;case 1:case 0:break;case 2:if(3<=(Ia|0))break b;a[fd>>2]=136187;a[fd+4>>2]=Ia;ad(e,136144,fd)|0;break a;default:hf=49;break b}do if(23==(hf|0)){a[T>>2]=U;a[T+4>>2]=S;a[T+8>>2]=pc;if(!(Pd(d,320,T)|0)){Ga=e;Ea=136511;La=Ga+32|0;do t[Ga>>0]=t[Ea>>0]|0,Ga=Ga+1|0,Ea=Ea+1|0;while((Ga|0)<(La|0));break a}ca=2<<N[c>>1];aa=eb(ca)|0;a[da>>2]=aa;aa=eb(ca)|0;a[fa>>2]=aa;aa=eb(ca)|0;a[oa>>2]=aa;dh=a[da>>2]|0;if(0==(dh|0)||0==(aa|0)|
0==(a[fa>>2]|0)){Ga=e;Ea=136543;La=Ga+32|0;do t[Ga>>0]=t[Ea>>0]|0,Ga=Ga+1|0,Ea=Ea+1|0;while((Ga|0)<(La|0));break a}else Ab(dh,a[U>>2]|0,ca),Ab(a[fa>>2]|0,a[S>>2]|0,ca),Ab(a[oa>>2]|0,a[pc>>2]|0,ca)}while(0);if(1==(w[bc>>1]|0)&&(ca=w[Kc>>1]|0,dh=ca&65535,1!=ca<<16>>16)&&(ca=w[c>>1]|0,8>(ca&65535))){aa=N[ua>>1]|0;a[M>>2]=130805;a[M+4>>2]=aa;a[M+8>>2]=136130;a[M+12>>2]=dh;a[M+16>>2]=ca&65535;ad(e,136051,M)|0;break a}}else{if(8>(Da|0)){switch(Da|0){case 6:if(!(1==(w[bc>>1]|0)&7==(w[ha>>1]|0)))break b;
a[O>>2]=1;lb(d,65538,O)|0;w[ua>>1]=2;break b;case 5:break;default:hf=49;break b}a[v>>2]=Nb;ne(d,332,v)|0;ca=w[Nb>>1]|0;if(1!=ca<<16>>16){a[K>>2]=136251;a[K+4>>2]=ca&65535;ad(e,136202,K)|0;break a}ca=w[Kc>>1]|0;if(4<=(ca&65535))break;a[L>>2]=136130;a[L+4>>2]=ca&65535;ad(e,136202,L)|0;break a}if(32844>(Da|0))switch(Da|0){case 8:break b;default:hf=49;break b}switch(Da|0){case 32844:if(-30860==(w[ha>>1]|0)){a[x>>2]=3;lb(d,65560,x)|0;w[ua>>1]=1;w[c>>1]=8;break b}else{a[G>>2]=136291;a[G+4>>2]=34676;ad(e,
136258,G)|0;break a}case 32845:break;default:hf=49;break b}if(-30860!=(w[ha>>1]&-2)<<16>>16){a[r>>2]=136291;a[r+4>>2]=34676;a[r+8>>2]=34677;ad(e,136303,r)|0;break a}ca=w[bc>>1]|0;if(1==ca<<16>>16)a[V>>2]=3,lb(d,65560,V)|0,w[ua>>1]=2,w[c>>1]=8;else return a[Ed>>2]=136391,a[Ed+4>>2]=ca&65535,ad(e,136344,Ed)|0,ya=0,u=f,ya|0}while(0);if(49==(hf|0)){a[Ra>>2]=130805;a[Ra+4>>2]=Da;ad(e,136411,Ra)|0;break a}Ia=b+56|0;ca=b+72|0;dh=b+76|0;aa=b+80|0;a[Ia>>2]=0;a[Ia+4>>2]=0;a[Ia+8>>2]=0;a[Ia+12>>2]=0;a[Ia+16>>
2]=0;a[Ia+20>>2]=0;a[Ia+24>>2]=0;a[C>>2]=b+16;Pd(d,256,C)|0;a[Q>>2]=b+20;Pd(d,257,Q)|0;a[z>>2]=b+28;ne(d,274,z)|0;if(2==(w[bc>>1]|0)){if(xb=2>(N[Kc>>1]|0),a[b+8>>2]=xb&1,!xb){xb=0!=(cd(a[b>>2]|0)|0);Aa=b+48|0;a[Aa>>2]=xb?3:4;xb=b+52|0;a[xb>>2]=0;b:do switch(N[ua>>1]|0){case 2:case 1:case 0:switch(N[c>>1]|0){case 8:switch(a[sa>>2]|0){case 1:a[xb>>2]=1;break b;case 2:a[dh>>2]|0&&Z(136575,136593,2728,136608);ra=eb(65536)|0;if(a[dh>>2]=ra)jb=0,mc=ra;else{Y(a[(a[b>>2]|0)+628>>2]|0,136608,150005,l);break b}for(;;){ra=
0;for(pa=mc;Ta=((((E(ra,jb)|0)+127|0)>>>0)/255|0)&255,t[pa>>0]=Ta,ra=ra+1|0,256!=(ra|0);)pa=pa+1|0;jb=jb+1|0;if(256==(jb|0))break;else mc=mc+256|0}a[xb>>2]=2;break b;default:a[xb>>2]=3;break b}case 16:break;default:break b}pa=a[sa>>2]|0;if(1==(pa|0)){a[aa>>2]|0&&Z(136623,136593,2750,136648);ra=eb(65536)|0;if(a[aa>>2]=ra)Ya=ra,Sa=0;else{Y(a[(a[b>>2]|0)+628>>2]|0,136648,150005,k);break b}for(;t[Ya>>0]=((Sa+128|0)>>>0)/257|0,Sa=Sa+1|0,65536!=(Sa|0);)Ya=Ya+1|0;a[xb>>2]=4;break b}ra=2==(pa|0);a[aa>>2]|
0&&Z(136623,136593,2750,136648);Ta=eb(65536)|0;if(a[aa>>2]=Ta)for(Db=Ta,Ta=0;;)if(t[Db>>0]=((Ta+128|0)>>>0)/257|0,Ta=Ta+1|0,65536==(Ta|0)){mb=1;break}else Db=Db+1|0;else Y(a[(a[b>>2]|0)+628>>2]|0,136648,150005,m),mb=0;if(!ra){if(!mb)break b;a[xb>>2]=6;break b}if(mb){a[dh>>2]|0&&Z(136575,136593,2728,136608);Db=eb(65536)|0;if(a[dh>>2]=Db)cc=0,Za=Db;else{Y(a[(a[b>>2]|0)+628>>2]|0,136608,150005,h);break b}for(;;){Db=0;for(Ta=Za;pa=((((E(Db,cc)|0)+127|0)>>>0)/255|0)&255,t[Ta>>0]=pa,Db=Db+1|0,256!=(Db|
0);)Ta=Ta+1|0;cc=cc+1|0;if(256==(cc|0))break;else Za=Za+256|0}a[xb>>2]=5}break;case 5:8==(w[c>>1]|0)&&4==(w[Kc>>1]|0)&&(a[sa>>2]=1,a[xb>>2]=7);break;case 6:8==(w[c>>1]|0)&&3==(w[Kc>>1]|0)&&0!=(Wc(b)|0)&&(ra=a[b>>2]|0,a[g>>2]=z,a[g+4>>2]=Q,ne(ra,530,g)|0,17==(N[z>>1]<<4|N[Q>>1]|0))&&(a[xb>>2]=8)}while(0);if(a[Aa>>2]|0&&a[xb>>2]|0)return ya=1,u=f,ya|0;Ga=e;Ea=136793;La=Ga+28|0;do t[Ga>>0]=t[Ea>>0]|0,Ga=Ga+1|0,Ea=Ea+1|0;while((Ga|0)<(La|0));break a}}else a[b+8>>2]=1;xb=0!=(cd(a[b>>2]|0)|0);Aa=b+48|0;
a[Aa>>2]=xb?1:2;xb=b+52|0;a[xb>>2]=0;b:do switch(N[ua>>1]|0){case 2:switch(N[c>>1]|0){case 8:switch(a[sa>>2]|0){case 1:a[xb>>2]=1;break b;case 2:a[dh>>2]|0&&Z(136575,136593,2728,136608);Da=eb(65536)|0;if(a[dh>>2]=Da)ia=0,qa=Da;else{Y(a[(a[b>>2]|0)+628>>2]|0,136608,150005,ka);break b}for(;;){Da=0;for(ra=qa;Ta=((((E(Da,ia)|0)+127|0)>>>0)/255|0)&255,t[ra>>0]=Ta,Da=Da+1|0,256!=(Da|0);)ra=ra+1|0;ia=ia+1|0;if(256==(ia|0))break;else qa=qa+256|0}a[xb>>2]=2;break b;default:a[xb>>2]=3;break b}case 16:break;
default:break b}ra=a[sa>>2]|0;if(1==(ra|0)){a[aa>>2]|0&&Z(136623,136593,2750,136648);Da=eb(65536)|0;if(a[aa>>2]=Da)Ja=Da,ea=0;else{Y(a[(a[b>>2]|0)+628>>2]|0,136648,150005,H);break b}for(;t[Ja>>0]=((ea+128|0)>>>0)/257|0,ea=ea+1|0,65536!=(ea|0);)Ja=Ja+1|0;a[xb>>2]=4;break b}Da=2==(ra|0);a[aa>>2]|0&&Z(136623,136593,2750,136648);Ta=eb(65536)|0;if(a[aa>>2]=Ta)for(Db=Ta,Ta=0;;)if(t[Db>>0]=((Ta+128|0)>>>0)/257|0,Ta=Ta+1|0,65536==(Ta|0)){wa=1;break}else Db=Db+1|0;else Y(a[(a[b>>2]|0)+628>>2]|0,136648,150005,
B),wa=0;if(!Da){if(!wa)break b;a[xb>>2]=6;break b}if(wa){a[dh>>2]|0&&Z(136575,136593,2728,136608);Db=eb(65536)|0;if(a[dh>>2]=Db)Ma=0,xa=Db;else{Y(a[(a[b>>2]|0)+628>>2]|0,136608,150005,y);break b}for(;;){Db=0;for(Ta=xa;ra=((((E(Db,Ma)|0)+127|0)>>>0)/255|0)&255,t[Ta>>0]=ra,Db=Db+1|0,256!=(Db|0);)Ta=Ta+1|0;Ma=Ma+1|0;if(256==(Ma|0))break;else xa=xa+256|0}a[xb>>2]=5}break;case 5:if(0!=(nc(b)|0)&&8==(w[c>>1]|0)){a[xb>>2]=a[Ia>>2]|0?8:7;break b}break;case 3:if(nc(b)|0)switch(N[c>>1]|0){case 8:a[xb>>2]=9;
break b;case 4:a[xb>>2]=10;break b;case 2:a[xb>>2]=11;break b;case 1:a[xb>>2]=12;break b;default:break b}break;case 1:case 0:if(nc(b)|0)switch(N[c>>1]|0){case 16:a[xb>>2]=13;break b;case 8:if(0!=(a[sa>>2]|0)&&2==(w[Kc>>1]|0)){a[xb>>2]=14;break b}a[xb>>2]=15;break b;case 4:a[xb>>2]=16;break b;case 2:a[xb>>2]=17;break b;case 1:a[xb>>2]=18;break b;default:break b}break;case 6:if(8==(w[c>>1]|0)&&3==(w[Kc>>1]|0)&&0!=(Wc(b)|0))switch(Da=a[b>>2]|0,a[q>>2]=C,a[q+4>>2]=Oa,ne(Da,530,q)|0,N[C>>1]<<4|N[Oa>>1]|
0){case 68:a[xb>>2]=19;break b;case 66:a[xb>>2]=20;break b;case 65:a[xb>>2]=21;break b;case 34:a[xb>>2]=22;break b;case 33:a[xb>>2]=23;break b;case 18:a[xb>>2]=24;break b;case 17:a[xb>>2]=25;break b;default:break b}break;case 8:if(0!=(nc(b)|0)&&8==(w[c>>1]|0)){if(0==(a[ca>>2]|0)&&(Da=eb(18124)|0,a[ca>>2]=Da,0==(Da|0)))Y(a[(a[b>>2]|0)+628>>2]|0,136670,136691,p),$a=0;else{Da=a[b>>2]|0;a[n>>2]=z;ne(Da,318,n)|0;W[Q+4>>2]=100;Da=a[z>>2]|0;Ta=Da+4|0;W[Q>>2]=+W[Da>>2]/+W[Ta>>2]*100;la=+W[Ta>>2];W[Q+8>>2]=
(1-+W[Da>>2]-la)/la*100;var Ba=a[ca>>2]|0,va=7644,za=Q,Ba=Ba|0,za=za|0,ta=void 0,nb=void 0,sc=void 0,gb=void 0,hb=void 0,ob=void 0,Bb=void 0,qb=void 0,kb=void 0,ib=void 0,Cb=void 0,fe=0,sb=void 0,Xa=void 0,Fa=void 0,Pa=0,Eb=void 0,vb=void 0,tb=void 0;a[Ba>>2]=1500;Ab(Ba+28|0,va|0,84);ta=1/+W[Ba+100>>2];va=Ba+64|0;nb=+W[va>>2];sc=Ba+88|0;gb=+W[sc>>2];hb=a[Ba>>2]|0;W[Ba+4>>2]=(nb-gb)/+(hb|0);if(0>(hb|0))ob=nb,Bb=gb,qb=hb;else{kb=Ba+76|0;ib=hb;for(hb=0;;)if(gb=+((a[kb>>2]|0)>>>0)*+Oi(+(+(hb|0)/+(ib|
0)),+ta),W[Ba+112+(hb<<2)>>2]=gb,Cb=a[Ba>>2]|0,(hb|0)<(Cb|0))ib=Cb,hb=hb+1|0;else{fe=Cb;break}ob=+W[va>>2];Bb=+W[sc>>2];qb=fe}ta=1/+W[Ba+104>>2];W[Ba+8>>2]=(ob-Bb)/+(qb|0);if(0>(qb|0))sb=ob,Xa=Bb,Fa=qb;else{fe=Ba+80|0;hb=qb;for(qb=0;;)if(Bb=+((a[fe>>2]|0)>>>0)*+Oi(+(+(qb|0)/+(hb|0)),+ta),W[Ba+6116+(qb<<2)>>2]=Bb,ib=a[Ba>>2]|0,(qb|0)<(ib|0))hb=ib,qb=qb+1|0;else{Pa=ib;break}sb=+W[va>>2];Xa=+W[sc>>2];Fa=Pa}ta=1/+W[Ba+108>>2];W[Ba+12>>2]=(sb-Xa)/+(Fa|0);if(!(0>(Fa|0)))for(Pa=Ba+84|0,sc=Fa,Fa=0;!(Xa=+((a[Pa>>
2]|0)>>>0)*+Oi(+(+(Fa|0)/+(sc|0)),+ta),W[Ba+12120+(Fa<<2)>>2]=Xa,sc=a[Ba>>2]|0,(Fa|0)>=(sc|0));)Fa=Fa+1|0;Eb=a[za>>2]|0;a[(Ba+16|0)>>2]=Eb;vb=a[(za+4|0)>>2]|0;a[(Ba+20|0)>>2]=vb;tb=a[(za+8|0)>>2]|0;a[(Ba+24|0)>>2]=tb;$a=26}a[xb>>2]=$a}}while(0);if(a[Aa>>2]|0&&a[xb>>2]|0)return ya=1,u=f,ya|0;Ga=e;Ea=136793;La=Ga+28|0;do t[Ga>>0]=t[Ea>>0]|0,Ga=Ga+1|0,Ea=Ea+1|0;while((Ga|0)<(La|0));break;default:a[R>>2]=ga,ad(e,135980,R)|0}while(0);ja(a[da>>2]|0);ja(a[fa>>2]|0);ja(a[oa>>2]|0);a[oa>>2]=0;a[fa>>2]=0;a[da>>
2]=0;u=f;return 0}function vc(b,d,c,e,f,g){b|=0;d|=0;c|=0;e|=0;f|=0;g|=0;var h,m,k,l,n;h=u;u=u+1136|0;m=h+16|0;k=h+8|0;l=h+112|0;n=h+20|0;Va(l|0,0,1024)|0;if(0!=(jc(b,l)|0)&&0!=(lc(n,b,g,l)|0)){w[n+30>>1]=f;f=a[n+20>>2]|0;g=e+((E(c-f|0,d)|0)<<2)|0;(c=a[n+48>>2]|0)?a[n+52>>2]|0?e=rb[c&63](n,g,d,f)|0:(e=a[n>>2]|0,b=a[e+628>>2]|0,Y(b,Bc(e)|0,136844,k),e=0):(e=a[n>>2]|0,b=a[e+628>>2]|0,Y(b,Bc(e)|0,136821,h),e=0);m=n|0;n=m+56|0;if(b=a[n>>2]|0)ja(b),a[n>>2]=0;n=m+60|0;if(b=a[n>>2]|0)ja(b),a[n>>2]=0;n=m+
64|0;if(b=a[n>>2]|0)ja(b),a[n>>2]=0;n=m+68|0;if(b=a[n>>2]|0)ja(b),a[n>>2]=0;n=m+72|0;if(b=a[n>>2]|0)ja(b),a[n>>2]=0;n=m+76|0;if(b=a[n>>2]|0)ja(b),a[n>>2]=0;n=m+80|0;if(b=a[n>>2]|0)ja(b),a[n>>2]=0;n=m+36|0;if(b=a[n>>2]|0)ja(b),b=m+40|0,ja(a[b>>2]|0),m=m+44|0,ja(a[m>>2]|0),a[m>>2]=0,a[b>>2]=0,a[n>>2]=0;u=h;return e|0}e=a[b+628>>2]|0;n=Bc(b)|0;a[m>>2]=l;Y(e,n,154321,m);u=h;return 0}function nc(b){b|=0;var d,c,e,f,g,h,m,k,l,n,p,q,y,B,H,ka;d=u;u=u+32|0;c=d+24|0;e=d+16|0;f=d+8|0;g=d;h=b+32|0;switch(N[h>>
1]|0){case 5:case 6:case 2:if(8==(w[b+24>>1]|0))return u=d,1;break;case 0:case 1:break;case 3:f=b+36|0;m=a[f>>2]|0;k=b+40|0;l=a[k>>2]|0;g=b+44|0;n=a[g>>2]|0;h=b+24|0;p=w[h>>1]|0;q=1<<(p&65535);y=n;B=l;H=q;for(ka=m;;){if(0>=(H|0)){y=36;break}if(255<(N[ka>>1]|0)){y=34;break}if(255<(N[B>>1]|0)){y=34;break}if(255<(N[y>>1]|0)){y=34;break}else y=y+2|0,B=B+2|0,H=H+-1|0,ka=ka+2|0}if(34==(y|0)){if(31==p<<16>>16)return u=d,1;p=q;do q=p,p=p+-1|0,ka=m+(p<<1)|0,w[ka>>1]=(N[ka>>1]|0)>>>8,ka=l+(p<<1)|0,w[ka>>1]=
(N[ka>>1]|0)>>>8,ka=n+(p<<1)|0,w[ka>>1]=(N[ka>>1]|0)>>>8;while(1<(q|0))}else 36==(y|0)&&(y=a[b>>2]|0,p=a[y+628>>2]|0,Wb(p,Bc(y)|0,137096,e));e=w[h>>1]|0;if(9<=(e&65535))return u=d,1;h=e&65535;e=a[f>>2]|0;f=a[k>>2]|0;k=a[g>>2]|0;g=eb(((8/(h>>>0)|0)<<10)+1024|0)|0;y=b+64|0;a[y>>2]=g;if(!g)return p=a[b>>2]|0,n=a[p+628>>2]|0,Y(n,Bc(p)|0,137120,c),u=d,0;c=g;p=0;for(n=g+1024|0;;){a[c+(p<<2)>>2]=n;switch(h|0){case 1:g=p>>>7&1;a[n>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;
g=p>>>6&1;a[n+4>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;g=p>>>5&1;a[n+8>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;g=p>>>4&1;a[n+12>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;g=p>>>3&1;a[n+16>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;g=p>>>2&1;a[n+20>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;g=p>>>1&1;a[n+24>>2]=N[e+(g<<1)>>1]&255|
N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;g=p&1;a[n+28>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;m=n+32|0;break;case 2:g=p>>>6&3;a[n>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;g=p>>>4&3;a[n+4>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;g=p>>>2&3;a[n+8>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;g=p&3;a[n+12>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+
(g<<1)>>1]<<16|-16777216;m=n+16|0;break;case 4:g=p>>>4&15;a[n>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;g=p&15;a[n+4>>2]=N[e+(g<<1)>>1]&255|N[f+(g<<1)>>1]<<8&65280|N[k+(g<<1)>>1]<<16|-16777216;m=n+8|0;break;case 8:a[n>>2]=N[e+(p<<1)>>1]&255|N[f+(p<<1)>>1]<<8&65280|N[k+(p<<1)>>1]<<16|-16777216;m=n+4|0;break;default:m=n}g=p+1|0;if(256==(g|0))break;c=a[y>>2]|0;p=g;n=m}u=d;return 1;default:return u=d,1}m=b+24|0;n=w[m>>1]|0;p=16==n<<16>>16?255:(1<<(n&65535))+-1|0;n=p+
1|0;y=eb(n)|0;c=b+56|0;a[c>>2]=y;if(!y)return k=a[b>>2]|0,f=a[k+628>>2]|0,Y(f,Bc(k)|0,137023,g),u=d,0;g=0>(p|0);if(!(w[h>>1]|0)){if(g?0:(t[y>>0]=-1,0!=(p|0))){k=1;do t[(a[c>>2]|0)+k>>0]=(255*(p-k|0)|0)/(p|0)|0,k=k+1|0;while((k|0)!=(n|0))}}else if(g?0:(t[y>>0]=0,0!=(p|0))){y=1;do t[(a[c>>2]|0)+y>>0]=(255*y|0)/(p|0)|0,y=y+1|0;while((y|0)!=(n|0))}n=w[m>>1]|0;if(17<=(n&65535)||2<=(N[h>>1]|0))return u=d,1;h=a[c>>2]|0;m=n&65535;y=8/(m>>>0)|0;p=eb(0==(y|0)?2048:(y<<10)+1024|0)|0;y=b+60|0;a[y>>2]=p;if(!p)return g=
a[b>>2]|0,b=a[g+628>>2]|0,Y(b,Bc(g)|0,137065,f),u=d,0;f=p+1024|0;a:do switch(n<<16>>16){case 1:for(g=p,b=0,k=f;;){a[g+(b<<2)>>2]=k;f=x[h+(b>>7)>>0]|0;a[k>>2]=f|f<<8|f<<16|-16777216;f=x[h+(b>>>6&1)>>0]|0;a[k+4>>2]=f|f<<8|f<<16|-16777216;f=x[h+(b>>>5&1)>>0]|0;a[k+8>>2]=f|f<<8|f<<16|-16777216;f=x[h+(b>>>4&1)>>0]|0;a[k+12>>2]=f|f<<8|f<<16|-16777216;f=x[h+(b>>>3&1)>>0]|0;a[k+16>>2]=f|f<<8|f<<16|-16777216;f=x[h+(b>>>2&1)>>0]|0;a[k+20>>2]=f|f<<8|f<<16|-16777216;f=x[h+(b>>>1&1)>>0]|0;a[k+24>>2]=f|f<<8|f<<
16|-16777216;f=x[h+(b&1)>>0]|0;a[k+28>>2]=f|f<<8|f<<16|-16777216;f=b+1|0;if(256==(f|0))break a;g=a[y>>2]|0;b=f;k=k+32|0}case 2:for(k=p,b=0,g=f;;){a[k+(b<<2)>>2]=g;f=x[h+(b>>6)>>0]|0;a[g>>2]=f|f<<8|f<<16|-16777216;f=x[h+(b>>>4&3)>>0]|0;a[g+4>>2]=f|f<<8|f<<16|-16777216;f=x[h+(b>>>2&3)>>0]|0;a[g+8>>2]=f|f<<8|f<<16|-16777216;f=x[h+(b&3)>>0]|0;a[g+12>>2]=f|f<<8|f<<16|-16777216;if(255==(b|0))break a;k=a[y>>2]|0;b=b+1|0;g=g+16|0}case 16:a[p>>2]=f;g=x[h>>0]|0;a[f>>2]=g|g<<8|g<<16|-16777216;g=1;b=f;do b=b+
4|0,a[(a[y>>2]|0)+(g<<2)>>2]=b,k=x[h+g>>0]|0,a[b>>2]=k|k<<8|k<<16|-16777216,g=g+1|0;while(256!=(g|0));break;default:for(g=p,b=0,k=f;;){a[g+(b<<2)>>2]=k;switch(m|0){case 8:case 16:f=x[h+b>>0]|0;a[k>>2]=f|f<<8|f<<16|-16777216;e=k+4|0;break;case 4:f=x[h+(b>>4)>>0]|0;a[k>>2]=f|f<<8|f<<16|-16777216;f=x[h+(b&15)>>0]|0;a[k+4>>2]=f|f<<8|f<<16|-16777216;e=k+8|0;break;default:e=k}f=b+1|0;if(256<=(f|0))break a;g=a[y>>2]|0;b=f;k=e}}while(0);ja(a[c>>2]|0);a[c>>2]=0;u=d;return 1}function Wc(b){b|=0;var d,c,e,f,
g,h,m,k=0;d=u;u=u+32|0;c=d+16|0;e=d+8|0;f=d;g=d+24|0;h=d+20|0;m=b+68|0;if(0==(a[m>>2]|0)&&(k=eb(6168)|0,a[m>>2]=k,0==(k|0)))return Y(a[(a[b>>2]|0)+628>>2]|0,136962,136982,f),u=d,0;f=a[b>>2]|0;a[e>>2]=g;ne(f,529,e)|0;e=a[b>>2]|0;a[c>>2]=h;ne(e,532,c)|0;b=a[m>>2]|0;g=a[g>>2]|0;var l=a[h>>2]|0;b|=0;g|=0;var l=l|0,n,p,q,y,B,H,ka;$c(b+24|0,0,256);h=b+280|0;a[b>>2]=h;c=0;do t[h+c>>0]=c,c=c+1|0;while(256!=(c|0));$c(h+256|0,255,512);a[b+4>>2]=h+768;a[b+8>>2]=h+1792;a[b+12>>2]=h+2816;a[b+16>>2]=h+3840;a[b+
20>>2]=h+4864;e=+W[g>>2];n=2-2*e;b=~~(65536*n+.5);f=+W[g+4>>2];c=0-~~(e*n/f*65536+.5)|0;n=+W[g+8>>2];e=2-2*n;g=~~(65536*e+.5);m=~~(n*e/f*65536+.5);f=+W[l+16>>2]+-128;k=~~f;e=+W[l+20>>2]+-128-f;f=0!=e?e:1;e=+W[l+8>>2]+-128;p=~~e;n=+W[l+12>>2]+-128-e;e=0!=n?n:1;n=+W[l>>2];q=~~n;l=+W[l+4>>2]-n;n=0!=l?l:1;l=0;for(y=-128;B=~~(127*+(y-k|0)/f),H=~~(127*+(y-p|0)/e),ka=(E(B,b)|0)+32768>>16,a[h+(l+192<<2)>>2]=ka,ka=(E(H,g)|0)+32768>>16,a[h+(l+448<<2)>>2]=ka,ka=E(B,c)|0,a[h+(l+704<<2)>>2]=ka,ka=32768-(E(H,m)|
0)|0,a[h+(l+960<<2)>>2]=ka,a[h+(l+1216<<2)>>2]=~~(255*+(y+128-q|0)/n),l=l+1|0,256!=(l|0);)y=y+1|0;u=d;return 1}function rd(b,d,c,e,f,g,h,m,k,l){b|=0;d|=0;c|=0;e|=0;f|=0;g|=0;h|=0;m|=0;k|=0;l|=0;var n,p,q,y,B,H,ka,z,Q,C,Ra,V,Ed,r,x,G,L,K,E,v=0,O,M,T,X=0,P=0;n=u;u=u+96|0;p=n+80|0;q=n+72|0;y=n+64|0;B=n+56|0;H=n+48|0;ka=n+40|0;z=n+32|0;Q=n+24|0;C=n+16|0;Ra=n+8|0;V=n;Ed=t[d>>0]|0;switch(Ed<<24>>24|0){case 114:r=43==(t[d+1>>0]|0)?2:0;break;case 97:case 119:r=119==Ed<<24>>24?578:66;break;default:return a[Ra>>
2]=d,Y(0,137231,137216,Ra),u=n,0}Ra=eb((bk(b)|0)+697|0)|0;if(!Ra)return a[C>>2]=b,Y(c,137231,137246,C),u=n,0;$c(Ra,0,696);C=Ra+696|0;a[Ra>>2]=C;C|=0;gj(C,b|0)|0;C|0;C=Ra+8|0;a[C>>2]=r&2;w[Ra+448>>1]=-1;Ed=Ra+456|0;a[Ed>>2]=0;a[Ed+4>>2]=0;a[Ra+452>>2]=-1;a[Ra+444>>2]=-1;Ed=Ra+628|0;a[Ed>>2]=c;if(!(0!=(e|0)&0!=(f|0)&0!=(g|0)&0!=(h|0)&0!=(m|0)))return Y(c,137231,137281,Q),u=n,0;Q=Ra+632|0;a[Q>>2]=e;e=Ra+636|0;a[e>>2]=f;f=Ra+640|0;a[f>>2]=g;a[Ra+644>>2]=h;a[Ra+648>>2]=m;m=Ra+620|0;a[m>>2]=0==(k|0)?7:
k;a[Ra+624>>2]=0==(l|0)?1:l;Ng(Ra);l=Ra+12|0;h=(k=0==(r|0))?2049:1;g=0==(r&576|0)?h|32768:h;a[l>>2]=g;h=t[d>>0]|0;a:do if(h<<24>>24){c=0==(r&64|0);if(k)k=h,K=h=L=G=x=g,E=d;else for(x=g,k=d;;){switch(h<<24>>24|0){case 98:c||(g=x|128,x=a[l>>2]=g);break;case 56:c||(g=x|524288,x=a[l>>2]=g);break;case 66:g=x&-4|1;x=a[l>>2]=g;break;case 76:g=x&-4|2;x=a[l>>2]=g;break;case 72:g=x&-4|2;x=a[l>>2]=g;break;case 104:g|=65536;x=a[l>>2]=g;break}k=k+1|0;h=t[k>>0]|0;if(!(h<<24>>24))break a}for(;;){do switch(k<<24>>
24|0){case 98:c?(v=K,O=h,M=L,T=G,g=x):(g=K|128,T=M=O=v=a[l>>2]=g);break;case 56:c?(v=K,O=h,M=L,T=G,g=x):(g=K|524288,T=M=O=v=a[l>>2]=g);break;case 66:g=K&-4|1;T=M=O=v=a[l>>2]=g;break;case 76:g=K&-4|2;T=M=O=v=a[l>>2]=g;break;case 72:g=K&-4|2;T=M=O=v=a[l>>2]=g;break;case 77:g=K|2048;T=M=O=v=a[l>>2]=g;break;case 109:g=h&-2049;T=M=O=v=a[l>>2]=g;break;case 67:g=L|32768;T=M=O=v=a[l>>2]=g;break;case 99:g=G&-32769;T=M=O=v=a[l>>2]=g;break;case 104:g=x|65536;T=M=O=v=a[l>>2]=g;break;default:v=K,O=h,M=L,T=G,g=
x}while(0);E=E+1|0;k=t[E>>0]|0;if(k<<24>>24)x=g,G=T,L=M,h=O,K=v;else break a}}while(0);a:do if(0==(r&512|0)&&(v=Ra+424|0,8==(Aa[a[Q>>2]&63](a[Ed>>2]|0,v,8)|0))){K=w[v>>1]|0;v=K&65535;switch(K<<16>>16){case 19789:a[l>>2]|=128;break;case 20549:case 18761:break;default:K=a[Ed>>2]|0;a[H>>2]=v;a[H+4>>2]=v;Y(K,b,137351,H);break a}K=Ra+426|0;a[l>>2]&128&&ac(K);v=w[K>>1]|0;K=v&65535;if(42!=(v&-2)<<16>>16)O=a[Ed>>2]|0,a[B>>2]=K,a[B+4>>2]=K,Y(O,b,137402,B);else{do if(42!=v<<16>>16){O=Ra+432|0;if(8!=(Aa[a[Q>>
2]&63](a[Ed>>2]|0,O,8)|0)){Y(a[Ed>>2]|0,b,137327,y);break a}K=Ra+428|0;a[l>>2]&128&&(ac(K),kc(O));O=w[K>>1]|0;K=O&65535;if(8!=O<<16>>16){O=a[Ed>>2]|0;a[q>>2]=K;a[q+4>>2]=K;Y(O,b,137448,q);break a}O=w[Ra+430>>1]|0;K=O&65535;if(O<<16>>16){O=a[Ed>>2]|0;a[p>>2]=K;a[p+4>>2]=K;Y(O,b,137498,p);break a}else w[Ra+440>>1]=16,O=a[l>>2]|524288,c=a[l>>2]=O}else O=a[l>>2]|0,O&128?(pb(Ra+428|0),c=a[l>>2]|0):c=O,w[Ra+440>>1]=8;while(0);v=c|512;a[l>>2]=v;O=Ra+588|0;a[O>>2]=0;a[O+4>>2]=0;a[O+8>>2]=0;a[O+12>>2]=0;a[O+
16>>2]=0;switch(t[d>>0]|0){case 114:break;case 97:if(Pi(Ra)|0)b=Ra;else break a;u=n;return b|0;default:break a}c&524288?(O=Ra+432|0,K=a[O+4>>2]|0,h=Ra+24|0,a[h>>2]=a[O>>2],a[h+4>>2]=K):(O=Ra+24|0,a[O>>2]=a[Ra+428>>2],a[O+4>>2]=0);c&2048?Aa[a[m>>2]&63](a[Ed>>2]|0,Ra+612|0,V)|0?(K=V,h=a[K>>2]|0,O=a[K+4>>2]|0,a[Ra+616>>2]=h,(h|0)==(h|0)&((0>(h|0))<<31>>31|0)==(O|0)?X=a[l>>2]|0:Z(137544,137569,449,137231)):(K=a[l>>2]&-2049,X=a[l>>2]=K):X=v;if(X&65536)return b=Ra,u=n,b|0;if(ck(Ra)|0)return a[Ra+608>>2]=
-1,a[l>>2]|=16,b=Ra,u=n,b|0}}else P=37;while(0);if(37==(P|0))if(a[C>>2]|0)if(X=a[l>>2]|0,V=X&128,m=Ra+424|0,w[m>>1]=0!=(V|0)?19789:18761,c=Ra+426|0,X&524288?(w[c>>1]=43,X=Ra+428|0,w[X>>1]=8,w[Ra+430>>1]=0,d=Ra+432|0,a[d>>2]=0,a[d+4>>2]=0,V&&(ac(c),ac(X)),X=Ra+440|0,w[X>>1]=16):(w[c>>1]=42,a[Ra+428>>2]=0,V&&ac(c),X=Ra+440|0,w[X>>1]=8),d=X,rb[a[f>>2]&63](a[Ed>>2]|0,0,0,0)|0,X=Aa[a[e>>2]&63](a[Ed>>2]|0,m,N[d>>1]|0)|0,(X|0)!=(N[d>>1]|0))Y(a[Ed>>2]|0,b,142082,ka);else{if(19789==(w[m>>1]|0)&&(a[l>>2]|=
128),Pi(Ra)|0)return m=Ra+16|0,a[m>>2]=0,a[m+4>>2]=0,a[Ra+32>>2]=0,w[Ra+36>>1]=0,w[Ra+38>>1]=0,u=n,Ra|0}else Y(a[Ed>>2]|0,b,137327,z);a[C>>2]=0;Ik(Ra);u=n;return 0}function Bc(b){return a[(b|0)>>2]|0}function cd(b){return(a[(b|0)+12>>2]|0)>>>10&1|0}function Vc(b,d,c,e){b|=0;d|=0;c|=0;e|=0;var f,g,h,m,k;f=u;u=u+32|0;g=f+16|0;if(1==(a[b+8>>2]|0))return Y(a[b+628>>2]|0,a[b>>2]|0,137580,f),u=f,-1;if(a[b+12>>2]&1024)return Y(a[b+628>>2]|0,a[b>>2]|0,137606,f+8|0),u=f,-1;h=a[b+168>>2]|0;if(h>>>0<=d>>>0)return m=
a[b+628>>2]|0,a[g>>2]=d,a[g+4>>2]=h,Y(m,137830,137851,g),u=f,-1;g=a[b+100>>2]|0;m=a[b+60>>2]|0;h=g>>>0>m>>>0?m:g;g=((m+-1+h|0)>>>0)/(h>>>0)|0;k=m-(E((d>>>0)%(g>>>0)|0,h)|0)|0;m=b|0;var l;l=u;u=u+16|0;h=Yd(m,(k>>>0>h>>>0?h:k)|0)|0;(h|0)==(h|0)&((0>(h|0))<<31>>31|0)==(U|0)?(u=l,h|=0):(Y(a[m+628>>2]|0,138858,139721,l),u=l,h=0);m=h|0;if(!m)return u=f,-1;k=-1!=(e|0)&(m|0)>(e|0)?e:m;if(!(Dd(b,d)|0)||1>(rb[a[b+540>>2]&63](b,c,k,((d>>>0)/(g>>>0)|0)&65535)|0))return u=f,-1;td[a[b+652>>2]&127](b,c,k);u=f;return k|
0}function Dd(b,d){b|=0;d|=0;var c,e,f,g,h,m,k,l,n,p,q,y=0,B;c=u;u=u+64|0;e=c+48|0;f=c+40|0;g=c+16|0;h=b+176|0;m=a[h>>2]|0;if(!m)return u=c,0;k=b+12|0;l=a[k>>2]|0;do if(!(l&131072)){n=m+(d<<3)|0;p=a[n>>2]|0;q=a[n+4>>2]|0;if(0>(q|0)|0==(q|0)&1>p>>>0)return n=a[b+628>>2]|0,y=c,a[y>>2]=p,a[y+4>>2]=q,a[c+8>>2]=d,Y(n,137884,137898,c),h=0,u=c,h|0;if(0!=(l&2048|0)&&0!=((N[b+94>>1]|256)&l|0)){0!=(l&512|0)&&(n=b+588|0,y=a[n>>2]|0,0!=(y|0))?(ja(y),a[n>>2]=0,a[b+592>>2]=0,y=a[k>>2]|0):y=l;n=y&-513;a[k>>2]=n;
y=a[b+616>>2]|0;l=(0>(y|0))<<31>>31;e=(a[b+172>>2]|0)+(d<<3)|0;f=a[e>>2]|0;m=a[e+4>>2]|0;e=Ic(y|0,l|0,p|0,q|0)|0;B=U;if(!(l>>>0<q>>>0|(l|0)==(q|0)&y>>>0<p>>>0|m>>>0>B>>>0|(m|0)==(B|0)&f>>>0>e>>>0)){a[b+592>>2]=p;a[b+588>>2]=(a[b+612>>2]|0)+f;a[b+596>>2]=0;a[b+600>>2]=p;a[k>>2]=n|8388608;break}n=a[b+628>>2]|0;e=Ic(y|0,l|0,f|0,m|0)|0;a[g>>2]=d;m=g+8|0;a[m>>2]=e;a[m+4>>2]=U;m=g+16|0;a[m>>2]=p;a[m+4>>2]=q;Y(n,137884,137939,g);a[b+452>>2]=-1;h=0;u=c;return h|0}if(!((p|0)==(p|0)&((0>(p|0))<<31>>31|0)==
(q|0)))return Y(a[b+628>>2]|0,137884,139721,f),h=0,u=c,h|0;if((p|0)>(a[b+592>>2]|0)){a[b+452>>2]=-1;if(!(l&512))return q=a[b+628>>2]|0,a[e>>2]=d,Y(q,137884,137994,e),h=0,u=c,h|0;if(ld(b,0,p)|0)q=a[k>>2]|0;else return h=0,u=c,h|0}else q=l;if(0!=(q&8388608|0)&&(a[b+452>>2]=-1,0==(ld(b,0,p)|0)))return h=0,u=c,h|0;q=b+588|0;if((me(b,d,a[q>>2]|0,p,137884)|0)!=(p|0))return h=0,u=c,h|0;a[b+596>>2]=0;a[b+600>>2]=p;(N[b+94>>1]|256)&a[k>>2]||ye(a[q>>2]|0,p)}while(0);if(!(a[h>>2]|0))return u=c,0;q=a[k>>2]|0;
if(q&32)g=q;else if(da[a[b+508>>2]&63](b)|0)l=a[k>>2]|32,g=a[k>>2]=l;else return u=c,0;a[b+452>>2]=d;q=a[b+164>>2]|0;l=E(a[b+100>>2]|0,(d>>>0)%(q>>>0)|0)|0;a[b+444>>2]=l;a[k>>2]=g&-1048577;g&131072?h=a[b+604>>2]=0:(a[b+604>>2]=a[b+588>>2],h=a[(a[h>>2]|0)+(d<<3)>>2]|0);a[b+608>>2]=h;h=dd[a[b+512>>2]&127](b,((d>>>0)/(q>>>0)|0)&65535)|0;u=c;return h|0}function ld(b,d,c){b|=0;d|=0;c|=0;var e,f,g,h,m,k,l;e=u;u=u+16|0;f=e+8|0;g=e;h=b+12|0;m=a[h>>2]|0;m&131072&&Z(137648,137683,918,137694);a[h>>2]=m&-8388609;
k=b+588|0;if(l=a[k>>2]|0)m&512&&ja(l),a[k>>2]=0,a[b+592>>2]=0;if(d)return a[b+592>>2]=c,a[k>>2]=d,a[h>>2]&=-513,u=e,1;d=c+1023&-1024;a[b+592>>2]=d;if(!d)return Y(a[b+628>>2]|0,137694,137714,g),u=e,0;g=eb(d)|0;a[k>>2]=g;a[h>>2]|=512;if(g)return u=e,1;g=a[b+628>>2]|0;a[f>>2]=a[b+444>>2];Y(g,137694,138034,f);a[b+592>>2]=0;u=e;return 0}function sd(b,d,c,e,f,g){b|=0;d|=0;c|=0;e|=0;f|=0;g|=0;var h;h=u;u=u+16|0;if(1==(a[b+8>>2]|0))return Y(a[b+628>>2]|0,a[b>>2]|0,137580,h),u=h,-1;if(!(a[b+12>>2]&1024))return Y(a[b+
628>>2]|0,a[b>>2]|0,138075,h+8|0),u=h,-1;if(!(yf(b,c,e,f,g)|0))return u=h,-1;var m=b;b|=0;c|=0;e|=0;g|=0;var k,l,n,p,q,y,B;k=a[b+68>>2]|0;l=a[b+72>>2]|0;n=a[b+76>>2]|0;p=a[b+64>>2]|0;f=1==(p|0)?0:f|0;k=-1==(k|0)?a[b+56>>2]|0:k;q=-1==(l|0)?a[b+60>>2]|0:l;l=-1==(n|0)?p:n;0!=(k|0)&0!=(q|0)&0!=(l|0)?(n=a[b+56>>2]|0,y=n>>>0<(0-k|0)>>>0?((k+-1+n|0)>>>0)/(k>>>0)|0:0,n=a[b+60>>2]|0,B=p>>>0<(0-l|0)>>>0?((l+-1+p|0)>>>0)/(l>>>0)|0:0,p=E(n>>>0<(0-q|0)>>>0?((q+-1+n|0)>>>0)/(q>>>0)|0:0,y)|0,b=2==(w[b+126>>1]|0)?
((c>>>0)/(k>>>0)|0)+(E((e>>>0)/(q>>>0)|0,y)|0)+(E(((f>>>0)/(l>>>0)|0)+(E(B,g&65535)|0)|0,p)|0)|0:(E((e>>>0)/(q>>>0)|0,y)|0)+(E((f>>>0)/(l>>>0)|0,p)|0)+((c>>>0)/(k>>>0)|0)|0,b|=0):b=1;d=Od(m,b|0,d,-1)|0;u=h;return d|0}function Od(b,d,c,e){b|=0;d|=0;c|=0;e|=0;var f,g,h,m;f=u;u=u+32|0;g=f+16|0;h=a[b+496>>2]|0;if(1==(a[b+8>>2]|0))return Y(a[b+628>>2]|0,a[b>>2]|0,137580,f),u=f,-1;if(!(a[b+12>>2]&1024))return Y(a[b+628>>2]|0,a[b>>2]|0,138075,f+8|0),u=f,-1;m=a[b+168>>2]|0;if(m>>>0<=d>>>0)return b=a[b+628>>
2]|0,a[g>>2]=d,a[g+4>>2]=m,Y(b,138116,138136,g),u=f,-1;g=-1==(e|0)|(h|0)<(e|0)?h:e;if(!(we(b,d)|0&&rb[a[b+548>>2]&63](b,c,g,((d>>>0)/((a[b+164>>2]|0)>>>0)|0)&65535)|0))return u=f,-1;td[a[b+652>>2]&127](b,c,g);u=f;return g|0}function we(b,d){b|=0;d|=0;var c,e,f,g,h,m,k,l,n,p,q,y,B=0,H=0,t=0,z=0;c=u;u=u+48|0;e=c+40|0;f=c+32|0;g=c+24|0;h=c+16|0;m=b+176|0;k=a[m>>2]|0;if(!k)return u=c,0;l=b+12|0;n=a[l>>2]|0;do if(!(n&131072)){p=k+(d<<3)|0;q=a[p>>2]|0;y=a[p+4>>2]|0;if(0>(y|0)|0==(y|0)&1>q>>>0)return p=
a[b+628>>2]|0,B=c,a[B>>2]=q,a[B+4>>2]=y,a[c+8>>2]=d,Y(p,138168,138181,c),e=0,u=c,e|0;if(0!=(n&2048|0)&&0!=((N[b+94>>1]|256)&n|0)){0!=(n&512|0)&&(p=b+588|0,B=a[p>>2]|0,0!=(B|0))?(ja(B),a[p>>2]=0,a[b+592>>2]=0,h=a[l>>2]|0):h=n;p=h&-513;a[l>>2]=p;B=a[b+616>>2]|0;h=(0>(B|0))<<31>>31;if(h>>>0<y>>>0|(h|0)==(y|0)&B>>>0<q>>>0?0:(H=(a[b+172>>2]|0)+(d<<3)|0,t=a[H>>2]|0,z=a[H+4>>2]|0,H=Ic(B|0,h|0,q|0,y|0)|0,h=U,!(z>>>0>h>>>0|(z|0)==(h|0)&t>>>0>H>>>0))){a[b+592>>2]=q;a[b+588>>2]=(a[b+612>>2]|0)+t;a[b+596>>2]=
0;a[b+600>>2]=q;a[l>>2]=p|8388608;break}a[b+492>>2]=-1;e=0;u=c;return e|0}if(!((q|0)==(q|0)&((0>(q|0))<<31>>31|0)==(y|0)))return Y(a[b+628>>2]|0,138168,139721,h),e=0,u=c,e|0;if((q|0)>(a[b+592>>2]|0)){a[b+492>>2]=-1;if(!(n&512))return y=a[b+628>>2]|0,a[g>>2]=d,Y(y,138168,138221,g),e=0,u=c,e|0;if(ld(b,0,q)|0)y=a[l>>2]|0;else return e=0,u=c,e|0}else y=n;if(0!=(y&8388608|0)&&(a[b+492>>2]=-1,0==(ld(b,0,q)|0)))return e=0,u=c,e|0;y=b+588|0;if((xe(b,d,a[y>>2]|0,q,138168)|0)!=(q|0))return e=0,u=c,e|0;a[b+
596>>2]=0;a[b+600>>2]=q;(N[b+94>>1]|256)&a[l>>2]||ye(a[y>>2]|0,q)}while(0);if(!(a[m>>2]|0))return u=c,0;y=a[l>>2]|0;if(y&32)q=y;else if(da[a[b+508>>2]&63](b)|0)n=a[l>>2]|32,q=a[l>>2]=n;else return u=c,0;a[b+492>>2]=d;y=a[b+56>>2]|0;n=a[b+68>>2]|0;if(y>>>0<(0-n|0)>>>0&&(g=((y+-1+n|0)>>>0)/(n>>>0)|0,0!=(g|0))){y=a[b+72>>2]|0;h=E(y,(d>>>0)%(g>>>0)|0)|0;a[b+444>>2]=h;h=a[b+60>>2]|0;if(h>>>0<(0-y|0)>>>0&&(g=((y+-1+h|0)>>>0)/(y>>>0)|0,0!=(g|0)))return y=E((d>>>0)%(g>>>0)|0,n)|0,a[b+488>>2]=y,a[l>>2]=q&
-1048577,q&131072?e=a[b+604>>2]=0:(a[b+604>>2]=a[b+588>>2],e=a[(a[m>>2]|0)+(d<<3)>>2]|0),a[b+608>>2]=e,e=dd[a[b+512>>2]&127](b,((d>>>0)/((a[b+164>>2]|0)>>>0)|0)&65535)|0,u=c,e|0;Y(a[b+628>>2]|0,138260,138274,e);u=c;return 0}Y(a[b+628>>2]|0,138260,138274,f);u=c;return 0}function me(b,d,c,e,f){b|=0;d|=0;c|=0;e|=0;f|=0;var g,h,m,k,l,n,p,q=p=0;g=u;u=u+64|0;h=g+32|0;m=g+8|0;k=g;l=a[b+12>>2]|0;l&131072&&Z(137648,137683,372,138609);if(!(l&2048)){l=b+628|0;h=b+172|0;n=(a[h>>2]|0)+(d<<3)|0;p=rb[a[b+640>>2]&
63](a[l>>2]|0,a[n>>2]|0,a[n+4>>2]|0,0)|0;n=(a[h>>2]|0)+(d<<3)|0;if((p|0)!=(a[n>>2]|0)||(U|0)!=(a[n+4>>2]|0))return n=a[l>>2]|0,a[k>>2]=a[b+444>>2],a[k+4>>2]=d,Y(n,f,137734,k),u=g,-1;k=Aa[a[b+632>>2]&63](a[l>>2]|0,c,e)|0;if((k|0)==(e|0))return u=g,e|0;n=a[l>>2]|0;a[m>>2]=a[b+444>>2];l=m+8|0;a[l>>2]=k;a[l+4>>2]=(0>(k|0))<<31>>31;k=m+16|0;a[k>>2]=e;a[k+4>>2]=(0>(e|0))<<31>>31;Y(n,f,137772,m);u=g;return-1}m=(a[b+172>>2]|0)+(d<<3)|0;n=a[m>>2]|0;k=n+e|0;(n|0)==(n|0)&&((0>(n|0))<<31>>31|0)==(a[m+4>>2]|0)&&
(m=a[b+616>>2]|0,(m|0)>=(n|0))?0>(n|e|0)|(k|0)>(m|0)&&(p=m-n|0,q=13):(p=0,q=13);if(13==(q|0)&&(p|0)!=(e|0))return q=a[b+628>>2]|0,a[h>>2]=a[b+444>>2],a[h+4>>2]=d,d=h+8|0,a[d>>2]=p,a[d+4>>2]=(0>(p|0))<<31>>31,p=h+16|0,a[p>>2]=e,a[p+4>>2]=(0>(e|0))<<31>>31,Y(q,f,138627,h),u=g,-1;Ab(c,(a[b+612>>2]|0)+n|0,e);u=g;return e|0}function xe(b,d,c,e,f){b|=0;d|=0;c|=0;e|=0;f|=0;var g,h,m,k,l,n,p,q=p=0;g=u;u=u+80|0;h=g+40|0;m=g+16|0;k=g;l=a[b+12>>2]|0;l&131072&&Z(137648,137683,684,138417);if(!(l&2048)){l=b+628|
0;h=b+172|0;n=(a[h>>2]|0)+(d<<3)|0;p=rb[a[b+640>>2]&63](a[l>>2]|0,a[n>>2]|0,a[n+4>>2]|0,0)|0;n=(a[h>>2]|0)+(d<<3)|0;if((p|0)!=(a[n>>2]|0)||(U|0)!=(a[n+4>>2]|0))return n=a[l>>2]|0,p=a[b+488>>2]|0,a[k>>2]=a[b+444>>2],a[k+4>>2]=p,a[k+8>>2]=d,Y(n,f,138434,k),u=g,-1;k=Aa[a[b+632>>2]&63](a[l>>2]|0,c,e)|0;if((k|0)==(e|0))return u=g,e|0;n=a[l>>2]|0;l=a[b+488>>2]|0;a[m>>2]=a[b+444>>2];a[m+4>>2]=l;l=m+8|0;a[l>>2]=k;a[l+4>>2]=(0>(k|0))<<31>>31;k=m+16|0;a[k>>2]=e;a[k+4>>2]=(0>(e|0))<<31>>31;Y(n,f,138475,m);u=
g;return-1}m=(a[b+172>>2]|0)+(d<<3)|0;n=a[m>>2]|0;k=n+e|0;(n|0)==(n|0)&&((0>(n|0))<<31>>31|0)==(a[m+4>>2]|0)&&(m=a[b+616>>2]|0,(m|0)>=(n|0))?0>(n|e|0)|(k|0)>(m|0)&&(p=m-n|0,q=13):(p=0,q=13);if(13==(q|0)&&(p|0)!=(e|0))return q=a[b+628>>2]|0,m=a[b+488>>2]|0,a[h>>2]=a[b+444>>2],a[h+4>>2]=m,a[h+8>>2]=d,d=h+16|0,a[d>>2]=p,a[d+4>>2]=(0>(p|0))<<31>>31,p=h+24|0,a[p>>2]=e,a[p+4>>2]=(0>(e|0))<<31>>31,Y(q,f,138537,h),u=g,-1;Ab(c,(a[b+612>>2]|0)+n|0,e);u=g;return e|0}function Pc(b,d,c){b|=0;c|=0;var e,f,g;e=
u;u=u+16|0;f=((d|0)>>>0)/((a[b+100>>2]|0)>>>0)|0;if(2!=(w[b+126>>1]|0))return u=e,f|0;d=c&65535;g=w[b+98>>1]|0;if((g&65535)>(c&65535))return b=(E(a[b+164>>2]|0,d)|0)+f|0,u=e,b|0;f=a[b+628>>2]|0;a[e>>2]=d;a[e+4>>2]=g&65535;Y(f,138696,139539,e);u=e;return 0}function Yd(b,d){b|=0;d|=0;var c,e,f,g,h,m;c=u;u=u+32|0;e=c+16|0;f=c+8|0;g=c;h=c+24|0;m=-1==(d|0)?a[b+60>>2]|0:d;if(1==(w[b+126>>1]|0)&&6==(w[b+90>>1]|0)&&0==(a[b+12>>2]&16384|0)){if(3!=(w[b+98>>1]|0))return Y(a[b+628>>2]|0,138732,138749,g),U=0,
u=c,0;g=h+2|0;a[f>>2]=h;a[f+4>>2]=g;ne(b,530,f)|0;f=w[h>>1]|0;a:do switch(f<<16>>16){case 4:case 2:case 1:h=w[g>>1]|0;switch(h<<16>>16){case 4:case 2:case 1:break;default:break a}d=f&65535;g=h&65535;h=(E(g,d)|0)+2|0;e=a[b+56>>2]|0;e=e>>>0<(0-d|0)>>>0?((d+-1+e|0)>>>0)/(d>>>0)|0:0;m=m>>>0<(0-g|0)>>>0?((m+-1+g|0)>>>0)/(g>>>0)|0:0;g=pd(b,e,0,h&65535,0,138732)|0;h=U;d=b+84|0;e=pd(b,g,h,N[d>>1]|0,0,138732)|0;m=pd(b,Qb(Oe(pd(b,g,h,N[d>>1]|0,0,138732)|0,U|0,3)|0,U|0,(0!=(e&7|0)|0)&1|0,0)|0,U,m,0,138732)|
0;U=h=U;u=c;return m|0;default:h=w[g>>1]|0}while(0);g=a[b+628>>2]|0;a[e>>2]=f&65535;a[e+4>>2]=h&65535;Y(g,138732,139754,e);U=0;u=c;return 0}e=Td(b)|0;g=pd(b,m,0,e,U,138732)|0;U=h=U;u=c;return g|0}function Td(b){b|=0;var d,c,e,f,g,h;d=u;u=u+32|0;c=d+16|0;e=d+8|0;f=d+20|0;a:do{if(1==(w[b+126>>1]|0)){g=w[b+98>>1]|0;if(3==g<<16>>16&&6==(w[b+90>>1]|0))if(a[b+12>>2]&16384)g=3;else{g=f+2|0;a[d>>2]=f;a[d+4>>2]=g;ne(b,530,d)|0;h=w[f>>1]|0;b:do switch(h<<16>>16){case 4:case 2:case 1:f=w[g>>1]|0;switch(f<<16>>
16){case 4:case 2:case 1:break;default:break b}h&=65535;e=(E(f&65535,h)|0)+2|0;f=a[b+56>>2]|0;f=f>>>0<(0-h|0)>>>0?((h+-1+f|0)>>>0)/(h>>>0)|0:0;g=pf(Oe(Qb(pd(b,pd(b,f,0,e&65535,0,138782)|0,U,N[b+84>>1]|0,0,138782)|0,U|0,7,0)|0,U|0,3)|0,U|0,N[g>>1]|0,0)|0;h=U;break a}while(0);Y(a[b+628>>2]|0,138782,138801,e);U=0;u=d;return 0}g=pd(b,a[b+56>>2]|0,0,g&65535,0,138782)|0;h=pd(b,g,U,N[b+84>>1]|0,0,138782)|0}else h=pd(b,a[b+56>>2]|0,0,N[b+84>>1]|0,0,138782)|0;g=Qb(h|0,U|0,7,0)|0;g=h=Oe(g|0,U|0,3)|0;h=U}while(0);
if(!(0==(g|0)&0==(h|0)))return U=h,u=d,g|0;Y(a[b+628>>2]|0,138782,138827,c);U=0;u=d;return 0}function se(b){b|=0;var d,c,e;d=u;u=u+16|0;c=a[b+100>>2]|0;e=a[b+60>>2]|0;c=Yd(b,c>>>0>e>>>0?e:c)|0;if((c|0)==(c|0)&((0>(c|0))<<31>>31|0)==(U|0))return u=d,c|0;Y(a[b+628>>2]|0,138873,139721,d);u=d;return 0}function Pe(b){b|=0;var d,c;d=u;u=u+16|0;c=Td(b)|0;if((c|0)==(c|0)&((0>(c|0))<<31>>31|0)==(U|0))return u=d,c|0;Y(a[b+628>>2]|0,138887,138904,d);u=d;return 0}function ac(a){a|=0;var d,c;d=a+1|0;c=t[d>>0]|
0;t[d>>0]=t[a>>0]|0;t[a>>0]=c}function pb(a){a|=0;var d,c;d=a+3|0;c=t[d>>0]|0;t[d>>0]=t[a>>0]|0;t[a>>0]=c;c=a+2|0;d=t[c>>0]|0;a=a+1|0;t[c>>0]=t[a>>0]|0;t[a>>0]=d}function kc(a){a|=0;var d,c,e;d=a+7|0;c=t[d>>0]|0;t[d>>0]=t[a>>0]|0;t[a>>0]=c;c=a+6|0;d=t[c>>0]|0;e=a+1|0;t[c>>0]=t[e>>0]|0;t[e>>0]=d;d=a+5|0;e=t[d>>0]|0;c=a+2|0;t[d>>0]=t[c>>0]|0;t[c>>0]=e;e=a+4|0;c=t[e>>0]|0;d=a+3|0;t[e>>0]=t[d>>0]|0;t[d>>0]=c}function Vd(a,d){d|=0;var c,e;if(0<(d|0))for(c=d,e=a|0;;)if(a=e+1|0,d=t[a>>0]|0,t[a>>0]=t[e>>
0]|0,t[e>>0]=d,1<(c|0))c=c+-1|0,e=e+2|0;else break}function Id(a,d){d|=0;var c,e,f;if(0<(d|0))for(c=d,e=a|0;;)if(a=e+3|0,d=t[a>>0]|0,t[a>>0]=t[e>>0]|0,t[e>>0]=d,d=e+2|0,a=t[d>>0]|0,f=e+1|0,t[d>>0]=t[f>>0]|0,t[f>>0]=a,1<(c|0))c=c+-1|0,e=e+4|0;else break}function Ae(a,d){d|=0;var c,e,f;if(0<(d|0))for(c=d,e=a|0;;)if(a=e+7|0,d=t[a>>0]|0,t[a>>0]=t[e>>0]|0,t[e>>0]=d,d=e+6|0,a=t[d>>0]|0,f=e+1|0,t[d>>0]=t[f>>0]|0,t[f>>0]=a,a=e+5|0,f=t[a>>0]|0,d=e+2|0,t[a>>0]=t[d>>0]|0,t[d>>0]=f,f=e+4|0,d=t[f>>0]|0,a=e+3|
0,t[f>>0]=t[a>>0]|0,t[a>>0]=d,1<(c|0))c=c+-1|0,e=e+8|0;else break}function gf(a,d){d|=0;var c,e,f;if(0<(d|0))for(c=d,e=a|0;;)if(a=e+3|0,d=t[a>>0]|0,t[a>>0]=t[e>>0]|0,t[e>>0]=d,d=e+2|0,a=t[d>>0]|0,f=e+1|0,t[d>>0]=t[f>>0]|0,t[f>>0]=a,1<(c|0))c=c+-1|0,e=e+4|0;else break}function re(a,d){d|=0;var c,e,f;if(0<(d|0))for(c=d,e=a|0;;)if(a=e+7|0,d=t[a>>0]|0,t[a>>0]=t[e>>0]|0,t[e>>0]=d,d=e+6|0,a=t[d>>0]|0,f=e+1|0,t[d>>0]=t[f>>0]|0,t[f>>0]=a,a=e+5|0,f=t[a>>0]|0,d=e+2|0,t[a>>0]=t[d>>0]|0,t[d>>0]=f,f=e+4|0,d=t[f>>
0]|0,a=e+3|0,t[f>>0]=t[a>>0]|0,t[a>>0]=d,1<(c|0))c=c+-1|0,e=e+8|0;else break}function ye(a,d){a|=0;d|=0;var c,e,f,g;if(8<(d|0)){c=d+-9&-8;e=a;for(f=d;!(t[e>>0]=t[138932+(x[e>>0]|0)>>0]|0,g=e+1|0,t[g>>0]=t[138932+(x[g>>0]|0)>>0]|0,g=e+2|0,t[g>>0]=t[138932+(x[g>>0]|0)>>0]|0,g=e+3|0,t[g>>0]=t[138932+(x[g>>0]|0)>>0]|0,g=e+4|0,t[g>>0]=t[138932+(x[g>>0]|0)>>0]|0,g=e+5|0,t[g>>0]=t[138932+(x[g>>0]|0)>>0]|0,g=e+6|0,t[g>>0]=t[138932+(x[g>>0]|0)>>0]|0,g=e+7|0,t[g>>0]=t[138932+(x[g>>0]|0)>>0]|0,f=f+-8|0,8>=(f|
0));)e=e+8|0;e=d+-8-c|0;c=a+(c+8|0)|0}else e=d,c=a;if(0<(e|0))for(;;)if(t[c>>0]=t[138932+(x[c>>0]|0)>>0]|0,1<(e|0))c=c+1|0,e=e+-1|0;else break}function yf(b,d,c,e,f){b|=0;d|=0;c|=0;e|=0;f|=0;var g,h,m,k,l,n,p,q;g=u;u=u+32|0;h=g+24|0;m=g+16|0;k=g+8|0;l=g;n=a[b+56>>2]|0;if(n>>>0<=d>>>0)return p=a[b+628>>2]|0,q=a[b>>2]|0,a[l>>2]=d,a[l+4>>2]=n+-1,Y(p,q,139444,l),u=g,0;l=a[b+60>>2]|0;if(l>>>0<=c>>>0)return q=a[b+628>>2]|0,p=a[b>>2]|0,a[k>>2]=c,a[k+4>>2]=l+-1,Y(q,p,139475,k),u=g,0;k=a[b+64>>2]|0;if(k>>>
0<=e>>>0)return p=a[b+628>>2]|0,q=a[b>>2]|0,a[m>>2]=e,a[m+4>>2]=k+-1,Y(p,q,139506,m),u=g,0;if(2!=(w[b+126>>1]|0))return u=g,1;m=w[b+98>>1]|0;if((m&65535)>(f&65535))return u=g,1;q=a[b+628>>2]|0;p=a[b>>2]|0;a[h>>2]=f&65535;a[h+4>>2]=(m&65535)+-1;Y(q,p,139539,h);u=g;return 0}function Uf(b){b|=0;var d,c,e,f,g,h;d=u;u=u+32|0;c=d+24|0;e=d+16|0;if(!(a[b+72>>2]|0))return Y(a[b+628>>2]|0,139591,139609,d),U=0,u=d,0;f=a[b+68>>2]|0;if(!f)return Y(a[b+628>>2]|0,139591,139629,d+8|0),U=0,u=d,0;g=pd(b,N[b+84>>1]|
0,0,f,0,139648)|0;f=U;if(1==(w[b+126>>1]|0))if(h=w[b+98>>1]|0,h<<16>>16)e=f=pd(b,g,f,h&65535,0,139648)|0,g=U;else return Y(a[b+628>>2]|0,139591,139664,e),U=0,u=d,0;else e=g,g=f;f=Oe(e|0,g|0,3)|0;g=Qb((0!=(e&7|0)|0)&1|0,0,f|0,U|0)|0;f=U;if(!(0==(g|0)&0==(f|0)))return U=f,u=d,g|0;Y(a[b+628>>2]|0,139591,139690,c);U=0;u=d;return 0}function tg(b){b|=0;var d,c;d=u;u=u+16|0;c=Uf(b)|0;if((c|0)==(c|0)&((0>(c|0))<<31>>31|0)==(U|0))return u=d,c|0;Y(a[b+628>>2]|0,139648,139721,d);u=d;return 0}function Kf(b,d){b|=
0;d|=0;var c,e,f,g,h,m;c=u;u=u+32|0;e=c+8|0;f=c;g=c+16|0;if(!(a[b+72>>2]|0))return U=0,u=c,0;h=b+68|0;if(!(a[h>>2]|0&&a[b+76>>2]|0))return U=0,u=c,0;if(1==(w[b+126>>1]|0)&&6==(w[b+90>>1]|0)&&3==(w[b+98>>1]|0)&&0==(a[b+12>>2]&16384|0)){m=g+2|0;a[f>>2]=g;a[f+4>>2]=m;ne(b,530,f)|0;f=w[g>>1]|0;a:do switch(f<<16>>16){case 4:case 2:case 1:g=w[m>>1]|0;switch(g<<16>>16){case 4:case 2:case 1:break;default:break a}e=f&65535;m=g&65535;g=(E(m,e)|0)+2|0;f=a[h>>2]|0;e=f>>>0<(0-e|0)>>>0?((e+-1+f|0)>>>0)/(e>>>0)|
0:0;h=d>>>0<(0-m|0)>>>0?((d+-1+m|0)>>>0)/(m>>>0)|0:0;m=pd(b,e,0,g&65535,0,139738)|0;g=U;e=b+84|0;f=pd(b,m,g,N[e>>1]|0,0,139738)|0;h=pd(b,Qb(Oe(pd(b,m,g,N[e>>1]|0,0,139738)|0,U|0,3)|0,U|0,(0!=(f&7|0)|0)&1|0,0)|0,U,h,0,139738)|0;U=g=U;u=c;return h|0;default:g=w[m>>1]|0}while(0);m=a[b+628>>2]|0;a[e>>2]=f&65535;a[e+4>>2]=g&65535;Y(m,139738,139754,e);U=0;u=c;return 0}e=Uf(b)|0;m=pd(b,d,0,e,U,139738)|0;U=g=U;u=c;return m|0}function Og(b){b|=0;var d,c;d=u;u=u+16|0;c=Kf(b,a[b+72>>2]|0)|0;if((c|0)==(c|0)&
((0>(c|0))<<31>>31|0)==(U|0))return u=d,c|0;Y(a[b+628>>2]|0,139788,139721,d);u=d;return 0}function Wb(b,d,c,e){b|=0;d|=0;c|=0;var f;f=u;u=u+16|0;a[f>>2]=e|0;if(e=a[1933]|0)td[e&127](d,c,f);if(e=a[1932]|0)Ud[e&31](b,d,c,f);u=f}function Lc(b){b|=0;var d,c,e,f,g;d=b+608|0;c=a[d>>2]|0;if(0>=(c|0))return 1;e=b+12|0;f=a[e>>2]|0;if(!(f&1048576))return 1;g=b+588|0;(N[b+94>>1]|256)&f?e=f:(ye(a[g>>2]|0,c),e=a[e>>2]|0,c=a[d>>2]|0);if(!(dg(b,a[(0==(e&1024|0)?b+452|0:b+492|0)>>2]|0,a[g>>2]|0,c)|0))return 0;a[d>>
2]=0;a[b+604>>2]=a[g>>2];return 1}function dg(b,d,c,e){b|=0;d|=0;c|=0;e|=0;var f,g,h,m,k,l,n,p,q=0,y=0,B=0,H=0,t;f=u;u=u+32|0;g=f+16|0;h=f+8|0;m=f;k=b+172|0;l=(a[k>>2]|0)+(d<<3)|0;n=a[l>>2]|0;p=a[l+4>>2]|0;if((l=0==(n|0)&0==(p|0))||(q=b+456|0,y=q,B=a[y>>2]|0,H=a[y+4>>2]|0,0==(B|0)&0==(H|0))){a[b+168>>2]|0||Z(139801,139820,690,139832);H=b+176|0;B=(a[H>>2]|0)+(d<<3)|0;q=a[B>>2]|0;y=a[B+4>>2]|0;if(0==(q|0)&0==(y|0)||(B=(0>(e|0))<<31>>31,y>>>0<B>>>0|(y|0)==(B|0)&q>>>0<e>>>0|l))m=rb[a[b+640>>2]&63](a[b+
628>>2]|0,0,0,2)|0,p=U,l=(a[k>>2]|0)+(d<<3)|0,a[l>>2]=m,a[l+4>>2]=p,l=b+12|0,a[l>>2]|=2097152,y=m,t=p;else if(l=b+628|0,q=rb[a[b+640>>2]&63](a[l>>2]|0,n,p,0)|0,p=U,n=(a[k>>2]|0)+(d<<3)|0,(q|0)==(a[n>>2]|0)&&(p|0)==(a[n+4>>2]|0))y=q,t=p;else return p=a[l>>2]|0,a[m>>2]=a[b+444>>2],Y(p,139832,139850,m),u=f,0;m=p=b+456|0;a[m>>2]=y;a[m+4>>2]=t;H=t=(a[H>>2]|0)+(d<<3)|0;m=a[H>>2]|0;y=a[H+4>>2]|0;H=t;a[H>>2]=0;a[H+4>>2]=0;k=H=p;B=a[H>>2]|0;l=a[H+4>>2]|0;n=m;q=y}else k=q,l=H,q=n=-1;y=(0>(e|0))<<31>>31;m=Qb(B|
0,l|0,e|0,y|0)|0;H=b+12|0;p=0==(a[H>>2]&524288|0);t=m;m=p?0:U;if(m>>>0<l>>>0|(m|0)==(l|0)&t>>>0<B>>>0|m>>>0<y>>>0|(m|0)==(y|0)&t>>>0<e>>>0)return Y(a[b+628>>2]|0,139832,142108,h),u=f,0;h=b+628|0;if((Aa[a[b+636>>2]&63](a[h>>2]|0,c,e)|0)!=(e|0))return c=a[h>>2]|0,a[g>>2]=a[b+444>>2],Y(c,139832,139877,g),u=f,0;g=k;a[g>>2]=t;a[g+4>>2]=m;d=m=(a[b+176>>2]|0)+(d<<3)|0;b=Qb(a[d>>2]|0,a[d+4>>2]|0,e|0,y|0)|0;y=U;e=m;a[e>>2]=b;a[e+4>>2]=y;if((b|0)==(n|0)&(y|0)==(q|0))return u=f,1;a[H>>2]|=2097152;u=f;return 1}
function eb(a){a|=0;return(a?Hc(a)|0:0)|0}function ja(a){Gc(a|0)}function nf(a,d){return qi(a|0,d|0)|0}function $c(a,d,c){Va(a|0,(d|0)&255|0,c|0)|0}function Ab(a,d,c){Ec(a|0,d|0,c|0)|0}function of(b,d,c,e){b|=0;d|=0;c|=0;e|=0;var f,g;f=u;u=u+16|0;g=E(c,d)|0;0!=(c|0)&&((g>>>0)/(c>>>0)|0)!=(d|0)?(d=a[b+628>>2]|0,a[f>>2]=e,Y(d,e,139955,f),b=0):b=g;u=f;return b|0}function pd(b,d,c,e,f,g){b|=0;d|=0;c|=0;e|=0;f|=0;g|=0;var h,m,k,l=0;h=u;u=u+16|0;m=Cf(e|0,f|0,d|0,c|0)|0;k=U;0==(e|0)&0==(f|0)||(l=pf(m|0,
k|0,e|0,f|0)|0,(l|0)==(d|0)&(U|0)==(c|0))?b=k:(c=a[b+628>>2]|0,a[h>>2]=g,Y(c,g,139955,h),m=b=0);U=b;u=h;return m|0}function Bf(b,d,c,e,f){b|=0;c|=0;e|=0;f|=0;var g,h=0;g=u;u=u+16|0;if(0!=(c|0)&0!=(e|0)&&(h=nf(d|0,E(e,c)|0)|0,0!=(h|0)))return u=g,h|0;h=a[b+628>>2]|0;d=a[b>>2]|0;a[g>>2]=f;a[g+4>>2]=c;a[g+8>>2]=e;Y(h,d,139978,g);u=g;return 0}function Mf(b,d,c,e){b|=0;d|=0;c|=0;e|=0;var f,g=0;f=u;u=u+16|0;if(0!=(d|0)&0!=(c|0)&&(g=nf(0,E(c,d)|0)|0,0!=(g|0)))return u=f,g|0;g=a[b+628>>2]|0;b=a[b>>2]|0;a[f>>
2]=e;a[f+4>>2]=d;a[f+8>>2]=c;Y(g,b,139978,f);u=f;return 0}function Se(b){b|=0;var d,c,e,f;d=4;c=Hc(40)|0;a[c>>2]=0;c=Xc(b+624|0,1,c|0,d|0)|0;d=U;Wa=e=Wa=0;0!=(e|0)&0!=(pa|0)?((f=db(a[e>>2]|0,c|0,d|0)|0)||Vb(e|0,pa|0),U=pa):f=-1;for(f=1==(f|0)?U:0;!f;)if(Wa=0,ri(12,b|0),f=Wa,Wa=0,0!=(f|0)&0!=(pa|0)?((e=db(a[f>>2]|0,c|0,d|0)|0)||Vb(f|0,pa|0),U=pa):e=-1,1==(e|0))f=U;else break;Gc(c|0)}function Re(b,d,c){b|=0;d|=0;c|=0;var e,f,g,h,m=0,k=0,l=0;e=4;f=Hc(40)|0;a[f>>2]=0;f=Xc(b+624|0,1,f|0,e|0)|0;e=U;Wa=
g=Wa=0;0!=(g|0)&0!=(pa|0)?((h=db(a[g>>2]|0,f|0,e|0)|0)||Vb(g|0,pa|0),U=pa):h=-1;for(h=1==(h|0)?U:0;;){if(h){m=-1;k=6;break}Wa=0;l=Pg(16,b|0,d|0,c|0)|0;h=Wa;Wa=0;0!=(h|0)&0!=(pa|0)?((g=db(a[h>>2]|0,f|0,e|0)|0)||Vb(h|0,pa|0),U=pa):g=-1;if(1==(g|0))h=U;else break}if(6==(k|0))return Gc(f|0),m|0;m=l;Gc(f|0);return m|0}function uf(b,d){b|=0;d|=0;var c,e,f,g,h=0,m=0;c=4;e=Hc(40)|0;a[e>>2]=0;e=Xc(b+624|0,1,e|0,c|0)|0;c=U;Wa=f=Wa=0;0!=(f|0)&0!=(pa|0)?((g=db(a[f>>2]|0,e|0,c|0)|0)||Vb(f|0,pa|0),U=pa):g=-1;for(g=
1==(g|0)?U:0;;){if(g){h=0;m=6;break}Wa=0;dk(2,b|0,d|0);g=Wa;Wa=0;0!=(g|0)&0!=(pa|0)?((f=db(a[g>>2]|0,e|0,c|0)|0)||Vb(g|0,pa|0),U=pa):f=-1;if(1==(f|0))g=U;else break}if(6==(m|0))return Gc(e|0),h|0;h=1;Gc(e|0);return h|0}function mg(b,d){b|=0;d|=0;var c,e,f,g,h=0,m=0;c=4;e=Hc(40)|0;a[e>>2]=0;e=Xc(b+624|0,1,e|0,c|0)|0;c=U;Wa=f=Wa=0;0!=(f|0)&0!=(pa|0)?((g=db(a[f>>2]|0,e|0,c|0)|0)||Vb(f|0,pa|0),U=pa):g=-1;for(g=1==(g|0)?U:0;;){if(g){h=0;m=6;break}Wa=0;Qi(12,b|0,d|0,0);g=Wa;Wa=0;0!=(g|0)&0!=(pa|0)?((f=
db(a[g>>2]|0,e|0,c|0)|0)||Vb(g|0,pa|0),U=pa):f=-1;if(1==(f|0))g=U;else break}if(6==(m|0))return Gc(e|0),h|0;h=1;Gc(e|0);return h|0}function eg(b,d,c){b|=0;d|=0;c|=0;var e,f,g,h,m=0,k=0,l=0;e=4;f=Hc(40)|0;a[f>>2]=0;f=Xc(b+624|0,1,f|0,e|0)|0;e=U;Wa=g=Wa=0;0!=(g|0)&0!=(pa|0)?((h=db(a[g>>2]|0,f|0,e|0)|0)||Vb(g|0,pa|0),U=pa):h=-1;for(h=1==(h|0)?U:0;;){if(h){m=0;k=6;break}Wa=0;l=Mj(a[(a[b+4>>2]|0)+8>>2]|0,b|0,1,d|0,c|0)|0;h=Wa;Wa=0;0!=(h|0)&0!=(pa|0)?((g=db(a[h>>2]|0,f|0,e|0)|0)||Vb(h|0,pa|0),U=pa):g=-1;
if(1==(g|0))h=U;else break}if(6==(k|0))return Gc(f|0),m|0;m=l;Gc(f|0);return m|0}function qg(b){b|=0;var d,c,e,f,g=0,h=0,m=0;d=4;c=Hc(40)|0;a[c>>2]=0;c=Xc(b+624|0,1,c|0,d|0)|0;d=U;Wa=e=Wa=0;0!=(e|0)&0!=(pa|0)?((f=db(a[e>>2]|0,c|0,d|0)|0)||Vb(e|0,pa|0),U=pa):f=-1;for(f=1==(f|0)?U:0;;){if(f){g=-1;h=6;break}Wa=0;m=si(20,b|0)|0;f=Wa;Wa=0;0!=(f|0)&0!=(pa|0)?((e=db(a[f>>2]|0,c|0,d|0)|0)||Vb(f|0,pa|0),U=pa):e=-1;if(1==(e|0))f=U;else break}if(6==(h|0))return Gc(c|0),g|0;g=m;Gc(c|0);return g|0}function fg(b,
d){b|=0;d|=0;var c,e,f,g,h=0,m=0,k=0;c=4;e=Hc(40)|0;a[e>>2]=0;e=Xc(b+624|0,1,e|0,c|0)|0;c=U;Wa=f=Wa=0;0!=(f|0)&0!=(pa|0)?((g=db(a[f>>2]|0,e|0,c|0)|0)||Vb(f|0,pa|0),U=pa):g=-1;for(g=1==(g|0)?U:0;;){if(g){h=-1;m=6;break}Wa=0;k=Jk(30,b|0,d|0)|0;g=Wa;Wa=0;0!=(g|0)&0!=(pa|0)?((f=db(a[g>>2]|0,e|0,c|0)|0)||Vb(g|0,pa|0),U=pa):f=-1;if(1==(f|0))g=U;else break}if(6==(m|0))return Gc(e|0),h|0;h=k;Gc(e|0);return h|0}function mf(a,d,c){a=+a;d=+d;c|=0;var e,f;if(.016939999535679817>d)return a=vf(a,d)|0,a|0;e=0==
(c|0);f=285.7142768952314*(d+-.016939999535679817);f=e?f:f+4.656612875245797E-10*+(Xe()|0)+-.5;c=~~f;if(162<(c|0))return a=vf(a,d)|0,a|0;f=+W[107752+(c<<3)>>2];if(f>a)return a=vf(a,d)|0,a|0;f=285.7142768952314*(a-f);e=~~(e?f:f+4.656612875245797E-10*+(Xe()|0)+-.5);a=(e|0)<(w[(c<<3)+107756>>1]|0)?(w[(c<<3)+107758>>1]|0)+e|0:vf(a,d)|0;return a|0}function tf(a,d){a|=0;d|=0;var c,e=0,f,g,h,m=0,k=0,l,n,p,q=0;f=0;c=a>>>14&1023;if(0==(c|0)||(e=+xh(+(.010830424696249145*(+(c|0)+.5)+-8.317766166719343)),0>=
e))W[d+8>>2]=0,W[d+4>>2]=0,W[d>>2]=0;else{c=a&16383;if(16288<c>>>0)c=.210526316,f=.473684211;else{a=0;g=163;a:for(;;){for(h=a;;){if(1>=(g-h|0)){m=h;k=9;break a}l=h+g>>1;n=w[(l<<3)+107758>>1]|0;p=c-(n<<16>>16)|0;if(0<(p|0))h=l;else{g=l;break}}if(0>(p|0))a=h;else{q=n;f=g;break}}9==(k|0)&&(q=w[(m<<3)+107758>>1]|0,f=m);c=+W[107752+(f<<3)>>2]+.0035000001080334187*(+(c-(q<<16>>16)|0)+.5);f=.0035000001080334187*(+(f|0)+.5)+.016939999535679817}m=1/(6*c-16*f+12);k=9*c*m;c=4*f*m;W[d>>2]=k/c*e;W[d+4>>2]=e;W[d+
8>>2]=(1-k-c)/c*e}}function vf(b,d){b=+b;d=+d;var c,e,f,g,h,m,k,l,n,p;c=u;u=u+800|0;if(a[27282]|0)return e=+ek(+(d+-.473684211),+(b+-.210526316)),e=109132+(~~(15.915494277358546*e+50)<<2)|0,e=a[e>>2]|0,u=c,e|0;for(f=99;;)if(Hb[c+(f<<3)>>3]=2,f)f=f+-1|0;else{e=162;g=163;break}for(;;){h=.0035000001080334187*(+(e|0)+.5)+.016939999535679817;f=(w[(e<<3)+107756>>1]|0)+-1|0;switch(g|0){case 1:case 163:m=1;break;default:m=f}g=+W[107752+(e<<3)>>2];k=h+-.473684211;l=(e<<3)+107758|0;n=f;do h=15.915494277358546*
+ek(+k,+(.0035000001080334187*(+(n|0)+.5)+g+-.210526316))+50,f=~~h,h=+Kk(+(h-(+(f|0)+.5))),p=c+(f<<3)|0,h<+Hb[p>>3]&&(a[109132+(f<<2)>>2]=(w[l>>1]|0)+n,Hb[p>>3]=h),n=n-m|0;while(-1<(n|0));if(e)n=e,e=e+-1|0,g=n;else{f=99;k=100;break}}for(;;){do if(1.5<+Hb[c+(f<<3)>>3]){for(g=1;;){if(1.5>+Hb[c+(((g+f|0)%100|0)<<3)>>3]){h=g;break}e=g+1|0;if(50>(e|0))g=e;else{h=e;break}}g=k+99|0;e=-1;for(m=1;!(1.5>+Hb[c+(((g+e|0)%100|0)<<3)>>3]);)if(n=m+1|0,l=~m,50>(n|0))e=l,m=n;else{m=n;e=l;break}a[109132+(f<<2)>>2]=
(h|0)<(m|0)?a[109132+(((h+f|0)%100|0)<<2)>>2]:a[109132+(((g+e|0)%100|0)<<2)>>2]}while(0);if(f)m=f,f=f+-1|0,k=m;else break}a[27282]=1;e=+ek(+(d+-.473684211),+(b+-.210526316));e=109132+(~~(15.915494277358546*e+50)<<2)|0;e=a[e>>2]|0;u=c;return e|0}function xf(b){b|=0;var d,c,e,f,g;d=u;u=u+32|0;c=d+16|0;e=d+8|0;(f=a[b+576>>2]|0)||Z(154187,146646,1335,147323);-32691!=(w[b+90>>1]|0)&&Z(147339,146646,1336,147323);if(1!=(w[b+126>>1]|0))return Y(a[b+628>>2]|0,147323,147380,d),u=d,0;g=a[f>>2]|0;if(-1==(g|0)){switch(N[b+
84>>1]<<3|N[b+86>>1]|0){case 259:g=0;break;case 258:case 257:case 260:g=2;break;case 129:case 130:case 132:g=1;break;case 65:case 68:g=3;break;default:g=-1}switch(N[b+98>>1]|0){case 1:g=2==(g|0)?2:-1;break;case 3:g=2==(g|0)?-1:g;break;default:g=-1}a[f>>2]=g}switch(g|0){case 0:a[f+8>>2]=12;break;case 1:a[f+8>>2]=6;break;case 2:a[f+8>>2]=4;break;case 3:a[f+8>>2]=3;break;default:return Y(a[b+628>>2]|0,147323,147433,e),u=d,0}g=a[b+12>>2]&1024?E(a[b+72>>2]|0,a[b+68>>2]|0)|0:E(a[b+100>>2]|0,a[b+56>>2]|
0)|0;a[f+16>>2]=g;if(0!=(g|0)&&(e=eb(g<<2)|0,a[f+12>>2]=e,0!=(e|0)))return u=d,1;Y(a[b+628>>2]|0,147323,147254,c);u=d;return 0}function Vf(b){b|=0;var d,c,e,f,g;d=u;u=u+16|0;c=d+8|0;e=d;(f=a[b+576>>2]|0)||Z(154187,146646,1243,147148);-32692!=(w[b+90>>1]|0)&&Z(147164,146646,1244,147148);g=a[f>>2]|0;if(-1==(g|0)){switch(N[b+86>>1]|N[b+84>>1]<<6|N[b+98>>1]<<3|0){case 2059:g=0;break;case 1033:case 1034:case 1036:g=1;break;case 521:case 524:g=3;break;default:g=-1}a[f>>2]=g}switch(g|0){case 0:a[f+8>>2]=
4;break;case 1:a[f+8>>2]=2;break;case 3:a[f+8>>2]=1;break;default:return Y(a[b+628>>2]|0,147148,147203,e),u=d,0}g=a[b+12>>2]&1024?E(a[b+72>>2]|0,a[b+68>>2]|0)|0:E(a[b+100>>2]|0,a[b+56>>2]|0)|0;a[f+16>>2]=g;if(0!=(g|0)&&(e=eb(g<<1)|0,a[f+12>>2]=e,0!=(e|0)))return u=d,1;Y(a[b+628>>2]|0,147148,147254,c);u=d;return 0}function Ig(b){b|=0;var d,c,e,f,g,h,m,k,l,n,p,q,y,B,H,ka;d=u;u=u+64|0;c=d+48|0;e=d+40|0;f=d+32|0;g=d+16|0;h=d+8|0;m=a[b+576>>2]|0;1;k=m+226|0;t[k>>0]|0&&Z(148839,148429,989,148870);a:do if(3==
(w[b+98>>1]|0)){switch(w[b+90>>1]|0){case 10:case 6:break;default:break a}t[k>>0]=1;l=m+228|0;n=t[l>>0]|0;p=m+229|0;q=t[p>>0]|0;y=m+225|0;t[y>>0]=1;Xg(b)|0;B=m+230|0;(H=0==(t[B>>0]|0))?ka=t[l>>0]|0:(t[l>>0]=1,ka=t[p>>0]=1);t[y>>0]=0;y=n&255;n=ka<<24>>24==n<<24>>24&&(t[p>>0]|0)==q<<24>>24?17:13;13==(n|0)&&(H?(n=a[b+628>>2]|0,H=ka&255,ka=x[p>>0]|0,t[m+227>>0]|0?(a[g>>2]=H,a[g+4>>2]=ka,a[g+8>>2]=y,a[g+12>>2]=q&255,Wb(n,148870,149125,g)):(a[h>>2]=H,a[h+4>>2]=ka,Wb(n,148870,148970,h)),n=17):n=18);17==
(n|0)&&0!=(t[B>>0]|0)&&(n=18);if(18==(n|0)&&(H=a[b+628>>2]|0,t[m+227>>0]|0?(a[e>>2]=y,a[e+4>>2]=q&255,Wb(H,148870,149488,e)):Wb(H,148870,149258,f),t[B>>0]|0)){t[k>>0]=1;u=d;return}H=t[l>>0]|0;n=t[p>>0]|0;if((H&255)>=(n&255)){t[k>>0]=1;u=d;return}ka=a[b+628>>2]|0;a[c>>2]=H&255;a[c+4>>2]=n&255;Wb(ka,148870,149696,c);t[k>>0]=1;u=d;return}while(0);t[m+227>>0]|0&&Wb(a[b+628>>2]|0,148870,148894,d);t[m+228>>0]=1;t[m+229>>0]=1;t[m+230>>0]=0;t[k>>0]=1;u=d}function pg(b,d){b|=0;var c,e,f,g,h,m,k,l,n,p,q,y,
B,H,ka,z,Q,C,Ra;c=a[b+124>>2]|0;e=a[b+56>>2]|0;f=a[b+108>>2]|0;g=e+f|0;h=a[b+120>>2]|0;m=a[b+144>>2]|0;k=(a[b+44>>2]|0)+-262|0;l=f>>>0>k>>>0?f-k|0:0;k=a[b+64>>2]|0;n=a[b+52>>2]|0;p=e+(f+258)|0;q=a[b+116>>2]|0;y=m>>>0>q>>>0?q:m;m=b+112|0;B=e+(f+1)|0;H=e+(f+2)|0;ka=f+257|0;z=d|0;d=h;Q=h>>>0<(a[b+140>>2]|0)>>>0?c:c>>>2;c=t[e+(h+f)>>0]|0;for(b=t[e+(f+-1+h)>>0]|0;;){h=e+z|0;if((t[e+(z+d)>>0]|0)==c<<24>>24&&(t[e+(d+-1+z)>>0]|0)==b<<24>>24&&(t[h>>0]|0)==(t[g>>0]|0)&&(t[e+(z+1)>>0]|0)==(t[B>>0]|0)){h=e+(z+
2)|0;for(C=H;;){Ra=C+1|0;if((t[Ra>>0]|0)!=(t[h+1>>0]|0)){C=Ra;break}Ra=C+2|0;if((t[Ra>>0]|0)!=(t[h+2>>0]|0)){C=Ra;break}Ra=C+3|0;if((t[Ra>>0]|0)!=(t[h+3>>0]|0)){C=Ra;break}Ra=C+4|0;if((t[Ra>>0]|0)!=(t[h+4>>0]|0)){C=Ra;break}Ra=C+5|0;if((t[Ra>>0]|0)!=(t[h+5>>0]|0)){C=Ra;break}Ra=C+6|0;if((t[Ra>>0]|0)!=(t[h+6>>0]|0)){C=Ra;break}Ra=C+7|0;if((t[Ra>>0]|0)!=(t[h+7>>0]|0)){C=Ra;break}Ra=C+8|0;h=h+8|0;if(Ra>>>0<p>>>0&&(t[Ra>>0]|0)==(t[h>>0]|0))C=Ra;else{C=Ra;break}}C=C-p|0;h=C+258|0;if((h|0)>(d|0)){a[m>>
2]=z;if((h|0)>=(y|0)){e=h;f=20;break}Ra=h;c=t[e+(h+f)>>0]|0;C=t[e+(ka+C)>>0]|0}else Ra=d,C=b}else Ra=d,C=b;z=N[k+((z&n)<<1)>>1]|0;if(z>>>0<=l>>>0){e=Ra;f=20;break}if(Q=Q+-1|0)d=Ra,b=C;else{e=Ra;f=20;break}}return 20==(f|0)?(e>>>0>q>>>0?q:e)|0:0}function If(b){b|=0;var d,c;if(!b)return-2;d=a[b+28>>2]|0;if(!d)return-2;a[d+40>>2]=0;a[d+44>>2]=0;a[d+48>>2]=0;a[d+28>>2]=0;a[b+20>>2]=0;a[b+8>>2]=0;a[b+24>>2]=0;(c=a[d+8>>2]|0)&&(a[b+48>>2]=c&1);a[d>>2]=0;a[d+4>>2]=0;a[d+12>>2]=0;a[d+20>>2]=32768;a[d+32>>
2]=0;a[d+56>>2]=0;a[d+60>>2]=0;c=d+1328|0;a[d+108>>2]=c;a[d+80>>2]=c;a[d+76>>2]=c;a[d+7104>>2]=1;a[d+7108>>2]=-1;return 0}function Ug(b,d,c){b|=0;d|=0;var e;if(!d||56!=(c|0)|49!=(t[d>>0]|0))return-6;if(!b)return-2;d=b+24|0;a[d>>2]=0;c=b+32|0;(e=a[c>>2]|0)?c=e:(a[c>>2]=29,a[b+40>>2]=0,c=29);e=b+36|0;a[e>>2]|0||(a[e>>2]=6);e=Aa[c&63](a[b+40>>2]|0,1,7116)|0;if(!e)return-4;a[b+28>>2]=e;a[e+52>>2]=0;a[e+8>>2]=1;a[e+36>>2]=15;a[e+40>>2]=0;a[e+44>>2]=0;a[e+48>>2]=0;